{*******************************************************}
{                                                       }
{       Borland Delphi Run-time Library                 }
{       Win32 API Interface Unit                        }
{                                                       }
{       Copyright (c) 1985-1999, Microsoft Corporation  }
{                                                       }
{       Translator: Borland Software Corporation        }
{                                                       }
{*******************************************************}

unit Windows;

{$ALIGN ON}
{$MINENUMSIZE 4}
{$WEAKPACKAGEUNIT}
{$IFDEF LINUX}
{$DEFINE LINUXCRITSECTION}
{$ENDIF}

interface

uses Types{$IFDEF LINUX}, Libc {$ENDIF};

(*$HPPEMIT '// WINVER check BEGIN ' *)
(*$HPPEMIT '#if (WINVER < 0x0400)' *)
(*$HPPEMIT '#error WINVER < 0x0400' *)
(*$HPPEMIT '#endif' *)
(*$HPPEMIT '// WINVER check END. ' *)
(*$HPPEMIT '' *)
(*$HPPEMIT '// WIN2K SDK fixes BEGIN ' *)
(*$HPPEMIT '#ifndef WINTRUST_H' *)
(*$HPPEMIT '#include<wintrust.h>' *)
(*$HPPEMIT '#endif' *)
(*$HPPEMIT '// WIN2K SDK fixes END. ' *)
(*$HPPEMIT '//' *)
(*$HPPEMIT '// WINDOWS provides two definitions of BLOB: wtypes.h defines a' *)
(*$HPPEMIT '// BLOB as a tagBLOB struct whereas nspapi.h defines a BLOB as a _BLOB' *)
(*$HPPEMIT '// struct. Unfortunately, VCL does not use the portable BLOB type but' *)
(*$HPPEMIT '// rather relies on tagBLOB. So here we use a kludge to try to determine' *)
(*$HPPEMIT '// which flavour of BLOB we have (which is determined by the order of header' *)
(*$HPPEMIT '// inclusion by the compilation unit). If it is the _BLOB, we expose the' *)
(*$HPPEMIT '// tagBLOB type for VCL.' *)
(*$HPPEMIT '//' *)
(*$HPPEMIT '#if sizeof(_BLOB) == 8      // We know that BLOB is 8 bytes ' *)
(*$HPPEMIT 'typedef _BLOB tagBLOB;      // If unknown, _BLOB would be 4 ' *)
(*$HPPEMIT '#endif                      // tagBLOB Kludge' *)
(*$HPPEMIT '#if sizeof(tagBLOB) == 4    // tagBLOB has probably not been defined yet' *)
(*$HPPEMIT '#ifndef _tagBLOB_DEFINED' *)
(*$HPPEMIT '#define _tagBLOB_DEFINED' *)
(*$HPPEMIT '#define _BLOB_DEFINED' *)
(*$HPPEMIT '#define _LPBLOB_DEFINED' *)
(*$HPPEMIT 'typedef struct  tagBLOB' *)
(*$HPPEMIT '    {' *)
(*$HPPEMIT '    ULONG cbSize;' *)
(*$HPPEMIT '    /* [size_is] */ BYTE __RPC_FAR *pBlobData;' *)
(*$HPPEMIT '    }       BLOB;' *)
(*$HPPEMIT '' *)
(*$HPPEMIT 'typedef struct tagBLOB __RPC_FAR *LPBLOB;' *)
(*$HPPEMIT '#endif      //      _tagBLOB_DEFINED' *)
(*$HPPEMIT '#endif      //      sizeof(tagBLOB) == 4' *)
(*$HPPEMIT '' *)
(*$HPPEMIT '#if defined(WIN32_LEAN_AND_MEAN) && !defined(_DDEHEADER_INCLUDED_)' *)
(*$HPPEMIT '#include <dde.h>' *)
(*$HPPEMIT '#endif      // WIN32_LEAN_AND_MEAN & _DDEHEADER_INCLUDED_' *)
(*$HPPEMIT '' *)
(*$HPPEMIT 'namespace Windows {'*)
(*$HPPEMIT 'typedef _LARGE_INTEGER TLargeInteger;'*)
(*$HPPEMIT ''*)
(*$HPPEMIT '#if (WINVER >= 0x0500)'*)
(*$HPPEMIT 'typedef BITMAPV5HEADER *PBitmapV5Header;'*)
(*$HPPEMIT 'typedef BITMAPV5HEADER  TBitmapV5Header;'*)
(*$HPPEMIT 'typedef tagEMRGRADIENTFILL *PEMGradientFill;'*)
(*$HPPEMIT 'typedef tagEMRGRADIENTFILL  TEMGradientFill;'*)
(*$HPPEMIT 'typedef tagEMRALPHABLEND *PEMRAlphaBlend;'*)
(*$HPPEMIT 'typedef tagEMRALPHABLEND  TEMRAlphaBlend;'*)
(*$HPPEMIT 'typedef tagEMRTRANSPARENTBLT *PEMRTransparentBLT;'*)
(*$HPPEMIT 'typedef tagEMRTRANSPARENTBLT  TEMRTransparentBLT;'*)
(*$HPPEMIT 'typedef _WGLSWAP *PWGLSwap;'*)
(*$HPPEMIT 'typedef _WGLSWAP  TWGLSwap;'*)
(*$HPPEMIT 'typedef tagMOUSEMOVEPOINT *PMouseMovePoint;'*)
(*$HPPEMIT 'typedef tagMOUSEMOVEPOINT  TMouseMovePoint;'*)
(*$HPPEMIT 'typedef FLASHWINFO  TFlashWInfo;'*)
(*$HPPEMIT 'typedef tagMENUINFO *PMenuInfo;'*)
(*$HPPEMIT 'typedef tagMENUINFO  TMenuInfo;'*)
(*$HPPEMIT 'typedef tagMENUGETOBJECTINFO *PMenuGetObjectInfo;'*)
(*$HPPEMIT 'typedef tagMENUGETOBJECTINFO  TMenuGetObjectInfo;'*)
(*$HPPEMIT 'typedef tagGUITHREADINFO *PGUIThreadInfo;'*)
(*$HPPEMIT 'typedef tagGUITHREADINFO  TGUIThreadInfo;'*)
(*$HPPEMIT 'typedef tagCURSORINFO *PCursorInfo;'*)
(*$HPPEMIT 'typedef tagCURSORINFO  TCursorInfo;'*)
(*$HPPEMIT 'typedef tagWINDOWINFO *PWindowInfo;'*)
(*$HPPEMIT 'typedef tagWINDOWINFO  TWindowInfo;'*)
(*$HPPEMIT 'typedef tagTITLEBARINFO *PTitleBarInfo;'*)
(*$HPPEMIT 'typedef tagTITLEBARINFO  TTitleBarInfo;'*)
(*$HPPEMIT 'typedef tagMENUBARINFO *PMenuBarInfo;'*)
(*$HPPEMIT 'typedef tagMENUBARINFO  TMenuBarInfo;'*)
(*$HPPEMIT 'typedef tagSCROLLBARINFO *PScrollBarInfo;'*)
(*$HPPEMIT 'typedef tagSCROLLBARINFO  TScrollBarInfo;'*)
(*$HPPEMIT 'typedef tagCOMBOBOXINFO *PComboBoxInfo;'*)
(*$HPPEMIT 'typedef tagCOMBOBOXINFO  TComboBoxInfo;'*)
(*$HPPEMIT 'typedef tagALTTABINFO *PAltTabInfo;'*)
(*$HPPEMIT 'typedef tagALTTABINFO  TAltTabInfo;'*)
(*$HPPEMIT '#endif'*)
(*$HPPEMIT ''*)
(*$HPPEMIT '} // namespace Windows'*)
(*$HPPEMIT ''*)

type
{ Translated from WINDEF.H }

  WCHAR = WideChar;
  {$EXTERNALSYM WCHAR}
  PWChar = PWideChar;

  LPSTR = PAnsiChar;
  {$EXTERNALSYM LPSTR}
  PLPSTR = ^LPSTR;
  {$EXTERNALSYM PLPSTR}
  LPCSTR = PAnsiChar;
  {$EXTERNALSYM LPCSTR}
  LPCTSTR = PAnsiChar;
  {$EXTERNALSYM LPCTSTR}
  LPTSTR = PAnsiChar;
  {$EXTERNALSYM LPTSTR}
  LPWSTR = PWideChar;
  {$EXTERNALSYM LPWSTR}
  PLPWSTR = ^LPWSTR;
  {$EXTERNALSYM PLPWSTR}
  LPCWSTR = PWideChar;
  {$EXTERNALSYM LPCWSTR}

  DWORD = Types.DWORD;
  {$EXTERNALSYM DWORD}
  BOOL = LongBool;
  {$EXTERNALSYM BOOL}
  PBOOL = ^BOOL;
  {$EXTERNALSYM PBOOL}
  PByte = Types.PByte;
  PINT = ^Integer;
  {$EXTERNALSYM PINT}
  PSingle = ^Single;
  PWORD = ^Word;
  {$EXTERNALSYM PWORD}
  PDWORD = ^DWORD;
  {$EXTERNALSYM PDWORD}
  LPDWORD = PDWORD;
  {$EXTERNALSYM LPDWORD}

  UCHAR = Byte;
  {$EXTERNALSYM UCHAR}
  PUCHAR = ^Byte;
  {$EXTERNALSYM PUCHAR}
  SHORT = Smallint;
  {$EXTERNALSYM SHORT}
  UINT = LongWord;
  {$EXTERNALSYM UINT}
  PUINT = ^UINT;
  {$EXTERNALSYM PUINT}
  ULONG = Cardinal;
  {$EXTERNALSYM ULONG}
  PULONG = ^ULONG;
  {$EXTERNALSYM PULONG}
  PLongint = System.PLongint;
  {$EXTERNALSYM PLongint}
  PInteger = System.PInteger;
  {$EXTERNALSYM PInteger}
  PLongWord = System.PLongWord;
  {$EXTERNALSYM PLongWord}
  PSmallInt = System.PSmallInt;
  {$EXTERNALSYM PSmallInt}
  PDouble = System.PDouble;
  {$EXTERNALSYM PDouble}
  PShortInt = System.PShortInt;
  {$EXTERNALSYM PShortInt}

  LCID = DWORD;
  {$EXTERNALSYM LCID}
  LANGID = Word;
  {$EXTERNALSYM LANGID}

  THandle = System.THandle;
  PHandle = ^THandle;

const
  MAX_PATH = 260;
  {$EXTERNALSYM MAX_PATH}


{ Translated from WINNT.H (only things needed for API calls) }

{line 190}
type
  LONGLONG = Int64;
  {$EXTERNALSYM LONGLONG}
  PSID = Pointer;
  {$EXTERNALSYM PSID}
  PLargeInteger = ^TLargeInteger;
  _LARGE_INTEGER = record
    case Integer of
    0: (
      LowPart: DWORD;
      HighPart: Longint);
    1: (
      QuadPart: LONGLONG);
  end;
  {$EXTERNALSYM _LARGE_INTEGER}
  {$NODEFINE TLargeInteger}
  TLargeInteger = Int64;
  LARGE_INTEGER = _LARGE_INTEGER;
  {$EXTERNALSYM LARGE_INTEGER}

  ULARGE_INTEGER = record
    case Integer of
    0: (
      LowPart: DWORD;
      HighPart: DWORD);
    1: (
      QuadPart: LONGLONG);
  end;
  {$EXTERNALSYM ULARGE_INTEGER}
  PULargeInteger = ^TULargeInteger;
  TULargeInteger = ULARGE_INTEGER;

{line 450}
  PListEntry = ^TListEntry;
  _LIST_ENTRY = record
    Flink: PListEntry;
    Blink: PListEntry;
  end;
  {$EXTERNALSYM _LIST_ENTRY}
  TListEntry = _LIST_ENTRY;
  LIST_ENTRY = _LIST_ENTRY;
  {$EXTERNALSYM LIST_ENTRY}

{line 490}
const
  MINCHAR = $80;
  {$EXTERNALSYM MINCHAR}
  MAXCHAR = 127;
  {$EXTERNALSYM MAXCHAR}
  MINSHORT = $8000;
  {$EXTERNALSYM MINSHORT}
  MAXSHORT = 32767;
  {$EXTERNALSYM MAXSHORT}
  MINLONG = DWORD($80000000);
  {$EXTERNALSYM MINLONG}
  MAXLONG = $7FFFFFFF;
  {$EXTERNALSYM MAXLONG}
  MAXBYTE = 255;
  {$EXTERNALSYM MAXBYTE}
  MAXWORD = 65535;
  {$EXTERNALSYM MAXWORD}
  MAXDWORD = DWORD($FFFFFFFF);
  {$EXTERNALSYM MAXDWORD}

{line 510}
(*
 *  Language IDs.
 *
 *  The following two combinations of primary language ID and
 *  sublanguage ID have special semantics:
 *
 *    Primary Language ID   Sublanguage ID      Result
 *    -------------------   ---------------     ------------------------
 *    LANG_NEUTRAL          SUBLANG_NEUTRAL     Language neutral
 *    LANG_NEUTRAL          SUBLANG_DEFAULT     User default language
 *    LANG_NEUTRAL          SUBLANG_SYS_DEFAULT System default language
 *)

const
{ Primary language IDs. }

  LANG_NEUTRAL                         = $00;
  {$EXTERNALSYM LANG_NEUTRAL}

  LANG_AFRIKAANS                       = $36;
  {$EXTERNALSYM LANG_AFRIKAANS}
  LANG_ALBANIAN                        = $1c;
  {$EXTERNALSYM LANG_ALBANIAN}
  LANG_ARABIC                          = $01;
  {$EXTERNALSYM LANG_ARABIC}
  LANG_BASQUE                          = $2d;
  {$EXTERNALSYM LANG_BASQUE}
  LANG_BELARUSIAN                      = $23;
  {$EXTERNALSYM LANG_BELARUSIAN}
  LANG_BULGARIAN                       = $02;
  {$EXTERNALSYM LANG_BULGARIAN}
  LANG_CATALAN                         = $03;
  {$EXTERNALSYM LANG_CATALAN}
  LANG_CHINESE                         = $04;
  {$EXTERNALSYM LANG_CHINESE}
  LANG_CROATIAN                        = $1a;
  {$EXTERNALSYM LANG_CROATIAN}
  LANG_CZECH                           = $05;
  {$EXTERNALSYM LANG_CZECH}
  LANG_DANISH                          = $06;
  {$EXTERNALSYM LANG_DANISH}
  LANG_DUTCH                           = $13;
  {$EXTERNALSYM LANG_DUTCH}
  LANG_ENGLISH                         = $09;
  {$EXTERNALSYM LANG_ENGLISH}
  LANG_ESTONIAN                        = $25;
  {$EXTERNALSYM LANG_ESTONIAN}
  LANG_FAEROESE                        = $38;
  {$EXTERNALSYM LANG_FAEROESE}
  LANG_FARSI                           = $29;
  {$EXTERNALSYM LANG_FARSI}
  LANG_FINNISH                         = $0b;
  {$EXTERNALSYM LANG_FINNISH}
  LANG_FRENCH                          = $0c;
  {$EXTERNALSYM LANG_FRENCH}
  LANG_GERMAN                          = $07;
  {$EXTERNALSYM LANG_GERMAN}
  LANG_GREEK                           = $08;
  {$EXTERNALSYM LANG_GREEK}
  LANG_HEBREW                          = $0d;
  {$EXTERNALSYM LANG_HEBREW}
  LANG_HUNGARIAN                       = $0e;
  {$EXTERNALSYM LANG_HUNGARIAN}
  LANG_ICELANDIC                       = $0f;
  {$EXTERNALSYM LANG_ICELANDIC}
  LANG_INDONESIAN                      = $21;
  {$EXTERNALSYM LANG_INDONESIAN}
  LANG_ITALIAN                         = $10;
  {$EXTERNALSYM LANG_ITALIAN}
  LANG_JAPANESE                        = $11;
  {$EXTERNALSYM LANG_JAPANESE}
  LANG_KOREAN                          = $12;
  {$EXTERNALSYM LANG_KOREAN}
  LANG_LATVIAN                         = $26;
  {$EXTERNALSYM LANG_LATVIAN}
  LANG_LITHUANIAN                      = $27;
  {$EXTERNALSYM LANG_LITHUANIAN}
  LANG_NORWEGIAN                       = $14;
  {$EXTERNALSYM LANG_NORWEGIAN}
  LANG_POLISH                          = $15;
  {$EXTERNALSYM LANG_POLISH}
  LANG_PORTUGUESE                      = $16;
  {$EXTERNALSYM LANG_PORTUGUESE}
  LANG_ROMANIAN                        = $18;
  {$EXTERNALSYM LANG_ROMANIAN}
  LANG_RUSSIAN                         = $19;
  {$EXTERNALSYM LANG_RUSSIAN}
  LANG_SERBIAN                         = $1a;
  {$EXTERNALSYM LANG_SERBIAN}
  LANG_SLOVAK                          = $1b;
  {$EXTERNALSYM LANG_SLOVAK}
  LANG_SLOVENIAN                       = $24;
  {$EXTERNALSYM LANG_SLOVENIAN}
  LANG_SPANISH                         = $0a;
  {$EXTERNALSYM LANG_SPANISH}
  LANG_SWEDISH                         = $1d;
  {$EXTERNALSYM LANG_SWEDISH}
  LANG_THAI                            = $1e;
  {$EXTERNALSYM LANG_THAI}
  LANG_TURKISH                         = $1f;
  {$EXTERNALSYM LANG_TURKISH}
  LANG_UKRAINIAN                       = $22;
  {$EXTERNALSYM LANG_UKRAINIAN}
  LANG_VIETNAMESE                      = $2a;
  {$EXTERNALSYM LANG_VIETNAMESE}


{ Sublanguage IDs. }

  { The name immediately following SUBLANG_ dictates which primary
    language ID that sublanguage ID can be combined with to form a
    valid language ID. }

  SUBLANG_NEUTRAL                      = $00;    { language neutral }
  {$EXTERNALSYM SUBLANG_NEUTRAL}
  SUBLANG_DEFAULT                      = $01;    { user default }
  {$EXTERNALSYM SUBLANG_DEFAULT}
  SUBLANG_SYS_DEFAULT                  = $02;    { system default }
  {$EXTERNALSYM SUBLANG_SYS_DEFAULT}

  SUBLANG_ARABIC_SAUDI_ARABIA          = $01;    { Arabic (Saudi Arabia) }
  {$EXTERNALSYM SUBLANG_ARABIC_SAUDI_ARABIA}
  SUBLANG_ARABIC_IRAQ                  = $02;    { Arabic (Iraq) }
  {$EXTERNALSYM SUBLANG_ARABIC_IRAQ}
  SUBLANG_ARABIC_EGYPT                 = $03;    { Arabic (Egypt) }
  {$EXTERNALSYM SUBLANG_ARABIC_EGYPT}
  SUBLANG_ARABIC_LIBYA                 = $04;    { Arabic (Libya) }
  {$EXTERNALSYM SUBLANG_ARABIC_LIBYA}
  SUBLANG_ARABIC_ALGERIA               = $05;    { Arabic (Algeria) }
  {$EXTERNALSYM SUBLANG_ARABIC_ALGERIA}
  SUBLANG_ARABIC_MOROCCO               = $06;    { Arabic (Morocco) }
  {$EXTERNALSYM SUBLANG_ARABIC_MOROCCO}
  SUBLANG_ARABIC_TUNISIA               = $07;    { Arabic (Tunisia) }
  {$EXTERNALSYM SUBLANG_ARABIC_TUNISIA}
  SUBLANG_ARABIC_OMAN                  = $08;    { Arabic (Oman) }
  {$EXTERNALSYM SUBLANG_ARABIC_OMAN}
  SUBLANG_ARABIC_YEMEN                 = $09;    { Arabic (Yemen) }
  {$EXTERNALSYM SUBLANG_ARABIC_YEMEN}
  SUBLANG_ARABIC_SYRIA                 = $0a;    { Arabic (Syria) }
  {$EXTERNALSYM SUBLANG_ARABIC_SYRIA}
  SUBLANG_ARABIC_JORDAN                = $0b;    { Arabic (Jordan) }
  {$EXTERNALSYM SUBLANG_ARABIC_JORDAN}
  SUBLANG_ARABIC_LEBANON               = $0c;    { Arabic (Lebanon) }
  {$EXTERNALSYM SUBLANG_ARABIC_LEBANON}
  SUBLANG_ARABIC_KUWAIT                = $0d;    { Arabic (Kuwait) }
  {$EXTERNALSYM SUBLANG_ARABIC_KUWAIT}
  SUBLANG_ARABIC_UAE                   = $0e;    { Arabic (U.A.E) }
  {$EXTERNALSYM SUBLANG_ARABIC_UAE}
  SUBLANG_ARABIC_BAHRAIN               = $0f;    { Arabic (Bahrain) }
  {$EXTERNALSYM SUBLANG_ARABIC_BAHRAIN}
  SUBLANG_ARABIC_QATAR                 = $10;    { Arabic (Qatar) }
  {$EXTERNALSYM SUBLANG_ARABIC_QATAR}
  SUBLANG_CHINESE_TRADITIONAL          = $01;    { Chinese (Taiwan) }
  {$EXTERNALSYM SUBLANG_CHINESE_TRADITIONAL}
  SUBLANG_CHINESE_SIMPLIFIED           = $02;    { Chinese (PR China) }
  {$EXTERNALSYM SUBLANG_CHINESE_SIMPLIFIED}
  SUBLANG_CHINESE_HONGKONG             = $03;    { Chinese (Hong Kong) }
  {$EXTERNALSYM SUBLANG_CHINESE_HONGKONG}
  SUBLANG_CHINESE_SINGAPORE            = $04;    { Chinese (Singapore) }
  {$EXTERNALSYM SUBLANG_CHINESE_SINGAPORE}
  SUBLANG_DUTCH                        = $01;    { Dutch }
  {$EXTERNALSYM SUBLANG_DUTCH}
  SUBLANG_DUTCH_BELGIAN                = $02;    { Dutch (Belgian) }
  {$EXTERNALSYM SUBLANG_DUTCH_BELGIAN}
  SUBLANG_ENGLISH_US                   = $01;    { English (USA) }
  {$EXTERNALSYM SUBLANG_ENGLISH_US}
  SUBLANG_ENGLISH_UK                   = $02;    { English (UK) }
  {$EXTERNALSYM SUBLANG_ENGLISH_UK}
  SUBLANG_ENGLISH_AUS                  = $03;    { English (Australian) }
  {$EXTERNALSYM SUBLANG_ENGLISH_AUS}
  SUBLANG_ENGLISH_CAN                  = $04;    { English (Canadian) }
  {$EXTERNALSYM SUBLANG_ENGLISH_CAN}
  SUBLANG_ENGLISH_NZ                   = $05;    { English (New Zealand) }
  {$EXTERNALSYM SUBLANG_ENGLISH_NZ}
  SUBLANG_ENGLISH_EIRE                 = $06;    { English (Irish) }
  {$EXTERNALSYM SUBLANG_ENGLISH_EIRE}
  SUBLANG_ENGLISH_SOUTH_AFRICA         = $07;    { English (South Africa) }
  {$EXTERNALSYM SUBLANG_ENGLISH_SOUTH_AFRICA}
  SUBLANG_ENGLISH_JAMAICA              = $08;    { English (Jamaica) }
  {$EXTERNALSYM SUBLANG_ENGLISH_JAMAICA}
  SUBLANG_ENGLISH_CARIBBEAN            = $09;    { English (Caribbean) }
  {$EXTERNALSYM SUBLANG_ENGLISH_CARIBBEAN}
  SUBLANG_ENGLISH_BELIZE               = $0a;    { English (Belize) }
  {$EXTERNALSYM SUBLANG_ENGLISH_BELIZE}
  SUBLANG_ENGLISH_TRINIDAD             = $0b;    { English (Trinidad) }
  {$EXTERNALSYM SUBLANG_ENGLISH_TRINIDAD}
  SUBLANG_FRENCH                       = $01;    { French }
  {$EXTERNALSYM SUBLANG_FRENCH}
  SUBLANG_FRENCH_BELGIAN               = $02;    { French (Belgian) }
  {$EXTERNALSYM SUBLANG_FRENCH_BELGIAN}
  SUBLANG_FRENCH_CANADIAN              = $03;    { French (Canadian) }
  {$EXTERNALSYM SUBLANG_FRENCH_CANADIAN}
  SUBLANG_FRENCH_SWISS                 = $04;    { French (Swiss) }
  {$EXTERNALSYM SUBLANG_FRENCH_SWISS}
  SUBLANG_FRENCH_LUXEMBOURG            = $05;    { French (Luxembourg) }
  {$EXTERNALSYM SUBLANG_FRENCH_LUXEMBOURG}
  SUBLANG_GERMAN                       = $01;    { German }
  {$EXTERNALSYM SUBLANG_GERMAN}
  SUBLANG_GERMAN_SWISS                 = $02;    { German (Swiss) }
  {$EXTERNALSYM SUBLANG_GERMAN_SWISS}
  SUBLANG_GERMAN_AUSTRIAN              = $03;    { German (Austrian) }
  {$EXTERNALSYM SUBLANG_GERMAN_AUSTRIAN}
  SUBLANG_GERMAN_LUXEMBOURG            = $04;    { German (Luxembourg) }
  {$EXTERNALSYM SUBLANG_GERMAN_LUXEMBOURG}
  SUBLANG_GERMAN_LIECHTENSTEIN         = $05;    { German (Liechtenstein) }
  {$EXTERNALSYM SUBLANG_GERMAN_LIECHTENSTEIN}
  SUBLANG_ITALIAN                      = $01;    { Italian }
  {$EXTERNALSYM SUBLANG_ITALIAN}
  SUBLANG_ITALIAN_SWISS                = $02;    { Italian (Swiss) }
  {$EXTERNALSYM SUBLANG_ITALIAN_SWISS}
  SUBLANG_KOREAN                       = $01;    { Korean (Extended Wansung) }
  {$EXTERNALSYM SUBLANG_KOREAN}
  SUBLANG_KOREAN_JOHAB                 = $02;    { Korean (Johab) }
  {$EXTERNALSYM SUBLANG_KOREAN_JOHAB}
  SUBLANG_NORWEGIAN_BOKMAL             = $01;    { Norwegian (Bokmal) }
  {$EXTERNALSYM SUBLANG_NORWEGIAN_BOKMAL}
  SUBLANG_NORWEGIAN_NYNORSK            = $02;    { Norwegian (Nynorsk) }
  {$EXTERNALSYM SUBLANG_NORWEGIAN_NYNORSK}
  SUBLANG_PORTUGUESE                   = $02;    { Portuguese }
  {$EXTERNALSYM SUBLANG_PORTUGUESE}
  SUBLANG_PORTUGUESE_BRAZILIAN         = $01;    { Portuguese (Brazilian) }
  {$EXTERNALSYM SUBLANG_PORTUGUESE_BRAZILIAN}
  SUBLANG_SERBIAN_LATIN                = $02;    { Serbian (Latin) }
  {$EXTERNALSYM SUBLANG_SERBIAN_LATIN}
  SUBLANG_SERBIAN_CYRILLIC             = $03;    { Serbian (Cyrillic) }
  {$EXTERNALSYM SUBLANG_SERBIAN_CYRILLIC}
  SUBLANG_SPANISH                      = $01;    { Spanish (Castilian) }
  {$EXTERNALSYM SUBLANG_SPANISH}
  SUBLANG_SPANISH_MEXICAN              = $02;    { Spanish (Mexican) }
  {$EXTERNALSYM SUBLANG_SPANISH_MEXICAN}
  SUBLANG_SPANISH_MODERN               = $03;    { Spanish (Modern) }
  {$EXTERNALSYM SUBLANG_SPANISH_MODERN}
  SUBLANG_SPANISH_GUATEMALA            = $04;    { Spanish (Guatemala) }
  {$EXTERNALSYM SUBLANG_SPANISH_GUATEMALA}
  SUBLANG_SPANISH_COSTA_RICA           = $05;    { Spanish (Costa Rica) }
  {$EXTERNALSYM SUBLANG_SPANISH_COSTA_RICA}
  SUBLANG_SPANISH_PANAMA               = $06;    { Spanish (Panama) }
  {$EXTERNALSYM SUBLANG_SPANISH_PANAMA}
  SUBLANG_SPANISH_DOMINICAN_REPUBLIC     = $07;  { Spanish (Dominican Republic) }
  {$EXTERNALSYM SUBLANG_SPANISH_DOMINICAN_REPUBLIC}
  SUBLANG_SPANISH_VENEZUELA            = $08;    { Spanish (Venezuela) }
  {$EXTERNALSYM SUBLANG_SPANISH_VENEZUELA}
  SUBLANG_SPANISH_COLOMBIA             = $09;    { Spanish (Colombia) }
  {$EXTERNALSYM SUBLANG_SPANISH_COLOMBIA}
  SUBLANG_SPANISH_PERU                 = $0a;    { Spanish (Peru) }
  {$EXTERNALSYM SUBLANG_SPANISH_PERU}
  SUBLANG_SPANISH_ARGENTINA            = $0b;    { Spanish (Argentina) }
  {$EXTERNALSYM SUBLANG_SPANISH_ARGENTINA}
  SUBLANG_SPANISH_ECUADOR              = $0c;    { Spanish (Ecuador) }
  {$EXTERNALSYM SUBLANG_SPANISH_ECUADOR}
  SUBLANG_SPANISH_CHILE                = $0d;    { Spanish (Chile) }
  {$EXTERNALSYM SUBLANG_SPANISH_CHILE}
  SUBLANG_SPANISH_URUGUAY              = $0e;    { Spanish (Uruguay) }
  {$EXTERNALSYM SUBLANG_SPANISH_URUGUAY}
  SUBLANG_SPANISH_PARAGUAY             = $0f;    { Spanish (Paraguay) }
  {$EXTERNALSYM SUBLANG_SPANISH_PARAGUAY}
  SUBLANG_SPANISH_BOLIVIA              = $10;    { Spanish (Bolivia) }
  {$EXTERNALSYM SUBLANG_SPANISH_BOLIVIA}
  SUBLANG_SPANISH_EL_SALVADOR          = $11;    { Spanish (El Salvador) }
  {$EXTERNALSYM SUBLANG_SPANISH_EL_SALVADOR}
  SUBLANG_SPANISH_HONDURAS             = $12;    { Spanish (Honduras) }
  {$EXTERNALSYM SUBLANG_SPANISH_HONDURAS}
  SUBLANG_SPANISH_NICARAGUA            = $13;    { Spanish (Nicaragua) }
  {$EXTERNALSYM SUBLANG_SPANISH_NICARAGUA}
  SUBLANG_SPANISH_PUERTO_RICO          = $14;    { Spanish (Puerto Rico) }
  {$EXTERNALSYM SUBLANG_SPANISH_PUERTO_RICO}
  SUBLANG_SWEDISH                      = $01;    { Swedish }
  {$EXTERNALSYM SUBLANG_SWEDISH}
  SUBLANG_SWEDISH_FINLAND              = $02;    { Swedish (Finland) }
  {$EXTERNALSYM SUBLANG_SWEDISH_FINLAND}


{ Sorting IDs. }

  SORT_DEFAULT                         = $0;     { sorting default }
  {$EXTERNALSYM SORT_DEFAULT}

  SORT_JAPANESE_XJIS                   = $0;     { Japanese XJIS order }
  {$EXTERNALSYM SORT_JAPANESE_XJIS}
  SORT_JAPANESE_UNICODE                = $1;     { Japanese Unicode order }
  {$EXTERNALSYM SORT_JAPANESE_UNICODE}

  SORT_CHINESE_BIG5                    = $0;     { Chinese BIG5 order }
  {$EXTERNALSYM SORT_CHINESE_BIG5}
  SORT_CHINESE_PRCP                    = $0;     { PRC Chinese Phonetic order }
  {$EXTERNALSYM SORT_CHINESE_PRCP}
  SORT_CHINESE_UNICODE                 = $1;     { Chinese Unicode order }
  {$EXTERNALSYM SORT_CHINESE_UNICODE}
  SORT_CHINESE_PRC                     = $2;     { PRC Chinese Stroke Count order }
  {$EXTERNALSYM SORT_CHINESE_PRC}

  SORT_KOREAN_KSC                      = $0;     { Korean KSC order }
  {$EXTERNALSYM SORT_KOREAN_KSC}
  SORT_KOREAN_UNICODE                  = $1;     { Korean Unicode order }
  {$EXTERNALSYM SORT_KOREAN_UNICODE}

  SORT_GERMAN_PHONE_BOOK               = $1;     { German Phone Book order }
  {$EXTERNALSYM SORT_GERMAN_PHONE_BOOK}


(*
 *  A language ID is a 16 bit value which is the combination of a
 *  primary language ID and a secondary language ID.  The bits are
 *  allocated as follows:
 *
 *       +-----------------------+-------------------------+
 *       |     Sublanguage ID    |   Primary Language ID   |
 *       +-----------------------+-------------------------+
 *        15                   10 9                       0   bit
 *
 *
 *
 *  A locale ID is a 32 bit value which is the combination of a
 *  language ID, a sort ID, and a reserved area.  The bits are
 *  allocated as follows:
 *
 *       +-------------+---------+-------------------------+
 *       |   Reserved  | Sort ID |      Language ID        |
 *       +-------------+---------+-------------------------+
 *        31         20 19     16 15                      0   bit
 *
 *)

{ Default System and User IDs for language and locale. }

  LANG_SYSTEM_DEFAULT   = (SUBLANG_SYS_DEFAULT shl 10) or LANG_NEUTRAL;
  {$EXTERNALSYM LANG_SYSTEM_DEFAULT}
  LANG_USER_DEFAULT     = (SUBLANG_DEFAULT shl 10) or LANG_NEUTRAL;
  {$EXTERNALSYM LANG_USER_DEFAULT}

  LOCALE_SYSTEM_DEFAULT = (SORT_DEFAULT shl 16) or LANG_SYSTEM_DEFAULT;
  {$EXTERNALSYM LOCALE_SYSTEM_DEFAULT}
  LOCALE_USER_DEFAULT   = (SORT_DEFAULT shl 16) or LANG_USER_DEFAULT;
  {$EXTERNALSYM LOCALE_USER_DEFAULT}


{line 724}
  STATUS_WAIT_0                   = $00000000;
  {$EXTERNALSYM STATUS_WAIT_0}
  STATUS_ABANDONED_WAIT_0         = $00000080;
  {$EXTERNALSYM STATUS_ABANDONED_WAIT_0}
  STATUS_USER_APC                 = $000000C0;
  {$EXTERNALSYM STATUS_USER_APC}
  STATUS_TIMEOUT                  = $00000102;
  {$EXTERNALSYM STATUS_TIMEOUT}
  STATUS_PENDING                  = $00000103;
  {$EXTERNALSYM STATUS_PENDING}
  STATUS_SEGMENT_NOTIFICATION     = $40000005;
  {$EXTERNALSYM STATUS_SEGMENT_NOTIFICATION}
  STATUS_GUARD_PAGE_VIOLATION     = DWORD($80000001);
  {$EXTERNALSYM STATUS_GUARD_PAGE_VIOLATION}
  STATUS_DATATYPE_MISALIGNMENT    = DWORD($80000002);
  {$EXTERNALSYM STATUS_DATATYPE_MISALIGNMENT}
  STATUS_BREAKPOINT               = DWORD($80000003);
  {$EXTERNALSYM STATUS_BREAKPOINT}
  STATUS_SINGLE_STEP              = DWORD($80000004);
  {$EXTERNALSYM STATUS_SINGLE_STEP}
  STATUS_ACCESS_VIOLATION         = DWORD($C0000005);
  {$EXTERNALSYM STATUS_ACCESS_VIOLATION}
  STATUS_IN_PAGE_ERROR            = DWORD($C0000006);
  {$EXTERNALSYM STATUS_IN_PAGE_ERROR}
  STATUS_INVALID_HANDLE           = DWORD($C0000008);
  {$EXTERNALSYM STATUS_INVALID_HANDLE}
  STATUS_NO_MEMORY                = DWORD($C0000017);
  {$EXTERNALSYM STATUS_NO_MEMORY}
  STATUS_ILLEGAL_INSTRUCTION      = DWORD($C000001D);
  {$EXTERNALSYM STATUS_ILLEGAL_INSTRUCTION}
  STATUS_NONCONTINUABLE_EXCEPTION = DWORD($C0000025);
  {$EXTERNALSYM STATUS_NONCONTINUABLE_EXCEPTION}
  STATUS_INVALID_DISPOSITION      = DWORD($C0000026);
  {$EXTERNALSYM STATUS_INVALID_DISPOSITION}
  STATUS_ARRAY_BOUNDS_EXCEEDED    = DWORD($C000008C);
  {$EXTERNALSYM STATUS_ARRAY_BOUNDS_EXCEEDED}
  STATUS_FLOAT_DENORMAL_OPERAND   = DWORD($C000008D);
  {$EXTERNALSYM STATUS_FLOAT_DENORMAL_OPERAND}
  STATUS_FLOAT_DIVIDE_BY_ZERO     = DWORD($C000008E);
  {$EXTERNALSYM STATUS_FLOAT_DIVIDE_BY_ZERO}
  STATUS_FLOAT_INEXACT_RESULT     = DWORD($C000008F);
  {$EXTERNALSYM STATUS_FLOAT_INEXACT_RESULT}
  STATUS_FLOAT_INVALID_OPERATION  = DWORD($C0000090);
  {$EXTERNALSYM STATUS_FLOAT_INVALID_OPERATION}
  STATUS_FLOAT_OVERFLOW           = DWORD($C0000091);
  {$EXTERNALSYM STATUS_FLOAT_OVERFLOW}
  STATUS_FLOAT_STACK_CHECK        = DWORD($C0000092);
  {$EXTERNALSYM STATUS_FLOAT_STACK_CHECK}
  STATUS_FLOAT_UNDERFLOW          = DWORD($C0000093);
  {$EXTERNALSYM STATUS_FLOAT_UNDERFLOW}
  STATUS_INTEGER_DIVIDE_BY_ZERO   = DWORD($C0000094);
  {$EXTERNALSYM STATUS_INTEGER_DIVIDE_BY_ZERO}
  STATUS_INTEGER_OVERFLOW         = DWORD($C0000095);
  {$EXTERNALSYM STATUS_INTEGER_OVERFLOW}
  STATUS_PRIVILEGED_INSTRUCTION   = DWORD($C0000096);
  {$EXTERNALSYM STATUS_PRIVILEGED_INSTRUCTION}
  STATUS_STACK_OVERFLOW           = DWORD($C00000FD);
  {$EXTERNALSYM STATUS_STACK_OVERFLOW}
  STATUS_CONTROL_C_EXIT           = DWORD($C000013A);
  {$EXTERNALSYM STATUS_CONTROL_C_EXIT}

  MAXIMUM_WAIT_OBJECTS = 64;
  {$EXTERNALSYM MAXIMUM_WAIT_OBJECTS}

{line 1280}
  SIZE_OF_80387_REGISTERS = 80;
  {$EXTERNALSYM SIZE_OF_80387_REGISTERS}

  { The following flags control the contents of the CONTEXT structure. }

  CONTEXT_i386 = $10000;     { this assumes that i386 and }
  {$EXTERNALSYM CONTEXT_i386}
  CONTEXT_i486 = $10000;     { i486 have identical context records }
  {$EXTERNALSYM CONTEXT_i486}

  CONTEXT_CONTROL         = (CONTEXT_i386 or $00000001); { SS:SP, CS:IP, FLAGS, BP }
  {$EXTERNALSYM CONTEXT_CONTROL}
  CONTEXT_INTEGER         = (CONTEXT_i386 or $00000002); { AX, BX, CX, DX, SI, DI }
  {$EXTERNALSYM CONTEXT_INTEGER}
  CONTEXT_SEGMENTS        = (CONTEXT_i386 or $00000004); { DS, ES, FS, GS }
  {$EXTERNALSYM CONTEXT_SEGMENTS}
  CONTEXT_FLOATING_POINT  = (CONTEXT_i386 or $00000008); { 387 state }
  {$EXTERNALSYM CONTEXT_FLOATING_POINT}
  CONTEXT_DEBUG_REGISTERS = (CONTEXT_i386 or $00000010); { DB 0-3,6,7 }
  {$EXTERNALSYM CONTEXT_DEBUG_REGISTERS}
  CONTEXT_FULL = (CONTEXT_CONTROL or CONTEXT_INTEGER or CONTEXT_SEGMENTS);
  {$EXTERNALSYM CONTEXT_FULL}

type
  PFloatingSaveArea = ^TFloatingSaveArea;
  _FLOATING_SAVE_AREA = record
    ControlWord: DWORD;
    StatusWord: DWORD;
    TagWord: DWORD;
    ErrorOffset: DWORD;
    ErrorSelector: DWORD;
    DataOffset: DWORD;
    DataSelector: DWORD;
    RegisterArea: array[0..SIZE_OF_80387_REGISTERS - 1] of Byte;
    Cr0NpxState: DWORD;
  end;
  {$EXTERNALSYM _FLOATING_SAVE_AREA}
  TFloatingSaveArea = _FLOATING_SAVE_AREA;
  FLOATING_SAVE_AREA = _FLOATING_SAVE_AREA;
  {$EXTERNALSYM FLOATING_SAVE_AREA}

{ This frame has a several purposes: 1) it is used as an argument to
  NtContinue, 2) is is used to constuct a call frame for APC delivery,
  and 3) it is used in the user level thread creation routines.
  The layout of the record conforms to a standard call frame. }

  PContext = ^TContext;
  _CONTEXT = record
  {$EXTERNALSYM _CONTEXT}

  { The flags values within this flag control the contents of
    a CONTEXT record.

    If the context record is used as an input parameter, then
    for each portion of the context record controlled by a flag
    whose value is set, it is assumed that that portion of the
    context record contains valid context. If the context record
    is being used to modify a threads context, then only that
    portion of the threads context will be modified.

    If the context record is used as an IN OUT parameter to capture
    the context of a thread, then only those portions of the thread's
    context corresponding to set flags will be returned.

    The context record is never used as an OUT only parameter. }

    ContextFlags: DWORD;

  { This section is specified/returned if CONTEXT_DEBUG_REGISTERS is
    set in ContextFlags.  Note that CONTEXT_DEBUG_REGISTERS is NOT
    included in CONTEXT_FULL. }

    Dr0: DWORD;
    Dr1: DWORD;
    Dr2: DWORD;
    Dr3: DWORD;
    Dr6: DWORD;
    Dr7: DWORD;

  { This section is specified/returned if the
    ContextFlags word contians the flag CONTEXT_FLOATING_POINT. }

    FloatSave: TFloatingSaveArea;

  { This section is specified/returned if the
    ContextFlags word contians the flag CONTEXT_SEGMENTS. }

    SegGs: DWORD;
    SegFs: DWORD;
    SegEs: DWORD;
    SegDs: DWORD;

  { This section is specified/returned if the
    ContextFlags word contians the flag CONTEXT_INTEGER. }

    Edi: DWORD;
    Esi: DWORD;
    Ebx: DWORD;
    Edx: DWORD;
    Ecx: DWORD;
    Eax: DWORD;

  { This section is specified/returned if the
    ContextFlags word contians the flag CONTEXT_CONTROL. }

    Ebp: DWORD;
    Eip: DWORD;
    SegCs: DWORD;
    EFlags: DWORD;
    Esp: DWORD;
    SegSs: DWORD;
  end;
  TContext = _CONTEXT;
  CONTEXT = _CONTEXT;
  {$EXTERNALSYM CONTEXT}

const
  { bitfield constants for Flags field of TLDTEntry }

  LDTF_BASEMID      = DWORD($FF000000);  {8}
  LDTF_TYPE_8       = $00F80000;  {5}
  LDTF_DPL          = $00060000;  {2}
  LDTF_PRES         = $00010000;  {1}
  LDTF_LIMITHI      = $0000F000;  {4}
  LDTF_SYS          = $00000800;  {1}
  LDTF_RESERVED_0   = $00000400;  {1}
  LDTF_DEFAULT_BIG  = $00000200;  {1}
  LDTF_GRANULARITY  = $00000100;  {1}
  LDTF_BASEHI       = $000000FF;  {8}


type
  PLDTEntry = ^TLDTEntry;
  _LDT_ENTRY = record
    LimitLow: Word;
    BaseLow: Word;
    case Integer of
      0: (
        BaseMid: Byte;
        Flags1: Byte;
        Flags2: Byte;
        BaseHi: Byte);
      1: (
        Flags: Longint);
  end;
  {$EXTERNALSYM _LDT_ENTRY}
  TLDTEntry = _LDT_ENTRY;
  LDT_ENTRY = _LDT_ENTRY;
  {$EXTERNALSYM LDT_ENTRY}

{line 2030}
const
  EXCEPTION_NONCONTINUABLE     = 1;    { Noncontinuable exception }
  {$EXTERNALSYM EXCEPTION_NONCONTINUABLE}
  EXCEPTION_MAXIMUM_PARAMETERS = 15;   { maximum number of exception parameters }
  {$EXTERNALSYM EXCEPTION_MAXIMUM_PARAMETERS}

type
  PExceptionRecord = ^TExceptionRecord;
  _EXCEPTION_RECORD = record
    ExceptionCode: DWORD;
    ExceptionFlags: DWORD;
    ExceptionRecord: PExceptionRecord;
    ExceptionAddress: Pointer;
    NumberParameters: DWORD;
    ExceptionInformation: array[0..EXCEPTION_MAXIMUM_PARAMETERS - 1] of DWORD;
  end;
  {$EXTERNALSYM _EXCEPTION_RECORD}
  TExceptionRecord = _EXCEPTION_RECORD;
  EXCEPTION_RECORD = _EXCEPTION_RECORD;
  {$EXTERNALSYM EXCEPTION_RECORD}

{ Typedef for pointer returned by exception_info() }

  _EXCEPTION_POINTERS = record
    ExceptionRecord : PExceptionRecord;
    ContextRecord : PContext;
  end;
  {$EXTERNALSYM _EXCEPTION_POINTERS}
  TExceptionPointers = _EXCEPTION_POINTERS;
  EXCEPTION_POINTERS = _EXCEPTION_POINTERS;
  {$EXTERNALSYM EXCEPTION_POINTERS}

{line 2100}
const
  THREAD_BASE_PRIORITY_LOWRT = 15;  { value that gets a thread to LowRealtime-1 }
  {$EXTERNALSYM THREAD_BASE_PRIORITY_LOWRT}
  THREAD_BASE_PRIORITY_MAX = 2;     { maximum thread base priority boost }
  {$EXTERNALSYM THREAD_BASE_PRIORITY_MAX}
  THREAD_BASE_PRIORITY_MIN = -2;    { minimum thread base priority boost }
  {$EXTERNALSYM THREAD_BASE_PRIORITY_MIN}
  THREAD_BASE_PRIORITY_IDLE = -15;  { value that gets a thread to idle }
  {$EXTERNALSYM THREAD_BASE_PRIORITY_IDLE}

  SYNCHRONIZE = $00100000;
  {$EXTERNALSYM SYNCHRONIZE}
  STANDARD_RIGHTS_REQUIRED = $000F0000;
  {$EXTERNALSYM STANDARD_RIGHTS_REQUIRED}
  EVENT_MODIFY_STATE = $0002;
  {$EXTERNALSYM EVENT_MODIFY_STATE}
  EVENT_ALL_ACCESS = (STANDARD_RIGHTS_REQUIRED or SYNCHRONIZE or $3);
  {$EXTERNALSYM EVENT_ALL_ACCESS}
  MUTANT_QUERY_STATE = $0001;
  {$EXTERNALSYM MUTANT_QUERY_STATE}
  MUTANT_ALL_ACCESS = (STANDARD_RIGHTS_REQUIRED or SYNCHRONIZE or MUTANT_QUERY_STATE);
  {$EXTERNALSYM MUTANT_ALL_ACCESS}

  SEMAPHORE_MODIFY_STATE  = $0002;
  {$EXTERNALSYM SEMAPHORE_MODIFY_STATE}
  SEMAPHORE_ALL_ACCESS = (STANDARD_RIGHTS_REQUIRED or SYNCHRONIZE or $3);
  {$EXTERNALSYM SEMAPHORE_ALL_ACCESS}

  PROCESS_TERMINATE         = $0001;
  {$EXTERNALSYM PROCESS_TERMINATE}
  PROCESS_CREATE_THREAD     = $0002;
  {$EXTERNALSYM PROCESS_CREATE_THREAD}
  PROCESS_VM_OPERATION      = $0008;
  {$EXTERNALSYM PROCESS_VM_OPERATION}
  PROCESS_VM_READ           = $0010;
  {$EXTERNALSYM PROCESS_VM_READ}
  PROCESS_VM_WRITE          = $0020;
  {$EXTERNALSYM PROCESS_VM_WRITE}
  PROCESS_DUP_HANDLE        = $0040;
  {$EXTERNALSYM PROCESS_DUP_HANDLE}
  PROCESS_CREATE_PROCESS    = $0080;
  {$EXTERNALSYM PROCESS_CREATE_PROCESS}
  PROCESS_SET_QUOTA         = $0100;
  {$EXTERNALSYM PROCESS_SET_QUOTA}
  PROCESS_SET_INFORMATION   = $0200;
  {$EXTERNALSYM PROCESS_SET_INFORMATION}
  PROCESS_QUERY_INFORMATION = $0400;
  {$EXTERNALSYM PROCESS_QUERY_INFORMATION}
  PROCESS_ALL_ACCESS        = (STANDARD_RIGHTS_REQUIRED or SYNCHRONIZE or $FFF);
  {$EXTERNALSYM PROCESS_ALL_ACCESS}

{line 2150}
type
  PMemoryBasicInformation = ^TMemoryBasicInformation;
  _MEMORY_BASIC_INFORMATION = record
    BaseAddress : Pointer;
    AllocationBase : Pointer;
    AllocationProtect : DWORD;
    RegionSize : DWORD;
    State : DWORD;
    Protect : DWORD;
    Type_9 : DWORD;
  end;
  {$EXTERNALSYM _MEMORY_BASIC_INFORMATION}
  TMemoryBasicInformation = _MEMORY_BASIC_INFORMATION;
  MEMORY_BASIC_INFORMATION = _MEMORY_BASIC_INFORMATION;
  {$EXTERNALSYM MEMORY_BASIC_INFORMATION}

const
  SECTION_QUERY = 1;
  {$EXTERNALSYM SECTION_QUERY}
  SECTION_MAP_WRITE = 2;
  {$EXTERNALSYM SECTION_MAP_WRITE}
  SECTION_MAP_READ = 4;
  {$EXTERNALSYM SECTION_MAP_READ}
  SECTION_MAP_EXECUTE = 8;
  {$EXTERNALSYM SECTION_MAP_EXECUTE}
  SECTION_EXTEND_SIZE = $10;
  {$EXTERNALSYM SECTION_EXTEND_SIZE}
  SECTION_ALL_ACCESS = (STANDARD_RIGHTS_REQUIRED or SECTION_QUERY or
    SECTION_MAP_WRITE or SECTION_MAP_READ or SECTION_MAP_EXECUTE or SECTION_EXTEND_SIZE);
  {$EXTERNALSYM SECTION_ALL_ACCESS}

  PAGE_NOACCESS = 1;
  {$EXTERNALSYM PAGE_NOACCESS}
  PAGE_READONLY = 2;
  {$EXTERNALSYM PAGE_READONLY}
  PAGE_READWRITE = 4;
  {$EXTERNALSYM PAGE_READWRITE}
  PAGE_WRITECOPY = 8;
  {$EXTERNALSYM PAGE_WRITECOPY}
  PAGE_EXECUTE = $10;
  {$EXTERNALSYM PAGE_EXECUTE}
  PAGE_EXECUTE_READ = $20;
  {$EXTERNALSYM PAGE_EXECUTE_READ}
  PAGE_EXECUTE_READWRITE = $40;
  {$EXTERNALSYM PAGE_EXECUTE_READWRITE}
  PAGE_EXECUTE_WRITECOPY = $80;
  {$EXTERNALSYM PAGE_EXECUTE_WRITECOPY}
  PAGE_GUARD = $100;
  {$EXTERNALSYM PAGE_GUARD}
  PAGE_NOCACHE = $200;
  {$EXTERNALSYM PAGE_NOCACHE}
  MEM_COMMIT = $1000;
  {$EXTERNALSYM MEM_COMMIT}
  MEM_RESERVE = $2000;
  {$EXTERNALSYM MEM_RESERVE}
  MEM_DECOMMIT = $4000;
  {$EXTERNALSYM MEM_DECOMMIT}
  MEM_RELEASE = $8000;
  {$EXTERNALSYM MEM_RELEASE}
  MEM_FREE = $10000;
  {$EXTERNALSYM MEM_FREE}
  MEM_PRIVATE = $20000;
  {$EXTERNALSYM MEM_PRIVATE}
  MEM_MAPPED = $40000;
  {$EXTERNALSYM MEM_MAPPED}
  MEM_RESET = $80000;
  {$EXTERNALSYM MEM_RESET}
  MEM_TOP_DOWN = $100000;
  {$EXTERNALSYM MEM_TOP_DOWN}
  SEC_FILE = $800000;
  {$EXTERNALSYM SEC_FILE}
  SEC_IMAGE = $1000000;
  {$EXTERNALSYM SEC_IMAGE}
  SEC_RESERVE = $4000000;
  {$EXTERNALSYM SEC_RESERVE}
  SEC_COMMIT = $8000000;
  {$EXTERNALSYM SEC_COMMIT}
  SEC_NOCACHE = $10000000;
  {$EXTERNALSYM SEC_NOCACHE}
  MEM_IMAGE = SEC_IMAGE;
  {$EXTERNALSYM MEM_IMAGE}


{line 2250}
  FILE_SHARE_READ                     = $00000001;
  {$EXTERNALSYM FILE_SHARE_READ}
  FILE_SHARE_WRITE                    = $00000002;
  {$EXTERNALSYM FILE_SHARE_WRITE}
  FILE_SHARE_DELETE                   = $00000004;
  {$EXTERNALSYM FILE_SHARE_DELETE}
  FILE_ATTRIBUTE_READONLY             = $00000001;
  {$EXTERNALSYM FILE_ATTRIBUTE_READONLY}
  FILE_ATTRIBUTE_HIDDEN               = $00000002;
  {$EXTERNALSYM FILE_ATTRIBUTE_HIDDEN}
  FILE_ATTRIBUTE_SYSTEM               = $00000004;
  {$EXTERNALSYM FILE_ATTRIBUTE_SYSTEM}
  FILE_ATTRIBUTE_DIRECTORY            = $00000010;
  {$EXTERNALSYM FILE_ATTRIBUTE_DIRECTORY}
  FILE_ATTRIBUTE_ARCHIVE              = $00000020;
  {$EXTERNALSYM FILE_ATTRIBUTE_ARCHIVE}
  FILE_ATTRIBUTE_DEVICE               = $00000040;
  {$EXTERNALSYM FILE_ATTRIBUTE_DEVICE}
  FILE_ATTRIBUTE_NORMAL               = $00000080;
  {$EXTERNALSYM FILE_ATTRIBUTE_NORMAL}
  FILE_ATTRIBUTE_TEMPORARY            = $00000100;
  {$EXTERNALSYM FILE_ATTRIBUTE_TEMPORARY}
  FILE_ATTRIBUTE_SPARSE_FILE          = $00000200;
  {$EXTERNALSYM FILE_ATTRIBUTE_SPARSE_FILE}
  FILE_ATTRIBUTE_REPARSE_POINT        = $00000400;
  {$EXTERNALSYM FILE_ATTRIBUTE_REPARSE_POINT}
  FILE_ATTRIBUTE_COMPRESSED           = $00000800;
  {$EXTERNALSYM FILE_ATTRIBUTE_COMPRESSED}
  FILE_ATTRIBUTE_OFFLINE              = $00001000;
  {$EXTERNALSYM FILE_ATTRIBUTE_OFFLINE}
  FILE_ATTRIBUTE_NOT_CONTENT_INDEXED  = $00002000;
  {$EXTERNALSYM FILE_ATTRIBUTE_NOT_CONTENT_INDEXED}
  FILE_ATTRIBUTE_ENCRYPTED            = $00004000;
  {$EXTERNALSYM FILE_ATTRIBUTE_ENCRYPTED}
  FILE_NOTIFY_CHANGE_FILE_NAME        = $00000001;
  {$EXTERNALSYM FILE_NOTIFY_CHANGE_FILE_NAME}
  FILE_NOTIFY_CHANGE_DIR_NAME         = $00000002;
  {$EXTERNALSYM FILE_NOTIFY_CHANGE_DIR_NAME}
  FILE_NOTIFY_CHANGE_ATTRIBUTES       = $00000004;
  {$EXTERNALSYM FILE_NOTIFY_CHANGE_ATTRIBUTES}
  FILE_NOTIFY_CHANGE_SIZE             = $00000008;
  {$EXTERNALSYM FILE_NOTIFY_CHANGE_SIZE}
  FILE_NOTIFY_CHANGE_LAST_WRITE       = $00000010;
  {$EXTERNALSYM FILE_NOTIFY_CHANGE_LAST_WRITE}
  FILE_NOTIFY_CHANGE_LAST_ACCESS      = $00000020;
  {$EXTERNALSYM FILE_NOTIFY_CHANGE_LAST_ACCESS}
  FILE_NOTIFY_CHANGE_CREATION         = $00000040;
  {$EXTERNALSYM FILE_NOTIFY_CHANGE_CREATION}
  FILE_NOTIFY_CHANGE_SECURITY         = $00000100;
  {$EXTERNALSYM FILE_NOTIFY_CHANGE_SECURITY}
  FILE_ACTION_ADDED                   = $00000001;
  {$EXTERNALSYM FILE_ACTION_ADDED}
  FILE_ACTION_REMOVED                 = $00000002;
  {$EXTERNALSYM FILE_ACTION_REMOVED}
  FILE_ACTION_MODIFIED                = $00000003;
  {$EXTERNALSYM FILE_ACTION_MODIFIED}
  FILE_ACTION_RENAMED_OLD_NAME        = $00000004;
  {$EXTERNALSYM FILE_ACTION_RENAMED_OLD_NAME}
  FILE_ACTION_RENAMED_NEW_NAME        = $00000005;
  {$EXTERNALSYM FILE_ACTION_RENAMED_NEW_NAME}
  MAILSLOT_NO_MESSAGE                 = LongWord(-1);
  {$EXTERNALSYM MAILSLOT_NO_MESSAGE}
  MAILSLOT_WAIT_FOREVER               = LongWord(-1);
  {$EXTERNALSYM MAILSLOT_WAIT_FOREVER}
  FILE_CASE_SENSITIVE_SEARCH          = $00000001;
  {$EXTERNALSYM FILE_CASE_SENSITIVE_SEARCH}
  FILE_CASE_PRESERVED_NAMES           = $00000002;
  {$EXTERNALSYM FILE_CASE_PRESERVED_NAMES}
  FILE_UNICODE_ON_DISK                = $00000004;
  {$EXTERNALSYM FILE_UNICODE_ON_DISK}
  FILE_PERSISTENT_ACLS                = $00000008;
  {$EXTERNALSYM FILE_PERSISTENT_ACLS}
  FILE_FILE_COMPRESSION               = $00000010;
  {$EXTERNALSYM FILE_FILE_COMPRESSION}
  FILE_VOLUME_IS_COMPRESSED           = $00008000;
  {$EXTERNALSYM FILE_VOLUME_IS_COMPRESSED}


{line 2300}
const
  IO_COMPLETION_MODIFY_STATE = $0002;
  {$EXTERNALSYM IO_COMPLETION_MODIFY_STATE}
  IO_COMPLETION_ALL_ACCESS   = (STANDARD_RIGHTS_REQUIRED or SYNCHRONIZE or 3);
  {$EXTERNALSYM IO_COMPLETION_ALL_ACCESS}
  DUPLICATE_CLOSE_SOURCE     = $00000001;
  {$EXTERNALSYM DUPLICATE_CLOSE_SOURCE}
  DUPLICATE_SAME_ACCESS      = $00000002;
  {$EXTERNALSYM DUPLICATE_SAME_ACCESS}

type
  PSECURITY_DESCRIPTOR = Pointer;
  {$EXTERNALSYM PSECURITY_DESCRIPTOR}

  ACCESS_MASK = DWORD;
  {$EXTERNALSYM ACCESS_MASK}
  PACCESS_MASK = ^ACCESS_MASK;

const
  { The following are masks for the predefined standard access types }

  _DELETE                  = $00010000; { Renamed from DELETE }
  READ_CONTROL             = $00020000;
  {$EXTERNALSYM READ_CONTROL}
  WRITE_DAC                = $00040000;
  {$EXTERNALSYM WRITE_DAC}
  WRITE_OWNER              = $00080000;
  {$EXTERNALSYM WRITE_OWNER}
{ SYNCHRONIZE              = $00100000; defined above }
{ STANDARD_RIGHTS_REQUIRED = $000F0000; defined above }
  STANDARD_RIGHTS_READ     = READ_CONTROL;
  {$EXTERNALSYM STANDARD_RIGHTS_READ}
  STANDARD_RIGHTS_WRITE    = READ_CONTROL;
  {$EXTERNALSYM STANDARD_RIGHTS_WRITE}
  STANDARD_RIGHTS_EXECUTE  = READ_CONTROL;
  {$EXTERNALSYM STANDARD_RIGHTS_EXECUTE}
  STANDARD_RIGHTS_ALL      = $001F0000;
  {$EXTERNALSYM STANDARD_RIGHTS_ALL}
  SPECIFIC_RIGHTS_ALL      = $0000FFFF;
  {$EXTERNALSYM SPECIFIC_RIGHTS_ALL}
  ACCESS_SYSTEM_SECURITY   = $01000000;
  {$EXTERNALSYM ACCESS_SYSTEM_SECURITY}
  MAXIMUM_ALLOWED          = $02000000;
  {$EXTERNALSYM MAXIMUM_ALLOWED}
  GENERIC_READ             = DWORD($80000000);
  {$EXTERNALSYM GENERIC_READ}
  GENERIC_WRITE            = $40000000;
  {$EXTERNALSYM GENERIC_WRITE}
  GENERIC_EXECUTE          = $20000000;
  {$EXTERNALSYM GENERIC_EXECUTE}
  GENERIC_ALL              = $10000000;
  {$EXTERNALSYM GENERIC_ALL}

type
  { Define the generic mapping array.  This is used to denote the
    mapping of each generic access right to a specific access mask. }

  PGenericMapping = ^TGenericMapping;
  _GENERIC_MAPPING = record
    GenericRead: ACCESS_MASK;
    GenericWrite: ACCESS_MASK;
    GenericExecute: ACCESS_MASK;
    GenericAll: ACCESS_MASK;
  end;
  {$EXTERNALSYM _GENERIC_MAPPING}
  TGenericMapping = _GENERIC_MAPPING;
  GENERIC_MAPPING = _GENERIC_MAPPING;
  {$EXTERNALSYM GENERIC_MAPPING}

  PLUIDAndAttributes = ^TLUIDAndAttributes;
  _LUID_AND_ATTRIBUTES = packed record
    Luid: TLargeInteger;
    Attributes: DWORD;
  end;
  {$EXTERNALSYM _LUID_AND_ATTRIBUTES}
  TLUIDAndAttributes = _LUID_AND_ATTRIBUTES;
  LUID_AND_ATTRIBUTES = _LUID_AND_ATTRIBUTES;
  {$EXTERNALSYM LUID_AND_ATTRIBUTES}

{ ////////////////////////////////////////////////////////////////////// }
{                                                                    // }
{              Security Id     (SID)                                 // }
{                                                                    // }
{ ////////////////////////////////////////////////////////////////////// }


{ Pictorially the structure of an SID is as follows: }

{         1   1   1   1   1   1 }
{         5   4   3   2   1   0   9   8   7   6   5   4   3   2   1   0 }
{      +---------------------------------------------------------------+ }
{      |      SubAuthorityCount        |Reserved1 (SBZ)|   Revision    | }
{      +---------------------------------------------------------------+ }
{      |                   IdentifierAuthority[0]                      | }
{      +---------------------------------------------------------------+ }
{      |                   IdentifierAuthority[1]                      | }
{      +---------------------------------------------------------------+ }
{      |                   IdentifierAuthority[2]                      | }
{      +---------------------------------------------------------------+ }
{      |                                                               | }
{      +- -  -  -  -  -  -  -  SubAuthority[]  -  -  -  -  -  -  -  - -+ }
{      |                                                               | }
{      +---------------------------------------------------------------+ }

  PSIDIdentifierAuthority = ^TSIDIdentifierAuthority;
  _SID_IDENTIFIER_AUTHORITY = record
    Value: array[0..5] of Byte;
  end;
  {$EXTERNALSYM _SID_IDENTIFIER_AUTHORITY}
  TSIDIdentifierAuthority = _SID_IDENTIFIER_AUTHORITY;
  SID_IDENTIFIER_AUTHORITY = _SID_IDENTIFIER_AUTHORITY;
  {$EXTERNALSYM SID_IDENTIFIER_AUTHORITY}

const
  SidTypeUser = 1;
  {$EXTERNALSYM SidTypeUser}
  SidTypeGroup = 2;
  {$EXTERNALSYM SidTypeGroup}
  SidTypeDomain = 3;
  {$EXTERNALSYM SidTypeDomain}
  SidTypeAlias = 4;
  {$EXTERNALSYM SidTypeAlias}
  SidTypeWellKnownGroup = 5;
  {$EXTERNALSYM SidTypeWellKnownGroup}
  SidTypeDeletedAccount = 6;
  {$EXTERNALSYM SidTypeDeletedAccount}
  SidTypeInvalid = 7;
  {$EXTERNALSYM SidTypeInvalid}
  SidTypeUnknown = 8;
  {$EXTERNALSYM SidTypeUnknown}
type
  SID_NAME_USE = DWORD;
  {$EXTERNALSYM SID_NAME_USE}

  PSIDAndAttributes = ^TSIDAndAttributes;
  _SID_AND_ATTRIBUTES = record
    Sid: PSID;
    Attributes: DWORD;
  end;
  {$EXTERNALSYM _SID_AND_ATTRIBUTES}
  TSIDAndAttributes = _SID_AND_ATTRIBUTES;
  SID_AND_ATTRIBUTES = _SID_AND_ATTRIBUTES;
  {$EXTERNALSYM SID_AND_ATTRIBUTES}

{line 2700}
  PACL = ^TACL;
  {$EXTERNALSYM PACL}
  _ACL = record
    AclRevision: Byte;
    Sbz1: Byte;
    AclSize: Word;
    AceCount: Word;
    Sbz2: Word;
  end;
  {$EXTERNALSYM _ACL}
  TACL = _ACL;
  ACL = _ACL;
  {$EXTERNALSYM ACL}

{line 2850}
  { The following declarations are used for setting and querying information
    about and ACL.  First are the various information classes available to
    the user. }

  TAclInformationClass = (AclInfoPad, AclRevisionInformation, AclSizeInformation);
  {$EXTERNALSYM TAclInformationClass}

{line 2900}
{ Security Descriptor and related data types. }

const
  SECURITY_DESCRIPTOR_REVISION = 1;
  {$EXTERNALSYM SECURITY_DESCRIPTOR_REVISION}
  SECURITY_DESCRIPTOR_REVISION1 = 1;
  {$EXTERNALSYM SECURITY_DESCRIPTOR_REVISION1}
  SECURITY_DESCRIPTOR_MIN_LENGTH = 20;
  {$EXTERNALSYM SECURITY_DESCRIPTOR_MIN_LENGTH}
  SE_OWNER_DEFAULTED = $0001;
  {$EXTERNALSYM SE_OWNER_DEFAULTED}
  SE_GROUP_DEFAULTED = $0002;
  {$EXTERNALSYM SE_GROUP_DEFAULTED}
  SE_DACL_PRESENT    = $0004;
  {$EXTERNALSYM SE_DACL_PRESENT}
  SE_DACL_DEFAULTED  = $0008;
  {$EXTERNALSYM SE_DACL_DEFAULTED}
  SE_SACL_PRESENT    = $0010;
  {$EXTERNALSYM SE_SACL_PRESENT}
  SE_SACL_DEFAULTED  = $0020;
  {$EXTERNALSYM SE_SACL_DEFAULTED}
  SE_DACL_AUTO_INHERIT_REQ = $0100;
  {$EXTERNALSYM SE_DACL_AUTO_INHERIT_REQ}
  SE_SACL_AUTO_INHERIT_REQ = $0200;
  {$EXTERNALSYM SE_SACL_AUTO_INHERIT_REQ}
  SE_DACL_AUTO_INHERITED = $0400;
  {$EXTERNALSYM SE_DACL_AUTO_INHERITED}
  SE_SACL_AUTO_INHERITED = $0800;
  {$EXTERNALSYM SE_SACL_AUTO_INHERITED}
  SE_DACL_PROTECTED = $1000;
  {$EXTERNALSYM SE_DACL_PROTECTED}
  SE_SACL_PROTECTED = $2000;
  {$EXTERNALSYM SE_SACL_PROTECTED}

  SE_SELF_RELATIVE   = $8000;
  {$EXTERNALSYM SE_SELF_RELATIVE}

{  Where: }

{      SE_OWNER_DEFAULTED - This boolean flag, when set, indicates that the }
{          SID pointed to by the Owner field was provided by a }
{          defaulting mechanism rather than explicitly provided by the }
{          original provider of the security descriptor.  This may }
{          affect the treatment of the SID with respect to inheritence }
{          of an owner. }

{      SE_GROUP_DEFAULTED - This boolean flag, when set, indicates that the }
{          SID in the Group field was provided by a defaulting mechanism }
{          rather than explicitly provided by the original provider of }
{          the security descriptor.  This may affect the treatment of }
{          the SID with respect to inheritence of a primary group. }

{      SE_DACL_PRESENT - This boolean flag, when set, indicates that the }
{          security descriptor contains a discretionary ACL.  If this }
{          flag is set and the Dacl field of the SECURITY_DESCRIPTOR is }
{          null, then a null ACL is explicitly being specified. }

{      SE_DACL_DEFAULTED - This boolean flag, when set, indicates that the }
{          ACL pointed to by the Dacl field was provided by a defaulting }
{          mechanism rather than explicitly provided by the original }
{          provider of the security descriptor.  This may affect the }
{          treatment of the ACL with respect to inheritence of an ACL. }
{          This flag is ignored if the DaclPresent flag is not set. }

{      SE_SACL_PRESENT - This boolean flag, when set,  indicates that the }
{          security descriptor contains a system ACL pointed to by the }
{          Sacl field.  If this flag is set and the Sacl field of the }
{          SECURITY_DESCRIPTOR is null, then an empty (but present) }
{          ACL is being specified. }

{      SE_SACL_DEFAULTED - This boolean flag, when set, indicates that the }
{          ACL pointed to by the Sacl field was provided by a defaulting }
{          mechanism rather than explicitly provided by the original }
{          provider of the security descriptor.  This may affect the }
{          treatment of the ACL with respect to inheritence of an ACL. }
{          This flag is ignored if the SaclPresent flag is not set. }

{      SE_SELF_RELATIVE - This boolean flag, when set, indicates that the }
{          security descriptor is in self-relative form.  In this form, }
{          all fields of the security descriptor are contiguous in memory }
{          and all pointer fields are expressed as offsets from the }
{          beginning of the security descriptor.  This form is useful }
{          for treating security descriptors as opaque data structures }
{          for transmission in communication protocol or for storage on }
{          secondary media. }



{ Pictorially the structure of a security descriptor is as follows: }

{       3 3 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1 }
{       1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0 }
{      +---------------------------------------------------------------+ }
{      |            Control            |Reserved1 (SBZ)|   Revision    | }
{      +---------------------------------------------------------------+ }
{      |                            Owner                              | }
{      +---------------------------------------------------------------+ }
{      |                            Group                              | }
{      +---------------------------------------------------------------+ }
{      |                            Sacl                               | }
{      +---------------------------------------------------------------+ }
{      |                            Dacl                               | }
{      +---------------------------------------------------------------+ }

{ In general, this data structure should be treated opaquely to ensure future }
{ compatibility. }


type
  SECURITY_DESCRIPTOR_CONTROL = Word;
  {$EXTERNALSYM SECURITY_DESCRIPTOR_CONTROL}
  PSECURITY_DESCRIPTOR_CONTROL = ^WORD;
  {$EXTERNALSYM PSECURITY_DESCRIPTOR_CONTROL}

  { In general, this data structure should be treated opaquely
    to ensure future compatibility. }

  PSecurityDescriptor = ^TSecurityDescriptor;
  _SECURITY_DESCRIPTOR = record
    Revision: Byte;
    Sbz1: Byte;
    Control: SECURITY_DESCRIPTOR_CONTROL;
    Owner: PSID;
    Group: PSID;
    Sacl: PACL;
    Dacl: PACL;
  end;
  {$EXTERNALSYM _SECURITY_DESCRIPTOR}
  TSecurityDescriptor = _SECURITY_DESCRIPTOR;
  SECURITY_DESCRIPTOR = _SECURITY_DESCRIPTOR;
  {$EXTERNALSYM SECURITY_DESCRIPTOR}

  PObjectTypeList = ^TObjectTypeList;
  _OBJECT_TYPE_LIST = record
    Level: WORD;
    Sbz: WORD;
    ObjectType: PGUID;
  end;
  {$EXTERNALSYM _OBJECT_TYPE_LIST}
  TObjectTypeList = _OBJECT_TYPE_LIST;
  OBJECT_TYPE_LIST = _OBJECT_TYPE_LIST;
  {$EXTERNALSYM OBJECT_TYPE_LIST}

const
  { DS values for Level }
  ACCESS_OBJECT_GUID = 0;
  {$EXTERNALSYM ACCESS_OBJECT_GUID}
  ACCESS_PROPERTY_SET_GUID = 1;
  {$EXTERNALSYM ACCESS_PROPERTY_SET_GUID}
  ACCESS_PROPERTY_GUID = 2;
  {$EXTERNALSYM ACCESS_PROPERTY_GUID}

  ACCESS_MAX_LEVEL = 4;
  {$EXTERNALSYM ACCESS_MAX_LEVEL}

type
  AUDIT_EVENT_TYPE = DWORD;
  {$EXTERNALSYM AUDIT_EVENT_TYPE}

const
  AUDIT_ALLOW_NO_PRIVILEGE = $1;
  {$EXTERNALSYM AUDIT_ALLOW_NO_PRIVILEGE}


{ Privilege Related Data Structures }

const
  { Privilege attributes }

  SE_PRIVILEGE_ENABLED_BY_DEFAULT = $00000001;
  {$EXTERNALSYM SE_PRIVILEGE_ENABLED_BY_DEFAULT}
  SE_PRIVILEGE_ENABLED            = $00000002;
  {$EXTERNALSYM SE_PRIVILEGE_ENABLED}
  SE_PRIVILEGE_USED_FOR_ACCESS    = DWORD($80000000);
  {$EXTERNALSYM SE_PRIVILEGE_USED_FOR_ACCESS}

  { Privilege Set Control flags }

  PRIVILEGE_SET_ALL_NECESSARY = 1;
  {$EXTERNALSYM PRIVILEGE_SET_ALL_NECESSARY}

  {  Privilege Set - This is defined for a privilege set of one.
                   If more than one privilege is needed, then this structure
                   will need to be allocated with more space.}
  {  Note: don't change this structure without fixing the INITIAL_PRIVILEGE_SET}

type
  PPrivilegeSet = ^TPrivilegeSet;
  _PRIVILEGE_SET = record
    PrivilegeCount: DWORD;
    Control: DWORD;
    Privilege: array[0..0] of TLUIDAndAttributes;
  end;
  {$EXTERNALSYM _PRIVILEGE_SET}
  TPrivilegeSet = _PRIVILEGE_SET;
  PRIVILEGE_SET = _PRIVILEGE_SET;
  {$EXTERNALSYM PRIVILEGE_SET}

{ line 3130 }
  TSecurityImpersonationLevel = (SecurityAnonymous,
    SecurityIdentification, SecurityImpersonation, SecurityDelegation);
  {$EXTERNALSYM TSecurityImpersonationLevel}

const
  SECURITY_MAX_IMPERSONATION_LEVEL     = SecurityDelegation;
  {$EXTERNALSYM SECURITY_MAX_IMPERSONATION_LEVEL}
  DEFAULT_IMPERSONATION_LEVEL     = SecurityImpersonation;
  {$EXTERNALSYM DEFAULT_IMPERSONATION_LEVEL}

const
  TOKEN_ASSIGN_PRIMARY = $0001;
  {$EXTERNALSYM TOKEN_ASSIGN_PRIMARY}
  TOKEN_DUPLICATE = $0002;
  {$EXTERNALSYM TOKEN_DUPLICATE}
  TOKEN_IMPERSONATE = $0004;
  {$EXTERNALSYM TOKEN_IMPERSONATE}
  TOKEN_QUERY = $0008;
  {$EXTERNALSYM TOKEN_QUERY}
  TOKEN_QUERY_SOURCE = $0010;
  {$EXTERNALSYM TOKEN_QUERY_SOURCE}
  TOKEN_ADJUST_PRIVILEGES = $0020;
  {$EXTERNALSYM TOKEN_ADJUST_PRIVILEGES}
  TOKEN_ADJUST_GROUPS = $0040;
  {$EXTERNALSYM TOKEN_ADJUST_GROUPS}
  TOKEN_ADJUST_DEFAULT = $0080;
  {$EXTERNALSYM TOKEN_ADJUST_DEFAULT}
  TOKEN_ALL_ACCESS = (STANDARD_RIGHTS_REQUIRED or TOKEN_ASSIGN_PRIMARY or
    TOKEN_DUPLICATE or TOKEN_IMPERSONATE or TOKEN_QUERY or
    TOKEN_QUERY_SOURCE or TOKEN_ADJUST_PRIVILEGES or TOKEN_ADJUST_GROUPS or
    TOKEN_ADJUST_DEFAULT);
  {$EXTERNALSYM TOKEN_ALL_ACCESS}
  TOKEN_READ = (STANDARD_RIGHTS_READ or TOKEN_QUERY);
  {$EXTERNALSYM TOKEN_READ}
  TOKEN_WRITE = (STANDARD_RIGHTS_WRITE or TOKEN_ADJUST_PRIVILEGES or
    TOKEN_ADJUST_GROUPS or TOKEN_ADJUST_DEFAULT);
  {$EXTERNALSYM TOKEN_WRITE}
  TOKEN_EXECUTE = STANDARD_RIGHTS_EXECUTE;
  {$EXTERNALSYM TOKEN_EXECUTE}

type
  TTokenType = (TokenTPad, TokenPrimary, TokenImpersonation);
  {$EXTERNALSYM TTokenType}

  TTokenInformationClass = (TokenICPad, TokenUser, TokenGroups, TokenPrivileges,
    TokenOwner, TokenPrimaryGroup, TokenDefaultDacl, TokenSource, TokenType,
    TokenImpersonationLevel, TokenStatistics);
  {$EXTERNALSYM TTokenInformationClass}

  PTokenGroups = ^TTokenGroups;
  _TOKEN_GROUPS = record
    GroupCount: DWORD;
    Groups: array[0..0] of TSIDAndAttributes;
  end;
  {$EXTERNALSYM _TOKEN_GROUPS}
  TTokenGroups = _TOKEN_GROUPS;
  TOKEN_GROUPS = _TOKEN_GROUPS;
  {$EXTERNALSYM TOKEN_GROUPS}

  PTokenPrivileges = ^TTokenPrivileges;
  _TOKEN_PRIVILEGES = record
    PrivilegeCount: DWORD;
    Privileges: array[0..0] of TLUIDAndAttributes;
  end;
  {$EXTERNALSYM _TOKEN_PRIVILEGES}
  TTokenPrivileges = _TOKEN_PRIVILEGES;
  TOKEN_PRIVILEGES = _TOKEN_PRIVILEGES;
  {$EXTERNALSYM TOKEN_PRIVILEGES}

const
  SECURITY_DYNAMIC_TRACKING = True;
  {$EXTERNALSYM SECURITY_DYNAMIC_TRACKING}
  SECURITY_STATIC_TRACKING  = False;
  {$EXTERNALSYM SECURITY_STATIC_TRACKING}

type
  SECURITY_CONTEXT_TRACKING_MODE = Boolean;
  {$EXTERNALSYM SECURITY_CONTEXT_TRACKING_MODE}

  PSecurityQualityOfService = ^TSecurityQualityOfService;
  _SECURITY_QUALITY_OF_SERVICE = record
    Length: DWORD;
    ImpersonationLevel: TSecurityImpersonationLevel;
    ContextTrackingMode: SECURITY_CONTEXT_TRACKING_MODE;
    EffectiveOnly: Boolean;
  end;
  {$EXTERNALSYM _SECURITY_QUALITY_OF_SERVICE}
  TSecurityQualityOfService = _SECURITY_QUALITY_OF_SERVICE;
  SECURITY_QUALITY_OF_SERVICE = _SECURITY_QUALITY_OF_SERVICE;
  {$EXTERNALSYM SECURITY_QUALITY_OF_SERVICE}

{line 3320}
  SECURITY_INFORMATION = DWORD;
  {$EXTERNALSYM SECURITY_INFORMATION}
  PSECURITY_INFORMATION = ^DWORD;

const
  OWNER_SECURITY_INFORMATION =  $00000001;
  {$EXTERNALSYM OWNER_SECURITY_INFORMATION}
  GROUP_SECURITY_INFORMATION =  $00000002;
  {$EXTERNALSYM GROUP_SECURITY_INFORMATION}
  DACL_SECURITY_INFORMATION  =  $00000004;
  {$EXTERNALSYM DACL_SECURITY_INFORMATION}
  SACL_SECURITY_INFORMATION  =  $00000008;
  {$EXTERNALSYM SACL_SECURITY_INFORMATION}

type
  TThreadStartRoutine = function(lpThreadParameter: Pointer): Integer stdcall;

{line 3337}
const
  IMAGE_DOS_SIGNATURE                     = $5A4D;      { MZ }
  {$EXTERNALSYM IMAGE_DOS_SIGNATURE}
  IMAGE_OS2_SIGNATURE                     = $454E;      { NE }
  {$EXTERNALSYM IMAGE_OS2_SIGNATURE}
  IMAGE_OS2_SIGNATURE_LE                  = $454C;      { LE }
  {$EXTERNALSYM IMAGE_OS2_SIGNATURE_LE}
  IMAGE_VXD_SIGNATURE                     = $454C;      { LE }
  {$EXTERNALSYM IMAGE_VXD_SIGNATURE}
  IMAGE_NT_SIGNATURE                      = $00004550;  { PE00 }
  {$EXTERNALSYM IMAGE_NT_SIGNATURE}

{line 3457}
{ File header format. }

type
  PImageDosHeader = ^TImageDosHeader;
    {EXTERNALSYM _IMAGE_DOS_HEADER}
  _IMAGE_DOS_HEADER = packed record      { DOS .EXE header                  }
      e_magic: Word;                     { Magic number                     }
      e_cblp: Word;                      { Bytes on last page of file       }
      e_cp: Word;                        { Pages in file                    }
      e_crlc: Word;                      { Relocations                      }
      e_cparhdr: Word;                   { Size of header in paragraphs     }
      e_minalloc: Word;                  { Minimum extra paragraphs needed  }
      e_maxalloc: Word;                  { Maximum extra paragraphs needed  }
      e_ss: Word;                        { Initial (relative) SS value      }
      e_sp: Word;                        { Initial SP value                 }
      e_csum: Word;                      { Checksum                         }
      e_ip: Word;                        { Initial IP value                 }
      e_cs: Word;                        { Initial (relative) CS value      }
      e_lfarlc: Word;                    { File address of relocation table }
      e_ovno: Word;                      { Overlay number                   }
      e_res: array [0..3] of Word;       { Reserved words                   }
      e_oemid: Word;                     { OEM identifier (for e_oeminfo)   }
      e_oeminfo: Word;                   { OEM information; e_oemid specific}
      e_res2: array [0..9] of Word;      { Reserved words                   }
      _lfanew: LongInt;                  { File address of new exe header   }
  end;
  TImageDosHeader = _IMAGE_DOS_HEADER;
  {$EXTERNALSYM IMAGE_DOS_HEADER}
  IMAGE_DOS_HEADER = _IMAGE_DOS_HEADER;


  PImageFileHeader = ^TImageFileHeader;
  _IMAGE_FILE_HEADER = packed record
    Machine: Word;
    NumberOfSections: Word;
    TimeDateStamp: DWORD;
    PointerToSymbolTable: DWORD;
    NumberOfSymbols: DWORD;
    SizeOfOptionalHeader: Word;
    Characteristics: Word;
  end;
  {$EXTERNALSYM _IMAGE_FILE_HEADER}
  TImageFileHeader = _IMAGE_FILE_HEADER;
  IMAGE_FILE_HEADER = _IMAGE_FILE_HEADER;
  {$EXTERNALSYM IMAGE_FILE_HEADER}

  PImageExportDirectory = ^TImageExportDirectory;
  _IMAGE_EXPORT_DIRECTORY = packed record
      Characteristics: DWord;
      TimeDateStamp: DWord;
      MajorVersion: Word;
      MinorVersion: Word;
      Name: DWord;
      Base: DWord;
      NumberOfFunctions: DWord;
      NumberOfNames: DWord;
      AddressOfFunctions: ^PDWORD;
      AddressOfNames: ^PDWORD;
      AddressOfNameOrdinals: ^PWord;
  end;
  {$EXTERNALSYM _IMAGE_EXPORT_DIRECTORY}
  TImageExportDirectory = _IMAGE_EXPORT_DIRECTORY;
  IMAGE_EXPORT_DIRECTORY = _IMAGE_EXPORT_DIRECTORY;
  {$EXTERNALSYM IMAGE_EXPORT_DIRECTORY}

const
  IMAGE_SIZEOF_FILE_HEADER                 = 20;
  {$EXTERNALSYM IMAGE_SIZEOF_FILE_HEADER}

  IMAGE_FILE_RELOCS_STRIPPED               = $0001;  { Relocation info stripped from file. }
  {$EXTERNALSYM IMAGE_FILE_RELOCS_STRIPPED}
  IMAGE_FILE_EXECUTABLE_IMAGE              = $0002;  { File is executable  (i.e. no unresolved externel references). }
  {$EXTERNALSYM IMAGE_FILE_EXECUTABLE_IMAGE}
  IMAGE_FILE_LINE_NUMS_STRIPPED            = $0004;  { Line nunbers stripped from file. }
  {$EXTERNALSYM IMAGE_FILE_LINE_NUMS_STRIPPED}
  IMAGE_FILE_LOCAL_SYMS_STRIPPED           = $0008;  { Local symbols stripped from file. }
  {$EXTERNALSYM IMAGE_FILE_LOCAL_SYMS_STRIPPED}
  IMAGE_FILE_AGGRESIVE_WS_TRIM             = $0010;  { Agressively trim working set }
  {$EXTERNALSYM IMAGE_FILE_AGGRESIVE_WS_TRIM}
  IMAGE_FILE_LARGE_ADDRESS_AWARE           = $0020;  { App can handle >2gb addresses }
  {$EXTERNALSYM IMAGE_FILE_LARGE_ADDRESS_AWARE}
  IMAGE_FILE_BYTES_REVERSED_LO             = $0080;  { Bytes of machine word are reversed. }
  {$EXTERNALSYM IMAGE_FILE_BYTES_REVERSED_LO}
  IMAGE_FILE_32BIT_MACHINE                 = $0100;  { 32 bit word machine. }
  {$EXTERNALSYM IMAGE_FILE_32BIT_MACHINE}
  IMAGE_FILE_DEBUG_STRIPPED                = $0200;  { Debugging info stripped from file in .DBG file }
  {$EXTERNALSYM IMAGE_FILE_DEBUG_STRIPPED}
  IMAGE_FILE_REMOVABLE_RUN_FROM_SWAP       = $0400;  { If Image is on removable media, copy and run from the swap file. }
  {$EXTERNALSYM IMAGE_FILE_REMOVABLE_RUN_FROM_SWAP}
  IMAGE_FILE_NET_RUN_FROM_SWAP             = $0800;  { If Image is on Net, copy and run from the swap file. }
  {$EXTERNALSYM IMAGE_FILE_NET_RUN_FROM_SWAP}
  IMAGE_FILE_SYSTEM                        = $1000;  { System File. }
  {$EXTERNALSYM IMAGE_FILE_SYSTEM}
  IMAGE_FILE_DLL                           = $2000;  { File is a DLL. }
  {$EXTERNALSYM IMAGE_FILE_DLL}
  IMAGE_FILE_UP_SYSTEM_ONLY                = $4000;  { File should only be run on a UP machine }
  {$EXTERNALSYM IMAGE_FILE_UP_SYSTEM_ONLY}
  IMAGE_FILE_BYTES_REVERSED_HI             = $8000;  { Bytes of machine word are reversed. }
  {$EXTERNALSYM IMAGE_FILE_BYTES_REVERSED_HI}

  IMAGE_FILE_MACHINE_UNKNOWN               = 0;
  {$EXTERNALSYM IMAGE_FILE_MACHINE_UNKNOWN}
  IMAGE_FILE_MACHINE_I386                  = $14c;   { Intel 386. }
  {$EXTERNALSYM IMAGE_FILE_MACHINE_I386}
  IMAGE_FILE_MACHINE_R3000                 = $162;   { MIPS little-endian, 0x160 big-endian }
  {$EXTERNALSYM IMAGE_FILE_MACHINE_R3000}
  IMAGE_FILE_MACHINE_R4000                 = $166;   { MIPS little-endian }
  {$EXTERNALSYM IMAGE_FILE_MACHINE_R4000}
  IMAGE_FILE_MACHINE_R10000                = $168;   { MIPS little-endian }
  {$EXTERNALSYM IMAGE_FILE_MACHINE_R10000}
  IMAGE_FILE_MACHINE_ALPHA                 = $184;   { Alpha_AXP }
  {$EXTERNALSYM IMAGE_FILE_MACHINE_ALPHA}
  IMAGE_FILE_MACHINE_POWERPC               = $1F0;   { IBM PowerPC Little-Endian }
  {$EXTERNALSYM IMAGE_FILE_MACHINE_POWERPC}

{ Directory format. }

type
  PImageDataDirectory = ^TImageDataDirectory;
  _IMAGE_DATA_DIRECTORY = record
    VirtualAddress: DWORD;
    Size: DWORD;
  end;
  {$EXTERNALSYM _IMAGE_DATA_DIRECTORY}
  TImageDataDirectory = _IMAGE_DATA_DIRECTORY;
  IMAGE_DATA_DIRECTORY = _IMAGE_DATA_DIRECTORY;
  {$EXTERNALSYM IMAGE_DATA_DIRECTORY}

const
  IMAGE_NUMBEROF_DIRECTORY_ENTRIES        = 16;
  {$EXTERNALSYM IMAGE_NUMBEROF_DIRECTORY_ENTRIES}

{ Optional header format. }

type
  PImageOptionalHeader = ^TImageOptionalHeader;
  _IMAGE_OPTIONAL_HEADER = packed record
    { Standard fields. }
    Magic: Word;
    MajorLinkerVersion: Byte;
    MinorLinkerVersion: Byte;
    SizeOfCode: DWORD;
    SizeOfInitializedData: DWORD;
    SizeOfUninitializedData: DWORD;
    AddressOfEntryPoint: DWORD;
    BaseOfCode: DWORD;
    BaseOfData: DWORD;
    { NT additional fields. }
    ImageBase: DWORD;
    SectionAlignment: DWORD;
    FileAlignment: DWORD;
    MajorOperatingSystemVersion: Word;
    MinorOperatingSystemVersion: Word;
    MajorImageVersion: Word;
    MinorImageVersion: Word;
    MajorSubsystemVersion: Word;
    MinorSubsystemVersion: Word;
    Win32VersionValue: DWORD;
    SizeOfImage: DWORD;
    SizeOfHeaders: DWORD;
    CheckSum: DWORD;
    Subsystem: Word;
    DllCharacteristics: Word;
    SizeOfStackReserve: DWORD;
    SizeOfStackCommit: DWORD;
    SizeOfHeapReserve: DWORD;
    SizeOfHeapCommit: DWORD;
    LoaderFlags: DWORD;
    NumberOfRvaAndSizes: DWORD;
    DataDirectory: packed array[0..IMAGE_NUMBEROF_DIRECTORY_ENTRIES-1] of TImageDataDirectory;
  end;
  {$EXTERNALSYM _IMAGE_OPTIONAL_HEADER}
  TImageOptionalHeader = _IMAGE_OPTIONAL_HEADER;
  IMAGE_OPTIONAL_HEADER = _IMAGE_OPTIONAL_HEADER;
  {$EXTERNALSYM IMAGE_OPTIONAL_HEADER}

  PImageRomOptionalHeader = ^TImageRomOptionalHeader;
  _IMAGE_ROM_OPTIONAL_HEADER = packed record
    Magic: Word;
    MajorLinkerVersion: Byte;
    MinorLinkerVersion: Byte;
    SizeOfCode: DWORD;
    SizeOfInitializedData: DWORD;
    SizeOfUninitializedData: DWORD;
    AddressOfEntryPoint: DWORD;
    BaseOfCode: DWORD;
    BaseOfData: DWORD;
    BaseOfBss: DWORD;
    GprMask: DWORD;
    CprMask: packed array[0..3] of DWORD;
    GpValue: DWORD;
  end;
  {$EXTERNALSYM _IMAGE_ROM_OPTIONAL_HEADER}
  TImageRomOptionalHeader = _IMAGE_ROM_OPTIONAL_HEADER;
  IMAGE_ROM_OPTIONAL_HEADER = _IMAGE_ROM_OPTIONAL_HEADER;
  {$EXTERNALSYM IMAGE_ROM_OPTIONAL_HEADER}


const
  IMAGE_SIZEOF_ROM_OPTIONAL_HEADER       = 56;
  {$EXTERNALSYM IMAGE_SIZEOF_ROM_OPTIONAL_HEADER}
  IMAGE_SIZEOF_STD_OPTIONAL_HEADER       = 28;
  {$EXTERNALSYM IMAGE_SIZEOF_STD_OPTIONAL_HEADER}
  IMAGE_SIZEOF_NT_OPTIONAL_HEADER        = 224;
  {$EXTERNALSYM IMAGE_SIZEOF_NT_OPTIONAL_HEADER}

  IMAGE_NT_OPTIONAL_HDR_MAGIC            = $010B;
  {$EXTERNALSYM IMAGE_NT_OPTIONAL_HDR_MAGIC}
  IMAGE_ROM_OPTIONAL_HDR_MAGIC           = $0107;
  {$EXTERNALSYM IMAGE_ROM_OPTIONAL_HDR_MAGIC}

type
  PImageNtHeaders = ^TImageNtHeaders;
  _IMAGE_NT_HEADERS = packed record
    Signature: DWORD;
    FileHeader: TImageFileHeader;
    OptionalHeader: TImageOptionalHeader;
  end;
  {$EXTERNALSYM _IMAGE_NT_HEADERS}
  TImageNtHeaders = _IMAGE_NT_HEADERS;
  IMAGE_NT_HEADERS = _IMAGE_NT_HEADERS;
  {$EXTERNALSYM IMAGE_NT_HEADERS}


  PImageRomHeaders = ^TImageRomHeaders;
  _IMAGE_ROM_HEADERS = packed record
    FileHeader: TImageFileHeader;
    OptionalHeader: TImageRomOptionalHeader;
  end;
  {$EXTERNALSYM _IMAGE_ROM_HEADERS}
  TImageRomHeaders = _IMAGE_ROM_HEADERS;
  IMAGE_ROM_HEADERS = _IMAGE_ROM_HEADERS;
  {$EXTERNALSYM IMAGE_ROM_HEADERS}


{ Subsystem Values }

const
  IMAGE_SUBSYSTEM_UNKNOWN                  = 0;  { Unknown subsystem. }
  {$EXTERNALSYM IMAGE_SUBSYSTEM_UNKNOWN}
  IMAGE_SUBSYSTEM_NATIVE                   = 1;  { Image doesn't require a subsystem. }
  {$EXTERNALSYM IMAGE_SUBSYSTEM_NATIVE}
  IMAGE_SUBSYSTEM_WINDOWS_GUI              = 2;  { Image runs in the Windows GUI subsystem. }
  {$EXTERNALSYM IMAGE_SUBSYSTEM_WINDOWS_GUI}
  IMAGE_SUBSYSTEM_WINDOWS_CUI              = 3;  { Image runs in the Windows character subsystem. }
  {$EXTERNALSYM IMAGE_SUBSYSTEM_WINDOWS_CUI}
  IMAGE_SUBSYSTEM_OS2_CUI                  = 5;  { image runs in the OS/2 character subsystem. }
  {$EXTERNALSYM IMAGE_SUBSYSTEM_OS2_CUI}
  IMAGE_SUBSYSTEM_POSIX_CUI                = 7;  { image run  in the Posix character subsystem. }
  {$EXTERNALSYM IMAGE_SUBSYSTEM_POSIX_CUI}
  IMAGE_SUBSYSTEM_RESERVED8                = 8;  { image run  in the 8 subsystem. }
  {$EXTERNALSYM IMAGE_SUBSYSTEM_RESERVED8}

{ DllCharacteristics Entries }

  IMAGE_LIBRARY_PROCESS_INIT                     = $1;    { Reserved. }
  {$EXTERNALSYM IMAGE_LIBRARY_PROCESS_INIT}
  IMAGE_LIBRARY_PROCESS_TERM                     = $2;    { Reserved. }
  {$EXTERNALSYM IMAGE_LIBRARY_PROCESS_TERM}
  IMAGE_LIBRARY_THREAD_INIT                      = $4;    { Reserved. }
  {$EXTERNALSYM IMAGE_LIBRARY_THREAD_INIT}
  IMAGE_LIBRARY_THREAD_TERM                      = $8;    { Reserved. }
  {$EXTERNALSYM IMAGE_LIBRARY_THREAD_TERM}
  IMAGE_DLLCHARACTERISTICS_NO_BIND               = $800;  { Do not bind this image. }
  {$EXTERNALSYM IMAGE_DLLCHARACTERISTICS_NO_BIND}
  //                                             = $1000; { Reserved. }
  IMAGE_DLLCHARACTERISTICS_WDM_DRIVER            = $2000; { Driver uses WDM model }
  {$EXTERNALSYM IMAGE_DLLCHARACTERISTICS_WDM_DRIVER}
  //                                             = $4000; { Reserved. }
  IMAGE_DLLCHARACTERISTICS_TERMINAL_SERVER_AWARE = $8000;
  {$EXTERNALSYM IMAGE_DLLCHARACTERISTICS_TERMINAL_SERVER_AWARE}


{ Directory Entries }

  IMAGE_DIRECTORY_ENTRY_EXPORT             = 0;  { Export Directory }
  {$EXTERNALSYM IMAGE_DIRECTORY_ENTRY_EXPORT}
  IMAGE_DIRECTORY_ENTRY_IMPORT             = 1;  { Import Directory }
  {$EXTERNALSYM IMAGE_DIRECTORY_ENTRY_IMPORT}
  IMAGE_DIRECTORY_ENTRY_RESOURCE           = 2;  { Resource Directory }
  {$EXTERNALSYM IMAGE_DIRECTORY_ENTRY_RESOURCE}
  IMAGE_DIRECTORY_ENTRY_EXCEPTION          = 3;  { Exception Directory }
  {$EXTERNALSYM IMAGE_DIRECTORY_ENTRY_EXCEPTION}
  IMAGE_DIRECTORY_ENTRY_SECURITY           = 4;  { Security Directory }
  {$EXTERNALSYM IMAGE_DIRECTORY_ENTRY_SECURITY}
  IMAGE_DIRECTORY_ENTRY_BASERELOC          = 5;  { Base Relocation Table }
  {$EXTERNALSYM IMAGE_DIRECTORY_ENTRY_BASERELOC}
  IMAGE_DIRECTORY_ENTRY_DEBUG              = 6;  { Debug Directory }
  {$EXTERNALSYM IMAGE_DIRECTORY_ENTRY_DEBUG}
  IMAGE_DIRECTORY_ENTRY_COPYRIGHT          = 7;  { Description String }
  {$EXTERNALSYM IMAGE_DIRECTORY_ENTRY_COPYRIGHT}
  IMAGE_DIRECTORY_ENTRY_GLOBALPTR          = 8;  { Machine Value (MIPS GP) }
  {$EXTERNALSYM IMAGE_DIRECTORY_ENTRY_GLOBALPTR}
  IMAGE_DIRECTORY_ENTRY_TLS                = 9;  { TLS Directory }
  {$EXTERNALSYM IMAGE_DIRECTORY_ENTRY_TLS}
  IMAGE_DIRECTORY_ENTRY_LOAD_CONFIG       = 10;  { Load Configuration Directory }
  {$EXTERNALSYM IMAGE_DIRECTORY_ENTRY_LOAD_CONFIG}
  IMAGE_DIRECTORY_ENTRY_BOUND_IMPORT      = 11;  { Bound Import Directory in headers }
  {$EXTERNALSYM IMAGE_DIRECTORY_ENTRY_BOUND_IMPORT}
  IMAGE_DIRECTORY_ENTRY_IAT               = 12;  { Import Address Table }
  {$EXTERNALSYM IMAGE_DIRECTORY_ENTRY_IAT}
  IMAGE_DIRECTORY_ENTRY_DELAY_IMPORT      = 13;  { Delay Load Import Descriptors }
  {$EXTERNALSYM IMAGE_DIRECTORY_ENTRY_DELAY_IMPORT}
  IMAGE_DIRECTORY_ENTRY_COM_DESCRIPTOR    = 14;  { COM Runtime descriptor }
  {$EXTERNALSYM IMAGE_DIRECTORY_ENTRY_COM_DESCRIPTOR}

{ Section header format. }

  IMAGE_SIZEOF_SHORT_NAME                  = 8;
  {$EXTERNALSYM IMAGE_SIZEOF_SHORT_NAME}

type
  TISHMisc = packed record
    case Integer of
      0: (PhysicalAddress: DWORD);
      1: (VirtualSize: DWORD);
  end;

  PPImageSectionHeader = ^PImageSectionHeader;
  PImageSectionHeader = ^TImageSectionHeader;
  _IMAGE_SECTION_HEADER = packed record
    Name: packed array[0..IMAGE_SIZEOF_SHORT_NAME-1] of Byte;
    Misc: TISHMisc;
    VirtualAddress: DWORD;
    SizeOfRawData: DWORD;
    PointerToRawData: DWORD;
    PointerToRelocations: DWORD;
    PointerToLinenumbers: DWORD;
    NumberOfRelocations: Word;
    NumberOfLinenumbers: Word;
    Characteristics: DWORD;
  end;
  {$EXTERNALSYM _IMAGE_SECTION_HEADER}
  TImageSectionHeader = _IMAGE_SECTION_HEADER;
  IMAGE_SECTION_HEADER = _IMAGE_SECTION_HEADER;
  {$EXTERNALSYM IMAGE_SECTION_HEADER}


const
  IMAGE_SIZEOF_SECTION_HEADER              = 40;
  {$EXTERNALSYM IMAGE_SIZEOF_SECTION_HEADER}


{ Section characteristics. }

{      IMAGE_SCN_TYPE_REG                   0x00000000  // Reserved. }
{      IMAGE_SCN_TYPE_DSECT                 0x00000001  // Reserved. }
{      IMAGE_SCN_TYPE_NOLOAD                0x00000002  // Reserved. }
{      IMAGE_SCN_TYPE_GROUP                 0x00000004  // Reserved. }
  IMAGE_SCN_TYPE_NO_PAD                    = $00000008;  { Reserved. }
  {$EXTERNALSYM IMAGE_SCN_TYPE_NO_PAD}
{      IMAGE_SCN_TYPE_COPY                  0x00000010  // Reserved. }

  IMAGE_SCN_CNT_CODE                       = $00000020;  { Section contains code. }
  {$EXTERNALSYM IMAGE_SCN_CNT_CODE}
  IMAGE_SCN_CNT_INITIALIZED_DATA           = $00000040;  { Section contains initialized data. }
  {$EXTERNALSYM IMAGE_SCN_CNT_INITIALIZED_DATA}
  IMAGE_SCN_CNT_UNINITIALIZED_DATA         = $00000080;  { Section contains uninitialized data. }
  {$EXTERNALSYM IMAGE_SCN_CNT_UNINITIALIZED_DATA}

  IMAGE_SCN_LNK_OTHER                      = $00000100;  { Reserved. }
  {$EXTERNALSYM IMAGE_SCN_LNK_OTHER}
  IMAGE_SCN_LNK_INFO                       = $00000200;  { Section contains comments or some other type of information. }
  {$EXTERNALSYM IMAGE_SCN_LNK_INFO}
{      IMAGE_SCN_TYPE_OVER                  0x00000400  // Reserved. }
  IMAGE_SCN_LNK_REMOVE                     = $00000800;  { Section contents will not become part of image. }
  {$EXTERNALSYM IMAGE_SCN_LNK_REMOVE}
  IMAGE_SCN_LNK_COMDAT                     = $00001000;  { Section contents comdat. }
  {$EXTERNALSYM IMAGE_SCN_LNK_COMDAT}
{                                           0x00002000  // Reserved. }

{      IMAGE_SCN_MEM_PROTECTED - Obsolete   0x00004000 }
  IMAGE_SCN_MEM_FARDATA                    = $00008000;
  {$EXTERNALSYM IMAGE_SCN_MEM_FARDATA}
{      IMAGE_SCN_MEM_SYSHEAP  - Obsolete    0x00010000 }
  IMAGE_SCN_MEM_PURGEABLE                  = $00020000;
  {$EXTERNALSYM IMAGE_SCN_MEM_PURGEABLE}
  IMAGE_SCN_MEM_16BIT                      = $00020000;
  {$EXTERNALSYM IMAGE_SCN_MEM_16BIT}
  IMAGE_SCN_MEM_LOCKED                     = $00040000;
  {$EXTERNALSYM IMAGE_SCN_MEM_LOCKED}
  IMAGE_SCN_MEM_PRELOAD                    = $00080000;
  {$EXTERNALSYM IMAGE_SCN_MEM_PRELOAD}

  IMAGE_SCN_ALIGN_1BYTES                   = $00100000;
  {$EXTERNALSYM IMAGE_SCN_ALIGN_1BYTES}
  IMAGE_SCN_ALIGN_2BYTES                   = $00200000;
  {$EXTERNALSYM IMAGE_SCN_ALIGN_2BYTES}
  IMAGE_SCN_ALIGN_4BYTES                   = $00300000;
  {$EXTERNALSYM IMAGE_SCN_ALIGN_4BYTES}
  IMAGE_SCN_ALIGN_8BYTES                   = $00400000;
  {$EXTERNALSYM IMAGE_SCN_ALIGN_8BYTES}
  IMAGE_SCN_ALIGN_16BYTES                  = $00500000;  { Default alignment if no others are specified. }
  {$EXTERNALSYM IMAGE_SCN_ALIGN_16BYTES}
  IMAGE_SCN_ALIGN_32BYTES                  = $00600000;
  {$EXTERNALSYM IMAGE_SCN_ALIGN_32BYTES}
  IMAGE_SCN_ALIGN_64BYTES                  = $00700000;
  {$EXTERNALSYM IMAGE_SCN_ALIGN_64BYTES}
{ Unused                                    0x00800000 }

  IMAGE_SCN_LNK_NRELOC_OVFL                = $01000000;  { Section contains extended relocations. }
  {$EXTERNALSYM IMAGE_SCN_LNK_NRELOC_OVFL}
  IMAGE_SCN_MEM_DISCARDABLE                = $02000000;  { Section can be discarded. }
  {$EXTERNALSYM IMAGE_SCN_MEM_DISCARDABLE}
  IMAGE_SCN_MEM_NOT_CACHED                 = $04000000;  { Section is not cachable. }
  {$EXTERNALSYM IMAGE_SCN_MEM_NOT_CACHED}
  IMAGE_SCN_MEM_NOT_PAGED                  = $08000000;  { Section is not pageable. }
  {$EXTERNALSYM IMAGE_SCN_MEM_NOT_PAGED}
  IMAGE_SCN_MEM_SHARED                     = $10000000;  { Section is shareable. }
  {$EXTERNALSYM IMAGE_SCN_MEM_SHARED}
  IMAGE_SCN_MEM_EXECUTE                    = $20000000;  { Section is executable. }
  {$EXTERNALSYM IMAGE_SCN_MEM_EXECUTE}
  IMAGE_SCN_MEM_READ                       = $40000000;  { Section is readable. }
  {$EXTERNALSYM IMAGE_SCN_MEM_READ}
  IMAGE_SCN_MEM_WRITE                      = DWORD($80000000);  { Section is writeable. }
  {$EXTERNALSYM IMAGE_SCN_MEM_WRITE}


{line 4281}
type
  PImageLoadConfigDirectory = ^TImageLoadConfigDirectory;
  IMAGE_LOAD_CONFIG_DIRECTORY = packed record
    Characteristics: DWORD;
    TimeDateStamp: DWORD;
    MajorVersion: Word;
    MinorVersion: Word;
    GlobalFlagsClear: DWORD;
    GlobalFlagsSet: DWORD;
    CriticalSectionDefaultTimeout: DWORD;
    DeCommitFreeBlockThreshold: DWORD;
    DeCommitTotalFreeThreshold: DWORD;
    LockPrefixTable: Pointer;
    MaximumAllocationSize: DWORD;
    VirtualMemoryThreshold: DWORD;
    ProcessHeapFlags: DWORD;
    ProcessAffinityMask: DWORD;
    Reserved: array[0..2] of DWORD;
  end;
  {$EXTERNALSYM IMAGE_LOAD_CONFIG_DIRECTORY}
  TImageLoadConfigDirectory = IMAGE_LOAD_CONFIG_DIRECTORY;
//  IMAGE_LOAD_CONFIG_DIRECTORY = _IMAGE_LOAD_CONFIG_DIRECTORY;
//  {$EXTERNALSYM IMAGE_LOAD_CONFIG_DIRECTORY}


// Function table entry format for MIPS/ALPHA images.  Function table is
// pointed to by the IMAGE_DIRECTORY_ENTRY_EXCEPTION directory entry.
// This definition duplicates ones in ntmips.h and ntalpha.h for use
// by portable image file mungers.

  PImageRuntimeFunctionEntry = ^TImageRuntimeFunctionEntry;
  IMAGE_RUNTIME_FUNCTION_ENTRY = record
    BeginAddress: DWORD;
    EndAddress: DWORD;
    ExceptionHandler: Pointer;
    HandlerData: Pointer;
    PrologEndAddress: DWORD;
  end;
  {$EXTERNALSYM IMAGE_RUNTIME_FUNCTION_ENTRY}
  TImageRuntimeFunctionEntry = IMAGE_RUNTIME_FUNCTION_ENTRY;
// IMAGE_RUNTIME_FUNCTION_ENTRY = _IMAGE_RUNTIME_FUNCTION_ENTRY;
// {$EXTERNALSYM IMAGE_RUNTIME_FUNCTION_ENTRY}


//
// Debug Format
//

  PImageDebugDirectory = ^TImageDebugDirectory;
  _IMAGE_DEBUG_DIRECTORY = packed record
    Characteristics: DWORD;
    TimeDateStamp: DWORD;
    MajorVersion: Word;
    MinorVersion: Word;
    _Type: DWORD;
    SizeOfData: DWORD;
    AddressOfRawData: DWORD;
    PointerToRawData: DWORD;
  end;
  {$EXTERNALSYM _IMAGE_DEBUG_DIRECTORY}
  TImageDebugDirectory = _IMAGE_DEBUG_DIRECTORY;
  IMAGE_DEBUG_DIRECTORY = _IMAGE_DEBUG_DIRECTORY;
  {$EXTERNALSYM IMAGE_DEBUG_DIRECTORY}


const
  IMAGE_DEBUG_TYPE_UNKNOWN          = 0;
  {$EXTERNALSYM IMAGE_DEBUG_TYPE_UNKNOWN}
  IMAGE_DEBUG_TYPE_COFF             = 1;
  {$EXTERNALSYM IMAGE_DEBUG_TYPE_COFF}
  IMAGE_DEBUG_TYPE_CODEVIEW         = 2;
  {$EXTERNALSYM IMAGE_DEBUG_TYPE_CODEVIEW}
  IMAGE_DEBUG_TYPE_FPO              = 3;
  {$EXTERNALSYM IMAGE_DEBUG_TYPE_FPO}
  IMAGE_DEBUG_TYPE_MISC             = 4;
  {$EXTERNALSYM IMAGE_DEBUG_TYPE_MISC}
  IMAGE_DEBUG_TYPE_EXCEPTION        = 5;
  {$EXTERNALSYM IMAGE_DEBUG_TYPE_EXCEPTION}
  IMAGE_DEBUG_TYPE_FIXUP            = 6;
  {$EXTERNALSYM IMAGE_DEBUG_TYPE_FIXUP}
  IMAGE_DEBUG_TYPE_OMAP_TO_SRC      = 7;
  {$EXTERNALSYM IMAGE_DEBUG_TYPE_OMAP_TO_SRC}
  IMAGE_DEBUG_TYPE_OMAP_FROM_SRC    = 8;
  {$EXTERNALSYM IMAGE_DEBUG_TYPE_OMAP_FROM_SRC}

type
  PImageCOFFSymbolsHeader = ^TImageCOFFSymbolsHeader;
  _IMAGE_COFF_SYMBOLS_HEADER = record
    NumberOfSymbols: DWORD;
    LvaToFirstSymbol: DWORD;
    NumberOfLinenumbers: DWORD;
    LvaToFirstLinenumber: DWORD;
    RvaToFirstByteOfCode: DWORD;
    RvaToLastByteOfCode: DWORD;
    RvaToFirstByteOfData: DWORD;
    RvaToLastByteOfData: DWORD;
  end;
  {$EXTERNALSYM _IMAGE_COFF_SYMBOLS_HEADER}
  TImageCOFFSymbolsHeader = _IMAGE_COFF_SYMBOLS_HEADER;
  IMAGE_COFF_SYMBOLS_HEADER = _IMAGE_COFF_SYMBOLS_HEADER;
  {$EXTERNALSYM IMAGE_COFF_SYMBOLS_HEADER}


const
  FRAME_FPO       = 0;
  {$EXTERNALSYM FRAME_FPO}
  FRAME_TRAP      = 1;
  {$EXTERNALSYM FRAME_TRAP}
  FRAME_TSS       = 2;
  {$EXTERNALSYM FRAME_TSS}
  FRAME_NONFPO    = 3;
  {$EXTERNALSYM FRAME_NONFPO}

type
  PFpoData = ^TFpoData;
  _FPO_DATA = packed record
    ulOffStart: DWORD;             // offset 1st byte of function code
    cbProcSize: DWORD;             // # bytes in function
    cdwLocals: DWORD;              // # bytes in locals/4
    cdwParams: Word;              // # bytes in params/4
{    WORD        cbProlog : 8;           // # bytes in prolog
     WORD        cbRegs   : 3;           // # regs saved
     WORD        fHasSEH  : 1;           // TRUE if SEH in func
     WORD        fUseBP   : 1;           // TRUE if EBP has been allocated
     WORD        reserved : 1;           // reserved for future use
     WORD        cbFrame  : 2;}           // frame type
     cbProlog: Byte;
     OtherStuff: Byte;
  end;
  {$EXTERNALSYM _FPO_DATA}
  TFpoData = _FPO_DATA;
  FPO_DATA = _FPO_DATA;
  {$EXTERNALSYM FPO_DATA}


const
  SIZEOF_RFPO_DATA         = 16;
  {$EXTERNALSYM SIZEOF_RFPO_DATA}
  IMAGE_DEBUG_MISC_EXENAME = 1;
  {$EXTERNALSYM IMAGE_DEBUG_MISC_EXENAME}

type
  PImageDebugMisc = ^TImageDebugMisc;
  _IMAGE_DEBUG_MISC = packed record
    DataType: DWORD;               // type of misc data, see defines
    Length: DWORD;                 // total length of record, rounded to four
                                   // byte multiple.
    Unicode: ByteBool;             // TRUE if data is unicode string
    Reserved: array[0..2] of Byte;
    Data: array[0..0] of Byte;     // Actual data
  end;
  {$EXTERNALSYM _IMAGE_DEBUG_MISC}
  TImageDebugMisc = _IMAGE_DEBUG_MISC;
  IMAGE_DEBUG_MISC = _IMAGE_DEBUG_MISC;
  {$EXTERNALSYM IMAGE_DEBUG_MISC}


//
// Function table extracted from MIPS/ALPHA images.  Does not contain
// information needed only for runtime support.  Just those fields for
// each entry needed by a debugger.
//
  PImageFunctionEntry = ^TImageFunctionEntry;
  _IMAGE_FUNCTION_ENTRY = record
    StartingAddress: DWORD;
    EndingAddress: DWORD;
    EndOfPrologue: DWORD;
  end;
  {$EXTERNALSYM _IMAGE_FUNCTION_ENTRY}
  TImageFunctionEntry = _IMAGE_FUNCTION_ENTRY;
  IMAGE_FUNCTION_ENTRY = _IMAGE_FUNCTION_ENTRY;
  {$EXTERNALSYM IMAGE_FUNCTION_ENTRY}


{line 4587}
type
  PRTLCriticalSection = ^TRTLCriticalSection;
  PRTLCriticalSectionDebug = ^TRTLCriticalSectionDebug;
  _RTL_CRITICAL_SECTION_DEBUG = record
    Type_18: Word;
    CreatorBackTraceIndex: Word;
    CriticalSection: PRTLCriticalSection;
    ProcessLocksList: TListEntry;
    EntryCount: DWORD;
    ContentionCount: DWORD;
    Spare: array[0..1] of DWORD;
  end;
  {$EXTERNALSYM _RTL_CRITICAL_SECTION_DEBUG}
  TRTLCriticalSectionDebug = _RTL_CRITICAL_SECTION_DEBUG;
  RTL_CRITICAL_SECTION_DEBUG = _RTL_CRITICAL_SECTION_DEBUG;
  {$EXTERNALSYM RTL_CRITICAL_SECTION_DEBUG}

  _RTL_CRITICAL_SECTION = record
    DebugInfo: PRTLCriticalSectionDebug;
    LockCount: Longint;
    RecursionCount: Longint;
    OwningThread: THandle;
    LockSemaphore: THandle;
    Reserved: DWORD;
  end;
  {$EXTERNALSYM _RTL_CRITICAL_SECTION}
  TRTLCriticalSection = _RTL_CRITICAL_SECTION;
  RTL_CRITICAL_SECTION = _RTL_CRITICAL_SECTION;
  {$EXTERNALSYM RTL_CRITICAL_SECTION}





const
  RTL_CRITSECT_TYPE = 0;
  {$EXTERNALSYM RTL_CRITSECT_TYPE}
  RTL_RESOURCE_TYPE = 1;
  {$EXTERNALSYM RTL_RESOURCE_TYPE}


  DLL_PROCESS_ATTACH = 1;
  {$EXTERNALSYM DLL_PROCESS_ATTACH}
  DLL_THREAD_ATTACH = 2;
  {$EXTERNALSYM DLL_THREAD_ATTACH}
  DLL_THREAD_DETACH = 3;
  {$EXTERNALSYM DLL_THREAD_DETACH}
  DLL_PROCESS_DETACH = 0;
  {$EXTERNALSYM DLL_PROCESS_DETACH}

{line 4630}

{ The types of events that can be logged. }

  EVENTLOG_SUCCESS          = $0000;
  {$EXTERNALSYM EVENTLOG_SUCCESS}
  EVENTLOG_ERROR_TYPE       = $0001;
  {$EXTERNALSYM EVENTLOG_ERROR_TYPE}
  EVENTLOG_WARNING_TYPE     = $0002;
  {$EXTERNALSYM EVENTLOG_WARNING_TYPE}
  EVENTLOG_INFORMATION_TYPE = $0004;
  {$EXTERNALSYM EVENTLOG_INFORMATION_TYPE}
  EVENTLOG_AUDIT_SUCCESS    = $0008;
  {$EXTERNALSYM EVENTLOG_AUDIT_SUCCESS}
  EVENTLOG_AUDIT_FAILURE    = $0010;
  {$EXTERNALSYM EVENTLOG_AUDIT_FAILURE}

{line 4700}

{ Registry Specific Access Rights. }

  KEY_QUERY_VALUE    = $0001;
  {$EXTERNALSYM KEY_QUERY_VALUE}
  KEY_SET_VALUE      = $0002;
  {$EXTERNALSYM KEY_SET_VALUE}
  KEY_CREATE_SUB_KEY = $0004;
  {$EXTERNALSYM KEY_CREATE_SUB_KEY}
  KEY_ENUMERATE_SUB_KEYS = $0008;
  {$EXTERNALSYM KEY_ENUMERATE_SUB_KEYS}
  KEY_NOTIFY         = $0010;
  {$EXTERNALSYM KEY_NOTIFY}
  KEY_CREATE_LINK    = $0020;
  {$EXTERNALSYM KEY_CREATE_LINK}


  KEY_READ           = (STANDARD_RIGHTS_READ or
                        KEY_QUERY_VALUE or
                        KEY_ENUMERATE_SUB_KEYS or
                        KEY_NOTIFY) and not
                        SYNCHRONIZE;
  {$EXTERNALSYM KEY_READ}



  KEY_WRITE          = (STANDARD_RIGHTS_WRITE or
                        KEY_SET_VALUE or
                        KEY_CREATE_SUB_KEY) and not
                        SYNCHRONIZE;
  {$EXTERNALSYM KEY_WRITE}

  KEY_EXECUTE        =  KEY_READ and not SYNCHRONIZE;
  {$EXTERNALSYM KEY_EXECUTE}


  KEY_ALL_ACCESS     = (STANDARD_RIGHTS_ALL or
                        KEY_QUERY_VALUE or
                        KEY_SET_VALUE or
                        KEY_CREATE_SUB_KEY or
                        KEY_ENUMERATE_SUB_KEYS or
                        KEY_NOTIFY or
                        KEY_CREATE_LINK) and not
                        SYNCHRONIZE;
  {$EXTERNALSYM KEY_ALL_ACCESS}

  { Registry Open/Create Options }

  REG_OPTION_RESERVED     = ($00000000);    { Parameter is reserved }
  {$EXTERNALSYM REG_OPTION_RESERVED}

  REG_OPTION_NON_VOLATILE = ($00000000);    { Key is preserved }
  {$EXTERNALSYM REG_OPTION_NON_VOLATILE}
                                            { when system is rebooted }

  REG_OPTION_VOLATILE     = ($00000001);    { Key is not preserved }
  {$EXTERNALSYM REG_OPTION_VOLATILE}
                                            { when system is rebooted }

  REG_OPTION_CREATE_LINK  = ($00000002);    { Created key is a }
  {$EXTERNALSYM REG_OPTION_CREATE_LINK}
                                            { symbolic link }

  REG_OPTION_BACKUP_RESTORE = ($00000004);  { open for backup or restore }
  {$EXTERNALSYM REG_OPTION_BACKUP_RESTORE}
                                            { special access rules }
                                            { privilege required   }

  REG_LEGAL_OPTION  = (REG_OPTION_RESERVED or
  {$EXTERNALSYM REG_LEGAL_OPTION}
                       REG_OPTION_NON_VOLATILE or
                       REG_OPTION_VOLATILE or
                       REG_OPTION_CREATE_LINK or
                       REG_OPTION_BACKUP_RESTORE);

  { Registry Key creation/open disposition }

  REG_CREATED_NEW_KEY     = ($00000001);    { New Registry Key created }
  {$EXTERNALSYM REG_CREATED_NEW_KEY}
  REG_OPENED_EXISTING_KEY = ($00000002);    { Existing Key opened }
  {$EXTERNALSYM REG_OPENED_EXISTING_KEY}

  { Registry Key restore flags }

  REG_WHOLE_HIVE_VOLATILE = ($00000001);    { Restore whole hive volatile }
  {$EXTERNALSYM REG_WHOLE_HIVE_VOLATILE}
  REG_REFRESH_HIVE        = ($00000002);    { Unwind changes to last flush }
  {$EXTERNALSYM REG_REFRESH_HIVE}

  { Registry Notify filter values }

  REG_NOTIFY_CHANGE_NAME       = ($00000001); { Create or delete (child) }
  {$EXTERNALSYM REG_NOTIFY_CHANGE_NAME}
  REG_NOTIFY_CHANGE_ATTRIBUTES = ($00000002);
  {$EXTERNALSYM REG_NOTIFY_CHANGE_ATTRIBUTES}
  REG_NOTIFY_CHANGE_LAST_SET   = ($00000004); { time stamp }
  {$EXTERNALSYM REG_NOTIFY_CHANGE_LAST_SET}
  REG_NOTIFY_CHANGE_SECURITY   = ($00000008);
  {$EXTERNALSYM REG_NOTIFY_CHANGE_SECURITY}

  REG_LEGAL_CHANGE_FILTER = (REG_OPTION_RESERVED or
                             REG_NOTIFY_CHANGE_NAME or
                             REG_NOTIFY_CHANGE_ATTRIBUTES or
                             REG_NOTIFY_CHANGE_LAST_SET or
                             REG_NOTIFY_CHANGE_SECURITY);
  {$EXTERNALSYM REG_LEGAL_CHANGE_FILTER}

  { Registry Predefined Value Types }

  REG_NONE                    = 0;
  {$EXTERNALSYM REG_NONE}
  REG_SZ                      = 1;
  {$EXTERNALSYM REG_SZ}
  REG_EXPAND_SZ               = 2;
  {$EXTERNALSYM REG_EXPAND_SZ}
  REG_BINARY                  = 3;
  {$EXTERNALSYM REG_BINARY}
  REG_DWORD                   = 4;
  {$EXTERNALSYM REG_DWORD}
  REG_DWORD_LITTLE_ENDIAN     = 4;
  {$EXTERNALSYM REG_DWORD_LITTLE_ENDIAN}
  REG_DWORD_BIG_ENDIAN        = 5;
  {$EXTERNALSYM REG_DWORD_BIG_ENDIAN}
  REG_LINK                    = 6;
  {$EXTERNALSYM REG_LINK}
  REG_MULTI_SZ                = 7;
  {$EXTERNALSYM REG_MULTI_SZ}
  REG_RESOURCE_LIST           = 8;
  {$EXTERNALSYM REG_RESOURCE_LIST}
  REG_FULL_RESOURCE_DESCRIPTOR = 9;
  {$EXTERNALSYM REG_FULL_RESOURCE_DESCRIPTOR}
  REG_RESOURCE_REQUIREMENTS_LIST = 10;
  {$EXTERNALSYM REG_RESOURCE_REQUIREMENTS_LIST}

{ END Translated from WINNT.H }

type
  WPARAM = Longint;
  {$EXTERNALSYM WPARAM}
  LPARAM = Longint;
  {$EXTERNALSYM LPARAM}
  LRESULT = Longint;
  {$EXTERNALSYM LRESULT}

function MakeWord(a, b: Byte): Word; inline;
{$EXTERNALSYM MakeWord}
function MakeLong(a, b: Word): Longint; inline;
{$EXTERNALSYM MakeLong}

type
  LOWORD = Word;
  {$EXTERNALSYM LOWORD}

function HiWord(l: DWORD): Word; inline;
{$EXTERNALSYM HiWord}

type
  LOBYTE = Byte;
  {$EXTERNALSYM LOBYTE}

function HiByte(W: Word): Byte; inline;
{$EXTERNALSYM HiByte}

type
















  HWND = type LongWord;
  {$EXTERNALSYM HWND}
  HHOOK = type LongWord;
  {$EXTERNALSYM HHOOK}


  ATOM = Word;
  {$EXTERNALSYM ATOM}
  TAtom = Word;

  HGLOBAL = THandle;
  {$EXTERNALSYM HGLOBAL}
  HLOCAL = THandle;
  {$EXTERNALSYM HLOCAL}
  FARPROC = Pointer;
  {$EXTERNALSYM FARPROC}
  TFarProc = Pointer;
  PROC_22 = Pointer;


















































































































  HGDIOBJ = type LongWord;
  {$EXTERNALSYM HGDIOBJ}
  HACCEL = type LongWord;
  {$EXTERNALSYM HACCEL}
  HBITMAP = type LongWord;
  {$EXTERNALSYM HBITMAP}
  HBRUSH = type LongWord;
  {$EXTERNALSYM HBRUSH}
  HCOLORSPACE = type LongWord;
  {$EXTERNALSYM HCOLORSPACE}
  HDC = type LongWord;
  {$EXTERNALSYM HDC}
  HGLRC = type LongWord;
  {$EXTERNALSYM HGLRC}
  HDESK = type LongWord;
  {$EXTERNALSYM HDESK}
  HENHMETAFILE = type LongWord;
  {$EXTERNALSYM HENHMETAFILE}
  HFONT = type LongWord;
  {$EXTERNALSYM HFONT}
  HICON = type LongWord;
  {$EXTERNALSYM HICON}
  HMENU = type LongWord;
  {$EXTERNALSYM HMENU}
  HMETAFILE = type LongWord;
  {$EXTERNALSYM HMETAFILE}
  HINST = System.HINST;
  HMODULE = System.HMODULE;      { HMODULEs can be used in place of HINSTs }
  {$EXTERNALSYM HMODULE}
  HPALETTE = type LongWord;
  {$EXTERNALSYM HPALETTE}
  HPEN = type LongWord;
  {$EXTERNALSYM HPEN}
  HRGN = type LongWord;
  {$EXTERNALSYM HRGN}
  HRSRC = System.HRSRC;
  {$EXTERNALSYM HRSRC}
  HSTR = type LongWord;
  {$EXTERNALSYM HSTR}
  HTASK = type LongWord;
  {$EXTERNALSYM HTASK}
  HWINSTA = type LongWord;
  {$EXTERNALSYM HWINSTA}
  HKL = type LongWord;
  {$EXTERNALSYM HKL}



  HFILE = LongWord;
  {$EXTERNALSYM HFILE}
  HCURSOR = HICON;              { HICONs & HCURSORs are polymorphic }
  {$EXTERNALSYM HCURSOR}

  COLORREF = DWORD;
  {$EXTERNALSYM COLORREF}
  TColorRef = DWORD;

const
  HFILE_ERROR = HFILE(-1);
  {$EXTERNALSYM HFILE_ERROR}

type
  PPoint = Types.PPoint;
  TPoint = Types.TPoint;
  {$NODEFINE TPoint}
  {$NODEFINE PPoint}
  tagPoint = Types.tagPoint;
  {$NODEFINE tagPoint}
  PRect = Types.PRect;
  TRect = Types.TRect;
  {$NODEFINE TRect}
  {$NODEFINE PRect}

type
  _POINTL = packed record      { ptl }
    x: Longint;
    y: Longint;
  end;
  {$EXTERNALSYM _POINTL}
  PPointL = ^TPointL;
  TPointL = _POINTL;

  PSize = Types.PSize;
  {$EXTERNALSYM PSize}
  TSize = Types.TSize;
  {$EXTERNALSYM TSize}
  SIZE = Types.SIZE;
  {$EXTERNALSYM SIZE}

  PSmallPoint = Types.PSmallPoint;
  {$EXTERNALSYM PSmallPoint}
  TSmallPoint = Types.TSmallPoint;
  {$EXTERNALSYM TSmallPoint}
{ Translated from WINBASE.H }

{ Compatiblity functions and procedures }

function DefineHandleTable(Offset: Word): Bool; inline;
{$EXTERNALSYM DefineHandleTable}
procedure LimitEmsPages(Kbytes: Longint); inline;
{$EXTERNALSYM LimitEmsPages}
function SetSwapAreaSize(Size: Word): Longint; inline;
{$EXTERNALSYM SetSwapAreaSize}
procedure LockSegment(Segment: THandle); inline;
{$EXTERNALSYM LockSegment}
procedure UnlockSegment(Segment: THandle); inline;
{$EXTERNALSYM UnlockSegment}
function GetCurrentTime: DWORD; inline;
{$EXTERNALSYM GetCurrentTime}
function Yield: Bool; inline;
{$EXTERNALSYM Yield}

const
  INVALID_HANDLE_VALUE = DWORD(-1);
  {$EXTERNALSYM INVALID_HANDLE_VALUE}
  INVALID_FILE_SIZE = DWORD($FFFFFFFF);
  {$EXTERNALSYM INVALID_FILE_SIZE}

  FILE_BEGIN = 0;
  {$EXTERNALSYM FILE_BEGIN}
  FILE_CURRENT = 1;
  {$EXTERNALSYM FILE_CURRENT}
  FILE_END = 2;
  {$EXTERNALSYM FILE_END}

  TIME_ZONE_ID_INVALID = DWORD($FFFFFFFF);
  {$EXTERNALSYM TIME_ZONE_ID_INVALID}
  TIME_ZONE_ID_UNKNOWN  = 0;
  {$EXTERNALSYM TIME_ZONE_ID_UNKNOWN}
  TIME_ZONE_ID_STANDARD = 1;
  {$EXTERNALSYM TIME_ZONE_ID_STANDARD}
  TIME_ZONE_ID_DAYLIGHT = 2;
  {$EXTERNALSYM TIME_ZONE_ID_DAYLIGHT}


  WAIT_FAILED  = DWORD($FFFFFFFF);
  {$EXTERNALSYM WAIT_FAILED}
  WAIT_OBJECT_0 = ((STATUS_WAIT_0 ) + 0 );
  {$EXTERNALSYM WAIT_OBJECT_0}

  WAIT_ABANDONED = ((STATUS_ABANDONED_WAIT_0 ) + 0 );
  {$EXTERNALSYM WAIT_ABANDONED}
  WAIT_ABANDONED_0 = ((STATUS_ABANDONED_WAIT_0 ) + 0 );
  {$EXTERNALSYM WAIT_ABANDONED_0}

  WAIT_TIMEOUT = STATUS_TIMEOUT;
  {$EXTERNALSYM WAIT_TIMEOUT}
  WAIT_IO_COMPLETION = STATUS_USER_APC;
  {$EXTERNALSYM WAIT_IO_COMPLETION}
  STILL_ACTIVE = STATUS_PENDING;
  {$EXTERNALSYM STILL_ACTIVE}
  EXCEPTION_ACCESS_VIOLATION = STATUS_ACCESS_VIOLATION;
  {$EXTERNALSYM EXCEPTION_ACCESS_VIOLATION}
  EXCEPTION_DATATYPE_MISALIGNMENT = STATUS_DATATYPE_MISALIGNMENT;
  {$EXTERNALSYM EXCEPTION_DATATYPE_MISALIGNMENT}
  EXCEPTION_BREAKPOINT = STATUS_BREAKPOINT;
  {$EXTERNALSYM EXCEPTION_BREAKPOINT}
  EXCEPTION_SINGLE_STEP = STATUS_SINGLE_STEP;
  {$EXTERNALSYM EXCEPTION_SINGLE_STEP}
  EXCEPTION_ARRAY_BOUNDS_EXCEEDED = STATUS_ARRAY_BOUNDS_EXCEEDED;
  {$EXTERNALSYM EXCEPTION_ARRAY_BOUNDS_EXCEEDED}
  EXCEPTION_FLT_DENORMAL_OPERAND = STATUS_FLOAT_DENORMAL_OPERAND;
  {$EXTERNALSYM EXCEPTION_FLT_DENORMAL_OPERAND}
  EXCEPTION_FLT_DIVIDE_BY_ZERO = STATUS_FLOAT_DIVIDE_BY_ZERO;
  {$EXTERNALSYM EXCEPTION_FLT_DIVIDE_BY_ZERO}
  EXCEPTION_FLT_INEXACT_RESULT = STATUS_FLOAT_INEXACT_RESULT;
  {$EXTERNALSYM EXCEPTION_FLT_INEXACT_RESULT}
  EXCEPTION_FLT_INVALID_OPERATION = STATUS_FLOAT_INVALID_OPERATION;
  {$EXTERNALSYM EXCEPTION_FLT_INVALID_OPERATION}
  EXCEPTION_FLT_OVERFLOW = STATUS_FLOAT_OVERFLOW;
  {$EXTERNALSYM EXCEPTION_FLT_OVERFLOW}
  EXCEPTION_FLT_STACK_CHECK = STATUS_FLOAT_STACK_CHECK;
  {$EXTERNALSYM EXCEPTION_FLT_STACK_CHECK}
  EXCEPTION_FLT_UNDERFLOW = STATUS_FLOAT_UNDERFLOW;
  {$EXTERNALSYM EXCEPTION_FLT_UNDERFLOW}
  EXCEPTION_INT_DIVIDE_BY_ZERO = STATUS_INTEGER_DIVIDE_BY_ZERO;
  {$EXTERNALSYM EXCEPTION_INT_DIVIDE_BY_ZERO}
  EXCEPTION_INT_OVERFLOW = STATUS_INTEGER_OVERFLOW;
  {$EXTERNALSYM EXCEPTION_INT_OVERFLOW}
  EXCEPTION_PRIV_INSTRUCTION = STATUS_PRIVILEGED_INSTRUCTION;
  {$EXTERNALSYM EXCEPTION_PRIV_INSTRUCTION}
  EXCEPTION_IN_PAGE_ERROR = STATUS_IN_PAGE_ERROR;
  {$EXTERNALSYM EXCEPTION_IN_PAGE_ERROR}
  EXCEPTION_ILLEGAL_INSTRUCTION = STATUS_ILLEGAL_INSTRUCTION;
  {$EXTERNALSYM EXCEPTION_ILLEGAL_INSTRUCTION}
  EXCEPTION_NONCONTINUABLE_EXCEPTION = STATUS_NONCONTINUABLE_EXCEPTION;
  {$EXTERNALSYM EXCEPTION_NONCONTINUABLE_EXCEPTION}
  EXCEPTION_STACK_OVERFLOW = STATUS_STACK_OVERFLOW;
  {$EXTERNALSYM EXCEPTION_STACK_OVERFLOW}
  EXCEPTION_INVALID_DISPOSITION = STATUS_INVALID_DISPOSITION;
  {$EXTERNALSYM EXCEPTION_INVALID_DISPOSITION}
  EXCEPTION_GUARD_PAGE = STATUS_GUARD_PAGE_VIOLATION;
  {$EXTERNALSYM EXCEPTION_GUARD_PAGE}
  EXCEPTION_INVALID_HANDLE = STATUS_INVALID_HANDLE;
  {$EXTERNALSYM EXCEPTION_INVALID_HANDLE}
  CONTROL_C_EXIT = STATUS_CONTROL_C_EXIT;
  {$EXTERNALSYM CONTROL_C_EXIT}

procedure MoveMemory(Destination: Pointer; Source: Pointer; Length: DWORD);
{$EXTERNALSYM MoveMemory}
procedure CopyMemory(Destination: Pointer; Source: Pointer; Length: DWORD);
{$EXTERNALSYM CopyMemory}
procedure FillMemory(Destination: Pointer; Length: DWORD; Fill: Byte);
{$EXTERNALSYM FillMemory}
procedure ZeroMemory(Destination: Pointer; Length: DWORD); inline;
{$EXTERNALSYM ZeroMemory}

const
  { File creation flags must start at the high end since they }
  { are combined with the attributes}

  FILE_FLAG_WRITE_THROUGH = DWORD($80000000);
  {$EXTERNALSYM FILE_FLAG_WRITE_THROUGH}
  FILE_FLAG_OVERLAPPED = $40000000;
  {$EXTERNALSYM FILE_FLAG_OVERLAPPED}
  FILE_FLAG_NO_BUFFERING = $20000000;
  {$EXTERNALSYM FILE_FLAG_NO_BUFFERING}
  FILE_FLAG_RANDOM_ACCESS = $10000000;
  {$EXTERNALSYM FILE_FLAG_RANDOM_ACCESS}
  FILE_FLAG_SEQUENTIAL_SCAN = $8000000;
  {$EXTERNALSYM FILE_FLAG_SEQUENTIAL_SCAN}
  FILE_FLAG_DELETE_ON_CLOSE = $4000000;
  {$EXTERNALSYM FILE_FLAG_DELETE_ON_CLOSE}
  FILE_FLAG_BACKUP_SEMANTICS = $2000000;
  {$EXTERNALSYM FILE_FLAG_BACKUP_SEMANTICS}
  FILE_FLAG_POSIX_SEMANTICS = $1000000;
  {$EXTERNALSYM FILE_FLAG_POSIX_SEMANTICS}

  CREATE_NEW = 1;
  {$EXTERNALSYM CREATE_NEW}
  CREATE_ALWAYS = 2;
  {$EXTERNALSYM CREATE_ALWAYS}
  OPEN_EXISTING = 3;
  {$EXTERNALSYM OPEN_EXISTING}
  OPEN_ALWAYS = 4;
  {$EXTERNALSYM OPEN_ALWAYS}
  TRUNCATE_EXISTING = 5;
  {$EXTERNALSYM TRUNCATE_EXISTING}


{ Define possible return codes from the CopyFileEx callback routine }

  PROGRESS_CONTINUE = 0;
  {$EXTERNALSYM PROGRESS_CONTINUE}
  PROGRESS_CANCEL = 1;
  {$EXTERNALSYM PROGRESS_CANCEL}
  PROGRESS_STOP = 2;
  {$EXTERNALSYM PROGRESS_STOP}
  PROGRESS_QUIET = 3;
  {$EXTERNALSYM PROGRESS_QUIET}


{ Define CopyFileEx callback routine state change values }

  CALLBACK_CHUNK_FINISHED = $00000000;
  {$EXTERNALSYM CALLBACK_CHUNK_FINISHED}
  CALLBACK_STREAM_SWITCH = $00000001;
  {$EXTERNALSYM CALLBACK_STREAM_SWITCH}


{ Define CopyFileEx option flags }

  COPY_FILE_FAIL_IF_EXISTS = $00000001;
  {$EXTERNALSYM COPY_FILE_FAIL_IF_EXISTS}
  COPY_FILE_RESTARTABLE = $00000002;
  {$EXTERNALSYM COPY_FILE_RESTARTABLE}


{ Define the NamedPipe definitions}

  { Define the dwOpenMode values for CreateNamedPipe }

  PIPE_ACCESS_INBOUND = 1;
  {$EXTERNALSYM PIPE_ACCESS_INBOUND}
  PIPE_ACCESS_OUTBOUND = 2;
  {$EXTERNALSYM PIPE_ACCESS_OUTBOUND}
  PIPE_ACCESS_DUPLEX = 3;
  {$EXTERNALSYM PIPE_ACCESS_DUPLEX}

  { Define the Named Pipe End flags for GetNamedPipeInfo }

  PIPE_CLIENT_END = 0;
  {$EXTERNALSYM PIPE_CLIENT_END}
  PIPE_SERVER_END = 1;
  {$EXTERNALSYM PIPE_SERVER_END}

  { Define the dwPipeMode values for CreateNamedPipe }

  PIPE_WAIT = 0;
  {$EXTERNALSYM PIPE_WAIT}
  PIPE_NOWAIT = 1;
  {$EXTERNALSYM PIPE_NOWAIT}
  PIPE_READMODE_BYTE = 0;
  {$EXTERNALSYM PIPE_READMODE_BYTE}
  PIPE_READMODE_MESSAGE = 2;
  {$EXTERNALSYM PIPE_READMODE_MESSAGE}
  PIPE_TYPE_BYTE = 0;
  {$EXTERNALSYM PIPE_TYPE_BYTE}
  PIPE_TYPE_MESSAGE = 4;
  {$EXTERNALSYM PIPE_TYPE_MESSAGE}

  { Define the well known values for CreateNamedPipe nMaxInstances }

  {$EXTERNALSYM PIPE_UNLIMITED_INSTANCES}
  PIPE_UNLIMITED_INSTANCES = 255;

  { Define the Security Quality of Service bits to be passed into CreateFile }

  SECURITY_ANONYMOUS = (Ord(SecurityAnonymous) shl 16);
  {$EXTERNALSYM SECURITY_ANONYMOUS}
  SECURITY_IDENTIFICATION = (Ord(SecurityIdentification) shl 16);
  {$EXTERNALSYM SECURITY_IDENTIFICATION}
  SECURITY_IMPERSONATION = (Ord(SecurityImpersonation) shl 16);
  {$EXTERNALSYM SECURITY_IMPERSONATION}
  SECURITY_DELEGATION = (Ord(SecurityDelegation) shl 16);
  {$EXTERNALSYM SECURITY_DELEGATION}

  SECURITY_CONTEXT_TRACKING = $40000;
  {$EXTERNALSYM SECURITY_CONTEXT_TRACKING}
  SECURITY_EFFECTIVE_ONLY = $80000;
  {$EXTERNALSYM SECURITY_EFFECTIVE_ONLY}

  SECURITY_SQOS_PRESENT = $100000;
  {$EXTERNALSYM SECURITY_SQOS_PRESENT}
  SECURITY_VALID_SQOS_FLAGS = $1F0000;
  {$EXTERNALSYM SECURITY_VALID_SQOS_FLAGS}

{ File structures }

type
  POverlapped = ^TOverlapped;
  _OVERLAPPED = record
    Internal: DWORD;
    InternalHigh: DWORD;
    Offset: DWORD;
    OffsetHigh: DWORD;
    hEvent: THandle;
  end;
  {$EXTERNALSYM _OVERLAPPED}
  TOverlapped = _OVERLAPPED;
  OVERLAPPED = _OVERLAPPED;
  {$EXTERNALSYM OVERLAPPED}

  PSecurityAttributes = ^TSecurityAttributes;
  _SECURITY_ATTRIBUTES = record
    nLength: DWORD;
    lpSecurityDescriptor: Pointer;
    bInheritHandle: BOOL;
  end;
  {$EXTERNALSYM _SECURITY_ATTRIBUTES}
  TSecurityAttributes = _SECURITY_ATTRIBUTES;
  SECURITY_ATTRIBUTES = _SECURITY_ATTRIBUTES;
  {$EXTERNALSYM SECURITY_ATTRIBUTES}

  PProcessInformation = ^TProcessInformation;
  _PROCESS_INFORMATION = record
    hProcess: THandle;
    hThread: THandle;
    dwProcessId: DWORD;
    dwThreadId: DWORD;
  end;
  {$EXTERNALSYM _PROCESS_INFORMATION}
  TProcessInformation = _PROCESS_INFORMATION;
  PROCESS_INFORMATION = _PROCESS_INFORMATION;
  {$EXTERNALSYM PROCESS_INFORMATION}

{$IFDEF MSWINDOWS}
  { File System time stamps are represented with the following structure: }
  PFileTime = ^TFileTime;
  _FILETIME = record
    dwLowDateTime: DWORD;
    dwHighDateTime: DWORD;
  end;
  {$EXTERNALSYM _FILETIME}
  TFileTime = _FILETIME;
  FILETIME = _FILETIME;
  {$EXTERNALSYM FILETIME}
{$ENDIF}
{$IFDEF LINUX}
  _FILETIME = Types._FILETIME;
  {$EXTERNALSYM _FILETIME}
  PFileTime = Types.PFileTime;
  TFileTime = Types.TFileTime;
  FILETIME = Types.FILETIME;
  {$EXTERNALSYM FILETIME}
{$ENDIF}

  { System time is represented with the following structure: }
  PSystemTime = ^TSystemTime;
  _SYSTEMTIME = record
    wYear: Word;
    wMonth: Word;
    wDayOfWeek: Word;
    wDay: Word;
    wHour: Word;
    wMinute: Word;
    wSecond: Word;
    wMilliseconds: Word;
  end;
  {$EXTERNALSYM _SYSTEMTIME}
  TSystemTime = _SYSTEMTIME;
  SYSTEMTIME = _SYSTEMTIME;
  {$EXTERNALSYM SYSTEMTIME}





  TFNThreadStartRoutine = TFarProc;
  TFNFiberStartRoutine = TFarProc;


const
  MUTEX_MODIFY_STATE = MUTANT_QUERY_STATE;
  {$EXTERNALSYM MUTEX_MODIFY_STATE}
  MUTEX_ALL_ACCESS = MUTANT_ALL_ACCESS;
  {$EXTERNALSYM MUTEX_ALL_ACCESS}

  { Serial provider type. }

  SP_SERIALCOMM = $00000001;
  {$EXTERNALSYM SP_SERIALCOMM}

  { Provider SubTypes }

  PST_UNSPECIFIED = $00000000;
  {$EXTERNALSYM PST_UNSPECIFIED}
  PST_RS232 = $00000001;
  {$EXTERNALSYM PST_RS232}
  PST_PARALLELPORT = $00000002;
  {$EXTERNALSYM PST_PARALLELPORT}
  PST_RS422 = $00000003;
  {$EXTERNALSYM PST_RS422}
  PST_RS423 = $00000004;
  {$EXTERNALSYM PST_RS423}
  PST_RS449 = $00000005;
  {$EXTERNALSYM PST_RS449}
  PST_MODEM = $00000006;
  {$EXTERNALSYM PST_MODEM}
  PST_FAX = $00000021;
  {$EXTERNALSYM PST_FAX}
  PST_SCANNER = $00000022;
  {$EXTERNALSYM PST_SCANNER}
  PST_NETWORK_BRIDGE = $00000100;
  {$EXTERNALSYM PST_NETWORK_BRIDGE}
  PST_LAT = $00000101;
  {$EXTERNALSYM PST_LAT}
  PST_TCPIP_TELNET = $00000102;
  {$EXTERNALSYM PST_TCPIP_TELNET}
  PST_X25 = $00000103;
  {$EXTERNALSYM PST_X25}

  { Provider capabilities flags. }

  PCF_DTRDSR = $0001;
  {$EXTERNALSYM PCF_DTRDSR}
  PCF_RTSCTS = $0002;
  {$EXTERNALSYM PCF_RTSCTS}
  PCF_RLSD = $0004;
  {$EXTERNALSYM PCF_RLSD}
  PCF_PARITY_CHECK = $0008;
  {$EXTERNALSYM PCF_PARITY_CHECK}
  PCF_XONXOFF = $0010;
  {$EXTERNALSYM PCF_XONXOFF}
  PCF_SETXCHAR = $0020;
  {$EXTERNALSYM PCF_SETXCHAR}
  PCF_TOTALTIMEOUTS = $0040;
  {$EXTERNALSYM PCF_TOTALTIMEOUTS}
  PCF_INTTIMEOUTS = $0080;
  {$EXTERNALSYM PCF_INTTIMEOUTS}
  PCF_SPECIALCHARS = $0100;
  {$EXTERNALSYM PCF_SPECIALCHARS}
  PCF_16BITMODE = $0200;
  {$EXTERNALSYM PCF_16BITMODE}

  { Comm provider settable parameters. }

  SP_PARITY = $0001;
  {$EXTERNALSYM SP_PARITY}
  SP_BAUD = $0002;
  {$EXTERNALSYM SP_BAUD}
  SP_DATABITS = $0004;
  {$EXTERNALSYM SP_DATABITS}
  SP_STOPBITS = $0008;
  {$EXTERNALSYM SP_STOPBITS}
  SP_HANDSHAKING = $0010;
  {$EXTERNALSYM SP_HANDSHAKING}
  SP_PARITY_CHECK = $0020;
  {$EXTERNALSYM SP_PARITY_CHECK}
  SP_RLSD = $0040;
  {$EXTERNALSYM SP_RLSD}

  { Settable baud rates in the provider. }

  BAUD_075 = $00000001;
  {$EXTERNALSYM BAUD_075}
  BAUD_110 = $00000002;
  {$EXTERNALSYM BAUD_110}
  BAUD_134_5 = $00000004;
  {$EXTERNALSYM BAUD_134_5}
  BAUD_150 = $00000008;
  {$EXTERNALSYM BAUD_150}
  BAUD_300 = $00000010;
  {$EXTERNALSYM BAUD_300}
  BAUD_600 = $00000020;
  {$EXTERNALSYM BAUD_600}
  BAUD_1200 = $00000040;
  {$EXTERNALSYM BAUD_1200}
  BAUD_1800 = $00000080;
  {$EXTERNALSYM BAUD_1800}
  BAUD_2400 = $00000100;
  {$EXTERNALSYM BAUD_2400}
  BAUD_4800 = $00000200;
  {$EXTERNALSYM BAUD_4800}
  BAUD_7200 = $00000400;
  {$EXTERNALSYM BAUD_7200}
  BAUD_9600 = $00000800;
  {$EXTERNALSYM BAUD_9600}
  BAUD_14400 = $00001000;
  {$EXTERNALSYM BAUD_14400}
  BAUD_19200 = $00002000;
  {$EXTERNALSYM BAUD_19200}
  BAUD_38400 = $00004000;
  {$EXTERNALSYM BAUD_38400}
  BAUD_56K = $00008000;
  {$EXTERNALSYM BAUD_56K}
  BAUD_128K = $00010000;
  {$EXTERNALSYM BAUD_128K}
  BAUD_115200 = $00020000;
  {$EXTERNALSYM BAUD_115200}
  BAUD_57600 = $00040000;
  {$EXTERNALSYM BAUD_57600}
  BAUD_USER = $10000000;
  {$EXTERNALSYM BAUD_USER}

  { Settable Data Bits }

  DATABITS_5 = $0001;
  {$EXTERNALSYM DATABITS_5}
  DATABITS_6 = $0002;
  {$EXTERNALSYM DATABITS_6}
  DATABITS_7 = $0004;
  {$EXTERNALSYM DATABITS_7}
  DATABITS_8 = $0008;
  {$EXTERNALSYM DATABITS_8}
  DATABITS_16 = $0010;
  {$EXTERNALSYM DATABITS_16}
  DATABITS_16X = $0020;
  {$EXTERNALSYM DATABITS_16X}

  { Settable Stop and Parity bits. }

  STOPBITS_10 = $0001;
  {$EXTERNALSYM STOPBITS_10}
  STOPBITS_15 = $0002;
  {$EXTERNALSYM STOPBITS_15}
  STOPBITS_20 = $0004;
  {$EXTERNALSYM STOPBITS_20}
  PARITY_NONE = $0100;
  {$EXTERNALSYM PARITY_NONE}
  PARITY_ODD = $0200;
  {$EXTERNALSYM PARITY_ODD}
  PARITY_EVEN = $0400;
  {$EXTERNALSYM PARITY_EVEN}
  PARITY_MARK = $0800;
  {$EXTERNALSYM PARITY_MARK}
  PARITY_SPACE = $1000;
  {$EXTERNALSYM PARITY_SPACE}

type
  PCommProp = ^TCommProp;
  _COMMPROP = record
    wPacketLength: Word;
    wPacketVersion: Word;
    dwServiceMask: DWORD;
    dwReserved1: DWORD;
    dwMaxTxQueue: DWORD;
    dwMaxRxQueue: DWORD;
    dwMaxBaud: DWORD;
    dwProvSubType: DWORD;
    dwProvCapabilities: DWORD;
    dwSettableParams: DWORD;
    dwSettableBaud: DWORD;
    wSettableData: Word;
    wSettableStopParity: Word;
    dwCurrentTxQueue: DWORD;
    dwCurrentRxQueue: DWORD;
    dwProvSpec1: DWORD;
    dwProvSpec2: DWORD;
    wcProvChar: array[0..0] of WCHAR;
  end;
  TCommProp = _COMMPROP;
  {$EXTERNALSYM _COMMPROP}
  COMMPROP = _COMMPROP;
  {$EXTERNALSYM COMMPROP}

  { Set dwProvSpec1 to COMMPROP_INITIALIZED to indicate that wPacketLength
    is valid before a call to GetCommProperties(). }
const
  COMMPROP_INITIALIZED = DWORD($E73CF52E);
  {$EXTERNALSYM COMMPROP_INITIALIZED}

type
  TComStateFlag = (fCtlHold, fDsrHold, fRlsHold, fXoffHold, fXOffSent, fEof,
    fTxim);  // not in Windows Headers
  TComStateFlags = set of TComStateFlag;
  _COMSTAT = record
    Flags: TComStateFlags;
    Reserved: array[0..2] of Byte;
    cbInQue: DWORD;
    cbOutQue: DWORD;
  end;
  {$EXTERNALSYM _COMSTAT}
  TComStat = _COMSTAT;
  COMSTAT = _COMSTAT;
  {$EXTERNALSYM COMSTAT}
  PComStat = ^TComStat;

const
  { DTR Control Flow Values. }
  DTR_CONTROL_DISABLE = 0;
  {$EXTERNALSYM DTR_CONTROL_DISABLE}
  DTR_CONTROL_ENABLE = 1;
  {$EXTERNALSYM DTR_CONTROL_ENABLE}
  DTR_CONTROL_HANDSHAKE = 2;
  {$EXTERNALSYM DTR_CONTROL_HANDSHAKE}

  { RTS Control Flow Values}
  RTS_CONTROL_DISABLE = 0;
  {$EXTERNALSYM RTS_CONTROL_DISABLE}
  RTS_CONTROL_ENABLE = 1;
  {$EXTERNALSYM RTS_CONTROL_ENABLE}
  RTS_CONTROL_HANDSHAKE = 2;
  {$EXTERNALSYM RTS_CONTROL_HANDSHAKE}
  RTS_CONTROL_TOGGLE = 3;
  {$EXTERNALSYM RTS_CONTROL_TOGGLE}

type
  _DCB = packed record
    DCBlength: DWORD;
    BaudRate: DWORD;
    Flags: Longint;
    wReserved: Word;
    XonLim: Word;
    XoffLim: Word;
    ByteSize: Byte;
    Parity: Byte;
    StopBits: Byte;
    XonChar: CHAR;
    XoffChar: CHAR;
    ErrorChar: CHAR;
    EofChar: CHAR;
    EvtChar: CHAR;
    wReserved1: Word;
  end;
  {$EXTERNALSYM _DCB}
  TDCB = _DCB;
  DCB = _DCB;
  {$EXTERNALSYM DCB}
  PDCB = ^TDCB;

  PCommTimeouts = ^TCommTimeouts;
  _COMMTIMEOUTS = record
    ReadIntervalTimeout: DWORD;
    ReadTotalTimeoutMultiplier: DWORD;
    ReadTotalTimeoutConstant: DWORD;
    WriteTotalTimeoutMultiplier: DWORD;
    WriteTotalTimeoutConstant: DWORD;
  end;
  {$EXTERNALSYM _COMMTIMEOUTS}
  TCommTimeouts = _COMMTIMEOUTS;
  COMMTIMEOUTS = _COMMTIMEOUTS;
  {$EXTERNALSYM COMMTIMEOUTS}

  PCommConfig = ^TCommConfig;
  _COMMCONFIG = record
    dwSize: DWORD;
    wVersion: Word;
    wReserved: Word;
    dcb: TDCB;
    dwProviderSubType: DWORD;
    dwProviderOffset: DWORD;
    dwProviderSize: DWORD;
    wcProviderData: array[0..0] of WCHAR;
  end;
  {$EXTERNALSYM _COMMCONFIG}
  TCommConfig = _COMMCONFIG;
  COMMCONFIG = _COMMCONFIG;
  {$EXTERNALSYM COMMCONFIG}

  PSystemInfo = ^TSystemInfo;
  _SYSTEM_INFO = record
    case Integer of
      0: (
        dwOemId: DWORD);
      1: (
        wProcessorArchitecture: Word;
        wReserved: Word;
        dwPageSize: DWORD;
        lpMinimumApplicationAddress: Pointer;
        lpMaximumApplicationAddress: Pointer;
        dwActiveProcessorMask: DWORD;
        dwNumberOfProcessors: DWORD;
        dwProcessorType: DWORD;
        dwAllocationGranularity: DWORD;
        wProcessorLevel: Word;
        wProcessorRevision: Word);
  end;
  {$EXTERNALSYM _SYSTEM_INFO}
  TSystemInfo = _SYSTEM_INFO;
  SYSTEM_INFO = _SYSTEM_INFO;
  {$EXTERNALSYM SYSTEM_INFO}

function FreeModule(var hLibModule: HINST): BOOL; inline;
{$EXTERNALSYM FreeModule}
function MakeProcInstance(Proc: FARPROC; Instance: THandle): FARPROC; inline;
{$EXTERNALSYM MakeProcInstance}
procedure FreeProcInstance(Proc: FARPROC); inline;
{$EXTERNALSYM FreeProcInstance}


const
  { Global Memory Flags }

  GMEM_FIXED = 0;
  {$EXTERNALSYM GMEM_FIXED}
  GMEM_MOVEABLE = 2;
  {$EXTERNALSYM GMEM_MOVEABLE}
  GMEM_NOCOMPACT = $10;
  {$EXTERNALSYM GMEM_NOCOMPACT}
  GMEM_NODISCARD = $20;
  {$EXTERNALSYM GMEM_NODISCARD}
  GMEM_ZEROINIT = $40;
  {$EXTERNALSYM GMEM_ZEROINIT}
  GMEM_MODIFY = $80;
  {$EXTERNALSYM GMEM_MODIFY}
  GMEM_DISCARDABLE = $100;
  {$EXTERNALSYM GMEM_DISCARDABLE}
  GMEM_NOT_BANKED = $1000;
  {$EXTERNALSYM GMEM_NOT_BANKED}
  GMEM_SHARE = $2000;
  {$EXTERNALSYM GMEM_SHARE}
  GMEM_DDESHARE = $2000;
  {$EXTERNALSYM GMEM_DDESHARE}
  GMEM_NOTIFY = $4000;
  {$EXTERNALSYM GMEM_NOTIFY}
  GMEM_LOWER = GMEM_NOT_BANKED;
  {$EXTERNALSYM GMEM_LOWER}
  GMEM_VALID_FLAGS = 32626;
  {$EXTERNALSYM GMEM_VALID_FLAGS}
  GMEM_INVALID_HANDLE = $8000;
  {$EXTERNALSYM GMEM_INVALID_HANDLE}

  GHND = GMEM_MOVEABLE or GMEM_ZEROINIT;
  {$EXTERNALSYM GHND}
  GPTR = GMEM_FIXED or GMEM_ZEROINIT;
  {$EXTERNALSYM GPTR}

function GlobalLRUNewest(h: THandle): THandle; inline;
{$EXTERNALSYM GlobalLRUNewest}
function GlobalLRUOldest(h: THandle): THandle; inline;
{$EXTERNALSYM GlobalLRUOldest}
function GlobalDiscard(h: THandle): THandle; inline;
{$EXTERNALSYM GlobalDiscard}

function GlobalAllocPtr(Flags: Integer; Bytes: Longint): Pointer;
{$EXTERNALSYM GlobalAllocPtr}
function GlobalReAllocPtr(P: Pointer; Bytes: Longint; Flags: Integer): Pointer;
{$EXTERNALSYM GlobalReAllocPtr}
function GlobalFreePtr(P: Pointer): THandle;
{$EXTERNALSYM GlobalFreePtr}

const
  { Flags returned by GlobalFlags (in addition to GMEM_DISCARDABLE) }
  GMEM_DISCARDED = $4000;
  {$EXTERNALSYM GMEM_DISCARDED}
  GMEM_LOCKCOUNT = 255;
  {$EXTERNALSYM GMEM_LOCKCOUNT}

type
  PMemoryStatus = ^TMemoryStatus;
  _MEMORYSTATUS = record
    dwLength: DWORD;
    dwMemoryLoad: DWORD;
    dwTotalPhys: DWORD;
    dwAvailPhys: DWORD;
    dwTotalPageFile: DWORD;
    dwAvailPageFile: DWORD;
    dwTotalVirtual: DWORD;
    dwAvailVirtual: DWORD;
  end;
  {$EXTERNALSYM _MEMORYSTATUS}
  TMemoryStatus = _MEMORYSTATUS;
  MEMORYSTATUS = _MEMORYSTATUS;
  {$EXTERNALSYM MEMORYSTATUS}

const
  { Local Memory Flags }

  LMEM_FIXED = 0;
  {$EXTERNALSYM LMEM_FIXED}
  LMEM_MOVEABLE = 2;
  {$EXTERNALSYM LMEM_MOVEABLE}
  LMEM_NOCOMPACT = $10;
  {$EXTERNALSYM LMEM_NOCOMPACT}
  LMEM_NODISCARD = $20;
  {$EXTERNALSYM LMEM_NODISCARD}
  LMEM_ZEROINIT = $40;
  {$EXTERNALSYM LMEM_ZEROINIT}
  LMEM_MODIFY = $80;
  {$EXTERNALSYM LMEM_MODIFY}
  LMEM_DISCARDABLE = $F00;
  {$EXTERNALSYM LMEM_DISCARDABLE}
  LMEM_VALID_FLAGS = $F72;
  {$EXTERNALSYM LMEM_VALID_FLAGS}
  LMEM_INVALID_HANDLE = $8000;
  {$EXTERNALSYM LMEM_INVALID_HANDLE}

  LHND = LMEM_MOVEABLE or LMEM_ZEROINIT;
  {$EXTERNALSYM LHND}
  LPTR = LMEM_FIXED or LMEM_ZEROINIT;
  {$EXTERNALSYM LPTR}

  NONZEROLPTR = LMEM_FIXED;
  {$EXTERNALSYM NONZEROLPTR}


function LocalDiscard(h: THandle): THandle; inline;
{$EXTERNALSYM LocalDiscard}

const
  { Flags returned by LocalFlags (in addition to LMEM_DISCARDABLE) }

  LMEM_DISCARDED = $4000;
  {$EXTERNALSYM LMEM_DISCARDED}
  LMEM_LOCKCOUNT = 255;
  {$EXTERNALSYM LMEM_LOCKCOUNT}

  { dwCreationFlag values }

{ dwCreationFlag values }


  DEBUG_PROCESS                   = $00000001;
  {$EXTERNALSYM DEBUG_PROCESS}
  DEBUG_ONLY_THIS_PROCESS         = $00000002;
  {$EXTERNALSYM DEBUG_ONLY_THIS_PROCESS}

  CREATE_SUSPENDED                = $00000004;
  {$EXTERNALSYM CREATE_SUSPENDED}

  DETACHED_PROCESS                = $00000008;
  {$EXTERNALSYM DETACHED_PROCESS}

  CREATE_NEW_CONSOLE              = $00000010;
  {$EXTERNALSYM CREATE_NEW_CONSOLE}

  NORMAL_PRIORITY_CLASS           = $00000020;
  {$EXTERNALSYM NORMAL_PRIORITY_CLASS}
  IDLE_PRIORITY_CLASS             = $00000040;
  {$EXTERNALSYM IDLE_PRIORITY_CLASS}
  HIGH_PRIORITY_CLASS             = $00000080;
  {$EXTERNALSYM HIGH_PRIORITY_CLASS}
  REALTIME_PRIORITY_CLASS         = $00000100;
  {$EXTERNALSYM REALTIME_PRIORITY_CLASS}

  CREATE_NEW_PROCESS_GROUP        = $00000200;
  {$EXTERNALSYM CREATE_NEW_PROCESS_GROUP}
  CREATE_UNICODE_ENVIRONMENT      = $00000400;
  {$EXTERNALSYM CREATE_UNICODE_ENVIRONMENT}

  CREATE_SEPARATE_WOW_VDM         = $00000800;
  {$EXTERNALSYM CREATE_SEPARATE_WOW_VDM}
  CREATE_SHARED_WOW_VDM           = $00001000;
  {$EXTERNALSYM CREATE_SHARED_WOW_VDM}
  CREATE_FORCEDOS                 = $00002000;
  {$EXTERNALSYM CREATE_FORCEDOS}

  CREATE_DEFAULT_ERROR_MODE       = $04000000;
  {$EXTERNALSYM CREATE_DEFAULT_ERROR_MODE}
  CREATE_NO_WINDOW                = $08000000;
  {$EXTERNALSYM CREATE_NO_WINDOW}

  PROFILE_USER                    = $10000000;
  {$EXTERNALSYM PROFILE_USER}
  PROFILE_KERNEL                  = $20000000;
  {$EXTERNALSYM PROFILE_KERNEL}
  PROFILE_SERVER                  = $40000000;
  {$EXTERNALSYM PROFILE_SERVER}

  THREAD_PRIORITY_LOWEST              = THREAD_BASE_PRIORITY_MIN;
  {$EXTERNALSYM THREAD_PRIORITY_LOWEST}
  THREAD_PRIORITY_BELOW_NORMAL        = THREAD_PRIORITY_LOWEST + 1;
  {$EXTERNALSYM THREAD_PRIORITY_BELOW_NORMAL}
  THREAD_PRIORITY_NORMAL              = 0;
  {$EXTERNALSYM THREAD_PRIORITY_NORMAL}
  THREAD_PRIORITY_HIGHEST             = THREAD_BASE_PRIORITY_MAX;
  {$EXTERNALSYM THREAD_PRIORITY_HIGHEST}
  THREAD_PRIORITY_ABOVE_NORMAL        = THREAD_PRIORITY_HIGHEST - 1;
  {$EXTERNALSYM THREAD_PRIORITY_ABOVE_NORMAL}
  THREAD_PRIORITY_ERROR_RETURN        = MAXLONG;
  {$EXTERNALSYM THREAD_PRIORITY_ERROR_RETURN}

  THREAD_PRIORITY_TIME_CRITICAL       = THREAD_BASE_PRIORITY_LOWRT;
  {$EXTERNALSYM THREAD_PRIORITY_TIME_CRITICAL}
  THREAD_PRIORITY_IDLE                = THREAD_BASE_PRIORITY_IDLE;
  {$EXTERNALSYM THREAD_PRIORITY_IDLE}

{ Debug APIs }

  DBG_CONTINUE               = $00010002;
  {$EXTERNALSYM DBG_CONTINUE}
  DBG_TERMINATE_THREAD       = $40010003;
  {$EXTERNALSYM DBG_TERMINATE_THREAD}
  DBG_TERMINATE_PROCESS      = $40010004;
  {$EXTERNALSYM DBG_TERMINATE_PROCESS}
  DBG_CONTROL_C              = $40010005;
  {$EXTERNALSYM DBG_CONTROL_C}
  DBG_CONTROL_BREAK          = $40010008;
  {$EXTERNALSYM DBG_CONTROL_BREAK}
  DBG_EXCEPTION_NOT_HANDLED  = $80010001;
  {$EXTERNALSYM DBG_EXCEPTION_NOT_HANDLED}

  EXCEPTION_DEBUG_EVENT = 1;
  {$EXTERNALSYM EXCEPTION_DEBUG_EVENT}
  CREATE_THREAD_DEBUG_EVENT = 2;
  {$EXTERNALSYM CREATE_THREAD_DEBUG_EVENT}
  CREATE_PROCESS_DEBUG_EVENT = 3;
  {$EXTERNALSYM CREATE_PROCESS_DEBUG_EVENT}
  EXIT_THREAD_DEBUG_EVENT = 4;
  {$EXTERNALSYM EXIT_THREAD_DEBUG_EVENT}
  EXIT_PROCESS_DEBUG_EVENT = 5;
  {$EXTERNALSYM EXIT_PROCESS_DEBUG_EVENT}
  LOAD_DLL_DEBUG_EVENT = 6;
  {$EXTERNALSYM LOAD_DLL_DEBUG_EVENT}
  UNLOAD_DLL_DEBUG_EVENT = 7;
  {$EXTERNALSYM UNLOAD_DLL_DEBUG_EVENT}
  OUTPUT_DEBUG_STRING_EVENT = 8;
  {$EXTERNALSYM OUTPUT_DEBUG_STRING_EVENT}
  RIP_EVENT = 9;
  {$EXTERNALSYM RIP_EVENT}

type
  PExceptionDebugInfo = ^TExceptionDebugInfo;
  _EXCEPTION_DEBUG_INFO = record
    ExceptionRecord: TExceptionRecord;
    dwFirstChance: DWORD;
  end;
  {$EXTERNALSYM _EXCEPTION_DEBUG_INFO}
  TExceptionDebugInfo = _EXCEPTION_DEBUG_INFO;
  EXCEPTION_DEBUG_INFO = _EXCEPTION_DEBUG_INFO;
  {$EXTERNALSYM EXCEPTION_DEBUG_INFO}

  PCreateThreadDebugInfo = ^TCreateThreadDebugInfo;
  _CREATE_THREAD_DEBUG_INFO = record
    hThread: THandle;
    lpThreadLocalBase: Pointer;
    lpStartAddress: TFNThreadStartRoutine;
  end;
  {$EXTERNALSYM _CREATE_THREAD_DEBUG_INFO}
  TCreateThreadDebugInfo = _CREATE_THREAD_DEBUG_INFO;
  CREATE_THREAD_DEBUG_INFO = _CREATE_THREAD_DEBUG_INFO;
  {$EXTERNALSYM CREATE_THREAD_DEBUG_INFO}

  PCreateProcessDebugInfo = ^TCreateProcessDebugInfo;
  _CREATE_PROCESS_DEBUG_INFO = record
    hFile: THandle;
    hProcess: THandle;
    hThread: THandle;
    lpBaseOfImage: Pointer;
    dwDebugInfoFileOffset: DWORD;
    nDebugInfoSize: DWORD;
    lpThreadLocalBase: Pointer;
    lpStartAddress: TFNThreadStartRoutine;
    lpImageName: Pointer;
    fUnicode: Word;
  end;
  {$EXTERNALSYM _CREATE_PROCESS_DEBUG_INFO}
  TCreateProcessDebugInfo = _CREATE_PROCESS_DEBUG_INFO;
  CREATE_PROCESS_DEBUG_INFO = _CREATE_PROCESS_DEBUG_INFO;
  {$EXTERNALSYM CREATE_PROCESS_DEBUG_INFO}

  PExitThreadDebugInfo = ^TExitThreadDebugInfo;
  _EXIT_THREAD_DEBUG_INFO = record
    dwExitCode: DWORD;
  end;
  {$EXTERNALSYM _EXIT_THREAD_DEBUG_INFO}
  TExitThreadDebugInfo = _EXIT_THREAD_DEBUG_INFO;
  EXIT_THREAD_DEBUG_INFO = _EXIT_THREAD_DEBUG_INFO;
  {$EXTERNALSYM EXIT_THREAD_DEBUG_INFO}

  PExitProcessDebugInfo = ^TExitProcessDebugInfo;
  _EXIT_PROCESS_DEBUG_INFO = record
    dwExitCode: DWORD;
  end;
  {$EXTERNALSYM _EXIT_PROCESS_DEBUG_INFO}
  TExitProcessDebugInfo = _EXIT_PROCESS_DEBUG_INFO;
  EXIT_PROCESS_DEBUG_INFO = _EXIT_PROCESS_DEBUG_INFO;
  {$EXTERNALSYM EXIT_PROCESS_DEBUG_INFO}

  PLoadDLLDebugInfo = ^TLoadDLLDebugInfo;
  _LOAD_DLL_DEBUG_INFO = record
    hFile: THandle;
    lpBaseOfDll: Pointer;
    dwDebugInfoFileOffset: DWORD;
    nDebugInfoSize: DWORD;
    lpImageName: Pointer;
    fUnicode: Word;
  end;
  {$EXTERNALSYM _LOAD_DLL_DEBUG_INFO}
  TLoadDLLDebugInfo = _LOAD_DLL_DEBUG_INFO;
  LOAD_DLL_DEBUG_INFO = _LOAD_DLL_DEBUG_INFO;
  {$EXTERNALSYM LOAD_DLL_DEBUG_INFO}

  PUnloadDLLDebugInfo = ^TUnloadDLLDebugInfo;
  _UNLOAD_DLL_DEBUG_INFO = record
    lpBaseOfDll: Pointer;
  end;
  {$EXTERNALSYM _UNLOAD_DLL_DEBUG_INFO}
  TUnloadDLLDebugInfo = _UNLOAD_DLL_DEBUG_INFO;
  UNLOAD_DLL_DEBUG_INFO = _UNLOAD_DLL_DEBUG_INFO;
  {$EXTERNALSYM UNLOAD_DLL_DEBUG_INFO}

  POutputDebugStringInfo = ^TOutputDebugStringInfo;
  _OUTPUT_DEBUG_STRING_INFO = record
    lpDebugStringData: LPSTR;
    fUnicode: Word;
    nDebugStringLength: Word;
  end;
  {$EXTERNALSYM _OUTPUT_DEBUG_STRING_INFO}
  TOutputDebugStringInfo = _OUTPUT_DEBUG_STRING_INFO;
  OUTPUT_DEBUG_STRING_INFO = _OUTPUT_DEBUG_STRING_INFO;
  {$EXTERNALSYM OUTPUT_DEBUG_STRING_INFO}

  PRIPInfo = ^TRIPInfo;
  _RIP_INFO = record
    dwError: DWORD;
    dwType: DWORD;
  end;
  {$EXTERNALSYM _RIP_INFO}
  TRIPInfo = _RIP_INFO;
  RIP_INFO = _RIP_INFO;
  {$EXTERNALSYM RIP_INFO}

  PDebugEvent = ^TDebugEvent;
  _DEBUG_EVENT = record
    dwDebugEventCode: DWORD;
    dwProcessId: DWORD;
    dwThreadId: DWORD;
    case Integer of
      0: (Exception: TExceptionDebugInfo);
      1: (CreateThread: TCreateThreadDebugInfo);
      2: (CreateProcessInfo: TCreateProcessDebugInfo);
      3: (ExitThread: TExitThreadDebugInfo);
      4: (ExitProcess: TExitProcessDebugInfo);
      5: (LoadDll: TLoadDLLDebugInfo);
      6: (UnloadDll: TUnloadDLLDebugInfo);
      7: (DebugString: TOutputDebugStringInfo);
      8: (RipInfo: TRIPInfo);
  end;
  {$EXTERNALSYM _DEBUG_EVENT}
  TDebugEvent = _DEBUG_EVENT;
  DEBUG_EVENT = _DEBUG_EVENT;
  {$EXTERNALSYM DEBUG_EVENT}

const
  DRIVE_UNKNOWN = 0;
  {$EXTERNALSYM DRIVE_UNKNOWN}
  DRIVE_NO_ROOT_DIR = 1;
  {$EXTERNALSYM DRIVE_NO_ROOT_DIR}
  DRIVE_REMOVABLE = 2;
  {$EXTERNALSYM DRIVE_REMOVABLE}
  DRIVE_FIXED = 3;
  {$EXTERNALSYM DRIVE_FIXED}
  DRIVE_REMOTE = 4;
  {$EXTERNALSYM DRIVE_REMOTE}
  DRIVE_CDROM = 5;
  {$EXTERNALSYM DRIVE_CDROM}
  DRIVE_RAMDISK = 6;
  {$EXTERNALSYM DRIVE_RAMDISK}

{$EXTERNALSYM GetFreeSpace}
function GetFreeSpace(w: Word): DWORD; inline;

const
  FILE_TYPE_UNKNOWN = 0;
  {$EXTERNALSYM FILE_TYPE_UNKNOWN}
  FILE_TYPE_DISK = 1;
  {$EXTERNALSYM FILE_TYPE_DISK}
  FILE_TYPE_CHAR = 2;
  {$EXTERNALSYM FILE_TYPE_CHAR}
  FILE_TYPE_PIPE = 3;
  {$EXTERNALSYM FILE_TYPE_PIPE}
  FILE_TYPE_REMOTE = $8000;
  {$EXTERNALSYM FILE_TYPE_REMOTE}

  STD_INPUT_HANDLE = DWORD(-10);
  {$EXTERNALSYM STD_INPUT_HANDLE}
  STD_OUTPUT_HANDLE = DWORD(-11);
  {$EXTERNALSYM STD_OUTPUT_HANDLE}
  STD_ERROR_HANDLE = DWORD(-12);
  {$EXTERNALSYM STD_ERROR_HANDLE}

  NOPARITY = 0;
  {$EXTERNALSYM NOPARITY}
  ODDPARITY = 1;
  {$EXTERNALSYM ODDPARITY}
  EVENPARITY = 2;
  {$EXTERNALSYM EVENPARITY}
  MARKPARITY = 3;
  {$EXTERNALSYM MARKPARITY}
  SPACEPARITY = 4;
  {$EXTERNALSYM SPACEPARITY}

  ONESTOPBIT = 0;
  {$EXTERNALSYM ONESTOPBIT}
  ONE5STOPBITS = 1;
  {$EXTERNALSYM ONE5STOPBITS}
  TWOSTOPBITS = 2;
  {$EXTERNALSYM TWOSTOPBITS}

  IGNORE = 0;               { Ignore signal }
  {$EXTERNALSYM IGNORE}
  INFINITE = DWORD($FFFFFFFF);     { Infinite timeout }
  {$EXTERNALSYM INFINITE}

  { Baud rates at which the communication device operates }

  CBR_110 = 110;
  {$EXTERNALSYM CBR_110}
  CBR_300 = 300;
  {$EXTERNALSYM CBR_300}
  CBR_600 = 600;
  {$EXTERNALSYM CBR_600}
  CBR_1200 = 1200;
  {$EXTERNALSYM CBR_1200}
  CBR_2400 = 2400;
  {$EXTERNALSYM CBR_2400}
  CBR_4800 = 4800;
  {$EXTERNALSYM CBR_4800}
  CBR_9600 = 9600;
  {$EXTERNALSYM CBR_9600}
  CBR_14400 = 14400;
  {$EXTERNALSYM CBR_14400}
  CBR_19200 = 19200;
  {$EXTERNALSYM CBR_19200}
  CBR_38400 = 38400;
  {$EXTERNALSYM CBR_38400}
  CBR_56000 = 56000;
  {$EXTERNALSYM CBR_56000}
  CBR_57600 = 57600;
  {$EXTERNALSYM CBR_57600}
  CBR_115200 = $1C200;
  {$EXTERNALSYM CBR_115200}
  CBR_128000 = $1F400;
  {$EXTERNALSYM CBR_128000}
  CBR_256000 = $3E800;
  {$EXTERNALSYM CBR_256000}

  { Error Flags }

  CE_RXOVER = 1;        { Receive Queue overflow }
  {$EXTERNALSYM CE_RXOVER}
  CE_OVERRUN = 2;       { Receive Overrun Error }
  {$EXTERNALSYM CE_OVERRUN}
  CE_RXPARITY = 4;      { Receive Parity Error }
  {$EXTERNALSYM CE_RXPARITY}
  CE_FRAME = 8;         { Receive Framing error }
  {$EXTERNALSYM CE_FRAME}
  CE_BREAK = $10;       { Break Detected }
  {$EXTERNALSYM CE_BREAK}
  CE_TXFULL = $100;     { TX Queue is full }
  {$EXTERNALSYM CE_TXFULL}
  CE_PTO = $200;        { LPTx Timeout }
  {$EXTERNALSYM CE_PTO}
  CE_IOE = $400;        { LPTx I/O Error }
  {$EXTERNALSYM CE_IOE}
  CE_DNS = $800;        { LPTx Device not selected }
  {$EXTERNALSYM CE_DNS}
  CE_OOP = $1000;       { LPTx Out-Of-Paper }
  {$EXTERNALSYM CE_OOP}
  CE_MODE = $8000;      { Requested mode unsupported }
  {$EXTERNALSYM CE_MODE}

  IE_BADID = LongWord(-1);        { Invalid or unsupported id }
  {$EXTERNALSYM IE_BADID}
  IE_OPEN = LongWord(-2);         { Device Already Open }
  {$EXTERNALSYM IE_OPEN}
  IE_NOPEN = LongWord(-3);        { Device Not Open }
  {$EXTERNALSYM IE_NOPEN}
  IE_MEMORY = LongWord(-4);       { Unable to allocate queues }
  {$EXTERNALSYM IE_MEMORY}
  IE_DEFAULT = LongWord(-5);      { Error in default parameters }
  {$EXTERNALSYM IE_DEFAULT}
  IE_HARDWARE = LongWord(-10);    { Hardware Not Present }
  {$EXTERNALSYM IE_HARDWARE}
  IE_BYTESIZE = LongWord(-11);    { Illegal Byte Size }
  {$EXTERNALSYM IE_BYTESIZE}
  IE_BAUDRATE = LongWord(-12);    { Unsupported BaudRate }
  {$EXTERNALSYM IE_BAUDRATE}

  { Events }

  EV_RXCHAR = 1;        { Any Character received }
  {$EXTERNALSYM EV_RXCHAR}
  EV_RXFLAG = 2;        { Received certain character }
  {$EXTERNALSYM EV_RXFLAG}
  EV_TXEMPTY = 4;       { Transmitt Queue Empty }
  {$EXTERNALSYM EV_TXEMPTY}
  EV_CTS = 8;           { CTS changed state }
  {$EXTERNALSYM EV_CTS}
  EV_DSR = $10;         { DSR changed state }
  {$EXTERNALSYM EV_DSR}
  EV_RLSD = $20;        { RLSD changed state }
  {$EXTERNALSYM EV_RLSD}
  EV_BREAK = $40;       { BREAK received }
  {$EXTERNALSYM EV_BREAK}
  EV_ERR = $80;         { Line status error occurred }
  {$EXTERNALSYM EV_ERR}
  EV_RING = $100;       { Ring signal detected }
  {$EXTERNALSYM EV_RING}
  EV_PERR = $200;       { Printer error occured }
  {$EXTERNALSYM EV_PERR}
  EV_RX80FULL = $400;   { Receive buffer is 80 percent full }
  {$EXTERNALSYM EV_RX80FULL}
  EV_EVENT1 = $800;     { Provider specific event 1 }
  {$EXTERNALSYM EV_EVENT1}
  EV_EVENT2 = $1000;    { Provider specific event 2 }
  {$EXTERNALSYM EV_EVENT2}

  { Escape functions }

  SETXOFF = 1;    { Simulate XOFF received }
  {$EXTERNALSYM SETXOFF}
  SETXON = 2;     { Simulate XON received }
  {$EXTERNALSYM SETXON}
  SETRTS = 3;     { Set RTS high }
  {$EXTERNALSYM SETRTS}
  CLRRTS = 4;     { Set RTS low }
  {$EXTERNALSYM CLRRTS}
  SETDTR = 5;     { Set DTR high }
  {$EXTERNALSYM SETDTR}
  CLRDTR = 6;     { Set DTR low }
  {$EXTERNALSYM CLRDTR}
  RESETDEV = 7;   { Reset device if possible }
  {$EXTERNALSYM RESETDEV}
  SETBREAK = 8;   { Set the device break line. }
  {$EXTERNALSYM SETBREAK}
  CLRBREAK = 9;   { Clear the device break line. }
  {$EXTERNALSYM CLRBREAK}

  { PURGE function flags. }

  PURGE_TXABORT = 1;     { Kill the pending/current writes to the comm port. }
  {$EXTERNALSYM PURGE_TXABORT}
  PURGE_RXABORT = 2;     { Kill the pending/current reads to the comm port. }
  {$EXTERNALSYM PURGE_RXABORT}
  PURGE_TXCLEAR = 4;     { Kill the transmit queue if there. }
  {$EXTERNALSYM PURGE_TXCLEAR}
  PURGE_RXCLEAR = 8;     { Kill the typeahead buffer if there. }
  {$EXTERNALSYM PURGE_RXCLEAR}

  LPTx = $80;     { Set if ID is for LPT device }
  {$EXTERNALSYM LPTx}

  { Modem Status Flags }

  MS_CTS_ON = DWORD($0010);
  {$EXTERNALSYM MS_CTS_ON}
  MS_DSR_ON = DWORD($0020);
  {$EXTERNALSYM MS_DSR_ON}
  MS_RING_ON = DWORD($0040);
  {$EXTERNALSYM MS_RING_ON}
  MS_RLSD_ON = DWORD($0080);
  {$EXTERNALSYM MS_RLSD_ON}

  { WaitSoundState() Constants }

  S_QUEUEEMPTY = 0;
  {$EXTERNALSYM S_QUEUEEMPTY}
  S_THRESHOLD = 1;
  {$EXTERNALSYM S_THRESHOLD}
  S_ALLTHRESHOLD = 2;
  {$EXTERNALSYM S_ALLTHRESHOLD}

  { Accent Modes }

  S_NORMAL = 0;
  {$EXTERNALSYM S_NORMAL}
  S_LEGATO = 1;
  {$EXTERNALSYM S_LEGATO}
  S_STACCATO = 2;
  {$EXTERNALSYM S_STACCATO}

  { SetSoundNoise() Sources }

  S_PERIOD512 = 0;     { Freq = N/512 high pitch, less coarse hiss }
  {$EXTERNALSYM S_PERIOD512}
  S_PERIOD1024 = 1;    { Freq = N/1024 }
  {$EXTERNALSYM S_PERIOD1024}
  S_PERIOD2048 = 2;    { Freq = N/2048 low pitch, more coarse hiss }
  {$EXTERNALSYM S_PERIOD2048}
  S_PERIODVOICE = 3;   { Source is frequency from voice channel (3) }
  {$EXTERNALSYM S_PERIODVOICE}
  S_WHITE512 = 4;      { Freq = N/512 high pitch, less coarse hiss }
  {$EXTERNALSYM S_WHITE512}
  S_WHITE1024 = 5;     { Freq = N/1024 }
  {$EXTERNALSYM S_WHITE1024}
  S_WHITE2048 = 6;     { Freq = N/2048 low pitch, more coarse hiss }
  {$EXTERNALSYM S_WHITE2048}
  S_WHITEVOICE = 7;    { Source is frequency from voice channel (3) }
  {$EXTERNALSYM S_WHITEVOICE}

  S_SERDVNA = LongWord(-1);     { Device not available  }
  {$EXTERNALSYM S_SERDVNA}
  S_SEROFM = LongWord(-2);      { Out of memory }
  {$EXTERNALSYM S_SEROFM}
  S_SERMACT = LongWord(-3);     { Music active }
  {$EXTERNALSYM S_SERMACT}
  S_SERQFUL = LongWord(-4);     { Queue full }
  {$EXTERNALSYM S_SERQFUL}
  S_SERBDNT = LongWord(-5);     { Invalid note }
  {$EXTERNALSYM S_SERBDNT}
  S_SERDLN = LongWord(-6);      { Invalid note length }
  {$EXTERNALSYM S_SERDLN}
  S_SERDCC = LongWord(-7);      { Invalid note count }
  {$EXTERNALSYM S_SERDCC}
  S_SERDTP = LongWord(-8);      { Invalid tempo }
  {$EXTERNALSYM S_SERDTP}
  S_SERDVL = LongWord(-9);      { Invalid volume }
  {$EXTERNALSYM S_SERDVL}
  S_SERDMD = LongWord(-10);     { Invalid mode }
  {$EXTERNALSYM S_SERDMD}
  S_SERDSH = LongWord(-11);     { Invalid shape }
  {$EXTERNALSYM S_SERDSH}
  S_SERDPT = LongWord(-12);     { Invalid pitch }
  {$EXTERNALSYM S_SERDPT}
  S_SERDFQ = LongWord(-13);     { Invalid frequency }
  {$EXTERNALSYM S_SERDFQ}
  S_SERDDR = LongWord(-14);     { Invalid duration }
  {$EXTERNALSYM S_SERDDR}
  S_SERDSR = LongWord(-15);     { Invalid source }
  {$EXTERNALSYM S_SERDSR}
  S_SERDST = LongWord(-16);     { Invalid state }
  {$EXTERNALSYM S_SERDST}

  NMPWAIT_WAIT_FOREVER = DWORD($FFFFFFFF);
  {$EXTERNALSYM NMPWAIT_WAIT_FOREVER}
  NMPWAIT_NOWAIT = 1;
  {$EXTERNALSYM NMPWAIT_NOWAIT}
  NMPWAIT_USE_DEFAULT_WAIT = 0;
  {$EXTERNALSYM NMPWAIT_USE_DEFAULT_WAIT}

  FS_CASE_IS_PRESERVED = FILE_CASE_PRESERVED_NAMES;
  {$EXTERNALSYM FS_CASE_IS_PRESERVED}
  FS_CASE_SENSITIVE = FILE_CASE_SENSITIVE_SEARCH;
  {$EXTERNALSYM FS_CASE_SENSITIVE}
  FS_UNICODE_STORED_ON_DISK = FILE_UNICODE_ON_DISK;
  {$EXTERNALSYM FS_UNICODE_STORED_ON_DISK}
  FS_PERSISTENT_ACLS = FILE_PERSISTENT_ACLS;
  {$EXTERNALSYM FS_PERSISTENT_ACLS}
  FS_VOL_IS_COMPRESSED = FILE_VOLUME_IS_COMPRESSED;
  {$EXTERNALSYM FS_VOL_IS_COMPRESSED}
  FS_FILE_COMPRESSION = FILE_FILE_COMPRESSION;
  {$EXTERNALSYM FS_FILE_COMPRESSION}

  FILE_MAP_COPY = SECTION_QUERY;
  {$EXTERNALSYM FILE_MAP_COPY}
  FILE_MAP_WRITE = SECTION_MAP_WRITE;
  {$EXTERNALSYM FILE_MAP_WRITE}
  FILE_MAP_READ = SECTION_MAP_READ;
  {$EXTERNALSYM FILE_MAP_READ}
  FILE_MAP_ALL_ACCESS = SECTION_ALL_ACCESS;
  {$EXTERNALSYM FILE_MAP_ALL_ACCESS}

  OF_READ = 0;
  {$EXTERNALSYM OF_READ}
  OF_WRITE = 1;
  {$EXTERNALSYM OF_WRITE}
  OF_READWRITE = 2;
  {$EXTERNALSYM OF_READWRITE}
  OF_SHARE_COMPAT = 0;
  {$EXTERNALSYM OF_SHARE_COMPAT}
  OF_SHARE_EXCLUSIVE = $10;
  {$EXTERNALSYM OF_SHARE_EXCLUSIVE}
  OF_SHARE_DENY_WRITE = $20;
  {$EXTERNALSYM OF_SHARE_DENY_WRITE}
  OF_SHARE_DENY_READ = 48;
  {$EXTERNALSYM OF_SHARE_DENY_READ}
  OF_SHARE_DENY_NONE = $40;
  {$EXTERNALSYM OF_SHARE_DENY_NONE}
  OF_PARSE = $100;
  {$EXTERNALSYM OF_PARSE}
  OF_DELETE = $200;
  {$EXTERNALSYM OF_DELETE}
  OF_VERIFY = $400;
  {$EXTERNALSYM OF_VERIFY}
  OF_CANCEL = $800;
  {$EXTERNALSYM OF_CANCEL}
  OF_CREATE = $1000;
  {$EXTERNALSYM OF_CREATE}
  OF_PROMPT = $2000;
  {$EXTERNALSYM OF_PROMPT}
  OF_EXIST = $4000;
  {$EXTERNALSYM OF_EXIST}
  OF_REOPEN = $8000;
  {$EXTERNALSYM OF_REOPEN}

  OFS_MAXPATHNAME = 128;
  {$EXTERNALSYM OFS_MAXPATHNAME}
type
  POFStruct = ^TOFStruct;
  _OFSTRUCT = record
    cBytes: Byte;
    fFixedDisk: Byte;
    nErrCode: Word;
    Reserved1: Word;
    Reserved2: Word;
    szPathName: array[0..OFS_MAXPATHNAME-1] of CHAR;
  end;
  {$EXTERNALSYM _OFSTRUCT}
  TOFStruct = _OFSTRUCT;
  OFSTRUCT = _OFSTRUCT;
  {$EXTERNALSYM OFSTRUCT}

function InterlockedIncrement(var Addend: Integer): Integer; stdcall;
{$EXTERNALSYM InterlockedIncrement}
function InterlockedDecrement(var Addend: Integer): Integer; stdcall;
{$EXTERNALSYM InterlockedDecrement}
function InterlockedExchange(var Target: Integer; Value: Integer): Integer; stdcall;
{$EXTERNALSYM InterlockedExchange}
function InterlockedCompareExchange(var Destination: Longint; Exchange: Longint; Comperand: Longint): Longint stdcall;
{$EXTERNALSYM InterlockedCompareExchange}
function InterlockedExchangeAdd(Addend: PLongint; Value: Longint): Longint stdcall; overload;
{$EXTERNALSYM InterlockedExchangeAdd}
function InterlockedExchangeAdd(var Addend: Longint; Value: Longint): Longint stdcall; overload;
{$EXTERNALSYM InterlockedExchangeAdd}

{$IFDEF MSWINDOWS}
function FreeResource(hResData: HGLOBAL): BOOL; stdcall;
{$EXTERNALSYM FreeResource}
function LockResource(hResData: HGLOBAL): Pointer; stdcall;
{$EXTERNALSYM LockResource}
function UnlockResource(hResData: THandle): BOOL; inline;
{$EXTERNALSYM UnlockResource}
{$ENDIF}

const
  MAXINTATOM = $C000;
  {$EXTERNALSYM MAXINTATOM}
  INVALID_ATOM = 0;
  {$EXTERNALSYM INVALID_ATOM}

type
  MakeIntAtomA = PAnsiChar;
  MakeIntAtomW = PWideChar;
  MakeIntAtom = MakeIntAtomA;

function FreeLibrary(hLibModule: HMODULE): BOOL; stdcall;
{$EXTERNALSYM FreeLibrary}
procedure FreeLibraryAndExitThread(hLibModule: HMODULE; dwExitCode: DWORD); stdcall;
{$EXTERNALSYM FreeLibraryAndExitThread}
function DisableThreadLibraryCalls(hLibModule: HMODULE): BOOL; stdcall;
{$EXTERNALSYM DisableThreadLibraryCalls}
function GetProcAddress(hModule: HMODULE; lpProcName: LPCSTR): FARPROC; stdcall;
{$EXTERNALSYM GetProcAddress}
function GetVersion: DWORD; stdcall;
{$EXTERNALSYM GetVersion}
function GlobalAlloc(uFlags: UINT; dwBytes: DWORD): HGLOBAL; stdcall;
{$EXTERNALSYM GlobalAlloc}
function GlobalReAlloc(hMem: HGLOBAL; dwBytes: DWORD; uFlags: UINT): HGLOBAL; stdcall;
{$EXTERNALSYM GlobalReAlloc}
function GlobalSize(hMem: HGLOBAL): DWORD; stdcall;
{$EXTERNALSYM GlobalSize}
function GlobalFlags(hMem: HGLOBAL): UINT; stdcall;
{$EXTERNALSYM GlobalFlags}
function GlobalLock(hMem: HGLOBAL): Pointer; stdcall;
{$EXTERNALSYM GlobalLock}
function GlobalHandle(Mem: Pointer): HGLOBAL; stdcall;
{$EXTERNALSYM GlobalHandle}
function GlobalUnlock(hMem: HGLOBAL): BOOL; stdcall;
{$EXTERNALSYM GlobalUnlock}
function GlobalFree(hMem: HGLOBAL): HGLOBAL; stdcall;
{$EXTERNALSYM GlobalFree}
function GlobalCompact(dwMinFree: DWORD): UINT; stdcall;
{$EXTERNALSYM GlobalCompact}
procedure GlobalFix(hMem: HGLOBAL); stdcall;
{$EXTERNALSYM GlobalFix}
procedure GlobalUnfix(hMem: HGLOBAL); stdcall;
{$EXTERNALSYM GlobalUnfix}
function GlobalWire(hMem: HGLOBAL): Pointer; stdcall;
{$EXTERNALSYM GlobalWire}
function GlobalUnWire(hMem: HGLOBAL): BOOL; stdcall;
{$EXTERNALSYM GlobalUnWire}
procedure GlobalMemoryStatus(var lpBuffer: TMemoryStatus); stdcall;
{$EXTERNALSYM GlobalMemoryStatus}
function LocalAlloc(uFlags, uBytes: UINT): HLOCAL; stdcall;
{$EXTERNALSYM LocalAlloc}
function LocalReAlloc(hMem: HLOCAL; uBytes, uFlags: UINT): HLOCAL; stdcall;
{$EXTERNALSYM LocalReAlloc}
function LocalLock(hMem: HLOCAL): Pointer; stdcall;
{$EXTERNALSYM LocalLock}
function LocalUnlock(hMem: HLOCAL): BOOL; stdcall;
{$EXTERNALSYM LocalUnlock}
function LocalSize(hMem: HLOCAL): UINT; stdcall;
{$EXTERNALSYM LocalSize}
function LocalFlags(hMem: HLOCAL): UINT; stdcall;
{$EXTERNALSYM LocalFlags}
function LocalFree(hMem: HLOCAL): HLOCAL; stdcall;
{$EXTERNALSYM LocalFree}
function LocalShrink(hMem: HLOCAL; cbNewSize: UINT): UINT; stdcall;
{$EXTERNALSYM LocalShrink}
function LocalCompact(uMinFree: UINT): UINT; stdcall;
{$EXTERNALSYM LocalCompact}
function FlushInstructionCache(hProcess: THandle; const lpBaseAddress: Pointer; dwSize: DWORD): BOOL; stdcall;
{$EXTERNALSYM FlushInstructionCache}
function VirtualAlloc(lpvAddress: Pointer; dwSize, flAllocationType, flProtect: DWORD): Pointer; stdcall;
{$EXTERNALSYM VirtualAlloc}
function VirtualFree(lpAddress: Pointer; dwSize, dwFreeType: DWORD): BOOL; stdcall;
{$EXTERNALSYM VirtualFree}
function VirtualProtect(lpAddress: Pointer; dwSize, flNewProtect: DWORD;
  lpflOldProtect: Pointer): BOOL; stdcall; overload;
{$EXTERNALSYM VirtualProtect}
function VirtualProtect(lpAddress: Pointer; dwSize, flNewProtect: DWORD;
  var OldProtect: DWORD): BOOL; stdcall; overload;
{$EXTERNALSYM VirtualProtect}
function VirtualQuery(lpAddress: Pointer;
  var lpBuffer: TMemoryBasicInformation; dwLength: DWORD): DWORD; stdcall;
{$EXTERNALSYM VirtualQuery}
function VirtualAllocEx(hProcess: THandle; lpAddress: Pointer;
  dwSize, flAllocationType: DWORD; flProtect: DWORD): Pointer; stdcall;
{$EXTERNALSYM VirtualAllocEx}
function VirtualFreeEx(hProcess: THandle; lpAddress: Pointer;
        dwSize, dwFreeType: DWORD): Pointer; stdcall;
{$EXTERNALSYM VirtualFreeEx}
function VirtualProtectEx(hProcess: THandle; lpAddress: Pointer;
  dwSize, flNewProtect: DWORD; lpflOldProtect: Pointer): BOOL; stdcall; overload;
{$EXTERNALSYM VirtualProtectEx}  
function VirtualProtectEx(hProcess: THandle; lpAddress: Pointer;
  dwSize, flNewProtect: DWORD; var OldProtect: DWORD): BOOL; stdcall; overload;
{$EXTERNALSYM VirtualProtectEx}
function VirtualQueryEx(hProcess: THandle; lpAddress: Pointer;
  var lpBuffer: TMemoryBasicInformation; dwLength: DWORD): DWORD; stdcall;
{$EXTERNALSYM VirtualQueryEx}
function HeapCreate(flOptions, dwInitialSize, dwMaximumSize: DWORD): THandle; stdcall;
{$EXTERNALSYM HeapCreate}
function HeapDestroy(hHeap: THandle): BOOL; stdcall;
{$EXTERNALSYM HeapDestroy}
function HeapAlloc(hHeap: THandle; dwFlags, dwBytes: DWORD): Pointer; stdcall;
{$EXTERNALSYM HeapAlloc}
function HeapReAlloc(hHeap: THandle; dwFlags: DWORD; lpMem: Pointer; dwBytes: DWORD): Pointer; stdcall;
{$EXTERNALSYM HeapReAlloc}
function HeapFree(hHeap: THandle; dwFlags: DWORD; lpMem: Pointer): BOOL; stdcall;
{$EXTERNALSYM HeapFree}
function HeapSize(hHeap: THandle; dwFlags: DWORD; lpMem: Pointer): DWORD; stdcall;
{$EXTERNALSYM HeapSize}
function HeapValidate(hHeap: THandle; dwFlags: DWORD; lpMem: Pointer): BOOL; stdcall;
{$EXTERNALSYM HeapValidate}
function HeapCompact(hHeap: THandle; dwFlags: DWORD): UINT; stdcall;
{$EXTERNALSYM HeapCompact}
function GetProcessHeap: THandle; stdcall;
{$EXTERNALSYM GetProcessHeap}
function GetProcessHeaps(NumberOfHeaps: DWORD; var ProcessHeaps: THandle): DWORD; stdcall;
{$EXTERNALSYM GetProcessHeaps}

type
  PProcessHeapEntry = ^TProcessHeapEntry;
  _PROCESS_HEAP_ENTRY = record
    lpData: Pointer;
    cbData: DWORD;
    cbOverhead: Byte;
    iRegionIndex: Byte;
    wFlags: Word;
    case Integer of
      0: (
        hMem: THandle);
      1: (
        dwCommittedSize: DWORD;
        dwUnCommittedSize: DWORD;
        lpFirstBlock: Pointer;
        lpLastBlock: Pointer);
  end;
  {$EXTERNALSYM _PROCESS_HEAP_ENTRY}
  TProcessHeapEntry = _PROCESS_HEAP_ENTRY;
  PROCESS_HEAP_ENTRY = _PROCESS_HEAP_ENTRY;
  {$EXTERNALSYM PROCESS_HEAP_ENTRY}

const
  PROCESS_HEAP_REGION = 1;
  {$EXTERNALSYM PROCESS_HEAP_REGION}
  PROCESS_HEAP_UNCOMMITTED_RANGE = 2;
  {$EXTERNALSYM PROCESS_HEAP_UNCOMMITTED_RANGE}
  PROCESS_HEAP_ENTRY_BUSY = 4;
  {$EXTERNALSYM PROCESS_HEAP_ENTRY_BUSY}
  PROCESS_HEAP_ENTRY_MOVEABLE = $10;
  {$EXTERNALSYM PROCESS_HEAP_ENTRY_MOVEABLE}
  PROCESS_HEAP_ENTRY_DDESHARE = $20;
  {$EXTERNALSYM PROCESS_HEAP_ENTRY_DDESHARE}

function HeapLock(hHeap: THandle): BOOL; stdcall;
{$EXTERNALSYM HeapLock}
function HeapUnlock(hHeap: THandle): BOOL; stdcall;
{$EXTERNALSYM HeapUnlock}
function HeapWalk(hHeap: THandle; var lpEntry: TProcessHeapEntry): BOOL; stdcall;
{$EXTERNALSYM HeapWalk}

const
  HEAP_NO_SERIALIZE               = $00000001;
  {$EXTERNALSYM HEAP_NO_SERIALIZE}
  HEAP_GROWABLE                   = $00000002;
  {$EXTERNALSYM HEAP_GROWABLE}
  HEAP_GENERATE_EXCEPTIONS        = $00000004;
  {$EXTERNALSYM HEAP_GENERATE_EXCEPTIONS}
  HEAP_ZERO_MEMORY                = $00000008;
  {$EXTERNALSYM HEAP_ZERO_MEMORY}
  HEAP_REALLOC_IN_PLACE_ONLY      = $00000010;
  {$EXTERNALSYM HEAP_REALLOC_IN_PLACE_ONLY}
  HEAP_TAIL_CHECKING_ENABLED      = $00000020;
  {$EXTERNALSYM HEAP_TAIL_CHECKING_ENABLED}
  HEAP_FREE_CHECKING_ENABLED      = $00000040;
  {$EXTERNALSYM HEAP_FREE_CHECKING_ENABLED}
  HEAP_DISABLE_COALESCE_ON_FREE   = $00000080;
  {$EXTERNALSYM HEAP_DISABLE_COALESCE_ON_FREE}
  HEAP_CREATE_ALIGN_16            = $00010000;
  {$EXTERNALSYM HEAP_CREATE_ALIGN_16}
  HEAP_CREATE_ENABLE_TRACING      = $00020000;
  {$EXTERNALSYM HEAP_CREATE_ENABLE_TRACING}
  HEAP_CREATE_ENABLE_EXECUTE      = $00040000;
  {$EXTERNALSYM HEAP_CREATE_ENABLE_EXECUTE}
  HEAP_MAXIMUM_TAG                = $0FFF;
  {$EXTERNALSYM HEAP_MAXIMUM_TAG}
  HEAP_PSEUDO_TAG_FLAG            = $8000;
  {$EXTERNALSYM HEAP_PSEUDO_TAG_FLAG}
  HEAP_TAG_SHIFT                  = 16;
  {$EXTERNALSYM HEAP_TAG_SHIFT}
  //HEAP_MAKE_TAG_FLAGS( b, o ) ((DWORD)((b) + ((o) << 16)))

{ GetBinaryType return values.}

const
  SCS_32BIT_BINARY = 0;
  {$EXTERNALSYM SCS_32BIT_BINARY}
  SCS_DOS_BINARY = 1;
  {$EXTERNALSYM SCS_DOS_BINARY}
  SCS_WOW_BINARY = 2;
  {$EXTERNALSYM SCS_WOW_BINARY}
  SCS_PIF_BINARY = 3;
  {$EXTERNALSYM SCS_PIF_BINARY}
  SCS_POSIX_BINARY = 4;
  {$EXTERNALSYM SCS_POSIX_BINARY}
  SCS_OS216_BINARY = 5;
  {$EXTERNALSYM SCS_OS216_BINARY}

function GetBinaryType(lpApplicationName: PChar; var lpBinaryType: DWORD): BOOL; stdcall;
{$EXTERNALSYM GetBinaryType}
function GetBinaryTypeA(lpApplicationName: PAnsiChar; var lpBinaryType: DWORD): BOOL; stdcall;
{$EXTERNALSYM GetBinaryTypeA}
function GetBinaryTypeW(lpApplicationName: PWideChar; var lpBinaryType: DWORD): BOOL; stdcall;
{$EXTERNALSYM GetBinaryTypeW}
function GetShortPathName(lpszLongPath: PChar; lpszShortPath: PChar;
  cchBuffer: DWORD): DWORD; stdcall;
{$EXTERNALSYM GetShortPathName}
function GetShortPathNameA(lpszLongPath: PAnsiChar; lpszShortPath: PAnsiChar;
  cchBuffer: DWORD): DWORD; stdcall;
{$EXTERNALSYM GetShortPathNameA}
function GetShortPathNameW(lpszLongPath: PWideChar; lpszShortPath: PWideChar;
  cchBuffer: DWORD): DWORD; stdcall;
{$EXTERNALSYM GetShortPathNameW}
function GetProcessAffinityMask(hProcess: THandle;
  var lpProcessAffinityMask, lpSystemAffinityMask: DWORD): BOOL; stdcall;
{$EXTERNALSYM GetProcessAffinityMask}
function SetProcessAffinityMask(hProcess: THandle;
  dwProcessAffinityMask: DWORD): BOOL; stdcall;
{$EXTERNALSYM SetProcessAffinityMask}
function GetProcessTimes(hProcess: THandle;
  var lpCreationTime, lpExitTime, lpKernelTime, lpUserTime: TFileTime): BOOL; stdcall;
{$EXTERNALSYM GetProcessTimes}
function GetProcessWorkingSetSize(hProcess: THandle;
  var lpMinimumWorkingSetSize, lpMaximumWorkingSetSize: DWORD): BOOL; stdcall;
{$EXTERNALSYM GetProcessWorkingSetSize}
function SetProcessWorkingSetSize(hProcess: THandle;
  dwMinimumWorkingSetSize, dwMaximumWorkingSetSize: DWORD): BOOL; stdcall;
{$EXTERNALSYM SetProcessWorkingSetSize}
function OpenProcess(dwDesiredAccess: DWORD; bInheritHandle: BOOL; dwProcessId: DWORD): THandle; stdcall;
{$EXTERNALSYM OpenProcess}
function GetCurrentProcess: THandle; stdcall;
{$EXTERNALSYM GetCurrentProcess}
function GetCurrentProcessId: DWORD; stdcall;
{$EXTERNALSYM GetCurrentProcessId}
procedure ExitProcess(uExitCode: UINT); stdcall;
{$EXTERNALSYM ExitProcess}
function TerminateProcess(hProcess: THandle; uExitCode: UINT): BOOL; stdcall;
{$EXTERNALSYM TerminateProcess}
function GetExitCodeProcess(hProcess: THandle; var lpExitCode: DWORD): BOOL; stdcall;
{$EXTERNALSYM GetExitCodeProcess}
procedure FatalExit(ExitCode: Integer); stdcall;
{$EXTERNALSYM FatalExit}
function GetEnvironmentStrings: PChar; stdcall;
{$EXTERNALSYM GetEnvironmentStrings}
function GetEnvironmentStringsA: PAnsiChar; stdcall;
{$EXTERNALSYM GetEnvironmentStringsA}
function GetEnvironmentStringsW: PWideChar; stdcall;
{$EXTERNALSYM GetEnvironmentStringsW}
function FreeEnvironmentStrings(EnvBlock: PChar): BOOL; stdcall;
{$EXTERNALSYM FreeEnvironmentStrings}
function FreeEnvironmentStringsA(EnvBlock: PAnsiChar): BOOL; stdcall;
{$EXTERNALSYM FreeEnvironmentStringsA}
function FreeEnvironmentStringsW(EnvBlock: PWideChar): BOOL; stdcall;
{$EXTERNALSYM FreeEnvironmentStringsW}
procedure RaiseException(dwExceptionCode, dwExceptionFlags, nNumberOfArguments: DWORD;
  lpArguments: PDWORD); stdcall;
{$EXTERNALSYM RaiseException}
function UnhandledExceptionFilter(const ExceptionInfo: TExceptionPointers): Longint; stdcall;
{$EXTERNALSYM UnhandledExceptionFilter}
function CreateFiber(dwStackSize: DWORD; lpStartAddress: TFNFiberStartRoutine;
  lpParameter: Pointer): Pointer; stdcall;
{$EXTERNALSYM CreateFiber}
function DeleteFiber(lpFiber: Pointer): BOOL; stdcall;
{$EXTERNALSYM DeleteFiber}
function ConvertThreadToFiber(lpParameter: Pointer): BOOL; stdcall;
{$EXTERNALSYM ConvertThreadToFiber}
function SwitchToFiber(lpFiber: Pointer): BOOL; stdcall;
{$EXTERNALSYM SwitchToFiber}
function SwitchToThread: BOOL; stdcall;
{$EXTERNALSYM SwitchToThread}

type



  TFNTopLevelExceptionFilter = TFarProc;


function SetUnhandledExceptionFilter(lpTopLevelExceptionFilter: TFNTopLevelExceptionFilter):
  TFNTopLevelExceptionFilter; stdcall;
{$EXTERNALSYM SetUnhandledExceptionFilter}
function CreateThread(lpThreadAttributes: Pointer;
  dwStackSize: DWORD; lpStartAddress: TFNThreadStartRoutine;
  lpParameter: Pointer; dwCreationFlags: DWORD; var lpThreadId: DWORD): THandle; stdcall;
{$EXTERNALSYM CreateThread}
function CreateRemoteThread(hProcess: THandle; lpThreadAttributes: Pointer;
  dwStackSize: DWORD; lpStartAddress: TFNThreadStartRoutine; lpParameter: Pointer;
  dwCreationFlags: DWORD; var lpThreadId: DWORD): THandle; stdcall;
{$EXTERNALSYM CreateRemoteThread}
function GetCurrentThread: THandle; stdcall;
{$EXTERNALSYM GetCurrentThread}
function GetCurrentThreadId: DWORD; stdcall;
{$EXTERNALSYM GetCurrentThreadId}
function SetThreadAffinityMask(hThread: THandle; dwThreadAffinityMask: DWORD): DWORD; stdcall;
{$EXTERNALSYM SetThreadAffinityMask}
function SetThreadIdealProcessor(hThread: THandle; dwIdealProcessor: DWORD): BOOL; stdcall;
{$EXTERNALSYM SetThreadIdealProcessor}
function SetProcessPriorityBoost(hThread: THandle; DisablePriorityBoost: Bool): BOOL; stdcall;
{$EXTERNALSYM SetProcessPriorityBoost}
function GetProcessPriorityBoost(hThread: THandle; var DisablePriorityBoost: Bool): BOOL; stdcall;
{$EXTERNALSYM GetProcessPriorityBoost}
function SetThreadPriority(hThread: THandle; nPriority: Integer): BOOL; stdcall;
{$EXTERNALSYM SetThreadPriority}
function GetThreadPriority(hThread: THandle): Integer; stdcall;
{$EXTERNALSYM GetThreadPriority}
function SetThreadPriorityBoost(hThread: THandle; DisablePriorityBoost: Bool): BOOL; stdcall;
{$EXTERNALSYM SetThreadPriorityBoost}
function GetThreadPriorityBoost(hThread: THandle; var DisablePriorityBoost: Bool): BOOL; stdcall;
{$EXTERNALSYM GetThreadPriorityBoost}
function GetThreadTimes(hThread: THandle;
  var lpCreationTime, lpExitTime, lpKernelTime, lpUserTime: TFileTime): BOOL; stdcall;
{$EXTERNALSYM GetThreadTimes}
procedure ExitThread(dwExitCode: DWORD); stdcall;
{$EXTERNALSYM ExitThread}
function TerminateThread(hThread: THandle; dwExitCode: DWORD): BOOL; stdcall;
{$EXTERNALSYM TerminateThread}
function GetExitCodeThread(hThread: THandle; var lpExitCode: DWORD): BOOL; stdcall;
{$EXTERNALSYM GetExitCodeThread}
function GetThreadSelectorEntry(hThread: THandle; dwSelector: DWORD;
  var lpSelectorEntry: TLDTEntry): BOOL; stdcall;
{$EXTERNALSYM GetThreadSelectorEntry}
function GetLastError: DWORD; stdcall;
{$EXTERNALSYM GetLastError}
procedure SetLastError(dwErrCode: DWORD); stdcall;
{$EXTERNALSYM SetLastError}
function GetOverlappedResult(hFile: THandle; const lpOverlapped: TOverlapped;
  var lpNumberOfBytesTransferred: DWORD; bWait: BOOL): BOOL; stdcall;
{$EXTERNALSYM GetOverlappedResult}
function CreateIoCompletionPort(FileHandle, ExistingCompletionPort: THandle;
  CompletionKey, NumberOfConcurrentThreads: DWORD): THandle; stdcall;
{$EXTERNALSYM CreateIoCompletionPort}
function GetQueuedCompletionStatus(CompletionPort: THandle;
  var lpNumberOfBytesTransferred, lpCompletionKey: DWORD;
  var lpOverlapped: POverlapped; dwMilliseconds: DWORD): BOOL; stdcall;
{$EXTERNALSYM GetQueuedCompletionStatus}
function PostQueuedCompletionStatus(CompletionPort: THandle; dwNumberOfBytesTransferred: DWORD;
  dwCompletionKey: DWORD; lpOverlapped: POverlapped): BOOL; stdcall;
{$EXTERNALSYM PostQueuedCompletionStatus}

const
  SEM_FAILCRITICALERRORS = 1;
  {$EXTERNALSYM SEM_FAILCRITICALERRORS}
  SEM_NOGPFAULTERRORBOX = 2;
  {$EXTERNALSYM SEM_NOGPFAULTERRORBOX}
  SEM_NOALIGNMENTFAULTEXCEPT = 4;
  {$EXTERNALSYM SEM_NOALIGNMENTFAULTEXCEPT}
  SEM_NOOPENFILEERRORBOX = $8000;
  {$EXTERNALSYM SEM_NOOPENFILEERRORBOX}

function SetErrorMode(uMode: UINT): UINT; stdcall;
{$EXTERNALSYM SetErrorMode}
function ReadProcessMemory(hProcess: THandle; const lpBaseAddress: Pointer; lpBuffer: Pointer;
  nSize: DWORD; var lpNumberOfBytesRead: DWORD): BOOL; stdcall;
{$EXTERNALSYM ReadProcessMemory}
function WriteProcessMemory(hProcess: THandle; const lpBaseAddress: Pointer; lpBuffer: Pointer;
  nSize: DWORD; var lpNumberOfBytesWritten: DWORD): BOOL; stdcall;
{$EXTERNALSYM WriteProcessMemory}
function GetThreadContext(hThread: THandle; var lpContext: TContext): BOOL; stdcall;
{$EXTERNALSYM GetThreadContext}
function SetThreadContext(hThread: THandle; const lpContext: TContext): BOOL; stdcall;
{$EXTERNALSYM SetThreadContext}
function SuspendThread(hThread: THandle): DWORD; stdcall;
{$EXTERNALSYM SuspendThread}
function ResumeThread(hThread: THandle): DWORD; stdcall;
{$EXTERNALSYM ResumeThread}

type



  TFNAPCProc = TFarProc;


function QueueUserAPC(pfnAPC: TFNAPCProc; hThread: THandle; dwData: DWORD): BOOL; stdcall;
{$EXTERNALSYM QueueUserAPC}
procedure DebugBreak; stdcall;
{$EXTERNALSYM DebugBreak}
function WaitForDebugEvent(var lpDebugEvent: TDebugEvent; dwMilliseconds: DWORD): BOOL; stdcall;
{$EXTERNALSYM WaitForDebugEvent}
function ContinueDebugEvent(dwProcessId, dwThreadId, dwContinueStatus: DWORD): BOOL; stdcall;
{$EXTERNALSYM ContinueDebugEvent}
function DebugActiveProcess(dwProcessId: DWORD): BOOL; stdcall;
{$EXTERNALSYM DebugActiveProcess}

procedure InitializeCriticalSection(var lpCriticalSection: TRTLCriticalSection); stdcall;
{$EXTERNALSYM InitializeCriticalSection}
procedure EnterCriticalSection(var lpCriticalSection: TRTLCriticalSection); stdcall;
{$EXTERNALSYM EnterCriticalSection}
procedure LeaveCriticalSection(var lpCriticalSection: TRTLCriticalSection); stdcall;
{$EXTERNALSYM LeaveCriticalSection}
function InitializeCriticalSectionAndSpinCount(var lpCriticalSection: TRTLCriticalSection; dwSpinCount: DWORD): BOOL; stdcall;
{$EXTERNALSYM InitializeCriticalSectionAndSpinCount}
function SetCriticalSectionSpinCount(var lpCriticalSection: TRTLCriticalSection; dwSpinCount: DWORD): DWORD; stdcall;
{$EXTERNALSYM SetCriticalSectionSpinCount}
function TryEnterCriticalSection(var lpCriticalSection: TRTLCriticalSection): BOOL; stdcall;
{$EXTERNALSYM TryEnterCriticalSection}
procedure DeleteCriticalSection(var lpCriticalSection: TRTLCriticalSection); stdcall;
{$EXTERNALSYM DeleteCriticalSection}

function SetEvent(hEvent: THandle): BOOL; stdcall;
{$EXTERNALSYM SetEvent}
function ResetEvent(hEvent: THandle): BOOL; stdcall;
{$EXTERNALSYM ResetEvent}
function PulseEvent(hEvent: THandle): BOOL; stdcall;
{$EXTERNALSYM PulseEvent}
function ReleaseSemaphore(hSemaphore: THandle; lReleaseCount: Longint;
  lpPreviousCount: Pointer): BOOL; stdcall;
{$EXTERNALSYM ReleaseSemaphore}
function ReleaseMutex(hMutex: THandle): BOOL; stdcall;
{$EXTERNALSYM ReleaseMutex}
function WaitForSingleObject(hHandle: THandle; dwMilliseconds: DWORD): DWORD; stdcall;
{$EXTERNALSYM WaitForSingleObject}

type
  TWOHandleArray = array[0..MAXIMUM_WAIT_OBJECTS - 1] of THandle;
  PWOHandleArray = ^TWOHandleArray;

function WaitForMultipleObjects(nCount: DWORD; lpHandles: PWOHandleArray;
  bWaitAll: BOOL; dwMilliseconds: DWORD): DWORD; stdcall;
{$EXTERNALSYM WaitForMultipleObjects}
procedure Sleep(dwMilliseconds: DWORD); stdcall;
{$EXTERNALSYM Sleep}
{$IFDEF MSWINDOWS}
function LoadResource(hModule: HINST; hResInfo: HRSRC): HGLOBAL; stdcall;
{$EXTERNALSYM LoadResource}
function SizeofResource(hModule: HINST; hResInfo: HRSRC): DWORD; stdcall;
{$EXTERNALSYM SizeofResource}
{$ENDIF}
function GlobalDeleteAtom(nAtom: ATOM): ATOM; stdcall;
{$EXTERNALSYM GlobalDeleteAtom}
function InitAtomTable(nSize: DWORD): BOOL; stdcall;
{$EXTERNALSYM InitAtomTable}
function DeleteAtom(nAtom: ATOM): ATOM; stdcall;
{$EXTERNALSYM DeleteAtom}
function SetHandleCount(uNumber: UINT): UINT; stdcall;
{$EXTERNALSYM SetHandleCount}
function GetLogicalDrives: DWORD; stdcall;
{$EXTERNALSYM GetLogicalDrives}
function LockFile(hFile: THandle; dwFileOffsetLow, dwFileOffsetHigh: DWORD;
  nNumberOfBytesToLockLow, nNumberOfBytesToLockHigh: DWORD): BOOL; stdcall;
{$EXTERNALSYM LockFile}
function UnlockFile(hFile: THandle; dwFileOffsetLow, dwFileOffsetHigh: DWORD;
  nNumberOfBytesToUnlockLow, nNumberOfBytesToUnlockHigh: DWORD): BOOL; stdcall;
{$EXTERNALSYM UnlockFile}
function LockFileEx(hFile: THandle; dwFlags, dwReserved: DWORD;
  nNumberOfBytesToLockLow, nNumberOfBytesToLockHigh: DWORD;
  const lpOverlapped: TOverlapped): BOOL; stdcall;
{$EXTERNALSYM LockFileEx}

const
  LOCKFILE_FAIL_IMMEDIATELY = 1;
  {$EXTERNALSYM LOCKFILE_FAIL_IMMEDIATELY}
  LOCKFILE_EXCLUSIVE_LOCK = 2;
  {$EXTERNALSYM LOCKFILE_EXCLUSIVE_LOCK}

function UnlockFileEx(hFile: THandle; dwReserved, nNumberOfBytesToUnlockLow: DWORD;
  nNumberOfBytesToUnlockHigh: DWORD; const lpOverlapped: TOverlapped): BOOL; stdcall;
{$EXTERNALSYM UnlockFileEx}

type
  PByHandleFileInformation = ^TByHandleFileInformation;
  _BY_HANDLE_FILE_INFORMATION = record
    dwFileAttributes: DWORD;
    ftCreationTime: TFileTime;
    ftLastAccessTime: TFileTime;
    ftLastWriteTime: TFileTime;
    dwVolumeSerialNumber: DWORD;
    nFileSizeHigh: DWORD;
    nFileSizeLow: DWORD;
    nNumberOfLinks: DWORD;
    nFileIndexHigh: DWORD;
    nFileIndexLow: DWORD;
  end;
  {$EXTERNALSYM _BY_HANDLE_FILE_INFORMATION}
  TByHandleFileInformation = _BY_HANDLE_FILE_INFORMATION;
  BY_HANDLE_FILE_INFORMATION = _BY_HANDLE_FILE_INFORMATION;
  {$EXTERNALSYM BY_HANDLE_FILE_INFORMATION}

function GetFileInformationByHandle(hFile: THandle; var lpFileInformation: TByHandleFileInformation): BOOL; stdcall;
{$EXTERNALSYM GetFileInformationByHandle}
function GetFileType(hFile: THandle): DWORD; stdcall;
{$EXTERNALSYM GetFileType}
function GetFileSize(hFile: THandle; lpFileSizeHigh: Pointer): DWORD; stdcall;
{$EXTERNALSYM GetFileSize}
function GetStdHandle(nStdHandle: DWORD): THandle; stdcall;
{$EXTERNALSYM GetStdHandle}
function SetStdHandle(nStdHandle: DWORD; hHandle: THandle): BOOL; stdcall;
{$EXTERNALSYM SetStdHandle}
function WriteFile(hFile: THandle; const Buffer; nNumberOfBytesToWrite: DWORD;
  var lpNumberOfBytesWritten: DWORD; lpOverlapped: POverlapped): BOOL; stdcall;
{$EXTERNALSYM WriteFile}
function ReadFile(hFile: THandle; var Buffer; nNumberOfBytesToRead: DWORD;
  var lpNumberOfBytesRead: DWORD; lpOverlapped: POverlapped): BOOL; stdcall;
{$EXTERNALSYM ReadFile}
function FlushFileBuffers(hFile: THandle): BOOL; stdcall;
{$EXTERNALSYM FlushFileBuffers}
function DeviceIoControl(hDevice: THandle; dwIoControlCode: DWORD; lpInBuffer: Pointer;
  nInBufferSize: DWORD; lpOutBuffer: Pointer; nOutBufferSize: DWORD;
  var lpBytesReturned: DWORD; lpOverlapped: POverlapped): BOOL; stdcall;
{$EXTERNALSYM DeviceIoControl}
function SetEndOfFile(hFile: THandle): BOOL; stdcall;
{$EXTERNALSYM SetEndOfFile}
function SetFilePointer(hFile: THandle; lDistanceToMove: Longint;
  lpDistanceToMoveHigh: Pointer; dwMoveMethod: DWORD): DWORD; stdcall;
{$EXTERNALSYM SetFilePointer}
function FindClose(hFindFile: THandle): BOOL; stdcall;
{$EXTERNALSYM FindClose}
function GetFileTime(hFile: THandle;
  lpCreationTime, lpLastAccessTime, lpLastWriteTime: PFileTime): BOOL; stdcall;
{$EXTERNALSYM GetFileTime}
function SetFileTime(hFile: THandle;
  lpCreationTime, lpLastAccessTime, lpLastWriteTime: PFileTime): BOOL; stdcall;
{$EXTERNALSYM SetFileTime}
function CloseHandle(hObject: THandle): BOOL; stdcall;
{$EXTERNALSYM CloseHandle}
function DuplicateHandle(hSourceProcessHandle, hSourceHandle, hTargetProcessHandle: THandle;
  lpTargetHandle: PHandle; dwDesiredAccess: DWORD;
  bInheritHandle: BOOL; dwOptions: DWORD): BOOL; stdcall;
{$EXTERNALSYM DuplicateHandle}
function GetHandleInformation(hObject: THandle; var lpdwFlags: DWORD): BOOL; stdcall;
{$EXTERNALSYM GetHandleInformation}
function SetHandleInformation(hObject: THandle; dwMask: DWORD; dwFlags: DWORD): BOOL; stdcall;
{$EXTERNALSYM SetHandleInformation}

const
  HANDLE_FLAG_INHERIT = 1;
  {$EXTERNALSYM HANDLE_FLAG_INHERIT}
  HANDLE_FLAG_PROTECT_FROM_CLOSE = 2;
  {$EXTERNALSYM HANDLE_FLAG_PROTECT_FROM_CLOSE}
  HINSTANCE_ERROR = $20;
  {$EXTERNALSYM HINSTANCE_ERROR}

function LoadModule(lpModuleName: LPCSTR; lpParameterBlock: Pointer): DWORD; stdcall;
{$EXTERNALSYM LoadModule}
function WinExec(lpCmdLine: LPCSTR; uCmdShow: UINT): UINT; stdcall;
{$EXTERNALSYM WinExec}
function ClearCommBreak(hFile: THandle): BOOL; stdcall;
{$EXTERNALSYM ClearCommBreak}
function ClearCommError(hFile: THandle; var lpErrors: DWORD; lpStat: PComStat): BOOL; stdcall;
{$EXTERNALSYM ClearCommError}
function SetupComm(hFile: THandle; dwInQueue, dwOutQueue: DWORD): BOOL; stdcall;
{$EXTERNALSYM SetupComm}
function EscapeCommFunction(hFile: THandle; dwFunc: DWORD): BOOL; stdcall;
{$EXTERNALSYM EscapeCommFunction}
function GetCommConfig(hCommDev: THandle; var lpCC: TCommConfig; var lpdwSize: DWORD): BOOL; stdcall;
{$EXTERNALSYM GetCommConfig}
function GetCommMask(hFile: THandle; var lpEvtMask: DWORD): BOOL; stdcall;
{$EXTERNALSYM GetCommMask}
function GetCommProperties(hFile: THandle; var lpCommProp: TCommProp): BOOL; stdcall;
{$EXTERNALSYM GetCommProperties}
function GetCommModemStatus(hFile: THandle; var lpModemStat: DWORD): BOOL; stdcall;
{$EXTERNALSYM GetCommModemStatus}
function GetCommState(hFile: THandle; var lpDCB: TDCB): BOOL; stdcall;
{$EXTERNALSYM GetCommState}
function GetCommTimeouts(hFile: THandle; var lpCommTimeouts: TCommTimeouts): BOOL; stdcall;
{$EXTERNALSYM GetCommTimeouts}
function PurgeComm(hFile: THandle; dwFlags: DWORD): BOOL; stdcall;
{$EXTERNALSYM PurgeComm}
function SetCommBreak(hFile: THandle): BOOL; stdcall;
{$EXTERNALSYM SetCommBreak}
function SetCommConfig(hCommDev: THandle; const lpCC: TCommConfig; dwSize: DWORD): BOOL; stdcall;
{$EXTERNALSYM SetCommConfig}
function SetCommMask(hFile: THandle; dwEvtMask: DWORD): BOOL; stdcall;
{$EXTERNALSYM SetCommMask}
function SetCommState(hFile: THandle; const lpDCB: TDCB): BOOL; stdcall;
{$EXTERNALSYM SetCommState}
function SetCommTimeouts(hFile: THandle; const lpCommTimeouts: TCommTimeouts): BOOL; stdcall;
{$EXTERNALSYM SetCommTimeouts}
function TransmitCommChar(hFile: THandle; cChar: CHAR): BOOL; stdcall;
{$EXTERNALSYM TransmitCommChar}
function WaitCommEvent(hFile: THandle; var lpEvtMask: DWORD; lpOverlapped: POverlapped): BOOL; stdcall;
{$EXTERNALSYM WaitCommEvent}
function SetTapePosition(hDevice: THandle; dwPositionMethod, dwPartition: DWORD;
  dwOffsetLow, dwOffsetHigh: DWORD; bImmediate: BOOL): DWORD; stdcall;
{$EXTERNALSYM SetTapePosition}
function GetTapePosition(hDevice: THandle; dwPositionType: DWORD;
  var lpdwPartition, lpdwOffsetLow: DWORD; lpdwOffsetHigh: Pointer): DWORD; stdcall;
{$EXTERNALSYM GetTapePosition}
function PrepareTape(hDevice: THandle; dwOperation: DWORD; bImmediate: BOOL): DWORD; stdcall;
{$EXTERNALSYM PrepareTape}
function EraseTape(hDevice: THandle; dwEraseType: DWORD; bImmediate: BOOL): DWORD; stdcall;
{$EXTERNALSYM EraseTape}
function CreateTapePartition(hDevice: THandle; dwPartitionMethod, dwCount, dwSize: DWORD): DWORD; stdcall;
{$EXTERNALSYM CreateTapePartition}
function WriteTapemark(hDevice: THandle;
  dwTapemarkType, dwTapemarkCount: DWORD; bImmediate: BOOL): DWORD; stdcall;
{$EXTERNALSYM WriteTapemark}
function GetTapeStatus(hDevice: THandle): DWORD; stdcall;
{$EXTERNALSYM GetTapeStatus}
function GetTapeParameters(hDevice: THandle; dwOperation: DWORD;
  var lpdwSize: DWORD; lpTapeInformation: Pointer): DWORD; stdcall;
{$EXTERNALSYM GetTapeParameters}

const
  GET_TAPE_MEDIA_INFORMATION = 0;
  {$EXTERNALSYM GET_TAPE_MEDIA_INFORMATION}
  GET_TAPE_DRIVE_INFORMATION = 1;
  {$EXTERNALSYM GET_TAPE_DRIVE_INFORMATION}

function SetTapeParameters(hDevice: THandle; dwOperation: DWORD; lpTapeInformation: Pointer): DWORD; stdcall;
{$EXTERNALSYM SetTapeParameters}

const
  SET_TAPE_MEDIA_INFORMATION = 0;
  {$EXTERNALSYM SET_TAPE_MEDIA_INFORMATION}
  SET_TAPE_DRIVE_INFORMATION = 1;
  {$EXTERNALSYM SET_TAPE_DRIVE_INFORMATION}

function Beep(dwFreq, dwDuration: DWORD): BOOL; stdcall;
{$EXTERNALSYM Beep}
function MulDiv(nNumber, nNumerator, nDenominator: Integer): Integer; stdcall;
{$EXTERNALSYM MulDiv}
procedure GetSystemTime(var lpSystemTime: TSystemTime); stdcall;
{$EXTERNALSYM GetSystemTime}
procedure GetSystemTimeAsFileTime(var lpSystemTimeAsFileTime: TFileTime); stdcall;
{$EXTERNALSYM GetSystemTimeAsFileTime}
function SetSystemTime(const lpSystemTime: TSystemTime): BOOL; stdcall;
{$EXTERNALSYM SetSystemTime}
procedure GetLocalTime(var lpSystemTime: TSystemTime); stdcall;
{$EXTERNALSYM GetLocalTime}
function SetLocalTime(const lpSystemTime: TSystemTime): BOOL; stdcall;
{$EXTERNALSYM SetLocalTime}
procedure GetSystemInfo(var lpSystemInfo: TSystemInfo); stdcall;
{$EXTERNALSYM GetSystemInfo}
function IsProcessorFeaturePresent(ProcessorFeature: DWORD): BOOL; stdcall;
{$EXTERNALSYM IsProcessorFeaturePresent}


type
  PTimeZoneInformation = ^TTimeZoneInformation;
  _TIME_ZONE_INFORMATION = record
    Bias: Longint;
    StandardName: array[0..31] of WCHAR;
    StandardDate: TSystemTime;
    StandardBias: Longint;
    DaylightName: array[0..31] of WCHAR;
    DaylightDate: TSystemTime;
    DaylightBias: Longint;
  end;
  {$EXTERNALSYM _TIME_ZONE_INFORMATION}
  TTimeZoneInformation = _TIME_ZONE_INFORMATION;
  TIME_ZONE_INFORMATION = _TIME_ZONE_INFORMATION;
  {$EXTERNALSYM TIME_ZONE_INFORMATION}

function SystemTimeToTzSpecificLocalTime(lpTimeZoneInformation: PTimeZoneInformation;
  var lpUniversalTime, lpLocalTime: TSystemTime): BOOL; stdcall;
{$EXTERNALSYM SystemTimeToTzSpecificLocalTime}
function GetTimeZoneInformation(var lpTimeZoneInformation: TTimeZoneInformation): DWORD; stdcall;
{$EXTERNALSYM GetTimeZoneInformation}
function SetTimeZoneInformation(const lpTimeZoneInformation: TTimeZoneInformation): BOOL; stdcall;
{$EXTERNALSYM SetTimeZoneInformation}

{ Routines to convert back and forth between system time and file time }

function SystemTimeToFileTime(const lpSystemTime: TSystemTime; var lpFileTime: TFileTime): BOOL; stdcall;
{$EXTERNALSYM SystemTimeToFileTime}
function FileTimeToLocalFileTime(const lpFileTime: TFileTime; var lpLocalFileTime: TFileTime): BOOL; stdcall;
{$EXTERNALSYM FileTimeToLocalFileTime}
function LocalFileTimeToFileTime(const lpLocalFileTime: TFileTime; var lpFileTime: TFileTime): BOOL; stdcall;
{$EXTERNALSYM LocalFileTimeToFileTime}
function FileTimeToSystemTime(const lpFileTime: TFileTime; var lpSystemTime: TSystemTime): BOOL; stdcall;
{$EXTERNALSYM FileTimeToSystemTime}
function CompareFileTime(const lpFileTime1, lpFileTime2: TFileTime): Longint; stdcall;
{$EXTERNALSYM CompareFileTime}
function FileTimeToDosDateTime(const lpFileTime: TFileTime;
  var lpFatDate, lpFatTime: Word): BOOL; stdcall;
{$EXTERNALSYM FileTimeToDosDateTime}
function DosDateTimeToFileTime(wFatDate, wFatTime: Word; var lpFileTime: TFileTime): BOOL; stdcall;
{$EXTERNALSYM DosDateTimeToFileTime}
function GetTickCount: DWORD; stdcall;
{$EXTERNALSYM GetTickCount}
function SetSystemTimeAdjustment(dwTimeAdjustment: DWORD; bTimeAdjustmentDisabled: BOOL): BOOL; stdcall;
{$EXTERNALSYM SetSystemTimeAdjustment}
function GetSystemTimeAdjustment(var lpTimeAdjustment, lpTimeIncrement: DWORD;
  var lpTimeAdjustmentDisabled: BOOL): BOOL; stdcall;
{$EXTERNALSYM GetSystemTimeAdjustment}
function FormatMessage(dwFlags: DWORD; lpSource: Pointer; dwMessageId: DWORD; dwLanguageId: DWORD;
  lpBuffer: PChar; nSize: DWORD; Arguments: Pointer): DWORD; stdcall;
{$EXTERNALSYM FormatMessage}
function FormatMessageA(dwFlags: DWORD; lpSource: Pointer; dwMessageId: DWORD; dwLanguageId: DWORD;
  lpBuffer: PAnsiChar; nSize: DWORD; Arguments: Pointer): DWORD; stdcall;
{$EXTERNALSYM FormatMessageA}
function FormatMessageW(dwFlags: DWORD; lpSource: Pointer; dwMessageId: DWORD; dwLanguageId: DWORD;
  lpBuffer: PWideChar; nSize: DWORD; Arguments: Pointer): DWORD; stdcall;
{$EXTERNALSYM FormatMessageW}

const
  FORMAT_MESSAGE_ALLOCATE_BUFFER = $100;
  {$EXTERNALSYM FORMAT_MESSAGE_ALLOCATE_BUFFER}
  FORMAT_MESSAGE_IGNORE_INSERTS = $200;
  {$EXTERNALSYM FORMAT_MESSAGE_IGNORE_INSERTS}
  FORMAT_MESSAGE_FROM_STRING = $400;
  {$EXTERNALSYM FORMAT_MESSAGE_FROM_STRING}
  FORMAT_MESSAGE_FROM_HMODULE = $800;
  {$EXTERNALSYM FORMAT_MESSAGE_FROM_HMODULE}
  FORMAT_MESSAGE_FROM_SYSTEM = $1000;
  {$EXTERNALSYM FORMAT_MESSAGE_FROM_SYSTEM}
  FORMAT_MESSAGE_ARGUMENT_ARRAY = $2000;
  {$EXTERNALSYM FORMAT_MESSAGE_ARGUMENT_ARRAY}
  FORMAT_MESSAGE_MAX_WIDTH_MASK = 255;
  {$EXTERNALSYM FORMAT_MESSAGE_MAX_WIDTH_MASK}

function CreatePipe(var hReadPipe, hWritePipe: THandle;
  lpPipeAttributes: PSecurityAttributes; nSize: DWORD): BOOL; stdcall;
{$EXTERNALSYM CreatePipe}
function ConnectNamedPipe(hNamedPipe: THandle; lpOverlapped: POverlapped): BOOL; stdcall;
{$EXTERNALSYM ConnectNamedPipe}
function DisconnectNamedPipe(hNamedPipe: THandle): BOOL; stdcall;
{$EXTERNALSYM DisconnectNamedPipe}
function SetNamedPipeHandleState(hNamedPipe: THandle; var lpMode: DWORD;
  lpMaxCollectionCount, lpCollectDataTimeout: Pointer): BOOL; stdcall;
{$EXTERNALSYM SetNamedPipeHandleState}
function GetNamedPipeInfo(hNamedPipe: THandle; var lpFlags: DWORD;
  lpOutBufferSize, lpInBufferSize, lpMaxInstances: Pointer): BOOL; stdcall;
{$EXTERNALSYM GetNamedPipeInfo}
function PeekNamedPipe(hNamedPipe: THandle; lpBuffer: Pointer; nBufferSize: DWORD;
  lpBytesRead, lpTotalBytesAvail, lpBytesLeftThisMessage: Pointer): BOOL; stdcall;
{$EXTERNALSYM PeekNamedPipe}
function TransactNamedPipe(hNamedPipe: THandle; lpInBuffer: Pointer; nInBufferSize: DWORD;
  lpOutBuffer: Pointer; nOutBufferSize: DWORD; var lpBytesRead: DWORD;
  lpOverlapped: POverlapped): BOOL; stdcall;
{$EXTERNALSYM TransactNamedPipe}

function CreateMailslot(lpName: PChar; nMaxMessageSize: DWORD;
  lReadTimeout: DWORD; lpSecurityAttributes: PSecurityAttributes): THandle; stdcall;
{$EXTERNALSYM CreateMailslot}
function CreateMailslotA(lpName: PAnsiChar; nMaxMessageSize: DWORD;
  lReadTimeout: DWORD; lpSecurityAttributes: PSecurityAttributes): THandle; stdcall;
{$EXTERNALSYM CreateMailslotA}
function CreateMailslotW(lpName: PWideChar; nMaxMessageSize: DWORD;
  lReadTimeout: DWORD; lpSecurityAttributes: PSecurityAttributes): THandle; stdcall;
{$EXTERNALSYM CreateMailslotW}
function GetMailslotInfo(hMailslot: THandle; lpMaxMessageSize: Pointer;
  var lpNextSize: DWORD; lpMessageCount, lpReadTimeout: Pointer): BOOL; stdcall;
{$EXTERNALSYM GetMailslotInfo}
function SetMailslotInfo(hMailslot: THandle; lReadTimeout: DWORD): BOOL; stdcall;
{$EXTERNALSYM SetMailslotInfo}
function MapViewOfFile(hFileMappingObject: THandle; dwDesiredAccess: DWORD;
  dwFileOffsetHigh, dwFileOffsetLow, dwNumberOfBytesToMap: DWORD): Pointer; stdcall;
{$EXTERNALSYM MapViewOfFile}
function FlushViewOfFile(const lpBaseAddress: Pointer; dwNumberOfBytesToFlush: DWORD): BOOL; stdcall;
{$EXTERNALSYM FlushViewOfFile}
function UnmapViewOfFile(lpBaseAddress: Pointer): BOOL; stdcall;
{$EXTERNALSYM UnmapViewOfFile}
function EncryptFile(lpFilename: PChar): BOOL; stdcall;
{$EXTERNALSYM EncryptFile}
function EncryptFileA(lpFilename: PAnsiChar): BOOL; stdcall;
{$EXTERNALSYM EncryptFileA}
function EncryptFileW(lpFilename: PWideChar): BOOL; stdcall;
{$EXTERNALSYM EncryptFileW}
function DecryptFile(lpFilename: PChar; dwReserved: DWORD): BOOL; stdcall;
{$EXTERNALSYM DecryptFile}
function DecryptFileA(lpFilename: PAnsiChar; dwReserved: DWORD): BOOL; stdcall;
{$EXTERNALSYM DecryptFileA}
function DecryptFileW(lpFilename: PWideChar; dwReserved: DWORD): BOOL; stdcall;
{$EXTERNALSYM DecryptFileW}

const
  { Currently defined recovery flags }
  EFS_USE_RECOVERY_KEYS = $1;
  {$EXTERNALSYM EFS_USE_RECOVERY_KEYS}

type
  TFNExportFunc = function (pbData, pvCallbackContext: Pointer; ulLength: ULONG): DWORD; stdcall;
  TFNImportFunc = function (pbData, pvCallbackContext: Pointer; ulLength: ULONG): DWORD; stdcall;

const
  { OpenRaw flag values }
  CREATE_FOR_IMPORT = 1;
  {$EXTERNALSYM CREATE_FOR_IMPORT}
  CREATE_FOR_DIR = 2;
  {$EXTERNALSYM CREATE_FOR_DIR}

function OpenRaw(lpFilename: PChar; ulFlags: ULONG; pvContext: Pointer): DWORD; stdcall;
{$EXTERNALSYM OpenRaw}
function OpenRawA(lpFilename: PAnsiChar; ulFlags: ULONG; pvContext: Pointer): DWORD; stdcall;
{$EXTERNALSYM OpenRawA}
function OpenRawW(lpFilename: PWideChar; ulFlags: ULONG; pvContext: Pointer): DWORD; stdcall;
{$EXTERNALSYM OpenRawW}
function ReadRaw(pfExportCallback: TFNExportFunc; pvCallbackContext, pvContext: Pointer): DWORD; stdcall;
{$EXTERNALSYM ReadRaw}
function WriteRaw(pfExportCallback: TFNImportFunc; pvCallbackContext, pvContext: Pointer): DWORD; stdcall;
{$EXTERNALSYM WriteRaw}
procedure CloseRaw(pvContext: Pointer); stdcall;
{$EXTERNALSYM CloseRaw}

type
  PRecoveryAgentInformationA = ^TRecoveryAgentInformationA;
  PRecoveryAgentInformationW = ^TRecoveryAgentInformationW;
  PRecoveryAgentInformation = PRecoveryAgentInformationA;
  _RECOVERY_AGENT_INFORMATIONA = record
    NextEntryOffset: DWORD;
    AgentNameLength: DWORD;
    AgentInformation: array[0..0] of AnsiChar;
  end;
  //{$EXTERNALSYM _RECOVERY_AGENT_INFORMATIONA}
  _RECOVERY_AGENT_INFORMATIONW = record
    NextEntryOffset: DWORD;
    AgentNameLength: DWORD;
    AgentInformation: array[0..0] of WideChar;
  end;
  //{$EXTERNALSYM _RECOVERY_AGENT_INFORMATIONW}
  _RECOVERY_AGENT_INFORMATION = _RECOVERY_AGENT_INFORMATIONA;
  TRecoveryAgentInformationA = _RECOVERY_AGENT_INFORMATIONA;
  TRecoveryAgentInformationW = _RECOVERY_AGENT_INFORMATIONW;
  TRecoveryAgentInformation = TRecoveryAgentInformationA;
  RECOVERY_AGENT_INFORMATIONA = _RECOVERY_AGENT_INFORMATIONA;
  //{$EXTERNALSYM RECOVERY_AGENT_INFORMATIONA}
  RECOVERY_AGENT_INFORMATIONW = _RECOVERY_AGENT_INFORMATIONW;
  //{$EXTERNALSYM RECOVERY_AGENT_INFORMATIONW}
  RECOVERY_AGENT_INFORMATION = RECOVERY_AGENT_INFORMATIONA;

function QueryRecoveryAgents(p1: PChar; var p2: Pointer; var p3: TRecoveryAgentInformation): DWORD; stdcall;
{$EXTERNALSYM QueryRecoveryAgents}
function QueryRecoveryAgentsA(p1: PAnsiChar; var p2: Pointer; var p3: TRecoveryAgentInformationA): DWORD; stdcall;
{$EXTERNALSYM QueryRecoveryAgentsA}
function QueryRecoveryAgentsW(p1: PWideChar; var p2: Pointer; var p3: TRecoveryAgentInformationW): DWORD; stdcall;
{$EXTERNALSYM QueryRecoveryAgentsW}

{ _l Compat Functions }

function lstrcmp(lpString1, lpString2: PChar): Integer; stdcall;
{$EXTERNALSYM lstrcmp}
function lstrcmpA(lpString1, lpString2: PAnsiChar): Integer; stdcall;
{$EXTERNALSYM lstrcmpA}
function lstrcmpW(lpString1, lpString2: PWideChar): Integer; stdcall;
{$EXTERNALSYM lstrcmpW}
function lstrcmpi(lpString1, lpString2: PChar): Integer; stdcall;
{$EXTERNALSYM lstrcmpi}
function lstrcmpiA(lpString1, lpString2: PAnsiChar): Integer; stdcall;
{$EXTERNALSYM lstrcmpiA}
function lstrcmpiW(lpString1, lpString2: PWideChar): Integer; stdcall;
{$EXTERNALSYM lstrcmpiW}
function lstrcpyn(lpString1, lpString2: PChar; iMaxLength: Integer): PChar; stdcall;
{$EXTERNALSYM lstrcpyn}
function lstrcpynA(lpString1, lpString2: PAnsiChar; iMaxLength: Integer): PAnsiChar; stdcall;
{$EXTERNALSYM lstrcpynA}
function lstrcpynW(lpString1, lpString2: PWideChar; iMaxLength: Integer): PWideChar; stdcall;
{$EXTERNALSYM lstrcpynW}
function lstrcpy(lpString1, lpString2: PChar): PChar; stdcall;
{$EXTERNALSYM lstrcpy}
function lstrcpyA(lpString1, lpString2: PAnsiChar): PAnsiChar; stdcall;
{$EXTERNALSYM lstrcpyA}
function lstrcpyW(lpString1, lpString2: PWideChar): PWideChar; stdcall;
{$EXTERNALSYM lstrcpyW}
function lstrcat(lpString1, lpString2: PChar): PChar; stdcall;
{$EXTERNALSYM lstrcat}
function lstrcatA(lpString1, lpString2: PAnsiChar): PAnsiChar; stdcall;
{$EXTERNALSYM lstrcatA}
function lstrcatW(lpString1, lpString2: PWideChar): PWideChar; stdcall;
{$EXTERNALSYM lstrcatW}
function lstrlen(lpString: PChar): Integer; stdcall;
{$EXTERNALSYM lstrlen}
function lstrlenA(lpString: PAnsiChar): Integer; stdcall;
{$EXTERNALSYM lstrlenA}
function lstrlenW(lpString: PWideChar): Integer; stdcall;
{$EXTERNALSYM lstrlenW}

function OpenFile(const lpFileName: LPCSTR; var lpReOpenBuff: TOFStruct; uStyle: UINT): HFILE; stdcall;
{$EXTERNALSYM OpenFile}
function _lopen(const lpPathName: LPCSTR; iReadWrite: Integer): HFILE; stdcall;
{$EXTERNALSYM _lopen}
function _lcreat(const lpPathName: LPCSTR; iAttribute: Integer): HFILE; stdcall;
{$EXTERNALSYM _lcreat}
function _lread(hFile: HFILE; lpBuffer: Pointer; uBytes: UINT): UINT; stdcall;
{$EXTERNALSYM _lread}
function _lwrite(hFile: HFILE; const lpBuffer: LPCSTR; uBytes: UINT): UINT; stdcall;
{$EXTERNALSYM _lwrite}
function _hread(hFile: HFILE; lpBuffer: Pointer; lBytes: Longint): Longint; stdcall;
{$EXTERNALSYM _hread}
function _hwrite(hFile: HFILE; lpBuffer: LPCSTR; lBytes: Longint): Longint; stdcall;
{$EXTERNALSYM _hwrite}
function _lclose(hFile: HFILE): HFILE; stdcall;
{$EXTERNALSYM _lclose}
function _llseek(hFile: HFILE; lOffset: Longint; iOrigin: Integer): Longint; stdcall;
{$EXTERNALSYM _llseek}
function IsTextUnicode(lpBuffer: Pointer; cb: Integer; lpi: PINT): BOOL; stdcall;
{$EXTERNALSYM IsTextUnicode}
function TlsAlloc: DWORD; stdcall;
{$EXTERNALSYM TlsAlloc}

const
  TLS_OUT_OF_INDEXES = DWORD($FFFFFFFF);
  {$EXTERNALSYM TLS_OUT_OF_INDEXES}

function TlsGetValue(dwTlsIndex: DWORD): Pointer; stdcall;
{$EXTERNALSYM TlsGetValue}
function TlsSetValue(dwTlsIndex: DWORD; lpTlsValue: Pointer): BOOL; stdcall;
{$EXTERNALSYM TlsSetValue}
function TlsFree(dwTlsIndex: DWORD): BOOL; stdcall;
{$EXTERNALSYM TlsFree}

type





  TPROverlappedCompletionRoutine = TFarProc;


function SleepEx(dwMilliseconds: DWORD; bAlertable: BOOL): DWORD; stdcall;
{$EXTERNALSYM SleepEx}
function WaitForSingleObjectEx(hHandle: THandle; dwMilliseconds: DWORD; bAlertable: BOOL): DWORD; stdcall;
{$EXTERNALSYM WaitForSingleObjectEx}
function WaitForMultipleObjectsEx(nCount: DWORD; lpHandles: PWOHandleArray;
  bWaitAll: BOOL; dwMilliseconds: DWORD; bAlertable: BOOL): DWORD; stdcall;
{$EXTERNALSYM WaitForMultipleObjectsEx}
function SignalObjectAndWait(hObjectToSignal: THandle; hObjectToWaitOn: THandle;
  dwMilliseconds: DWORD; bAlertable: BOOL): BOOL; stdcall;
{$EXTERNALSYM SignalObjectAndWait}
function ReadFileEx(hFile: THandle; lpBuffer: Pointer; nNumberOfBytesToRead: DWORD;
  lpOverlapped: POverlapped; lpCompletionRoutine: TPROverlappedCompletionRoutine): BOOL; stdcall;
{$EXTERNALSYM ReadFileEx}
function WriteFileEx(hFile: THandle; lpBuffer: Pointer; nNumberOfBytesToWrite: DWORD;
  const lpOverlapped: TOverlapped; lpCompletionRoutine: FARPROC): BOOL; stdcall;
{$EXTERNALSYM WriteFileEx}
function BackupRead(hFile: THandle; lpBuffer: PByte; nNumberOfBytesToRead: DWORD;
  var lpNumberOfBytesRead: DWORD; bAbort: BOOL;
  bProcessSecurity: BOOL; var lpContext: Pointer): BOOL; stdcall;
{$EXTERNALSYM BackupRead}
function BackupSeek(hFile: THandle; dwLowBytesToSeek, dwHighBytesToSeek: DWORD;
  var lpdwLowByteSeeked, lpdwHighByteSeeked: DWORD; lpContext: Pointer): BOOL; stdcall;
{$EXTERNALSYM BackupSeek}
function BackupWrite(hFile: THandle; lpBuffer: PByte; nNumberOfBytesToWrite: DWORD;
  var lpNumberOfBytesWritten: DWORD; bAbort, bProcessSecurity: BOOL; var lpContext: Pointer): BOOL; stdcall;
{$EXTERNALSYM BackupWrite}

type
  PWIN32StreamID = ^TWIN32StreamID;
  _WIN32_STREAM_ID = record
    dwStreamId: DWORD;
    dwStreamAttributes: DWORD;
    Size: TLargeInteger;
    dwStreamNameSize: DWORD;
    cStreamName: array[0..0] of WCHAR;
  end;
  {$EXTERNALSYM _WIN32_STREAM_ID}
  TWIN32StreamID = _WIN32_STREAM_ID;
  WIN32_STREAM_ID = _WIN32_STREAM_ID;
  {$EXTERNALSYM WIN32_STREAM_ID}

const
  { Stream IDs }
  BACKUP_INVALID = 0;
  {$EXTERNALSYM BACKUP_INVALID}
  BACKUP_DATA = 1;
  {$EXTERNALSYM BACKUP_DATA}
  BACKUP_EA_DATA = 2;
  {$EXTERNALSYM BACKUP_EA_DATA}
  BACKUP_SECURITY_DATA = 3;
  {$EXTERNALSYM BACKUP_SECURITY_DATA}
  BACKUP_ALTERNATE_DATA = 4;
  {$EXTERNALSYM BACKUP_ALTERNATE_DATA}
  BACKUP_LINK = 5;
  {$EXTERNALSYM BACKUP_LINK}
  BACKUP_PROPERTY_DATA = 6;
  {$EXTERNALSYM BACKUP_PROPERTY_DATA}

  { Stream Attributes}
  STREAM_NORMAL_ATTRIBUTE = 0;
  {$EXTERNALSYM STREAM_NORMAL_ATTRIBUTE}
  STREAM_MODIFIED_WHEN_READ = 1;
  {$EXTERNALSYM STREAM_MODIFIED_WHEN_READ}
  STREAM_CONTAINS_SECURITY = 2;
  {$EXTERNALSYM STREAM_CONTAINS_SECURITY}
  STREAM_CONTAINS_PROPERTIES = 4;
  {$EXTERNALSYM STREAM_CONTAINS_PROPERTIES}

  { Dual Mode API below this line. Dual Mode Structures also included. }
  STARTF_USESHOWWINDOW = 1;
  {$EXTERNALSYM STARTF_USESHOWWINDOW}
  STARTF_USESIZE = 2;
  {$EXTERNALSYM STARTF_USESIZE}
  STARTF_USEPOSITION = 4;
  {$EXTERNALSYM STARTF_USEPOSITION}
  STARTF_USECOUNTCHARS = 8;
  {$EXTERNALSYM STARTF_USECOUNTCHARS}
  STARTF_USEFILLATTRIBUTE = $10;
  {$EXTERNALSYM STARTF_USEFILLATTRIBUTE}
  STARTF_RUNFULLSCREEN = $20;  { ignored for non-x86 platforms }
  {$EXTERNALSYM STARTF_RUNFULLSCREEN}
  STARTF_FORCEONFEEDBACK = $40;
  {$EXTERNALSYM STARTF_FORCEONFEEDBACK}
  STARTF_FORCEOFFFEEDBACK = $80;
  {$EXTERNALSYM STARTF_FORCEOFFFEEDBACK}
  STARTF_USESTDHANDLES = $100;
  {$EXTERNALSYM STARTF_USESTDHANDLES}
  STARTF_USEHOTKEY = $200;
  {$EXTERNALSYM STARTF_USEHOTKEY}

type
  PStartupInfoA = ^TStartupInfoA;
  PStartupInfoW = ^TStartupInfoW;
  PStartupInfo = PStartupInfoA;
  _STARTUPINFOA = record
    cb: DWORD;
    lpReserved: PAnsiChar;
    lpDesktop: PAnsiChar;
    lpTitle: PAnsiChar;
    dwX: DWORD;
    dwY: DWORD;
    dwXSize: DWORD;
    dwYSize: DWORD;
    dwXCountChars: DWORD;
    dwYCountChars: DWORD;
    dwFillAttribute: DWORD;
    dwFlags: DWORD;
    wShowWindow: Word;
    cbReserved2: Word;
    lpReserved2: PByte;
    hStdInput: THandle;
    hStdOutput: THandle;
    hStdError: THandle;
  end;
  _STARTUPINFOW = record
    cb: DWORD;
    lpReserved: PWideChar;
    lpDesktop: PWideChar;
    lpTitle: PWideChar;
    dwX: DWORD;
    dwY: DWORD;
    dwXSize: DWORD;
    dwYSize: DWORD;
    dwXCountChars: DWORD;
    dwYCountChars: DWORD;
    dwFillAttribute: DWORD;
    dwFlags: DWORD;
    wShowWindow: Word;
    cbReserved2: Word;
    lpReserved2: PByte;
    hStdInput: THandle;
    hStdOutput: THandle;
    hStdError: THandle;
  end;
  _STARTUPINFO = _STARTUPINFOA;
  TStartupInfoA = _STARTUPINFOA;
  TStartupInfoW = _STARTUPINFOW;
  TStartupInfo = TStartupInfoA;
  {$EXTERNALSYM STARTUPINFOA}
  STARTUPINFOA = _STARTUPINFOA;
  {$EXTERNALSYM STARTUPINFOW}
  STARTUPINFOW = _STARTUPINFOW;
  {$EXTERNALSYM STARTUPINFO}
  STARTUPINFO = STARTUPINFOA;

const
  SHUTDOWN_NORETRY = 1;
  {$EXTERNALSYM SHUTDOWN_NORETRY}

type
  PWin32FindDataA = ^TWin32FindDataA;
  PWin32FindDataW = ^TWin32FindDataW;
  PWin32FindData = PWin32FindDataA;
  _WIN32_FIND_DATAA = record
    dwFileAttributes: DWORD;
    ftCreationTime: TFileTime;
    ftLastAccessTime: TFileTime;
    ftLastWriteTime: TFileTime;
    nFileSizeHigh: DWORD;
    nFileSizeLow: DWORD;
    dwReserved0: DWORD;
    dwReserved1: DWORD;
    cFileName: array[0..MAX_PATH - 1] of AnsiChar;
    cAlternateFileName: array[0..13] of AnsiChar;
  end;
  {$EXTERNALSYM _WIN32_FIND_DATAA}
  _WIN32_FIND_DATAW = record
    dwFileAttributes: DWORD;
    ftCreationTime: TFileTime;
    ftLastAccessTime: TFileTime;
    ftLastWriteTime: TFileTime;
    nFileSizeHigh: DWORD;
    nFileSizeLow: DWORD;
    dwReserved0: DWORD;
    dwReserved1: DWORD;
    cFileName: array[0..MAX_PATH - 1] of WideChar;
    cAlternateFileName: array[0..13] of WideChar;
  end;
  {$EXTERNALSYM _WIN32_FIND_DATAW}
  _WIN32_FIND_DATA = _WIN32_FIND_DATAA;
  TWin32FindDataA = _WIN32_FIND_DATAA;
  TWin32FindDataW = _WIN32_FIND_DATAW;
  TWin32FindData = TWin32FindDataA;
  {$EXTERNALSYM WIN32_FIND_DATAA}
  WIN32_FIND_DATAA = _WIN32_FIND_DATAA;
  {$EXTERNALSYM WIN32_FIND_DATAW}
  WIN32_FIND_DATAW = _WIN32_FIND_DATAW;
  {$EXTERNALSYM WIN32_FIND_DATA}
  WIN32_FIND_DATA = WIN32_FIND_DATAA;

  PWin32FileAttributeData = ^TWin32FileAttributeData;
  _WIN32_FILE_ATTRIBUTE_DATA = record
    dwFileAttributes: DWORD;
    ftCreationTime: TFileTime;
    ftLastAccessTime: TFileTime;
    ftLastWriteTime: TFileTime;
    nFileSizeHigh: DWORD;
    nFileSizeLow: DWORD;
  end;
  {$EXTERNALSYM _WIN32_FILE_ATTRIBUTE_DATA}
  TWin32FileAttributeData = _WIN32_FILE_ATTRIBUTE_DATA;
  WIN32_FILE_ATTRIBUTE_DATA = _WIN32_FILE_ATTRIBUTE_DATA;
  {$EXTERNALSYM WIN32_FILE_ATTRIBUTE_DATA}

function CreateMutex(lpMutexAttributes: PSecurityAttributes; bInitialOwner: BOOL; lpName: PChar): THandle; stdcall;
{$EXTERNALSYM CreateMutex}
function CreateMutexA(lpMutexAttributes: PSecurityAttributes; bInitialOwner: BOOL; lpName: PAnsiChar): THandle; stdcall;
{$EXTERNALSYM CreateMutexA}
function CreateMutexW(lpMutexAttributes: PSecurityAttributes; bInitialOwner: BOOL; lpName: PWideChar): THandle; stdcall;
{$EXTERNALSYM CreateMutexW}
function OpenMutex(dwDesiredAccess: DWORD; bInheritHandle: BOOL; lpName: PChar): THandle; stdcall;
{$EXTERNALSYM OpenMutex}
function OpenMutexA(dwDesiredAccess: DWORD; bInheritHandle: BOOL; lpName: PAnsiChar): THandle; stdcall;
{$EXTERNALSYM OpenMutexA}
function OpenMutexW(dwDesiredAccess: DWORD; bInheritHandle: BOOL; lpName: PWideChar): THandle; stdcall;
{$EXTERNALSYM OpenMutexW}
function CreateEvent(lpEventAttributes: PSecurityAttributes;
  bManualReset, bInitialState: BOOL; lpName: PChar): THandle; stdcall;
{$EXTERNALSYM CreateEvent}
function CreateEventA(lpEventAttributes: PSecurityAttributes;
  bManualReset, bInitialState: BOOL; lpName: PAnsiChar): THandle; stdcall;
{$EXTERNALSYM CreateEventA}
function CreateEventW(lpEventAttributes: PSecurityAttributes;
  bManualReset, bInitialState: BOOL; lpName: PWideChar): THandle; stdcall;
{$EXTERNALSYM CreateEventW}
{$EXTERNALSYM OpenEvent}
function OpenEvent(dwDesiredAccess: DWORD; bInheritHandle: BOOL; lpName: PChar): THandle; stdcall;
{$EXTERNALSYM OpenEventA}
function OpenEventA(dwDesiredAccess: DWORD; bInheritHandle: BOOL; lpName: PAnsiChar): THandle; stdcall;
{$EXTERNALSYM OpenEventW}
function OpenEventW(dwDesiredAccess: DWORD; bInheritHandle: BOOL; lpName: PWideChar): THandle; stdcall;
function CreateSemaphore(lpSemaphoreAttributes: PSecurityAttributes;
  lInitialCount, lMaximumCount: Longint; lpName: PChar): THandle; stdcall;
{$EXTERNALSYM CreateSemaphore}
function CreateSemaphoreA(lpSemaphoreAttributes: PSecurityAttributes;
  lInitialCount, lMaximumCount: Longint; lpName: PAnsiChar): THandle; stdcall;
{$EXTERNALSYM CreateSemaphoreA}
function CreateSemaphoreW(lpSemaphoreAttributes: PSecurityAttributes;
  lInitialCount, lMaximumCount: Longint; lpName: PWideChar): THandle; stdcall;
{$EXTERNALSYM CreateSemaphoreW}
function OpenSemaphore(dwDesiredAccess: DWORD; bInheritHandle: BOOL; lpName: PChar): THandle; stdcall;
{$EXTERNALSYM OpenSemaphore}
function OpenSemaphoreA(dwDesiredAccess: DWORD; bInheritHandle: BOOL; lpName: PAnsiChar): THandle; stdcall;
{$EXTERNALSYM OpenSemaphoreA}
function OpenSemaphoreW(dwDesiredAccess: DWORD; bInheritHandle: BOOL; lpName: PWideChar): THandle; stdcall;
{$EXTERNALSYM OpenSemaphoreW}

type




  TFNTimerAPCRoutine = TFarProc;


function CreateWaitableTimer(lpTimerAttributes: PSecurityAttributes; bManualReset: BOOL; lpTimerName: PChar): THandle; stdcall;
{$EXTERNALSYM CreateWaitableTimer}
function CreateWaitableTimerA(lpTimerAttributes: PSecurityAttributes; bManualReset: BOOL; lpTimerName: PAnsiChar): THandle; stdcall;
{$EXTERNALSYM CreateWaitableTimerA}
function CreateWaitableTimerW(lpTimerAttributes: PSecurityAttributes; bManualReset: BOOL; lpTimerName: PWideChar): THandle; stdcall;
{$EXTERNALSYM CreateWaitableTimerW}
function OpenWaitableTimer(dwDesiredAccess: DWORD; bInheritHandle: BOOL;
  lpTimerName: PChar): THandle; stdcall;
{$EXTERNALSYM OpenWaitableTimer}
function OpenWaitableTimerA(dwDesiredAccess: DWORD; bInheritHandle: BOOL;
  lpTimerName: PAnsiChar): THandle; stdcall;
{$EXTERNALSYM OpenWaitableTimerA}
function OpenWaitableTimerW(dwDesiredAccess: DWORD; bInheritHandle: BOOL;
  lpTimerName: PWideChar): THandle; stdcall;
{$EXTERNALSYM OpenWaitableTimerW}
function SetWaitableTimer(hTimer: THandle; var lpDueTime: TLargeInteger;
  lPeriod: Longint; pfnCompletionRoutine: TFNTimerAPCRoutine;
  lpArgToCompletionRoutine: Pointer; fResume: BOOL): BOOL; stdcall;
{$EXTERNALSYM SetWaitableTimer}
function CancelWaitableTimer(hTimer: THandle): BOOL; stdcall;
{$EXTERNALSYM CancelWaitableTimer}
function CreateFileMapping(hFile: THandle; lpFileMappingAttributes: PSecurityAttributes;
  flProtect, dwMaximumSizeHigh, dwMaximumSizeLow: DWORD; lpName: PChar): THandle; stdcall;
{$EXTERNALSYM CreateFileMapping}
function CreateFileMappingA(hFile: THandle; lpFileMappingAttributes: PSecurityAttributes;
  flProtect, dwMaximumSizeHigh, dwMaximumSizeLow: DWORD; lpName: PAnsiChar): THandle; stdcall;
{$EXTERNALSYM CreateFileMappingA}
function CreateFileMappingW(hFile: THandle; lpFileMappingAttributes: PSecurityAttributes;
  flProtect, dwMaximumSizeHigh, dwMaximumSizeLow: DWORD; lpName: PWideChar): THandle; stdcall;
{$EXTERNALSYM CreateFileMappingW}
function OpenFileMapping(dwDesiredAccess: DWORD; bInheritHandle: BOOL; lpName: PChar): THandle; stdcall;
{$EXTERNALSYM OpenFileMapping}
function OpenFileMappingA(dwDesiredAccess: DWORD; bInheritHandle: BOOL; lpName: PAnsiChar): THandle; stdcall;
{$EXTERNALSYM OpenFileMappingA}
function OpenFileMappingW(dwDesiredAccess: DWORD; bInheritHandle: BOOL; lpName: PWideChar): THandle; stdcall;
{$EXTERNALSYM OpenFileMappingW}
function GetLogicalDriveStrings(nBufferLength: DWORD; lpBuffer: PAnsiChar): DWORD; stdcall;
{$EXTERNALSYM GetLogicalDriveStrings}
function GetLogicalDriveStringsA(nBufferLength: DWORD; lpBuffer: PAnsiChar): DWORD; stdcall;
{$EXTERNALSYM GetLogicalDriveStringsA}
function GetLogicalDriveStringsW(nBufferLength: DWORD; lpBuffer: PAnsiChar): DWORD; stdcall;
{$EXTERNALSYM GetLogicalDriveStringsW}
{$IFDEF MSWINDOWS}
function LoadLibrary(lpLibFileName: PChar): HMODULE; stdcall;
{$EXTERNALSYM LoadLibrary}
function LoadLibraryA(lpLibFileName: PAnsiChar): HMODULE; stdcall;
{$EXTERNALSYM LoadLibraryA}
function LoadLibraryW(lpLibFileName: PWideChar): HMODULE; stdcall;
{$EXTERNALSYM LoadLibraryW}
function LoadLibraryEx(lpLibFileName: PChar; hFile: THandle; dwFlags: DWORD): HMODULE; stdcall;
{$EXTERNALSYM LoadLibraryEx}
function LoadLibraryExA(lpLibFileName: PAnsiChar; hFile: THandle; dwFlags: DWORD): HMODULE; stdcall;
{$EXTERNALSYM LoadLibraryExA}
function LoadLibraryExW(lpLibFileName: PWideChar; hFile: THandle; dwFlags: DWORD): HMODULE; stdcall;
{$EXTERNALSYM LoadLibraryExW}

const
  DONT_RESOLVE_DLL_REFERENCES = 1;
  {$EXTERNALSYM DONT_RESOLVE_DLL_REFERENCES}
  LOAD_LIBRARY_AS_DATAFILE = 2;
  {$EXTERNALSYM LOAD_LIBRARY_AS_DATAFILE}
  LOAD_WITH_ALTERED_SEARCH_PATH = 8;
  {$EXTERNALSYM LOAD_WITH_ALTERED_SEARCH_PATH}
{$ENDIF}

function GetModuleFileName(hModule: HINST; lpFilename: PChar; nSize: DWORD): DWORD; stdcall;
{$EXTERNALSYM GetModuleFileName}
function GetModuleFileNameA(hModule: HINST; lpFilename: PAnsiChar; nSize: DWORD): DWORD; stdcall;
{$EXTERNALSYM GetModuleFileNameA}
function GetModuleFileNameW(hModule: HINST; lpFilename: PWideChar; nSize: DWORD): DWORD; stdcall;
{$EXTERNALSYM GetModuleFileNameW}
function GetModuleHandle(lpModuleName: PChar): HMODULE; stdcall;
{$EXTERNALSYM GetModuleHandle}
function GetModuleHandleA(lpModuleName: PAnsiChar): HMODULE; stdcall;
{$EXTERNALSYM GetModuleHandleA}
function GetModuleHandleW(lpModuleName: PWideChar): HMODULE; stdcall;
{$EXTERNALSYM GetModuleHandleW}
function CreateProcess(lpApplicationName: PChar; lpCommandLine: PChar;
  lpProcessAttributes, lpThreadAttributes: PSecurityAttributes;
  bInheritHandles: BOOL; dwCreationFlags: DWORD; lpEnvironment: Pointer;
  lpCurrentDirectory: PChar; const lpStartupInfo: TStartupInfo;
  var lpProcessInformation: TProcessInformation): BOOL; stdcall;
{$EXTERNALSYM CreateProcess}
function CreateProcessA(lpApplicationName: PAnsiChar; lpCommandLine: PAnsiChar;
  lpProcessAttributes, lpThreadAttributes: PSecurityAttributes;
  bInheritHandles: BOOL; dwCreationFlags: DWORD; lpEnvironment: Pointer;
  lpCurrentDirectory: PAnsiChar; const lpStartupInfo: TStartupInfoA;
  var lpProcessInformation: TProcessInformation): BOOL; stdcall;
{$EXTERNALSYM CreateProcessA}
function CreateProcessW(lpApplicationName: PWideChar; lpCommandLine: PWideChar;
  lpProcessAttributes, lpThreadAttributes: PSecurityAttributes;
  bInheritHandles: BOOL; dwCreationFlags: DWORD; lpEnvironment: Pointer;
  lpCurrentDirectory: PWideChar; const lpStartupInfo: TStartupInfoW;
  var lpProcessInformation: TProcessInformation): BOOL; stdcall;
{$EXTERNALSYM CreateProcessW}
function SetProcessShutdownParameters(dwLevel, dwFlags: DWORD): BOOL; stdcall;
{$EXTERNALSYM SetProcessShutdownParameters}
function GetProcessShutdownParameters(var lpdwLevel, lpdwFlags: DWORD): BOOL; stdcall;
{$EXTERNALSYM GetProcessShutdownParameters}
function GetProcessVersion(ProcessId: DWORD): DWORD; stdcall;
{$EXTERNALSYM GetProcessVersion}
procedure FatalAppExit(uAction: UINT; lpMessageText: PChar); stdcall;
{$EXTERNALSYM FatalAppExit}
procedure FatalAppExitA(uAction: UINT; lpMessageText: PAnsiChar); stdcall;
{$EXTERNALSYM FatalAppExitA}
procedure FatalAppExitW(uAction: UINT; lpMessageText: PWideChar); stdcall;
{$EXTERNALSYM FatalAppExitW}
procedure GetStartupInfo(var lpStartupInfo: TStartupInfo); stdcall;
{$EXTERNALSYM GetStartupInfo}
procedure GetStartupInfoA(var lpStartupInfo: TStartupInfo); stdcall;
{$EXTERNALSYM GetStartupInfoA}
procedure GetStartupInfoW(var lpStartupInfo: TStartupInfo); stdcall;
{$EXTERNALSYM GetStartupInfoW}
function GetCommandLine: PChar; stdcall;
{$EXTERNALSYM GetCommandLine}
function GetCommandLineA: PAnsiChar; stdcall;
{$EXTERNALSYM GetCommandLineA}
function GetCommandLineW: PWideChar; stdcall;
{$EXTERNALSYM GetCommandLineW}
function GetEnvironmentVariable(lpName: PChar; lpBuffer: PChar; nSize: DWORD): DWORD; stdcall; overload;
{$EXTERNALSYM GetEnvironmentVariable}
function GetEnvironmentVariableA(lpName: PAnsiChar; lpBuffer: PAnsiChar; nSize: DWORD): DWORD; stdcall; overload;
{$EXTERNALSYM GetEnvironmentVariableA}
function GetEnvironmentVariableW(lpName: PWideChar; lpBuffer: PWideChar; nSize: DWORD): DWORD; stdcall; overload;
{$EXTERNALSYM GetEnvironmentVariableW}
function SetEnvironmentVariable(lpName, lpValue: PChar): BOOL; stdcall;
{$EXTERNALSYM SetEnvironmentVariable}
function SetEnvironmentVariableA(lpName, lpValue: PAnsiChar): BOOL; stdcall;
{$EXTERNALSYM SetEnvironmentVariableA}
function SetEnvironmentVariableW(lpName, lpValue: PWideChar): BOOL; stdcall;
{$EXTERNALSYM SetEnvironmentVariableW}
function ExpandEnvironmentStrings(lpSrc: PChar; lpDst: PChar; nSize: DWORD): DWORD; stdcall;
{$EXTERNALSYM ExpandEnvironmentStrings}
function ExpandEnvironmentStringsA(lpSrc: PAnsiChar; lpDst: PAnsiChar; nSize: DWORD): DWORD; stdcall;
{$EXTERNALSYM ExpandEnvironmentStringsA}
function ExpandEnvironmentStringsW(lpSrc: PWideChar; lpDst: PWideChar; nSize: DWORD): DWORD; stdcall;
{$EXTERNALSYM ExpandEnvironmentStringsW}
procedure OutputDebugString(lpOutputString: PChar); stdcall;
{$EXTERNALSYM OutputDebugString}
procedure OutputDebugStringA(lpOutputString: PAnsiChar); stdcall;
{$EXTERNALSYM OutputDebugStringA}
procedure OutputDebugStringW(lpOutputString: PWideChar); stdcall;
{$EXTERNALSYM OutputDebugStringW}
{$IFDEF MSWINDOWS}
function FindResource(hModule: HMODULE; lpName, lpType: PChar): HRSRC; stdcall;
{$EXTERNALSYM FindResource}
function FindResourceA(hModule: HMODULE; lpName, lpType: PAnsiChar): HRSRC; stdcall;
{$EXTERNALSYM FindResourceA}
function FindResourceW(hModule: HMODULE; lpName, lpType: PWideChar): HRSRC; stdcall;
{$EXTERNALSYM FindResourceW}
{$ENDIF}
function FindResourceEx(hModule: HMODULE; lpType, lpName: PChar; wLanguage: Word): HRSRC; stdcall;
{$EXTERNALSYM FindResourceEx}
function FindResourceExA(hModule: HMODULE; lpType, lpName: PAnsiChar; wLanguage: Word): HRSRC; stdcall;
{$EXTERNALSYM FindResourceExA}
function FindResourceExW(hModule: HMODULE; lpType, lpName: PWideChar; wLanguage: Word): HRSRC; stdcall;
{$EXTERNALSYM FindResourceExW}

type
  ENUMRESTYPEPROC = FARPROC;
  {$EXTERNALSYM ENUMRESTYPEPROC}
  ENUMRESNAMEPROC = FARPROC;
  {$EXTERNALSYM ENUMRESNAMEPROC}
  ENUMRESLANGPROC = FARPROC;
  {$EXTERNALSYM ENUMRESLANGPROC}

function EnumResourceTypes(hModule: HMODULE; lpEnumFunc: ENUMRESTYPEPROC;
  lParam: Longint): BOOL; stdcall;
{$EXTERNALSYM EnumResourceTypes}
function EnumResourceTypesA(hModule: HMODULE; lpEnumFunc: ENUMRESTYPEPROC;
  lParam: Longint): BOOL; stdcall;
{$EXTERNALSYM EnumResourceTypesA}
function EnumResourceTypesW(hModule: HMODULE; lpEnumFunc: ENUMRESTYPEPROC;
  lParam: Longint): BOOL; stdcall;
{$EXTERNALSYM EnumResourceTypesW}
function EnumResourceNames(hModule: HMODULE; lpType: PChar;
  lpEnumFunc: ENUMRESNAMEPROC; lParam: Longint): BOOL; stdcall;
{$EXTERNALSYM EnumResourceNames}
function EnumResourceNamesA(hModule: HMODULE; lpType: PAnsiChar;
  lpEnumFunc: ENUMRESNAMEPROC; lParam: Longint): BOOL; stdcall;
{$EXTERNALSYM EnumResourceNamesA}
function EnumResourceNamesW(hModule: HMODULE; lpType: PWideChar;
  lpEnumFunc: ENUMRESNAMEPROC; lParam: Longint): BOOL; stdcall;
{$EXTERNALSYM EnumResourceNamesW}
function EnumResourceLanguages(hModule: HMODULE; lpType, lpName: PChar;
  lpEnumFunc: ENUMRESLANGPROC; lParam: Longint): BOOL; stdcall;
{$EXTERNALSYM EnumResourceLanguages}
function EnumResourceLanguagesA(hModule: HMODULE; lpType, lpName: PAnsiChar;
  lpEnumFunc: ENUMRESLANGPROC; lParam: Longint): BOOL; stdcall;
{$EXTERNALSYM EnumResourceLanguagesA}
function EnumResourceLanguagesW(hModule: HMODULE; lpType, lpName: PWideChar;
  lpEnumFunc: ENUMRESLANGPROC; lParam: Longint): BOOL; stdcall;
{$EXTERNALSYM EnumResourceLanguagesW}
function BeginUpdateResource(pFileName: PChar; bDeleteExistingResources: BOOL): THandle; stdcall;
{$EXTERNALSYM BeginUpdateResource}
function BeginUpdateResourceA(pFileName: PAnsiChar; bDeleteExistingResources: BOOL): THandle; stdcall;
{$EXTERNALSYM BeginUpdateResourceA}
function BeginUpdateResourceW(pFileName: PWideChar; bDeleteExistingResources: BOOL): THandle; stdcall;
{$EXTERNALSYM BeginUpdateResourceW}
function UpdateResource(hUpdate: THandle; lpType, lpName: PChar;
  wLanguage: Word; lpData: Pointer; cbData: DWORD): BOOL; stdcall;
{$EXTERNALSYM UpdateResource}
function UpdateResourceA(hUpdate: THandle; lpType, lpName: PAnsiChar;
  wLanguage: Word; lpData: Pointer; cbData: DWORD): BOOL; stdcall;
{$EXTERNALSYM UpdateResourceA}
function UpdateResourceW(hUpdate: THandle; lpType, lpName: PWideChar;
  wLanguage: Word; lpData: Pointer; cbData: DWORD): BOOL; stdcall;
{$EXTERNALSYM UpdateResourceW}
function EndUpdateResource(hUpdate: THandle; fDiscard: BOOL): BOOL; stdcall;
{$EXTERNALSYM EndUpdateResource}
function EndUpdateResourceA(hUpdate: THandle; fDiscard: BOOL): BOOL; stdcall;
{$EXTERNALSYM EndUpdateResourceA}
function EndUpdateResourceW(hUpdate: THandle; fDiscard: BOOL): BOOL; stdcall;
{$EXTERNALSYM EndUpdateResourceW}
function GlobalAddAtom(lpString: PChar): ATOM; stdcall;
{$EXTERNALSYM GlobalAddAtom}
function GlobalAddAtomA(lpString: PAnsiChar): ATOM; stdcall;
{$EXTERNALSYM GlobalAddAtomA}
function GlobalAddAtomW(lpString: PWideChar): ATOM; stdcall;
{$EXTERNALSYM GlobalAddAtomW}
function GlobalFindAtom(lpString: PChar): ATOM; stdcall;
{$EXTERNALSYM GlobalFindAtom}
function GlobalFindAtomA(lpString: PAnsiChar): ATOM; stdcall;
{$EXTERNALSYM GlobalFindAtomA}
function GlobalFindAtomW(lpString: PWideChar): ATOM; stdcall;
{$EXTERNALSYM GlobalFindAtomW}
function GlobalGetAtomName(nAtom: ATOM; lpBuffer: PChar; nSize: Integer): UINT; stdcall;
{$EXTERNALSYM GlobalGetAtomName}
function GlobalGetAtomNameA(nAtom: ATOM; lpBuffer: PAnsiChar; nSize: Integer): UINT; stdcall;
{$EXTERNALSYM GlobalGetAtomNameA}
function GlobalGetAtomNameW(nAtom: ATOM; lpBuffer: PWideChar; nSize: Integer): UINT; stdcall;
{$EXTERNALSYM GlobalGetAtomNameW}
function AddAtom(lpString: PChar): ATOM; stdcall;
{$EXTERNALSYM AddAtom}
function AddAtomA(lpString: PAnsiChar): ATOM; stdcall;
{$EXTERNALSYM AddAtomA}
function AddAtomW(lpString: PWideChar): ATOM; stdcall;
{$EXTERNALSYM AddAtomW}
function FindAtom(lpString: PChar): ATOM; stdcall;
{$EXTERNALSYM FindAtom}
function FindAtomA(lpString: PAnsiChar): ATOM; stdcall;
{$EXTERNALSYM FindAtomA}
function FindAtomW(lpString: PWideChar): ATOM; stdcall;
{$EXTERNALSYM FindAtomW}
function GetAtomName(nAtom: ATOM; lpBuffer: PChar; nSize: Integer): UINT; stdcall;
{$EXTERNALSYM GetAtomName}
function GetAtomNameA(nAtom: ATOM; lpBuffer: PAnsiChar; nSize: Integer): UINT; stdcall;
{$EXTERNALSYM GetAtomNameA}
function GetAtomNameW(nAtom: ATOM; lpBuffer: PWideChar; nSize: Integer): UINT; stdcall;
{$EXTERNALSYM GetAtomNameW}
function GetProfileInt(lpAppName, lpKeyName: PChar; nDefault: Integer): UINT; stdcall;
{$EXTERNALSYM GetProfileInt}
function GetProfileIntA(lpAppName, lpKeyName: PAnsiChar; nDefault: Integer): UINT; stdcall;
{$EXTERNALSYM GetProfileIntA}
function GetProfileIntW(lpAppName, lpKeyName: PWideChar; nDefault: Integer): UINT; stdcall;
{$EXTERNALSYM GetProfileIntW}
function GetProfileString(lpAppName, lpKeyName, lpDefault: PChar;
  lpReturnedString: PChar; nSize: DWORD): DWORD; stdcall;
{$EXTERNALSYM GetProfileString}
function GetProfileStringA(lpAppName, lpKeyName, lpDefault: PAnsiChar;
  lpReturnedString: PAnsiChar; nSize: DWORD): DWORD; stdcall;
{$EXTERNALSYM GetProfileStringA}
function GetProfileStringW(lpAppName, lpKeyName, lpDefault: PWideChar;
  lpReturnedString: PWideChar; nSize: DWORD): DWORD; stdcall;
{$EXTERNALSYM GetProfileStringW}
function WriteProfileString(lpAppName, lpKeyName, lpString: PChar): BOOL; stdcall;
{$EXTERNALSYM WriteProfileString}
function WriteProfileStringA(lpAppName, lpKeyName, lpString: PAnsiChar): BOOL; stdcall;
{$EXTERNALSYM WriteProfileStringA}
function WriteProfileStringW(lpAppName, lpKeyName, lpString: PWideChar): BOOL; stdcall;
{$EXTERNALSYM WriteProfileStringW}
function GetProfileSection(lpAppName: PChar; lpReturnedString: PChar; nSize: DWORD): DWORD; stdcall;
{$EXTERNALSYM GetProfileSection}
function GetProfileSectionA(lpAppName: PAnsiChar; lpReturnedString: PAnsiChar; nSize: DWORD): DWORD; stdcall;
{$EXTERNALSYM GetProfileSectionA}
function GetProfileSectionW(lpAppName: PWideChar; lpReturnedString: PWideChar; nSize: DWORD): DWORD; stdcall;
{$EXTERNALSYM GetProfileSectionW}
function WriteProfileSection(lpAppName, lpString: PChar): BOOL; stdcall;
{$EXTERNALSYM WriteProfileSection}
function WriteProfileSectionA(lpAppName, lpString: PAnsiChar): BOOL; stdcall;
{$EXTERNALSYM WriteProfileSectionA}
function WriteProfileSectionW(lpAppName, lpString: PWideChar): BOOL; stdcall;
{$EXTERNALSYM WriteProfileSectionW}
function GetPrivateProfileInt(lpAppName, lpKeyName: PChar; nDefault: Integer; lpFileName: PChar): UINT; stdcall;
{$EXTERNALSYM GetPrivateProfileInt}
function GetPrivateProfileIntA(lpAppName, lpKeyName: PAnsiChar; nDefault: Integer; lpFileName: PAnsiChar): UINT; stdcall;
{$EXTERNALSYM GetPrivateProfileIntA}
function GetPrivateProfileIntW(lpAppName, lpKeyName: PWideChar; nDefault: Integer; lpFileName: PWideChar): UINT; stdcall;
{$EXTERNALSYM GetPrivateProfileIntW}
function GetPrivateProfileString(lpAppName, lpKeyName, lpDefault: PChar;
  lpReturnedString: PChar; nSize: DWORD; lpFileName: PChar): DWORD; stdcall;
{$EXTERNALSYM GetPrivateProfileString}
function GetPrivateProfileStringA(lpAppName, lpKeyName, lpDefault: PAnsiChar;
  lpReturnedString: PAnsiChar; nSize: DWORD; lpFileName: PAnsiChar): DWORD; stdcall;
{$EXTERNALSYM GetPrivateProfileStringA}
function GetPrivateProfileStringW(lpAppName, lpKeyName, lpDefault: PWideChar;
  lpReturnedString: PWideChar; nSize: DWORD; lpFileName: PWideChar): DWORD; stdcall;
{$EXTERNALSYM GetPrivateProfileStringW}
function WritePrivateProfileString(lpAppName, lpKeyName, lpString, lpFileName: PChar): BOOL; stdcall;
{$EXTERNALSYM WritePrivateProfileString}
function WritePrivateProfileStringA(lpAppName, lpKeyName, lpString, lpFileName: PAnsiChar): BOOL; stdcall;
{$EXTERNALSYM WritePrivateProfileStringA}
function WritePrivateProfileStringW(lpAppName, lpKeyName, lpString, lpFileName: PWideChar): BOOL; stdcall;
{$EXTERNALSYM WritePrivateProfileStringW}
function GetPrivateProfileSection(lpAppName: PChar; lpReturnedString: PChar; nSize: DWORD; lpFileName: PChar): DWORD; stdcall;
{$EXTERNALSYM GetPrivateProfileSection}
function GetPrivateProfileSectionA(lpAppName: PAnsiChar; lpReturnedString: PAnsiChar; nSize: DWORD; lpFileName: PAnsiChar): DWORD; stdcall;
{$EXTERNALSYM GetPrivateProfileSectionA}
function GetPrivateProfileSectionW(lpAppName: PWideChar; lpReturnedString: PWideChar; nSize: DWORD; lpFileName: PWideChar): DWORD; stdcall;
{$EXTERNALSYM GetPrivateProfileSectionW}
function WritePrivateProfileSection(lpAppName, lpString, lpFileName: PChar): BOOL; stdcall;
{$EXTERNALSYM WritePrivateProfileSection}
function WritePrivateProfileSectionA(lpAppName, lpString, lpFileName: PAnsiChar): BOOL; stdcall;
{$EXTERNALSYM WritePrivateProfileSectionA}
function WritePrivateProfileSectionW(lpAppName, lpString, lpFileName: PWideChar): BOOL; stdcall;
{$EXTERNALSYM WritePrivateProfileSectionW}
function GetPrivateProfileSectionNames(lpszReturnBuffer: PChar; nSize: DWORD; lpFileName: PChar): DWORD; stdcall;
{$EXTERNALSYM GetPrivateProfileSectionNames}
function GetPrivateProfileSectionNamesA(lpszReturnBuffer: PAnsiChar; nSize: DWORD; lpFileName: PAnsiChar): DWORD; stdcall;
{$EXTERNALSYM GetPrivateProfileSectionNamesA}
function GetPrivateProfileSectionNamesW(lpszReturnBuffer: PWideChar; nSize: DWORD; lpFileName: PWideChar): DWORD; stdcall;
{$EXTERNALSYM GetPrivateProfileSectionNamesW}
function GetPrivateProfileStruct(lpszSection, lpszKey: PChar;
  lpStruct: Pointer; uSizeStruct: UINT; szFile: PChar): BOOL; stdcall;
{$EXTERNALSYM GetPrivateProfileStruct}
function GetPrivateProfileStructA(lpszSection, lpszKey: PAnsiChar;
  lpStruct: Pointer; uSizeStruct: UINT; szFile: PAnsiChar): BOOL; stdcall;
{$EXTERNALSYM GetPrivateProfileStructA}
function GetPrivateProfileStructW(lpszSection, lpszKey: PWideChar;
  lpStruct: Pointer; uSizeStruct: UINT; szFile: PWideChar): BOOL; stdcall;
{$EXTERNALSYM GetPrivateProfileStructW}
function WritePrivateProfileStruct(lpszSection, lpszKey: PChar;
  lpStruct: Pointer; uSizeStruct: UINT; szFile: PChar): BOOL; stdcall;
{$EXTERNALSYM WritePrivateProfileStruct}
function WritePrivateProfileStructA(lpszSection, lpszKey: PAnsiChar;
  lpStruct: Pointer; uSizeStruct: UINT; szFile: PAnsiChar): BOOL; stdcall;
{$EXTERNALSYM WritePrivateProfileStructA}
function WritePrivateProfileStructW(lpszSection, lpszKey: PWideChar;
  lpStruct: Pointer; uSizeStruct: UINT; szFile: PWideChar): BOOL; stdcall;
{$EXTERNALSYM WritePrivateProfileStructW}
function GetDriveType(lpRootPathName: PChar): UINT; stdcall;
{$EXTERNALSYM GetDriveType}
function GetDriveTypeA(lpRootPathName: PAnsiChar): UINT; stdcall;
{$EXTERNALSYM GetDriveTypeA}
function GetDriveTypeW(lpRootPathName: PWideChar): UINT; stdcall;
{$EXTERNALSYM GetDriveTypeW}
function GetSystemDirectory(lpBuffer: PChar; uSize: UINT): UINT; stdcall;
{$EXTERNALSYM GetSystemDirectory}
function GetSystemDirectoryA(lpBuffer: PAnsiChar; uSize: UINT): UINT; stdcall;
{$EXTERNALSYM GetSystemDirectoryA}
function GetSystemDirectoryW(lpBuffer: PWideChar; uSize: UINT): UINT; stdcall;
{$EXTERNALSYM GetSystemDirectoryW}
function GetTempPath(nBufferLength: DWORD; lpBuffer: PChar): DWORD; stdcall;
{$EXTERNALSYM GetTempPath}
function GetTempPathA(nBufferLength: DWORD; lpBuffer: PAnsiChar): DWORD; stdcall;
{$EXTERNALSYM GetTempPathA}
function GetTempPathW(nBufferLength: DWORD; lpBuffer: PWideChar): DWORD; stdcall;
{$EXTERNALSYM GetTempPathW}
function GetTempFileName(lpPathName, lpPrefixString: PChar;
  uUnique: UINT; lpTempFileName: PChar): UINT; stdcall;
{$EXTERNALSYM GetTempFileName}
function GetTempFileNameA(lpPathName, lpPrefixString: PAnsiChar;
  uUnique: UINT; lpTempFileName: PAnsiChar): UINT; stdcall;
{$EXTERNALSYM GetTempFileNameA}
function GetTempFileNameW(lpPathName, lpPrefixString: PWideChar;
  uUnique: UINT; lpTempFileName: PWideChar): UINT; stdcall;
{$EXTERNALSYM GetTempFileNameW}
function GetWindowsDirectory(lpBuffer: PChar; uSize: UINT): UINT; stdcall;
{$EXTERNALSYM GetWindowsDirectory}
function GetWindowsDirectoryA(lpBuffer: PAnsiChar; uSize: UINT): UINT; stdcall;
{$EXTERNALSYM GetWindowsDirectoryA}
function GetWindowsDirectoryW(lpBuffer: PWideChar; uSize: UINT): UINT; stdcall;
{$EXTERNALSYM GetWindowsDirectoryW}
function SetCurrentDirectory(lpPathName: PChar): BOOL; stdcall;
{$EXTERNALSYM SetCurrentDirectory}
function SetCurrentDirectoryA(lpPathName: PAnsiChar): BOOL; stdcall;
{$EXTERNALSYM SetCurrentDirectoryA}
function SetCurrentDirectoryW(lpPathName: PWideChar): BOOL; stdcall;
{$EXTERNALSYM SetCurrentDirectoryW}
function GetCurrentDirectory(nBufferLength: DWORD; lpBuffer: PChar): DWORD; stdcall;
{$EXTERNALSYM GetCurrentDirectory}
function GetCurrentDirectoryA(nBufferLength: DWORD; lpBuffer: PAnsiChar): DWORD; stdcall;
{$EXTERNALSYM GetCurrentDirectoryA}
function GetCurrentDirectoryW(nBufferLength: DWORD; lpBuffer: PWideChar): DWORD; stdcall;
{$EXTERNALSYM GetCurrentDirectoryW}
function GetDiskFreeSpace(lpRootPathName: PChar;
  var lpSectorsPerCluster, lpBytesPerSector, lpNumberOfFreeClusters, lpTotalNumberOfClusters: DWORD): BOOL; stdcall;
{$EXTERNALSYM GetDiskFreeSpace}
function GetDiskFreeSpaceA(lpRootPathName: PAnsiChar;
  var lpSectorsPerCluster, lpBytesPerSector, lpNumberOfFreeClusters, lpTotalNumberOfClusters: DWORD): BOOL; stdcall;
{$EXTERNALSYM GetDiskFreeSpaceA}
function GetDiskFreeSpaceW(lpRootPathName: PWideChar;
  var lpSectorsPerCluster, lpBytesPerSector, lpNumberOfFreeClusters, lpTotalNumberOfClusters: DWORD): BOOL; stdcall;
{$EXTERNALSYM GetDiskFreeSpaceW}
function GetDiskFreeSpaceEx(lpDirectoryName: PChar;
  var lpFreeBytesAvailableToCaller, lpTotalNumberOfBytes; lpTotalNumberOfFreeBytes: PLargeInteger): BOOL; stdcall;
{$EXTERNALSYM GetDiskFreeSpaceEx}
function GetDiskFreeSpaceExA(lpDirectoryName: PAnsiChar;
  var lpFreeBytesAvailableToCaller, lpTotalNumberOfBytes; lpTotalNumberOfFreeBytes: PLargeInteger): BOOL; stdcall;
{$EXTERNALSYM GetDiskFreeSpaceExA}
function GetDiskFreeSpaceExW(lpDirectoryName: PWideChar;
  var lpFreeBytesAvailableToCaller, lpTotalNumberOfBytes; lpTotalNumberOfFreeBytes: PLargeInteger): BOOL; stdcall;
{$EXTERNALSYM GetDiskFreeSpaceExW}
function CreateDirectory(lpPathName: PChar;
  lpSecurityAttributes: PSecurityAttributes): BOOL; stdcall;
{$EXTERNALSYM CreateDirectory}
function CreateDirectoryA(lpPathName: PAnsiChar;
  lpSecurityAttributes: PSecurityAttributes): BOOL; stdcall;
{$EXTERNALSYM CreateDirectoryA}
function CreateDirectoryW(lpPathName: PWideChar;
  lpSecurityAttributes: PSecurityAttributes): BOOL; stdcall;
{$EXTERNALSYM CreateDirectoryW}
function CreateDirectoryEx(lpTemplateDirectory, lpNewDirectory: PChar;
  lpSecurityAttributes: PSecurityAttributes): BOOL; stdcall;
{$EXTERNALSYM CreateDirectoryEx}
function CreateDirectoryExA(lpTemplateDirectory, lpNewDirectory: PAnsiChar;
  lpSecurityAttributes: PSecurityAttributes): BOOL; stdcall;
{$EXTERNALSYM CreateDirectoryExA}
function CreateDirectoryExW(lpTemplateDirectory, lpNewDirectory: PWideChar;
  lpSecurityAttributes: PSecurityAttributes): BOOL; stdcall;
{$EXTERNALSYM CreateDirectoryExW}
function RemoveDirectory(lpPathName: PChar): BOOL; stdcall;
{$EXTERNALSYM RemoveDirectory}
function RemoveDirectoryA(lpPathName: PAnsiChar): BOOL; stdcall;
{$EXTERNALSYM RemoveDirectoryA}
function RemoveDirectoryW(lpPathName: PWideChar): BOOL; stdcall;
{$EXTERNALSYM RemoveDirectoryW}
function GetFullPathName(lpFileName: PChar; nBufferLength: DWORD;
  lpBuffer: PChar; var lpFilePart: PChar): DWORD; stdcall;
{$EXTERNALSYM GetFullPathName}
function GetFullPathNameA(lpFileName: PAnsiChar; nBufferLength: DWORD;
  lpBuffer: PAnsiChar; var lpFilePart: PAnsiChar): DWORD; stdcall;
{$EXTERNALSYM GetFullPathNameA}
function GetFullPathNameW(lpFileName: PWideChar; nBufferLength: DWORD;
  lpBuffer: PWideChar; var lpFilePart: PWideChar): DWORD; stdcall;
{$EXTERNALSYM GetFullPathNameW}

const
  DDD_RAW_TARGET_PATH             = $00000001;
  {$EXTERNALSYM DDD_RAW_TARGET_PATH}
  DDD_REMOVE_DEFINITION           = $00000002;
  {$EXTERNALSYM DDD_REMOVE_DEFINITION}
  DDD_EXACT_MATCH_ON_REMOVE       = $00000004;
  {$EXTERNALSYM DDD_EXACT_MATCH_ON_REMOVE}
  DDD_NO_BROADCAST_SYSTEM         = $00000008;
  {$EXTERNALSYM DDD_NO_BROADCAST_SYSTEM}

function DefineDosDevice(dwFlags: DWORD; lpDeviceName, lpTargetPath: PChar): BOOL; stdcall;
{$EXTERNALSYM DefineDosDevice}
function DefineDosDeviceA(dwFlags: DWORD; lpDeviceName, lpTargetPath: PAnsiChar): BOOL; stdcall;
{$EXTERNALSYM DefineDosDeviceA}
function DefineDosDeviceW(dwFlags: DWORD; lpDeviceName, lpTargetPath: PWideChar): BOOL; stdcall;
{$EXTERNALSYM DefineDosDeviceW}
function QueryDosDevice(lpDeviceName: PChar; lpTargetPath: PChar; ucchMax: DWORD): DWORD; stdcall;
{$EXTERNALSYM QueryDosDevice}
function QueryDosDeviceA(lpDeviceName: PAnsiChar; lpTargetPath: PAnsiChar; ucchMax: DWORD): DWORD; stdcall;
{$EXTERNALSYM QueryDosDeviceA}
function QueryDosDeviceW(lpDeviceName: PWideChar; lpTargetPath: PWideChar; ucchMax: DWORD): DWORD; stdcall;
{$EXTERNALSYM QueryDosDeviceW}
function CreateFile(lpFileName: PChar; dwDesiredAccess, dwShareMode: DWORD;
  lpSecurityAttributes: PSecurityAttributes; dwCreationDisposition, dwFlagsAndAttributes: DWORD;
  hTemplateFile: THandle): THandle; stdcall;
{$EXTERNALSYM CreateFile}
function CreateFileA(lpFileName: PAnsiChar; dwDesiredAccess, dwShareMode: DWORD;
  lpSecurityAttributes: PSecurityAttributes; dwCreationDisposition, dwFlagsAndAttributes: DWORD;
  hTemplateFile: THandle): THandle; stdcall;
{$EXTERNALSYM CreateFileA}
function CreateFileW(lpFileName: PWideChar; dwDesiredAccess, dwShareMode: DWORD;
  lpSecurityAttributes: PSecurityAttributes; dwCreationDisposition, dwFlagsAndAttributes: DWORD;
  hTemplateFile: THandle): THandle; stdcall;
{$EXTERNALSYM CreateFileW}
function SetFileAttributes(lpFileName: PChar; dwFileAttributes: DWORD): BOOL; stdcall;
{$EXTERNALSYM SetFileAttributes}
function SetFileAttributesA(lpFileName: PAnsiChar; dwFileAttributes: DWORD): BOOL; stdcall;
{$EXTERNALSYM SetFileAttributesA}
function SetFileAttributesW(lpFileName: PWideChar; dwFileAttributes: DWORD): BOOL; stdcall;
{$EXTERNALSYM SetFileAttributesW}
function GetFileAttributes(lpFileName: PChar): DWORD; stdcall;
{$EXTERNALSYM GetFileAttributes}
function GetFileAttributesA(lpFileName: PAnsiChar): DWORD; stdcall;
{$EXTERNALSYM GetFileAttributesA}
function GetFileAttributesW(lpFileName: PWideChar): DWORD; stdcall;
{$EXTERNALSYM GetFileAttributesW}
type
  _GET_FILEEX_INFO_LEVELS = (GetFileExInfoStandard, GetFileExMaxInfoLevel);
  {$EXTERNALSYM _GET_FILEEX_INFO_LEVELS}
  TGetFileExInfoLevels = _GET_FILEEX_INFO_LEVELS;
  GET_FILEEX_INFO_LEVELS = _GET_FILEEX_INFO_LEVELS;
  {$EXTERNALSYM GET_FILEEX_INFO_LEVELS}
function GetFileAttributesEx(lpFileName: PChar;
  fInfoLevelId: TGetFileExInfoLevels; lpFileInformation: Pointer): BOOL; stdcall;
{$EXTERNALSYM GetFileAttributesEx}
function GetFileAttributesExA(lpFileName: PAnsiChar;
  fInfoLevelId: TGetFileExInfoLevels; lpFileInformation: Pointer): BOOL; stdcall;
{$EXTERNALSYM GetFileAttributesExA}
function GetFileAttributesExW(lpFileName: PWideChar;
  fInfoLevelId: TGetFileExInfoLevels; lpFileInformation: Pointer): BOOL; stdcall;
{$EXTERNALSYM GetFileAttributesExW}
function GetCompressedFileSize(lpFileName: PChar; lpFileSizeHigh: PDWORD): DWORD; stdcall;
{$EXTERNALSYM GetCompressedFileSize}
function GetCompressedFileSizeA(lpFileName: PAnsiChar; lpFileSizeHigh: PDWORD): DWORD; stdcall;
{$EXTERNALSYM GetCompressedFileSizeA}
function GetCompressedFileSizeW(lpFileName: PWideChar; lpFileSizeHigh: PDWORD): DWORD; stdcall;
{$EXTERNALSYM GetCompressedFileSizeW}
function DeleteFile(lpFileName: PChar): BOOL; stdcall;
{$EXTERNALSYM DeleteFile}
function DeleteFileA(lpFileName: PAnsiChar): BOOL; stdcall;
{$EXTERNALSYM DeleteFileA}
function DeleteFileW(lpFileName: PWideChar): BOOL; stdcall;
{$EXTERNALSYM DeleteFileW}
type
  _FINDEX_INFO_LEVELS = (FindExInfoStandard, FindExInfoMaxInfoLevel);
  {$EXTERNALSYM _FINDEX_INFO_LEVELS}
  TFindexInfoLevels = _FINDEX_INFO_LEVELS;
  FINDEX_INFO_LEVELS = _FINDEX_INFO_LEVELS;
  {$EXTERNALSYM FINDEX_INFO_LEVELS}

  _FINDEX_SEARCH_OPS = (FindExSearchNameMatch, FindExSearchLimitToDirectories,
  {$EXTERNALSYM _FINDEX_SEARCH_OPS}
    FindExSearchLimitToDevices, FindExSearchMaxSearchOp);
  TFindexSearchOps = _FINDEX_SEARCH_OPS;
  FINDEX_SEARCH_OPS = _FINDEX_SEARCH_OPS;
  {$EXTERNALSYM FINDEX_SEARCH_OPS}
const
  FIND_FIRST_EX_CASE_SENSITIVE = $00000001;
  {$EXTERNALSYM FIND_FIRST_EX_CASE_SENSITIVE}

function FindFirstFileEx(lpFileName: PChar; fInfoLevelId: TFindexInfoLevels;
  lpFindFileData: Pointer; fSearchOp: TFindexSearchOps; lpSearchFilter: Pointer;
  dwAdditionalFlags: DWORD): BOOL; stdcall;
{$EXTERNALSYM FindFirstFileEx}
function FindFirstFileExA(lpFileName: PAnsiChar; fInfoLevelId: TFindexInfoLevels;
  lpFindFileData: Pointer; fSearchOp: TFindexSearchOps; lpSearchFilter: Pointer;
  dwAdditionalFlags: DWORD): BOOL; stdcall;
{$EXTERNALSYM FindFirstFileExA}
function FindFirstFileExW(lpFileName: PWideChar; fInfoLevelId: TFindexInfoLevels;
  lpFindFileData: Pointer; fSearchOp: TFindexSearchOps; lpSearchFilter: Pointer;
  dwAdditionalFlags: DWORD): BOOL; stdcall;
{$EXTERNALSYM FindFirstFileExW}
function FindFirstFile(lpFileName: PChar; var lpFindFileData: TWIN32FindData): THandle; stdcall;
{$EXTERNALSYM FindFirstFile}
function FindFirstFileA(lpFileName: PAnsiChar; var lpFindFileData: TWIN32FindDataA): THandle; stdcall;
{$EXTERNALSYM FindFirstFileA}
function FindFirstFileW(lpFileName: PWideChar; var lpFindFileData: TWIN32FindDataW): THandle; stdcall;
{$EXTERNALSYM FindFirstFileW}
function FindNextFile(hFindFile: THandle; var lpFindFileData: TWIN32FindData): BOOL; stdcall;
{$EXTERNALSYM FindNextFile}
function FindNextFileA(hFindFile: THandle; var lpFindFileData: TWIN32FindDataA): BOOL; stdcall;
{$EXTERNALSYM FindNextFileA}
function FindNextFileW(hFindFile: THandle; var lpFindFileData: TWIN32FindDataW): BOOL; stdcall;
{$EXTERNALSYM FindNextFileW}
function SearchPath(lpPath, lpFileName, lpExtension: PChar;
  nBufferLength: DWORD; lpBuffer: PChar; var lpFilePart: PChar): DWORD; stdcall;
{$EXTERNALSYM SearchPath}
function SearchPathA(lpPath, lpFileName, lpExtension: PAnsiChar;
  nBufferLength: DWORD; lpBuffer: PAnsiChar; var lpFilePart: PAnsiChar): DWORD; stdcall;
{$EXTERNALSYM SearchPathA}
function SearchPathW(lpPath, lpFileName, lpExtension: PWideChar;
  nBufferLength: DWORD; lpBuffer: PWideChar; var lpFilePart: PWideChar): DWORD; stdcall;
{$EXTERNALSYM SearchPathW}
function CopyFile(lpExistingFileName, lpNewFileName: PChar; bFailIfExists: BOOL): BOOL; stdcall;
{$EXTERNALSYM CopyFile}
function CopyFileA(lpExistingFileName, lpNewFileName: PAnsiChar; bFailIfExists: BOOL): BOOL; stdcall;
{$EXTERNALSYM CopyFileA}
function CopyFileW(lpExistingFileName, lpNewFileName: PWideChar; bFailIfExists: BOOL): BOOL; stdcall;
{$EXTERNALSYM CopyFileW}

type






  TFNProgressRoutine = TFarProc;


function CopyFileEx(lpExistingFileName, lpNewFileName: PChar;
  lpProgressRoutine: TFNProgressRoutine; lpData: Pointer; pbCancel: PBool;
  dwCopyFlags: DWORD): BOOL; stdcall;
{$EXTERNALSYM CopyFileEx}
function CopyFileExA(lpExistingFileName, lpNewFileName: PAnsiChar;
  lpProgressRoutine: TFNProgressRoutine; lpData: Pointer; pbCancel: PBool;
  dwCopyFlags: DWORD): BOOL; stdcall;
{$EXTERNALSYM CopyFileExA}
function CopyFileExW(lpExistingFileName, lpNewFileName: PWideChar;
  lpProgressRoutine: TFNProgressRoutine; lpData: Pointer; pbCancel: PBool;
  dwCopyFlags: DWORD): BOOL; stdcall;
{$EXTERNALSYM CopyFileExW}
function MoveFile(lpExistingFileName, lpNewFileName: PChar): BOOL; stdcall;
{$EXTERNALSYM MoveFile}
function MoveFileA(lpExistingFileName, lpNewFileName: PAnsiChar): BOOL; stdcall;
{$EXTERNALSYM MoveFileA}
function MoveFileW(lpExistingFileName, lpNewFileName: PWideChar): BOOL; stdcall;
{$EXTERNALSYM MoveFileW}
function MoveFileEx(lpExistingFileName, lpNewFileName: PChar; dwFlags: DWORD): BOOL; stdcall;
{$EXTERNALSYM MoveFileEx}
function MoveFileExA(lpExistingFileName, lpNewFileName: PAnsiChar; dwFlags: DWORD): BOOL; stdcall;
{$EXTERNALSYM MoveFileExA}
function MoveFileExW(lpExistingFileName, lpNewFileName: PWideChar; dwFlags: DWORD): BOOL; stdcall;
{$EXTERNALSYM MoveFileExW}
function MoveFileWithProgress(lpExistingFileName, lpNewFileName: PChar; lpProgressRoutine: TFNProgressRoutine;
  lpData: Pointer; dwFlags: DWORD): BOOL; stdcall;
{$EXTERNALSYM MoveFileWithProgress}
function MoveFileWithProgressA(lpExistingFileName, lpNewFileName: PAnsiChar; lpProgressRoutine: TFNProgressRoutine;
  lpData: Pointer; dwFlags: DWORD): BOOL; stdcall;
{$EXTERNALSYM MoveFileWithProgressA}
function MoveFileWithProgressW(lpExistingFileName, lpNewFileName: PWideChar; lpProgressRoutine: TFNProgressRoutine;
  lpData: Pointer; dwFlags: DWORD): BOOL; stdcall;
{$EXTERNALSYM MoveFileWithProgressW}

const
  MOVEFILE_REPLACE_EXISTING       = $00000001;
  {$EXTERNALSYM MOVEFILE_REPLACE_EXISTING}
  MOVEFILE_COPY_ALLOWED           = $00000002;
  {$EXTERNALSYM MOVEFILE_COPY_ALLOWED}
  MOVEFILE_DELAY_UNTIL_REBOOT     = $00000004;
  {$EXTERNALSYM MOVEFILE_DELAY_UNTIL_REBOOT}
  MOVEFILE_WRITE_THROUGH          = $00000008;
  {$EXTERNALSYM MOVEFILE_WRITE_THROUGH}
  MOVEFILE_CREATE_HARDLINK        = $00000010;
  {$EXTERNALSYM MOVEFILE_CREATE_HARDLINK}
  MOVEFILE_FAIL_IF_NOT_TRACKABLE  = $00000020;
  {$EXTERNALSYM MOVEFILE_FAIL_IF_NOT_TRACKABLE}

function CreateHardLink(lpFileName, lpExistingFileName: PChar;
  lpSecurityAttributes: PSecurityAttributes): BOOL; stdcall;
{$EXTERNALSYM CreateHardLink}
function CreateHardLinkA(lpFileName, lpExistingFileName: PAnsiChar;
  lpSecurityAttributes: PSecurityAttributes): BOOL; stdcall;
{$EXTERNALSYM CreateHardLinkA}
function CreateHardLinkW(lpFileName, lpExistingFileName: PWideChar;
  lpSecurityAttributes: PSecurityAttributes): BOOL; stdcall;
{$EXTERNALSYM CreateHardLinkW}
function CreateNamedPipe(lpName: PChar;
  dwOpenMode, dwPipeMode, nMaxInstances, nOutBufferSize, nInBufferSize, nDefaultTimeOut: DWORD;
  lpSecurityAttributes: PSecurityAttributes): THandle; stdcall;
{$EXTERNALSYM CreateNamedPipe}
function CreateNamedPipeA(lpName: PAnsiChar;
  dwOpenMode, dwPipeMode, nMaxInstances, nOutBufferSize, nInBufferSize, nDefaultTimeOut: DWORD;
  lpSecurityAttributes: PSecurityAttributes): THandle; stdcall;
{$EXTERNALSYM CreateNamedPipeA}
function CreateNamedPipeW(lpName: PWideChar;
  dwOpenMode, dwPipeMode, nMaxInstances, nOutBufferSize, nInBufferSize, nDefaultTimeOut: DWORD;
  lpSecurityAttributes: PSecurityAttributes): THandle; stdcall;
{$EXTERNALSYM CreateNamedPipeW}
function GetNamedPipeHandleState(hNamedPipe: THandle;
  lpState, lpCurInstances, lpMaxCollectionCount, lpCollectDataTimeout: PDWORD;
  lpUserName: PChar; nMaxUserNameSize: DWORD): BOOL; stdcall;
{$EXTERNALSYM GetNamedPipeHandleState}
function GetNamedPipeHandleStateA(hNamedPipe: THandle;
  lpState, lpCurInstances, lpMaxCollectionCount, lpCollectDataTimeout: PDWORD;
  lpUserName: PAnsiChar; nMaxUserNameSize: DWORD): BOOL; stdcall;
{$EXTERNALSYM GetNamedPipeHandleStateA}
function GetNamedPipeHandleStateW(hNamedPipe: THandle;
  lpState, lpCurInstances, lpMaxCollectionCount, lpCollectDataTimeout: PDWORD;
  lpUserName: PWideChar; nMaxUserNameSize: DWORD): BOOL; stdcall;
{$EXTERNALSYM GetNamedPipeHandleStateW}
function CallNamedPipe(lpNamedPipeName: PChar; lpInBuffer: Pointer;
  nInBufferSize: DWORD; lpOutBuffer: Pointer; nOutBufferSize: DWORD;
  var lpBytesRead: DWORD; nTimeOut: DWORD): BOOL; stdcall;
{$EXTERNALSYM CallNamedPipe}
function CallNamedPipeA(lpNamedPipeName: PAnsiChar; lpInBuffer: Pointer;
  nInBufferSize: DWORD; lpOutBuffer: Pointer; nOutBufferSize: DWORD;
  var lpBytesRead: DWORD; nTimeOut: DWORD): BOOL; stdcall;
{$EXTERNALSYM CallNamedPipeA}
function CallNamedPipeW(lpNamedPipeName: PWideChar; lpInBuffer: Pointer;
  nInBufferSize: DWORD; lpOutBuffer: Pointer; nOutBufferSize: DWORD;
  var lpBytesRead: DWORD; nTimeOut: DWORD): BOOL; stdcall;
{$EXTERNALSYM CallNamedPipeW}
function WaitNamedPipe(lpNamedPipeName: PChar; nTimeOut: DWORD): BOOL; stdcall;
{$EXTERNALSYM WaitNamedPipe}
function WaitNamedPipeA(lpNamedPipeName: PAnsiChar; nTimeOut: DWORD): BOOL; stdcall;
{$EXTERNALSYM WaitNamedPipeA}
function WaitNamedPipeW(lpNamedPipeName: PWideChar; nTimeOut: DWORD): BOOL; stdcall;
{$EXTERNALSYM WaitNamedPipeW}
function SetVolumeLabel(lpRootPathName: PChar; lpVolumeName: PChar): BOOL; stdcall;
{$EXTERNALSYM SetVolumeLabel}
function SetVolumeLabelA(lpRootPathName: PAnsiChar; lpVolumeName: PAnsiChar): BOOL; stdcall;
{$EXTERNALSYM SetVolumeLabelA}
function SetVolumeLabelW(lpRootPathName: PWideChar; lpVolumeName: PWideChar): BOOL; stdcall;
{$EXTERNALSYM SetVolumeLabelW}
procedure SetFileApisToOEM; stdcall;
{$EXTERNALSYM SetFileApisToOEM}
procedure SetFileApisToANSI; stdcall;
{$EXTERNALSYM SetFileApisToANSI}
function AreFileApisANSI: BOOL; stdcall;
{$EXTERNALSYM AreFileApisANSI}
function GetVolumeInformation(lpRootPathName: PChar;
  lpVolumeNameBuffer: PChar; nVolumeNameSize: DWORD; lpVolumeSerialNumber: PDWORD;
  var lpMaximumComponentLength, lpFileSystemFlags: DWORD;
  lpFileSystemNameBuffer: PChar; nFileSystemNameSize: DWORD): BOOL; stdcall;
{$EXTERNALSYM GetVolumeInformation}
function GetVolumeInformationA(lpRootPathName: PAnsiChar;
  lpVolumeNameBuffer: PAnsiChar; nVolumeNameSize: DWORD; lpVolumeSerialNumber: PDWORD;
  var lpMaximumComponentLength, lpFileSystemFlags: DWORD;
  lpFileSystemNameBuffer: PAnsiChar; nFileSystemNameSize: DWORD): BOOL; stdcall;
{$EXTERNALSYM GetVolumeInformationA}
function GetVolumeInformationW(lpRootPathName: PWideChar;
  lpVolumeNameBuffer: PWideChar; nVolumeNameSize: DWORD; lpVolumeSerialNumber: PDWORD;
  var lpMaximumComponentLength, lpFileSystemFlags: DWORD;
  lpFileSystemNameBuffer: PWideChar; nFileSystemNameSize: DWORD): BOOL; stdcall;
{$EXTERNALSYM GetVolumeInformationW}

function CancelIo(hFile: THandle): BOOL; stdcall;
{$EXTERNALSYM CancelIo}

{ Event logging APIs }

function ClearEventLog(hEventLog: THandle; lpBackupFileName: PChar): BOOL; stdcall;
{$EXTERNALSYM ClearEventLog}
function ClearEventLogA(hEventLog: THandle; lpBackupFileName: PAnsiChar): BOOL; stdcall;
{$EXTERNALSYM ClearEventLogA}
function ClearEventLogW(hEventLog: THandle; lpBackupFileName: PWideChar): BOOL; stdcall;
{$EXTERNALSYM ClearEventLogW}
function BackupEventLog(hEventLog: THandle; lpBackupFileName: PChar): BOOL; stdcall;
{$EXTERNALSYM BackupEventLog}
function BackupEventLogA(hEventLog: THandle; lpBackupFileName: PAnsiChar): BOOL; stdcall;
{$EXTERNALSYM BackupEventLogA}
function BackupEventLogW(hEventLog: THandle; lpBackupFileName: PWideChar): BOOL; stdcall;
{$EXTERNALSYM BackupEventLogW}
function CloseEventLog(hEventLog: THandle): BOOL; stdcall;
{$EXTERNALSYM CloseEventLog}
function DeregisterEventSource(hEventLog: THandle): BOOL; stdcall;
{$EXTERNALSYM DeregisterEventSource}
function NotifyChangeEventLog(hEventLog, hEvent: THandle): BOOL; stdcall;
{$EXTERNALSYM NotifyChangeEventLog}
function GetNumberOfEventLogRecords(hEventLog: THandle; var NumberOfRecords: DWORD): BOOL; stdcall;
{$EXTERNALSYM GetNumberOfEventLogRecords}
function GetOldestEventLogRecord(hEventLog: THandle; var OldestRecord: DWORD): BOOL; stdcall;
{$EXTERNALSYM GetOldestEventLogRecord}
function OpenEventLog(lpUNCServerName, lpSourceName: PChar): THandle; stdcall;
{$EXTERNALSYM OpenEventLog}
function OpenEventLogA(lpUNCServerName, lpSourceName: PAnsiChar): THandle; stdcall;
{$EXTERNALSYM OpenEventLogA}
function OpenEventLogW(lpUNCServerName, lpSourceName: PWideChar): THandle; stdcall;
{$EXTERNALSYM OpenEventLogW}
function RegisterEventSource(lpUNCServerName, lpSourceName: PChar): THandle; stdcall;
{$EXTERNALSYM RegisterEventSource}
function RegisterEventSourceA(lpUNCServerName, lpSourceName: PAnsiChar): THandle; stdcall;
{$EXTERNALSYM RegisterEventSourceA}
function RegisterEventSourceW(lpUNCServerName, lpSourceName: PWideChar): THandle; stdcall;
{$EXTERNALSYM RegisterEventSourceW}
function OpenBackupEventLog(lpUNCServerName, lpFileName: PChar): THandle; stdcall;
{$EXTERNALSYM OpenBackupEventLog}
function OpenBackupEventLogA(lpUNCServerName, lpFileName: PAnsiChar): THandle; stdcall;
{$EXTERNALSYM OpenBackupEventLogA}
function OpenBackupEventLogW(lpUNCServerName, lpFileName: PWideChar): THandle; stdcall;
{$EXTERNALSYM OpenBackupEventLogW}
function ReadEventLog(hEventLog: THandle; dwReadFlags, dwRecordOffset: DWORD;
  lpBuffer: Pointer; nNumberOfBytesToRead: DWORD;
  var pnBytesRead, pnMinNumberOfBytesNeeded: DWORD): BOOL; stdcall;
{$EXTERNALSYM ReadEventLog}
function ReadEventLogA(hEventLog: THandle; dwReadFlags, dwRecordOffset: DWORD;
  lpBuffer: Pointer; nNumberOfBytesToRead: DWORD;
  var pnBytesRead, pnMinNumberOfBytesNeeded: DWORD): BOOL; stdcall;
{$EXTERNALSYM ReadEventLogA}
function ReadEventLogW(hEventLog: THandle; dwReadFlags, dwRecordOffset: DWORD;
  lpBuffer: Pointer; nNumberOfBytesToRead: DWORD;
  var pnBytesRead, pnMinNumberOfBytesNeeded: DWORD): BOOL; stdcall;
{$EXTERNALSYM ReadEventLogW}
function ReportEvent(hEventLog: THandle; wType, wCategory: Word;
  dwEventID: DWORD; lpUserSid: Pointer; wNumStrings: Word;
  dwDataSize: DWORD; lpStrings, lpRawData: Pointer): BOOL; stdcall;
{$EXTERNALSYM ReportEvent}
function ReportEventA(hEventLog: THandle; wType, wCategory: Word;
  dwEventID: DWORD; lpUserSid: Pointer; wNumStrings: Word;
  dwDataSize: DWORD; lpStrings, lpRawData: Pointer): BOOL; stdcall;
{$EXTERNALSYM ReportEventA}
function ReportEventW(hEventLog: THandle; wType, wCategory: Word;
  dwEventID: DWORD; lpUserSid: Pointer; wNumStrings: Word;
  dwDataSize: DWORD; lpStrings, lpRawData: Pointer): BOOL; stdcall;
{$EXTERNALSYM ReportEventW}

{ Security APIs }

function DuplicateToken(ExistingTokenHandle: THandle;
  ImpersonationLevel: TSecurityImpersonationLevel; DuplicateTokenHandle: PHandle): BOOL; stdcall;
{$EXTERNALSYM DuplicateToken}
function GetKernelObjectSecurity(Handle: THandle; RequestedInformation: SECURITY_INFORMATION;
  pSecurityDescriptor: PSecurityDescriptor; nLength: DWORD;
  var lpnLengthNeeded: DWORD): BOOL; stdcall;
{$EXTERNALSYM GetKernelObjectSecurity}
function ImpersonateNamedPipeClient(hNamedPipe: THandle): BOOL; stdcall;
{$EXTERNALSYM ImpersonateNamedPipeClient}
function ImpersonateSelf(ImpersonationLevel: TSecurityImpersonationLevel): BOOL; stdcall;
{$EXTERNALSYM ImpersonateSelf}
function RevertToSelf: BOOL; stdcall;
{$EXTERNALSYM RevertToSelf}
function SetThreadToken(Thread: PHandle; Token: THandle): BOOL; stdcall;
{$EXTERNALSYM SetThreadToken}
function AccessCheck(pSecurityDescriptor: PSecurityDescriptor;
  ClientToken: THandle; DesiredAccess: DWORD; const GenericMapping: TGenericMapping;
  var PrivilegeSet: TPrivilegeSet; var PrivilegeSetLength: DWORD;
  var GrantedAccess: DWORD; var AccessStatus: BOOL): BOOL; stdcall;
{$EXTERNALSYM AccessCheck}
function AccessCheckByType(pSecurityDescriptor: PSecurityDescriptor; PrincipalSelfSid: PSID;
  ClientToken: THandle; DesiredAccess: DWORD; ObjectTypeList: PObjectTypeList;
  const GenericMapping: TGenericMapping; ObjectTypeListLength: DWORD;
  var PrivilegeSet: TPrivilegeSet; var PrivilegeSetLength: DWORD;
  var GrantedAccess: DWORD; var AccessStatus: BOOL): BOOL; stdcall;
{$EXTERNALSYM AccessCheckByType}
function AccessCheckByTypeResultList(pSecurityDescriptor: PSecurityDescriptor; PrincipalSelfSid: PSID;
  ClientToken: THandle; DesiredAccess: DWORD; ObjectTypeList: PObjectTypeList;
  const GenericMapping: TGenericMapping; ObjectTypeListLength: DWORD;
  var PrivilegeSet: TPrivilegeSet; var PrivilegeSetLength: DWORD;
  var GrantedAccess: DWORD; var AccessStatusList: DWORD): BOOL; stdcall;
{$EXTERNALSYM AccessCheckByTypeResultList}
function OpenProcessToken(ProcessHandle: THandle; DesiredAccess: DWORD;
  var TokenHandle: THandle): BOOL; stdcall;
{$EXTERNALSYM OpenProcessToken}
function OpenThreadToken(ThreadHandle: THandle; DesiredAccess: DWORD;
  OpenAsSelf: BOOL; var TokenHandle: THandle): BOOL; stdcall;
{$EXTERNALSYM OpenThreadToken}
function GetTokenInformation(TokenHandle: THandle;
  TokenInformationClass: TTokenInformationClass; TokenInformation: Pointer;
  TokenInformationLength: DWORD; var ReturnLength: DWORD): BOOL; stdcall;
{$EXTERNALSYM GetTokenInformation}
function SetTokenInformation(TokenHandle: THandle;
  TokenInformationClass: TTokenInformationClass; TokenInformation: Pointer;
  TokenInformationLength: DWORD): BOOL; stdcall;
{$EXTERNALSYM SetTokenInformation}
function AdjustTokenPrivileges(TokenHandle: THandle; DisableAllPrivileges: BOOL;
  const NewState: TTokenPrivileges; BufferLength: DWORD;
  var PreviousState: TTokenPrivileges; var ReturnLength: DWORD): BOOL; stdcall; overload;
{$EXTERNALSYM AdjustTokenPrivileges}
function AdjustTokenPrivileges(TokenHandle: THandle; DisableAllPrivileges: BOOL;
  const NewState: TTokenPrivileges; BufferLength: DWORD;
  PreviousState: PTokenPrivileges; var ReturnLength: DWORD): BOOL; stdcall; overload;
{$EXTERNALSYM AdjustTokenPrivileges}
function AdjustTokenGroups(TokenHandle: THandle; ResetToDefault: BOOL;
  const NewState: TTokenGroups; BufferLength: DWORD;
  var PreviousState: TTokenGroups; var ReturnLength: DWORD): BOOL; stdcall;
{$EXTERNALSYM AdjustTokenGroups}
function PrivilegeCheck(ClientToken: THandle; const RequiredPrivileges: TPrivilegeSet;
  var pfResult: BOOL): BOOL; stdcall;
{$EXTERNALSYM PrivilegeCheck}
function AccessCheckAndAuditAlarm(SubsystemName: PChar;
  HandleId: Pointer; ObjectTypeName, ObjectName: PChar;
  SecurityDescriptor: PSecurityDescriptor; DesiredAccess: DWORD;
  const GenericMapping: TGenericMapping;  ObjectCreation: BOOL;
  var GrantedAccess: DWORD; var AccessStatus, pfGenerateOnClose: BOOL): BOOL; stdcall;
{$EXTERNALSYM AccessCheckAndAuditAlarm}
function AccessCheckAndAuditAlarmA(SubsystemName: PAnsiChar;
  HandleId: Pointer; ObjectTypeName, ObjectName: PAnsiChar;
  SecurityDescriptor: PSecurityDescriptor; DesiredAccess: DWORD;
  const GenericMapping: TGenericMapping;  ObjectCreation: BOOL;
  var GrantedAccess: DWORD; var AccessStatus, pfGenerateOnClose: BOOL): BOOL; stdcall;
{$EXTERNALSYM AccessCheckAndAuditAlarmA}
function AccessCheckAndAuditAlarmW(SubsystemName: PWideChar;
  HandleId: Pointer; ObjectTypeName, ObjectName: PWideChar;
  SecurityDescriptor: PSecurityDescriptor; DesiredAccess: DWORD;
  const GenericMapping: TGenericMapping;  ObjectCreation: BOOL;
  var GrantedAccess: DWORD; var AccessStatus, pfGenerateOnClose: BOOL): BOOL; stdcall;
{$EXTERNALSYM AccessCheckAndAuditAlarmW}
function AccessCheckByTypeAndAuditAlarm(SubsystemName: PChar;
  HandleId: Pointer; ObjectTypeName, ObjectName: PChar;
  SecurityDescriptor: PSecurityDescriptor; PrincipalSelfSid: PSID; DesiredAccess: DWORD;
  AuditType: AUDIT_EVENT_TYPE; Flags: DWORD; ObjectTypeList: PObjectTypeList;
  ObjectTypeListLength: DWORD; const GenericMapping: TGenericMapping;  ObjectCreation: BOOL;
  var GrantedAccess: DWORD; var AccessStatus, pfGenerateOnClose: BOOL): BOOL; stdcall;
{$EXTERNALSYM AccessCheckByTypeAndAuditAlarm}
function AccessCheckByTypeAndAuditAlarmA(SubsystemName: PAnsiChar;
  HandleId: Pointer; ObjectTypeName, ObjectName: PAnsiChar;
  SecurityDescriptor: PSecurityDescriptor; PrincipalSelfSid: PSID; DesiredAccess: DWORD;
  AuditType: AUDIT_EVENT_TYPE; Flags: DWORD; ObjectTypeList: PObjectTypeList;
  ObjectTypeListLength: DWORD; const GenericMapping: TGenericMapping;  ObjectCreation: BOOL;
  var GrantedAccess: DWORD; var AccessStatus, pfGenerateOnClose: BOOL): BOOL; stdcall;
{$EXTERNALSYM AccessCheckByTypeAndAuditAlarmA}
function AccessCheckByTypeAndAuditAlarmW(SubsystemName: PWideChar;
  HandleId: Pointer; ObjectTypeName, ObjectName: PWideChar;
  SecurityDescriptor: PSecurityDescriptor; PrincipalSelfSid: PSID; DesiredAccess: DWORD;
  AuditType: AUDIT_EVENT_TYPE; Flags: DWORD; ObjectTypeList: PObjectTypeList;
  ObjectTypeListLength: DWORD; const GenericMapping: TGenericMapping;  ObjectCreation: BOOL;
  var GrantedAccess: DWORD; var AccessStatus, pfGenerateOnClose: BOOL): BOOL; stdcall;
{$EXTERNALSYM AccessCheckByTypeAndAuditAlarmW}
function AccessCheckByTypeResultListAndAuditAlarm(SubsystemName: PChar;
  HandleId: Pointer; ObjectTypeName, ObjectName: PChar;
  SecurityDescriptor: PSecurityDescriptor; PrincipalSelfSid: PSID; DesiredAccess: DWORD;
  AuditType: AUDIT_EVENT_TYPE; Flags: DWORD; ObjectTypeList: PObjectTypeList;
  ObjectTypeListLength: DWORD; const GenericMapping: TGenericMapping;  ObjectCreation: BOOL;
  var GrantedAccess: DWORD; var AccessStatusList: DWORD; var pfGenerateOnClose: BOOL): BOOL; stdcall;
{$EXTERNALSYM AccessCheckByTypeResultListAndAuditAlarm}
function AccessCheckByTypeResultListAndAuditAlarmA(SubsystemName: PAnsiChar;
  HandleId: Pointer; ObjectTypeName, ObjectName: PAnsiChar;
  SecurityDescriptor: PSecurityDescriptor; PrincipalSelfSid: PSID; DesiredAccess: DWORD;
  AuditType: AUDIT_EVENT_TYPE; Flags: DWORD; ObjectTypeList: PObjectTypeList;
  ObjectTypeListLength: DWORD; const GenericMapping: TGenericMapping;  ObjectCreation: BOOL;
  var GrantedAccess: DWORD; var AccessStatusList: DWORD; var pfGenerateOnClose: BOOL): BOOL; stdcall;
{$EXTERNALSYM AccessCheckByTypeResultListAndAuditAlarmA}
function AccessCheckByTypeResultListAndAuditAlarmW(SubsystemName: PWideChar;
  HandleId: Pointer; ObjectTypeName, ObjectName: PWideChar;
  SecurityDescriptor: PSecurityDescriptor; PrincipalSelfSid: PSID; DesiredAccess: DWORD;
  AuditType: AUDIT_EVENT_TYPE; Flags: DWORD; ObjectTypeList: PObjectTypeList;
  ObjectTypeListLength: DWORD; const GenericMapping: TGenericMapping;  ObjectCreation: BOOL;
  var GrantedAccess: DWORD; var AccessStatusList: DWORD; var pfGenerateOnClose: BOOL): BOOL; stdcall;
{$EXTERNALSYM AccessCheckByTypeResultListAndAuditAlarmW}
function ObjectOpenAuditAlarm(SubsystemName: PChar; HandleId: Pointer;
  ObjectTypeName: PChar; ObjectName: PChar; pSecurityDescriptor: PSecurityDescriptor;
  ClientToken: THandle; DesiredAccess, GrantedAccess: DWORD;
  var Privileges: TPrivilegeSet; ObjectCreation, AccessGranted: BOOL;
  var GenerateOnClose: BOOL): BOOL; stdcall;
{$EXTERNALSYM ObjectOpenAuditAlarm}
function ObjectOpenAuditAlarmA(SubsystemName: PAnsiChar; HandleId: Pointer;
  ObjectTypeName: PAnsiChar; ObjectName: PAnsiChar; pSecurityDescriptor: PSecurityDescriptor;
  ClientToken: THandle; DesiredAccess, GrantedAccess: DWORD;
  var Privileges: TPrivilegeSet; ObjectCreation, AccessGranted: BOOL;
  var GenerateOnClose: BOOL): BOOL; stdcall;
{$EXTERNALSYM ObjectOpenAuditAlarmA}
function ObjectOpenAuditAlarmW(SubsystemName: PWideChar; HandleId: Pointer;
  ObjectTypeName: PWideChar; ObjectName: PWideChar; pSecurityDescriptor: PSecurityDescriptor;
  ClientToken: THandle; DesiredAccess, GrantedAccess: DWORD;
  var Privileges: TPrivilegeSet; ObjectCreation, AccessGranted: BOOL;
  var GenerateOnClose: BOOL): BOOL; stdcall;
{$EXTERNALSYM ObjectOpenAuditAlarmW}
function ObjectPrivilegeAuditAlarm(SubsystemName: PChar;
  HandleId: Pointer; ClientToken: THandle; DesiredAccess: DWORD;
  var Privileges: TPrivilegeSet; AccessGranted: BOOL): BOOL; stdcall;
{$EXTERNALSYM ObjectPrivilegeAuditAlarm}
function ObjectPrivilegeAuditAlarmA(SubsystemName: PAnsiChar;
  HandleId: Pointer; ClientToken: THandle; DesiredAccess: DWORD;
  var Privileges: TPrivilegeSet; AccessGranted: BOOL): BOOL; stdcall;
{$EXTERNALSYM ObjectPrivilegeAuditAlarmA}
function ObjectPrivilegeAuditAlarmW(SubsystemName: PWideChar;
  HandleId: Pointer; ClientToken: THandle; DesiredAccess: DWORD;
  var Privileges: TPrivilegeSet; AccessGranted: BOOL): BOOL; stdcall;
{$EXTERNALSYM ObjectPrivilegeAuditAlarmW}
function ObjectCloseAuditAlarm(SubsystemName: PChar;
  HandleId: Pointer; GenerateOnClose: BOOL): BOOL; stdcall;
{$EXTERNALSYM ObjectCloseAuditAlarm}
function ObjectCloseAuditAlarmA(SubsystemName: PAnsiChar;
  HandleId: Pointer; GenerateOnClose: BOOL): BOOL; stdcall;
{$EXTERNALSYM ObjectCloseAuditAlarmA}
function ObjectCloseAuditAlarmW(SubsystemName: PWideChar;
  HandleId: Pointer; GenerateOnClose: BOOL): BOOL; stdcall;
{$EXTERNALSYM ObjectCloseAuditAlarmW}
function ObjectDeleteAuditAlarm(SubsystemName: PChar;
  HandleId: Pointer; GenerateOnClose: BOOL): BOOL; stdcall;
{$EXTERNALSYM ObjectDeleteAuditAlarm}
function ObjectDeleteAuditAlarmA(SubsystemName: PAnsiChar;
  HandleId: Pointer; GenerateOnClose: BOOL): BOOL; stdcall;
{$EXTERNALSYM ObjectDeleteAuditAlarmA}
function ObjectDeleteAuditAlarmW(SubsystemName: PWideChar;
  HandleId: Pointer; GenerateOnClose: BOOL): BOOL; stdcall;
{$EXTERNALSYM ObjectDeleteAuditAlarmW}
function PrivilegedServiceAuditAlarm(SubsystemName, ServiceName: PChar;
  ClientToken: THandle; var Privileges: TPrivilegeSet; AccessGranted: BOOL): BOOL; stdcall;
{$EXTERNALSYM PrivilegedServiceAuditAlarm}
function PrivilegedServiceAuditAlarmA(SubsystemName, ServiceName: PAnsiChar;
  ClientToken: THandle; var Privileges: TPrivilegeSet; AccessGranted: BOOL): BOOL; stdcall;
{$EXTERNALSYM PrivilegedServiceAuditAlarmA}
function PrivilegedServiceAuditAlarmW(SubsystemName, ServiceName: PWideChar;
  ClientToken: THandle; var Privileges: TPrivilegeSet; AccessGranted: BOOL): BOOL; stdcall;
{$EXTERNALSYM PrivilegedServiceAuditAlarmW}
function IsValidSid(pSid: Pointer): BOOL; stdcall;
{$EXTERNALSYM IsValidSid}
function EqualSid(pSid1, pSid2: Pointer): BOOL; stdcall;
{$EXTERNALSYM EqualSid}
function EqualPrefixSid(pSid1, pSid2: Pointer): BOOL; stdcall;
{$EXTERNALSYM EqualPrefixSid}
function GetSidLengthRequired(nSubAuthorityCount: UCHAR): DWORD; stdcall;
{$EXTERNALSYM GetSidLengthRequired}
function AllocateAndInitializeSid(const pIdentifierAuthority: TSIDIdentifierAuthority;
  nSubAuthorityCount: Byte; nSubAuthority0, nSubAuthority1: DWORD;
  nSubAuthority2, nSubAuthority3, nSubAuthority4: DWORD;
  nSubAuthority5, nSubAuthority6, nSubAuthority7: DWORD;
  var pSid: Pointer): BOOL; stdcall;
{$EXTERNALSYM AllocateAndInitializeSid}
function FreeSid(pSid: Pointer): Pointer; stdcall;
{$EXTERNALSYM FreeSid}
function InitializeSid(Sid: Pointer; const pIdentifierAuthority: TSIDIdentifierAuthority;
  nSubAuthorityCount: Byte): BOOL; stdcall;
{$EXTERNALSYM InitializeSid}
function GetSidIdentifierAuthority(pSid: Pointer): PSIDIdentifierAuthority; stdcall;
{$EXTERNALSYM GetSidIdentifierAuthority}
function GetSidSubAuthority(pSid: Pointer; nSubAuthority: DWORD): PDWORD; stdcall;
{$EXTERNALSYM GetSidSubAuthority}
function GetSidSubAuthorityCount(pSid: Pointer): PUCHAR; stdcall;
{$EXTERNALSYM GetSidSubAuthorityCount}
function GetLengthSid(pSid: Pointer): DWORD; stdcall;
{$EXTERNALSYM GetLengthSid}
function CopySid(nDestinationSidLength: DWORD;
  pDestinationSid, pSourceSid: Pointer): BOOL; stdcall;
{$EXTERNALSYM CopySid}
function AreAllAccessesGranted(GrantedAccess, DesiredAccess: DWORD): BOOL; stdcall;
{$EXTERNALSYM AreAllAccessesGranted}
function AreAnyAccessesGranted(GrantedAccess, DesiredAccess: DWORD): BOOL; stdcall;
{$EXTERNALSYM AreAnyAccessesGranted}
procedure MapGenericMask(var AccessMask: DWORD; const GenericMapping: TGenericMapping); stdcall;
{$EXTERNALSYM MapGenericMask}
function IsValidAcl(const pAcl: TACL): BOOL; stdcall;
{$EXTERNALSYM IsValidAcl}
function InitializeAcl(var pAcl: TACL; nAclLength, dwAclRevision: DWORD): BOOL; stdcall;
{$EXTERNALSYM InitializeAcl}
function GetAclInformation(const pAcl: TACL; pAclInformation: Pointer;
  nAclInformationLength: DWORD; dwAclInformationClass: TAclInformationClass): BOOL; stdcall;
{$EXTERNALSYM GetAclInformation}
function SetAclInformation(var pAcl: TACL; pAclInformation: Pointer;
  nAclInformationLength: DWORD; dwAclInformationClass: TAclInformationClass): BOOL; stdcall;
{$EXTERNALSYM SetAclInformation}
function AddAce(var pAcl: TACL; dwAceRevision, dwStartingAceIndex: DWORD; pAceList: Pointer;
  nAceListLength: DWORD): BOOL; stdcall;
{$EXTERNALSYM AddAce}
function DeleteAce(var pAcl: TACL; dwAceIndex: DWORD): BOOL; stdcall;
{$EXTERNALSYM DeleteAce}
function GetAce(const pAcl: TACL; dwAceIndex: DWORD; var pAce: Pointer): BOOL; stdcall;
{$EXTERNALSYM GetAce}
function AddAccessAllowedAce(var pAcl: TACL; dwAceRevision: DWORD;
  AccessMask: DWORD; pSid: PSID): BOOL; stdcall;
{$EXTERNALSYM AddAccessAllowedAce}
function AddAccessAllowedAceEx(var pAcl: TACL; dwAceRevision: DWORD;
  AceFlags: DWORD; AccessMask: DWORD; pSid: PSID): BOOL; stdcall;
{$EXTERNALSYM AddAccessAllowedAceEx}
function AddAccessDeniedAce(var pAcl: TACL; dwAceRevision: DWORD;
  AccessMask: DWORD; pSid: PSID): BOOL; stdcall;
{$EXTERNALSYM AddAccessDeniedAce}
function AddAccessDeniedAceEx(var pAcl: TACL; dwAceRevision: DWORD;
  ACEFlags: DWORD; AccessMask: DWORD; pSid: PSID): BOOL; stdcall;
{$EXTERNALSYM AddAccessDeniedAceEx}
function AddAuditAccessAce(var pAcl: TACL; dwAceRevision: DWORD;
  dwAccessMask: DWORD; pSid: Pointer; bAuditSuccess, bAuditFailure: BOOL): BOOL; stdcall;
{$EXTERNALSYM AddAuditAccessAce}
function AddAuditAccessAceEx(var pAcl: TACL; dwAceRevision: DWORD;
  AceFlags: DWORD; dwAccessMask: DWORD; pSid: Pointer; bAuditSuccess, bAuditFailure: BOOL): BOOL; stdcall;
{$EXTERNALSYM AddAuditAccessAceEx}
function AddAccessAllowedObjectAce(var pAcl: TACL; dwAceRevision: DWORD;
  AceFlags: DWORD; AccessMask: DWORD; ObjectTypeGuid, InheritedObjectTypeGuid: PGuid; pSid: Pointer): BOOL; stdcall;
{$EXTERNALSYM AddAccessAllowedObjectAce}
function AddAccessDeniedObjectAce(var pAcl: TACL; dwAceRevision: DWORD;
  AceFlags: DWORD; AccessMask: DWORD; ObjectTypeGuid, InheritedObjectTypeGuid: PGuid; pSid: Pointer): BOOL; stdcall;
{$EXTERNALSYM AddAccessDeniedObjectAce}
function AddAuditAccessObjectAce(var pAcl: TACL; dwAceRevision: DWORD;
  AceFlags: DWORD; AccessMask: DWORD; ObjectTypeGuid, InheritedObjectTypeGuid: PGuid; pSid: Pointer; bAuditSuccess, bAuditFailure: BOOL): BOOL; stdcall;
{$EXTERNALSYM AddAuditAccessObjectAce}
function FindFirstFreeAce(var pAcl: TACL; var pAce: Pointer): BOOL; stdcall;
{$EXTERNALSYM FindFirstFreeAce}
function InitializeSecurityDescriptor(pSecurityDescriptor: PSecurityDescriptor;
  dwRevision: DWORD): BOOL; stdcall;
{$EXTERNALSYM InitializeSecurityDescriptor}
function IsValidSecurityDescriptor(pSecurityDescriptor: PSecurityDescriptor): BOOL; stdcall;
{$EXTERNALSYM IsValidSecurityDescriptor}
function GetSecurityDescriptorLength(pSecurityDescriptor: PSecurityDescriptor): DWORD; stdcall;
{$EXTERNALSYM GetSecurityDescriptorLength}
function GetSecurityDescriptorControl(pSecurityDescriptor: PSecurityDescriptor;
  var pControl: SECURITY_DESCRIPTOR_CONTROL; var lpdwRevision: DWORD): BOOL; stdcall;
{$EXTERNALSYM GetSecurityDescriptorControl}
function SetSecurityDescriptorControl(pSecurityDescriptor: PSecurityDescriptor;
  ControlBitsOfInterest, ControlBitsToSet: SECURITY_DESCRIPTOR_CONTROL): BOOL; stdcall;
{$EXTERNALSYM SetSecurityDescriptorControl}
function SetSecurityDescriptorDacl(pSecurityDescriptor: PSecurityDescriptor;
  bDaclPresent: BOOL; pDacl: PACL; bDaclDefaulted: BOOL): BOOL; stdcall;
{$EXTERNALSYM SetSecurityDescriptorDacl}
function GetSecurityDescriptorDacl(pSecurityDescriptor: PSecurityDescriptor;
  var lpbDaclPresent: BOOL; var pDacl: PACL; var lpbDaclDefaulted: BOOL): BOOL; stdcall;
{$EXTERNALSYM GetSecurityDescriptorDacl}
function SetSecurityDescriptorSacl(pSecurityDescriptor: PSecurityDescriptor;
  bSaclPresent: BOOL; pSacl: PACL; bSaclDefaulted: BOOL): BOOL; stdcall;
{$EXTERNALSYM SetSecurityDescriptorSacl}
function GetSecurityDescriptorSacl(pSecurityDescriptor: PSecurityDescriptor;
  var lpbSaclPresent: BOOL; var pSacl: PACL; var lpbSaclDefaulted: BOOL): BOOL; stdcall;
{$EXTERNALSYM GetSecurityDescriptorSacl}
function SetSecurityDescriptorOwner(pSecurityDescriptor: PSecurityDescriptor;
  pOwner: PSID; bOwnerDefaulted: BOOL): BOOL; stdcall;
{$EXTERNALSYM SetSecurityDescriptorOwner}
function GetSecurityDescriptorOwner(pSecurityDescriptor: PSecurityDescriptor;
  var pOwner: PSID; var lpbOwnerDefaulted: BOOL): BOOL; stdcall;
{$EXTERNALSYM GetSecurityDescriptorOwner}
function SetSecurityDescriptorGroup(pSecurityDescriptor: PSecurityDescriptor;
  pGroup: PSID; bGroupDefaulted: BOOL): BOOL; stdcall;
{$EXTERNALSYM SetSecurityDescriptorGroup}
function GetSecurityDescriptorGroup(pSecurityDescriptor: PSecurityDescriptor;
  var pGroup: PSID; var lpbGroupDefaulted: BOOL): BOOL; stdcall;
{$EXTERNALSYM GetSecurityDescriptorGroup}
function CreatePrivateObjectSecurity(ParentDescriptor, CreatorDescriptor: PSecurityDescriptor;
  var NewDescriptor: PSecurityDescriptor; IsDirectoryObject: BOOL;
  Token: THandle; const GenericMapping: TGenericMapping): BOOL; stdcall;
{$EXTERNALSYM CreatePrivateObjectSecurity}
function ConvertToAutoInheritPrivateObjectSecurity(ParentDescriptor, CurrentSecurityDescriptor: PSecurityDescriptor;
  var NewDescriptor: PSecurityDescriptor; ObjectType: PGUID;
  IsDirectoryObject: BOOL; const GenericMapping: TGenericMapping): BOOL; stdcall;
{$EXTERNALSYM ConvertToAutoInheritPrivateObjectSecurity}
function CreatePrivateObjectSecurityEx(ParentDescriptor, CreatorDescriptor: PSecurityDescriptor;
  var NewDescriptor: PSecurityDescriptor; ObjectType: PGUID; IsContainerObject: BOOL;
  AutoInheritFlags: ULONG; Token: THandle; const GenericMapping: TGenericMapping): BOOL; stdcall;
{$EXTERNALSYM CreatePrivateObjectSecurityEx}
function SetPrivateObjectSecurity(SecurityInformation: SECURITY_INFORMATION;
  ModificationDescriptor: PSecurityDescriptor; var ObjectsSecurityDescriptor: PSecurityDescriptor;
  const GenericMapping: TGenericMapping; Token: THandle): BOOL; stdcall;
{$EXTERNALSYM SetPrivateObjectSecurity}
function SetPrivateObjectSecurityEx(SecurityInformation: SECURITY_INFORMATION;
  ModificationDescriptor: PSecurityDescriptor; var ObjectsSecurityDescriptor: PSecurityDescriptor;
  AutoInheritFlags: ULONG; const GenericMapping: TGenericMapping; Token: THandle): BOOL; stdcall;
{$EXTERNALSYM SetPrivateObjectSecurityEx}
function GetPrivateObjectSecurity(ObjectDescriptor: PSecurityDescriptor;
  SecurityInformation: SECURITY_INFORMATION; ResultantDescriptor: PSecurityDescriptor;
  DescriptorLength: DWORD; var ReturnLength: DWORD): BOOL; stdcall;
{$EXTERNALSYM GetPrivateObjectSecurity}
function DestroyPrivateObjectSecurity(var ObjectDescriptor: PSecurityDescriptor): BOOL; stdcall;
{$EXTERNALSYM DestroyPrivateObjectSecurity}
function MakeSelfRelativeSD(pAbsoluteSecurityDescriptor: PSecurityDescriptor;
  pSelfRelativeSecurityDescriptor: PSecurityDescriptor; var lpdwBufferLength: DWORD): BOOL; stdcall;
{$EXTERNALSYM MakeSelfRelativeSD}
function MakeAbsoluteSD(pSelfRelativeSecurityDescriptor: PSecurityDescriptor;
  pAbsoluteSecurityDescriptor: PSecurityDescriptor; var lpdwAbsoluteSecurityDescriptorSi: DWORD;
  var pDacl: TACL; var lpdwDaclSize: DWORD; var pSacl: TACL;
  var lpdwSaclSize: DWORD; pOwner: PSID; var lpdwOwnerSize: DWORD;
  pPrimaryGroup: Pointer; var lpdwPrimaryGroupSize: DWORD): BOOL; stdcall;
{$EXTERNALSYM MakeAbsoluteSD}

function SetFileSecurity(lpFileName: PChar; SecurityInformation: SECURITY_INFORMATION;
  pSecurityDescriptor: PSecurityDescriptor): BOOL; stdcall;
{$EXTERNALSYM SetFileSecurity}
function SetFileSecurityA(lpFileName: PAnsiChar; SecurityInformation: SECURITY_INFORMATION;
  pSecurityDescriptor: PSecurityDescriptor): BOOL; stdcall;
{$EXTERNALSYM SetFileSecurityA}
function SetFileSecurityW(lpFileName: PWideChar; SecurityInformation: SECURITY_INFORMATION;
  pSecurityDescriptor: PSecurityDescriptor): BOOL; stdcall;
{$EXTERNALSYM SetFileSecurityW}
function GetFileSecurity(lpFileName: PChar; RequestedInformation: SECURITY_INFORMATION;
  pSecurityDescriptor: PSecurityDescriptor; nLength: DWORD; var lpnLengthNeeded: DWORD): BOOL; stdcall;
{$EXTERNALSYM GetFileSecurity}
function GetFileSecurityA(lpFileName: PAnsiChar; RequestedInformation: SECURITY_INFORMATION;
  pSecurityDescriptor: PSecurityDescriptor; nLength: DWORD; var lpnLengthNeeded: DWORD): BOOL; stdcall;
{$EXTERNALSYM GetFileSecurityA}
function GetFileSecurityW(lpFileName: PWideChar; RequestedInformation: SECURITY_INFORMATION;
  pSecurityDescriptor: PSecurityDescriptor; nLength: DWORD; var lpnLengthNeeded: DWORD): BOOL; stdcall;
{$EXTERNALSYM GetFileSecurityW}
function SetKernelObjectSecurity(Handle: THandle; SecurityInformation: SECURITY_INFORMATION;
  SecurityDescriptor: PSecurityDescriptor): BOOL; stdcall;
{$EXTERNALSYM SetKernelObjectSecurity}
function FindFirstChangeNotification(lpPathName: PChar;
  bWatchSubtree: BOOL; dwNotifyFilter: DWORD): THandle; stdcall;
{$EXTERNALSYM FindFirstChangeNotification}
function FindFirstChangeNotificationA(lpPathName: PAnsiChar;
  bWatchSubtree: BOOL; dwNotifyFilter: DWORD): THandle; stdcall;
{$EXTERNALSYM FindFirstChangeNotificationA}
function FindFirstChangeNotificationW(lpPathName: PWideChar;
  bWatchSubtree: BOOL; dwNotifyFilter: DWORD): THandle; stdcall;
{$EXTERNALSYM FindFirstChangeNotificationW}
function FindNextChangeNotification(hChangeHandle: THandle): BOOL; stdcall;
{$EXTERNALSYM FindNextChangeNotification}
function FindCloseChangeNotification(hChangeHandle: THandle): BOOL; stdcall;
{$EXTERNALSYM FindCloseChangeNotification}
function ReadDirectoryChanges(hDirectory: THandle; lpBuffer: Pointer;
  nBufferLength: DWORD; bWatchSubtree: Bool; dwNotifyFilter: DWORD;
  lpBytesReturned: LPDWORD; lpOverlapped: POverlapped;
  lpCompletionRoutine: FARPROC): BOOL; stdcall;
{$EXTERNALSYM ReadDirectoryChanges}
function ReadDirectoryChangesW(hDirectory: THandle; lpBuffer: Pointer;
  nBufferLength: DWORD; bWatchSubtree: Bool; dwNotifyFilter: DWORD;
  lpBytesReturned: LPDWORD; lpOverlapped: POverlapped;
  lpCompletionRoutine: FARPROC): BOOL; stdcall;
{$EXTERNALSYM ReadDirectoryChangesW}
function VirtualLock(lpAddress: Pointer; dwSize: DWORD): BOOL; stdcall;
{$EXTERNALSYM VirtualLock}
function VirtualUnlock(lpAddress: Pointer; dwSize: DWORD): BOOL; stdcall;
{$EXTERNALSYM VirtualUnlock}
function MapViewOfFileEx(hFileMappingObject: THandle;
  dwDesiredAccess, dwFileOffsetHigh, dwFileOffsetLow, dwNumberOfBytesToMap: DWORD;
  lpBaseAddress: Pointer): Pointer; stdcall;
{$EXTERNALSYM MapViewOfFileEx}
function SetPriorityClass(hProcess: THandle; dwPriorityClass: DWORD): BOOL; stdcall;
{$EXTERNALSYM SetPriorityClass}
function GetPriorityClass(hProcess: THandle): DWORD; stdcall;
{$EXTERNALSYM GetPriorityClass}
function IsBadReadPtr(lp: Pointer; ucb: UINT): BOOL; stdcall;
{$EXTERNALSYM IsBadReadPtr}
function IsBadWritePtr(lp: Pointer; ucb: UINT): BOOL; stdcall;
{$EXTERNALSYM IsBadWritePtr}
function IsBadHugeReadPtr(lp: Pointer; ucb: UINT): BOOL; stdcall;
{$EXTERNALSYM IsBadHugeReadPtr}
function IsBadHugeWritePtr(lp: Pointer; ucb: UINT): BOOL; stdcall;
{$EXTERNALSYM IsBadHugeWritePtr}
function IsBadCodePtr(lpfn: FARPROC): BOOL; stdcall;
{$EXTERNALSYM IsBadCodePtr}
function IsBadStringPtr(lpsz: PChar; ucchMax: UINT): BOOL; stdcall;
{$EXTERNALSYM IsBadStringPtr}
function IsBadStringPtrA(lpsz: PAnsiChar; ucchMax: UINT): BOOL; stdcall;
{$EXTERNALSYM IsBadStringPtrA}
function IsBadStringPtrW(lpsz: PWideChar; ucchMax: UINT): BOOL; stdcall;
{$EXTERNALSYM IsBadStringPtrW}
function LookupAccountSid(lpSystemName: PChar; Sid: PSID;
  Name: PChar; var cbName: DWORD; ReferencedDomainName: PChar;
  var cbReferencedDomainName: DWORD; var peUse: SID_NAME_USE): BOOL; stdcall;
{$EXTERNALSYM LookupAccountSid}
function LookupAccountSidA(lpSystemName: PAnsiChar; Sid: PSID;
  Name: PAnsiChar; var cbName: DWORD; ReferencedDomainName: PAnsiChar;
  var cbReferencedDomainName: DWORD; var peUse: SID_NAME_USE): BOOL; stdcall;
{$EXTERNALSYM LookupAccountSidA}
function LookupAccountSidW(lpSystemName: PWideChar; Sid: PSID;
  Name: PWideChar; var cbName: DWORD; ReferencedDomainName: PWideChar;
  var cbReferencedDomainName: DWORD; var peUse: SID_NAME_USE): BOOL; stdcall;
{$EXTERNALSYM LookupAccountSidW}
function LookupAccountName(lpSystemName, lpAccountName: PChar;
  Sid: PSID; var cbSid: DWORD; ReferencedDomainName: PChar;
  var cbReferencedDomainName: DWORD; var peUse: SID_NAME_USE): BOOL; stdcall;
{$EXTERNALSYM LookupAccountName}
function LookupAccountNameA(lpSystemName, lpAccountName: PAnsiChar;
  Sid: PSID; var cbSid: DWORD; ReferencedDomainName: PAnsiChar;
  var cbReferencedDomainName: DWORD; var peUse: SID_NAME_USE): BOOL; stdcall;
{$EXTERNALSYM LookupAccountNameA}
function LookupAccountNameW(lpSystemName, lpAccountName: PWideChar;
  Sid: PSID; var cbSid: DWORD; ReferencedDomainName: PWideChar;
  var cbReferencedDomainName: DWORD; var peUse: SID_NAME_USE): BOOL; stdcall;
{$EXTERNALSYM LookupAccountNameW}
function LookupPrivilegeValue(lpSystemName, lpName: PChar;
  var lpLuid: TLargeInteger): BOOL; stdcall;
{$EXTERNALSYM LookupPrivilegeValue}
function LookupPrivilegeValueA(lpSystemName, lpName: PAnsiChar;
  var lpLuid: TLargeInteger): BOOL; stdcall;
{$EXTERNALSYM LookupPrivilegeValueA}
function LookupPrivilegeValueW(lpSystemName, lpName: PWideChar;
  var lpLuid: TLargeInteger): BOOL; stdcall;
{$EXTERNALSYM LookupPrivilegeValueW}
function LookupPrivilegeName(lpSystemName: PChar;
  var lpLuid: TLargeInteger; lpName: PChar; var cbName: DWORD): BOOL; stdcall;
{$EXTERNALSYM LookupPrivilegeName}
function LookupPrivilegeNameA(lpSystemName: PAnsiChar;
  var lpLuid: TLargeInteger; lpName: PAnsiChar; var cbName: DWORD): BOOL; stdcall;
{$EXTERNALSYM LookupPrivilegeNameA}
function LookupPrivilegeNameW(lpSystemName: PWideChar;
  var lpLuid: TLargeInteger; lpName: PWideChar; var cbName: DWORD): BOOL; stdcall;
{$EXTERNALSYM LookupPrivilegeNameW}
function LookupPrivilegeDisplayName(lpSystemName, lpName: PAnsiChar;
  lpDisplayName: PChar; var cbDisplayName, lpLanguageId: DWORD): BOOL; stdcall;
{$EXTERNALSYM LookupPrivilegeDisplayName}
function LookupPrivilegeDisplayNameA(lpSystemName, lpName: PAnsiChar;
  lpDisplayName: PAnsiChar; var cbDisplayName, lpLanguageId: DWORD): BOOL; stdcall;
{$EXTERNALSYM LookupPrivilegeDisplayNameA}
function LookupPrivilegeDisplayNameW(lpSystemName, lpName: PAnsiChar;
  lpDisplayName: PWideChar; var cbDisplayName, lpLanguageId: DWORD): BOOL; stdcall;
{$EXTERNALSYM LookupPrivilegeDisplayNameW}
function AllocateLocallyUniqueId(var Luid: TLargeInteger): BOOL; stdcall;
{$EXTERNALSYM AllocateLocallyUniqueId}
function BuildCommDCB(lpDef: PChar; var lpDCB: TDCB): BOOL; stdcall;
{$EXTERNALSYM BuildCommDCB}
{$EXTERNALSYM AllocateLocallyUniqueId}
function BuildCommDCBA(lpDef: PAnsiChar; var lpDCB: TDCB): BOOL; stdcall;
{$EXTERNALSYM BuildCommDCBA}
{$EXTERNALSYM AllocateLocallyUniqueId}
function BuildCommDCBW(lpDef: PWideChar; var lpDCB: TDCB): BOOL; stdcall;
{$EXTERNALSYM BuildCommDCBW}
function BuildCommDCBAndTimeouts(lpDef: PChar; var lpDCB: TDCB;
  var lpCommTimeouts: TCommTimeouts): BOOL; stdcall;
{$EXTERNALSYM BuildCommDCBAndTimeouts}
function BuildCommDCBAndTimeoutsA(lpDef: PAnsiChar; var lpDCB: TDCB;
  var lpCommTimeouts: TCommTimeouts): BOOL; stdcall;
{$EXTERNALSYM BuildCommDCBAndTimeoutsA}
function BuildCommDCBAndTimeoutsW(lpDef: PWideChar; var lpDCB: TDCB;
  var lpCommTimeouts: TCommTimeouts): BOOL; stdcall;
{$EXTERNALSYM BuildCommDCBAndTimeoutsW}
function CommConfigDialog(lpszName: PChar; hWnd: HWND; var lpCC: TCommConfig): BOOL; stdcall;
{$EXTERNALSYM CommConfigDialog}
function CommConfigDialogA(lpszName: PAnsiChar; hWnd: HWND; var lpCC: TCommConfig): BOOL; stdcall;
{$EXTERNALSYM CommConfigDialogA}
function CommConfigDialogW(lpszName: PWideChar; hWnd: HWND; var lpCC: TCommConfig): BOOL; stdcall;
{$EXTERNALSYM CommConfigDialogW}
function GetDefaultCommConfig(lpszName: PChar;
  var lpCC: TCommConfig; var lpdwSize: DWORD): BOOL; stdcall;
{$EXTERNALSYM GetDefaultCommConfig}
function GetDefaultCommConfigA(lpszName: PAnsiChar;
  var lpCC: TCommConfig; var lpdwSize: DWORD): BOOL; stdcall;
{$EXTERNALSYM GetDefaultCommConfigA}
function GetDefaultCommConfigW(lpszName: PWideChar;
  var lpCC: TCommConfig; var lpdwSize: DWORD): BOOL; stdcall;
{$EXTERNALSYM GetDefaultCommConfigW}
function SetDefaultCommConfig(lpszName: PChar; lpCC: PCommConfig; dwSize: DWORD): BOOL; stdcall;
{$EXTERNALSYM SetDefaultCommConfig}
function SetDefaultCommConfigA(lpszName: PAnsiChar; lpCC: PCommConfig; dwSize: DWORD): BOOL; stdcall;
{$EXTERNALSYM SetDefaultCommConfigA}
function SetDefaultCommConfigW(lpszName: PWideChar; lpCC: PCommConfig; dwSize: DWORD): BOOL; stdcall;
{$EXTERNALSYM SetDefaultCommConfigW}

const
  MAX_COMPUTERNAME_LENGTH = 15;
  {$EXTERNALSYM MAX_COMPUTERNAME_LENGTH}

function GetComputerName(lpBuffer: PChar; var nSize: DWORD): BOOL; stdcall;
{$EXTERNALSYM GetComputerName}
function GetComputerNameA(lpBuffer: PAnsiChar; var nSize: DWORD): BOOL; stdcall;
{$EXTERNALSYM GetComputerNameA}
function GetComputerNameW(lpBuffer: PWideChar; var nSize: DWORD): BOOL; stdcall;
{$EXTERNALSYM GetComputerNameW}
function SetComputerName(lpComputerName: PChar): BOOL; stdcall;
{$EXTERNALSYM SetComputerName}
function SetComputerNameA(lpComputerName: PAnsiChar): BOOL; stdcall;
{$EXTERNALSYM SetComputerNameA}
function SetComputerNameW(lpComputerName: PWideChar): BOOL; stdcall;
{$EXTERNALSYM SetComputerNameW}
function GetUserName(lpBuffer: PChar; var nSize: DWORD): BOOL; stdcall;
{$EXTERNALSYM GetUserName}
function GetUserNameA(lpBuffer: PAnsiChar; var nSize: DWORD): BOOL; stdcall;
{$EXTERNALSYM GetUserNameA}
function GetUserNameW(lpBuffer: PWideChar; var nSize: DWORD): BOOL; stdcall;
{$EXTERNALSYM GetUserNameW}

{ Logon Support APIs }

const
  LOGON32_LOGON_INTERACTIVE = 2;
  {$EXTERNALSYM LOGON32_LOGON_INTERACTIVE}
  LOGON32_LOGON_NETWORK = 3;
  {$EXTERNALSYM LOGON32_LOGON_NETWORK}
  LOGON32_LOGON_BATCH = 4;
  {$EXTERNALSYM LOGON32_LOGON_BATCH}
  LOGON32_LOGON_SERVICE = 5;
  {$EXTERNALSYM LOGON32_LOGON_SERVICE}

  LOGON32_PROVIDER_DEFAULT = 0;
  {$EXTERNALSYM LOGON32_PROVIDER_DEFAULT}
  LOGON32_PROVIDER_WINNT35 = 1;
  {$EXTERNALSYM LOGON32_PROVIDER_WINNT35}
  LOGON32_PROVIDER_WINNT40 = 2;
  {$EXTERNALSYM LOGON32_PROVIDER_WINNT40}
  LOGON32_PROVIDER_WINNT50 = 3;
  {$EXTERNALSYM LOGON32_PROVIDER_WINNT50}

function LogonUser(lpszUsername, lpszDomain, lpszPassword: PChar;
  dwLogonType, dwLogonProvider: DWORD; var phToken: THandle): BOOL; stdcall;
{$EXTERNALSYM LogonUser}
function LogonUserA(lpszUsername, lpszDomain, lpszPassword: PAnsiChar;
  dwLogonType, dwLogonProvider: DWORD; var phToken: THandle): BOOL; stdcall;
{$EXTERNALSYM LogonUserA}
function LogonUserW(lpszUsername, lpszDomain, lpszPassword: PWideChar;
  dwLogonType, dwLogonProvider: DWORD; var phToken: THandle): BOOL; stdcall;
{$EXTERNALSYM LogonUserW}
function ImpersonateLoggedOnUser(hToken: THandle): BOOL; stdcall;
{$EXTERNALSYM ImpersonateLoggedOnUser}
function CreateProcessAsUser(hToken: THandle; lpApplicationName: PChar;
  lpCommandLine: PChar; lpProcessAttributes: PSecurityAttributes;
  lpThreadAttributes: PSecurityAttributes; bInheritHandles: BOOL;
  dwCreationFlags: DWORD; lpEnvironment: Pointer; lpCurrentDirectory: PChar;
  const lpStartupInfo: TStartupInfo; var lpProcessInformation: TProcessInformation): BOOL; stdcall;
{$EXTERNALSYM CreateProcessAsUser}
function CreateProcessAsUserA(hToken: THandle; lpApplicationName: PAnsiChar;
  lpCommandLine: PAnsiChar; lpProcessAttributes: PSecurityAttributes;
  lpThreadAttributes: PSecurityAttributes; bInheritHandles: BOOL;
  dwCreationFlags: DWORD; lpEnvironment: Pointer; lpCurrentDirectory: PAnsiChar;
  const lpStartupInfo: TStartupInfo; var lpProcessInformation: TProcessInformation): BOOL; stdcall;
{$EXTERNALSYM CreateProcessAsUserA}
function CreateProcessAsUserW(hToken: THandle; lpApplicationName: PWideChar;
  lpCommandLine: PWideChar; lpProcessAttributes: PSecurityAttributes;
  lpThreadAttributes: PSecurityAttributes; bInheritHandles: BOOL;
  dwCreationFlags: DWORD; lpEnvironment: Pointer; lpCurrentDirectory: PWideChar;
  const lpStartupInfo: TStartupInfo; var lpProcessInformation: TProcessInformation): BOOL; stdcall;
{$EXTERNALSYM CreateProcessAsUserW}

function DuplicateTokenEx(hExistingToken: THandle; dwDesiredAccess: DWORD;
  lpTokenAttributes: PSecurityAttributes;
  ImpersonationLevel: TSecurityImpersonationLevel; TokenType: TTokenType;
  var phNewToken: THandle): BOOL; stdcall;
{$EXTERNALSYM DuplicateTokenEx}

{ Plug-and-Play API's }
const
  HW_PROFILE_GUIDLEN = 39;                 { 36-characters plus NULL terminator }
  {$EXTERNALSYM HW_PROFILE_GUIDLEN}
  MAX_PROFILE_LEN = 80;
  {$EXTERNALSYM MAX_PROFILE_LEN}

  DOCKINFO_UNDOCKED = $1;
  {$EXTERNALSYM DOCKINFO_UNDOCKED}
  DOCKINFO_DOCKED = $2;
  {$EXTERNALSYM DOCKINFO_DOCKED}
  DOCKINFO_USER_SUPPLIED = $4;
  {$EXTERNALSYM DOCKINFO_USER_SUPPLIED}
  DOCKINFO_USER_UNDOCKED = DOCKINFO_USER_SUPPLIED or DOCKINFO_UNDOCKED;
  {$EXTERNALSYM DOCKINFO_USER_UNDOCKED}
  DOCKINFO_USER_DOCKED = DOCKINFO_USER_SUPPLIED or DOCKINFO_DOCKED;
  {$EXTERNALSYM DOCKINFO_USER_DOCKED}

type
  PHWProfileInfoA = ^THWProfileInfoA;
  PHWProfileInfoW = ^THWProfileInfoW;
  PHWProfileInfo = PHWProfileInfoA;
  tagHW_PROFILE_INFOA = packed record
    dwDockInfo: DWORD;
    szHwProfileGuid: packed array[0..HW_PROFILE_GUIDLEN-1] of AnsiChar;
    szHwProfileName: packed array[0..MAX_PROFILE_LEN-1] of AnsiChar;
  end;
  {$EXTERNALSYM tagHW_PROFILE_INFOA}
  tagHW_PROFILE_INFOW = packed record
    dwDockInfo: DWORD;
    szHwProfileGuid: packed array[0..HW_PROFILE_GUIDLEN-1] of WideChar;
    szHwProfileName: packed array[0..MAX_PROFILE_LEN-1] of WideChar;
  end;
  {$EXTERNALSYM tagHW_PROFILE_INFOW}
  tagHW_PROFILE_INFO = tagHW_PROFILE_INFOA;
  THWProfileInfoA = tagHW_PROFILE_INFOA;
  THWProfileInfoW = tagHW_PROFILE_INFOW;
  THWProfileInfo = THWProfileInfoA;
  HW_PROFILE_INFOA = tagHW_PROFILE_INFOA;
  {$EXTERNALSYM HW_PROFILE_INFOA}
  HW_PROFILE_INFOW = tagHW_PROFILE_INFOW;
  {$EXTERNALSYM HW_PROFILE_INFOW}
  HW_PROFILE_INFO = HW_PROFILE_INFOA;

function GetCurrentHwProfile(var lpHwProfileInfo: THWProfileInfo): BOOL; stdcall;
{$EXTERNALSYM GetCurrentHwProfile}
function GetCurrentHwProfileA(var lpHwProfileInfo: THWProfileInfoA): BOOL; stdcall;
{$EXTERNALSYM GetCurrentHwProfileA}
function GetCurrentHwProfileW(var lpHwProfileInfo: THWProfileInfoW): BOOL; stdcall;
{$EXTERNALSYM GetCurrentHwProfileW}

{ Performance counter API's }

function QueryPerformanceCounter(var lpPerformanceCount: TLargeInteger): BOOL; stdcall;
{$EXTERNALSYM QueryPerformanceCounter}
function QueryPerformanceFrequency(var lpFrequency: TLargeInteger): BOOL; stdcall;
{$EXTERNALSYM QueryPerformanceFrequency}

type
  POSVersionInfoA = ^TOSVersionInfoA;
  POSVersionInfoW = ^TOSVersionInfoW;
  POSVersionInfo = POSVersionInfoA;
  _OSVERSIONINFOA = record
    dwOSVersionInfoSize: DWORD;
    dwMajorVersion: DWORD;
    dwMinorVersion: DWORD;
    dwBuildNumber: DWORD;
    dwPlatformId: DWORD;
    szCSDVersion: array[0..127] of AnsiChar; { Maintenance string for PSS usage }
  end;
  {$EXTERNALSYM _OSVERSIONINFOA}
  _OSVERSIONINFOW = record
    dwOSVersionInfoSize: DWORD;
    dwMajorVersion: DWORD;
    dwMinorVersion: DWORD;
    dwBuildNumber: DWORD;
    dwPlatformId: DWORD;
    szCSDVersion: array[0..127] of WideChar; { Maintenance string for PSS usage }
  end;
  {$EXTERNALSYM _OSVERSIONINFOW}
  _OSVERSIONINFO = _OSVERSIONINFOA;
  TOSVersionInfoA = _OSVERSIONINFOA;
  TOSVersionInfoW = _OSVERSIONINFOW;
  TOSVersionInfo = TOSVersionInfoA;
  OSVERSIONINFOA = _OSVERSIONINFOA;
  {$EXTERNALSYM OSVERSIONINFOA}
  {$EXTERNALSYM OSVERSIONINFO}
  OSVERSIONINFOW = _OSVERSIONINFOW;
  {$EXTERNALSYM OSVERSIONINFOW}
  {$EXTERNALSYM OSVERSIONINFO}
  OSVERSIONINFO = OSVERSIONINFOA;

{ dwPlatformId defines }
const
  VER_PLATFORM_WIN32s = 0;
  {$EXTERNALSYM VER_PLATFORM_WIN32s}
  VER_PLATFORM_WIN32_WINDOWS = 1;
  {$EXTERNALSYM VER_PLATFORM_WIN32_WINDOWS}
  VER_PLATFORM_WIN32_NT = 2;
  {$EXTERNALSYM VER_PLATFORM_WIN32_NT}
  VER_PLATFORM_WIN32_CE = 3;
  {$EXTERNALSYM VER_PLATFORM_WIN32_CE}

function GetVersionEx(var lpVersionInformation: TOSVersionInfo): BOOL; stdcall;
{$EXTERNALSYM GetVersionEx}
function GetVersionExA(var lpVersionInformation: TOSVersionInfo): BOOL; stdcall;
{$EXTERNALSYM GetVersionExA}
function GetVersionExW(var lpVersionInformation: TOSVersionInfo): BOOL; stdcall;
{$EXTERNALSYM GetVersionExW}

{ DOS and OS/2 Compatible Error Code definitions returned by the Win32 Base
  API functions. }


{ Translated from WINERROR.H }
{ Error code definitions for the Win32 API functions }

(*
  Values are 32 bit values layed out as follows:
   3 3 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1
   1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0
  +---+-+-+-----------------------+-------------------------------+
  |Sev|C|R|     Facility          |               Code            |
  +---+-+-+-----------------------+-------------------------------+

  where
      Sev - is the severity code
          00 - Success
          01 - Informational
          10 - Warning
          11 - Error

      C - is the Customer code flag
      R - is a reserved bit
      Facility - is the facility code
      Code - is the facility's status code
*)

{ Define the facility codes }

const
  FACILITY_WINDOWS                     = 8;
  {$EXTERNALSYM FACILITY_WINDOWS}
  FACILITY_STORAGE                     = 3;
  {$EXTERNALSYM FACILITY_STORAGE}
  FACILITY_RPC                         = 1;
  {$EXTERNALSYM FACILITY_RPC}
  FACILITY_SSPI                        = 9;
  {$EXTERNALSYM FACILITY_SSPI}
  FACILITY_WIN32                       = 7;
  {$EXTERNALSYM FACILITY_WIN32}
  FACILITY_CONTROL                     = 10;
  {$EXTERNALSYM FACILITY_CONTROL}
  FACILITY_NULL                        = 0;
  {$EXTERNALSYM FACILITY_NULL}
  FACILITY_INTERNET                    = 12;
  {$EXTERNALSYM FACILITY_INTERNET}
  FACILITY_ITF                         = 4;
  {$EXTERNALSYM FACILITY_ITF}
  FACILITY_DISPATCH                    = 2;
  {$EXTERNALSYM FACILITY_DISPATCH}
  FACILITY_CERT                        = 11;
  {$EXTERNALSYM FACILITY_CERT}


{ Define the severity codes }

  { The operation completed successfully. }
  ERROR_SUCCESS = 0;
  {$EXTERNALSYM ERROR_SUCCESS}
  NO_ERROR = 0;   { dderror }
  {$EXTERNALSYM NO_ERROR}

  { Incorrect function. }
  ERROR_INVALID_FUNCTION = 1;   { dderror }
  {$EXTERNALSYM ERROR_INVALID_FUNCTION}

  { The system cannot find the file specified. }
  ERROR_FILE_NOT_FOUND = 2;
  {$EXTERNALSYM ERROR_FILE_NOT_FOUND}

  { The system cannot find the path specified. }
  ERROR_PATH_NOT_FOUND = 3;
  {$EXTERNALSYM ERROR_PATH_NOT_FOUND}

  { The system cannot open the file. }
  ERROR_TOO_MANY_OPEN_FILES = 4;
  {$EXTERNALSYM ERROR_TOO_MANY_OPEN_FILES}

  { Access is denied. }
  ERROR_ACCESS_DENIED = 5;
  {$EXTERNALSYM ERROR_ACCESS_DENIED}

  { The handle is invalid. }
  ERROR_INVALID_HANDLE = 6;
  {$EXTERNALSYM ERROR_INVALID_HANDLE}

  { The storage control blocks were destroyed. }
  ERROR_ARENA_TRASHED = 7;
  {$EXTERNALSYM ERROR_ARENA_TRASHED}

  { Not enough storage is available to process this command. }
  ERROR_NOT_ENOUGH_MEMORY = 8;   { dderror }
  {$EXTERNALSYM ERROR_NOT_ENOUGH_MEMORY}

  { The storage control block address is invalid. }
  ERROR_INVALID_BLOCK = 9;
  {$EXTERNALSYM ERROR_INVALID_BLOCK}

  { The environment is incorrect. }
  ERROR_BAD_ENVIRONMENT = 10;
  {$EXTERNALSYM ERROR_BAD_ENVIRONMENT}

  { An attempt was made to load a program with an incorrect format. }
  ERROR_BAD_FORMAT = 11;
  {$EXTERNALSYM ERROR_BAD_FORMAT}

  { The access code is invalid. }
  ERROR_INVALID_ACCESS = 12;
  {$EXTERNALSYM ERROR_INVALID_ACCESS}

  { The data is invalid. }
  ERROR_INVALID_DATA = 13;
  {$EXTERNALSYM ERROR_INVALID_DATA}

  { Not enough storage is available to complete this operation. }
  ERROR_OUTOFMEMORY = 14;
  {$EXTERNALSYM ERROR_OUTOFMEMORY}

  { The system cannot find the drive specified. }
  ERROR_INVALID_DRIVE = 15;
  {$EXTERNALSYM ERROR_INVALID_DRIVE}

  { The directory cannot be removed. }
  ERROR_CURRENT_DIRECTORY = $10;
  {$EXTERNALSYM ERROR_CURRENT_DIRECTORY}

  { The system cannot move the file }
  { to a different disk drive. }
  ERROR_NOT_SAME_DEVICE = 17;
  {$EXTERNALSYM ERROR_NOT_SAME_DEVICE}

  { There are no more files. }
  ERROR_NO_MORE_FILES = 18;
  {$EXTERNALSYM ERROR_NO_MORE_FILES}

  { The media is write protected. }
  ERROR_WRITE_PROTECT = 19;
  {$EXTERNALSYM ERROR_WRITE_PROTECT}

  { The system cannot find the device specified. }
  ERROR_BAD_UNIT = 20;
  {$EXTERNALSYM ERROR_BAD_UNIT}

  { The device is not ready. }
  ERROR_NOT_READY = 21;
  {$EXTERNALSYM ERROR_NOT_READY}

  { The device does not recognize the command. }
  ERROR_BAD_COMMAND = 22;
  {$EXTERNALSYM ERROR_BAD_COMMAND}

  { Data error (cyclic redundancy check) }
  ERROR_CRC = 23;
  {$EXTERNALSYM ERROR_CRC}

  { The program issued a command but the command length is incorrect. }
  ERROR_BAD_LENGTH = 24;
  {$EXTERNALSYM ERROR_BAD_LENGTH}

  { The drive cannot locate a specific area or track on the disk. }
  ERROR_SEEK = 25;
  {$EXTERNALSYM ERROR_SEEK}

  { The specified disk or diskette cannot be accessed. }
  ERROR_NOT_DOS_DISK = 26;
  {$EXTERNALSYM ERROR_NOT_DOS_DISK}

  { The drive cannot find the sector requested. }
  ERROR_SECTOR_NOT_FOUND = 27;
  {$EXTERNALSYM ERROR_SECTOR_NOT_FOUND}

  { The printer is out of paper. }
  ERROR_OUT_OF_PAPER = 28;
  {$EXTERNALSYM ERROR_OUT_OF_PAPER}

  { The system cannot write to the specified device. }
  ERROR_WRITE_FAULT = 29;
  {$EXTERNALSYM ERROR_WRITE_FAULT}

  { The system cannot read from the specified device. }
  ERROR_READ_FAULT = 30;
  {$EXTERNALSYM ERROR_READ_FAULT}

  { A device attached to the system is not functioning. }
  ERROR_GEN_FAILURE = 31;
  {$EXTERNALSYM ERROR_GEN_FAILURE}

  { The process cannot access the file because it is being used by another process. }
  ERROR_SHARING_VIOLATION = $20;
  {$EXTERNALSYM ERROR_SHARING_VIOLATION}

  { The process cannot access the file because }
  { another process has locked a portion of the file. }
  ERROR_LOCK_VIOLATION = 33;
  {$EXTERNALSYM ERROR_LOCK_VIOLATION}

  { The wrong diskette is in the drive. Insert %2 (Volume Serial Number: %3) }
  { into drive %1. }
  ERROR_WRONG_DISK = 34;
  {$EXTERNALSYM ERROR_WRONG_DISK}

  { Too many files opened for sharing. }
  ERROR_SHARING_BUFFER_EXCEEDED = 36;
  {$EXTERNALSYM ERROR_SHARING_BUFFER_EXCEEDED}

  { Reached end of file. }
  ERROR_HANDLE_EOF = 38;
  {$EXTERNALSYM ERROR_HANDLE_EOF}

  { The disk is full. }
  ERROR_HANDLE_DISK_FULL = 39;
  {$EXTERNALSYM ERROR_HANDLE_DISK_FULL}

  { The network request is not supported. }
  ERROR_NOT_SUPPORTED = 50;
  {$EXTERNALSYM ERROR_NOT_SUPPORTED}

  { The remote computer is not available. }
  ERROR_REM_NOT_LIST = 51;
  {$EXTERNALSYM ERROR_REM_NOT_LIST}

  { A duplicate name exists on the network. }
  ERROR_DUP_NAME = 52;
  {$EXTERNALSYM ERROR_DUP_NAME}

  { The network path was not found. }
  ERROR_BAD_NETPATH = 53;
  {$EXTERNALSYM ERROR_BAD_NETPATH}

  { The network is busy. }
  ERROR_NETWORK_BUSY = 54;
  {$EXTERNALSYM ERROR_NETWORK_BUSY}

  { The specified network resource or device is no longer }
  { available. }
  ERROR_DEV_NOT_EXIST = 55;   { dderror }
  {$EXTERNALSYM ERROR_DEV_NOT_EXIST}

  { The network BIOS command limit has been reached. }
  ERROR_TOO_MANY_CMDS = 56;
  {$EXTERNALSYM ERROR_TOO_MANY_CMDS}

  { A network adapter hardware error occurred. }
  ERROR_ADAP_HDW_ERR = 57;
  {$EXTERNALSYM ERROR_ADAP_HDW_ERR}

  { The specified server cannot perform the requested }
  { operation. }
  ERROR_BAD_NET_RESP = 58;
  {$EXTERNALSYM ERROR_BAD_NET_RESP}

  { An unexpected network error occurred. }
  ERROR_UNEXP_NET_ERR = 59;
  {$EXTERNALSYM ERROR_UNEXP_NET_ERR}

  { The remote adapter is not compatible. }
  ERROR_BAD_REM_ADAP = 60;
  {$EXTERNALSYM ERROR_BAD_REM_ADAP}

  { The printer queue is full. }
  ERROR_PRINTQ_FULL = 61;
  {$EXTERNALSYM ERROR_PRINTQ_FULL}

  { Space to store the file waiting to be printed is }
  { not available on the server. }
  ERROR_NO_SPOOL_SPACE = 62;
  {$EXTERNALSYM ERROR_NO_SPOOL_SPACE}

  { Your file waiting to be printed was deleted. }
  ERROR_PRINT_CANCELLED = 63;
  {$EXTERNALSYM ERROR_PRINT_CANCELLED}

  { The specified network name is no longer available. }
  ERROR_NETNAME_DELETED = $40;
  {$EXTERNALSYM ERROR_NETNAME_DELETED}

  { Network access is denied. }
  ERROR_NETWORK_ACCESS_DENIED = 65;
  {$EXTERNALSYM ERROR_NETWORK_ACCESS_DENIED}

  { The network resource type is not correct. }
  ERROR_BAD_DEV_TYPE = 66;
  {$EXTERNALSYM ERROR_BAD_DEV_TYPE}

  { The network name cannot be found. }
  ERROR_BAD_NET_NAME = 67;
  {$EXTERNALSYM ERROR_BAD_NET_NAME}

  { The name limit for the local computer network }
  { adapter card was exceeded. }
  ERROR_TOO_MANY_NAMES = 68;
  {$EXTERNALSYM ERROR_TOO_MANY_NAMES}

  { The network BIOS session limit was exceeded. }
  ERROR_TOO_MANY_SESS = 69;
  {$EXTERNALSYM ERROR_TOO_MANY_SESS}

  { The remote server has been paused or is in the }
  { process of being started. }
  ERROR_SHARING_PAUSED = 70;
  {$EXTERNALSYM ERROR_SHARING_PAUSED}

  { No more connections can be made to this remote computer at this time }
  { because there are already as many connections as the computer can accept. }
  ERROR_REQ_NOT_ACCEP = 71;
  {$EXTERNALSYM ERROR_REQ_NOT_ACCEP}

  { The specified printer or disk device has been paused. }
  ERROR_REDIR_PAUSED = 72;
  {$EXTERNALSYM ERROR_REDIR_PAUSED}

  { The file exists. }
  ERROR_FILE_EXISTS = 80;
  {$EXTERNALSYM ERROR_FILE_EXISTS}

  { The directory or file cannot be created. }
  ERROR_CANNOT_MAKE = 82;
  {$EXTERNALSYM ERROR_CANNOT_MAKE}

  { Fail on INT 24 }
  ERROR_FAIL_I24 = 83;
  {$EXTERNALSYM ERROR_FAIL_I24}

  { Storage to process this request is not available. }
  ERROR_OUT_OF_STRUCTURES = 84;
  {$EXTERNALSYM ERROR_OUT_OF_STRUCTURES}

  { The local device name is already in use. }
  ERROR_ALREADY_ASSIGNED = 85;
  {$EXTERNALSYM ERROR_ALREADY_ASSIGNED}

  { The specified network password is not correct. }
  ERROR_INVALID_PASSWORD = 86;
  {$EXTERNALSYM ERROR_INVALID_PASSWORD}

  { The parameter is incorrect. }
  ERROR_INVALID_PARAMETER = 87;   { dderror }
  {$EXTERNALSYM ERROR_INVALID_PARAMETER}

  { A write fault occurred on the network. }
  ERROR_NET_WRITE_FAULT = 88;
  {$EXTERNALSYM ERROR_NET_WRITE_FAULT}

  { The system cannot start another process at }
  { this time. }
  ERROR_NO_PROC_SLOTS = 89;
  {$EXTERNALSYM ERROR_NO_PROC_SLOTS}

  { Cannot create another system semaphore. }
  ERROR_TOO_MANY_SEMAPHORES = 100;
  {$EXTERNALSYM ERROR_TOO_MANY_SEMAPHORES}

  { The exclusive semaphore is owned by another process. }
  ERROR_EXCL_SEM_ALREADY_OWNED = 101;
  {$EXTERNALSYM ERROR_EXCL_SEM_ALREADY_OWNED}

  { The semaphore is set and cannot be closed. }
  ERROR_SEM_IS_SET = 102;
  {$EXTERNALSYM ERROR_SEM_IS_SET}

  { The semaphore cannot be set again. }
  ERROR_TOO_MANY_SEM_REQUESTS = 103;
  {$EXTERNALSYM ERROR_TOO_MANY_SEM_REQUESTS}

  { Cannot request exclusive semaphores at interrupt time. }
  ERROR_INVALID_AT_INTERRUPT_TIME = 104;
  {$EXTERNALSYM ERROR_INVALID_AT_INTERRUPT_TIME}

  { The previous ownership of this semaphore has ended. }
  ERROR_SEM_OWNER_DIED = 105;
  {$EXTERNALSYM ERROR_SEM_OWNER_DIED}

  { Insert the diskette for drive %1. }
  ERROR_SEM_USER_LIMIT = 106;
  {$EXTERNALSYM ERROR_SEM_USER_LIMIT}

  { Program stopped because alternate diskette was not inserted. }
  ERROR_DISK_CHANGE = 107;
  {$EXTERNALSYM ERROR_DISK_CHANGE}

  { The disk is in use or locked by }
  { another process. }
  ERROR_DRIVE_LOCKED = 108;
  {$EXTERNALSYM ERROR_DRIVE_LOCKED}

  { The pipe has been ended. }
  ERROR_BROKEN_PIPE = 109;
  {$EXTERNALSYM ERROR_BROKEN_PIPE}

  { The system cannot open the device or file specified. }
  ERROR_OPEN_FAILED = 110;
  {$EXTERNALSYM ERROR_OPEN_FAILED}

  { The file name is too long. }
  ERROR_BUFFER_OVERFLOW = 111;
  {$EXTERNALSYM ERROR_BUFFER_OVERFLOW}

  { There is not enough space on the disk. }
  ERROR_DISK_FULL = 112;
  {$EXTERNALSYM ERROR_DISK_FULL}

  { No more internal file identifiers available. }
  ERROR_NO_MORE_SEARCH_HANDLES = 113;
  {$EXTERNALSYM ERROR_NO_MORE_SEARCH_HANDLES}

  { The target internal file identifier is incorrect. }
  ERROR_INVALID_TARGET_HANDLE = 114;
  {$EXTERNALSYM ERROR_INVALID_TARGET_HANDLE}

  { The IOCTL call made by the application program is not correct. }
  ERROR_INVALID_CATEGORY = 117;
  {$EXTERNALSYM ERROR_INVALID_CATEGORY}

  { The verify-on-write switch parameter value is not correct. }
  ERROR_INVALID_VERIFY_SWITCH = 118;
  {$EXTERNALSYM ERROR_INVALID_VERIFY_SWITCH}

  { The system does not support the command requested. }
  ERROR_BAD_DRIVER_LEVEL = 119;
  {$EXTERNALSYM ERROR_BAD_DRIVER_LEVEL}

  { This function is only valid in Windows NT mode. }
  ERROR_CALL_NOT_IMPLEMENTED = 120;
  {$EXTERNALSYM ERROR_CALL_NOT_IMPLEMENTED}

  { The semaphore timeout period has expired. }
  ERROR_SEM_TIMEOUT = 121;
  {$EXTERNALSYM ERROR_SEM_TIMEOUT}

  { The data area passed to a system call is too small. }
  ERROR_INSUFFICIENT_BUFFER = 122;   { dderror }
  {$EXTERNALSYM ERROR_INSUFFICIENT_BUFFER}

  { The filename, directory name, or volume label syntax is incorrect. }
  ERROR_INVALID_NAME = 123;
  {$EXTERNALSYM ERROR_INVALID_NAME}

  { The system call level is not correct. }
  ERROR_INVALID_LEVEL = 124;
  {$EXTERNALSYM ERROR_INVALID_LEVEL}

  { The disk has no volume label. }
  ERROR_NO_VOLUME_LABEL = 125;
  {$EXTERNALSYM ERROR_NO_VOLUME_LABEL}

  { The specified module could not be found. }
  ERROR_MOD_NOT_FOUND = 126;
  {$EXTERNALSYM ERROR_MOD_NOT_FOUND}

  { The specified procedure could not be found. }
  ERROR_PROC_NOT_FOUND = 127;
  {$EXTERNALSYM ERROR_PROC_NOT_FOUND}

  { There are no child processes to wait for. }
  ERROR_WAIT_NO_CHILDREN = $80;
  {$EXTERNALSYM ERROR_WAIT_NO_CHILDREN}

  { The %1 application cannot be run in Windows NT mode. }
  ERROR_CHILD_NOT_COMPLETE = 129;
  {$EXTERNALSYM ERROR_CHILD_NOT_COMPLETE}

  { Attempt to use a file handle to an open disk partition for an }
  { operation other than raw disk I/O. }
  ERROR_DIRECT_ACCESS_HANDLE = 130;
  {$EXTERNALSYM ERROR_DIRECT_ACCESS_HANDLE}

  { An attempt was made to move the file pointer before the beginning of the file. }
  ERROR_NEGATIVE_SEEK = 131;
  {$EXTERNALSYM ERROR_NEGATIVE_SEEK}

  { The file pointer cannot be set on the specified device or file. }
  ERROR_SEEK_ON_DEVICE = 132;
  {$EXTERNALSYM ERROR_SEEK_ON_DEVICE}

  { A JOIN or SUBST command }
  { cannot be used for a drive that }
  { contains previously joined drives. }
  ERROR_IS_JOIN_TARGET = 133;
  {$EXTERNALSYM ERROR_IS_JOIN_TARGET}

  { An attempt was made to use a }
  { JOIN or SUBST command on a drive that has }
  { already been joined. }
  ERROR_IS_JOINED = 134;
  {$EXTERNALSYM ERROR_IS_JOINED}

  { An attempt was made to use a }
  { JOIN or SUBST command on a drive that has }
  { already been substituted. }
  ERROR_IS_SUBSTED = 135;
  {$EXTERNALSYM ERROR_IS_SUBSTED}

  { The system tried to delete }
  { the JOIN of a drive that is not joined. }
  ERROR_NOT_JOINED = 136;
  {$EXTERNALSYM ERROR_NOT_JOINED}

  { The system tried to delete the }
  { substitution of a drive that is not substituted. }
  ERROR_NOT_SUBSTED = 137;
  {$EXTERNALSYM ERROR_NOT_SUBSTED}

  { The system tried to join a drive to a directory on a joined drive. }
  ERROR_JOIN_TO_JOIN = 138;
  {$EXTERNALSYM ERROR_JOIN_TO_JOIN}

  { The system tried to substitute a drive to a directory on a substituted drive. }
  ERROR_SUBST_TO_SUBST = 139;
  {$EXTERNALSYM ERROR_SUBST_TO_SUBST}

  { The system tried to join a drive to a directory on a substituted drive. }
  ERROR_JOIN_TO_SUBST = 140;
  {$EXTERNALSYM ERROR_JOIN_TO_SUBST}

  { The system tried to SUBST a drive to a directory on a joined drive. }
  ERROR_SUBST_TO_JOIN = 141;
  {$EXTERNALSYM ERROR_SUBST_TO_JOIN}

  { The system cannot perform a JOIN or SUBST at this time. }
  ERROR_BUSY_DRIVE = 142;
  {$EXTERNALSYM ERROR_BUSY_DRIVE}

  { The system cannot join or substitute a }
  { drive to or for a directory on the same drive. }
  ERROR_SAME_DRIVE = 143;
  {$EXTERNALSYM ERROR_SAME_DRIVE}

  { The directory is not a subdirectory of the root directory. }
  ERROR_DIR_NOT_ROOT = 144;
  {$EXTERNALSYM ERROR_DIR_NOT_ROOT}

  { The directory is not empty. }
  ERROR_DIR_NOT_EMPTY = 145;
  {$EXTERNALSYM ERROR_DIR_NOT_EMPTY}

  { The path specified is being used in a substitute. }
  ERROR_IS_SUBST_PATH = 146;
  {$EXTERNALSYM ERROR_IS_SUBST_PATH}

  { Not enough resources are available to process this command. }
  ERROR_IS_JOIN_PATH = 147;
  {$EXTERNALSYM ERROR_IS_JOIN_PATH}

  { The path specified cannot be used at this time. }
  ERROR_PATH_BUSY = 148;
  {$EXTERNALSYM ERROR_PATH_BUSY}

  { An attempt was made to join or substitute a drive for which a directory }
  { on the drive is the target of a previous substitute. }
  ERROR_IS_SUBST_TARGET = 149;
  {$EXTERNALSYM ERROR_IS_SUBST_TARGET}

  { System trace information was not specified in your }
  { CONFIG.SYS file, or tracing is disallowed. }
  ERROR_SYSTEM_TRACE = 150;
  {$EXTERNALSYM ERROR_SYSTEM_TRACE}

  { The number of specified semaphore events for }
  { DosMuxSemWait is not correct. }
  ERROR_INVALID_EVENT_COUNT = 151;
  {$EXTERNALSYM ERROR_INVALID_EVENT_COUNT}

  { DosMuxSemWait did not execute; too many semaphores }
  { are already set. }
  ERROR_TOO_MANY_MUXWAITERS = 152;
  {$EXTERNALSYM ERROR_TOO_MANY_MUXWAITERS}

  { The DosMuxSemWait list is not correct. }
  ERROR_INVALID_LIST_FORMAT = 153;
  {$EXTERNALSYM ERROR_INVALID_LIST_FORMAT}

  {  The volume label you entered exceeds the label character }
  {  limit of the target file system. }
  ERROR_LABEL_TOO_LONG = 154;
  {$EXTERNALSYM ERROR_LABEL_TOO_LONG}

  { Cannot create another thread. }
  ERROR_TOO_MANY_TCBS = 155;
  {$EXTERNALSYM ERROR_TOO_MANY_TCBS}

  { The recipient process has refused the signal. }
  ERROR_SIGNAL_REFUSED = 156;
  {$EXTERNALSYM ERROR_SIGNAL_REFUSED}

  { The segment is already discarded and cannot be locked. }
  ERROR_DISCARDED = 157;
  {$EXTERNALSYM ERROR_DISCARDED}

  { The segment is already unlocked. }
  ERROR_NOT_LOCKED = 158;
  {$EXTERNALSYM ERROR_NOT_LOCKED}

  { The address for the thread ID is not correct. }
  ERROR_BAD_THREADID_ADDR = 159;
  {$EXTERNALSYM ERROR_BAD_THREADID_ADDR}

  { The argument string passed to DosExecPgm is not correct. }
  ERROR_BAD_ARGUMENTS = 160;
  {$EXTERNALSYM ERROR_BAD_ARGUMENTS}

  { The specified path is invalid. }
  ERROR_BAD_PATHNAME = 161;
  {$EXTERNALSYM ERROR_BAD_PATHNAME}

  { A signal is already pending. }
  ERROR_SIGNAL_PENDING = 162;
  {$EXTERNALSYM ERROR_SIGNAL_PENDING}

  { No more threads can be created in the system. }
  ERROR_MAX_THRDS_REACHED = 164;
  {$EXTERNALSYM ERROR_MAX_THRDS_REACHED}

  { Unable to lock a region of a file. }
  ERROR_LOCK_FAILED = 167;
  {$EXTERNALSYM ERROR_LOCK_FAILED}

  { The requested resource is in use. }
  ERROR_BUSY = 170;
  {$EXTERNALSYM ERROR_BUSY}

  { A lock request was not outstanding for the supplied cancel region. }
  ERROR_CANCEL_VIOLATION = 173;
  {$EXTERNALSYM ERROR_CANCEL_VIOLATION}

  { The file system does not support atomic changes to the lock type. }
  ERROR_ATOMIC_LOCKS_NOT_SUPPORTED = 174;
  {$EXTERNALSYM ERROR_ATOMIC_LOCKS_NOT_SUPPORTED}

  { The system detected a segment number that was not correct. }
  ERROR_INVALID_SEGMENT_NUMBER = 180;
  {$EXTERNALSYM ERROR_INVALID_SEGMENT_NUMBER}

  { The operating system cannot run %1. }
  ERROR_INVALID_ORDINAL = 182;
  {$EXTERNALSYM ERROR_INVALID_ORDINAL}

  { Cannot create a file when that file already exists. }
  ERROR_ALREADY_EXISTS = 183;
  {$EXTERNALSYM ERROR_ALREADY_EXISTS}

  { The flag passed is not correct. }
  ERROR_INVALID_FLAG_NUMBER = 186;
  {$EXTERNALSYM ERROR_INVALID_FLAG_NUMBER}

  { The specified system semaphore name was not found. }
  ERROR_SEM_NOT_FOUND = 187;
  {$EXTERNALSYM ERROR_SEM_NOT_FOUND}

  { The operating system cannot run %1. }
  ERROR_INVALID_STARTING_CODESEG = 188;
  {$EXTERNALSYM ERROR_INVALID_STARTING_CODESEG}

  { The operating system cannot run %1. }
  ERROR_INVALID_STACKSEG = 189;
  {$EXTERNALSYM ERROR_INVALID_STACKSEG}

  { The operating system cannot run %1. }
  ERROR_INVALID_MODULETYPE = 190;
  {$EXTERNALSYM ERROR_INVALID_MODULETYPE}

  { Cannot run %1 in Windows NT mode. }
  ERROR_INVALID_EXE_SIGNATURE = 191;
  {$EXTERNALSYM ERROR_INVALID_EXE_SIGNATURE}

  { The operating system cannot run %1. }
  ERROR_EXE_MARKED_INVALID = 192;
  {$EXTERNALSYM ERROR_EXE_MARKED_INVALID}

  { %1 is not a valid Windows NT application. }
  ERROR_BAD_EXE_FORMAT = 193;
  {$EXTERNALSYM ERROR_BAD_EXE_FORMAT}

  { The operating system cannot run %1. }
  ERROR_ITERATED_DATA_EXCEEDS_64k = 194;
  {$EXTERNALSYM ERROR_ITERATED_DATA_EXCEEDS_64k}

  { The operating system cannot run %1. }
  ERROR_INVALID_MINALLOCSIZE = 195;
  {$EXTERNALSYM ERROR_INVALID_MINALLOCSIZE}

  { The operating system cannot run this application program. }
  ERROR_DYNLINK_FROM_INVALID_RING = 196;
  {$EXTERNALSYM ERROR_DYNLINK_FROM_INVALID_RING}

  { The operating system is not presently configured to run this application. }
  ERROR_IOPL_NOT_ENABLED = 197;
  {$EXTERNALSYM ERROR_IOPL_NOT_ENABLED}

  { The operating system cannot run %1. }
  ERROR_INVALID_SEGDPL = 198;
  {$EXTERNALSYM ERROR_INVALID_SEGDPL}

  { The operating system cannot run this }
  { application program. }
  ERROR_AUTODATASEG_EXCEEDS_64k = 199;
  {$EXTERNALSYM ERROR_AUTODATASEG_EXCEEDS_64k}

  { The code segment cannot be greater than or equal to 64KB. }
  ERROR_RING2SEG_MUST_BE_MOVABLE = 200;
  {$EXTERNALSYM ERROR_RING2SEG_MUST_BE_MOVABLE}

  { The operating system cannot run %1. }
  ERROR_RELOC_CHAIN_XEEDS_SEGLIM = 201;
  {$EXTERNALSYM ERROR_RELOC_CHAIN_XEEDS_SEGLIM}

  { The operating system cannot run %1. }
  ERROR_INFLOOP_IN_RELOC_CHAIN = 202;
  {$EXTERNALSYM ERROR_INFLOOP_IN_RELOC_CHAIN}

  { The system could not find the environment option that was entered. }
  ERROR_ENVVAR_NOT_FOUND = 203;
  {$EXTERNALSYM ERROR_ENVVAR_NOT_FOUND}

  { No process in the command subtree has a signal handler. }
  ERROR_NO_SIGNAL_SENT = 205;
  {$EXTERNALSYM ERROR_NO_SIGNAL_SENT}

  { The filename or extension is too long. }
  ERROR_FILENAME_EXCED_RANGE = 206;
  {$EXTERNALSYM ERROR_FILENAME_EXCED_RANGE}

  { The ring 2 stack is in use. }
  ERROR_RING2_STACK_IN_USE = 207;
  {$EXTERNALSYM ERROR_RING2_STACK_IN_USE}

  { The global filename characters, * or ?, are entered }
  { incorrectly or too many global filename characters are specified. }
  ERROR_META_EXPANSION_TOO_LONG = 208;
  {$EXTERNALSYM ERROR_META_EXPANSION_TOO_LONG}

  { The signal being posted is not correct. }
  ERROR_INVALID_SIGNAL_NUMBER = 209;
  {$EXTERNALSYM ERROR_INVALID_SIGNAL_NUMBER}

  { The signal handler cannot be set. }
  ERROR_THREAD_1_INACTIVE = 210;
  {$EXTERNALSYM ERROR_THREAD_1_INACTIVE}

  { The segment is locked and cannot be reallocated. }
  ERROR_LOCKED = 212;
  {$EXTERNALSYM ERROR_LOCKED}

  { Too many dynamic link modules are attached to this }
  { program or dynamic link module. }
  ERROR_TOO_MANY_MODULES = 214;
  {$EXTERNALSYM ERROR_TOO_MANY_MODULES}

  { Can't nest calls to LoadModule. }
  ERROR_NESTING_NOT_ALLOWED = 215;
  {$EXTERNALSYM ERROR_NESTING_NOT_ALLOWED}

  {  The image file %1 is valid, but is for a machine type other }
  {  than the current machine. }
  ERROR_EXE_MACHINE_TYPE_MISMATCH = 216;
  {$EXTERNALSYM ERROR_EXE_MACHINE_TYPE_MISMATCH}

  { The pipe state is invalid. }
  ERROR_BAD_PIPE = 230;
  {$EXTERNALSYM ERROR_BAD_PIPE}

  { All pipe instances are busy. }
  ERROR_PIPE_BUSY = 231;
  {$EXTERNALSYM ERROR_PIPE_BUSY}

  { The pipe is being closed. }
  ERROR_NO_DATA = 232;
  {$EXTERNALSYM ERROR_NO_DATA}

  { No process is on the other end of the pipe. }
  ERROR_PIPE_NOT_CONNECTED = 233;
  {$EXTERNALSYM ERROR_PIPE_NOT_CONNECTED}

  { More data is available. }
  ERROR_MORE_DATA = 234;   { dderror }
  {$EXTERNALSYM ERROR_MORE_DATA}

  { The session was cancelled. }
  ERROR_VC_DISCONNECTED = 240;
  {$EXTERNALSYM ERROR_VC_DISCONNECTED}

  { The specified extended attribute name was invalid. }
  ERROR_INVALID_EA_NAME = 254;
  {$EXTERNALSYM ERROR_INVALID_EA_NAME}

  { The extended attributes are inconsistent. }
  ERROR_EA_LIST_INCONSISTENT = 255;
  {$EXTERNALSYM ERROR_EA_LIST_INCONSISTENT}

  { No more data is available. }
  ERROR_NO_MORE_ITEMS = 259;
  {$EXTERNALSYM ERROR_NO_MORE_ITEMS}

  { The Copy API cannot be used. }
  ERROR_CANNOT_COPY = 266;
  {$EXTERNALSYM ERROR_CANNOT_COPY}

  { The directory name is invalid. }
  ERROR_DIRECTORY = 267;
  {$EXTERNALSYM ERROR_DIRECTORY}

  { The extended attributes did not fit in the buffer. }
  ERROR_EAS_DIDNT_FIT = 275;
  {$EXTERNALSYM ERROR_EAS_DIDNT_FIT}

  { The extended attribute file on the mounted file system is corrupt. }
  ERROR_EA_FILE_CORRUPT = 276;
  {$EXTERNALSYM ERROR_EA_FILE_CORRUPT}

  { The extended attribute table file is full. }
  ERROR_EA_TABLE_FULL = 277;
  {$EXTERNALSYM ERROR_EA_TABLE_FULL}

  { The specified extended attribute handle is invalid. }
  ERROR_INVALID_EA_HANDLE = 278;
  {$EXTERNALSYM ERROR_INVALID_EA_HANDLE}

  { The mounted file system does not support extended attributes. }
  ERROR_EAS_NOT_SUPPORTED = 282;
  {$EXTERNALSYM ERROR_EAS_NOT_SUPPORTED}

  { Attempt to release mutex not owned by caller. }
  ERROR_NOT_OWNER = 288;
  {$EXTERNALSYM ERROR_NOT_OWNER}

  { Too many posts were made to a semaphore. }
  ERROR_TOO_MANY_POSTS = 298;
  {$EXTERNALSYM ERROR_TOO_MANY_POSTS}

  { Only part of a Read/WriteProcessMemory request was completed. }
  ERROR_PARTIAL_COPY = 299;
  {$EXTERNALSYM ERROR_PARTIAL_COPY}

  { The system cannot find message for message number $%1 }
  { in message file for %2. }
  ERROR_MR_MID_NOT_FOUND = 317;
  {$EXTERNALSYM ERROR_MR_MID_NOT_FOUND}

  { Attempt to access invalid address. }
  ERROR_INVALID_ADDRESS = 487;
  {$EXTERNALSYM ERROR_INVALID_ADDRESS}

  { Arithmetic result exceeded 32 bits. }
  ERROR_ARITHMETIC_OVERFLOW = 534;
  {$EXTERNALSYM ERROR_ARITHMETIC_OVERFLOW}

  { There is a process on other end of the pipe. }
  ERROR_PIPE_CONNECTED = 535;
  {$EXTERNALSYM ERROR_PIPE_CONNECTED}

  { Waiting for a process to open the other end of the pipe. }
  ERROR_PIPE_LISTENING = 536;
  {$EXTERNALSYM ERROR_PIPE_LISTENING}

  { Access to the extended attribute was denied. }
  ERROR_EA_ACCESS_DENIED = 994;
  {$EXTERNALSYM ERROR_EA_ACCESS_DENIED}

  { The I/O operation has been aborted because of either a thread exit }
  { or an application request. }
  ERROR_OPERATION_ABORTED = 995;
  {$EXTERNALSYM ERROR_OPERATION_ABORTED}

  { Overlapped I/O event is not in a signalled state. }
  ERROR_IO_INCOMPLETE = 996;
  {$EXTERNALSYM ERROR_IO_INCOMPLETE}

  { Overlapped I/O operation is in progress. }
  ERROR_IO_PENDING = 997;   { dderror }
  {$EXTERNALSYM ERROR_IO_PENDING}

  { Invalid access to memory location. }
  ERROR_NOACCESS = 998;
  {$EXTERNALSYM ERROR_NOACCESS}

  { Error performing inpage operation. }
  ERROR_SWAPERROR = 999;
  {$EXTERNALSYM ERROR_SWAPERROR}

  { Recursion too deep, stack overflowed. }
  ERROR_STACK_OVERFLOW = 1001;
  {$EXTERNALSYM ERROR_STACK_OVERFLOW}

  { The window cannot act on the sent message. }
  ERROR_INVALID_MESSAGE = 1002;
  {$EXTERNALSYM ERROR_INVALID_MESSAGE}

  { Cannot complete this function. }
  ERROR_CAN_NOT_COMPLETE = 1003;
  {$EXTERNALSYM ERROR_CAN_NOT_COMPLETE}

  { Invalid flags. }
  ERROR_INVALID_FLAGS = 1004;
  {$EXTERNALSYM ERROR_INVALID_FLAGS}

  { The volume does not contain a recognized file system. }
  { Please make sure that all required file system drivers are loaded and that the }
  { volume is not corrupt. }
  ERROR_UNRECOGNIZED_VOLUME = 1005;
  {$EXTERNALSYM ERROR_UNRECOGNIZED_VOLUME}

  { The volume for a file has been externally altered such that the }
  { opened file is no longer valid. }
  ERROR_FILE_INVALID = 1006;
  {$EXTERNALSYM ERROR_FILE_INVALID}

  { The requested operation cannot be performed in full-screen mode. }
  ERROR_FULLSCREEN_MODE = 1007;
  {$EXTERNALSYM ERROR_FULLSCREEN_MODE}

  { An attempt was made to reference a token that does not exist. }
  ERROR_NO_TOKEN = 1008;
  {$EXTERNALSYM ERROR_NO_TOKEN}

  { The configuration registry database is corrupt. }
  ERROR_BADDB = 1009;
  {$EXTERNALSYM ERROR_BADDB}

  { The configuration registry key is invalid. }
  ERROR_BADKEY = 1010;
  {$EXTERNALSYM ERROR_BADKEY}

  { The configuration registry key could not be opened. }
  ERROR_CANTOPEN = 1011;
  {$EXTERNALSYM ERROR_CANTOPEN}

  { The configuration registry key could not be read. }
  ERROR_CANTREAD = 1012;
  {$EXTERNALSYM ERROR_CANTREAD}

  { The configuration registry key could not be written. }
  ERROR_CANTWRITE = 1013;
  {$EXTERNALSYM ERROR_CANTWRITE}

  { One of the files in the Registry database had to be recovered }
  { by use of a log or alternate copy.  The recovery was successful. }
  ERROR_REGISTRY_RECOVERED = 1014;
  {$EXTERNALSYM ERROR_REGISTRY_RECOVERED}

  { The Registry is corrupt. The structure of one of the files that contains }
  { Registry data is corrupt, or the system's image of the file in memory }
  { is corrupt, or the file could not be recovered because the alternate }
  { copy or log was absent or corrupt. }
  ERROR_REGISTRY_CORRUPT = 1015;
  {$EXTERNALSYM ERROR_REGISTRY_CORRUPT}

  { An I/O operation initiated by the Registry failed unrecoverably. }
  { The Registry could not read in, or write out, or flush, one of the files }
  { that contain the system's image of the Registry. }
  ERROR_REGISTRY_IO_FAILED = 1016;
  {$EXTERNALSYM ERROR_REGISTRY_IO_FAILED}

  { The system has attempted to load or restore a file into the Registry, but the }
  { specified file is not in a Registry file format. }
  ERROR_NOT_REGISTRY_FILE = 1017;
  {$EXTERNALSYM ERROR_NOT_REGISTRY_FILE}

  { Illegal operation attempted on a Registry key which has been marked for deletion. }
  ERROR_KEY_DELETED = 1018;
  {$EXTERNALSYM ERROR_KEY_DELETED}

  { System could not allocate the required space in a Registry log. }
  ERROR_NO_LOG_SPACE = 1019;
  {$EXTERNALSYM ERROR_NO_LOG_SPACE}

  { Cannot create a symbolic link in a Registry key that already }
  { has subkeys or values. }
  ERROR_KEY_HAS_CHILDREN = 1020;
  {$EXTERNALSYM ERROR_KEY_HAS_CHILDREN}

  { Cannot create a stable subkey under a volatile parent key. }
  ERROR_CHILD_MUST_BE_VOLATILE = 1021;
  {$EXTERNALSYM ERROR_CHILD_MUST_BE_VOLATILE}

  { A notify change request is being completed and the information }
  { is not being returned in the caller's buffer. The caller now }
  { needs to enumerate the files to find the changes. }
  ERROR_NOTIFY_ENUM_DIR = 1022;
  {$EXTERNALSYM ERROR_NOTIFY_ENUM_DIR}

  { A stop control has been sent to a service which other running services }
  { are dependent on. }
  ERROR_DEPENDENT_SERVICES_RUNNING = 1051;
  {$EXTERNALSYM ERROR_DEPENDENT_SERVICES_RUNNING}

  { The requested control is not valid for this service }
  ERROR_INVALID_SERVICE_CONTROL = 1052;
  {$EXTERNALSYM ERROR_INVALID_SERVICE_CONTROL}

  { The service did not respond to the start or control request in a timely }
  { fashion. }
  ERROR_SERVICE_REQUEST_TIMEOUT = 1053;
  {$EXTERNALSYM ERROR_SERVICE_REQUEST_TIMEOUT}

  { A thread could not be created for the service. }
  ERROR_SERVICE_NO_THREAD = 1054;
  {$EXTERNALSYM ERROR_SERVICE_NO_THREAD}

  { The service database is locked. }
  ERROR_SERVICE_DATABASE_LOCKED = 1055;
  {$EXTERNALSYM ERROR_SERVICE_DATABASE_LOCKED}

  { An instance of the service is already running. }
  ERROR_SERVICE_ALREADY_RUNNING = 1056;
  {$EXTERNALSYM ERROR_SERVICE_ALREADY_RUNNING}

  { The account name is invalid or does not exist. }
  ERROR_INVALID_SERVICE_ACCOUNT = 1057;
  {$EXTERNALSYM ERROR_INVALID_SERVICE_ACCOUNT}

  { The specified service is disabled and cannot be started. }
  ERROR_SERVICE_DISABLED = 1058;
  {$EXTERNALSYM ERROR_SERVICE_DISABLED}

  { Circular service dependency was specified. }
  ERROR_CIRCULAR_DEPENDENCY = 1059;
  {$EXTERNALSYM ERROR_CIRCULAR_DEPENDENCY}

  { The specified service does not exist as an installed service. }
  ERROR_SERVICE_DOES_NOT_EXIST = 1060;
  {$EXTERNALSYM ERROR_SERVICE_DOES_NOT_EXIST}

  { The service cannot accept control messages at this time. }
  ERROR_SERVICE_CANNOT_ACCEPT_CTRL = 1061;
  {$EXTERNALSYM ERROR_SERVICE_CANNOT_ACCEPT_CTRL}

  { The service has not been started. }
  ERROR_SERVICE_NOT_ACTIVE = 1062;
  {$EXTERNALSYM ERROR_SERVICE_NOT_ACTIVE}

  { The service process could not connect to the service controller. }
  ERROR_FAILED_SERVICE_CONTROLLER_ = 1063;
  {$EXTERNALSYM ERROR_FAILED_SERVICE_CONTROLLER_}

  { An exception occurred in the service when handling the control request. }
  ERROR_EXCEPTION_IN_SERVICE = 1064;
  {$EXTERNALSYM ERROR_EXCEPTION_IN_SERVICE}

  { The database specified does not exist. }
  ERROR_DATABASE_DOES_NOT_EXIST = 1065;
  {$EXTERNALSYM ERROR_DATABASE_DOES_NOT_EXIST}

  { The service has returned a service-specific error code. }
  ERROR_SERVICE_SPECIFIC_ERROR = 1066;
  {$EXTERNALSYM ERROR_SERVICE_SPECIFIC_ERROR}

  { The process terminated unexpectedly. }
  ERROR_PROCESS_ABORTED = 1067;
  {$EXTERNALSYM ERROR_PROCESS_ABORTED}

  { The dependency service or group failed to start. }
  ERROR_SERVICE_DEPENDENCY_FAIL = 1068;
  {$EXTERNALSYM ERROR_SERVICE_DEPENDENCY_FAIL}

  { The service did not start due to a logon failure. }
  ERROR_SERVICE_LOGON_FAILED = 1069;
  {$EXTERNALSYM ERROR_SERVICE_LOGON_FAILED}

  { After starting, the service hung in a start-pending state. }
  ERROR_SERVICE_START_HANG = 1070;
  {$EXTERNALSYM ERROR_SERVICE_START_HANG}

  { The specified service database lock is invalid. }
  ERROR_INVALID_SERVICE_LOCK = 1071;
  {$EXTERNALSYM ERROR_INVALID_SERVICE_LOCK}

  { The specified service has been marked for deletion. }
  ERROR_SERVICE_MARKED_FOR_DELETE = 1072;
  {$EXTERNALSYM ERROR_SERVICE_MARKED_FOR_DELETE}

  { The specified service already exists. }
  ERROR_SERVICE_EXISTS = 1073;
  {$EXTERNALSYM ERROR_SERVICE_EXISTS}

  { The system is currently running with the last-known-good configuration. }
  ERROR_ALREADY_RUNNING_LKG = 1074;
  {$EXTERNALSYM ERROR_ALREADY_RUNNING_LKG}

  { The dependency service does not exist or has been marked for }
  { deletion. }
  ERROR_SERVICE_DEPENDENCY_DELETED = 1075;
  {$EXTERNALSYM ERROR_SERVICE_DEPENDENCY_DELETED}

  { The current boot has already been accepted for use as the }
  { last-known-good control set. }
  ERROR_BOOT_ALREADY_ACCEPTED = 1076;
  {$EXTERNALSYM ERROR_BOOT_ALREADY_ACCEPTED}

  { No attempts to start the service have been made since the last boot. }
  ERROR_SERVICE_NEVER_STARTED = 1077;
  {$EXTERNALSYM ERROR_SERVICE_NEVER_STARTED}

  { The name is already in use as either a service name or a service display }
  { name. }
  ERROR_DUPLICATE_SERVICE_NAME = 1078;
  {$EXTERNALSYM ERROR_DUPLICATE_SERVICE_NAME}

  {  The account specified for this service is different from the account }
  {  specified for other services running in the same process. }
  ERROR_DIFFERENT_SERVICE_ACCOUNT = 1079;
  {$EXTERNALSYM ERROR_DIFFERENT_SERVICE_ACCOUNT}

  { The physical end of the tape has been reached. }
  ERROR_END_OF_MEDIA = 1100;
  {$EXTERNALSYM ERROR_END_OF_MEDIA}

  { A tape access reached a filemark. }
  ERROR_FILEMARK_DETECTED = 1101;
  {$EXTERNALSYM ERROR_FILEMARK_DETECTED}

  { Beginning of tape or partition was encountered. }
  ERROR_BEGINNING_OF_MEDIA = 1102;
  {$EXTERNALSYM ERROR_BEGINNING_OF_MEDIA}

  { A tape access reached the end of a set of files. }
  ERROR_SETMARK_DETECTED = 1103;
  {$EXTERNALSYM ERROR_SETMARK_DETECTED}

  { No more data is on the tape. }
  ERROR_NO_DATA_DETECTED = 1104;
  {$EXTERNALSYM ERROR_NO_DATA_DETECTED}

  { Tape could not be partitioned. }
  ERROR_PARTITION_FAILURE = 1105;
  {$EXTERNALSYM ERROR_PARTITION_FAILURE}

  { When accessing a new tape of a multivolume partition, the current }
  { blocksize is incorrect. }
  ERROR_INVALID_BLOCK_LENGTH = 1106;
  {$EXTERNALSYM ERROR_INVALID_BLOCK_LENGTH}

  { Tape partition information could not be found when loading a tape. }
  ERROR_DEVICE_NOT_PARTITIONED = 1107;
  {$EXTERNALSYM ERROR_DEVICE_NOT_PARTITIONED}

  { Unable to lock the media eject mechanism. }
  ERROR_UNABLE_TO_LOCK_MEDIA = 1108;
  {$EXTERNALSYM ERROR_UNABLE_TO_LOCK_MEDIA}

  { Unable to unload the media. }
  ERROR_UNABLE_TO_UNLOAD_MEDIA = 1109;
  {$EXTERNALSYM ERROR_UNABLE_TO_UNLOAD_MEDIA}

  { Media in drive may have changed. }
  ERROR_MEDIA_CHANGED = 1110;
  {$EXTERNALSYM ERROR_MEDIA_CHANGED}

  { The I/O bus was reset. }
  ERROR_BUS_RESET = 1111;
  {$EXTERNALSYM ERROR_BUS_RESET}

  { No media in drive. }
  ERROR_NO_MEDIA_IN_DRIVE = 1112;
  {$EXTERNALSYM ERROR_NO_MEDIA_IN_DRIVE}

  { No mapping for the Unicode character exists in the target multi-byte code page. }
  ERROR_NO_UNICODE_TRANSLATION = 1113;
  {$EXTERNALSYM ERROR_NO_UNICODE_TRANSLATION}

  { A dynamic link library (DLL) initialization routine failed. }
  ERROR_DLL_INIT_FAILED = 1114;
  {$EXTERNALSYM ERROR_DLL_INIT_FAILED}

  { A system shutdown is in progress. }
  ERROR_SHUTDOWN_IN_PROGRESS = 1115;
  {$EXTERNALSYM ERROR_SHUTDOWN_IN_PROGRESS}

  { Unable to abort the system shutdown because no shutdown was in progress. }
  ERROR_NO_SHUTDOWN_IN_PROGRESS = 1116;
  {$EXTERNALSYM ERROR_NO_SHUTDOWN_IN_PROGRESS}

  { The request could not be performed because of an I/O device error. }
  ERROR_IO_DEVICE = 1117;
  {$EXTERNALSYM ERROR_IO_DEVICE}

  { No serial device was successfully initialized.  The serial driver will unload. }
  ERROR_SERIAL_NO_DEVICE = 1118;
  {$EXTERNALSYM ERROR_SERIAL_NO_DEVICE}

  { Unable to open a device that was sharing an interrupt request (IRQ) }
  { with other devices. At least one other device that uses that IRQ }
  { was already opened. }
  ERROR_IRQ_BUSY = 1119;
  {$EXTERNALSYM ERROR_IRQ_BUSY}

  { A serial I/O operation was completed by another write to the serial port. }
  { (The IOCTL_SERIAL_XOFF_COUNTER reached zero.) }
  ERROR_MORE_WRITES = 1120;
  {$EXTERNALSYM ERROR_MORE_WRITES}

  { A serial I/O operation completed because the time-out period expired. }
  { (The IOCTL_SERIAL_XOFF_COUNTER did not reach zero.) }
  ERROR_COUNTER_TIMEOUT = 1121;
  {$EXTERNALSYM ERROR_COUNTER_TIMEOUT}

  { No ID address mark was found on the floppy disk. }
  ERROR_FLOPPY_ID_MARK_NOT_FOUND = 1122;
  {$EXTERNALSYM ERROR_FLOPPY_ID_MARK_NOT_FOUND}

  { Mismatch between the floppy disk sector ID field and the floppy disk }
  { controller track address. }
  ERROR_FLOPPY_WRONG_CYLINDER = 1123;
  {$EXTERNALSYM ERROR_FLOPPY_WRONG_CYLINDER}

  { The floppy disk controller reported an error that is not recognized }
  { by the floppy disk driver. }
  ERROR_FLOPPY_UNKNOWN_ERROR = 1124;
  {$EXTERNALSYM ERROR_FLOPPY_UNKNOWN_ERROR}

  { The floppy disk controller returned inconsistent results in its registers. }
  ERROR_FLOPPY_BAD_REGISTERS = 1125;
  {$EXTERNALSYM ERROR_FLOPPY_BAD_REGISTERS}

  { While accessing the hard disk, a recalibrate operation failed, even after retries. }
  ERROR_DISK_RECALIBRATE_FAILED = 1126;
  {$EXTERNALSYM ERROR_DISK_RECALIBRATE_FAILED}

  { While accessing the hard disk, a disk operation failed even after retries. }
  ERROR_DISK_OPERATION_FAILED = 1127;
  {$EXTERNALSYM ERROR_DISK_OPERATION_FAILED}

  { While accessing the hard disk, a disk controller reset was needed, but }
  { even that failed. }
  ERROR_DISK_RESET_FAILED = 1128;
  {$EXTERNALSYM ERROR_DISK_RESET_FAILED}

  { Physical end of tape encountered. }
  ERROR_EOM_OVERFLOW = 1129;
  {$EXTERNALSYM ERROR_EOM_OVERFLOW}

  { Not enough server storage is available to process this command. }
  ERROR_NOT_ENOUGH_SERVER_MEMORY = 1130;
  {$EXTERNALSYM ERROR_NOT_ENOUGH_SERVER_MEMORY}

  { A potential deadlock condition has been detected. }
  ERROR_POSSIBLE_DEADLOCK = 1131;
  {$EXTERNALSYM ERROR_POSSIBLE_DEADLOCK}

  { The base address or the file offset specified does not have the proper }
  { alignment. }
  ERROR_MAPPED_ALIGNMENT = 1132;
  {$EXTERNALSYM ERROR_MAPPED_ALIGNMENT}

  { An attempt to change the system power state was vetoed by another }
  { application or driver. }
  ERROR_SET_POWER_STATE_VETOED = 1140;
  {$EXTERNALSYM ERROR_SET_POWER_STATE_VETOED}

  { The system BIOS failed an attempt to change the system power state. }
  ERROR_SET_POWER_STATE_FAILED = 1141;
  {$EXTERNALSYM ERROR_SET_POWER_STATE_FAILED}

  {  An attempt was made to create more links on a file than }
  {  the file system supports. }
  ERROR_TOO_MANY_LINKS = 1142;
  {$EXTERNALSYM ERROR_TOO_MANY_LINKS}

  { The specified program requires a newer version of Windows. }
  ERROR_OLD_WIN_VERSION = 1150;
  {$EXTERNALSYM ERROR_OLD_WIN_VERSION}

  { The specified program is not a Windows or MS-DOS program. }
  ERROR_APP_WRONG_OS = 1151;
  {$EXTERNALSYM ERROR_APP_WRONG_OS}

  { Cannot start more than one instance of the specified program. }
  ERROR_SINGLE_INSTANCE_APP = 1152;
  {$EXTERNALSYM ERROR_SINGLE_INSTANCE_APP}

  {  The specified program was written for an older version of Windows. }
  ERROR_RMODE_APP = 1153;
  {$EXTERNALSYM ERROR_RMODE_APP}

  { One of the library files needed to run this application is damaged. }
  ERROR_INVALID_DLL = 1154;
  {$EXTERNALSYM ERROR_INVALID_DLL}

  { No application is associated with the specified file for this operation. }
  ERROR_NO_ASSOCIATION = 1155;
  {$EXTERNALSYM ERROR_NO_ASSOCIATION}

  { An error occurred in sending the command to the application. }
  ERROR_DDE_FAIL = 1156;
  {$EXTERNALSYM ERROR_DDE_FAIL}

  { One of the library files needed to run this application cannot be found. }
  ERROR_DLL_NOT_FOUND = 1157;
  {$EXTERNALSYM ERROR_DLL_NOT_FOUND}


{ Winnet32 Status Codes }

  { The specified username is invalid. }
  ERROR_BAD_USERNAME = 2202;
  {$EXTERNALSYM ERROR_BAD_USERNAME}

  { This network connection does not exist. }
  ERROR_NOT_CONNECTED = 2250;
  {$EXTERNALSYM ERROR_NOT_CONNECTED}

  { This network connection has files open or requests pending. }
  ERROR_OPEN_FILES = 2401;
  {$EXTERNALSYM ERROR_OPEN_FILES}

  { Active connections still exist. }
  ERROR_ACTIVE_CONNECTIONS = 2402;
  {$EXTERNALSYM ERROR_ACTIVE_CONNECTIONS}

  { The device is in use by an active process and cannot be disconnected. }
  ERROR_DEVICE_IN_USE = 2404;
  {$EXTERNALSYM ERROR_DEVICE_IN_USE}

  { The specified device name is invalid. }
  ERROR_BAD_DEVICE = 1200;
  {$EXTERNALSYM ERROR_BAD_DEVICE}

  { The device is not currently connected but it is a remembered connection. }
  ERROR_CONNECTION_UNAVAIL = 1201;
  {$EXTERNALSYM ERROR_CONNECTION_UNAVAIL}

  { An attempt was made to remember a device that had previously been remembered. }
  ERROR_DEVICE_ALREADY_REMEMBERED = 1202;
  {$EXTERNALSYM ERROR_DEVICE_ALREADY_REMEMBERED}

  { No network provider accepted the given network path. }
  ERROR_NO_NET_OR_BAD_PATH = 1203;
  {$EXTERNALSYM ERROR_NO_NET_OR_BAD_PATH}

  { The specified network provider name is invalid. }
  ERROR_BAD_PROVIDER = 1204;
  {$EXTERNALSYM ERROR_BAD_PROVIDER}

  { Unable to open the network connection profile. }
  ERROR_CANNOT_OPEN_PROFILE = 1205;
  {$EXTERNALSYM ERROR_CANNOT_OPEN_PROFILE}

  { The network connection profile is corrupt. }
  ERROR_BAD_PROFILE = 1206;
  {$EXTERNALSYM ERROR_BAD_PROFILE}

  { Cannot enumerate a non-container. }
  ERROR_NOT_CONTAINER = 1207;
  {$EXTERNALSYM ERROR_NOT_CONTAINER}

  { An extended error has occurred. }
  ERROR_EXTENDED_ERROR = 1208;
  {$EXTERNALSYM ERROR_EXTENDED_ERROR}

  { The format of the specified group name is invalid. }
  ERROR_INVALID_GROUPNAME = 1209;
  {$EXTERNALSYM ERROR_INVALID_GROUPNAME}

  { The format of the specified computer name is invalid. }
  ERROR_INVALID_COMPUTERNAME = 1210;
  {$EXTERNALSYM ERROR_INVALID_COMPUTERNAME}

  { The format of the specified event name is invalid. }
  ERROR_INVALID_EVENTNAME = 1211;
  {$EXTERNALSYM ERROR_INVALID_EVENTNAME}

  { The format of the specified domain name is invalid. }
  ERROR_INVALID_DOMAINNAME = 1212;
  {$EXTERNALSYM ERROR_INVALID_DOMAINNAME}

  { The format of the specified service name is invalid. }
  ERROR_INVALID_SERVICENAME = 1213;
  {$EXTERNALSYM ERROR_INVALID_SERVICENAME}

  { The format of the specified network name is invalid. }
  ERROR_INVALID_NETNAME = 1214;
  {$EXTERNALSYM ERROR_INVALID_NETNAME}

  { The format of the specified share name is invalid. }
  ERROR_INVALID_SHARENAME = 1215;
  {$EXTERNALSYM ERROR_INVALID_SHARENAME}

  { The format of the specified password is invalid. }
  ERROR_INVALID_PASSWORDNAME = 1216;
  {$EXTERNALSYM ERROR_INVALID_PASSWORDNAME}

  { The format of the specified message name is invalid. }
  ERROR_INVALID_MESSAGENAME = 1217;
  {$EXTERNALSYM ERROR_INVALID_MESSAGENAME}

  { The format of the specified message destination is invalid. }
  ERROR_INVALID_MESSAGEDEST = 1218;
  {$EXTERNALSYM ERROR_INVALID_MESSAGEDEST}

  { The credentials supplied conflict with an existing set of credentials. }
  ERROR_SESSION_CREDENTIAL_CONFLICT = 1219;
  {$EXTERNALSYM ERROR_SESSION_CREDENTIAL_CONFLICT}

  { An attempt was made to establish a session to a network server, but there }
  { are already too many sessions established to that server. }
  ERROR_REMOTE_SESSION_LIMIT_EXCEEDED = 1220;
  {$EXTERNALSYM ERROR_REMOTE_SESSION_LIMIT_EXCEEDED}

  { The workgroup or domain name is already in use by another computer on the }
  { network. }
  ERROR_DUP_DOMAINNAME = 1221;
  {$EXTERNALSYM ERROR_DUP_DOMAINNAME}

  { The network is not present or not started. }
  ERROR_NO_NETWORK = 1222;
  {$EXTERNALSYM ERROR_NO_NETWORK}

  { The operation was cancelled by the user. }
  ERROR_CANCELLED = 1223;
  {$EXTERNALSYM ERROR_CANCELLED}

  { The requested operation cannot be performed on a file with a user mapped section open. }
  ERROR_USER_MAPPED_FILE = 1224;
  {$EXTERNALSYM ERROR_USER_MAPPED_FILE}

  { The remote system refused the network connection. }
  ERROR_CONNECTION_REFUSED = 1225;
  {$EXTERNALSYM ERROR_CONNECTION_REFUSED}

  { The network connection was gracefully closed. }
  ERROR_GRACEFUL_DISCONNECT = 1226;
  {$EXTERNALSYM ERROR_GRACEFUL_DISCONNECT}

  { The network transport endpoint already has an address associated with it. }
  ERROR_ADDRESS_ALREADY_ASSOCIATED = 1227;
  {$EXTERNALSYM ERROR_ADDRESS_ALREADY_ASSOCIATED}

  { An address has not yet been associated with the network endpoint. }
  ERROR_ADDRESS_NOT_ASSOCIATED = 1228;
  {$EXTERNALSYM ERROR_ADDRESS_NOT_ASSOCIATED}

  { An operation was attempted on a non-existent network connection. }
  ERROR_CONNECTION_INVALID = 1229;
  {$EXTERNALSYM ERROR_CONNECTION_INVALID}

  { An invalid operation was attempted on an active network connection. }
  ERROR_CONNECTION_ACTIVE = 1230;
  {$EXTERNALSYM ERROR_CONNECTION_ACTIVE}

  { The remote network is not reachable by the transport. }
  ERROR_NETWORK_UNREACHABLE = 1231;
  {$EXTERNALSYM ERROR_NETWORK_UNREACHABLE}

  { The remote system is not reachable by the transport. }
  ERROR_HOST_UNREACHABLE = 1232;
  {$EXTERNALSYM ERROR_HOST_UNREACHABLE}

  { The remote system does not support the transport protocol. }
  ERROR_PROTOCOL_UNREACHABLE = 1233;
  {$EXTERNALSYM ERROR_PROTOCOL_UNREACHABLE}

  { No service is operating at the destination network endpoint }
  { on the remote system. }
  ERROR_PORT_UNREACHABLE = 1234;
  {$EXTERNALSYM ERROR_PORT_UNREACHABLE}

  { The request was aborted. }
  ERROR_REQUEST_ABORTED = 1235;
  {$EXTERNALSYM ERROR_REQUEST_ABORTED}

  { The network connection was aborted by the local system. }
  ERROR_CONNECTION_ABORTED = 1236;
  {$EXTERNALSYM ERROR_CONNECTION_ABORTED}

  { The operation could not be completed.  A retry should be performed. }
  ERROR_RETRY = 1237;
  {$EXTERNALSYM ERROR_RETRY}

  { A connection to the server could not be made because the limit on the number of }
  { concurrent connections for this account has been reached. }
  ERROR_CONNECTION_COUNT_LIMIT = 1238;
  {$EXTERNALSYM ERROR_CONNECTION_COUNT_LIMIT}

  { Attempting to login during an unauthorized time of day for this account. }
  ERROR_LOGIN_TIME_RESTRICTION = 1239;
  {$EXTERNALSYM ERROR_LOGIN_TIME_RESTRICTION}

  { The account is not authorized to login from this station. }
  ERROR_LOGIN_WKSTA_RESTRICTION = 1240;
  {$EXTERNALSYM ERROR_LOGIN_WKSTA_RESTRICTION}

  { The network address could not be used for the operation requested. }
  ERROR_INCORRECT_ADDRESS = 1241;
  {$EXTERNALSYM ERROR_INCORRECT_ADDRESS}

  { The service is already registered. }
  ERROR_ALREADY_REGISTERED = 1242;
  {$EXTERNALSYM ERROR_ALREADY_REGISTERED}

  { The specified service does not exist. }
  ERROR_SERVICE_NOT_FOUND = 1243;
  {$EXTERNALSYM ERROR_SERVICE_NOT_FOUND}

  { The operation being requested was not performed because the user }
  { has not been authenticated. }
  ERROR_NOT_AUTHENTICATED = 1244;
  {$EXTERNALSYM ERROR_NOT_AUTHENTICATED}

  { The operation being requested was not performed because the user }
  { has not logged on to the network. }
  { The specified service does not exist. }
  ERROR_NOT_LOGGED_ON = 1245;
  {$EXTERNALSYM ERROR_NOT_LOGGED_ON}

  { Return that wants caller to continue with work in progress. }
  ERROR_CONTINUE = 1246;
  {$EXTERNALSYM ERROR_CONTINUE}

  { An attempt was made to perform an initialization operation when }
  { initialization has already been completed. }
  ERROR_ALREADY_INITIALIZED = 1247;
  {$EXTERNALSYM ERROR_ALREADY_INITIALIZED}

  { No more local devices. }
  ERROR_NO_MORE_DEVICES = 1248;
  {$EXTERNALSYM ERROR_NO_MORE_DEVICES}


{ Security Status Codes }

  { Not all privileges referenced are assigned to the caller. }
  ERROR_NOT_ALL_ASSIGNED = 1300;
  {$EXTERNALSYM ERROR_NOT_ALL_ASSIGNED}

  { Some mapping between account names and security IDs was not done. }
  ERROR_SOME_NOT_MAPPED = 1301;
  {$EXTERNALSYM ERROR_SOME_NOT_MAPPED}

  { No system quota limits are specifically set for this account. }
  ERROR_NO_QUOTAS_FOR_ACCOUNT = 1302;
  {$EXTERNALSYM ERROR_NO_QUOTAS_FOR_ACCOUNT}

  { No encryption key is available.  A well-known encryption key was returned. }
  ERROR_LOCAL_USER_SESSION_KEY = 1303;
  {$EXTERNALSYM ERROR_LOCAL_USER_SESSION_KEY}

  { The NT password is too complex to be converted to a LAN Manager }
  { password.  The LAN Manager password returned is a NULL string. }
  ERROR_NULL_LM_PASSWORD = 1304;
  {$EXTERNALSYM ERROR_NULL_LM_PASSWORD}

  { The revision level is unknown. }
  ERROR_UNKNOWN_REVISION = 1305;
  {$EXTERNALSYM ERROR_UNKNOWN_REVISION}

  { Indicates two revision levels are incompatible. }
  ERROR_REVISION_MISMATCH = 1306;
  {$EXTERNALSYM ERROR_REVISION_MISMATCH}

  { This security ID may not be assigned as the owner of this object. }
  ERROR_INVALID_OWNER = 1307;
  {$EXTERNALSYM ERROR_INVALID_OWNER}

  { This security ID may not be assigned as the primary group of an object. }
  ERROR_INVALID_PRIMARY_GROUP = 1308;
  {$EXTERNALSYM ERROR_INVALID_PRIMARY_GROUP}

  { An attempt has been made to operate on an impersonation token }

  { by a thread that is not currently impersonating a client. }
  ERROR_NO_IMPERSONATION_TOKEN = 1309;
  {$EXTERNALSYM ERROR_NO_IMPERSONATION_TOKEN}

  { The group may not be disabled. }
  ERROR_CANT_DISABLE_MANDATORY = 1310;
  {$EXTERNALSYM ERROR_CANT_DISABLE_MANDATORY}

  { There are currently no logon servers available to service the logon }
  { request. }
  ERROR_NO_LOGON_SERVERS = 1311;
  {$EXTERNALSYM ERROR_NO_LOGON_SERVERS}

  {  A specified logon session does not exist.  It may already have }
  {  been terminated. }
  ERROR_NO_SUCH_LOGON_SESSION = 1312;
  {$EXTERNALSYM ERROR_NO_SUCH_LOGON_SESSION}

  {  A specified privilege does not exist. }
  ERROR_NO_SUCH_PRIVILEGE = 1313;
  {$EXTERNALSYM ERROR_NO_SUCH_PRIVILEGE}

  {  A required privilege is not held by the client. }
  ERROR_PRIVILEGE_NOT_HELD = 1314;
  {$EXTERNALSYM ERROR_PRIVILEGE_NOT_HELD}

  { The name provided is not a properly formed account name. }
  ERROR_INVALID_ACCOUNT_NAME = 1315;
  {$EXTERNALSYM ERROR_INVALID_ACCOUNT_NAME}

  { The specified user already exists. }
  ERROR_USER_EXISTS = 1316;
  {$EXTERNALSYM ERROR_USER_EXISTS}

  { The specified user does not exist. }
  ERROR_NO_SUCH_USER = 1317;
  {$EXTERNALSYM ERROR_NO_SUCH_USER}

  { The specified group already exists. }
  ERROR_GROUP_EXISTS = 1318;
  {$EXTERNALSYM ERROR_GROUP_EXISTS}

  { The specified group does not exist. }
  ERROR_NO_SUCH_GROUP = 1319;
  {$EXTERNALSYM ERROR_NO_SUCH_GROUP}

  { Either the specified user account is already a member of the specified }
  { group, or the specified group cannot be deleted because it contains }
  { a member. }
  ERROR_MEMBER_IN_GROUP = 1320;
  {$EXTERNALSYM ERROR_MEMBER_IN_GROUP}

  { The specified user account is not a member of the specified group account. }
  ERROR_MEMBER_NOT_IN_GROUP = 1321;
  {$EXTERNALSYM ERROR_MEMBER_NOT_IN_GROUP}

  { The last remaining administration account cannot be disabled }
  { or deleted. }
  ERROR_LAST_ADMIN = 1322;
  {$EXTERNALSYM ERROR_LAST_ADMIN}

  { Unable to update the password.  The value provided as the current }
  { password is incorrect. }
  ERROR_WRONG_PASSWORD = 1323;
  {$EXTERNALSYM ERROR_WRONG_PASSWORD}

  { Unable to update the password.  The value provided for the new password }
  { contains values that are not allowed in passwords. }
  ERROR_ILL_FORMED_PASSWORD = 1324;
  {$EXTERNALSYM ERROR_ILL_FORMED_PASSWORD}

  { Unable to update the password because a password update rule has been }
  { violated. }
  ERROR_PASSWORD_RESTRICTION = 1325;
  {$EXTERNALSYM ERROR_PASSWORD_RESTRICTION}

  { Logon failure: unknown user name or bad password. }
  ERROR_LOGON_FAILURE = 1326;
  {$EXTERNALSYM ERROR_LOGON_FAILURE}

  { Logon failure: user account restriction. }
  ERROR_ACCOUNT_RESTRICTION = 1327;
  {$EXTERNALSYM ERROR_ACCOUNT_RESTRICTION}

  { Logon failure: account logon time restriction violation. }
  ERROR_INVALID_LOGON_HOURS = 1328;
  {$EXTERNALSYM ERROR_INVALID_LOGON_HOURS}

  { Logon failure: user not allowed to log on to this computer. }
  ERROR_INVALID_WORKSTATION = 1329;
  {$EXTERNALSYM ERROR_INVALID_WORKSTATION}

  { Logon failure: the specified account password has expired. }
  ERROR_PASSWORD_EXPIRED = 1330;
  {$EXTERNALSYM ERROR_PASSWORD_EXPIRED}

  { Logon failure: account currently disabled. }
  ERROR_ACCOUNT_DISABLED = 1331;
  {$EXTERNALSYM ERROR_ACCOUNT_DISABLED}

  { No mapping between account names and security IDs was done. }
  ERROR_NONE_MAPPED = 1332;
  {$EXTERNALSYM ERROR_NONE_MAPPED}

  { Too many local user identifiers (LUIDs) were requested at one time. }
  ERROR_TOO_MANY_LUIDS_REQUESTED = 1333;
  {$EXTERNALSYM ERROR_TOO_MANY_LUIDS_REQUESTED}

  { No more local user identifiers (LUIDs) are available. }
  ERROR_LUIDS_EXHAUSTED = 1334;
  {$EXTERNALSYM ERROR_LUIDS_EXHAUSTED}

  { The subauthority part of a security ID is invalid for this particular use. }
  ERROR_INVALID_SUB_AUTHORITY = 1335;
  {$EXTERNALSYM ERROR_INVALID_SUB_AUTHORITY}

  { The access control list (ACL) structure is invalid. }
  ERROR_INVALID_ACL = 1336;
  {$EXTERNALSYM ERROR_INVALID_ACL}

  { The security ID structure is invalid. }
  ERROR_INVALID_SID = 1337;
  {$EXTERNALSYM ERROR_INVALID_SID}

  { The security descriptor structure is invalid. }
  ERROR_INVALID_SECURITY_DESCR = 1338;
  {$EXTERNALSYM ERROR_INVALID_SECURITY_DESCR}

  { The inherited access control list (ACL) or access control entry (ACE) }
  { could not be built. }
  ERROR_BAD_INHERITANCE_ACL = 1340;
  {$EXTERNALSYM ERROR_BAD_INHERITANCE_ACL}

  { The server is currently disabled. }
  ERROR_SERVER_DISABLED = 1341;
  {$EXTERNALSYM ERROR_SERVER_DISABLED}

  { The server is currently enabled. }
  ERROR_SERVER_NOT_DISABLED = 1342;
  {$EXTERNALSYM ERROR_SERVER_NOT_DISABLED}

  { The value provided was an invalid value for an identifier authority. }
  ERROR_INVALID_ID_AUTHORITY = 1343;
  {$EXTERNALSYM ERROR_INVALID_ID_AUTHORITY}

  { No more memory is available for security information updates. }
  ERROR_ALLOTTED_SPACE_EXCEEDED = 1344;
  {$EXTERNALSYM ERROR_ALLOTTED_SPACE_EXCEEDED}

  { The specified attributes are invalid, or incompatible with the }

  { attributes for the group as a whole. }
  ERROR_INVALID_GROUP_ATTRIBUTES = 1345;
  {$EXTERNALSYM ERROR_INVALID_GROUP_ATTRIBUTES}

  { Either a required impersonation level was not provided, or the }
  { provided impersonation level is invalid. }
  ERROR_BAD_IMPERSONATION_LEVEL = 1346;
  {$EXTERNALSYM ERROR_BAD_IMPERSONATION_LEVEL}

  { Cannot open an anonymous level security token. }
  ERROR_CANT_OPEN_ANONYMOUS = 1347;
  {$EXTERNALSYM ERROR_CANT_OPEN_ANONYMOUS}

  { The validation information class requested was invalid. }
  ERROR_BAD_VALIDATION_CLASS = 1348;
  {$EXTERNALSYM ERROR_BAD_VALIDATION_CLASS}

  { The type of the token is inappropriate for its attempted use. }
  ERROR_BAD_TOKEN_TYPE = 1349;
  {$EXTERNALSYM ERROR_BAD_TOKEN_TYPE}

  { Unable to perform a security operation on an object }
  { which has no associated security. }
  ERROR_NO_SECURITY_ON_OBJECT = 1350;
  {$EXTERNALSYM ERROR_NO_SECURITY_ON_OBJECT}

  { Indicates a Windows NT Server could not be contacted or that }
  { objects within the domain are protected such that necessary }
  { information could not be retrieved. }
  ERROR_CANT_ACCESS_DOMAIN_INFO = 1351;
  {$EXTERNALSYM ERROR_CANT_ACCESS_DOMAIN_INFO}

  { The security account manager (SAM) or local security }
  { authority (LSA) server was in the wrong state to perform }
  { the security operation. }
  ERROR_INVALID_SERVER_STATE = 1352;
  {$EXTERNALSYM ERROR_INVALID_SERVER_STATE}

  { The domain was in the wrong state to perform the security operation. }
  ERROR_INVALID_DOMAIN_STATE = 1353;
  {$EXTERNALSYM ERROR_INVALID_DOMAIN_STATE}

  { This operation is only allowed for the Primary Domain Controller of the domain. }
  ERROR_INVALID_DOMAIN_ROLE = 1354;
  {$EXTERNALSYM ERROR_INVALID_DOMAIN_ROLE}

  { The specified domain did not exist. }
  ERROR_NO_SUCH_DOMAIN = 1355;
  {$EXTERNALSYM ERROR_NO_SUCH_DOMAIN}

  { The specified domain already exists. }
  ERROR_DOMAIN_EXISTS = 1356;
  {$EXTERNALSYM ERROR_DOMAIN_EXISTS}

  { An attempt was made to exceed the limit on the number of domains per server. }
  ERROR_DOMAIN_LIMIT_EXCEEDED = 1357;
  {$EXTERNALSYM ERROR_DOMAIN_LIMIT_EXCEEDED}

  { Unable to complete the requested operation because of either a }
  { catastrophic media failure or a data structure corruption on the disk. }
  ERROR_INTERNAL_DB_CORRUPTION = 1358;
  {$EXTERNALSYM ERROR_INTERNAL_DB_CORRUPTION}

  { The security account database contains an internal inconsistency. }
  ERROR_INTERNAL_ERROR = 1359;
  {$EXTERNALSYM ERROR_INTERNAL_ERROR}

  { Generic access types were contained in an access mask which should }
  { already be mapped to non-generic types. }
  ERROR_GENERIC_NOT_MAPPED = 1360;
  {$EXTERNALSYM ERROR_GENERIC_NOT_MAPPED}

  { A security descriptor is not in the right format (absolute or self-relative). }
  ERROR_BAD_DESCRIPTOR_FORMAT = 1361;
  {$EXTERNALSYM ERROR_BAD_DESCRIPTOR_FORMAT}

  { The requested action is restricted for use by logon processes }
  { only.  The calling process has not registered as a logon process. }
  ERROR_NOT_LOGON_PROCESS = 1362;
  {$EXTERNALSYM ERROR_NOT_LOGON_PROCESS}

  { Cannot start a new logon session with an ID that is already in use. }
  ERROR_LOGON_SESSION_EXISTS = 1363;
  {$EXTERNALSYM ERROR_LOGON_SESSION_EXISTS}

  { A specified authentication package is unknown. }
  ERROR_NO_SUCH_PACKAGE = 1364;
  {$EXTERNALSYM ERROR_NO_SUCH_PACKAGE}

  { The logon session is not in a state that is consistent with the }
  { requested operation. }
  ERROR_BAD_LOGON_SESSION_STATE = 1365;
  {$EXTERNALSYM ERROR_BAD_LOGON_SESSION_STATE}

  { The logon session ID is already in use. }
  ERROR_LOGON_SESSION_COLLISION = 1366;
  {$EXTERNALSYM ERROR_LOGON_SESSION_COLLISION}

  { A logon request contained an invalid logon type value. }
  ERROR_INVALID_LOGON_TYPE = 1367;
  {$EXTERNALSYM ERROR_INVALID_LOGON_TYPE}

  { Unable to impersonate via a named pipe until data has been read }
  { from that pipe. }
  ERROR_CANNOT_IMPERSONATE = 1368;
  {$EXTERNALSYM ERROR_CANNOT_IMPERSONATE}

  { The transaction state of a Registry subtree is incompatible with the }
  { requested operation. }
  ERROR_RXACT_INVALID_STATE = 1369;
  {$EXTERNALSYM ERROR_RXACT_INVALID_STATE}

  { An internal security database corruption has been encountered. }
  ERROR_RXACT_COMMIT_FAILURE = 1370;
  {$EXTERNALSYM ERROR_RXACT_COMMIT_FAILURE}

  { Cannot perform this operation on built-in accounts. }
  ERROR_SPECIAL_ACCOUNT = 1371;
  {$EXTERNALSYM ERROR_SPECIAL_ACCOUNT}

  { Cannot perform this operation on this built-in special group. }
  ERROR_SPECIAL_GROUP = 1372;
  {$EXTERNALSYM ERROR_SPECIAL_GROUP}

  { Cannot perform this operation on this built-in special user. }
  ERROR_SPECIAL_USER = 1373;
  {$EXTERNALSYM ERROR_SPECIAL_USER}

  { The user cannot be removed from a group because the group }
  { is currently the user's primary group. }
  ERROR_MEMBERS_PRIMARY_GROUP = 1374;
  {$EXTERNALSYM ERROR_MEMBERS_PRIMARY_GROUP}

  { The token is already in use as a primary token. }
  ERROR_TOKEN_ALREADY_IN_USE = 1375;
  {$EXTERNALSYM ERROR_TOKEN_ALREADY_IN_USE}

  { The specified local group does not exist. }
  ERROR_NO_SUCH_ALIAS = 1376;
  {$EXTERNALSYM ERROR_NO_SUCH_ALIAS}

  { The specified account name is not a member of the local group. }
  ERROR_MEMBER_NOT_IN_ALIAS = 1377;
  {$EXTERNALSYM ERROR_MEMBER_NOT_IN_ALIAS}

  { The specified account name is already a member of the local group. }
  ERROR_MEMBER_IN_ALIAS = 1378;
  {$EXTERNALSYM ERROR_MEMBER_IN_ALIAS}

  { The specified local group already exists. }
  ERROR_ALIAS_EXISTS = 1379;
  {$EXTERNALSYM ERROR_ALIAS_EXISTS}

  { Logon failure: the user has not been granted the requested }
  { logon type at this computer. }
  ERROR_LOGON_NOT_GRANTED = 1380;
  {$EXTERNALSYM ERROR_LOGON_NOT_GRANTED}

  { The maximum number of secrets that may be stored in a single system has been }
  { exceeded. }
  ERROR_TOO_MANY_SECRETS = 1381;
  {$EXTERNALSYM ERROR_TOO_MANY_SECRETS}

  { The length of a secret exceeds the maximum length allowed. }
  ERROR_SECRET_TOO_LONG = 1382;
  {$EXTERNALSYM ERROR_SECRET_TOO_LONG}

  { The local security authority database contains an internal inconsistency. }
  ERROR_INTERNAL_DB_ERROR = 1383;
  {$EXTERNALSYM ERROR_INTERNAL_DB_ERROR}

  { During a logon attempt, the user's security context accumulated too many }
  { security IDs. }
  ERROR_TOO_MANY_CONTEXT_IDS = 1384;
  {$EXTERNALSYM ERROR_TOO_MANY_CONTEXT_IDS}

  { Logon failure: the user has not been granted the requested logon type }
  { at this computer. }
  ERROR_LOGON_TYPE_NOT_GRANTED = 1385;
  {$EXTERNALSYM ERROR_LOGON_TYPE_NOT_GRANTED}

  { A cross-encrypted password is necessary to change a user password. }
  ERROR_NT_CROSS_ENCRYPTION_REQUIRED = 1386;
  {$EXTERNALSYM ERROR_NT_CROSS_ENCRYPTION_REQUIRED}

  { A new member could not be added to a local group because the member does }
  { not exist. }
  ERROR_NO_SUCH_MEMBER = 1387;
  {$EXTERNALSYM ERROR_NO_SUCH_MEMBER}

  { A new member could not be added to a local group because the member has the }
  { wrong account type. }
  ERROR_INVALID_MEMBER = 1388;
  {$EXTERNALSYM ERROR_INVALID_MEMBER}

  { Too many security IDs have been specified. }
  ERROR_TOO_MANY_SIDS = 1389;
  {$EXTERNALSYM ERROR_TOO_MANY_SIDS}

  { A cross-encrypted password is necessary to change this user password. }
  ERROR_LM_CROSS_ENCRYPTION_REQUIRED = 1390;
  {$EXTERNALSYM ERROR_LM_CROSS_ENCRYPTION_REQUIRED}

  { Indicates an TACL contains no inheritable components }
  ERROR_NO_INHERITANCE = 1391;
  {$EXTERNALSYM ERROR_NO_INHERITANCE}

  { The file or directory is corrupt and non-readable. }
  ERROR_FILE_CORRUPT = 1392;
  {$EXTERNALSYM ERROR_FILE_CORRUPT}

  { The disk structure is corrupt and non-readable. }
  ERROR_DISK_CORRUPT = 1393;
  {$EXTERNALSYM ERROR_DISK_CORRUPT}

  { There is no user session key for the specified logon session. }
  ERROR_NO_USER_SESSION_KEY = 1394;
  {$EXTERNALSYM ERROR_NO_USER_SESSION_KEY}

  { The service being accessed is licensed for a particular number of connections. }
  { No more connections can be made to the service at this time }
  { because there are already as many connections as the service can accept. }
  ERROR_LICENSE_QUOTA_EXCEEDED = 1395;
  {$EXTERNALSYM ERROR_LICENSE_QUOTA_EXCEEDED}


{ WinUser Error Codes }

  { Invalid window handle. }
  ERROR_INVALID_WINDOW_HANDLE = 1400;
  {$EXTERNALSYM ERROR_INVALID_WINDOW_HANDLE}

  { Invalid menu handle. }
  ERROR_INVALID_MENU_HANDLE = 1401;
  {$EXTERNALSYM ERROR_INVALID_MENU_HANDLE}

  { Invalid cursor handle. }
  ERROR_INVALID_CURSOR_HANDLE = 1402;
  {$EXTERNALSYM ERROR_INVALID_CURSOR_HANDLE}

  { Invalid accelerator table handle. }
  ERROR_INVALID_ACCEL_HANDLE = 1403;
  {$EXTERNALSYM ERROR_INVALID_ACCEL_HANDLE}

  { Invalid hook handle. }
  ERROR_INVALID_HOOK_HANDLE = 1404;
  {$EXTERNALSYM ERROR_INVALID_HOOK_HANDLE}

  { Invalid handle to a multiple-window position structure. }
  ERROR_INVALID_DWP_HANDLE = 1405;
  {$EXTERNALSYM ERROR_INVALID_DWP_HANDLE}

  { Cannot create a top-level child window. }
  ERROR_TLW_WITH_WSCHILD = 1406;
  {$EXTERNALSYM ERROR_TLW_WITH_WSCHILD}

  { Cannot find window class. }
  ERROR_CANNOT_FIND_WND_CLASS = 1407;
  {$EXTERNALSYM ERROR_CANNOT_FIND_WND_CLASS}

  { Invalid window, belongs to other thread. }
  ERROR_WINDOW_OF_OTHER_THREAD = 1408;
  {$EXTERNALSYM ERROR_WINDOW_OF_OTHER_THREAD}

  { Hot key is already registered. }
  ERROR_HOTKEY_ALREADY_REGISTERED = 1409;
  {$EXTERNALSYM ERROR_HOTKEY_ALREADY_REGISTERED}

  { Class already exists. }
  ERROR_CLASS_ALREADY_EXISTS = 1410;
  {$EXTERNALSYM ERROR_CLASS_ALREADY_EXISTS}

  { Class does not exist. }
  ERROR_CLASS_DOES_NOT_EXIST = 1411;
  {$EXTERNALSYM ERROR_CLASS_DOES_NOT_EXIST}

  { Class still has open windows. }
  ERROR_CLASS_HAS_WINDOWS = 1412;
  {$EXTERNALSYM ERROR_CLASS_HAS_WINDOWS}

  { Invalid index. }
  ERROR_INVALID_INDEX = 1413;
  {$EXTERNALSYM ERROR_INVALID_INDEX}

  { Invalid icon handle. }
  ERROR_INVALID_ICON_HANDLE = 1414;
  {$EXTERNALSYM ERROR_INVALID_ICON_HANDLE}

  { Using private DIALOG window words. }
  ERROR_PRIVATE_DIALOG_INDEX = 1415;
  {$EXTERNALSYM ERROR_PRIVATE_DIALOG_INDEX}

  { The listbox identifier was not found. }
  ERROR_LISTBOX_ID_NOT_FOUND = 1416;
  {$EXTERNALSYM ERROR_LISTBOX_ID_NOT_FOUND}

  { No wildcards were found. }
  ERROR_NO_WILDCARD_CHARACTERS = 1417;
  {$EXTERNALSYM ERROR_NO_WILDCARD_CHARACTERS}

  { Thread does not have a clipboard open. }
  ERROR_CLIPBOARD_NOT_OPEN = 1418;
  {$EXTERNALSYM ERROR_CLIPBOARD_NOT_OPEN}

  { Hot key is not registered. }
  ERROR_HOTKEY_NOT_REGISTERED = 1419;
  {$EXTERNALSYM ERROR_HOTKEY_NOT_REGISTERED}

  { The window is not a valid dialog window. }
  ERROR_WINDOW_NOT_DIALOG = 1420;
  {$EXTERNALSYM ERROR_WINDOW_NOT_DIALOG}

  { Control ID not found. }
  ERROR_CONTROL_ID_NOT_FOUND = 1421;
  {$EXTERNALSYM ERROR_CONTROL_ID_NOT_FOUND}

  { Invalid message for a combo box because it does not have an edit control. }
  ERROR_INVALID_COMBOBOX_MESSAGE = 1422;
  {$EXTERNALSYM ERROR_INVALID_COMBOBOX_MESSAGE}

  { The window is not a combo box. }
  ERROR_WINDOW_NOT_COMBOBOX = 1423;
  {$EXTERNALSYM ERROR_WINDOW_NOT_COMBOBOX}

  { Height must be less than 256. }
  ERROR_INVALID_EDIT_HEIGHT = 1424;
  {$EXTERNALSYM ERROR_INVALID_EDIT_HEIGHT}

  { Invalid device context (DC) handle. }
  ERROR_DC_NOT_FOUND = 1425;
  {$EXTERNALSYM ERROR_DC_NOT_FOUND}

  { Invalid hook procedure type. }
  ERROR_INVALID_HOOK_FILTER = 1426;
  {$EXTERNALSYM ERROR_INVALID_HOOK_FILTER}

  { Invalid hook procedure. }
  ERROR_INVALID_FILTER_PROC = 1427;
  {$EXTERNALSYM ERROR_INVALID_FILTER_PROC}

  { Cannot set non-local hook without a module handle. }
  ERROR_HOOK_NEEDS_HMOD = 1428;
  {$EXTERNALSYM ERROR_HOOK_NEEDS_HMOD}

  { This hook procedure can only be set globally. }
  ERROR_GLOBAL_ONLY_HOOK = 1429;
  {$EXTERNALSYM ERROR_GLOBAL_ONLY_HOOK}

  { The journal hook procedure is already installed. }
  ERROR_JOURNAL_HOOK_SET = 1430;
  {$EXTERNALSYM ERROR_JOURNAL_HOOK_SET}

  { The hook procedure is not installed. }
  ERROR_HOOK_NOT_INSTALLED = 1431;
  {$EXTERNALSYM ERROR_HOOK_NOT_INSTALLED}

  { Invalid message for single-selection listbox. }
  ERROR_INVALID_LB_MESSAGE = 1432;
  {$EXTERNALSYM ERROR_INVALID_LB_MESSAGE}

  { LB_SETCOUNT sent to non-lazy listbox. }
  ERROR_SETCOUNT_ON_BAD_LB = 1433;
  {$EXTERNALSYM ERROR_SETCOUNT_ON_BAD_LB}

  { This list box does not support tab stops. }
  ERROR_LB_WITHOUT_TABSTOPS = 1434;
  {$EXTERNALSYM ERROR_LB_WITHOUT_TABSTOPS}

  { Cannot destroy object created by another thread. }
  ERROR_DESTROY_OBJECT_OF_OTHER_THREAD = 1435;
  {$EXTERNALSYM ERROR_DESTROY_OBJECT_OF_OTHER_THREAD}

  { Child windows cannot have menus. }
  ERROR_CHILD_WINDOW_MENU = 1436;
  {$EXTERNALSYM ERROR_CHILD_WINDOW_MENU}

  { The window does not have a system menu. }
  ERROR_NO_SYSTEM_MENU = 1437;
  {$EXTERNALSYM ERROR_NO_SYSTEM_MENU}

  { Invalid message box style. }
  ERROR_INVALID_MSGBOX_STYLE = 1438;
  {$EXTERNALSYM ERROR_INVALID_MSGBOX_STYLE}

  { Invalid system-wide (SPI_*) parameter. }
  ERROR_INVALID_SPI_VALUE = 1439;
  {$EXTERNALSYM ERROR_INVALID_SPI_VALUE}

  { Screen already locked. }
  ERROR_SCREEN_ALREADY_LOCKED = 1440;
  {$EXTERNALSYM ERROR_SCREEN_ALREADY_LOCKED}

  { All handles to windows in a multiple-window position structure must }
  { have the same parent. }
  ERROR_HWNDS_HAVE_DIFF_PARENT = 1441;
  {$EXTERNALSYM ERROR_HWNDS_HAVE_DIFF_PARENT}

  { The window is not a child window. }
  ERROR_NOT_CHILD_WINDOW = 1442;
  {$EXTERNALSYM ERROR_NOT_CHILD_WINDOW}

  { Invalid GW_* command. }
  ERROR_INVALID_GW_COMMAND = 1443;
  {$EXTERNALSYM ERROR_INVALID_GW_COMMAND}

  { Invalid thread identifier. }
  ERROR_INVALID_THREAD_ID = 1444;
  {$EXTERNALSYM ERROR_INVALID_THREAD_ID}

  { Cannot process a message from a window that is not a multiple document }
  { interface (MDI) window. }
  ERROR_NON_MDICHILD_WINDOW = 1445;
  {$EXTERNALSYM ERROR_NON_MDICHILD_WINDOW}

  { Popup menu already active. }
  ERROR_POPUP_ALREADY_ACTIVE = 1446;
  {$EXTERNALSYM ERROR_POPUP_ALREADY_ACTIVE}

  { The window does not have scroll bars. }
  ERROR_NO_SCROLLBARS = 1447;
  {$EXTERNALSYM ERROR_NO_SCROLLBARS}

  { Scroll bar range cannot be greater than $7FFF. }
  ERROR_INVALID_SCROLLBAR_RANGE = 1448;
  {$EXTERNALSYM ERROR_INVALID_SCROLLBAR_RANGE}

  { Cannot show or remove the window in the way specified. }
  ERROR_INVALID_SHOWWIN_COMMAND = 1449;
  {$EXTERNALSYM ERROR_INVALID_SHOWWIN_COMMAND}

  { Insufficient system resources exist to complete the requested service. }
  ERROR_NO_SYSTEM_RESOURCES = 1450;
  {$EXTERNALSYM ERROR_NO_SYSTEM_RESOURCES}

  { Insufficient system resources exist to complete the requested service. }
  ERROR_NONPAGED_SYSTEM_RESOURCES = 1451;
  {$EXTERNALSYM ERROR_NONPAGED_SYSTEM_RESOURCES}

  { Insufficient system resources exist to complete the requested service. }
  ERROR_PAGED_SYSTEM_RESOURCES = 1452;
  {$EXTERNALSYM ERROR_PAGED_SYSTEM_RESOURCES}

  { Insufficient quota to complete the requested service. }
  ERROR_WORKING_SET_QUOTA = 1453;
  {$EXTERNALSYM ERROR_WORKING_SET_QUOTA}

  { Insufficient quota to complete the requested service. }
  ERROR_PAGEFILE_QUOTA = 1454;
  {$EXTERNALSYM ERROR_PAGEFILE_QUOTA}

  { The paging file is too small for this operation to complete. }
  ERROR_COMMITMENT_LIMIT = 1455;
  {$EXTERNALSYM ERROR_COMMITMENT_LIMIT}

  { A menu item was not found. }
  ERROR_MENU_ITEM_NOT_FOUND = 1456;
  {$EXTERNALSYM ERROR_MENU_ITEM_NOT_FOUND}

  { Invalid keyboard layout handle. }
  ERROR_INVALID_KEYBOARD_HANDLE = 1457;
  {$EXTERNALSYM ERROR_INVALID_KEYBOARD_HANDLE}

  { Hook type not allowed. }
  ERROR_HOOK_TYPE_NOT_ALLOWED = 1458;
  {$EXTERNALSYM ERROR_HOOK_TYPE_NOT_ALLOWED}

  { This operation requires an interactive windowstation. }
  ERROR_REQUIRES_INTERACTIVE_WINDOWSTATION = 1459;
  {$EXTERNALSYM ERROR_REQUIRES_INTERACTIVE_WINDOWSTATION}

  { This operation returned because the timeout period expired. }
  ERROR_TIMEOUT = 1460;
  {$EXTERNALSYM ERROR_TIMEOUT}


{ Eventlog Status Codes }

  { The event log file is corrupt. }
  ERROR_EVENTLOG_FILE_CORRUPT = 1500;
  {$EXTERNALSYM ERROR_EVENTLOG_FILE_CORRUPT}

  { No event log file could be opened, so the event logging service did not start. }
  ERROR_EVENTLOG_CANT_START = 1501;
  {$EXTERNALSYM ERROR_EVENTLOG_CANT_START}

  { The event log file is full. }
  ERROR_LOG_FILE_FULL = 1502;
  {$EXTERNALSYM ERROR_LOG_FILE_FULL}

  { The event log file has changed between reads. }
  ERROR_EVENTLOG_FILE_CHANGED = 1503;
  {$EXTERNALSYM ERROR_EVENTLOG_FILE_CHANGED}


{ RPC Status Codes }

  { The string binding is invalid. }
  RPC_S_INVALID_STRING_BINDING = 1700;
  {$EXTERNALSYM RPC_S_INVALID_STRING_BINDING}

  { The binding handle is not the correct type. }
  RPC_S_WRONG_KIND_OF_BINDING = 1701;
  {$EXTERNALSYM RPC_S_WRONG_KIND_OF_BINDING}

  { The binding handle is invalid. }
  RPC_S_INVALID_BINDING = 1702;
  {$EXTERNALSYM RPC_S_INVALID_BINDING}

  { The RPC protocol sequence is not supported. }
  RPC_S_PROTSEQ_NOT_SUPPORTED = 1703;
  {$EXTERNALSYM RPC_S_PROTSEQ_NOT_SUPPORTED}

  { The RPC protocol sequence is invalid. }
  RPC_S_INVALID_RPC_PROTSEQ = 1704;
  {$EXTERNALSYM RPC_S_INVALID_RPC_PROTSEQ}

  { The string universal unique identifier (UUID) is invalid. }
  RPC_S_INVALID_STRING_UUID = 1705;
  {$EXTERNALSYM RPC_S_INVALID_STRING_UUID}

  { The endpoint format is invalid. }
  RPC_S_INVALID_ENDPOINT_FORMAT = 1706;
  {$EXTERNALSYM RPC_S_INVALID_ENDPOINT_FORMAT}

  { The network address is invalid. }
  RPC_S_INVALID_NET_ADDR = 1707;
  {$EXTERNALSYM RPC_S_INVALID_NET_ADDR}

  { No endpoint was found. }
  RPC_S_NO_ENDPOINT_FOUND = 1708;
  {$EXTERNALSYM RPC_S_NO_ENDPOINT_FOUND}

  { The timeout value is invalid. }
  RPC_S_INVALID_TIMEOUT = 1709;
  {$EXTERNALSYM RPC_S_INVALID_TIMEOUT}

  { The object universal unique identifier (UUID) was not found. }
  RPC_S_OBJECT_NOT_FOUND = 1710;
  {$EXTERNALSYM RPC_S_OBJECT_NOT_FOUND}

  { The object universal unique identifier (UUID) has already been registered. }
  RPC_S_ALREADY_REGISTERED = 1711;
  {$EXTERNALSYM RPC_S_ALREADY_REGISTERED}

  { The type universal unique identifier (UUID) has already been registered. }
  RPC_S_TYPE_ALREADY_REGISTERED = 1712;
  {$EXTERNALSYM RPC_S_TYPE_ALREADY_REGISTERED}

  { The RPC server is already listening. }
  RPC_S_ALREADY_LISTENING = 1713;
  {$EXTERNALSYM RPC_S_ALREADY_LISTENING}

  { No protocol sequences have been registered. }
  RPC_S_NO_PROTSEQS_REGISTERED = 1714;
  {$EXTERNALSYM RPC_S_NO_PROTSEQS_REGISTERED}

  { The RPC server is not listening. }
  RPC_S_NOT_LISTENING = 1715;
  {$EXTERNALSYM RPC_S_NOT_LISTENING}

  { The manager type is unknown. }
  RPC_S_UNKNOWN_MGR_TYPE = 1716;
  {$EXTERNALSYM RPC_S_UNKNOWN_MGR_TYPE}

  { The interface is unknown. }
  RPC_S_UNKNOWN_IF = 1717;
  {$EXTERNALSYM RPC_S_UNKNOWN_IF}

  { There are no bindings. }
  RPC_S_NO_BINDINGS = 1718;
  {$EXTERNALSYM RPC_S_NO_BINDINGS}

  { There are no protocol sequences. }
  RPC_S_NO_PROTSEQS = 1719;
  {$EXTERNALSYM RPC_S_NO_PROTSEQS}

  { The endpoint cannot be created. }
  RPC_S_CANT_CREATE_ENDPOINT = 1720;
  {$EXTERNALSYM RPC_S_CANT_CREATE_ENDPOINT}

  { Not enough resources are available to complete this operation. }
  RPC_S_OUT_OF_RESOURCES = 1721;
  {$EXTERNALSYM RPC_S_OUT_OF_RESOURCES}

  { The RPC server is unavailable. }
  RPC_S_SERVER_UNAVAILABLE = 1722;
  {$EXTERNALSYM RPC_S_SERVER_UNAVAILABLE}

  { The RPC server is too busy to complete this operation. }
  RPC_S_SERVER_TOO_BUSY = 1723;
  {$EXTERNALSYM RPC_S_SERVER_TOO_BUSY}

  { The network options are invalid. }
  RPC_S_INVALID_NETWORK_OPTIONS = 1724;
  {$EXTERNALSYM RPC_S_INVALID_NETWORK_OPTIONS}

  { There is not a remote procedure call active in this thread. }
  RPC_S_NO_CALL_ACTIVE = 1725;
  {$EXTERNALSYM RPC_S_NO_CALL_ACTIVE}

  { The remote procedure call failed. }
  RPC_S_CALL_FAILED = 1726;
  {$EXTERNALSYM RPC_S_CALL_FAILED}

  { The remote procedure call failed and did not execute. }
  RPC_S_CALL_FAILED_DNE = 1727;
  {$EXTERNALSYM RPC_S_CALL_FAILED_DNE}

  { A remote procedure call (RPC) protocol error occurred. }
  RPC_S_PROTOCOL_ERROR = 1728;
  {$EXTERNALSYM RPC_S_PROTOCOL_ERROR}

  { The transfer syntax is not supported by the RPC server. }
  RPC_S_UNSUPPORTED_TRANS_SYN = 1730;
  {$EXTERNALSYM RPC_S_UNSUPPORTED_TRANS_SYN}

  { The universal unique identifier (UUID) type is not supported. }
  RPC_S_UNSUPPORTED_TYPE = 1732;
  {$EXTERNALSYM RPC_S_UNSUPPORTED_TYPE}

  { The tag is invalid. }
  RPC_S_INVALID_TAG = 1733;
  {$EXTERNALSYM RPC_S_INVALID_TAG}

  { The array bounds are invalid. }
  RPC_S_INVALID_BOUND = 1734;
  {$EXTERNALSYM RPC_S_INVALID_BOUND}

  { The binding does not contain an entry name. }
  RPC_S_NO_ENTRY_NAME = 1735;
  {$EXTERNALSYM RPC_S_NO_ENTRY_NAME}

  { The name syntax is invalid. }
  RPC_S_INVALID_NAME_SYNTAX = 1736;
  {$EXTERNALSYM RPC_S_INVALID_NAME_SYNTAX}

  { The name syntax is not supported. }
  RPC_S_UNSUPPORTED_NAME_SYNTAX = 1737;
  {$EXTERNALSYM RPC_S_UNSUPPORTED_NAME_SYNTAX}

  { No network address is available to use to construct a universal }

  { unique identifier (UUID). }
  RPC_S_UUID_NO_ADDRESS = 1739;
  {$EXTERNALSYM RPC_S_UUID_NO_ADDRESS}

  { The endpoint is a duplicate. }
  RPC_S_DUPLICATE_ENDPOINT = 1740;
  {$EXTERNALSYM RPC_S_DUPLICATE_ENDPOINT}

  { The authentication type is unknown. }
  RPC_S_UNKNOWN_AUTHN_TYPE = 1741;
  {$EXTERNALSYM RPC_S_UNKNOWN_AUTHN_TYPE}

  { The maximum number of calls is too small. }
  RPC_S_MAX_CALLS_TOO_SMALL = 1742;
  {$EXTERNALSYM RPC_S_MAX_CALLS_TOO_SMALL}

  { The string is too long. }
  RPC_S_STRING_TOO_LONG = 1743;
  {$EXTERNALSYM RPC_S_STRING_TOO_LONG}

  { The RPC protocol sequence was not found. }
  RPC_S_PROTSEQ_NOT_FOUND = 1744;
  {$EXTERNALSYM RPC_S_PROTSEQ_NOT_FOUND}

  { The procedure number is out of range. }
  RPC_S_PROCNUM_OUT_OF_RANGE = 1745;
  {$EXTERNALSYM RPC_S_PROCNUM_OUT_OF_RANGE}

  { The binding does not contain any authentication information. }
  RPC_S_BINDING_HAS_NO_AUTH = 1746;
  {$EXTERNALSYM RPC_S_BINDING_HAS_NO_AUTH}

  { The authentication service is unknown. }
  RPC_S_UNKNOWN_AUTHN_SERVICE = 1747;
  {$EXTERNALSYM RPC_S_UNKNOWN_AUTHN_SERVICE}

  { The authentication level is unknown. }
  RPC_S_UNKNOWN_AUTHN_LEVEL = 1748;
  {$EXTERNALSYM RPC_S_UNKNOWN_AUTHN_LEVEL}

  { The security context is invalid. }
  RPC_S_INVALID_AUTH_IDENTITY = 1749;
  {$EXTERNALSYM RPC_S_INVALID_AUTH_IDENTITY}

  { The authorization service is unknown. }
  RPC_S_UNKNOWN_AUTHZ_SERVICE = 1750;
  {$EXTERNALSYM RPC_S_UNKNOWN_AUTHZ_SERVICE}

  { The entry is invalid. }
  EPT_S_INVALID_ENTRY = 1751;
  {$EXTERNALSYM EPT_S_INVALID_ENTRY}

  { The server endpoint cannot perform the operation. }
  EPT_S_CANT_PERFORM_OP = 1752;
  {$EXTERNALSYM EPT_S_CANT_PERFORM_OP}

  { There are no more endpoints available from the endpoint mapper. }
  EPT_S_NOT_REGISTERED = 1753;
  {$EXTERNALSYM EPT_S_NOT_REGISTERED}

  { No interfaces have been exported. }
  RPC_S_NOTHING_TO_EXPORT = 1754;
  {$EXTERNALSYM RPC_S_NOTHING_TO_EXPORT}

  { The entry name is incomplete. }
  RPC_S_INCOMPLETE_NAME = 1755;
  {$EXTERNALSYM RPC_S_INCOMPLETE_NAME}

  { The version option is invalid. }
  RPC_S_INVALID_VERS_OPTION = 1756;
  {$EXTERNALSYM RPC_S_INVALID_VERS_OPTION}

  { There are no more members. }
  RPC_S_NO_MORE_MEMBERS = 1757;
  {$EXTERNALSYM RPC_S_NO_MORE_MEMBERS}

  { There is nothing to unexport. }
  RPC_S_NOT_ALL_OBJS_UNEXPORTED = 1758;
  {$EXTERNALSYM RPC_S_NOT_ALL_OBJS_UNEXPORTED}

  { The interface was not found. }
  RPC_S_INTERFACE_NOT_FOUND = 1759;
  {$EXTERNALSYM RPC_S_INTERFACE_NOT_FOUND}

  { The entry already exists. }
  RPC_S_ENTRY_ALREADY_EXISTS = 1760;
  {$EXTERNALSYM RPC_S_ENTRY_ALREADY_EXISTS}

  { The entry is not found. }
  RPC_S_ENTRY_NOT_FOUND = 1761;
  {$EXTERNALSYM RPC_S_ENTRY_NOT_FOUND}

  { The name service is unavailable. }
  RPC_S_NAME_SERVICE_UNAVAILABLE = 1762;
  {$EXTERNALSYM RPC_S_NAME_SERVICE_UNAVAILABLE}

  { The network address family is invalid. }
  RPC_S_INVALID_NAF_ID = 1763;
  {$EXTERNALSYM RPC_S_INVALID_NAF_ID}

  { The requested operation is not supported. }
  RPC_S_CANNOT_SUPPORT = 1764;
  {$EXTERNALSYM RPC_S_CANNOT_SUPPORT}

  { No security context is available to allow impersonation. }
  RPC_S_NO_CONTEXT_AVAILABLE = 1765;
  {$EXTERNALSYM RPC_S_NO_CONTEXT_AVAILABLE}

  { An internal error occurred in a remote procedure call (RPC). }
  RPC_S_INTERNAL_ERROR = 1766;
  {$EXTERNALSYM RPC_S_INTERNAL_ERROR}

  { The RPC server attempted an integer division by zero. }
  RPC_S_ZERO_DIVIDE = 1767;
  {$EXTERNALSYM RPC_S_ZERO_DIVIDE}

  { An addressing error occurred in the RPC server. }
  RPC_S_ADDRESS_ERROR = 1768;
  {$EXTERNALSYM RPC_S_ADDRESS_ERROR}

  { A floating-point operation at the RPC server caused a division by zero. }
  RPC_S_FP_DIV_ZERO = 1769;
  {$EXTERNALSYM RPC_S_FP_DIV_ZERO}

  { A floating-point underflow occurred at the RPC server. }
  RPC_S_FP_UNDERFLOW = 1770;
  {$EXTERNALSYM RPC_S_FP_UNDERFLOW}

  { A floating-point overflow occurred at the RPC server. }
  RPC_S_FP_OVERFLOW = 1771;
  {$EXTERNALSYM RPC_S_FP_OVERFLOW}

  { The list of RPC servers available for the binding of auto handles }
  { has been exhausted. }
  RPC_X_NO_MORE_ENTRIES = 1772;
  {$EXTERNALSYM RPC_X_NO_MORE_ENTRIES}

  { Unable to open the character translation table file. }
  RPC_X_SS_CHAR_TRANS_OPEN_FAIL = 1773;
  {$EXTERNALSYM RPC_X_SS_CHAR_TRANS_OPEN_FAIL}

  { The file containing the character translation table has fewer than }
  { 512 bytes. }
  RPC_X_SS_CHAR_TRANS_SHORT_FILE = 1774;
  {$EXTERNALSYM RPC_X_SS_CHAR_TRANS_SHORT_FILE}

  { A null context handle was passed from the client to the host during }
  { a remote procedure call. }
  RPC_X_SS_IN_NULL_CONTEXT = 1775;
  {$EXTERNALSYM RPC_X_SS_IN_NULL_CONTEXT}

  { The context handle changed during a remote procedure call. }
  RPC_X_SS_CONTEXT_DAMAGED = 1777;
  {$EXTERNALSYM RPC_X_SS_CONTEXT_DAMAGED}

  { The binding handles passed to a remote procedure call do not match. }
  RPC_X_SS_HANDLES_MISMATCH = 1778;
  {$EXTERNALSYM RPC_X_SS_HANDLES_MISMATCH}

  { The stub is unable to get the remote procedure call handle. }
  RPC_X_SS_CANNOT_GET_CALL_HANDLE = 1779;
  {$EXTERNALSYM RPC_X_SS_CANNOT_GET_CALL_HANDLE}

  { A null reference pointer was passed to the stub. }
  RPC_X_NULL_REF_POINTER = 1780;
  {$EXTERNALSYM RPC_X_NULL_REF_POINTER}

  { The enumeration value is out of range. }
  RPC_X_ENUM_VALUE_OUT_OF_RANGE = 1781;
  {$EXTERNALSYM RPC_X_ENUM_VALUE_OUT_OF_RANGE}

  { The byte count is too small. }
  RPC_X_BYTE_COUNT_TOO_SMALL = 1782;
  {$EXTERNALSYM RPC_X_BYTE_COUNT_TOO_SMALL}

  { The stub received bad data. }
  RPC_X_BAD_STUB_DATA = 1783;
  {$EXTERNALSYM RPC_X_BAD_STUB_DATA}

  { The supplied user buffer is not valid for the requested operation. }
  ERROR_INVALID_USER_BUFFER = 1784;
  {$EXTERNALSYM ERROR_INVALID_USER_BUFFER}

  { The disk media is not recognized.  It may not be formatted. }
  ERROR_UNRECOGNIZED_MEDIA = 1785;
  {$EXTERNALSYM ERROR_UNRECOGNIZED_MEDIA}

  { The workstation does not have a trust secret. }
  ERROR_NO_TRUST_LSA_SECRET = 1786;
  {$EXTERNALSYM ERROR_NO_TRUST_LSA_SECRET}

  { The SAM database on the Windows NT Server does not have a computer }
  { account for this workstation trust relationship. }
  ERROR_NO_TRUST_SAM_ACCOUNT = 1787;
  {$EXTERNALSYM ERROR_NO_TRUST_SAM_ACCOUNT}

  { The trust relationship between the primary domain and the trusted }
  { domain failed. }
  ERROR_TRUSTED_DOMAIN_FAILURE = 1788;
  {$EXTERNALSYM ERROR_TRUSTED_DOMAIN_FAILURE}

  { The trust relationship between this workstation and the primary }
  { domain failed. }
  ERROR_TRUSTED_RELATIONSHIP_FAILURE = 1789;
  {$EXTERNALSYM ERROR_TRUSTED_RELATIONSHIP_FAILURE}

  { The network logon failed. }
  ERROR_TRUST_FAILURE = 1790;
  {$EXTERNALSYM ERROR_TRUST_FAILURE}

  { A remote procedure call is already in progress for this thread. }
  RPC_S_CALL_IN_PROGRESS = 1791;
  {$EXTERNALSYM RPC_S_CALL_IN_PROGRESS}

  { An attempt was made to logon, but the network logon service was not started. }
  ERROR_NETLOGON_NOT_STARTED = 1792;
  {$EXTERNALSYM ERROR_NETLOGON_NOT_STARTED}

  { The user's account has expired. }
  ERROR_ACCOUNT_EXPIRED = 1793;
  {$EXTERNALSYM ERROR_ACCOUNT_EXPIRED}

  { The redirector is in use and cannot be unloaded. }
  ERROR_REDIRECTOR_HAS_OPEN_HANDLES = 1794;
  {$EXTERNALSYM ERROR_REDIRECTOR_HAS_OPEN_HANDLES}

  { The specified printer driver is already installed. }
  ERROR_PRINTER_DRIVER_ALREADY_INSTALLED = 1795;
  {$EXTERNALSYM ERROR_PRINTER_DRIVER_ALREADY_INSTALLED}

  { The specified port is unknown. }
  ERROR_UNKNOWN_PORT = 1796;
  {$EXTERNALSYM ERROR_UNKNOWN_PORT}

  { The printer driver is unknown. }
  ERROR_UNKNOWN_PRINTER_DRIVER = 1797;
  {$EXTERNALSYM ERROR_UNKNOWN_PRINTER_DRIVER}

  { The print processor is unknown. }
  ERROR_UNKNOWN_PRINTPROCESSOR = 1798;
  {$EXTERNALSYM ERROR_UNKNOWN_PRINTPROCESSOR}

  { The specified separator file is invalid. }
  ERROR_INVALID_SEPARATOR_FILE = 1799;
  {$EXTERNALSYM ERROR_INVALID_SEPARATOR_FILE}

  { The specified priority is invalid. }
  ERROR_INVALID_PRIORITY = 1800;
  {$EXTERNALSYM ERROR_INVALID_PRIORITY}

  { The printer name is invalid. }
  ERROR_INVALID_PRINTER_NAME = 1801;
  {$EXTERNALSYM ERROR_INVALID_PRINTER_NAME}

  { The printer already exists. }
  ERROR_PRINTER_ALREADY_EXISTS = 1802;
  {$EXTERNALSYM ERROR_PRINTER_ALREADY_EXISTS}

  { The printer command is invalid. }
  ERROR_INVALID_PRINTER_COMMAND = 1803;
  {$EXTERNALSYM ERROR_INVALID_PRINTER_COMMAND}

  { The specified datatype is invalid. }
  ERROR_INVALID_DATATYPE = 1804;
  {$EXTERNALSYM ERROR_INVALID_DATATYPE}

  { The Environment specified is invalid. }
  ERROR_INVALID_ENVIRONMENT = 1805;
  {$EXTERNALSYM ERROR_INVALID_ENVIRONMENT}

  { There are no more bindings. }
  RPC_S_NO_MORE_BINDINGS = 1806;
  {$EXTERNALSYM RPC_S_NO_MORE_BINDINGS}

  { The account used is an interdomain trust account.  Use your global user account or local user account to access this server. }
  ERROR_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT = 1807;
  {$EXTERNALSYM ERROR_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT}

  { The account used is a Computer Account.  Use your global user account or local user account to access this server. }
  ERROR_NOLOGON_WORKSTATION_TRUST_ACCOUNT = 1808;
  {$EXTERNALSYM ERROR_NOLOGON_WORKSTATION_TRUST_ACCOUNT}

  { The account used is an server trust account.  Use your global user account or local user account to access this server. }
  ERROR_NOLOGON_SERVER_TRUST_ACCOUNT = 1809;
  {$EXTERNALSYM ERROR_NOLOGON_SERVER_TRUST_ACCOUNT}

  { The name or security ID (SID) of the domain specified is inconsistent }
  { with the trust information for that domain. }
  ERROR_DOMAIN_TRUST_INCONSISTENT = 1810;
  {$EXTERNALSYM ERROR_DOMAIN_TRUST_INCONSISTENT}

  { The server is in use and cannot be unloaded. }
  ERROR_SERVER_HAS_OPEN_HANDLES = 1811;
  {$EXTERNALSYM ERROR_SERVER_HAS_OPEN_HANDLES}

  { The specified image file did not contain a resource section. }
  ERROR_RESOURCE_DATA_NOT_FOUND = 1812;
  {$EXTERNALSYM ERROR_RESOURCE_DATA_NOT_FOUND}

  { The specified resource type can not be found in the image file. }
  ERROR_RESOURCE_TYPE_NOT_FOUND = 1813;
  {$EXTERNALSYM ERROR_RESOURCE_TYPE_NOT_FOUND}

  { The specified resource name can not be found in the image file. }
  ERROR_RESOURCE_NAME_NOT_FOUND = 1814;
  {$EXTERNALSYM ERROR_RESOURCE_NAME_NOT_FOUND}

  { The specified resource language ID cannot be found in the image file. }
  ERROR_RESOURCE_LANG_NOT_FOUND = 1815;
  {$EXTERNALSYM ERROR_RESOURCE_LANG_NOT_FOUND}

  { Not enough quota is available to process this command. }
  ERROR_NOT_ENOUGH_QUOTA = 1816;
  {$EXTERNALSYM ERROR_NOT_ENOUGH_QUOTA}

  { No interfaces have been registered. }
  RPC_S_NO_INTERFACES = 1817;
  {$EXTERNALSYM RPC_S_NO_INTERFACES}

  { The server was altered while processing this call. }
  RPC_S_CALL_CANCELLED = 1818;
  {$EXTERNALSYM RPC_S_CALL_CANCELLED}

  { The binding handle does not contain all required information. }
  RPC_S_BINDING_INCOMPLETE = 1819;
  {$EXTERNALSYM RPC_S_BINDING_INCOMPLETE}

  { Communications failure. }
  RPC_S_COMM_FAILURE = 1820;
  {$EXTERNALSYM RPC_S_COMM_FAILURE}

  { The requested authentication level is not supported. }
  RPC_S_UNSUPPORTED_AUTHN_LEVEL = 1821;
  {$EXTERNALSYM RPC_S_UNSUPPORTED_AUTHN_LEVEL}

  { No principal name registered. }
  RPC_S_NO_PRINC_NAME = 1822;
  {$EXTERNALSYM RPC_S_NO_PRINC_NAME}

  { The error specified is not a valid Windows NT RPC error code. }
  RPC_S_NOT_RPC_ERROR = 1823;
  {$EXTERNALSYM RPC_S_NOT_RPC_ERROR}

  { A UUID that is valid only on this computer has been allocated. }
  RPC_S_UUID_LOCAL_ONLY = 1824;
  {$EXTERNALSYM RPC_S_UUID_LOCAL_ONLY}

  { A security package specific error occurred. }
  RPC_S_SEC_PKG_ERROR = 1825;
  {$EXTERNALSYM RPC_S_SEC_PKG_ERROR}

  { Thread is not cancelled. }
  RPC_S_NOT_CANCELLED = 1826;
  {$EXTERNALSYM RPC_S_NOT_CANCELLED}

  { Invalid operation on the encoding/decoding handle. }
  RPC_X_INVALID_ES_ACTION = 1827;
  {$EXTERNALSYM RPC_X_INVALID_ES_ACTION}

  { Incompatible version of the serializing package. }
  RPC_X_WRONG_ES_VERSION = 1828;
  {$EXTERNALSYM RPC_X_WRONG_ES_VERSION}

  { Incompatible version of the RPC stub. }
  RPC_X_WRONG_STUB_VERSION = 1829;
  {$EXTERNALSYM RPC_X_WRONG_STUB_VERSION}

  { The idl pipe object is invalid or corrupted. }
  RPC_X_INVALID_PIPE_OBJECT = 1830;
  {$EXTERNALSYM RPC_X_INVALID_PIPE_OBJECT}

  { The operation is invalid for a given idl pipe object. }
  RPC_X_INVALID_PIPE_OPERATION = 1831;
  {$EXTERNALSYM RPC_X_INVALID_PIPE_OPERATION}

  { The idl pipe version is not supported. }
  RPC_X_WRONG_PIPE_VERSION = 1832;
  {$EXTERNALSYM RPC_X_WRONG_PIPE_VERSION}

  { The group member was not found. }
  RPC_S_GROUP_MEMBER_NOT_FOUND = 1898;
  {$EXTERNALSYM RPC_S_GROUP_MEMBER_NOT_FOUND}

  { The endpoint mapper database could not be created. }
  EPT_S_CANT_CREATE = 1899;
  {$EXTERNALSYM EPT_S_CANT_CREATE}

  { The object universal unique identifier (UUID) is the nil UUID. }
  RPC_S_INVALID_OBJECT = 1900;
  {$EXTERNALSYM RPC_S_INVALID_OBJECT}

  { The specified time is invalid. }
  ERROR_INVALID_TIME = 1901;
  {$EXTERNALSYM ERROR_INVALID_TIME}

  { The specified Form name is invalid. }
  ERROR_INVALID_FORM_NAME = 1902;
  {$EXTERNALSYM ERROR_INVALID_FORM_NAME}

  { The specified Form size is invalid }
  ERROR_INVALID_FORM_SIZE = 1903;
  {$EXTERNALSYM ERROR_INVALID_FORM_SIZE}

  { The specified Printer handle is already being waited on }
  ERROR_ALREADY_WAITING = 1904;
  {$EXTERNALSYM ERROR_ALREADY_WAITING}

  { The specified Printer has been deleted }
  ERROR_PRINTER_DELETED = 1905;
  {$EXTERNALSYM ERROR_PRINTER_DELETED}

  { The state of the Printer is invalid }
  ERROR_INVALID_PRINTER_STATE = 1906;
  {$EXTERNALSYM ERROR_INVALID_PRINTER_STATE}

  { The user must change his password before he logs on the first time. }
  ERROR_PASSWORD_MUST_CHANGE = 1907;
  {$EXTERNALSYM ERROR_PASSWORD_MUST_CHANGE}

  { Could not find the domain controller for this domain. }
  ERROR_DOMAIN_CONTROLLER_NOT_FOUND = 1908;
  {$EXTERNALSYM ERROR_DOMAIN_CONTROLLER_NOT_FOUND}

  { The referenced account is currently locked out and may not be logged on to. }
  ERROR_ACCOUNT_LOCKED_OUT = 1909;
  {$EXTERNALSYM ERROR_ACCOUNT_LOCKED_OUT}

  { The object exporter specified was not found. }
  OR_INVALID_OXID = 1910;
  {$EXTERNALSYM OR_INVALID_OXID}

  { The object specified was not found. }
  OR_INVALID_OID = 1911;
  {$EXTERNALSYM OR_INVALID_OID}

  { The object resolver set specified was not found. }
  OR_INVALID_SET = 1912;
  {$EXTERNALSYM OR_INVALID_SET}

  { Some data remains to be sent in the request buffer. }
  RPC_S_SEND_INCOMPLETE = 1913;
  {$EXTERNALSYM RPC_S_SEND_INCOMPLETE}

  { The list of servers for this workgroup is not currently available }
  ERROR_NO_BROWSER_SERVERS_FOUND = 6118;
  {$EXTERNALSYM ERROR_NO_BROWSER_SERVERS_FOUND}


{ OpenGL Error Code }

  { The pixel format is invalid. }
  ERROR_INVALID_PIXEL_FORMAT = 2000;
  {$EXTERNALSYM ERROR_INVALID_PIXEL_FORMAT}

  { The specified driver is invalid. }
  ERROR_BAD_DRIVER = 2001;
  {$EXTERNALSYM ERROR_BAD_DRIVER}

  { The window style or class attribute is invalid for this operation. }
  ERROR_INVALID_WINDOW_STYLE = 2002;
  {$EXTERNALSYM ERROR_INVALID_WINDOW_STYLE}

  { The requested metafile operation is not supported. }
  ERROR_METAFILE_NOT_SUPPORTED = 2003;
  {$EXTERNALSYM ERROR_METAFILE_NOT_SUPPORTED}

  { The requested transformation operation is not supported. }
  ERROR_TRANSFORM_NOT_SUPPORTED = 2004;
  {$EXTERNALSYM ERROR_TRANSFORM_NOT_SUPPORTED}

  { The requested clipping operation is not supported. }
  ERROR_CLIPPING_NOT_SUPPORTED = 2005;
  {$EXTERNALSYM ERROR_CLIPPING_NOT_SUPPORTED}


{ Win32 Spooler Error Codes }

  { The specified print monitor is unknown. }
  ERROR_UNKNOWN_PRINT_MONITOR = 3000;
  {$EXTERNALSYM ERROR_UNKNOWN_PRINT_MONITOR}

  { The specified printer driver is currently in use. }
  ERROR_PRINTER_DRIVER_IN_USE = 3001;
  {$EXTERNALSYM ERROR_PRINTER_DRIVER_IN_USE}

  { The spool file was not found. }
  ERROR_SPOOL_FILE_NOT_FOUND = 3002;
  {$EXTERNALSYM ERROR_SPOOL_FILE_NOT_FOUND}

  { A StartDocPrinter call was not issued. }
  ERROR_SPL_NO_STARTDOC = 3003;
  {$EXTERNALSYM ERROR_SPL_NO_STARTDOC}

  { An AddJob call was not issued. }
  ERROR_SPL_NO_ADDJOB = 3004;
  {$EXTERNALSYM ERROR_SPL_NO_ADDJOB}

  { The specified print processor has already been installed. }
  ERROR_PRINT_PROCESSOR_ALREADY_INSTALLED = 3005;
  {$EXTERNALSYM ERROR_PRINT_PROCESSOR_ALREADY_INSTALLED}

  { The specified print monitor has already been installed. }
  ERROR_PRINT_MONITOR_ALREADY_INSTALLED = 3006;
  {$EXTERNALSYM ERROR_PRINT_MONITOR_ALREADY_INSTALLED}

  { The specified print monitor does not have the required functions. }
  ERROR_INVALID_PRINT_MONITOR = 3007;
  {$EXTERNALSYM ERROR_INVALID_PRINT_MONITOR}

  { The specified print monitor is currently in use. }
  ERROR_PRINT_MONITOR_IN_USE = 3008;
  {$EXTERNALSYM ERROR_PRINT_MONITOR_IN_USE}

  { The requested operation is not allowed when there are jobs queued to the printer. }
  ERROR_PRINTER_HAS_JOBS_QUEUED = 3009;
  {$EXTERNALSYM ERROR_PRINTER_HAS_JOBS_QUEUED}

  { The requested operation is successful.  Changes will not be effective until the system is rebooted. }
  ERROR_SUCCESS_REBOOT_REQUIRED = 3010;
  {$EXTERNALSYM ERROR_SUCCESS_REBOOT_REQUIRED}

  { The requested operation is successful.  Changes will not be effective until the service is restarted. }
  ERROR_SUCCESS_RESTART_REQUIRED = 3011;
  {$EXTERNALSYM ERROR_SUCCESS_RESTART_REQUIRED}


{ Wins Error Codes }

  { WINS encountered an error while processing the command. }
  ERROR_WINS_INTERNAL = 4000;
  {$EXTERNALSYM ERROR_WINS_INTERNAL}

  { The local WINS can not be deleted. }
  ERROR_CAN_NOT_DEL_LOCAL_WINS = 4001;
  {$EXTERNALSYM ERROR_CAN_NOT_DEL_LOCAL_WINS}

  { The importation from the file failed. }
  ERROR_STATIC_INIT = 4002;
  {$EXTERNALSYM ERROR_STATIC_INIT}

  { The backup Failed.  Was a full backup done before ? }
  ERROR_INC_BACKUP = 4003;
  {$EXTERNALSYM ERROR_INC_BACKUP}

  { The backup Failed.  Check the directory that you are backing the database to. }
  ERROR_FULL_BACKUP = 4004;
  {$EXTERNALSYM ERROR_FULL_BACKUP}

  { The name does not exist in the WINS database. }
  ERROR_REC_NON_EXISTENT = 4005;
  {$EXTERNALSYM ERROR_REC_NON_EXISTENT}

  { Replication with a non-configured partner is not allowed. }
  ERROR_RPL_NOT_ALLOWED = 4006;
  {$EXTERNALSYM ERROR_RPL_NOT_ALLOWED}


{------------------------------}
{     OLE Error Codes          }
{------------------------------}

(*
  The return value of OLE APIs and methods is an HRESULT.
  This is not a handle to anything, but is merely a 32-bit value
  with several fields encoded in the value.  The parts of an
  HRESULT are shown below.

  HRESULTs are 32 bit values layed out as follows:

   3 3 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1
   1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0
  +-+-+-+-+-+---------------------+-------------------------------+
  |S|R|C|N|r|    Facility         |               Code            |
  +-+-+-+-+-+---------------------+-------------------------------+

  where

      S - Severity - indicates success/fail
          0 - Success
          1 - Fail (COERROR)

      R - reserved portion of the facility code, corresponds to NT's
              second severity bit.

      C - reserved portion of the facility code, corresponds to NT's
              C field.

      N - reserved portion of the facility code. Used to indicate a
              mapped NT status value.

      r - reserved portion of the facility code. Reserved for internal
              use. Used to indicate HRESULT values that are not status
              values, but are instead message ids for display strings.

      Facility - is the facility code

      Code - is the facility's status code
*)

const
  { Severity values }
  SEVERITY_SUCCESS = 0;
  {$EXTERNALSYM SEVERITY_SUCCESS}
  SEVERITY_ERROR = 1;
  {$EXTERNALSYM SEVERITY_ERROR}

{$EXTERNALSYM Succeeded}
function Succeeded(Status: HRESULT): BOOL; inline;

{$EXTERNALSYM Failed}
{ and the inverse }
function Failed(Status: HRESULT): BOOL; inline;

{$EXTERNALSYM IsError}
{ Generic test for error on any status value. }
function IsError(Status: HRESULT): BOOL; inline;

{ Return the code }
function HResultCode(hr: HRESULT): Integer; inline;

{ Return the facility }
function HResultFacility(hr: HRESULT): Integer; inline;

{ Return the severity }
function HResultSeverity(hr: HRESULT): Integer; inline;

{ Create an HRESULT value from component pieces }
function MakeResult(sev, fac, code: Integer): HResult; inline;
{$EXTERNALSYM MakeResult}

{ Map a WIN32 error value into a HRESULT }
{ Note: This assumes that WIN32 errors fall in the range -32k to 32k. }
const
  { Define bits here so macros are guaranteed to work }
  FACILITY_NT_BIT = $10000000;
  {$EXTERNALSYM FACILITY_NT_BIT}
function HResultFromWin32(x: Integer): HRESULT; inline;

{ Map an NT status value into a HRESULT }
function HResultFromNT(x: Integer): HRESULT; inline;

const
  { HRESULT value definitions }
  { Codes $4000-$40ff are reserved for OLE }

  { Success codes }
  S_OK    = $00000000;
  {$EXTERNALSYM S_OK}
  S_FALSE = $00000001;
  {$EXTERNALSYM S_FALSE}

  NOERROR = 0;
  {$EXTERNALSYM NOERROR}

  { Catastrophic failure }
  E_UNEXPECTED = HRESULT($8000FFFF);
  {$EXTERNALSYM E_UNEXPECTED}

  { Not implemented }
  E_NOTIMPL = HRESULT($80004001);
  {$EXTERNALSYM E_NOTIMPL}

  { Ran out of memory }
  E_OUTOFMEMORY = HRESULT($8007000E);
  {$EXTERNALSYM E_OUTOFMEMORY}

  { One or more arguments are invalid }
  E_INVALIDARG = HRESULT($80070057);
  {$EXTERNALSYM E_INVALIDARG}

  { No such interface supported }
  E_NOINTERFACE = HRESULT($80004002);
  {$EXTERNALSYM E_NOINTERFACE}

  { Invalid pointer }
  E_POINTER = HRESULT($80004003);
  {$EXTERNALSYM E_POINTER}

  { Invalid handle }
  E_HANDLE = HRESULT($80070006);
  {$EXTERNALSYM E_HANDLE}

  { Operation aborted }
  E_ABORT = HRESULT($80004004);
  {$EXTERNALSYM E_ABORT}

  { Unspecified error }
  E_FAIL = HRESULT($80004005);
  {$EXTERNALSYM E_FAIL}

  { General access denied error }
  E_ACCESSDENIED = HRESULT($80070005);
  {$EXTERNALSYM E_ACCESSDENIED}

  { The data necessary to complete this operation is not yet available. }
  E_PENDING = HRESULT($8000000A);
  {$EXTERNALSYM E_PENDING}

  { Thread local storage failure }
  CO_E_INIT_TLS = HRESULT($80004006);
  {$EXTERNALSYM CO_E_INIT_TLS}

  { Get shared memory allocator failure }
  CO_E_INIT_SHARED_ALLOCATOR = HRESULT($80004007);
  {$EXTERNALSYM CO_E_INIT_SHARED_ALLOCATOR}

  { Get memory allocator failure }
  CO_E_INIT_MEMORY_ALLOCATOR = HRESULT($80004008);
  {$EXTERNALSYM CO_E_INIT_MEMORY_ALLOCATOR}

  { Unable to initialize class cache }
  CO_E_INIT_CLASS_CACHE = HRESULT($80004009);
  {$EXTERNALSYM CO_E_INIT_CLASS_CACHE}

  { Unable to initialize RPC services }
  CO_E_INIT_RPC_CHANNEL = HRESULT($8000400A);
  {$EXTERNALSYM CO_E_INIT_RPC_CHANNEL}

  { Cannot set thread local storage channel control }
  CO_E_INIT_TLS_SET_CHANNEL_CONTROL = HRESULT($8000400B);
  {$EXTERNALSYM CO_E_INIT_TLS_SET_CHANNEL_CONTROL}

  { Could not allocate thread local storage channel control }
  CO_E_INIT_TLS_CHANNEL_CONTROL = HRESULT($8000400C);
  {$EXTERNALSYM CO_E_INIT_TLS_CHANNEL_CONTROL}

  { The user supplied memory allocator is unacceptable }
  CO_E_INIT_UNACCEPTED_USER_ALLOCATOR = HRESULT($8000400D);
  {$EXTERNALSYM CO_E_INIT_UNACCEPTED_USER_ALLOCATOR}

  { The OLE service mutex already exists }
  CO_E_INIT_SCM_MUTEX_EXISTS = HRESULT($8000400E);
  {$EXTERNALSYM CO_E_INIT_SCM_MUTEX_EXISTS}

  { The OLE service file mapping already exists }
  CO_E_INIT_SCM_FILE_MAPPING_EXISTS = HRESULT($8000400F);
  {$EXTERNALSYM CO_E_INIT_SCM_FILE_MAPPING_EXISTS}

  { Unable to map view of file for OLE service }
  CO_E_INIT_SCM_MAP_VIEW_OF_FILE = HRESULT($80004010);
  {$EXTERNALSYM CO_E_INIT_SCM_MAP_VIEW_OF_FILE}

  { Failure attempting to launch OLE service }
  CO_E_INIT_SCM_EXEC_FAILURE = HRESULT($80004011);
  {$EXTERNALSYM CO_E_INIT_SCM_EXEC_FAILURE}

  { There was an attempt to call CoInitialize a second time while single threaded }
  CO_E_INIT_ONLY_SINGLE_THREADED = HRESULT($80004012);
  {$EXTERNALSYM CO_E_INIT_ONLY_SINGLE_THREADED}

  { A Remote activation was necessary but was not allowed }
  CO_E_CANT_REMOTE = HRESULT($80004013);
  {$EXTERNALSYM CO_E_CANT_REMOTE}

  { A Remote activation was necessary but the server name provided was invalid }
  CO_E_BAD_SERVER_NAME = HRESULT($80004014);
  {$EXTERNALSYM CO_E_BAD_SERVER_NAME}

  { The class is configured to run as a security id different from the caller }
  CO_E_WRONG_SERVER_IDENTITY = HRESULT($80004015);
  {$EXTERNALSYM CO_E_WRONG_SERVER_IDENTITY}

  { Use of Ole1 services requiring DDE windows is disabled }
  CO_E_OLE1DDE_DISABLED = HRESULT($80004016);
  {$EXTERNALSYM CO_E_OLE1DDE_DISABLED}

  { A RunAs specification must be <domain name>\<user name> or simply <user name> }
  CO_E_RUNAS_SYNTAX = HRESULT($80004017);
  {$EXTERNALSYM CO_E_RUNAS_SYNTAX}

  { The server process could not be started.  The pathname may be incorrect. }
  CO_E_CREATEPROCESS_FAILURE = HRESULT($80004018);
  {$EXTERNALSYM CO_E_CREATEPROCESS_FAILURE}

  { The server process could not be started as the configured identity.  The pathname may be incorrect or unavailable. }
  CO_E_RUNAS_CREATEPROCESS_FAILURE = HRESULT($80004019);
  {$EXTERNALSYM CO_E_RUNAS_CREATEPROCESS_FAILURE}

  { The server process could not be started because the configured identity is incorrect.  Check the username and password. }
  CO_E_RUNAS_LOGON_FAILURE = HRESULT($8000401A);
  {$EXTERNALSYM CO_E_RUNAS_LOGON_FAILURE}

  { The client is not allowed to launch this server. }
  CO_E_LAUNCH_PERMSSION_DENIED = HRESULT($8000401B);
  {$EXTERNALSYM CO_E_LAUNCH_PERMSSION_DENIED}

  { The service providing this server could not be started. }
  CO_E_START_SERVICE_FAILURE = HRESULT($8000401C);
  {$EXTERNALSYM CO_E_START_SERVICE_FAILURE}

  { This computer was unable to communicate with the computer providing the server. }
  CO_E_REMOTE_COMMUNICATION_FAILURE = HRESULT($8000401D);
  {$EXTERNALSYM CO_E_REMOTE_COMMUNICATION_FAILURE}

  { The server did not respond after being launched. }
  CO_E_SERVER_START_TIMEOUT = HRESULT($8000401E);
  {$EXTERNALSYM CO_E_SERVER_START_TIMEOUT}

  { The registration information for this server is inconsistent or incomplete. }
  CO_E_CLSREG_INCONSISTENT = HRESULT($8000401F);
  {$EXTERNALSYM CO_E_CLSREG_INCONSISTENT}

  { The registration information for this interface is inconsistent or incomplete. }
  CO_E_IIDREG_INCONSISTENT = HRESULT($80004020);
  {$EXTERNALSYM CO_E_IIDREG_INCONSISTENT}

  { The operation attempted is not supported. }
  CO_E_NOT_SUPPORTED = HRESULT($80004021);
  {$EXTERNALSYM CO_E_NOT_SUPPORTED}


  { FACILITY_ITF }
  { Codes $0-$01ff are reserved for the OLE group of }

  { Generic OLE errors that may be returned by many inerfaces}
  OLE_E_FIRST = HRESULT($80040000);
  {$EXTERNALSYM OLE_E_FIRST}
  OLE_E_LAST  = HRESULT($800400FF);
  {$EXTERNALSYM OLE_E_LAST}
  OLE_S_FIRST = $40000;
  {$EXTERNALSYM OLE_S_FIRST}
  OLE_S_LAST  = $400FF;
  {$EXTERNALSYM OLE_S_LAST}

  { Invalid OLEVERB structure }
  OLE_E_OLEVERB = HRESULT($80040000);
  {$EXTERNALSYM OLE_E_OLEVERB}

  { Invalid advise flags }
  OLE_E_ADVF = HRESULT($80040001);
  {$EXTERNALSYM OLE_E_ADVF}

  { Can't enumerate any more, because the associated data is missing }
  OLE_E_ENUM_NOMORE = HRESULT($80040002);
  {$EXTERNALSYM OLE_E_ENUM_NOMORE}

  { This implementation doesn't take advises }
  OLE_E_ADVISENOTSUPPORTED = HRESULT($80040003);
  {$EXTERNALSYM OLE_E_ADVISENOTSUPPORTED}

  { There is no connection for this connection ID }
  OLE_E_NOCONNECTION = HRESULT($80040004);
  {$EXTERNALSYM OLE_E_NOCONNECTION}

  { Need to run the object to perform this operation }
  OLE_E_NOTRUNNING = HRESULT($80040005);
  {$EXTERNALSYM OLE_E_NOTRUNNING}

  { There is no cache to operate on }
  OLE_E_NOCACHE = HRESULT($80040006);
  {$EXTERNALSYM OLE_E_NOCACHE}

  { Uninitialized object }
  OLE_E_BLANK = HRESULT($80040007);
  {$EXTERNALSYM OLE_E_BLANK}

  { Linked object's source class has changed }
  OLE_E_CLASSDIFF = HRESULT($80040008);
  {$EXTERNALSYM OLE_E_CLASSDIFF}

  { Not able to get the moniker of the object }
  OLE_E_CANT_GETMONIKER = HRESULT($80040009);
  {$EXTERNALSYM OLE_E_CANT_GETMONIKER}

  { Not able to bind to the source }
  OLE_E_CANT_BINDTOSOURCE = HRESULT($8004000A);
  {$EXTERNALSYM OLE_E_CANT_BINDTOSOURCE}

  { Object is static; operation not allowed }
  OLE_E_STATIC = HRESULT($8004000B);
  {$EXTERNALSYM OLE_E_STATIC}

  { User cancelled out of save dialog }
  OLE_E_PROMPTSAVECANCELLED = HRESULT($8004000C);
  {$EXTERNALSYM OLE_E_PROMPTSAVECANCELLED}

  { Invalid rectangle }
  OLE_E_INVALIDRECT = HRESULT($8004000D);
  {$EXTERNALSYM OLE_E_INVALIDRECT}

  { compobj.dll is too old for the ole2.dll initialized }
  OLE_E_WRONGCOMPOBJ = HRESULT($8004000E);
  {$EXTERNALSYM OLE_E_WRONGCOMPOBJ}

  { Invalid window handle }
  OLE_E_INVALIDHWND = HRESULT($8004000F);
  {$EXTERNALSYM OLE_E_INVALIDHWND}

  { Object is not in any of the inplace active states }
  OLE_E_NOT_INPLACEACTIVE = HRESULT($80040010);
  {$EXTERNALSYM OLE_E_NOT_INPLACEACTIVE}

  { Not able to convert object }
  OLE_E_CANTCONVERT = HRESULT($80040011);
  {$EXTERNALSYM OLE_E_CANTCONVERT}

  OLE_E_NOSTORAGE = HRESULT($80040012);
  {$EXTERNALSYM OLE_E_NOSTORAGE}

  { Invalid FORMATETC structure }
  DV_E_FORMATETC = HRESULT($80040064);
  {$EXTERNALSYM DV_E_FORMATETC}

  { Invalid DVTARGETDEVICE structure }
  DV_E_DVTARGETDEVICE = HRESULT($80040065);
  {$EXTERNALSYM DV_E_DVTARGETDEVICE}

  { Invalid STDGMEDIUM structure }
  DV_E_STGMEDIUM = HRESULT($80040066);
  {$EXTERNALSYM DV_E_STGMEDIUM}

  { Invalid STATDATA structure }
  DV_E_STATDATA = HRESULT($80040067);
  {$EXTERNALSYM DV_E_STATDATA}

  { Invalid lindex }
  DV_E_LINDEX = HRESULT($80040068);
  {$EXTERNALSYM DV_E_LINDEX}

  { Invalid tymed }
  DV_E_TYMED = HRESULT($80040069);
  {$EXTERNALSYM DV_E_TYMED}

  { Invalid clipboard format }
  DV_E_CLIPFORMAT = HRESULT($8004006A);
  {$EXTERNALSYM DV_E_CLIPFORMAT}

  { Invalid aspect(s) }
  DV_E_DVASPECT = HRESULT($8004006B);
  {$EXTERNALSYM DV_E_DVASPECT}

  { tdSize parameter of the DVTARGETDEVICE structure is invalid }
  DV_E_DVTARGETDEVICE_SIZE = HRESULT($8004006C);
  {$EXTERNALSYM DV_E_DVTARGETDEVICE_SIZE}

  { Object doesn't support IViewObject interface }
  DV_E_NOIVIEWOBJECT = HRESULT($8004006D);
  {$EXTERNALSYM DV_E_NOIVIEWOBJECT}

  DRAGDROP_E_FIRST = HRESULT($80040100);
  {$EXTERNALSYM DRAGDROP_E_FIRST}
  DRAGDROP_E_LAST  = HRESULT($8004010F);
  {$EXTERNALSYM DRAGDROP_E_LAST}
  DRAGDROP_S_FIRST = $40100;
  {$EXTERNALSYM DRAGDROP_S_FIRST}

  { Trying to revoke a drop target that has not been registered }
  DRAGDROP_E_NOTREGISTERED = HRESULT($80040100);
  {$EXTERNALSYM DRAGDROP_E_NOTREGISTERED}

  { This window has already been registered as a drop target }
  DRAGDROP_E_ALREADYREGISTERED = HRESULT($80040101);
  {$EXTERNALSYM DRAGDROP_E_ALREADYREGISTERED}

  { Invalid window handle }
  DRAGDROP_E_INVALIDHWND = HRESULT($80040102);
  {$EXTERNALSYM DRAGDROP_E_INVALIDHWND}

  CLASSFACTORY_E_FIRST = HRESULT($80040110);
  {$EXTERNALSYM CLASSFACTORY_E_FIRST}
  CLASSFACTORY_E_LAST  = HRESULT($8004011F);
  {$EXTERNALSYM CLASSFACTORY_E_LAST}
  CLASSFACTORY_S_FIRST = $40110;
  {$EXTERNALSYM CLASSFACTORY_S_FIRST}

  { Class does not support aggregation (or class object is remote) }
  CLASS_E_NOAGGREGATION = HRESULT($80040110);
  {$EXTERNALSYM CLASS_E_NOAGGREGATION}

  { ClassFactory cannot supply requested class }
  CLASS_E_CLASSNOTAVAILABLE = HRESULT($80040111);
  {$EXTERNALSYM CLASS_E_CLASSNOTAVAILABLE}

  MARSHAL_E_FIRST = HRESULT($80040120);
  {$EXTERNALSYM MARSHAL_E_FIRST}
  MARSHAL_E_LAST  = HRESULT($8004012F);
  {$EXTERNALSYM MARSHAL_E_LAST}
  MARSHAL_S_FIRST = $40120;
  {$EXTERNALSYM MARSHAL_S_FIRST}
  MARSHAL_S_LAST  = $4012F;
  {$EXTERNALSYM MARSHAL_S_LAST}
  DATA_E_FIRST    = HRESULT($80040130);
  {$EXTERNALSYM DATA_E_FIRST}
  DATA_E_LAST     = HRESULT($8004013F);
  {$EXTERNALSYM DATA_E_LAST}
  DATA_S_FIRST    = $40130;
  {$EXTERNALSYM DATA_S_FIRST}
  DATA_S_LAST     = $4013F;
  {$EXTERNALSYM DATA_S_LAST}
  VIEW_E_FIRST    = HRESULT($80040140);
  {$EXTERNALSYM VIEW_E_FIRST}
  VIEW_E_LAST     = HRESULT($8004014F);
  {$EXTERNALSYM VIEW_E_LAST}
  VIEW_S_FIRST    = $40140;
  {$EXTERNALSYM VIEW_S_FIRST}

  { Error drawing view }
  VIEW_E_DRAW = HRESULT($80040140);
  {$EXTERNALSYM VIEW_E_DRAW}

  REGDB_E_FIRST = HRESULT($80040150);
  {$EXTERNALSYM REGDB_E_FIRST}
  REGDB_E_LAST  = HRESULT($8004015F);
  {$EXTERNALSYM REGDB_E_LAST}
  REGDB_S_FIRST = $40150;
  {$EXTERNALSYM REGDB_S_FIRST}

  { Could not read key from registry }
  REGDB_E_READREGDB = HRESULT($80040150);
  {$EXTERNALSYM REGDB_E_READREGDB}

  { Could not write key to registry }
  REGDB_E_WRITEREGDB = HRESULT($80040151);
  {$EXTERNALSYM REGDB_E_WRITEREGDB}

  { Could not find the key in the registry }
  REGDB_E_KEYMISSING = HRESULT($80040152);
  {$EXTERNALSYM REGDB_E_KEYMISSING}

  { Invalid value for registry }
  REGDB_E_INVALIDVALUE = HRESULT($80040153);
  {$EXTERNALSYM REGDB_E_INVALIDVALUE}

  { Class not registered }
  REGDB_E_CLASSNOTREG = HRESULT($80040154);
  {$EXTERNALSYM REGDB_E_CLASSNOTREG}

  { Interface not registered }
  REGDB_E_IIDNOTREG = HRESULT($80040155);
  {$EXTERNALSYM REGDB_E_IIDNOTREG}

  CACHE_E_FIRST = HRESULT($80040170);
  {$EXTERNALSYM CACHE_E_FIRST}
  CACHE_E_LAST  = HRESULT($8004017F);
  {$EXTERNALSYM CACHE_E_LAST}
  CACHE_S_FIRST = $40170;
  {$EXTERNALSYM CACHE_S_FIRST}

  { Cache not updated }
  CACHE_E_NOCACHE_UPDATED = HRESULT($80040170);
  {$EXTERNALSYM CACHE_E_NOCACHE_UPDATED}

  OLEOBJ_E_FIRST = HRESULT($80040180);
  {$EXTERNALSYM OLEOBJ_E_FIRST}
  OLEOBJ_E_LAST  = HRESULT($8004018F);
  {$EXTERNALSYM OLEOBJ_E_LAST}
  OLEOBJ_S_FIRST = $40180;
  {$EXTERNALSYM OLEOBJ_S_FIRST}

  { No verbs for OLE object }
  OLEOBJ_E_NOVERBS = HRESULT($80040180);
  {$EXTERNALSYM OLEOBJ_E_NOVERBS}

  { Invalid verb for OLE object }
  OLEOBJ_E_INVALIDVERB = HRESULT($80040181);
  {$EXTERNALSYM OLEOBJ_E_INVALIDVERB}

  CLIENTSITE_E_FIRST = HRESULT($80040190);
  {$EXTERNALSYM CLIENTSITE_E_FIRST}
  CLIENTSITE_E_LAST = HRESULT($8004019F);
  {$EXTERNALSYM CLIENTSITE_E_LAST}
  CLIENTSITE_S_FIRST = $40190;
  {$EXTERNALSYM CLIENTSITE_S_FIRST}

  { Undo is not available }
  INPLACE_E_NOTUNDOABLE = HRESULT($800401A0);
  {$EXTERNALSYM INPLACE_E_NOTUNDOABLE}

  { Space for tools is not available }
  INPLACE_E_NOTOOLSPACE = HRESULT($800401A1);
  {$EXTERNALSYM INPLACE_E_NOTOOLSPACE}

  INPLACE_E_FIRST = HRESULT($800401A0);
  {$EXTERNALSYM INPLACE_E_FIRST}
  INPLACE_E_LAST  = HRESULT($800401AF);
  {$EXTERNALSYM INPLACE_E_LAST}
  INPLACE_S_FIRST = $401A0;
  {$EXTERNALSYM INPLACE_S_FIRST}
  INPLACE_S_LAST  = $401AF;
  {$EXTERNALSYM INPLACE_S_LAST}
  ENUM_E_FIRST = HRESULT($800401B0);
  {$EXTERNALSYM ENUM_E_FIRST}
  ENUM_E_LAST  = HRESULT($800401BF);
  {$EXTERNALSYM ENUM_E_LAST}
  ENUM_S_FIRST = $401B0;
  {$EXTERNALSYM ENUM_S_FIRST}
  ENUM_S_LAST  = $401BF;
  {$EXTERNALSYM ENUM_S_LAST}
  CONVERT10_E_FIRST = HRESULT($800401C0);
  {$EXTERNALSYM CONVERT10_E_FIRST}
  CONVERT10_E_LAST  = HRESULT($800401CF);
  {$EXTERNALSYM CONVERT10_E_LAST}
  CONVERT10_S_FIRST = $401C0;
  {$EXTERNALSYM CONVERT10_S_FIRST}

  { OLESTREAM Get method failed }
  CONVERT10_E_OLESTREAM_GET = HRESULT($800401C0);
  {$EXTERNALSYM CONVERT10_E_OLESTREAM_GET}

  { OLESTREAM Put method failed }
  CONVERT10_E_OLESTREAM_PUT = HRESULT($800401C1);
  {$EXTERNALSYM CONVERT10_E_OLESTREAM_PUT}

  { Contents of the OLESTREAM not in correct format }
  CONVERT10_E_OLESTREAM_FMT = HRESULT($800401C2);
  {$EXTERNALSYM CONVERT10_E_OLESTREAM_FMT}

  { There was an error in a Windows GDI call while converting the bitmap to a DIB }
  CONVERT10_E_OLESTREAM_BITMAP_TO_DIB = HRESULT($800401C3);
  {$EXTERNALSYM CONVERT10_E_OLESTREAM_BITMAP_TO_DIB}

  { Contents of the IStorage not in correct format }
  CONVERT10_E_STG_FMT = HRESULT($800401C4);
  {$EXTERNALSYM CONVERT10_E_STG_FMT}

  { Contents of IStorage is missing one of the standard streams }
  CONVERT10_E_STG_NO_STD_STREAM = HRESULT($800401C5);
  {$EXTERNALSYM CONVERT10_E_STG_NO_STD_STREAM}

  CONVERT10_E_STG_DIB_TO_BITMAP = HRESULT($800401C6);
  {$EXTERNALSYM CONVERT10_E_STG_DIB_TO_BITMAP}

  CLIPBRD_E_FIRST = HRESULT($800401D0);
  {$EXTERNALSYM CLIPBRD_E_FIRST}
  CLIPBRD_E_LAST  = HRESULT($800401DF);
  {$EXTERNALSYM CLIPBRD_E_LAST}
  CLIPBRD_S_FIRST = $401D0;
  {$EXTERNALSYM CLIPBRD_S_FIRST}

  { OpenClipboard Failed }
  CLIPBRD_E_CANT_OPEN = HRESULT($800401D0);
  {$EXTERNALSYM CLIPBRD_E_CANT_OPEN}

  { EmptyClipboard Failed }
  CLIPBRD_E_CANT_EMPTY = HRESULT($800401D1);
  {$EXTERNALSYM CLIPBRD_E_CANT_EMPTY}

  { SetClipboard Failed }
  CLIPBRD_E_CANT_SET = HRESULT($800401D2);
  {$EXTERNALSYM CLIPBRD_E_CANT_SET}

  { Data on clipboard is invalid }
  CLIPBRD_E_BAD_DATA = HRESULT($800401D3);
  {$EXTERNALSYM CLIPBRD_E_BAD_DATA}

  { CloseClipboard Failed }
  CLIPBRD_E_CANT_CLOSE = HRESULT($800401D4);
  {$EXTERNALSYM CLIPBRD_E_CANT_CLOSE}

  MK_E_FIRST = HRESULT($800401E0);
  {$EXTERNALSYM MK_E_FIRST}
  MK_E_LAST  = HRESULT($800401EF);
  {$EXTERNALSYM MK_E_LAST}
  MK_S_FIRST = $401E0;
  {$EXTERNALSYM MK_S_FIRST}

  { Moniker needs to be connected manually }
  MK_E_CONNECTMANUALLY = HRESULT($800401E0);
  {$EXTERNALSYM MK_E_CONNECTMANUALLY}

  { Operation exceeded deadline }
  MK_E_EXCEEDEDDEADLINE = HRESULT($800401E1);
  {$EXTERNALSYM MK_E_EXCEEDEDDEADLINE}

  { Moniker needs to be generic }
  MK_E_NEEDGENERIC = HRESULT($800401E2);
  {$EXTERNALSYM MK_E_NEEDGENERIC}

  { Operation unavailable }
  MK_E_UNAVAILABLE = HRESULT($800401E3);
  {$EXTERNALSYM MK_E_UNAVAILABLE}

  { Invalid syntax }
  MK_E_SYNTAX = HRESULT($800401E4);
  {$EXTERNALSYM MK_E_SYNTAX}

  { No object for moniker }
  MK_E_NOOBJECT = HRESULT($800401E5);
  {$EXTERNALSYM MK_E_NOOBJECT}

  { Bad extension for file }
  MK_E_INVALIDEXTENSION = HRESULT($800401E6);
  {$EXTERNALSYM MK_E_INVALIDEXTENSION}

  { Intermediate operation failed }
  MK_E_INTERMEDIATEINTERFACENOTSUPPORTED = HRESULT($800401E7);
  {$EXTERNALSYM MK_E_INTERMEDIATEINTERFACENOTSUPPORTED}

  { Moniker is not bindable }
  MK_E_NOTBINDABLE = HRESULT($800401E8);
  {$EXTERNALSYM MK_E_NOTBINDABLE}

  { Moniker is not bound }
  MK_E_NOTBOUND = HRESULT($800401E9);
  {$EXTERNALSYM MK_E_NOTBOUND}

  { Moniker cannot open file }
  MK_E_CANTOPENFILE = HRESULT($800401EA);
  {$EXTERNALSYM MK_E_CANTOPENFILE}

  { User input required for operation to succeed }
  MK_E_MUSTBOTHERUSER = HRESULT($800401EB);
  {$EXTERNALSYM MK_E_MUSTBOTHERUSER}

  { Moniker class has no inverse }
  MK_E_NOINVERSE = HRESULT($800401EC);
  {$EXTERNALSYM MK_E_NOINVERSE}

  { Moniker does not refer to storage }
  MK_E_NOSTORAGE = HRESULT($800401ED);
  {$EXTERNALSYM MK_E_NOSTORAGE}

  { No common prefix }
  MK_E_NOPREFIX = HRESULT($800401EE);
  {$EXTERNALSYM MK_E_NOPREFIX}

  { Moniker could not be enumerated }
  MK_E_ENUMERATION_FAILED = HRESULT($800401EF);
  {$EXTERNALSYM MK_E_ENUMERATION_FAILED}

  CO_E_FIRST = HRESULT($800401F0);
  {$EXTERNALSYM CO_E_FIRST}
  CO_E_LAST  = HRESULT($800401FF);
  {$EXTERNALSYM CO_E_LAST}
  CO_S_FIRST = $401F0;
  {$EXTERNALSYM CO_S_FIRST}

  { CoInitialize has not been called. }
  CO_E_NOTINITIALIZED = HRESULT($800401F0);
  {$EXTERNALSYM CO_E_NOTINITIALIZED}

  { CoInitialize has already been called. }
  CO_E_ALREADYINITIALIZED = HRESULT($800401F1);
  {$EXTERNALSYM CO_E_ALREADYINITIALIZED}

  { Class of object cannot be determined }
  CO_E_CANTDETERMINECLASS = HRESULT($800401F2);
  {$EXTERNALSYM CO_E_CANTDETERMINECLASS}

  { Invalid class string }
  CO_E_CLASSSTRING = HRESULT($800401F3);
  {$EXTERNALSYM CO_E_CLASSSTRING}

  { Invalid interface string }
  CO_E_IIDSTRING = HRESULT($800401F4);
  {$EXTERNALSYM CO_E_IIDSTRING}

  { Application not found }
  CO_E_APPNOTFOUND = HRESULT($800401F5);
  {$EXTERNALSYM CO_E_APPNOTFOUND}

  { Application cannot be run more than once }
  CO_E_APPSINGLEUSE = HRESULT($800401F6);
  {$EXTERNALSYM CO_E_APPSINGLEUSE}

  { Some error in application program }
  CO_E_ERRORINAPP = HRESULT($800401F7);
  {$EXTERNALSYM CO_E_ERRORINAPP}

  { DLL for class not found }
  CO_E_DLLNOTFOUND = HRESULT($800401F8);
  {$EXTERNALSYM CO_E_DLLNOTFOUND}

  { Error in the DLL }
  CO_E_ERRORINDLL = HRESULT($800401F9);
  {$EXTERNALSYM CO_E_ERRORINDLL}

  { Wrong OS or OS version for application }
  CO_E_WRONGOSFORAPP = HRESULT($800401FA);
  {$EXTERNALSYM CO_E_WRONGOSFORAPP}

  { Object is not registered }
  CO_E_OBJNOTREG = HRESULT($800401FB);
  {$EXTERNALSYM CO_E_OBJNOTREG}

  { Object is already registered }
  CO_E_OBJISREG = HRESULT($800401FC);
  {$EXTERNALSYM CO_E_OBJISREG}

  { Object is not connected to server }
  CO_E_OBJNOTCONNECTED = HRESULT($800401FD);
  {$EXTERNALSYM CO_E_OBJNOTCONNECTED}

  { Application was launched but it didn't register a class factory }
  CO_E_APPDIDNTREG = HRESULT($800401FE);
  {$EXTERNALSYM CO_E_APPDIDNTREG}

  { Object has been released }
  CO_E_RELEASED = HRESULT($800401FF);
  {$EXTERNALSYM CO_E_RELEASED}

  { Use the registry database to provide the requested information }
  OLE_S_USEREG = $40000;
  {$EXTERNALSYM OLE_S_USEREG}

  { Success, but static }
  OLE_S_STATIC = $40001;
  {$EXTERNALSYM OLE_S_STATIC}

  { Macintosh clipboard format }
  OLE_S_MAC_CLIPFORMAT = $40002;
  {$EXTERNALSYM OLE_S_MAC_CLIPFORMAT}

  { Successful drop took place }
  DRAGDROP_S_DROP = $40100;
  {$EXTERNALSYM DRAGDROP_S_DROP}

  { Drag-drop operation canceled }
  DRAGDROP_S_CANCEL = $40101;
  {$EXTERNALSYM DRAGDROP_S_CANCEL}

  { Use the default cursor }
  DRAGDROP_S_USEDEFAULTCURSORS = $40102;
  {$EXTERNALSYM DRAGDROP_S_USEDEFAULTCURSORS}

  { Data has same FORMATETC }
  DATA_S_SAMEFORMATETC = $40130;
  {$EXTERNALSYM DATA_S_SAMEFORMATETC}

  { View is already frozen }
  VIEW_S_ALREADY_FROZEN = $40140;
  {$EXTERNALSYM VIEW_S_ALREADY_FROZEN}

  { FORMATETC not supported }
  CACHE_S_FORMATETC_NOTSUPPORTED = $40170;
  {$EXTERNALSYM CACHE_S_FORMATETC_NOTSUPPORTED}

  { Same cache }
  CACHE_S_SAMECACHE = $40171;
  {$EXTERNALSYM CACHE_S_SAMECACHE}

  { Some cache(s) not updated }
  CACHE_S_SOMECACHES_NOTUPDATED = $40172;
  {$EXTERNALSYM CACHE_S_SOMECACHES_NOTUPDATED}

  { Invalid verb for OLE object }
  OLEOBJ_S_INVALIDVERB = $40180;
  {$EXTERNALSYM OLEOBJ_S_INVALIDVERB}

  { Verb number is valid but verb cannot be done now }
  OLEOBJ_S_CANNOT_DOVERB_NOW = $40181;
  {$EXTERNALSYM OLEOBJ_S_CANNOT_DOVERB_NOW}

  { Invalid window handle passed }
  OLEOBJ_S_INVALIDHWND = $40182;
  {$EXTERNALSYM OLEOBJ_S_INVALIDHWND}

  { Message is too long; some of it had to be truncated before displaying }
  INPLACE_S_TRUNCATED = $401A0;
  {$EXTERNALSYM INPLACE_S_TRUNCATED}

  { Unable to convert OLESTREAM to IStorage }
  CONVERT10_S_NO_PRESENTATION = $401C0;
  {$EXTERNALSYM CONVERT10_S_NO_PRESENTATION}

  { Moniker reduced to itself }
  MK_S_REDUCED_TO_SELF = $401E2;
  {$EXTERNALSYM MK_S_REDUCED_TO_SELF}

  { Common prefix is this moniker }
  MK_S_ME = $401E4;
  {$EXTERNALSYM MK_S_ME}

  { Common prefix is input moniker }
  MK_S_HIM = $401E5;
  {$EXTERNALSYM MK_S_HIM}

  { Common prefix is both monikers }
  MK_S_US = $401E6;
  {$EXTERNALSYM MK_S_US}

  { Moniker is already registered in running object table }
  MK_S_MONIKERALREADYREGISTERED = $401E7;
  {$EXTERNALSYM MK_S_MONIKERALREADYREGISTERED}


  { FACILITY_WINDOWS }
  { Codes $0-$01ff are reserved for the OLE group of}

  { Attempt to create a class object failed }
  CO_E_CLASS_CREATE_FAILED = HRESULT($80080001);
  {$EXTERNALSYM CO_E_CLASS_CREATE_FAILED}

  { OLE service could not bind object }
  CO_E_SCM_ERROR = HRESULT($80080002);
  {$EXTERNALSYM CO_E_SCM_ERROR}

  { RPC communication failed with OLE service }
  CO_E_SCM_RPC_FAILURE = HRESULT($80080003);
  {$EXTERNALSYM CO_E_SCM_RPC_FAILURE}

  { Bad path to object }
  CO_E_BAD_PATH = HRESULT($80080004);
  {$EXTERNALSYM CO_E_BAD_PATH}

  { Server execution failed }
  CO_E_SERVER_EXEC_FAILURE = HRESULT($80080005);
  {$EXTERNALSYM CO_E_SERVER_EXEC_FAILURE}

  { OLE service could not communicate with the object server }
  CO_E_OBJSRV_RPC_FAILURE = HRESULT($80080006);
  {$EXTERNALSYM CO_E_OBJSRV_RPC_FAILURE}

  { Moniker path could not be normalized }
  MK_E_NO_NORMALIZED = HRESULT($80080007);
  {$EXTERNALSYM MK_E_NO_NORMALIZED}

  { Object server is stopping when OLE service contacts it }
  CO_E_SERVER_STOPPING = HRESULT($80080008);
  {$EXTERNALSYM CO_E_SERVER_STOPPING}

  { An invalid root block pointer was specified }
  MEM_E_INVALID_ROOT = HRESULT($80080009);
  {$EXTERNALSYM MEM_E_INVALID_ROOT}

  { An allocation chain contained an invalid link pointer }
  MEM_E_INVALID_LINK = HRESULT($80080010);
  {$EXTERNALSYM MEM_E_INVALID_LINK}

  { The requested allocation size was too large }
  MEM_E_INVALID_SIZE = HRESULT($80080011);
  {$EXTERNALSYM MEM_E_INVALID_SIZE}

  { Not all the requested interfaces were available }
  CO_S_NOTALLINTERFACES = $00080012;
  {$EXTERNALSYM CO_S_NOTALLINTERFACES}


  { FACILITY_DISPATCH }

  { Unknown interface. }
  DISP_E_UNKNOWNINTERFACE = HRESULT($80020001);
  {$EXTERNALSYM DISP_E_UNKNOWNINTERFACE}

  { Member not found. }
  DISP_E_MEMBERNOTFOUND = HRESULT($80020003);
  {$EXTERNALSYM DISP_E_MEMBERNOTFOUND}

  { Parameter not found. }
  DISP_E_PARAMNOTFOUND = HRESULT($80020004);
  {$EXTERNALSYM DISP_E_PARAMNOTFOUND}

  { Type mismatch. }
  DISP_E_TYPEMISMATCH = HRESULT($80020005);
  {$EXTERNALSYM DISP_E_TYPEMISMATCH}

  { Unknown name. }
  DISP_E_UNKNOWNNAME = HRESULT($80020006);
  {$EXTERNALSYM DISP_E_UNKNOWNNAME}

  { No named arguments. }
  DISP_E_NONAMEDARGS = HRESULT($80020007);
  {$EXTERNALSYM DISP_E_NONAMEDARGS}

  { Bad variable type. }
  DISP_E_BADVARTYPE = HRESULT($80020008);
  {$EXTERNALSYM DISP_E_BADVARTYPE}

  { Exception occurred. }
  DISP_E_EXCEPTION = HRESULT($80020009);
  {$EXTERNALSYM DISP_E_EXCEPTION}

  { Out of present range. }
  DISP_E_OVERFLOW = HRESULT($8002000A);
  {$EXTERNALSYM DISP_E_OVERFLOW}

  { Invalid index. }
  DISP_E_BADINDEX = HRESULT($8002000B);
  {$EXTERNALSYM DISP_E_BADINDEX}

  { Unknown language. }
  DISP_E_UNKNOWNLCID = HRESULT($8002000C);
  {$EXTERNALSYM DISP_E_UNKNOWNLCID}

  { Memory is locked. }
  DISP_E_ARRAYISLOCKED = HRESULT($8002000D);
  {$EXTERNALSYM DISP_E_ARRAYISLOCKED}

  { Invalid number of parameters. }
  DISP_E_BADPARAMCOUNT = HRESULT($8002000E);
  {$EXTERNALSYM DISP_E_BADPARAMCOUNT}

  { Parameter not optional. }
  DISP_E_PARAMNOTOPTIONAL = HRESULT($8002000F);
  {$EXTERNALSYM DISP_E_PARAMNOTOPTIONAL}

  { Invalid callee. }
  DISP_E_BADCALLEE = HRESULT($80020010);
  {$EXTERNALSYM DISP_E_BADCALLEE}

  { Does not support a collection. }
  DISP_E_NOTACOLLECTION = HRESULT($80020011);
  {$EXTERNALSYM DISP_E_NOTACOLLECTION}

  { Buffer too small. }
  TYPE_E_BUFFERTOOSMALL = HRESULT($80028016);
  {$EXTERNALSYM TYPE_E_BUFFERTOOSMALL}

  { Old format or invalid type library. }
  TYPE_E_INVDATAREAD = HRESULT($80028018);
  {$EXTERNALSYM TYPE_E_INVDATAREAD}

  { Old format or invalid type library. }
  TYPE_E_UNSUPFORMAT = HRESULT($80028019);
  {$EXTERNALSYM TYPE_E_UNSUPFORMAT}

  { Error accessing the OLE registry. }
  TYPE_E_REGISTRYACCESS = HRESULT($8002801C);
  {$EXTERNALSYM TYPE_E_REGISTRYACCESS}

  { Library not registered. }
  TYPE_E_LIBNOTREGISTERED = HRESULT($8002801D);
  {$EXTERNALSYM TYPE_E_LIBNOTREGISTERED}

  { Bound to unknown type. }
  TYPE_E_UNDEFINEDTYPE = HRESULT($80028027);
  {$EXTERNALSYM TYPE_E_UNDEFINEDTYPE}

  { Qualified name disallowed. }
  TYPE_E_QUALIFIEDNAMEDISALLOWED = HRESULT($80028028);
  {$EXTERNALSYM TYPE_E_QUALIFIEDNAMEDISALLOWED}

  { Invalid forward reference, or reference to uncompiled type. }
  TYPE_E_INVALIDSTATE = HRESULT($80028029);
  {$EXTERNALSYM TYPE_E_INVALIDSTATE}

  { Type mismatch. }
  TYPE_E_WRONGTYPEKIND = HRESULT($8002802A);
  {$EXTERNALSYM TYPE_E_WRONGTYPEKIND}

  { Element not found. }
  TYPE_E_ELEMENTNOTFOUND = HRESULT($8002802B);
  {$EXTERNALSYM TYPE_E_ELEMENTNOTFOUND}

  { Ambiguous name. }
  TYPE_E_AMBIGUOUSNAME = HRESULT($8002802C);
  {$EXTERNALSYM TYPE_E_AMBIGUOUSNAME}

  { Name already exists in the library. }
  TYPE_E_NAMECONFLICT = HRESULT($8002802D);
  {$EXTERNALSYM TYPE_E_NAMECONFLICT}

  { Unknown LCID. }
  TYPE_E_UNKNOWNLCID = HRESULT($8002802E);
  {$EXTERNALSYM TYPE_E_UNKNOWNLCID}

  { Function not defined in specified DLL. }
  TYPE_E_DLLFUNCTIONNOTFOUND = HRESULT($8002802F);
  {$EXTERNALSYM TYPE_E_DLLFUNCTIONNOTFOUND}

  { Wrong module kind for the operation. }
  TYPE_E_BADMODULEKIND = HRESULT($800288BD);
  {$EXTERNALSYM TYPE_E_BADMODULEKIND}

  { Size may not exceed 64K. }
  TYPE_E_SIZETOOBIG = HRESULT($800288C5);
  {$EXTERNALSYM TYPE_E_SIZETOOBIG}

  { Duplicate ID in inheritance hierarchy. }
  TYPE_E_DUPLICATEID = HRESULT($800288C6);
  {$EXTERNALSYM TYPE_E_DUPLICATEID}

  { Incorrect inheritance depth in standard OLE hmember. }
  TYPE_E_INVALIDID = HRESULT($800288CF);
  {$EXTERNALSYM TYPE_E_INVALIDID}

  { Type mismatch. }
  TYPE_E_TYPEMISMATCH = HRESULT($80028CA0);
  {$EXTERNALSYM TYPE_E_TYPEMISMATCH}

  { Invalid number of arguments. }
  TYPE_E_OUTOFBOUNDS = HRESULT($80028CA1);
  {$EXTERNALSYM TYPE_E_OUTOFBOUNDS}

  { I/O Error. }
  TYPE_E_IOERROR = HRESULT($80028CA2);
  {$EXTERNALSYM TYPE_E_IOERROR}

  { Error creating unique tmp file. }
  TYPE_E_CANTCREATETMPFILE = HRESULT($80028CA3);
  {$EXTERNALSYM TYPE_E_CANTCREATETMPFILE}

  { Error loading type library/DLL. }
  TYPE_E_CANTLOADLIBRARY = HRESULT($80029C4A);
  {$EXTERNALSYM TYPE_E_CANTLOADLIBRARY}

  { Inconsistent property functions. }
  TYPE_E_INCONSISTENTPROPFUNCS = HRESULT($80029C83);
  {$EXTERNALSYM TYPE_E_INCONSISTENTPROPFUNCS}

  { Circular dependency between types/modules. }
  TYPE_E_CIRCULARTYPE = HRESULT($80029C84);
  {$EXTERNALSYM TYPE_E_CIRCULARTYPE}


  { FACILITY_STORAGE }

{$IFDEF MSWINDOWS}
  { Unable to perform requested operation. }
  STG_E_INVALIDFUNCTION = HRESULT($80030001);
  {$EXTERNALSYM STG_E_INVALIDFUNCTION}

  { %l could not be found. }
  STG_E_FILENOTFOUND = HRESULT($80030002);
  {$EXTERNALSYM STG_E_FILENOTFOUND}

  { The path %l could not be found. }
  STG_E_PATHNOTFOUND = HRESULT($80030003);
  {$EXTERNALSYM STG_E_PATHNOTFOUND}

  { There are insufficient resources to open another file. }
  STG_E_TOOMANYOPENFILES = HRESULT($80030004);
  {$EXTERNALSYM STG_E_TOOMANYOPENFILES}

  { Access Denied. }
  STG_E_ACCESSDENIED = HRESULT($80030005);
  {$EXTERNALSYM STG_E_ACCESSDENIED}

  { Attempted an operation on an invalid object. }
  STG_E_INVALIDHANDLE = HRESULT($80030006);
  {$EXTERNALSYM STG_E_INVALIDHANDLE}

  { There is insufficient memory available to complete operation. }
  STG_E_INSUFFICIENTMEMORY = HRESULT($80030008);
  {$EXTERNALSYM STG_E_INSUFFICIENTMEMORY}

  { Invalid pointer error. }
  STG_E_INVALIDPOINTER = HRESULT($80030009);
  {$EXTERNALSYM STG_E_INVALIDPOINTER}

  { There are no more entries to return. }
  STG_E_NOMOREFILES = HRESULT($80030012);
  {$EXTERNALSYM STG_E_NOMOREFILES}

  { Disk is write-protected. }
  STG_E_DISKISWRITEPROTECTED = HRESULT($80030013);
  {$EXTERNALSYM STG_E_DISKISWRITEPROTECTED}

  { An error occurred during a seek operation. }
  STG_E_SEEKERROR = HRESULT($80030019);
  {$EXTERNALSYM STG_E_SEEKERROR}

  { A disk error occurred during a write operation. }
  STG_E_WRITEFAULT = HRESULT($8003001D);
  {$EXTERNALSYM STG_E_WRITEFAULT}

  { A disk error occurred during a read operation. }
  STG_E_READFAULT = HRESULT($8003001E);
  {$EXTERNALSYM STG_E_READFAULT}

  { A share violation has occurred. }
  STG_E_SHAREVIOLATION = HRESULT($80030020);
  {$EXTERNALSYM STG_E_SHAREVIOLATION}

  { A lock violation has occurred. }
  STG_E_LOCKVIOLATION = HRESULT($80030021);
  {$EXTERNALSYM STG_E_LOCKVIOLATION}

  { %l already exists. }
  STG_E_FILEALREADYEXISTS = HRESULT($80030050);
  {$EXTERNALSYM STG_E_FILEALREADYEXISTS}

  { Invalid parameter error. }
  STG_E_INVALIDPARAMETER = HRESULT($80030057);
  {$EXTERNALSYM STG_E_INVALIDPARAMETER}

  { There is insufficient disk space to complete operation. }
  STG_E_MEDIUMFULL = HRESULT($80030070);
  {$EXTERNALSYM STG_E_MEDIUMFULL}

  { Illegal write of non-simple property to simple property set. }
  STG_E_PROPSETMISMATCHED = HRESULT($800300F0);
  {$EXTERNALSYM STG_E_PROPSETMISMATCHED}

  { An API call exited abnormally. }
  STG_E_ABNORMALAPIEXIT = HRESULT($800300FA);
  {$EXTERNALSYM STG_E_ABNORMALAPIEXIT}

  { The file %l is not a valid compound file. }
  STG_E_INVALIDHEADER = HRESULT($800300FB);
  {$EXTERNALSYM STG_E_INVALIDHEADER}

  { The name %l is not valid. }
  STG_E_INVALIDNAME = HRESULT($800300FC);
  {$EXTERNALSYM STG_E_INVALIDNAME}

  { An unexpected error occurred. }
  STG_E_UNKNOWN = HRESULT($800300FD);
  {$EXTERNALSYM STG_E_UNKNOWN}

  { That function is not implemented. }
  STG_E_UNIMPLEMENTEDFUNCTION = HRESULT($800300FE);
  {$EXTERNALSYM STG_E_UNIMPLEMENTEDFUNCTION}

  { Invalid flag error. }
  STG_E_INVALIDFLAG = HRESULT($800300FF);
  {$EXTERNALSYM STG_E_INVALIDFLAG}

  { Attempted to use an object that is busy. }
  STG_E_INUSE = HRESULT($80030100);
  {$EXTERNALSYM STG_E_INUSE}

  { The storage has been changed since the last commit. }
  STG_E_NOTCURRENT = HRESULT($80030101);
  {$EXTERNALSYM STG_E_NOTCURRENT}

  { Attempted to use an object that has ceased to exist. }
  STG_E_REVERTED = HRESULT($80030102);
  {$EXTERNALSYM STG_E_REVERTED}

  { Can't save. }
  STG_E_CANTSAVE = HRESULT($80030103);
  {$EXTERNALSYM STG_E_CANTSAVE}

  { The compound file %l was produced with an incompatible version of storage. }
  STG_E_OLDFORMAT = HRESULT($80030104);
  {$EXTERNALSYM STG_E_OLDFORMAT}

  { The compound file %l was produced with a newer version of storage. }
  STG_E_OLDDLL = HRESULT($80030105);
  {$EXTERNALSYM STG_E_OLDDLL}

  { Share.exe or equivalent is required for operation. }
  STG_E_SHAREREQUIRED = HRESULT($80030106);
  {$EXTERNALSYM STG_E_SHAREREQUIRED}

  { Illegal operation called on non-file based storage. }
  STG_E_NOTFILEBASEDSTORAGE = HRESULT($80030107);
  {$EXTERNALSYM STG_E_NOTFILEBASEDSTORAGE}

  { Illegal operation called on object with extant marshallings. }
  STG_E_EXTANTMARSHALLINGS = HRESULT($80030108);
  {$EXTERNALSYM STG_E_EXTANTMARSHALLINGS}

  { The docfile has been corrupted. }
  STG_E_DOCFILECORRUPT = HRESULT($80030109);
  {$EXTERNALSYM STG_E_DOCFILECORRUPT}

  { OLE32.DLL has been loaded at the wrong address. }
  STG_E_BADBASEADDRESS = HRESULT($80030110);
  {$EXTERNALSYM STG_E_BADBASEADDRESS}

  { The file download was aborted abnormally.  The file is incomplete. }
  STG_E_INCOMPLETE = HRESULT($80030201);
  {$EXTERNALSYM STG_E_INCOMPLETE}

  { The file download has been terminated. }
  STG_E_TERMINATED = HRESULT($80030202);
  {$EXTERNALSYM STG_E_TERMINATED}

  { The underlying file was converted to compound file format. }
  STG_S_CONVERTED = $00030200;
  {$EXTERNALSYM STG_S_CONVERTED}

  { The storage operation should block until more data is available. }
  STG_S_BLOCK = $00030201;
  {$EXTERNALSYM STG_S_BLOCK}

  { The storage operation should retry immediately. }
  STG_S_RETRYNOW = $00030202;
  {$EXTERNALSYM STG_S_RETRYNOW}

  { The notified event sink will not influence the storage operation. }
  STG_S_MONITORING = $00030203;
  {$EXTERNALSYM STG_S_MONITORING}
{$ENDIF}
{$IFDEF LINUX}
  STG_E_INVALIDFUNCTION = Types.STG_E_INVALIDFUNCTION;
  {$EXTERNALSYM STG_E_INVALIDFUNCTION}

  { %l could not be found. }
  STG_E_FILENOTFOUND = Types.STG_E_FILENOTFOUND;
  {$EXTERNALSYM STG_E_FILENOTFOUND}

  { The path %l could not be found. }
  STG_E_PATHNOTFOUND = Types.STG_E_PATHNOTFOUND;
  {$EXTERNALSYM STG_E_PATHNOTFOUND}

  { There are insufficient resources to open another file. }
  STG_E_TOOMANYOPENFILES = Types.STG_E_TOOMANYOPENFILES;
  {$EXTERNALSYM STG_E_TOOMANYOPENFILES}

  { Access Denied. }
  STG_E_ACCESSDENIED = Types.STG_E_ACCESSDENIED;
  {$EXTERNALSYM STG_E_ACCESSDENIED}

  { Attempted an operation on an invalid object. }
  STG_E_INVALIDHANDLE = Types.STG_E_INVALIDHANDLE;
  {$EXTERNALSYM STG_E_INVALIDHANDLE}

  { There is insufficient memory available to complete operation. }
  STG_E_INSUFFICIENTMEMORY = Types.STG_E_INSUFFICIENTMEMORY;
  {$EXTERNALSYM STG_E_INSUFFICIENTMEMORY}

  { Invalid pointer error. }
  STG_E_INVALIDPOINTER = Types.STG_E_INVALIDPOINTER;
  {$EXTERNALSYM STG_E_INVALIDPOINTER}

  { There are no more entries to return. }
  STG_E_NOMOREFILES = Types.STG_E_NOMOREFILES;
  {$EXTERNALSYM STG_E_NOMOREFILES}

  { Disk is write-protected. }
  STG_E_DISKISWRITEPROTECTED = Types.STG_E_DISKISWRITEPROTECTED;
  {$EXTERNALSYM STG_E_DISKISWRITEPROTECTED}

  { An error occurred during a seek operation. }
  STG_E_SEEKERROR = Types.STG_E_SEEKERROR;
  {$EXTERNALSYM STG_E_SEEKERROR}

  { A disk error occurred during a write operation. }
  STG_E_WRITEFAULT = Types.STG_E_WRITEFAULT;
  {$EXTERNALSYM STG_E_WRITEFAULT}

  { A disk error occurred during a read operation. }
  STG_E_READFAULT = Types.STG_E_READFAULT;
  {$EXTERNALSYM STG_E_READFAULT}

  { A share violation has occurred. }
  STG_E_SHAREVIOLATION = Types.STG_E_SHAREVIOLATION;
  {$EXTERNALSYM STG_E_SHAREVIOLATION}

  { A lock violation has occurred. }
  STG_E_LOCKVIOLATION = Types.STG_E_LOCKVIOLATION;
  {$EXTERNALSYM STG_E_LOCKVIOLATION}

  { %l already exists. }
  STG_E_FILEALREADYEXISTS = Types.STG_E_FILEALREADYEXISTS;
  {$EXTERNALSYM STG_E_FILEALREADYEXISTS}

  { Invalid parameter error. }
  STG_E_INVALIDPARAMETER = Types.STG_E_INVALIDPARAMETER;
  {$EXTERNALSYM STG_E_INVALIDPARAMETER}

  { There is insufficient disk space to complete operation. }
  STG_E_MEDIUMFULL = Types.STG_E_MEDIUMFULL;
  {$EXTERNALSYM STG_E_MEDIUMFULL}

  { Illegal write of non-simple property to simple property set. }
  STG_E_PROPSETMISMATCHED = Types.STG_E_PROPSETMISMATCHED;
  {$EXTERNALSYM STG_E_PROPSETMISMATCHED}

  { An API call exited abnormally. }
  STG_E_ABNORMALAPIEXIT = Types.STG_E_ABNORMALAPIEXIT;
  {$EXTERNALSYM STG_E_ABNORMALAPIEXIT}

  { The file %l is not a valid compound file. }
  STG_E_INVALIDHEADER = Types.STG_E_INVALIDHEADER;
  {$EXTERNALSYM STG_E_INVALIDHEADER}

  { The name %l is not valid. }
  STG_E_INVALIDNAME = Types.STG_E_INVALIDNAME;
  {$EXTERNALSYM STG_E_INVALIDNAME}

  { An unexpected error occurred. }
  STG_E_UNKNOWN = Types.STG_E_UNKNOWN;
  {$EXTERNALSYM STG_E_UNKNOWN}

  { That function is not implemented. }
  STG_E_UNIMPLEMENTEDFUNCTION = Types.STG_E_UNIMPLEMENTEDFUNCTION;
  {$EXTERNALSYM STG_E_UNIMPLEMENTEDFUNCTION}

  { Invalid flag error. }
  STG_E_INVALIDFLAG = Types.STG_E_INVALIDFLAG;
  {$EXTERNALSYM STG_E_INVALIDFLAG}

  { Attempted to use an object that is busy. }
  STG_E_INUSE = Types.STG_E_INUSE;
  {$EXTERNALSYM STG_E_INUSE}

  { The storage has been changed since the last commit. }
  STG_E_NOTCURRENT = Types.STG_E_NOTCURRENT;
  {$EXTERNALSYM STG_E_NOTCURRENT}

  { Attempted to use an object that has ceased to exist. }
  STG_E_REVERTED = Types.STG_E_REVERTED;
  {$EXTERNALSYM STG_E_REVERTED}

  { Can't save. }
  STG_E_CANTSAVE = Types.STG_E_CANTSAVE;
  {$EXTERNALSYM STG_E_CANTSAVE}

  { The compound file %l was produced with an incompatible version of storage. }
  STG_E_OLDFORMAT = Types.STG_E_OLDFORMAT;
  {$EXTERNALSYM STG_E_OLDFORMAT}

  { The compound file %l was produced with a newer version of storage. }
  STG_E_OLDDLL = Types.STG_E_OLDDLL;
  {$EXTERNALSYM STG_E_OLDDLL}

  { Share.exe or equivalent is required for operation. }
  STG_E_SHAREREQUIRED = Types.STG_E_SHAREREQUIRED;
  {$EXTERNALSYM STG_E_SHAREREQUIRED}

  { Illegal operation called on non-file based storage. }
  STG_E_NOTFILEBASEDSTORAGE = Types.STG_E_NOTFILEBASEDSTORAGE;
  {$EXTERNALSYM STG_E_NOTFILEBASEDSTORAGE}

  { Illegal operation called on object with extant marshallings. }
  STG_E_EXTANTMARSHALLINGS = Types.STG_E_EXTANTMARSHALLINGS;
  {$EXTERNALSYM STG_E_EXTANTMARSHALLINGS}

  { The docfile has been corrupted. }
  STG_E_DOCFILECORRUPT = Types.STG_E_DOCFILECORRUPT;
  {$EXTERNALSYM STG_E_DOCFILECORRUPT}

  { OLE32.DLL has been loaded at the wrong address. }
  STG_E_BADBASEADDRESS = Types.STG_E_BADBASEADDRESS;
  {$EXTERNALSYM STG_E_BADBASEADDRESS}

  { The file download was aborted abnormally.  The file is incomplete. }
  STG_E_INCOMPLETE = Types.STG_E_INCOMPLETE;
  {$EXTERNALSYM STG_E_INCOMPLETE}

  { The file download has been terminated. }
  STG_E_TERMINATED = Types.STG_E_TERMINATED;
  {$EXTERNALSYM STG_E_TERMINATED}

  { The underlying file was converted to compound file format. }
  STG_S_CONVERTED = Types.STG_S_CONVERTED ;
  {$EXTERNALSYM STG_S_CONVERTED}

  { The storage operation should block until more data is available. }
  STG_S_BLOCK = Types.STG_S_BLOCK ;
  {$EXTERNALSYM STG_S_BLOCK}

  { The storage operation should retry immediately. }
  STG_S_RETRYNOW = Types.STG_S_RETRYNOW ;
  {$EXTERNALSYM STG_S_RETRYNOW}

  { The notified event sink will not influence the storage operation. }
  STG_S_MONITORING = Types.STG_S_MONITORING ;
  {$EXTERNALSYM STG_S_MONITORING}
{$ENDIF}

  { FACILITY_RPC }

  { Call was rejected by callee. }
  RPC_E_CALL_REJECTED = HRESULT($80010001);
  {$EXTERNALSYM RPC_E_CALL_REJECTED}

  { Call was canceled by the message filter. }
  RPC_E_CALL_CANCELED = HRESULT($80010002);
  {$EXTERNALSYM RPC_E_CALL_CANCELED}

  { The caller is dispatching an intertask SendMessage call and }
  { cannot call out via PostMessage. }
  RPC_E_CANTPOST_INSENDCALL = HRESULT($80010003);
  {$EXTERNALSYM RPC_E_CANTPOST_INSENDCALL}

  { The caller is dispatching an asynchronous call and cannot }
  { make an outgoing call on behalf of this call. }
  RPC_E_CANTCALLOUT_INASYNCCALL = HRESULT($80010004);
  {$EXTERNALSYM RPC_E_CANTCALLOUT_INASYNCCALL}

  { It is illegal to call out while inside message filter. }
  RPC_E_CANTCALLOUT_INEXTERNALCALL = HRESULT($80010005);
  {$EXTERNALSYM RPC_E_CANTCALLOUT_INEXTERNALCALL}

  { The connection terminated or is in a bogus state }
  { and cannot be used any more. Other connections }
  { are still valid. }
  RPC_E_CONNECTION_TERMINATED = HRESULT($80010006);
  {$EXTERNALSYM RPC_E_CONNECTION_TERMINATED}

  { The callee (server [not server application]) is not available }
  { and disappeared; all connections are invalid.  The call may }
  { have executed. }
  RPC_E_SERVER_DIED = HRESULT($80010007);
  {$EXTERNALSYM RPC_E_SERVER_DIED}

  { The caller (client) disappeared while the callee (server) was }
  { processing a call. }
  RPC_E_CLIENT_DIED = HRESULT($80010008);
  {$EXTERNALSYM RPC_E_CLIENT_DIED}

  { The data packet with the marshalled parameter data is incorrect. }
  RPC_E_INVALID_DATAPACKET = HRESULT($80010009);
  {$EXTERNALSYM RPC_E_INVALID_DATAPACKET}

  { The call was not transmitted properly; the message queue }
  { was full and was not emptied after yielding. }
  RPC_E_CANTTRANSMIT_CALL = HRESULT($8001000A);
  {$EXTERNALSYM RPC_E_CANTTRANSMIT_CALL}

  { The client (caller) cannot marshall the parameter data - low memory, etc. }
  RPC_E_CLIENT_CANTMARSHAL_DATA = HRESULT($8001000B);
  {$EXTERNALSYM RPC_E_CLIENT_CANTMARSHAL_DATA}

  { The client (caller) cannot unmarshall the return data - low memory, etc. }
  RPC_E_CLIENT_CANTUNMARSHAL_DATA = HRESULT($8001000C);
  {$EXTERNALSYM RPC_E_CLIENT_CANTUNMARSHAL_DATA}

  { The server (callee) cannot marshall the return data - low memory, etc. }
  RPC_E_SERVER_CANTMARSHAL_DATA = HRESULT($8001000D);
  {$EXTERNALSYM RPC_E_SERVER_CANTMARSHAL_DATA}

  { The server (callee) cannot unmarshall the parameter data - low memory, etc. }
  RPC_E_SERVER_CANTUNMARSHAL_DATA = HRESULT($8001000E);
  {$EXTERNALSYM RPC_E_SERVER_CANTUNMARSHAL_DATA}

  { Received data is invalid; could be server or client data. }
  RPC_E_INVALID_DATA = HRESULT($8001000F);
  {$EXTERNALSYM RPC_E_INVALID_DATA}

  { A particular parameter is invalid and cannot be (un)marshalled. }
  RPC_E_INVALID_PARAMETER = HRESULT($80010010);
  {$EXTERNALSYM RPC_E_INVALID_PARAMETER}

  { There is no second outgoing call on same channel in DDE conversation. }
  RPC_E_CANTCALLOUT_AGAIN = HRESULT($80010011);
  {$EXTERNALSYM RPC_E_CANTCALLOUT_AGAIN}

  { The callee (server [not server application]) is not available }
  { and disappeared; all connections are invalid.  The call did not execute. }
  RPC_E_SERVER_DIED_DNE = HRESULT($80010012);
  {$EXTERNALSYM RPC_E_SERVER_DIED_DNE}

  { System call failed. }
  RPC_E_SYS_CALL_FAILED = HRESULT($80010100);
  {$EXTERNALSYM RPC_E_SYS_CALL_FAILED}

  { Could not allocate some required resource (memory, events, ...) }
  RPC_E_OUT_OF_RESOURCES = HRESULT($80010101);
  {$EXTERNALSYM RPC_E_OUT_OF_RESOURCES}

  { Attempted to make calls on more than one thread in single threaded mode. }
  RPC_E_ATTEMPTED_MULTITHREAD = HRESULT($80010102);
  {$EXTERNALSYM RPC_E_ATTEMPTED_MULTITHREAD}

  { The requested interface is not registered on the server object. }
  RPC_E_NOT_REGISTERED = HRESULT($80010103);
  {$EXTERNALSYM RPC_E_NOT_REGISTERED}

  { RPC could not call the server or could not return the results of calling the server. }
  RPC_E_FAULT = HRESULT($80010104);
  {$EXTERNALSYM RPC_E_FAULT}

  { The server threw an exception. }
  RPC_E_SERVERFAULT = HRESULT($80010105);
  {$EXTERNALSYM RPC_E_SERVERFAULT}

  { Cannot change thread mode after it is set. }
  RPC_E_CHANGED_MODE = HRESULT($80010106);
  {$EXTERNALSYM RPC_E_CHANGED_MODE}

  { The method called does not exist on the server. }
  RPC_E_INVALIDMETHOD = HRESULT($80010107);
  {$EXTERNALSYM RPC_E_INVALIDMETHOD}

  { The object invoked has disconnected from its clients. }
  RPC_E_DISCONNECTED = HRESULT($80010108);
  {$EXTERNALSYM RPC_E_DISCONNECTED}

  { The object invoked chose not to process the call now.  Try again later. }
  RPC_E_RETRY = HRESULT($80010109);
  {$EXTERNALSYM RPC_E_RETRY}

  { The message filter indicated that the application is busy. }
  RPC_E_SERVERCALL_RETRYLATER = HRESULT($8001010A);
  {$EXTERNALSYM RPC_E_SERVERCALL_RETRYLATER}

  { The message filter rejected the call. }
  RPC_E_SERVERCALL_REJECTED = HRESULT($8001010B);
  {$EXTERNALSYM RPC_E_SERVERCALL_REJECTED}

  { A call control interfaces was called with invalid data. }
  RPC_E_INVALID_CALLDATA = HRESULT($8001010C);
  {$EXTERNALSYM RPC_E_INVALID_CALLDATA}

  { An outgoing call cannot be made since the application is dispatching an input-synchronous call. }
  RPC_E_CANTCALLOUT_ININPUTSYNCCALL = HRESULT($8001010D);
  {$EXTERNALSYM RPC_E_CANTCALLOUT_ININPUTSYNCCALL}

  { The application called an interface that was marshalled for a different thread. }
  RPC_E_WRONG_THREAD = HRESULT($8001010E);
  {$EXTERNALSYM RPC_E_WRONG_THREAD}

  { CoInitialize has not been called on the current thread. }
  RPC_E_THREAD_NOT_INIT = HRESULT($8001010F);
  {$EXTERNALSYM RPC_E_THREAD_NOT_INIT}

  { The version of OLE on the client and server machines does not match. }
  RPC_E_VERSION_MISMATCH = HRESULT($80010110);
  {$EXTERNALSYM RPC_E_VERSION_MISMATCH}

  { OLE received a packet with an invalid header. }
  RPC_E_INVALID_HEADER = HRESULT($80010111);
  {$EXTERNALSYM RPC_E_INVALID_HEADER}

  { OLE received a packet with an invalid extension. }
  RPC_E_INVALID_EXTENSION = HRESULT($80010112);
  {$EXTERNALSYM RPC_E_INVALID_EXTENSION}

  { The requested object or interface does not exist. }
  RPC_E_INVALID_IPID = HRESULT($80010113);
  {$EXTERNALSYM RPC_E_INVALID_IPID}

  { The requested object does not exist. }
  RPC_E_INVALID_OBJECT = HRESULT($80010114);
  {$EXTERNALSYM RPC_E_INVALID_OBJECT}

  { OLE has sent a request and is waiting for a reply. }
  RPC_S_CALLPENDING = HRESULT($80010115);
  {$EXTERNALSYM RPC_S_CALLPENDING}

  { OLE is waiting before retrying a request. }
  RPC_S_WAITONTIMER = HRESULT($80010116);
  {$EXTERNALSYM RPC_S_WAITONTIMER}

  { Call context cannot be accessed after call completed. }
  RPC_E_CALL_COMPLETE = HRESULT($80010117);
  {$EXTERNALSYM RPC_E_CALL_COMPLETE}

  { Impersonate on unsecure calls is not supported. }
  RPC_E_UNSECURE_CALL = HRESULT($80010118);
  {$EXTERNALSYM RPC_E_UNSECURE_CALL}

  { Security must be initialized before any interfaces are marshalled or }
  RPC_E_TOO_LATE = HRESULT($80010119);
  {$EXTERNALSYM RPC_E_TOO_LATE}

  { No security packages are installed on this machine or the user is not logged }
  RPC_E_NO_GOOD_SECURITY_PACKAGES = HRESULT($8001011A);
  {$EXTERNALSYM RPC_E_NO_GOOD_SECURITY_PACKAGES}

  { Access is denied. }
  RPC_E_ACCESS_DENIED = HRESULT($8001011B);
  {$EXTERNALSYM RPC_E_ACCESS_DENIED}

  { Remote calls are not allowed for this process. }
  RPC_E_REMOTE_DISABLED = HRESULT($8001011C);
  {$EXTERNALSYM RPC_E_REMOTE_DISABLED}

  { The marshaled interface data packet (OBJREF) has an invalid or unknown format. }
  RPC_E_INVALID_OBJREF = HRESULT($8001011D);
  {$EXTERNALSYM RPC_E_INVALID_OBJREF}

  { No context is associated with this call.
    This happens for some custom marshalled calls and on the client side of the call. }
  RPC_E_NO_CONTEXT = HRESULT($8001011E);
  {$EXTERNALSYM RPC_E_NO_CONTEXT}

  { This operation returned because the timeout period expired. }
  RPC_E_TIMEOUT = HRESULT($8001011F);
  {$EXTERNALSYM RPC_E_TIMEOUT}

  { An internal error occurred. }
  RPC_E_UNEXPECTED = HRESULT($8001FFFF);
  {$EXTERNALSYM RPC_E_UNEXPECTED}


{ FACILITY_SSPI }

  { Bad UID. }
  NTE_BAD_UID = HRESULT($80090001);
  {$EXTERNALSYM NTE_BAD_UID}

  { Bad Hash. }
  NTE_BAD_HASH = HRESULT($80090002);
  {$EXTERNALSYM NTE_BAD_HASH}

  { Bad Key. }
  NTE_BAD_KEY = HRESULT($80090003);
  {$EXTERNALSYM NTE_BAD_KEY}

  { Bad Length. }
  NTE_BAD_LEN = HRESULT($80090004);
  {$EXTERNALSYM NTE_BAD_LEN}

  { Bad Data. }
  NTE_BAD_DATA = HRESULT($80090005);
  {$EXTERNALSYM NTE_BAD_DATA}

  { Invalid Signature. }
  NTE_BAD_SIGNATURE = HRESULT($80090006);
  {$EXTERNALSYM NTE_BAD_SIGNATURE}

  { Bad Version of provider. }
  NTE_BAD_VER = HRESULT($80090007);
  {$EXTERNALSYM NTE_BAD_VER}

  { Invalid algorithm specified. }
  NTE_BAD_ALGID = HRESULT($80090008);
  {$EXTERNALSYM NTE_BAD_ALGID}

  { Invalid flags specified. }
  NTE_BAD_FLAGS = HRESULT($80090009);
  {$EXTERNALSYM NTE_BAD_FLAGS}

  { Invalid type specified. }
  NTE_BAD_TYPE = HRESULT($8009000A);
  {$EXTERNALSYM NTE_BAD_TYPE}

  { Key not valid for use in specified state. }
  NTE_BAD_KEY_STATE = HRESULT($8009000B);
  {$EXTERNALSYM NTE_BAD_KEY_STATE}

  { Hash not valid for use in specified state. }
  NTE_BAD_HASH_STATE = HRESULT($8009000C);
  {$EXTERNALSYM NTE_BAD_HASH_STATE}

  { Key does not exist. }
  NTE_NO_KEY = HRESULT($8009000D);
  {$EXTERNALSYM NTE_NO_KEY}

  { Insufficient memory available for the operation. }
  NTE_NO_MEMORY = HRESULT($8009000E);
  {$EXTERNALSYM NTE_NO_MEMORY}

  { Object already exists. }
  NTE_EXISTS = HRESULT($8009000F);
  {$EXTERNALSYM NTE_EXISTS}

  { Access denied. }
  NTE_PERM = HRESULT($80090010);
  {$EXTERNALSYM NTE_PERM}

  { Object was not found. }
  NTE_NOT_FOUND = HRESULT($80090011);
  {$EXTERNALSYM NTE_NOT_FOUND}

  { Data already encrypted. }
  NTE_DOUBLE_ENCRYPT = HRESULT($80090012);
  {$EXTERNALSYM NTE_DOUBLE_ENCRYPT}

  { Invalid provider specified. }
  NTE_BAD_PROVIDER = HRESULT($80090013);
  {$EXTERNALSYM NTE_BAD_PROVIDER}

  { Invalid provider type specified. }
  NTE_BAD_PROV_TYPE = HRESULT($80090014);
  {$EXTERNALSYM NTE_BAD_PROV_TYPE}

  { Provider's public key is invalid. }
  NTE_BAD_PUBLIC_KEY = HRESULT($80090015);
  {$EXTERNALSYM NTE_BAD_PUBLIC_KEY}

  { Keyset does not exist }
  NTE_BAD_KEYSET = HRESULT($80090016);
  {$EXTERNALSYM NTE_BAD_KEYSET}

  { Provider type not defined. }
  NTE_PROV_TYPE_NOT_DEF = HRESULT($80090017);
  {$EXTERNALSYM NTE_PROV_TYPE_NOT_DEF}

  { Provider type as registered is invalid. }
  NTE_PROV_TYPE_ENTRY_BAD = HRESULT($80090018);
  {$EXTERNALSYM NTE_PROV_TYPE_ENTRY_BAD}

  { The keyset is not defined. }
  NTE_KEYSET_NOT_DEF = HRESULT($80090019);
  {$EXTERNALSYM NTE_KEYSET_NOT_DEF}

  { Keyset as registered is invalid. }
  NTE_KEYSET_ENTRY_BAD = HRESULT($8009001A);
  {$EXTERNALSYM NTE_KEYSET_ENTRY_BAD}

  { Provider type does not match registered value. }
  NTE_PROV_TYPE_NO_MATCH = HRESULT($8009001B);
  {$EXTERNALSYM NTE_PROV_TYPE_NO_MATCH}

  { The digital signature file is corrupt. }
  NTE_SIGNATURE_FILE_BAD = HRESULT($8009001C);
  {$EXTERNALSYM NTE_SIGNATURE_FILE_BAD}

  { Provider DLL failed to initialize correctly. }
  NTE_PROVIDER_DLL_FAIL = HRESULT($8009001D);
  {$EXTERNALSYM NTE_PROVIDER_DLL_FAIL}

  { Provider DLL could not be found. }
  NTE_PROV_DLL_NOT_FOUND = HRESULT($8009001E);
  {$EXTERNALSYM NTE_PROV_DLL_NOT_FOUND}

  { The Keyset parameter is invalid. }
  NTE_BAD_KEYSET_PARAM = HRESULT($8009001F);
  {$EXTERNALSYM NTE_BAD_KEYSET_PARAM}

  { An internal error occurred. }
  NTE_FAIL = HRESULT($80090020);
  {$EXTERNALSYM NTE_FAIL}

  { A base error occurred. }
  NTE_SYS_ERR = HRESULT($80090021);
  {$EXTERNALSYM NTE_SYS_ERR}

  NTE_OP_OK = 0;
  {$EXTERNALSYM NTE_OP_OK}

{ FACILITY_CERT }

  { The specified trust provider is not known on this system. }
  TRUST_E_PROVIDER_UNKNOWN = HRESULT($800B0001);
  {$EXTERNALSYM TRUST_E_PROVIDER_UNKNOWN}

  { The trust verification action specified is not supported by the specified trust provider. }
  TRUST_E_ACTION_UNKNOWN = HRESULT($800B0002);
  {$EXTERNALSYM TRUST_E_ACTION_UNKNOWN}

  { The form specified for the subject is not one supported or known by the specified trust provider. }
  TRUST_E_SUBJECT_FORM_UNKNOWN = HRESULT($800B0003);
  {$EXTERNALSYM TRUST_E_SUBJECT_FORM_UNKNOWN}

  { The subject is not trusted for the specified action. }
  TRUST_E_SUBJECT_NOT_TRUSTED = HRESULT($800B0004);
  {$EXTERNALSYM TRUST_E_SUBJECT_NOT_TRUSTED}

  { Error due to problem in ASN.1 encoding process. }
  DIGSIG_E_ENCODE = HRESULT($800B0005);
  {$EXTERNALSYM DIGSIG_E_ENCODE}

  { Error due to problem in ASN.1 decoding process. }
  DIGSIG_E_DECODE = HRESULT($800B0006);
  {$EXTERNALSYM DIGSIG_E_DECODE}

  { Reading / writing Extensions where Attributes are appropriate, and visa versa. }
  DIGSIG_E_EXTENSIBILITY = HRESULT($800B0007);
  {$EXTERNALSYM DIGSIG_E_EXTENSIBILITY}

  { Unspecified cryptographic failure. }
  DIGSIG_E_CRYPTO = HRESULT($800B0008);
  {$EXTERNALSYM DIGSIG_E_CRYPTO}

  { The size of the data could not be determined. }
  PERSIST_E_SIZEDEFINITE = HRESULT($800B0009);
  {$EXTERNALSYM PERSIST_E_SIZEDEFINITE}

  { The size of the indefinite-sized data could not be determined. }
  PERSIST_E_SIZEINDEFINITE = HRESULT($800B000A);
  {$EXTERNALSYM PERSIST_E_SIZEINDEFINITE}

  { This object does not read and write self-sizing data. }
  PERSIST_E_NOTSELFSIZING = HRESULT($800B000B);
  {$EXTERNALSYM PERSIST_E_NOTSELFSIZING}

  { No signature was present in the subject. }
  TRUST_E_NOSIGNATURE = HRESULT($800B0100);
  {$EXTERNALSYM TRUST_E_NOSIGNATURE}

  { A required certificate is not within its validity period. }
  CERT_E_EXPIRED = HRESULT($800B0101);
  {$EXTERNALSYM CERT_E_EXPIRED}

  { The validity periods of the certification chain do not nest correctly. }
  CERT_E_VALIDIYPERIODNESTING = HRESULT($800B0102);
  {$EXTERNALSYM CERT_E_VALIDIYPERIODNESTING}

  { A certificate that can only be used as an end-entity is being used as a CA or visa versa. }
  CERT_E_ROLE = HRESULT($800B0103);
  {$EXTERNALSYM CERT_E_ROLE}

  { A path length constraint in the certification chain has been violated. }
  CERT_E_PATHLENCONST = HRESULT($800B0104);
  {$EXTERNALSYM CERT_E_PATHLENCONST}

  { An extension of unknown type that is labeled 'critical' is present in a certificate. }
  CERT_E_CRITICAL = HRESULT($800B0105);
  {$EXTERNALSYM CERT_E_CRITICAL}

  { A certificate is being used for a purpose other than that for which it is permitted. }
  CERT_E_PURPOSE = HRESULT($800B0106);
  {$EXTERNALSYM CERT_E_PURPOSE}

  { A parent of a given certificate in fact did not issue that child certificate. }
  CERT_E_ISSUERCHAINING = HRESULT($800B0107);
  {$EXTERNALSYM CERT_E_ISSUERCHAINING}

  { A certificate is missing or has an empty value for an important field, such as a subject or issuer name. }
  CERT_E_MALFORMED = HRESULT($800B0108);
  {$EXTERNALSYM CERT_E_MALFORMED}

  { A certification chain processed correctly, but terminated in a root certificate which isn't trusted by the trust provider. }
  CERT_E_UNTRUSTEDROOT = HRESULT($800B0109);
  {$EXTERNALSYM CERT_E_UNTRUSTEDROOT}

  { A chain of certs didn't chain as they should in a certain application of chaining. }
  CERT_E_CHAINING = HRESULT($800B010A);
  {$EXTERNALSYM CERT_E_CHAINING}

{ End WINERROR.H }


  { Abnormal termination codes }

  TC_NORMAL = 0;
  {$EXTERNALSYM TC_NORMAL}
  TC_HARDERR = 1;
  {$EXTERNALSYM TC_HARDERR}
  TC_GP_TRAP = 2;
  {$EXTERNALSYM TC_GP_TRAP}
  TC_SIGNAL = 3;
  {$EXTERNALSYM TC_SIGNAL}

  { Power Management APIs }

  AC_LINE_OFFLINE = 0;
  {$EXTERNALSYM AC_LINE_OFFLINE}
  AC_LINE_ONLINE = 1;
  {$EXTERNALSYM AC_LINE_ONLINE}
  AC_LINE_BACKUP_POWER = 2;
  {$EXTERNALSYM AC_LINE_BACKUP_POWER}
  AC_LINE_UNKNOWN = 255;
  {$EXTERNALSYM AC_LINE_UNKNOWN}

  BATTERY_FLAG_HIGH = 1;
  {$EXTERNALSYM BATTERY_FLAG_HIGH}
  BATTERY_FLAG_LOW = 2;
  {$EXTERNALSYM BATTERY_FLAG_LOW}
  BATTERY_FLAG_CRITICAL = 4;
  {$EXTERNALSYM BATTERY_FLAG_CRITICAL}
  BATTERY_FLAG_CHARGING = 8;
  {$EXTERNALSYM BATTERY_FLAG_CHARGING}
  BATTERY_FLAG_NO_BATTERY = $80;
  {$EXTERNALSYM BATTERY_FLAG_NO_BATTERY}
  BATTERY_FLAG_UNKNOWN = 255;
  {$EXTERNALSYM BATTERY_FLAG_UNKNOWN}
  BATTERY_PERCENTAGE_UNKNOWN = 255;
  {$EXTERNALSYM BATTERY_PERCENTAGE_UNKNOWN}
  BATTERY_LIFE_UNKNOWN = DWORD($FFFFFFFF);
  {$EXTERNALSYM BATTERY_LIFE_UNKNOWN}

type
  PSystemPowerStatus = ^TSystemPowerStatus;
  _SYSTEM_POWER_STATUS = packed record
    ACLineStatus : Byte;
    BatteryFlag : Byte;
    BatteryLifePercent : Byte;
    Reserved1 : Byte;
    BatteryLifeTime : DWORD;
    BatteryFullLifeTime : DWORD;
  end;
  {$EXTERNALSYM _SYSTEM_POWER_STATUS}
  TSystemPowerStatus = _SYSTEM_POWER_STATUS;
  SYSTEM_POWER_STATUS = _SYSTEM_POWER_STATUS;
  {$EXTERNALSYM SYSTEM_POWER_STATUS}

function GetSystemPowerStatus(var lpSystemPowerStatus: TSystemPowerStatus): BOOL; stdcall;
{$EXTERNALSYM GetSystemPowerStatus}
function SetSystemPowerState(fSuspend, fForce: BOOL): BOOL; stdcall;
{$EXTERNALSYM SetSystemPowerState}


{ Win Certificate API and Structures }

{ Structures }
type
  PWinCertificate = ^TWinCertificate;
  _WIN_CERTIFICATE = packed record
    dwLength: DWORD;
    wRevision: Word;
    wCertificateType: Word;         { WIN_CERT_TYPE_xxx }
    bCertificate: packed array[0..0] of Byte;
  end;
  {$EXTERNALSYM _WIN_CERTIFICATE}
  TWinCertificate = _WIN_CERTIFICATE;
  WIN_CERTIFICATE = _WIN_CERTIFICATE;
  {$EXTERNALSYM WIN_CERTIFICATE}

{ Currently, the only defined certificate revision is WIN_CERT_REVISION_1_0 }

const
  {$EXTERNALSYM WIN_CERT_REVISION_1_0}
  WIN_CERT_REVISION_1_0 = $0100;

{ Possible certificate types are specified by the following values }

  {$EXTERNALSYM WIN_CERT_TYPE_X509}
  WIN_CERT_TYPE_X509 = $0001;                        { bCertificate contains an X.509 Certificate }
  {$EXTERNALSYM WIN_CERT_TYPE_PKCS_SIGNED_DATA}
  WIN_CERT_TYPE_PKCS_SIGNED_DATA = $0002;            { bCertificate contains a PKCS SignedData structure }
  {$EXTERNALSYM WIN_CERT_TYPE_RESERVED_1}
  WIN_CERT_TYPE_RESERVED_1 = $0003;                  { Reserved }

{ API }

{$EXTERNALSYM WinSubmitCertificate}
function WinSubmitCertificate(var lpCertificate: TWinCertificate): BOOL; stdcall;

{ Trust API and Structures }

{$EXTERNALSYM WinVerifyTrust}
function WinVerifyTrust(hwnd: HWND; const ActionID: TGUID; ActionData: Pointer): Longint; stdcall;
{$EXTERNALSYM WinLoadTrustProvider}
function WinLoadTrustProvider(ActionID: PGUID): BOOL; stdcall;

{ Common Trust API Data Structures }

{ Data type commonly used in ActionData structures }

type
  TWinTrustSubject = Pointer;

{ Two commonly used ActionData structures }

  PWinTrustActdataContextWithSubject = ^TWinTrustActdataContextWithSubject;
  {$EXTERNALSYM _WIN_TRUST_ACTDATA_CONTEXT_WITH_SUBJECT}
  _WIN_TRUST_ACTDATA_CONTEXT_WITH_SUBJECT = record
    hClientToken: THandle;
    SubjectType: PGUID;
    Subject: TWinTrustSubject;
  end;
  TWinTrustActdataContextWithSubject = _WIN_TRUST_ACTDATA_CONTEXT_WITH_SUBJECT;
  {$EXTERNALSYM WIN_TRUST_ACTDATA_CONTEXT_WITH_SUBJECT}
  WIN_TRUST_ACTDATA_CONTEXT_WITH_SUBJECT = _WIN_TRUST_ACTDATA_CONTEXT_WITH_SUBJECT;


  PWinTrustActdataSubjectOnly = ^TWinTrustActdataSubjectOnly;
  {$EXTERNALSYM _WIN_TRUST_ACTDATA_SUBJECT_ONLY}
  _WIN_TRUST_ACTDATA_SUBJECT_ONLY = record
    SubjectType: PGUID;
    Subject: TWinTrustSubject;
  end;
  TWinTrustActdataSubjectOnly = _WIN_TRUST_ACTDATA_SUBJECT_ONLY;
  {$EXTERNALSYM WIN_TRUST_ACTDATA_SUBJECT_ONLY}
  WIN_TRUST_ACTDATA_SUBJECT_ONLY = _WIN_TRUST_ACTDATA_SUBJECT_ONLY;


{ SUBJECT FORM DEFINITIONS }

{ Currently defined Subject Type Identifiers.  All of the below
  use the WIN_TRUST_SUBJECT_FILE subject form, defined below. }

const
{ RawFile = 959dc450-8d9e-11cf-8736-00aa00a485eb }
  {$EXTERNALSYM WIN_TRUST_SUBJTYPE_RAW_FILE}
  WIN_TRUST_SUBJTYPE_RAW_FILE: TGUID =
    '{959dc450-8d9e-11cf-8736-00aa00a485eb}';

{ PeImage = 43c9a1e0-8da0-11cf-8736-00aa00a485eb }
  {$EXTERNALSYM WIN_TRUST_SUBJTYPE_PE_IMAGE}
  WIN_TRUST_SUBJTYPE_PE_IMAGE: TGUID =
    '{43c9a1e0-8da0-11cf-8736-00aa00a485eb}';

{ JavaClass = 08ad3990-8da1-11cf-8736-00aa00a485eb }
  {$EXTERNALSYM WIN_TRUST_SUBJTYPE_JAVA_CLASS}
  WIN_TRUST_SUBJTYPE_JAVA_CLASS: TGUID =
    '{08ad3990-8da1-11cf-8736-00aa00a485eb}';

{ Cabinet = d17c5374-a392-11cf-9df5-00aa00c184e0 }
  {$EXTERNALSYM WIN_TRUST_SUBJTYPE_CABINET}
  WIN_TRUST_SUBJTYPE_CABINET: TGUID =
    '{d17c5374-a392-11cf-9df5-00aa00c184e0}';

{ Associated Subject Data Structure: }


type
  PWinTrustSubjectFile = ^TWinTrustSubjectFile;
  {$EXTERNALSYM _WIN_TRUST_SUBJECT_FILE}
  _WIN_TRUST_SUBJECT_FILE = record
    hFile: THandle;
    lpPath: PWideChar;
  end;
  TWinTrustSubjectFile = _WIN_TRUST_SUBJECT_FILE;
  {$EXTERNALSYM WIN_TRUST_SUBJECT_FILE}
  WIN_TRUST_SUBJECT_FILE = _WIN_TRUST_SUBJECT_FILE;

{ The following subject types use the
  WIN_TRUST_SUBJECT_FILE_AND_DISPLAY subject type, defined
  below. }

const
  {$EXTERNALSYM WIN_TRUST_SUBJTYPE_RAW_FILEEX}
  WIN_TRUST_SUBJTYPE_RAW_FILEEX: TGUID = (
          D1:$6f458110; D2:$c2f1; D3:$11cf; D4:($8a, $69, $0, $aa, $0, $6c, $37, $6 ));

  {$EXTERNALSYM WIN_TRUST_SUBJTYPE_PE_IMAGEEX}
  WIN_TRUST_SUBJTYPE_PE_IMAGEEX: TGUID = (
          D1:$6f458111; D2:$c2f1; D3:$11cf; D4:($8a, $69, $0, $aa, $0, $6c, $37, $6 ));

  {$EXTERNALSYM WIN_TRUST_SUBJTYPE_JAVA_CLASSEX}
  WIN_TRUST_SUBJTYPE_JAVA_CLASSEX: TGUID = (
          D1:$6f458113; D2:$c2f1; D3:$11cf; D4:($8a, $69, $0, $aa, $0, $6c, $37, $6 ));

  {$EXTERNALSYM WIN_TRUST_SUBJTYPE_CABINETEX}
  WIN_TRUST_SUBJTYPE_CABINETEX: TGUID = (
          D1:$6f458114; D2:$c2f1; D3:$11cf; D4:($8a, $69, $0, $aa, $0, $6c, $37, $6 ));


{ Associated Subject Data Structure: }

type
  PWinTrustSubjectFileAndDisplay = ^TWinTrustSubjectFileAndDisplay;
  {$EXTERNALSYM _WIN_TRUST_SUBJECT_FILE_AND_DISPLAY}
  _WIN_TRUST_SUBJECT_FILE_AND_DISPLAY = record
    hFile: THandle;              { handle to the open file if you got it }
    lpPath: PWideString;         { the path to open if you don't }
    lpDisplayName: PWideString;  { (optional) display name to show to user }
                                 {      in place of path }
  end;
  TWinTrustSubjectFileAndDisplay = _WIN_TRUST_SUBJECT_FILE_AND_DISPLAY;
  {$EXTERNALSYM WIN_TRUST_SUBJECT_FILE_AND_DISPLAY}
  WIN_TRUST_SUBJECT_FILE_AND_DISPLAY = _WIN_TRUST_SUBJECT_FILE_AND_DISPLAY;

{ Other subject types: }

const
{ OleStorage == c257e740-8da0-11cf-8736-00aa00a485eb }
{$EXTERNALSYM WIN_TRUST_SUBJTYPE_OLE_STORAGE}
WIN_TRUST_SUBJTYPE_OLE_STORAGE: TGUID = (
          D1:$c257e740; D2:$8da0; D3:$11cf; D4:($87, $36, $00, $aa, $00, $a4, $85, $eb));


{ TRUST PROVIDER SPECIFIC DEFINITIONS

      Each trust provider will have the following
      sections defined:

      Actions - What actions are supported by the trust
          provider.
      SubjectForms - Subjects that may be evaluated by this
          trust provider.
                     and
      Data structures to support the subject forms. }


{ Software Publisher Trust Provider }

{ Actions: }

{ TrustedPublisher == 66426730-8da1-11cf-8736-00aa00a485eb }
  {$EXTERNALSYM WIN_SPUB_ACTION_TRUSTED_PUBLISHER}
  WIN_SPUB_ACTION_TRUSTED_PUBLISHER: TGUID = (
          D1:$66426730; D2:$8da1; D3:$11cf; D4:($87, $36, $00, $aa, $00, $a4, $85, $eb));

{ NtActivateImage == 8bc96b00-8da1-11cf-8736-00aa00a485eb }
  {$EXTERNALSYM WIN_SPUB_ACTION_NT_ACTIVATE_IMAGE}
  WIN_SPUB_ACTION_NT_ACTIVATE_IMAGE: TGUID = (
          D1:$8bc96b00; D2:$8da1; D3:$11cf; D4:($87, $36, $00, $aa, $00, $a4, $85, $eb));

{ PublishedSoftware == 64b9d180-8da2-11cf-8736-00aa00a485eb }
  {$EXTERNALSYM WIN_SPUB_ACTION_PUBLISHED_SOFTWARE}
  WIN_SPUB_ACTION_PUBLISHED_SOFTWARE: TGUID = (
          D1:$64b9d180; D2:$8da2; D3:$11cf; D4:($87, $36, $00, $aa, $00, $a4, $85, $eb));

{ Data Structures: }

{ WIN_SPUB_ACTION_TRUSTED_PUBLISHER:
      Uses WIN_SPUB_TRUSTED_PUBLISHER_DATA }

{ WIN_SPUB_ACTION_NT_ACTIVATE_IMAGE:
      Uses WIN_TRUST_ACTDATA_CONTEXT_WITH_SUBJECT }

{ WIN_SPUB_ACTION_PUBLISHED_SOFTWARE:
      Uses WIN_TRUST_ACTDATA_CONTEXT_WITH_SUBJECT }

type
  PWinSpubTrustedPublisherData = ^TWinSpubTrustedPublisherData;
  {$EXTERNALSYM _WIN_SPUB_TRUSTED_PUBLISHER_DATA}
  _WIN_SPUB_TRUSTED_PUBLISHER_DATA = record
    hClientToken: THandle;
    lpCertificate: PWinCertificate;
  end;
  TWinSpubTrustedPublisherData = _WIN_SPUB_TRUSTED_PUBLISHER_DATA;
  {$EXTERNALSYM WIN_SPUB_TRUSTED_PUBLISHER_DATA}
  WIN_SPUB_TRUSTED_PUBLISHER_DATA = _WIN_SPUB_TRUSTED_PUBLISHER_DATA;

{ Translated from WINGDI.H }

const
  { Binary raster ops }
  {$EXTERNALSYM R2_BLACK}
  R2_BLACK       = 1;     {  0   }
  {$EXTERNALSYM R2_NOTMERGEPEN}
  R2_NOTMERGEPEN = 2;     { DPon }
  {$EXTERNALSYM R2_MASKNOTPEN}
  R2_MASKNOTPEN  = 3;     { DPna }
  {$EXTERNALSYM R2_NOTCOPYPEN}
  R2_NOTCOPYPEN  = 4;     { PN   }
  {$EXTERNALSYM R2_MASKPENNOT}
  R2_MASKPENNOT  = 5;     { PDna }
  {$EXTERNALSYM R2_NOT}
  R2_NOT         = 6;     { Dn   }
  {$EXTERNALSYM R2_XORPEN}
  R2_XORPEN      = 7;     { DPx  }
  {$EXTERNALSYM R2_NOTMASKPEN}
  R2_NOTMASKPEN  = 8;     { DPan }
  {$EXTERNALSYM R2_MASKPEN}
  R2_MASKPEN     = 9;     { DPa  }
  {$EXTERNALSYM R2_NOTXORPEN}
  R2_NOTXORPEN   = 10;    { DPxn }
  {$EXTERNALSYM R2_NOP}
  R2_NOP         = 11;    { D    }
  {$EXTERNALSYM R2_MERGENOTPEN}
  R2_MERGENOTPEN = 12;    { DPno }
  {$EXTERNALSYM R2_COPYPEN}
  R2_COPYPEN     = 13;    { P    }
  {$EXTERNALSYM R2_MERGEPENNOT}
  R2_MERGEPENNOT = 14;    { PDno }
  {$EXTERNALSYM R2_MERGEPEN}
  R2_MERGEPEN    = 15;    { DPo  }
  {$EXTERNALSYM R2_WHITE}
  R2_WHITE       = $10;   {  1   }
  {$EXTERNALSYM R2_LAST}
  R2_LAST        = $10;


  { Ternary raster operations }
  {$EXTERNALSYM SRCCOPY}
  SRCCOPY     = $00CC0020;     { dest = source                    }
  {$EXTERNALSYM SRCPAINT}
  SRCPAINT    = $00EE0086;     { dest = source OR dest            }
  {$EXTERNALSYM SRCAND}
  SRCAND      = $008800C6;     { dest = source AND dest           }
  {$EXTERNALSYM SRCINVERT}
  SRCINVERT   = $00660046;     { dest = source XOR dest           }
  {$EXTERNALSYM SRCERASE}
  SRCERASE    = $00440328;     { dest = source AND (NOT dest )    }
  {$EXTERNALSYM NOTSRCCOPY}
  NOTSRCCOPY  = $00330008;     { dest = (NOT source)              }
  {$EXTERNALSYM NOTSRCERASE}
  NOTSRCERASE = $001100A6;     { dest = (NOT src) AND (NOT dest)  }
  {$EXTERNALSYM MERGECOPY}
  MERGECOPY   = $00C000CA;     { dest = (source AND pattern)      }
  {$EXTERNALSYM MERGEPAINT}
  MERGEPAINT  = $00BB0226;     { dest = (NOT source) OR dest      }
  {$EXTERNALSYM PATCOPY}
  PATCOPY     = $00F00021;     { dest = pattern                   }
  {$EXTERNALSYM PATPAINT}
  PATPAINT    = $00FB0A09;     { dest = DPSnoo                    }
  {$EXTERNALSYM PATINVERT}
  PATINVERT   = $005A0049;     { dest = pattern XOR dest          }
  {$EXTERNALSYM DSTINVERT}
  DSTINVERT   = $00550009;     { dest = (NOT dest)                }
  {$EXTERNALSYM BLACKNESS}
  BLACKNESS   = $00000042;     { dest = BLACK                     }
  {$EXTERNALSYM WHITENESS}
  WHITENESS   = $00FF0062;     { dest = WHITE                     }


{ Quaternary raster codes }

{$EXTERNALSYM MakeROP4}
function MakeROP4(fore,back: DWORD): DWORD; inline;

const
  {$EXTERNALSYM GDI_ERROR}
  GDI_ERROR = DWORD($FFFFFFFF);
  {$EXTERNALSYM HGDI_ERROR}
  HGDI_ERROR = DWORD($FFFFFFFF);


  { Region Flags }
  {$EXTERNALSYM ERROR}
  ERROR = 0;
  {$EXTERNALSYM NULLREGION}
  NULLREGION = 1;
  {$EXTERNALSYM SIMPLEREGION}
  SIMPLEREGION = 2;
  {$EXTERNALSYM COMPLEXREGION}
  COMPLEXREGION = 3;
  {$EXTERNALSYM RGN_ERROR}
  RGN_ERROR = ERROR;


  { CombineRgn() Styles }
  {$EXTERNALSYM RGN_AND}
  RGN_AND = 1;
  {$EXTERNALSYM RGN_OR}
  RGN_OR = 2;
  {$EXTERNALSYM RGN_XOR}
  RGN_XOR = 3;
  {$EXTERNALSYM RGN_DIFF}
  RGN_DIFF = 4;
  {$EXTERNALSYM RGN_COPY}
  RGN_COPY = 5;
  {$EXTERNALSYM RGN_MIN}
  RGN_MIN = RGN_AND;
  {$EXTERNALSYM RGN_MAX}
  RGN_MAX = RGN_COPY;

  { StretchBlt() Modes }
  {$EXTERNALSYM BLACKONWHITE}
  BLACKONWHITE = 1;
  {$EXTERNALSYM WHITEONBLACK}
  WHITEONBLACK = 2;
  {$EXTERNALSYM COLORONCOLOR}
  COLORONCOLOR = 3;
  {$EXTERNALSYM HALFTONE}
  HALFTONE = 4;
  {$EXTERNALSYM MAXSTRETCHBLTMODE}
  MAXSTRETCHBLTMODE = 4;


  { New StretchBlt() Modes }
  {$EXTERNALSYM STRETCH_ANDSCANS}
  STRETCH_ANDSCANS = BLACKONWHITE;
  {$EXTERNALSYM STRETCH_ORSCANS}
  STRETCH_ORSCANS = WHITEONBLACK;
  {$EXTERNALSYM STRETCH_DELETESCANS}
  STRETCH_DELETESCANS = COLORONCOLOR;
  {$EXTERNALSYM STRETCH_HALFTONE}
  STRETCH_HALFTONE = HALFTONE;


  { PolyFill() Modes }
  {$EXTERNALSYM ALTERNATE}
  ALTERNATE = 1;
  {$EXTERNALSYM WINDING}
  WINDING = 2;
  {$EXTERNALSYM POLYFILL_LAST}
  POLYFILL_LAST = 2;


  { Text Alignment Options }
  {$EXTERNALSYM TA_NOUPDATECP}
  TA_NOUPDATECP = 0;
  {$EXTERNALSYM TA_UPDATECP}
  TA_UPDATECP = 1;
  {$EXTERNALSYM TA_LEFT}
  TA_LEFT = 0;
  {$EXTERNALSYM TA_RIGHT}
  TA_RIGHT = 2;
  {$EXTERNALSYM TA_CENTER}
  TA_CENTER = 6;
  {$EXTERNALSYM TA_TOP}
  TA_TOP = 0;
  {$EXTERNALSYM TA_BOTTOM}
  TA_BOTTOM = 8;
  {$EXTERNALSYM TA_BASELINE}
  TA_BASELINE = 24;
  {$EXTERNALSYM TA_RTLREADING}
  TA_RTLREADING = $100;
  {$EXTERNALSYM TA_MASK}
  TA_MASK =  (TA_BASELINE+TA_CENTER+TA_UPDATECP+TA_RTLREADING);

  {$EXTERNALSYM VTA_BASELINE}
  VTA_BASELINE = TA_BASELINE;
  {$EXTERNALSYM VTA_LEFT}
  VTA_LEFT = TA_BOTTOM;
  {$EXTERNALSYM VTA_RIGHT}
  VTA_RIGHT = TA_TOP;
  {$EXTERNALSYM VTA_CENTER}
  VTA_CENTER = TA_CENTER;
  {$EXTERNALSYM VTA_BOTTOM}
  VTA_BOTTOM = TA_RIGHT;
  {$EXTERNALSYM VTA_TOP}
  VTA_TOP = TA_LEFT;

  {$EXTERNALSYM ETO_OPAQUE}
  ETO_OPAQUE = 2;
  {$EXTERNALSYM ETO_CLIPPED}
  ETO_CLIPPED = 4;
  {$EXTERNALSYM ETO_GLYPH_INDEX}
  ETO_GLYPH_INDEX = $10;
  {$EXTERNALSYM ETO_RTLREADING}
  ETO_RTLREADING = $80;
  {$EXTERNALSYM ETO_NUMERICSLOCAL}
  ETO_NUMERICSLOCAL = $400;
  {$EXTERNALSYM ETO_NUMERICSLATIN}
  ETO_NUMERICSLATIN = $800;
  {$EXTERNALSYM ETO_IGNORELANGUAGE}
  ETO_IGNORELANGUAGE = $1000;
  {$EXTERNALSYM ETO_PDY}
  ETO_PDY = $2000;

  {$EXTERNALSYM ASPECT_FILTERING}
  ASPECT_FILTERING = 1;


  { Bounds Accumulation APIs }
  {$EXTERNALSYM DCB_RESET}
  DCB_RESET = 1;
  {$EXTERNALSYM DCB_ACCUMULATE}
  DCB_ACCUMULATE = 2;
  {$EXTERNALSYM DCB_DIRTY}
  DCB_DIRTY = DCB_ACCUMULATE;
  {$EXTERNALSYM DCB_SET}
  DCB_SET = (DCB_RESET or DCB_ACCUMULATE);
  {$EXTERNALSYM DCB_ENABLE}
  DCB_ENABLE = 4;
  {$EXTERNALSYM DCB_DISABLE}
  DCB_DISABLE = 8;

  { Metafile Functions }
  {$EXTERNALSYM META_SETBKCOLOR}
  META_SETBKCOLOR = 513;
  {$EXTERNALSYM META_SETBKMODE}
  META_SETBKMODE = 258;
  {$EXTERNALSYM META_SETMAPMODE}
  META_SETMAPMODE = 259;
  {$EXTERNALSYM META_SETROP2}
  META_SETROP2 = 260;
  {$EXTERNALSYM META_SETRELABS}
  META_SETRELABS = 261;
  {$EXTERNALSYM META_SETPOLYFILLMODE}
  META_SETPOLYFILLMODE = 262;
  {$EXTERNALSYM META_SETSTRETCHBLTMODE}
  META_SETSTRETCHBLTMODE = 263;
  {$EXTERNALSYM META_SETTEXTCHAREXTRA}
  META_SETTEXTCHAREXTRA = 264;
  {$EXTERNALSYM META_SETTEXTCOLOR}
  META_SETTEXTCOLOR = 521;
  {$EXTERNALSYM META_SETTEXTJUSTIFICATION}
  META_SETTEXTJUSTIFICATION = 522;
  {$EXTERNALSYM META_SETWINDOWORG}
  META_SETWINDOWORG = 523;
  {$EXTERNALSYM META_SETWINDOWEXT}
  META_SETWINDOWEXT = 524;
  {$EXTERNALSYM META_SETVIEWPORTORG}
  META_SETVIEWPORTORG = 525;
  {$EXTERNALSYM META_SETVIEWPORTEXT}
  META_SETVIEWPORTEXT = 526;
  {$EXTERNALSYM META_OFFSETWINDOWORG}
  META_OFFSETWINDOWORG = 527;
  {$EXTERNALSYM META_SCALEWINDOWEXT}
  META_SCALEWINDOWEXT = 1040;
  {$EXTERNALSYM META_OFFSETVIEWPORTORG}
  META_OFFSETVIEWPORTORG = 529;
  {$EXTERNALSYM META_SCALEVIEWPORTEXT}
  META_SCALEVIEWPORTEXT = 1042;
  {$EXTERNALSYM META_LINETO}
  META_LINETO = 531;
  {$EXTERNALSYM META_MOVETO}
  META_MOVETO = 532;
  {$EXTERNALSYM META_EXCLUDECLIPRECT}
  META_EXCLUDECLIPRECT = 1045;
  {$EXTERNALSYM META_INTERSECTCLIPRECT}
  META_INTERSECTCLIPRECT = 1046;
  {$EXTERNALSYM META_ARC}
  META_ARC = 2071;
  {$EXTERNALSYM META_ELLIPSE}
  META_ELLIPSE = 1048;
  {$EXTERNALSYM META_FLOODFILL}
  META_FLOODFILL = 1049;
  {$EXTERNALSYM META_PIE}
  META_PIE = 2074;
  {$EXTERNALSYM META_RECTANGLE}
  META_RECTANGLE = 1051;
  {$EXTERNALSYM META_ROUNDRECT}
  META_ROUNDRECT = 1564;
  {$EXTERNALSYM META_PATBLT}
  META_PATBLT = 1565;
  {$EXTERNALSYM META_SAVEDC}
  META_SAVEDC = 30;
  {$EXTERNALSYM META_SETPIXEL}
  META_SETPIXEL = 1055;
  {$EXTERNALSYM META_OFFSETCLIPRGN}
  META_OFFSETCLIPRGN = 544;
  {$EXTERNALSYM META_TEXTOUT}
  META_TEXTOUT = 1313;
  {$EXTERNALSYM META_BITBLT}
  META_BITBLT = 2338;
  {$EXTERNALSYM META_STRETCHBLT}
  META_STRETCHBLT = 2851;
  {$EXTERNALSYM META_POLYGON}
  META_POLYGON = 804;
  {$EXTERNALSYM META_POLYLINE}
  META_POLYLINE = 805;
  {$EXTERNALSYM META_ESCAPE}
  META_ESCAPE = 1574;
  {$EXTERNALSYM META_RESTOREDC}
  META_RESTOREDC = 295;
  {$EXTERNALSYM META_FILLREGION}
  META_FILLREGION = 552;
  {$EXTERNALSYM META_FRAMEREGION}
  META_FRAMEREGION = 1065;
  {$EXTERNALSYM META_INVERTREGION}
  META_INVERTREGION = 298;
  {$EXTERNALSYM META_PAINTREGION}
  META_PAINTREGION = 299;
  {$EXTERNALSYM META_SELECTCLIPREGION}
  META_SELECTCLIPREGION = 300;
  {$EXTERNALSYM META_SELECTOBJECT}
  META_SELECTOBJECT = 301;
  {$EXTERNALSYM META_SETTEXTALIGN}
  META_SETTEXTALIGN = 302;
  {$EXTERNALSYM META_CHORD}
  META_CHORD = 2096;
  {$EXTERNALSYM META_SETMAPPERFLAGS}
  META_SETMAPPERFLAGS = 561;
  {$EXTERNALSYM META_EXTTEXTOUT}
  META_EXTTEXTOUT = 2610;
  {$EXTERNALSYM META_SETDIBTODEV}
  META_SETDIBTODEV = 3379;
  {$EXTERNALSYM META_SELECTPALETTE}
  META_SELECTPALETTE = 564;
  {$EXTERNALSYM META_REALIZEPALETTE}
  META_REALIZEPALETTE = 53;
  {$EXTERNALSYM META_ANIMATEPALETTE}
  META_ANIMATEPALETTE = 1078;
  {$EXTERNALSYM META_SETPALENTRIES}
  META_SETPALENTRIES = 55;
  {$EXTERNALSYM META_POLYPOLYGON}
  META_POLYPOLYGON = 1336;
  {$EXTERNALSYM META_RESIZEPALETTE}
  META_RESIZEPALETTE = 313;
  {$EXTERNALSYM META_DIBBITBLT}
  META_DIBBITBLT = 2368;
  {$EXTERNALSYM META_DIBSTRETCHBLT}
  META_DIBSTRETCHBLT = 2881;
  {$EXTERNALSYM META_DIBCREATEPATTERNBRUSH}
  META_DIBCREATEPATTERNBRUSH = 322;
  {$EXTERNALSYM META_STRETCHDIB}
  META_STRETCHDIB = 3907;
  {$EXTERNALSYM META_EXTFLOODFILL}
  META_EXTFLOODFILL = 1352;
  {$EXTERNALSYM META_DELETEOBJECT}
  META_DELETEOBJECT = 496;
  {$EXTERNALSYM META_CREATEPALETTE}
  META_CREATEPALETTE = 247;
  {$EXTERNALSYM META_CREATEPATTERNBRUSH}
  META_CREATEPATTERNBRUSH = 505;
  {$EXTERNALSYM META_CREATEPENINDIRECT}
  META_CREATEPENINDIRECT = 762;
  {$EXTERNALSYM META_CREATEFONTINDIRECT}
  META_CREATEFONTINDIRECT = 763;
  {$EXTERNALSYM META_CREATEBRUSHINDIRECT}
  META_CREATEBRUSHINDIRECT = 764;
  {$EXTERNALSYM META_CREATEREGION}
  META_CREATEREGION = 1791;


  { GDI Escapes }
  {$EXTERNALSYM NEWFRAME}
  NEWFRAME = 1;
  _ABORTDOC = 2; { Renamed }
  {$EXTERNALSYM NEXTBAND}
  NEXTBAND = 3;
  {$EXTERNALSYM SETCOLORTABLE}
  SETCOLORTABLE = 4;
  {$EXTERNALSYM GETCOLORTABLE}
  GETCOLORTABLE = 5;
  {$EXTERNALSYM FLUSHOUTPUT}
  FLUSHOUTPUT = 6;
  {$EXTERNALSYM DRAFTMODE}
  DRAFTMODE = 7;
  {$EXTERNALSYM QUERYESCSUPPORT}
  QUERYESCSUPPORT = 8;
  _SETABORTPROC = 9; { Renamed }
  _STARTDOC = 10; { Renamed }
  _ENDDOC = 11; { Renamed }
  {$EXTERNALSYM GETPHYSPAGESIZE}
  GETPHYSPAGESIZE = 12;
  {$EXTERNALSYM GETPRINTINGOFFSET}
  GETPRINTINGOFFSET = 13;
  {$EXTERNALSYM GETSCALINGFACTOR}
  GETSCALINGFACTOR = 14;
  {$EXTERNALSYM MFCOMMENT}
  MFCOMMENT = 15;
  {$EXTERNALSYM GETPENWIDTH}
  GETPENWIDTH = $10;
  {$EXTERNALSYM SETCOPYCOUNT}
  SETCOPYCOUNT = 17;
  {$EXTERNALSYM SELECTPAPERSOURCE}
  SELECTPAPERSOURCE = 18;
  {$EXTERNALSYM DEVICEDATA}
  DEVICEDATA = 19;
  {$EXTERNALSYM PASSTHROUGH}
  PASSTHROUGH = 19;
  {$EXTERNALSYM GETTECHNOLGY}
  GETTECHNOLGY = 20;
  {$EXTERNALSYM GETTECHNOLOGY}
  GETTECHNOLOGY = 20;
  {$EXTERNALSYM SETLINECAP}
  SETLINECAP = 21;
  {$EXTERNALSYM SETLINEJOIN}
  SETLINEJOIN = 22;
  _SETMITERLIMIT = 23; { Renamed }
  {$EXTERNALSYM BANDINFO}
  BANDINFO = 24;
  {$EXTERNALSYM DRAWPATTERNRECT}
  DRAWPATTERNRECT = 25;
  {$EXTERNALSYM GETVECTORPENSIZE}
  GETVECTORPENSIZE = 26;
  {$EXTERNALSYM GETVECTORBRUSHSIZE}
  GETVECTORBRUSHSIZE = 27;
  {$EXTERNALSYM ENABLEDUPLEX}
  ENABLEDUPLEX = 28;
  {$EXTERNALSYM GETSETPAPERBINS}
  GETSETPAPERBINS = 29;
  {$EXTERNALSYM GETSETPRINTORIENT}
  GETSETPRINTORIENT = 30;
  {$EXTERNALSYM ENUMPAPERBINS}
  ENUMPAPERBINS = 31;
  {$EXTERNALSYM SETDIBSCALING}
  SETDIBSCALING = $20;
  {$EXTERNALSYM EPSPRINTING}
  EPSPRINTING = 33;
  {$EXTERNALSYM ENUMPAPERMETRICS}
  ENUMPAPERMETRICS = 34;
  {$EXTERNALSYM GETSETPAPERMETRICS}
  GETSETPAPERMETRICS = 35;
  {$EXTERNALSYM POSTSCRIPT_DATA}
  POSTSCRIPT_DATA = 37;
  {$EXTERNALSYM POSTSCRIPT_IGNORE}
  POSTSCRIPT_IGNORE = 38;
  {$EXTERNALSYM MOUSETRAILS}
  MOUSETRAILS = 39;
  {$EXTERNALSYM GETDEVICEUNITS}
  GETDEVICEUNITS = 42;

  {$EXTERNALSYM GETEXTENDEDTEXTMETRICS}
  GETEXTENDEDTEXTMETRICS = 256;
  {$EXTERNALSYM GETEXTENTTABLE}
  GETEXTENTTABLE = 257;
  {$EXTERNALSYM GETPAIRKERNTABLE}
  GETPAIRKERNTABLE = 258;
  {$EXTERNALSYM GETTRACKKERNTABLE}
  GETTRACKKERNTABLE = 259;
  _EXTTEXTOUT = $200; { Renamed }
  {$EXTERNALSYM GETFACENAME}
  GETFACENAME = 513;
  {$EXTERNALSYM DOWNLOADFACE}
  DOWNLOADFACE = 514;
  {$EXTERNALSYM ENABLERELATIVEWIDTHS}
  ENABLERELATIVEWIDTHS = 768;
  {$EXTERNALSYM ENABLEPAIRKERNING}
  ENABLEPAIRKERNING = 769;
  {$EXTERNALSYM SETKERNTRACK}
  SETKERNTRACK = 770;
  {$EXTERNALSYM SETALLJUSTVALUES}
  SETALLJUSTVALUES = 771;
  {$EXTERNALSYM SETCHARSET}
  SETCHARSET = 772;

  _STRETCHBLT = $800; { Renamed }
  {$EXTERNALSYM GETSETSCREENPARAMS}
  GETSETSCREENPARAMS = 3072;
  {$EXTERNALSYM QUERYDIBSUPPORT}
  QUERYDIBSUPPORT = 3073;
  {$EXTERNALSYM BEGIN_PATH}
  BEGIN_PATH = $1000;
  {$EXTERNALSYM CLIP_TO_PATH}
  CLIP_TO_PATH = 4097;
  {$EXTERNALSYM END_PATH}
  END_PATH = 4098;
  {$EXTERNALSYM EXT_DEVICE_CAPS}
  EXT_DEVICE_CAPS = 4099;
  {$EXTERNALSYM RESTORE_CTM}
  RESTORE_CTM = 4100;
  {$EXTERNALSYM SAVE_CTM}
  SAVE_CTM = 4101;
  {$EXTERNALSYM SET_ARC_DIRECTION}
  SET_ARC_DIRECTION = 4102;
  {$EXTERNALSYM SET_BACKGROUND_COLOR}
  SET_BACKGROUND_COLOR = 4103;
  {$EXTERNALSYM SET_POLY_MODE}
  SET_POLY_MODE = 4104;
  {$EXTERNALSYM SET_SCREEN_ANGLE}
  SET_SCREEN_ANGLE = 4105;
  {$EXTERNALSYM SET_SPREAD}
  SET_SPREAD = 4106;
  {$EXTERNALSYM TRANSFORM_CTM}
  TRANSFORM_CTM = 4107;
  {$EXTERNALSYM SET_CLIP_BOX}
  SET_CLIP_BOX = 4108;
  {$EXTERNALSYM SET_BOUNDS}
  SET_BOUNDS = 4109;
  {$EXTERNALSYM SET_MIRROR_MODE}
  SET_MIRROR_MODE = 4110;
  {$EXTERNALSYM OPENCHANNEL}
  OPENCHANNEL = 4110;
  {$EXTERNALSYM DOWNLOADHEADER}
  DOWNLOADHEADER = 4111;
  {$EXTERNALSYM CLOSECHANNEL}
  CLOSECHANNEL = 4112;
  {$EXTERNALSYM POSTSCRIPT_PASSTHROUGH}
  POSTSCRIPT_PASSTHROUGH = 4115;
  {$EXTERNALSYM ENCAPSULATED_POSTSCRIPT}
  ENCAPSULATED_POSTSCRIPT = 4116;

  { Flag returned from QUERYDIBSUPPORT }
  {$EXTERNALSYM QDI_SETDIBITS}
  QDI_SETDIBITS = 1;
  {$EXTERNALSYM QDI_GETDIBITS}
  QDI_GETDIBITS = 2;
  {$EXTERNALSYM QDI_DIBTOSCREEN}
  QDI_DIBTOSCREEN = 4;
  {$EXTERNALSYM QDI_STRETCHDIB}
  QDI_STRETCHDIB = 8;


  { Spooler Error Codes }
  {$EXTERNALSYM SP_NOTREPORTED}
  SP_NOTREPORTED = $4000;
  {$EXTERNALSYM SP_ERROR}
  SP_ERROR = LongWord(-1);
  {$EXTERNALSYM SP_APPABORT}
  SP_APPABORT = LongWord(-2);
  {$EXTERNALSYM SP_USERABORT}
  SP_USERABORT = LongWord(-3);
  {$EXTERNALSYM SP_OUTOFDISK}
  SP_OUTOFDISK = LongWord(-4);
  {$EXTERNALSYM SP_OUTOFMEMORY}
  SP_OUTOFMEMORY = LongWord(-5);

  {$EXTERNALSYM PR_JOBSTATUS}
  PR_JOBSTATUS = 0;


  { Object Definitions for EnumObjects() }
  {$EXTERNALSYM OBJ_PEN}
  OBJ_PEN = 1;
  {$EXTERNALSYM OBJ_BRUSH}
  OBJ_BRUSH = 2;
  {$EXTERNALSYM OBJ_DC}
  OBJ_DC = 3;
  {$EXTERNALSYM OBJ_METADC}
  OBJ_METADC = 4;
  {$EXTERNALSYM OBJ_PAL}
  OBJ_PAL = 5;
  {$EXTERNALSYM OBJ_FONT}
  OBJ_FONT = 6;
  {$EXTERNALSYM OBJ_BITMAP}
  OBJ_BITMAP = 7;
  {$EXTERNALSYM OBJ_REGION}
  OBJ_REGION = 8;
  {$EXTERNALSYM OBJ_METAFILE}
  OBJ_METAFILE = 9;
  {$EXTERNALSYM OBJ_MEMDC}
  OBJ_MEMDC = 10;
  {$EXTERNALSYM OBJ_EXTPEN}
  OBJ_EXTPEN = 11;
  {$EXTERNALSYM OBJ_ENHMETADC}
  OBJ_ENHMETADC = 12;
  {$EXTERNALSYM OBJ_ENHMETAFILE}
  OBJ_ENHMETAFILE = 13;


  { xform stuff }
  {$EXTERNALSYM MWT_IDENTITY}
  MWT_IDENTITY = 1;
  {$EXTERNALSYM MWT_LEFTMULTIPLY}
  MWT_LEFTMULTIPLY = 2;
  {$EXTERNALSYM MWT_RIGHTMULTIPLY}
  MWT_RIGHTMULTIPLY = 3;

  {$EXTERNALSYM MWT_MIN}
  MWT_MIN = MWT_IDENTITY;
  {$EXTERNALSYM MWT_MAX}
  MWT_MAX = MWT_RIGHTMULTIPLY;


type
  PXForm = ^TXForm;
  {$EXTERNALSYM tagXFORM}
  tagXFORM = packed record
    eM11: Single;
    eM12: Single;
    eM21: Single;
    eM22: Single;
    eDx: Single;
    eDy: Single;
  end;
  TXForm = tagXFORM;
  {$EXTERNALSYM XFORM}
  XFORM = tagXFORM;

{ Bitmap Header Definition }
  PBitmap = ^TBitmap;
  {$EXTERNALSYM tagBITMAP}
  tagBITMAP = packed record
    bmType: Longint;
    bmWidth: Longint;
    bmHeight: Longint;
    bmWidthBytes: Longint;
    bmPlanes: Word;
    bmBitsPixel: Word;
    bmBits: Pointer;
  end;
  TBitmap = tagBITMAP;
  {$EXTERNALSYM BITMAP}
  BITMAP = tagBITMAP;

  PRGBTriple = ^TRGBTriple;
  {$EXTERNALSYM tagRGBTRIPLE}
  tagRGBTRIPLE = packed record
    rgbtBlue: Byte;
    rgbtGreen: Byte;
    rgbtRed: Byte;
  end;
  TRGBTriple = tagRGBTRIPLE;
  {$EXTERNALSYM RGBTRIPLE}
  RGBTRIPLE = tagRGBTRIPLE;

  PRGBQuad = ^TRGBQuad;
  {$EXTERNALSYM tagRGBQUAD}
  tagRGBQUAD = packed record
    rgbBlue: Byte;
    rgbGreen: Byte;
    rgbRed: Byte;
    rgbReserved: Byte;
  end;
  TRGBQuad = tagRGBQUAD;
  {$EXTERNALSYM RGBQUAD}
  RGBQUAD = tagRGBQUAD;


  { Image Color Matching color definitions }
  {$EXTERNALSYM LCSCSTYPE}
  LCSCSTYPE = Longint;
const
  {$EXTERNALSYM LCS_CALIBRATED_RGB}
  LCS_CALIBRATED_RGB = 0;
  {$EXTERNALSYM LCS_DEVICE_RGB}
  LCS_DEVICE_RGB = 1;
  {$EXTERNALSYM LCS_DEVICE_CMYK}
  LCS_DEVICE_CMYK = 2;

type
  {$EXTERNALSYM LCSGAMUTMATCH}
  LCSGAMUTMATCH = Longint;
const
  {$EXTERNALSYM LCS_GM_BUSINESS}
  LCS_GM_BUSINESS = 1;
  {$EXTERNALSYM LCS_GM_GRAPHICS}
  LCS_GM_GRAPHICS = 2;
  {$EXTERNALSYM LCS_GM_IMAGES}
  LCS_GM_IMAGES = 4;


  { ICM Defines for results from CheckColorInGamut() }
  {$EXTERNALSYM CM_OUT_OF_GAMUT}
  CM_OUT_OF_GAMUT = 255;
  {$EXTERNALSYM CM_IN_GAMUT}
  CM_IN_GAMUT = 0;


{ functions to retrieve CMYK values from a COLORREF }

{$EXTERNALSYM GetCValue}
function GetCValue(cmyk: COLORREF): Byte; inline;
{$EXTERNALSYM GetMValue}
function GetMValue(cmyk: COLORREF): Byte; inline;
{$EXTERNALSYM GetYValue}
function GetYValue(cmyk: COLORREF): Byte; inline;
{$EXTERNALSYM GetKValue}
function GetKValue(cmyk: COLORREF): Byte; inline;
{$EXTERNALSYM CMYK}
function CMYK(c, m, y, k: Byte): COLORREF;

type
  {$EXTERNALSYM FXPT16DOT16}
  FXPT16DOT16 = Longint;
  {$EXTERNALSYM LPFXPT16DOT16}
  LPFXPT16DOT16 = ^Longint;
  {$EXTERNALSYM FXPT2DOT30}
  FXPT2DOT30 = Longint;
  {$EXTERNALSYM LPFXPT2DOT30}
  LPFXPT2DOT30 = ^Longint;


  { ICM Color Definitions }
  { The following two structures are used for defining RGB's in terms of
    CIEXYZ. The values are fixed point 16.16. }

  PCIEXYZ = ^TCIEXYZ;
  {$EXTERNALSYM tagCIEXYZ}
  tagCIEXYZ = packed record
    ciexyzX: FXPT2DOT30;
    ciexyzY: FXPT2DOT30;
    ciexyzZ: FXPT2DOT30;
  end;
  TCIEXYZ = tagCIEXYZ;
  {$EXTERNALSYM CIEXYZ}
  CIEXYZ = tagCIEXYZ;

  PCIEXYZTriple = ^TCIEXYZTriple;
  {$EXTERNALSYM tagICEXYZTRIPLE}
  tagICEXYZTRIPLE = packed record
    ciexyzRed: TCIEXYZ;
    ciexyzGreen: TCIEXYZ;
    ciexyzBlue: TCIEXYZ;
  end;
  TCIEXYZTriple = tagICEXYZTRIPLE;
  {$EXTERNALSYM CIEXYZTRIPLE}
  CIEXYZTRIPLE = tagICEXYZTRIPLE;

  { The next structures the logical color space. Unlike pens and brushes,
    but like palettes, there is only one way to create a LogColorSpace.
    A pointer to it must be passed, its elements can't be pushed as
    arguments. }

type
  PLogColorSpaceA = ^TLogColorSpaceA;
  PLogColorSpaceW = ^TLogColorSpaceW;
  PLogColorSpace = PLogColorSpaceA;
  {$EXTERNALSYM tagLOGCOLORSPACEA}
  tagLOGCOLORSPACEA = packed record
    lcsSignature: DWORD;
    lcsVersion: DWORD;
    lcsSize: DWORD;
    lcsCSType: LCSCSTYPE;
    lcsIntent: LCSGAMUTMATCH;
    lcsEndpoints: TCIEXYZTriple;
    lcsGammaRed: DWORD;
    lcsGammaGreen: DWORD;
    lcsGammaBlue: DWORD;
    lcsFilename: array[0..259] of AnsiChar;
  end;
  {$EXTERNALSYM tagLOGCOLORSPACEW}
  tagLOGCOLORSPACEW = packed record
    lcsSignature: DWORD;
    lcsVersion: DWORD;
    lcsSize: DWORD;
    lcsCSType: LCSCSTYPE;
    lcsIntent: LCSGAMUTMATCH;
    lcsEndpoints: TCIEXYZTriple;
    lcsGammaRed: DWORD;
    lcsGammaGreen: DWORD;
    lcsGammaBlue: DWORD;
    lcsFilename: array[0..259] of WideChar;
  end;
  {$EXTERNALSYM tagLOGCOLORSPACE}
  tagLOGCOLORSPACE = tagLOGCOLORSPACEA;
  TLogColorSpaceA = tagLOGCOLORSPACEA;
  TLogColorSpaceW = tagLOGCOLORSPACEW;
  TLogColorSpace = TLogColorSpaceA;
  {$EXTERNALSYM LOGCOLORSPACEA}
  LOGCOLORSPACEA = tagLOGCOLORSPACEA;
  {$EXTERNALSYM LOGCOLORSPACEW}
  LOGCOLORSPACEW = tagLOGCOLORSPACEW;
  {$EXTERNALSYM LOGCOLORSPACE}
  LOGCOLORSPACE = LOGCOLORSPACEA;

  { structures for defining DIBs - used to get to color table }
  PBitmapCoreHeader = ^TBitmapCoreHeader;
  {$EXTERNALSYM tagBITMAPCOREHEADER}
  tagBITMAPCOREHEADER = packed record
    bcSize: DWORD;
    bcWidth: Word;
    bcHeight: Word;
    bcPlanes: Word;
    bcBitCount: Word;
  end;
  TBitmapCoreHeader = tagBITMAPCOREHEADER;
  {$EXTERNALSYM BITMAPCOREHEADER}
  BITMAPCOREHEADER = tagBITMAPCOREHEADER;

  PBitmapInfoHeader = ^TBitmapInfoHeader;
  {$EXTERNALSYM tagBITMAPINFOHEADER}
  tagBITMAPINFOHEADER = packed record
    biSize: DWORD;
    biWidth: Longint;
    biHeight: Longint;
    biPlanes: Word;
    biBitCount: Word;
    biCompression: DWORD;
    biSizeImage: DWORD;
    biXPelsPerMeter: Longint;
    biYPelsPerMeter: Longint;
    biClrUsed: DWORD;
    biClrImportant: DWORD;
  end;
  TBitmapInfoHeader = tagBITMAPINFOHEADER;
  {$EXTERNALSYM BITMAPINFOHEADER}
  BITMAPINFOHEADER = tagBITMAPINFOHEADER;

  PBitmapV4Header = ^TBitmapV4Header;
  {$EXTERNALSYM BITMAPV4HEADER}
  BITMAPV4HEADER = packed record
    bV4Size: DWORD;
    bV4Width: Longint;
    bV4Height: Longint;
    bV4Planes: Word;
    bV4BitCount: Word;
    bV4V4Compression: DWORD;
    bV4SizeImage: DWORD;
    bV4XPelsPerMeter: Longint;
    bV4YPelsPerMeter: Longint;
    bV4ClrUsed: DWORD;
    bV4ClrImportant: DWORD;
    bV4RedMask: DWORD;
    bV4GreenMask: DWORD;
    bV4BlueMask: DWORD;
    bV4AlphaMask: DWORD;
    bV4CSType: DWORD;
    bV4Endpoints: TCIEXYZTriple;
    bV4GammaRed: DWORD;
    bV4GammaGreen: DWORD;
    bV4GammaBlue: DWORD;
  end;
  TBitmapV4Header = BITMAPV4HEADER;

  {$EXTERNALSYM PBitmapV5Header}
  PBitmapV5Header = ^TBitmapV5Header;
  {$EXTERNALSYM BITMAPV5HEADER}
  BITMAPV5HEADER = packed record
    bV5Size: DWORD;
    bV5Width: Longint;
    bV5Height: Longint;
    bV5Planes: Word;
    bV5BitCount: Word;
    bV5Compression: DWORD;
    bV5SizeImage: DWORD;
    bV5XPelsPerMeter: Longint;
    bV5YPelsPerMeter: Longint;
    bV5ClrUsed: DWORD;
    bV5ClrImportant: DWORD;
    bV5RedMask: DWORD;
    bV5GreenMask: DWORD;
    bV5BlueMask: DWORD;
    bV5AlphaMask: DWORD;
    bV5CSType: DWORD;
    bV5Endpoints: TCIEXYZTriple;
    bV5GammaRed: DWORD;
    bV5GammaGreen: DWORD;
    bV5GammaBlue: DWORD;
    bV5Intent: DWORD;
    bV5ProfileData: DWORD;
    bV5ProfileSize: DWORD;
    bV5Reserved: DWORD;
  end;
  {$EXTERNALSYM TBitmapV5Header}
  TBitmapV5Header = BITMAPV5HEADER;

const
  { constants for the biCompression field }
  {$EXTERNALSYM BI_RGB}
  BI_RGB = 0;
  {$EXTERNALSYM BI_RLE8}
  BI_RLE8 = 1;
  {$EXTERNALSYM BI_RLE4}
  BI_RLE4 = 2;
  {$EXTERNALSYM BI_BITFIELDS}
  BI_BITFIELDS = 3;

type
  PBitmapInfo = ^TBitmapInfo;
  {$EXTERNALSYM tagBITMAPINFO}
  tagBITMAPINFO = packed record
    bmiHeader: TBitmapInfoHeader;
    bmiColors: array[0..0] of TRGBQuad;
  end;
  TBitmapInfo = tagBITMAPINFO;
  {$EXTERNALSYM BITMAPINFO}
  BITMAPINFO = tagBITMAPINFO;

  PBitmapCoreInfo = ^TBitmapCoreInfo;
  {$EXTERNALSYM tagBITMAPCOREINFO}
  tagBITMAPCOREINFO = record
    bmciHeader: TBitmapCoreHeader;
    bmciColors: array[0..0] of TRGBTriple;
    Reserved: array[0..0] of Char;
  end;
  TBitmapCoreInfo = tagBITMAPCOREINFO;
  {$EXTERNALSYM BITMAPCOREINFO}
  BITMAPCOREINFO = tagBITMAPCOREINFO;

  PBitmapFileHeader = ^TBitmapFileHeader;
  {$EXTERNALSYM tagBITMAPFILEHEADER}
  tagBITMAPFILEHEADER = packed record
    bfType: Word;
    bfSize: DWORD;
    bfReserved1: Word;
    bfReserved2: Word;
    bfOffBits: DWORD;
  end;
  TBitmapFileHeader = tagBITMAPFILEHEADER;
  {$EXTERNALSYM BITMAPFILEHEADER}
  BITMAPFILEHEADER = tagBITMAPFILEHEADER;

  PFontSignature = ^TFontSignature;
  {$EXTERNALSYM tagFONTSIGNATURE}
  tagFONTSIGNATURE = packed record
    fsUsb: array[0..3] of DWORD;
    fsCsb: array[0..1] of DWORD;
  end;
  TFontSignature = tagFONTSIGNATURE;
  {$EXTERNALSYM FONTSIGNATURE}
  FONTSIGNATURE = tagFONTSIGNATURE;

  PCharsetInfo = ^TCharsetInfo;
  {$EXTERNALSYM tagCHARSETINFO}
  tagCHARSETINFO = packed record
    ciCharset: UINT;
    ciACP: UINT;
    fs: TFontSignature;
  end;
  TCharsetInfo = tagCHARSETINFO;
  {$EXTERNALSYM CHARSETINFO}
  CHARSETINFO = tagCHARSETINFO;

const
  {$EXTERNALSYM TCI_SRCCHARSET}
  TCI_SRCCHARSET = 1;
  {$EXTERNALSYM TCI_SRCCODEPAGE}
  TCI_SRCCODEPAGE = 2;
  {$EXTERNALSYM TCI_SRCFONTSIG}
  TCI_SRCFONTSIG = 3;

type
  PLocaleSignature = ^TLocaleSignature;
  {$EXTERNALSYM tagLOCALESIGNATURE}
  tagLOCALESIGNATURE = packed record
    lsUsb: array[0..3] of DWORD;
    lsCsbDefault: array[0..1] of DWORD;
    lsCsbSupported: array[0..1] of DWORD;
  end;
  TLocaleSignature = tagLOCALESIGNATURE;
  {$EXTERNALSYM LOCALESIGNATURE}
  LOCALESIGNATURE = tagLOCALESIGNATURE;

  { Clipboard Metafile Picture Structure }
  PHandleTable = ^THandleTable;
  {$EXTERNALSYM tagHANDLETABLE}
  tagHANDLETABLE = packed record
    objectHandle: array[0..0] of HGDIOBJ;
  end;
  THandleTable = tagHANDLETABLE;
  {$EXTERNALSYM HANDLETABLE}
  HANDLETABLE = tagHANDLETABLE;

  PMetaRecord = ^TMetaRecord;
  {$EXTERNALSYM tagMETARECORD}
  tagMETARECORD = packed record
    rdSize: DWORD;
    rdFunction: Word;
    rdParm: array[0..0] of Word;
  end;
  TMetaRecord = tagMETARECORD;
  {$EXTERNALSYM METARECORD}
  METARECORD = tagMETARECORD;

  PMetafilePict = ^TMetafilePict;
  {$EXTERNALSYM tagMETAFILEPICT}
  tagMETAFILEPICT = packed record
    mm: Longint;
    xExt: Longint;
    yExt: Longint;
    hMF: HMETAFILE;
  end;
  TMetafilePict = tagMETAFILEPICT;
  {$EXTERNALSYM METAFILEPICT}
  METAFILEPICT = tagMETAFILEPICT;

  PMetaHeader = ^TMetaHeader;
  {$EXTERNALSYM tagMETAHEADER}
  tagMETAHEADER = packed record
    mtType: Word;
    mtHeaderSize: Word;
    mtVersion: Word;
    mtSize: DWORD;
    mtNoObjects: Word;
    mtMaxRecord: DWORD;
    mtNoParameters: Word;
  end;
  TMetaHeader = tagMETAHEADER;
  {$EXTERNALSYM METAHEADER}
  METAHEADER = tagMETAHEADER;

  { Enhanced Metafile structures }

  PEnhMetaRecord = ^TEnhMetaRecord;
  {$EXTERNALSYM tagENHMETARECORD}
  tagENHMETARECORD = packed record
    iType: DWORD; { Record type EMR_XXX}
    nSize: DWORD; { Record size in bytes}
    dParm: array[0..0] of DWORD; { Parameters}
  end;
  TEnhMetaRecord = tagENHMETARECORD;
  {$EXTERNALSYM ENHMETARECORD}
  ENHMETARECORD = tagENHMETARECORD;

  PEnhMetaHeader = ^TEnhMetaHeader;
  {$EXTERNALSYM tagENHMETAHEADER}
  tagENHMETAHEADER = packed record
    iType: DWORD;          { Record type EMR_HEADER}
    nSize: DWORD;          { Record size in bytes.  This may be greater
                             than the sizeof(TEnhMetaHeader). }
    rclBounds: TRect;     { Inclusive-inclusive bounds in device units}
    rclFrame: TRect;      { Inclusive-inclusive Picture Frame of metafile in .01 mm units}
    dSignature: DWORD;     { Signature.  Must be ENHMETA_SIGNATURE.}
    nVersion: DWORD;       { Version number}
    nBytes: DWORD;         { Size of the metafile in bytes}
    nRecords: DWORD;       { Number of records in the metafile}
    nHandles: Word;        { Number of handles in the handle table
                             Handle index zero is reserved. }
    sReserved: Word;       { Reserved.  Must be zero.}
    nDescription: DWORD;   { Number of chars in the unicode description string
                             This is 0 if there is no description string }
    offDescription: DWORD; { Offset to the metafile description record. }
                           { This is 0 if there is no description string }
    nPalEntries: DWORD;    { Number of entries in the metafile palette.}
    szlDevice: TSize;      { Size of the reference device in pels}
    szlMillimeters: TSize; { Size of the reference device in millimeters}
    cbPixelFormat: DWORD;  { Size of TPixelFormatDescriptor information }
                           { This is 0 if no pixel format is set }
    offPixelFormat: DWORD; { Offset to TPixelFormatDescriptor }
                           { This is 0 if no pixel format is set }
    bOpenGL: DWORD;        { True if OpenGL commands are present in }
                           { the metafile, otherwise FALSE }
  end;
  TEnhMetaHeader = tagENHMETAHEADER;
  {$EXTERNALSYM ENHMETAHEADER}
  ENHMETAHEADER = tagENHMETAHEADER;

const
  { tmPitchAndFamily flags }
  {$EXTERNALSYM TMPF_FIXED_PITCH}
  TMPF_FIXED_PITCH = 1;
  {$EXTERNALSYM TMPF_VECTOR}
  TMPF_VECTOR = 2;
  {$EXTERNALSYM TMPF_DEVICE}
  TMPF_DEVICE = 8;
  {$EXTERNALSYM TMPF_TRUETYPE}
  TMPF_TRUETYPE = 4;

type
  PTextMetricA = ^TTextMetricA;
  PTextMetricW = ^TTextMetricW;
  PTextMetric = PTextMetricA;
  {$EXTERNALSYM tagTEXTMETRICA}
  tagTEXTMETRICA = record
    tmHeight: Longint;
    tmAscent: Longint;
    tmDescent: Longint;
    tmInternalLeading: Longint;
    tmExternalLeading: Longint;
    tmAveCharWidth: Longint;
    tmMaxCharWidth: Longint;
    tmWeight: Longint;
    tmOverhang: Longint;
    tmDigitizedAspectX: Longint;
    tmDigitizedAspectY: Longint;
    tmFirstChar: AnsiChar;
    tmLastChar: AnsiChar;
    tmDefaultChar: AnsiChar;
    tmBreakChar: AnsiChar;
    tmItalic: Byte;
    tmUnderlined: Byte;
    tmStruckOut: Byte;
    tmPitchAndFamily: Byte;
    tmCharSet: Byte;
  end;
  {$EXTERNALSYM tagTEXTMETRICW}
  tagTEXTMETRICW = record
    tmHeight: Longint;
    tmAscent: Longint;
    tmDescent: Longint;
    tmInternalLeading: Longint;
    tmExternalLeading: Longint;
    tmAveCharWidth: Longint;
    tmMaxCharWidth: Longint;
    tmWeight: Longint;
    tmOverhang: Longint;
    tmDigitizedAspectX: Longint;
    tmDigitizedAspectY: Longint;
    tmFirstChar: WideChar;
    tmLastChar: WideChar;
    tmDefaultChar: WideChar;
    tmBreakChar: WideChar;
    tmItalic: Byte;
    tmUnderlined: Byte;
    tmStruckOut: Byte;
    tmPitchAndFamily: Byte;
    tmCharSet: Byte;
  end;
  {$EXTERNALSYM tagTEXTMETRIC}
  tagTEXTMETRIC = tagTEXTMETRICA;
  TTextMetricA = tagTEXTMETRICA;
  TTextMetricW = tagTEXTMETRICW;
  TTextMetric = TTextMetricA;
  {$EXTERNALSYM TEXTMETRICA}
  TEXTMETRICA = tagTEXTMETRICA;
  {$EXTERNALSYM TEXTMETRICW}
  TEXTMETRICW = tagTEXTMETRICW;
  {$EXTERNALSYM TEXTMETRIC}
  TEXTMETRIC = TEXTMETRICA;

const
  { ntmFlags field flags }
  {$EXTERNALSYM NTM_REGULAR}
  NTM_REGULAR = $40;
  {$EXTERNALSYM NTM_BOLD}
  NTM_BOLD = $20;
  {$EXTERNALSYM NTM_ITALIC}
  NTM_ITALIC = 1;

type
  PNewTextMetricA = ^TNewTextMetricA;
  PNewTextMetricW = ^TNewTextMetricW;
  PNewTextMetric = PNewTextMetricA;
  {$EXTERNALSYM tagNEWTEXTMETRICA}
  tagNEWTEXTMETRICA = record
    tmHeight: Longint;
    tmAscent: Longint;
    tmDescent: Longint;
    tmInternalLeading: Longint;
    tmExternalLeading: Longint;
    tmAveCharWidth: Longint;
    tmMaxCharWidth: Longint;
    tmWeight: Longint;
    tmOverhang: Longint;
    tmDigitizedAspectX: Longint;
    tmDigitizedAspectY: Longint;
    tmFirstChar: AnsiChar;
    tmLastChar: AnsiChar;
    tmDefaultChar: AnsiChar;
    tmBreakChar: AnsiChar;
    tmItalic: Byte;
    tmUnderlined: Byte;
    tmStruckOut: Byte;
    tmPitchAndFamily: Byte;
    tmCharSet: Byte;
    ntmFlags: DWORD;
    ntmSizeEM: UINT;
    ntmCellHeight: UINT;
    ntmAvgWidth: UINT;
  end;
  {$EXTERNALSYM tagNEWTEXTMETRICW}
  tagNEWTEXTMETRICW = record
    tmHeight: Longint;
    tmAscent: Longint;
    tmDescent: Longint;
    tmInternalLeading: Longint;
    tmExternalLeading: Longint;
    tmAveCharWidth: Longint;
    tmMaxCharWidth: Longint;
    tmWeight: Longint;
    tmOverhang: Longint;
    tmDigitizedAspectX: Longint;
    tmDigitizedAspectY: Longint;
    tmFirstChar: WideChar;
    tmLastChar: WideChar;
    tmDefaultChar: WideChar;
    tmBreakChar: WideChar;
    tmItalic: Byte;
    tmUnderlined: Byte;
    tmStruckOut: Byte;
    tmPitchAndFamily: Byte;
    tmCharSet: Byte;
    ntmFlags: DWORD;
    ntmSizeEM: UINT;
    ntmCellHeight: UINT;
    ntmAvgWidth: UINT;
  end;
  {$EXTERNALSYM tagNEWTEXTMETRIC}
  tagNEWTEXTMETRIC = tagNEWTEXTMETRICA;
  TNewTextMetricA = tagNEWTEXTMETRICA;
  TNewTextMetricW = tagNEWTEXTMETRICW;
  TNewTextMetric = TNewTextMetricA;
  {$EXTERNALSYM NEWTEXTMETRICA}
  NEWTEXTMETRICA = tagNEWTEXTMETRICA;
  {$EXTERNALSYM NEWTEXTMETRICW}
  NEWTEXTMETRICW = tagNEWTEXTMETRICW;
  {$EXTERNALSYM NEWTEXTMETRIC}
  NEWTEXTMETRIC = NEWTEXTMETRICA;

  PNewTextMetricExA = ^TNewTextMetricExA;
  {$EXTERNALSYM tagNEWTEXTMETRICEXA}
  tagNEWTEXTMETRICEXA = packed record
    ntmTm: TNewTextMetricA;
    ntmFontSig: TFontSignature;
  end;
  TNewTextMetricExA = tagNEWTEXTMETRICEXA;
  {$EXTERNALSYM NEWTEXTMETRICEXA}
  NEWTEXTMETRICEXA = tagNEWTEXTMETRICEXA;
  PNewTextMetricExW = ^TNewTextMetricExW;
  {$EXTERNALSYM tagNEWTEXTMETRICEXW}
  tagNEWTEXTMETRICEXW = packed record
    ntmTm: TNewTextMetricW;
    ntmFontSig: TFontSignature;
  end;
  TNewTextMetricExW = tagNEWTEXTMETRICEXW;
  {$EXTERNALSYM NEWTEXTMETRICEXW}
  NEWTEXTMETRICEXW = tagNEWTEXTMETRICEXW;
  PNewTextMetricEx = PNewTextMetricExA;

{ GDI Logical Objects: }

  { Pel Array }
  PPelArray = ^TPelArray;
  {$EXTERNALSYM tagPELARRAY}
  tagPELARRAY = record
    paXCount: Longint;
    paYCount: Longint;
    paXExt: Longint;
    paYExt: Longint;
    paRGBs: Byte;
  end;
  TPelArray = tagPELARRAY;
  {$EXTERNALSYM PELARRAY}
  PELARRAY = tagPELARRAY;

  { Logical Brush (or Pattern) }
  PLogBrush = ^TLogBrush;
  {$EXTERNALSYM tagLOGBRUSH}
  tagLOGBRUSH = packed record
    lbStyle: UINT;
    lbColor: COLORREF;
    lbHatch: Longint;
  end;
  TLogBrush = tagLOGBRUSH;
  {$EXTERNALSYM LOGBRUSH}
  LOGBRUSH = tagLOGBRUSH;

  PPattern = ^TPattern;
  TPattern = TLogBrush;

  { Logical Pen }
  PLogPen = ^TLogPen;
  {$EXTERNALSYM tagLOGPEN}
  tagLOGPEN = packed record
    lopnStyle: UINT;
    lopnWidth: TPoint;
    lopnColor: COLORREF;
  end;
  TLogPen = tagLOGPEN;
  {$EXTERNALSYM LOGPEN}
  LOGPEN = tagLOGPEN;

  PExtLogPen = ^TLogPen;
  {$EXTERNALSYM tagEXTLOGPEN}
  tagEXTLOGPEN = packed record
    elpPenStyle: DWORD;
    elpWidth: DWORD;
    elpBrushStyle: UINT;
    elpColor: COLORREF;
    elpHatch: Longint;
    elpNumEntries: DWORD;
    elpStyleEntry: array[0..0] of DWORD;
  end;
  TExtLogPen = tagEXTLOGPEN;
  {$EXTERNALSYM EXTLOGPEN}
  EXTLOGPEN = tagEXTLOGPEN;

  PPaletteEntry = ^TPaletteEntry;
  {$EXTERNALSYM tagPALETTEENTRY}
  tagPALETTEENTRY = packed record
    peRed: Byte;
    peGreen: Byte;
    peBlue: Byte;
    peFlags: Byte;
  end;
  TPaletteEntry = tagPALETTEENTRY;
  {$EXTERNALSYM PALETTEENTRY}
  PALETTEENTRY = tagPALETTEENTRY;


  { Logical Palette }
  PLogPalette = ^TLogPalette;
  {$EXTERNALSYM tagLOGPALETTE}
  tagLOGPALETTE = packed record
    palVersion: Word;
    palNumEntries: Word;
    palPalEntry: array[0..0] of TPaletteEntry;
  end;
  TLogPalette = tagLOGPALETTE;
  {$EXTERNALSYM LOGPALETTE}
  LOGPALETTE = tagLOGPALETTE;

  PMaxLogPalette = ^TMaxLogPalette; // not in Windows Headers
  TMaxLogPalette = packed record
    palVersion: Word;
    palNumEntries: Word;
    palPalEntry: array [Byte] of TPaletteEntry;
  end;

const
  { Logical Font }
  {$EXTERNALSYM LF_FACESIZE}
  LF_FACESIZE = 32;

type
  PLogFontA = ^TLogFontA;
  PLogFontW = ^TLogFontW;
  PLogFont = PLogFontA;
  {$EXTERNALSYM tagLOGFONTA}
  tagLOGFONTA = packed record
    lfHeight: Longint;
    lfWidth: Longint;
    lfEscapement: Longint;
    lfOrientation: Longint;
    lfWeight: Longint;
    lfItalic: Byte;
    lfUnderline: Byte;
    lfStrikeOut: Byte;
    lfCharSet: Byte;
    lfOutPrecision: Byte;
    lfClipPrecision: Byte;
    lfQuality: Byte;
    lfPitchAndFamily: Byte;
    lfFaceName: array[0..LF_FACESIZE - 1] of AnsiChar;
  end;
  {$EXTERNALSYM tagLOGFONTW}
  tagLOGFONTW = packed record
    lfHeight: Longint;
    lfWidth: Longint;
    lfEscapement: Longint;
    lfOrientation: Longint;
    lfWeight: Longint;
    lfItalic: Byte;
    lfUnderline: Byte;
    lfStrikeOut: Byte;
    lfCharSet: Byte;
    lfOutPrecision: Byte;
    lfClipPrecision: Byte;
    lfQuality: Byte;
    lfPitchAndFamily: Byte;
    lfFaceName: array[0..LF_FACESIZE - 1] of WideChar;
  end;
  {$EXTERNALSYM tagLOGFONT}
  tagLOGFONT = tagLOGFONTA;
  TLogFontA = tagLOGFONTA;
  TLogFontW = tagLOGFONTW;
  TLogFont = TLogFontA;
  {$EXTERNALSYM LOGFONTA}
  LOGFONTA = tagLOGFONTA;
  {$EXTERNALSYM LOGFONTW}
  LOGFONTW = tagLOGFONTW;
  {$EXTERNALSYM LOGFONT}
  LOGFONT = LOGFONTA;

const
  {$EXTERNALSYM LF_FULLFACESIZE}
  LF_FULLFACESIZE = 64;

type
  { Structure passed to FONTENUMPROC }
  PEnumLogFontA = ^TEnumLogFontA;
  PEnumLogFontW = ^TEnumLogFontW;
  PEnumLogFont = PEnumLogFontA;
  {$EXTERNALSYM tagENUMLOGFONTA}
  tagENUMLOGFONTA = packed record
    elfLogFont: TLogFontA;
    elfFullName: array[0..LF_FULLFACESIZE - 1] of AnsiChar;
    elfStyle: array[0..LF_FACESIZE - 1] of AnsiChar;
  end;
  {$EXTERNALSYM tagENUMLOGFONTW}
  tagENUMLOGFONTW = packed record
    elfLogFont: TLogFontW;
    elfFullName: array[0..LF_FULLFACESIZE - 1] of WideChar;
    elfStyle: array[0..LF_FACESIZE - 1] of WideChar;
  end;
  {$EXTERNALSYM tagENUMLOGFONT}
  tagENUMLOGFONT = tagENUMLOGFONTA;
  TEnumLogFontA = tagENUMLOGFONTA;
  TEnumLogFontW = tagENUMLOGFONTW;
  TEnumLogFont = TEnumLogFontA;
  {$EXTERNALSYM ENUMLOGFONTA}
  ENUMLOGFONTA = tagENUMLOGFONTA;
  {$EXTERNALSYM ENUMLOGFONTW}
  ENUMLOGFONTW = tagENUMLOGFONTW;
  {$EXTERNALSYM ENUMLOGFONT}
  ENUMLOGFONT = ENUMLOGFONTA;

  PEnumLogFontExA = ^TEnumLogFontExA;
  PEnumLogFontExW = ^TEnumLogFontExW;
  PEnumLogFontEx = PEnumLogFontExA;
  {$EXTERNALSYM tagENUMLOGFONTEXA}
  tagENUMLOGFONTEXA = packed record
    elfLogFont: TLogFontA;
    elfFullName: array[0..LF_FULLFACESIZE - 1] of AnsiChar;
    elfStyle: array[0..LF_FACESIZE - 1] of AnsiChar;
    elfScript: array[0..LF_FACESIZE - 1] of AnsiChar;
  end;
  {$EXTERNALSYM tagENUMLOGFONTEXW}
  tagENUMLOGFONTEXW = packed record
    elfLogFont: TLogFontW;
    elfFullName: array[0..LF_FULLFACESIZE - 1] of WideChar;
    elfStyle: array[0..LF_FACESIZE - 1] of WideChar;
    elfScript: array[0..LF_FACESIZE - 1] of WideChar;
  end;
  {$EXTERNALSYM tagENUMLOGFONTEX}
  tagENUMLOGFONTEX = tagENUMLOGFONTEXA;
  TEnumLogFontExA = tagENUMLOGFONTEXA;
  TEnumLogFontExW = tagENUMLOGFONTEXW;
  TEnumLogFontEx = TEnumLogFontExA;
  {$EXTERNALSYM ENUMLOGFONTEXA}
  ENUMLOGFONTEXA = tagENUMLOGFONTEXA;
  {$EXTERNALSYM ENUMLOGFONTEXW}
  ENUMLOGFONTEXW = tagENUMLOGFONTEXW;
  {$EXTERNALSYM ENUMLOGFONTEX}
  ENUMLOGFONTEX = ENUMLOGFONTEXA;

const
  {$EXTERNALSYM OUT_DEFAULT_PRECIS}
  OUT_DEFAULT_PRECIS = 0;
  {$EXTERNALSYM OUT_STRING_PRECIS}
  OUT_STRING_PRECIS = 1;
  {$EXTERNALSYM OUT_CHARACTER_PRECIS}
  OUT_CHARACTER_PRECIS = 2;
  {$EXTERNALSYM OUT_STROKE_PRECIS}
  OUT_STROKE_PRECIS = 3;
  {$EXTERNALSYM OUT_TT_PRECIS}
  OUT_TT_PRECIS = 4;
  {$EXTERNALSYM OUT_DEVICE_PRECIS}
  OUT_DEVICE_PRECIS = 5;
  {$EXTERNALSYM OUT_RASTER_PRECIS}
  OUT_RASTER_PRECIS = 6;
  {$EXTERNALSYM OUT_TT_ONLY_PRECIS}
  OUT_TT_ONLY_PRECIS = 7;
  {$EXTERNALSYM OUT_OUTLINE_PRECIS}
  OUT_OUTLINE_PRECIS = 8;
  {$EXTERNALSYM OUT_SCREEN_OUTLINE_PRECIS}
  OUT_SCREEN_OUTLINE_PRECIS = 9;

  {$EXTERNALSYM CLIP_DEFAULT_PRECIS}
  CLIP_DEFAULT_PRECIS = 0;
  {$EXTERNALSYM CLIP_CHARACTER_PRECIS}
  CLIP_CHARACTER_PRECIS = 1;
  {$EXTERNALSYM CLIP_STROKE_PRECIS}
  CLIP_STROKE_PRECIS = 2;
  {$EXTERNALSYM CLIP_MASK}
  CLIP_MASK = 15;
  {$EXTERNALSYM CLIP_LH_ANGLES}
  CLIP_LH_ANGLES = (1 shl 4);
  {$EXTERNALSYM CLIP_TT_ALWAYS}
  CLIP_TT_ALWAYS = (2 shl 4);
  {$EXTERNALSYM CLIP_EMBEDDED}
  CLIP_EMBEDDED  = (8 shl 4);

  {$EXTERNALSYM DEFAULT_QUALITY}
  DEFAULT_QUALITY = 0;
  {$EXTERNALSYM DRAFT_QUALITY}
  DRAFT_QUALITY = 1;
  {$EXTERNALSYM PROOF_QUALITY}
  PROOF_QUALITY = 2;
  {$EXTERNALSYM NONANTIALIASED_QUALITY}
  NONANTIALIASED_QUALITY = 3;
  {$EXTERNALSYM ANTIALIASED_QUALITY}
  ANTIALIASED_QUALITY = 4;

  {$EXTERNALSYM DEFAULT_PITCH}
  DEFAULT_PITCH = 0;
  {$EXTERNALSYM FIXED_PITCH}
  FIXED_PITCH = 1;
  {$EXTERNALSYM VARIABLE_PITCH}
  VARIABLE_PITCH = 2;
  {$EXTERNALSYM MONO_FONT}
  MONO_FONT = 8;

  {$EXTERNALSYM ANSI_CHARSET}
  ANSI_CHARSET = 0;
  {$EXTERNALSYM DEFAULT_CHARSET}
  DEFAULT_CHARSET = 1;
  {$EXTERNALSYM SYMBOL_CHARSET}
  SYMBOL_CHARSET = 2;
  {$EXTERNALSYM SHIFTJIS_CHARSET}
  SHIFTJIS_CHARSET = $80;
  {$EXTERNALSYM HANGEUL_CHARSET}
  HANGEUL_CHARSET = 129;
  {$EXTERNALSYM GB2312_CHARSET}
  GB2312_CHARSET = 134;
  {$EXTERNALSYM CHINESEBIG5_CHARSET}
  CHINESEBIG5_CHARSET = 136;
  {$EXTERNALSYM OEM_CHARSET}
  OEM_CHARSET = 255;
  {$EXTERNALSYM JOHAB_CHARSET}
  JOHAB_CHARSET = 130;
  {$EXTERNALSYM HEBREW_CHARSET}
  HEBREW_CHARSET = 177;
  {$EXTERNALSYM ARABIC_CHARSET}
  ARABIC_CHARSET = 178;
  {$EXTERNALSYM GREEK_CHARSET}
  GREEK_CHARSET = 161;
  {$EXTERNALSYM TURKISH_CHARSET}
  TURKISH_CHARSET = 162;
  {$EXTERNALSYM VIETNAMESE_CHARSET}
  VIETNAMESE_CHARSET = 163;
  {$EXTERNALSYM THAI_CHARSET}
  THAI_CHARSET = 222;
  {$EXTERNALSYM EASTEUROPE_CHARSET}
  EASTEUROPE_CHARSET = 238;
  {$EXTERNALSYM RUSSIAN_CHARSET}
  RUSSIAN_CHARSET = 204;

  {$EXTERNALSYM MAC_CHARSET}
  MAC_CHARSET = 77;
  {$EXTERNALSYM BALTIC_CHARSET}
  BALTIC_CHARSET = 186;

  {$EXTERNALSYM FS_LATIN1}
  FS_LATIN1 = 1;
  {$EXTERNALSYM FS_LATIN2}
  FS_LATIN2 = 2;
  {$EXTERNALSYM FS_CYRILLIC}
  FS_CYRILLIC = 4;
  {$EXTERNALSYM FS_GREEK}
  FS_GREEK = 8;
  {$EXTERNALSYM FS_TURKISH}
  FS_TURKISH = $10;
  {$EXTERNALSYM FS_HEBREW}
  FS_HEBREW = $20;
  {$EXTERNALSYM FS_ARABIC}
  FS_ARABIC = $40;
  {$EXTERNALSYM FS_BALTIC}
  FS_BALTIC = $80;
  {$EXTERNALSYM FS_VIETNAMESE}
  FS_VIETNAMESE = $00000100;
  {$EXTERNALSYM FS_THAI}
  FS_THAI = $10000;
  {$EXTERNALSYM FS_JISJAPAN}
  FS_JISJAPAN = $20000;
  {$EXTERNALSYM FS_CHINESESIMP}
  FS_CHINESESIMP = $40000;
  {$EXTERNALSYM FS_WANSUNG}
  FS_WANSUNG = $80000;
  {$EXTERNALSYM FS_CHINESETRAD}
  FS_CHINESETRAD = $100000;
  {$EXTERNALSYM FS_JOHAB}
  FS_JOHAB = $200000;
  {$EXTERNALSYM FS_SYMBOL}
  FS_SYMBOL = DWORD($80000000);

  { Font Families }
  {$EXTERNALSYM FF_DONTCARE}
  FF_DONTCARE   = (0 shl 4);     { Don't care or don't know. }
  {$EXTERNALSYM FF_ROMAN}
  FF_ROMAN      = (1 shl 4);     { Variable stroke width, serifed. }
                                 { Times Roman, Century Schoolbook, etc. }
  {$EXTERNALSYM FF_SWISS}
  FF_SWISS      = (2 shl 4);     { Variable stroke width, sans-serifed. }
                                 { Helvetica, Swiss, etc. }
  {$EXTERNALSYM FF_MODERN}
  FF_MODERN     = (3 shl 4);     { Constant stroke width, serifed or sans-serifed. }
                                 { Pica, Elite, Courier, etc. }
  {$EXTERNALSYM FF_SCRIPT}
  FF_SCRIPT     = (4 shl 4);     { Cursive, etc. }
  {$EXTERNALSYM FF_DECORATIVE}
  FF_DECORATIVE = (5 shl 4);     { Old English, etc. }

  { Font Weights }
  {$EXTERNALSYM FW_DONTCARE}
  FW_DONTCARE = 0;
  {$EXTERNALSYM FW_THIN}
  FW_THIN = 100;
  {$EXTERNALSYM FW_EXTRALIGHT}
  FW_EXTRALIGHT = 200;
  {$EXTERNALSYM FW_LIGHT}
  FW_LIGHT = 300;
  {$EXTERNALSYM FW_NORMAL}
  FW_NORMAL = 400;
  {$EXTERNALSYM FW_MEDIUM}
  FW_MEDIUM = 500;
  {$EXTERNALSYM FW_SEMIBOLD}
  FW_SEMIBOLD = 600;
  {$EXTERNALSYM FW_BOLD}
  FW_BOLD = 700;
  {$EXTERNALSYM FW_EXTRABOLD}
  FW_EXTRABOLD = 800;
  {$EXTERNALSYM FW_HEAVY}
  FW_HEAVY = 900;
  {$EXTERNALSYM FW_ULTRALIGHT}
  FW_ULTRALIGHT = FW_EXTRALIGHT;
  {$EXTERNALSYM FW_REGULAR}
  FW_REGULAR = FW_NORMAL;
  {$EXTERNALSYM FW_DEMIBOLD}
  FW_DEMIBOLD = FW_SEMIBOLD;
  {$EXTERNALSYM FW_ULTRABOLD}
  FW_ULTRABOLD = FW_EXTRABOLD;
  {$EXTERNALSYM FW_BLACK}
  FW_BLACK = FW_HEAVY;

  {$EXTERNALSYM PANOSE_COUNT}
  PANOSE_COUNT = 10;
  {$EXTERNALSYM PAN_FAMILYTYPE_INDEX}
  PAN_FAMILYTYPE_INDEX = 0;
  {$EXTERNALSYM PAN_SERIFSTYLE_INDEX}
  PAN_SERIFSTYLE_INDEX = 1;
  {$EXTERNALSYM PAN_WEIGHT_INDEX}
  PAN_WEIGHT_INDEX = 2;
  {$EXTERNALSYM PAN_PROPORTION_INDEX}
  PAN_PROPORTION_INDEX = 3;
  {$EXTERNALSYM PAN_CONTRAST_INDEX}
  PAN_CONTRAST_INDEX = 4;
  {$EXTERNALSYM PAN_STROKEVARIATION_INDEX}
  PAN_STROKEVARIATION_INDEX = 5;
  {$EXTERNALSYM PAN_ARMSTYLE_INDEX}
  PAN_ARMSTYLE_INDEX = 6;
  {$EXTERNALSYM PAN_LETTERFORM_INDEX}
  PAN_LETTERFORM_INDEX = 7;
  {$EXTERNALSYM PAN_MIDLINE_INDEX}
  PAN_MIDLINE_INDEX = 8;
  {$EXTERNALSYM PAN_XHEIGHT_INDEX}
  PAN_XHEIGHT_INDEX = 9;

  {$EXTERNALSYM PAN_CULTURE_LATIN}
  PAN_CULTURE_LATIN = 0;

type
  PPanose = ^TPanose;
  {$EXTERNALSYM tagPANOSE}
  tagPANOSE = packed record
    bFamilyType: Byte;
    bSerifStyle: Byte;
    bWeight: Byte;
    bProportion: Byte;
    bContrast: Byte;
    bStrokeVariation: Byte;
    bArmStyle: Byte;
    bLetterform: Byte;
    bMidline: Byte;
    bXHeight: Byte;
  end;
  TPanose = tagPANOSE;
  {$EXTERNALSYM PANOSE}
  PANOSE = tagPANOSE;

const
  {$EXTERNALSYM PAN_ANY}
  PAN_ANY = 0;
  {$EXTERNALSYM PAN_NO_FIT}
  PAN_NO_FIT = 1;

  {$EXTERNALSYM PAN_FAMILY_TEXT_DISPLAY}
  PAN_FAMILY_TEXT_DISPLAY = 2;
  {$EXTERNALSYM PAN_FAMILY_SCRIPT}
  PAN_FAMILY_SCRIPT = 3;
  {$EXTERNALSYM PAN_FAMILY_DECORATIVE}
  PAN_FAMILY_DECORATIVE = 4;
  {$EXTERNALSYM PAN_FAMILY_PICTORIAL}
  PAN_FAMILY_PICTORIAL = 5;

  {$EXTERNALSYM PAN_SERIF_COVE}
  PAN_SERIF_COVE = 2;
  {$EXTERNALSYM PAN_SERIF_OBTUSE_COVE}
  PAN_SERIF_OBTUSE_COVE = 3;
  {$EXTERNALSYM PAN_SERIF_SQUARE_COVE}
  PAN_SERIF_SQUARE_COVE = 4;
  {$EXTERNALSYM PAN_SERIF_OBTUSE_SQUARE_COVE}
  PAN_SERIF_OBTUSE_SQUARE_COVE = 5;
  {$EXTERNALSYM PAN_SERIF_SQUARE}
  PAN_SERIF_SQUARE = 6;
  {$EXTERNALSYM PAN_SERIF_THIN}
  PAN_SERIF_THIN = 7;
  {$EXTERNALSYM PAN_SERIF_BONE}
  PAN_SERIF_BONE = 8;
  {$EXTERNALSYM PAN_SERIF_EXAGGERATED}
  PAN_SERIF_EXAGGERATED = 9;
  {$EXTERNALSYM PAN_SERIF_TRIANGLE}
  PAN_SERIF_TRIANGLE = 10;
  {$EXTERNALSYM PAN_SERIF_NORMAL_SANS}
  PAN_SERIF_NORMAL_SANS = 11;
  {$EXTERNALSYM PAN_SERIF_OBTUSE_SANS}
  PAN_SERIF_OBTUSE_SANS = 12;
  {$EXTERNALSYM PAN_SERIF_PERP_SANS}
  PAN_SERIF_PERP_SANS = 13;
  {$EXTERNALSYM PAN_SERIF_FLARED}
  PAN_SERIF_FLARED = 14;
  {$EXTERNALSYM PAN_SERIF_ROUNDED}
  PAN_SERIF_ROUNDED = 15;

  {$EXTERNALSYM PAN_WEIGHT_VERY_LIGHT}
  PAN_WEIGHT_VERY_LIGHT = 2;
  {$EXTERNALSYM PAN_WEIGHT_LIGHT}
  PAN_WEIGHT_LIGHT = 3;
  {$EXTERNALSYM PAN_WEIGHT_THIN}
  PAN_WEIGHT_THIN = 4;
  {$EXTERNALSYM PAN_WEIGHT_BOOK}
  PAN_WEIGHT_BOOK = 5;
  {$EXTERNALSYM PAN_WEIGHT_MEDIUM}
  PAN_WEIGHT_MEDIUM = 6;
  {$EXTERNALSYM PAN_WEIGHT_DEMI}
  PAN_WEIGHT_DEMI = 7;
  {$EXTERNALSYM PAN_WEIGHT_BOLD}
  PAN_WEIGHT_BOLD = 8;
  {$EXTERNALSYM PAN_WEIGHT_HEAVY}
  PAN_WEIGHT_HEAVY = 9;
  {$EXTERNALSYM PAN_WEIGHT_BLACK}
  PAN_WEIGHT_BLACK = 10;
  {$EXTERNALSYM PAN_WEIGHT_NORD}
  PAN_WEIGHT_NORD = 11;

  {$EXTERNALSYM PAN_PROP_OLD_STYLE}
  PAN_PROP_OLD_STYLE = 2;
  {$EXTERNALSYM PAN_PROP_MODERN}
  PAN_PROP_MODERN = 3;
  {$EXTERNALSYM PAN_PROP_EVEN_WIDTH}
  PAN_PROP_EVEN_WIDTH = 4;
  {$EXTERNALSYM PAN_PROP_EXPANDED}
  PAN_PROP_EXPANDED = 5;
  {$EXTERNALSYM PAN_PROP_CONDENSED}
  PAN_PROP_CONDENSED = 6;
  {$EXTERNALSYM PAN_PROP_VERY_EXPANDED}
  PAN_PROP_VERY_EXPANDED = 7;
  {$EXTERNALSYM PAN_PROP_VERY_CONDENSED}
  PAN_PROP_VERY_CONDENSED = 8;
  {$EXTERNALSYM PAN_PROP_MONOSPACED}
  PAN_PROP_MONOSPACED = 9;

  {$EXTERNALSYM PAN_CONTRAST_NONE}
  PAN_CONTRAST_NONE = 2;
  {$EXTERNALSYM PAN_CONTRAST_VERY_LOW}
  PAN_CONTRAST_VERY_LOW = 3;
  {$EXTERNALSYM PAN_CONTRAST_LOW}
  PAN_CONTRAST_LOW = 4;
  {$EXTERNALSYM PAN_CONTRAST_MEDIUM_LOW}
  PAN_CONTRAST_MEDIUM_LOW = 5;
  {$EXTERNALSYM PAN_CONTRAST_MEDIUM}
  PAN_CONTRAST_MEDIUM = 6;
  {$EXTERNALSYM PAN_CONTRAST_MEDIUM_HIGH}
  PAN_CONTRAST_MEDIUM_HIGH = 7;
  {$EXTERNALSYM PAN_CONTRAST_HIGH}
  PAN_CONTRAST_HIGH = 8;
  {$EXTERNALSYM PAN_CONTRAST_VERY_HIGH}
  PAN_CONTRAST_VERY_HIGH = 9;

  {$EXTERNALSYM PAN_STROKE_GRADUAL_DIAG}
  PAN_STROKE_GRADUAL_DIAG = 2;
  {$EXTERNALSYM PAN_STROKE_GRADUAL_TRAN}
  PAN_STROKE_GRADUAL_TRAN = 3;
  {$EXTERNALSYM PAN_STROKE_GRADUAL_VERT}
  PAN_STROKE_GRADUAL_VERT = 4;
  {$EXTERNALSYM PAN_STROKE_GRADUAL_HORZ}
  PAN_STROKE_GRADUAL_HORZ = 5;
  {$EXTERNALSYM PAN_STROKE_RAPID_VERT}
  PAN_STROKE_RAPID_VERT = 6;
  {$EXTERNALSYM PAN_STROKE_RAPID_HORZ}
  PAN_STROKE_RAPID_HORZ = 7;
  {$EXTERNALSYM PAN_STROKE_INSTANT_VERT}
  PAN_STROKE_INSTANT_VERT = 8;

  {$EXTERNALSYM PAN_STRAIGHT_ARMS_HORZ}
  PAN_STRAIGHT_ARMS_HORZ = 2;
  {$EXTERNALSYM PAN_STRAIGHT_ARMS_WEDGE}
  PAN_STRAIGHT_ARMS_WEDGE = 3;
  {$EXTERNALSYM PAN_STRAIGHT_ARMS_VERT}
  PAN_STRAIGHT_ARMS_VERT = 4;
  {$EXTERNALSYM PAN_STRAIGHT_ARMS_SINGLE_SERIF}
  PAN_STRAIGHT_ARMS_SINGLE_SERIF = 5;
  {$EXTERNALSYM PAN_STRAIGHT_ARMS_DOUBLE_SERIF}
  PAN_STRAIGHT_ARMS_DOUBLE_SERIF = 6;
  {$EXTERNALSYM PAN_BENT_ARMS_HORZ}
  PAN_BENT_ARMS_HORZ = 7;
  {$EXTERNALSYM PAN_BENT_ARMS_WEDGE}
  PAN_BENT_ARMS_WEDGE = 8;
  {$EXTERNALSYM PAN_BENT_ARMS_VERT}
  PAN_BENT_ARMS_VERT = 9;
  {$EXTERNALSYM PAN_BENT_ARMS_SINGLE_SERIF}
  PAN_BENT_ARMS_SINGLE_SERIF = 10;
  {$EXTERNALSYM PAN_BENT_ARMS_DOUBLE_SERIF}
  PAN_BENT_ARMS_DOUBLE_SERIF = 11;

  {$EXTERNALSYM PAN_LETT_NORMAL_CONTACT}
  PAN_LETT_NORMAL_CONTACT = 2;
  {$EXTERNALSYM PAN_LETT_NORMAL_WEIGHTED}
  PAN_LETT_NORMAL_WEIGHTED = 3;
  {$EXTERNALSYM PAN_LETT_NORMAL_BOXED}
  PAN_LETT_NORMAL_BOXED = 4;
  {$EXTERNALSYM PAN_LETT_NORMAL_FLATTENED}
  PAN_LETT_NORMAL_FLATTENED = 5;
  {$EXTERNALSYM PAN_LETT_NORMAL_ROUNDED}
  PAN_LETT_NORMAL_ROUNDED = 6;
  {$EXTERNALSYM PAN_LETT_NORMAL_OFF_CENTER}
  PAN_LETT_NORMAL_OFF_CENTER = 7;
  {$EXTERNALSYM PAN_LETT_NORMAL_SQUARE}
  PAN_LETT_NORMAL_SQUARE = 8;
  {$EXTERNALSYM PAN_LETT_OBLIQUE_CONTACT}
  PAN_LETT_OBLIQUE_CONTACT = 9;
  {$EXTERNALSYM PAN_LETT_OBLIQUE_WEIGHTED}
  PAN_LETT_OBLIQUE_WEIGHTED = 10;
  {$EXTERNALSYM PAN_LETT_OBLIQUE_BOXED}
  PAN_LETT_OBLIQUE_BOXED = 11;
  {$EXTERNALSYM PAN_LETT_OBLIQUE_FLATTENED}
  PAN_LETT_OBLIQUE_FLATTENED = 12;
  {$EXTERNALSYM PAN_LETT_OBLIQUE_ROUNDED}
  PAN_LETT_OBLIQUE_ROUNDED = 13;
  {$EXTERNALSYM PAN_LETT_OBLIQUE_OFF_CENTER}
  PAN_LETT_OBLIQUE_OFF_CENTER = 14;
  {$EXTERNALSYM PAN_LETT_OBLIQUE_SQUARE}
  PAN_LETT_OBLIQUE_SQUARE = 15;

  {$EXTERNALSYM PAN_MIDLINE_STANDARD_TRIMMED}
  PAN_MIDLINE_STANDARD_TRIMMED = 2;
  {$EXTERNALSYM PAN_MIDLINE_STANDARD_POINTED}
  PAN_MIDLINE_STANDARD_POINTED = 3;
  {$EXTERNALSYM PAN_MIDLINE_STANDARD_SERIFED}
  PAN_MIDLINE_STANDARD_SERIFED = 4;
  {$EXTERNALSYM PAN_MIDLINE_HIGH_TRIMMED}
  PAN_MIDLINE_HIGH_TRIMMED = 5;
  {$EXTERNALSYM PAN_MIDLINE_HIGH_POINTED}
  PAN_MIDLINE_HIGH_POINTED = 6;
  {$EXTERNALSYM PAN_MIDLINE_HIGH_SERIFED}
  PAN_MIDLINE_HIGH_SERIFED = 7;
  {$EXTERNALSYM PAN_MIDLINE_CONSTANT_TRIMMED}
  PAN_MIDLINE_CONSTANT_TRIMMED = 8;
  {$EXTERNALSYM PAN_MIDLINE_CONSTANT_POINTED}
  PAN_MIDLINE_CONSTANT_POINTED = 9;
  {$EXTERNALSYM PAN_MIDLINE_CONSTANT_SERIFED}
  PAN_MIDLINE_CONSTANT_SERIFED = 10;
  {$EXTERNALSYM PAN_MIDLINE_LOW_TRIMMED}
  PAN_MIDLINE_LOW_TRIMMED = 11;
  {$EXTERNALSYM PAN_MIDLINE_LOW_POINTED}
  PAN_MIDLINE_LOW_POINTED = 12;
  {$EXTERNALSYM PAN_MIDLINE_LOW_SERIFED}
  PAN_MIDLINE_LOW_SERIFED = 13;

  {$EXTERNALSYM PAN_XHEIGHT_CONSTANT_SMALL}
  PAN_XHEIGHT_CONSTANT_SMALL = 2;
  {$EXTERNALSYM PAN_XHEIGHT_CONSTANT_STD}
  PAN_XHEIGHT_CONSTANT_STD = 3;
  {$EXTERNALSYM PAN_XHEIGHT_CONSTANT_LARGE}
  PAN_XHEIGHT_CONSTANT_LARGE = 4;
  {$EXTERNALSYM PAN_XHEIGHT_DUCKING_SMALL}
  PAN_XHEIGHT_DUCKING_SMALL = 5;
  {$EXTERNALSYM PAN_XHEIGHT_DUCKING_STD}
  PAN_XHEIGHT_DUCKING_STD = 6;
  {$EXTERNALSYM PAN_XHEIGHT_DUCKING_LARGE}
  PAN_XHEIGHT_DUCKING_LARGE = 7;

  {$EXTERNALSYM ELF_VENDOR_SIZE}
  ELF_VENDOR_SIZE = 4;

{ The extended logical font       }
{ An extension of the ENUMLOGFONT }

type
  PExtLogFontA = ^TExtLogFontA;
  PExtLogFontW = ^TExtLogFontW;
  PExtLogFont = PExtLogFontA;
  {$EXTERNALSYM tagEXTLOGFONTA}
  tagEXTLOGFONTA = record
    elfLogFont: TLogFontA;
    elfFullName: array[0..LF_FULLFACESIZE - 1] of AnsiChar;
    elfStyle: array[0..LF_FACESIZE - 1] of AnsiChar;
    elfVersion: DWORD;     { 0 for the first release of NT }
    elfStyleSize: DWORD;
    elfMatch: DWORD;
    elfReserved: DWORD;
    elfVendorId: array[0..ELF_VENDOR_SIZE - 1] of Byte;
    elfCulture: DWORD;     { 0 for Latin }
    elfPanose: TPanose;
  end;
  {$EXTERNALSYM tagEXTLOGFONTW}
  tagEXTLOGFONTW = record
    elfLogFont: TLogFontW;
    elfFullName: array[0..LF_FULLFACESIZE - 1] of WideChar;
    elfStyle: array[0..LF_FACESIZE - 1] of WideChar;
    elfVersion: DWORD;     { 0 for the first release of NT }
    elfStyleSize: DWORD;
    elfMatch: DWORD;
    elfReserved: DWORD;
    elfVendorId: array[0..ELF_VENDOR_SIZE - 1] of Byte;
    elfCulture: DWORD;     { 0 for Latin }
    elfPanose: TPanose;
  end;
  {$EXTERNALSYM tagEXTLOGFONT}
  tagEXTLOGFONT = tagEXTLOGFONTA;
  TExtLogFontA = tagEXTLOGFONTA;
  TExtLogFontW = tagEXTLOGFONTW;
  TExtLogFont = TExtLogFontA;
  {$EXTERNALSYM EXTLOGFONTA}
  EXTLOGFONTA = tagEXTLOGFONTA;
  {$EXTERNALSYM EXTLOGFONTW}
  EXTLOGFONTW = tagEXTLOGFONTW;
  {$EXTERNALSYM EXTLOGFONT}
  EXTLOGFONT = EXTLOGFONTA;

const
  {$EXTERNALSYM ELF_VERSION}
  ELF_VERSION = 0;
  {$EXTERNALSYM ELF_CULTURE_LATIN}
  ELF_CULTURE_LATIN = 0;


  { EnumFonts Masks }
  {$EXTERNALSYM RASTER_FONTTYPE}
  RASTER_FONTTYPE = 1;
  {$EXTERNALSYM DEVICE_FONTTYPE}
  DEVICE_FONTTYPE = 2;
  {$EXTERNALSYM TRUETYPE_FONTTYPE}
  TRUETYPE_FONTTYPE = 4;

{$EXTERNALSYM RGB}
function RGB(r, g, b: Byte): COLORREF; inline;
{$EXTERNALSYM PaletteRGB}
function PaletteRGB(r, g, b: Byte): COLORREF; inline;
{$EXTERNALSYM PaletteIndex}
function PaletteIndex(i: Word): COLORREF; inline;

const
  { palette entry flags }
  {$EXTERNALSYM PC_RESERVED}
  PC_RESERVED = 1;     { palette index used for animation }
  {$EXTERNALSYM PC_EXPLICIT}
  PC_EXPLICIT = 2;     { palette index is explicit to device }
  {$EXTERNALSYM PC_NOCOLLAPSE}
  PC_NOCOLLAPSE = 4;   { do not match color to system palette }

{$EXTERNALSYM GetRValue}
function GetRValue(rgb: DWORD): Byte; inline;
{$EXTERNALSYM GetGValue}
function GetGValue(rgb: DWORD): Byte; inline;
{$EXTERNALSYM GetBValue}
function GetBValue(rgb: DWORD): Byte; inline;

const
  { Background Modes }
  {$EXTERNALSYM TRANSPARENT}
  TRANSPARENT = 1;
  {$EXTERNALSYM OPAQUE}
  OPAQUE = 2;
  {$EXTERNALSYM BKMODE_LAST}
  BKMODE_LAST = 2;

  { Graphics Modes }
  {$EXTERNALSYM GM_COMPATIBLE}
  GM_COMPATIBLE = 1;
  {$EXTERNALSYM GM_ADVANCED}
  GM_ADVANCED = 2;
  {$EXTERNALSYM GM_LAST}
  GM_LAST = 2;

  { PolyDraw and GetPath point types }
  {$EXTERNALSYM PT_CLOSEFIGURE}
  PT_CLOSEFIGURE = 1;
  {$EXTERNALSYM PT_LINETO}
  PT_LINETO = 2;
  {$EXTERNALSYM PT_BEZIERTO}
  PT_BEZIERTO = 4;
  {$EXTERNALSYM PT_MOVETO}
  PT_MOVETO = 6;

  { Mapping Modes }
  {$EXTERNALSYM MM_TEXT}
  MM_TEXT = 1;
  {$EXTERNALSYM MM_LOMETRIC}
  MM_LOMETRIC = 2;
  {$EXTERNALSYM MM_HIMETRIC}
  MM_HIMETRIC = 3;
  {$EXTERNALSYM MM_LOENGLISH}
  MM_LOENGLISH = 4;
  {$EXTERNALSYM MM_HIENGLISH}
  MM_HIENGLISH = 5;
  {$EXTERNALSYM MM_TWIPS}
  MM_TWIPS = 6;
  {$EXTERNALSYM MM_ISOTROPIC}
  MM_ISOTROPIC = 7;
  {$EXTERNALSYM MM_ANISOTROPIC}
  MM_ANISOTROPIC = 8;

  { Min and Max Mapping Mode values }
  {$EXTERNALSYM MM_MIN}
  MM_MIN = MM_TEXT;
  {$EXTERNALSYM MM_MAX}
  MM_MAX = MM_ANISOTROPIC;
  {$EXTERNALSYM MM_MAX_FIXEDSCALE}
  MM_MAX_FIXEDSCALE = MM_TWIPS;

  { Coordinate Modes }
  {$EXTERNALSYM ABSOLUTE}
  ABSOLUTE = 1;
  {$EXTERNALSYM RELATIVE}
  RELATIVE = 2;

  { Stock Logical Objects }
  {$EXTERNALSYM WHITE_BRUSH}
  WHITE_BRUSH = 0;
  {$EXTERNALSYM LTGRAY_BRUSH}
  LTGRAY_BRUSH = 1;
  {$EXTERNALSYM GRAY_BRUSH}
  GRAY_BRUSH = 2;
  {$EXTERNALSYM DKGRAY_BRUSH}
  DKGRAY_BRUSH = 3;
  {$EXTERNALSYM BLACK_BRUSH}
  BLACK_BRUSH = 4;
  {$EXTERNALSYM NULL_BRUSH}
  NULL_BRUSH = 5;
  {$EXTERNALSYM HOLLOW_BRUSH}
  HOLLOW_BRUSH = NULL_BRUSH;
  {$EXTERNALSYM WHITE_PEN}
  WHITE_PEN = 6;
  {$EXTERNALSYM BLACK_PEN}
  BLACK_PEN = 7;
  {$EXTERNALSYM NULL_PEN}
  NULL_PEN = 8;
  {$EXTERNALSYM OEM_FIXED_FONT}
  OEM_FIXED_FONT = 10;
  {$EXTERNALSYM ANSI_FIXED_FONT}
  ANSI_FIXED_FONT = 11;
  {$EXTERNALSYM ANSI_VAR_FONT}
  ANSI_VAR_FONT = 12;
  {$EXTERNALSYM SYSTEM_FONT}
  SYSTEM_FONT = 13;
  {$EXTERNALSYM DEVICE_DEFAULT_FONT}
  DEVICE_DEFAULT_FONT = 14;
  {$EXTERNALSYM DEFAULT_PALETTE}
  DEFAULT_PALETTE = 15;
  {$EXTERNALSYM SYSTEM_FIXED_FONT}
  SYSTEM_FIXED_FONT = $10;
  {$EXTERNALSYM DEFAULT_GUI_FONT}
  DEFAULT_GUI_FONT = 17;
  {$EXTERNALSYM DC_BRUSH}
  DC_BRUSH = 18;
  {$EXTERNALSYM DC_PEN}
  DC_PEN = 19;
  {$EXTERNALSYM STOCK_LAST}
  STOCK_LAST = 19;

  {$EXTERNALSYM CLR_INVALID}
  CLR_INVALID = DWORD($FFFFFFFF);

  { Brush Styles }
  {$EXTERNALSYM BS_SOLID}
  BS_SOLID                = 0;
  {$EXTERNALSYM BS_NULL}
  BS_NULL                 = 1;
  {$EXTERNALSYM BS_HOLLOW}
  BS_HOLLOW               = BS_NULL;
  {$EXTERNALSYM BS_HATCHED}
  BS_HATCHED              = 2;
  {$EXTERNALSYM BS_PATTERN}
  BS_PATTERN              = 3;
  {$EXTERNALSYM BS_INDEXED}
  BS_INDEXED              = 4;
  {$EXTERNALSYM BS_DIBPATTERN}
  BS_DIBPATTERN           = 5;
  {$EXTERNALSYM BS_DIBPATTERNPT}
  BS_DIBPATTERNPT         = 6;
  {$EXTERNALSYM BS_PATTERN8X8}
  BS_PATTERN8X8           = 7;
  {$EXTERNALSYM BS_DIBPATTERN8X8}
  BS_DIBPATTERN8X8        = 8;
  {$EXTERNALSYM BS_MONOPATTERN}
  BS_MONOPATTERN          = 9;

  { Hatch Styles }
  {$EXTERNALSYM HS_HORIZONTAL}
  HS_HORIZONTAL = 0;       { ----- }
  {$EXTERNALSYM HS_VERTICAL}
  HS_VERTICAL   = 1;       { ||||| }
  {$EXTERNALSYM HS_FDIAGONAL}
  HS_FDIAGONAL  = 2;       { ///// }
  {$EXTERNALSYM HS_BDIAGONAL}
  HS_BDIAGONAL  = 3;       { \\\\\ }
  {$EXTERNALSYM HS_CROSS}
  HS_CROSS      = 4;       { +++++ }
  {$EXTERNALSYM HS_DIAGCROSS}
  HS_DIAGCROSS  = 5;       { xxxxx }


  { Pen Styles }
  {$EXTERNALSYM PS_SOLID}
  PS_SOLID       = 0;
  {$EXTERNALSYM PS_DASH}
  PS_DASH        = 1;      { ------- }
  {$EXTERNALSYM PS_DOT}
  PS_DOT         = 2;      { ....... }
  {$EXTERNALSYM PS_DASHDOT}
  PS_DASHDOT     = 3;      { _._._._ }
  {$EXTERNALSYM PS_DASHDOTDOT}
  PS_DASHDOTDOT  = 4;      { _.._.._ }
  {$EXTERNALSYM PS_NULL}
  PS_NULL = 5;
  {$EXTERNALSYM PS_INSIDEFRAME}
  PS_INSIDEFRAME = 6;
  {$EXTERNALSYM PS_USERSTYLE}
  PS_USERSTYLE = 7;
  {$EXTERNALSYM PS_ALTERNATE}
  PS_ALTERNATE = 8;
  {$EXTERNALSYM PS_STYLE_MASK}
  PS_STYLE_MASK = 15;

  {$EXTERNALSYM PS_ENDCAP_ROUND}
  PS_ENDCAP_ROUND = 0;
  {$EXTERNALSYM PS_ENDCAP_SQUARE}
  PS_ENDCAP_SQUARE = $100;
  {$EXTERNALSYM PS_ENDCAP_FLAT}
  PS_ENDCAP_FLAT = $200;
  {$EXTERNALSYM PS_ENDCAP_MASK}
  PS_ENDCAP_MASK = 3840;

  {$EXTERNALSYM PS_JOIN_ROUND}
  PS_JOIN_ROUND = 0;
  {$EXTERNALSYM PS_JOIN_BEVEL}
  PS_JOIN_BEVEL = $1000;
  {$EXTERNALSYM PS_JOIN_MITER}
  PS_JOIN_MITER = $2000;
  {$EXTERNALSYM PS_JOIN_MASK}
  PS_JOIN_MASK = 61440;

  {$EXTERNALSYM PS_COSMETIC}
  PS_COSMETIC = 0;
  {$EXTERNALSYM PS_GEOMETRIC}
  PS_GEOMETRIC = $10000;
  {$EXTERNALSYM PS_TYPE_MASK}
  PS_TYPE_MASK = $F0000;

  {$EXTERNALSYM AD_COUNTERCLOCKWISE}
  AD_COUNTERCLOCKWISE = 1;
  {$EXTERNALSYM AD_CLOCKWISE}
  AD_CLOCKWISE = 2;

  { Device Parameters for GetDeviceCaps() }
  {$EXTERNALSYM DRIVERVERSION}
  DRIVERVERSION = 0;     { Device driver version                     }
  {$EXTERNALSYM TECHNOLOGY}
  TECHNOLOGY    = 2;     { Device classification                     }
  {$EXTERNALSYM HORZSIZE}
  HORZSIZE      = 4;     { Horizontal size in millimeters            }
  {$EXTERNALSYM VERTSIZE}
  VERTSIZE      = 6;     { Vertical size in millimeters              }
  {$EXTERNALSYM HORZRES}
  HORZRES       = 8;     { Horizontal width in pixels                }
  {$EXTERNALSYM VERTRES}
  VERTRES       = 10;    { Vertical height in pixels                 }
  {$EXTERNALSYM BITSPIXEL}
  BITSPIXEL     = 12;    { Number of bits per pixel                  }
  {$EXTERNALSYM PLANES}
  PLANES        = 14;    { Number of planes                          }
  {$EXTERNALSYM NUMBRUSHES}
  NUMBRUSHES    = $10;   { Number of brushes the device has          }
  {$EXTERNALSYM NUMPENS}
  NUMPENS       = 18;    { Number of pens the device has             }
  {$EXTERNALSYM NUMMARKERS}
  NUMMARKERS    = 20;    { Number of markers the device has          }
  {$EXTERNALSYM NUMFONTS}
  NUMFONTS      = 22;    { Number of fonts the device has            }
  {$EXTERNALSYM NUMCOLORS}
  NUMCOLORS     = 24;    { Number of colors the device supports      }
  {$EXTERNALSYM PDEVICESIZE}
  PDEVICESIZE   = 26;    { Size required for device descriptor       }
  {$EXTERNALSYM CURVECAPS}
  CURVECAPS     = 28;    { Curve capabilities                        }
  {$EXTERNALSYM LINECAPS}
  LINECAPS      = 30;    { Line capabilities                         }
  {$EXTERNALSYM POLYGONALCAPS}
  POLYGONALCAPS = $20;   { Polygonal capabilities                    }
  {$EXTERNALSYM TEXTCAPS}
  TEXTCAPS      = 34;    { Text capabilities                         }
  {$EXTERNALSYM CLIPCAPS}
  CLIPCAPS      = 36;    { Clipping capabilities                     }
  {$EXTERNALSYM RASTERCAPS}
  RASTERCAPS    = 38;    { Bitblt capabilities                       }
  {$EXTERNALSYM ASPECTX}
  ASPECTX       = 40;    { Length of the X leg                       }
  {$EXTERNALSYM ASPECTY}
  ASPECTY       = 42;    { Length of the Y leg                       }
  {$EXTERNALSYM ASPECTXY}
  ASPECTXY      = 44;    { Length of the hypotenuse                  }
  {$EXTERNALSYM SHADEBLENDCAPS}
  SHADEBLENDCAPS = 45;   { Shading and Blending caps                 }

  {$EXTERNALSYM LOGPIXELSX}
  LOGPIXELSX    = 88;    { Logical pixelsinch in X                  }
  {$EXTERNALSYM LOGPIXELSY}
  LOGPIXELSY    = 90;    { Logical pixelsinch in Y                  }

  {$EXTERNALSYM SIZEPALETTE}
  SIZEPALETTE   = 104;   { Number of entries in physical palette     }
  {$EXTERNALSYM NUMRESERVED}
  NUMRESERVED   = 106;   { Number of reserved entries in palette     }
  {$EXTERNALSYM COLORRES}
  COLORRES      = 108;   { Actual color resolution                   }

  { Printing related DeviceCaps. These replace the appropriate Escapes }
  {$EXTERNALSYM PHYSICALWIDTH}
  PHYSICALWIDTH   = 110;     { Physical Width in device units            }
  {$EXTERNALSYM PHYSICALHEIGHT}
  PHYSICALHEIGHT  = 111;     { Physical Height in device units           }
  {$EXTERNALSYM PHYSICALOFFSETX}
  PHYSICALOFFSETX = 112;     { Physical Printable Area x margin          }
  {$EXTERNALSYM PHYSICALOFFSETY}
  PHYSICALOFFSETY = 113;     { Physical Printable Area y margin          }
  {$EXTERNALSYM SCALINGFACTORX}
  SCALINGFACTORX  = 114;     { Scaling factor x                          }
  {$EXTERNALSYM SCALINGFACTORY}
  SCALINGFACTORY  = 115;     { Scaling factor y                          }


  { Display driver specific}
  {$EXTERNALSYM VREFRESH}
  VREFRESH       = 116;     { Current vertical refresh rate of the     }
                            { display device (for displays only) in Hz}
  {$EXTERNALSYM DESKTOPVERTRES}
  DESKTOPVERTRES = 117;     { Horizontal width of entire desktop in    }
                            { pixels                                  }
  {$EXTERNALSYM DESKTOPHORZRES}
  DESKTOPHORZRES = 118;     { Vertical height of entire desktop in     }
                            { pixels                                  }
  {$EXTERNALSYM BLTALIGNMENT}
  BLTALIGNMENT   = 119;     { Preferred blt alignment                  }


{ Device Capability Masks: }

{ Device Technologies }

  {$EXTERNALSYM DT_PLOTTER}
  DT_PLOTTER    = 0;     { Vector plotter                    }
  {$EXTERNALSYM DT_RASDISPLAY}
  DT_RASDISPLAY = 1;     { Raster display                    }
  {$EXTERNALSYM DT_RASPRINTER}
  DT_RASPRINTER = 2;     { Raster printer                    }
  {$EXTERNALSYM DT_RASCAMERA}
  DT_RASCAMERA  = 3;     { Raster camera                     }
  {$EXTERNALSYM DT_CHARSTREAM}
  DT_CHARSTREAM = 4;     { Character-stream, PLP             }
  {$EXTERNALSYM DT_METAFILE}
  DT_METAFILE   = 5;     { Metafile, VDM                     }
  {$EXTERNALSYM DT_DISPFILE}
  DT_DISPFILE   = 6;     { Display-file                      }

{ Curve Capabilities }

  {$EXTERNALSYM CC_NONE}
  CC_NONE       = 0;     { Curves not supported              }
  {$EXTERNALSYM CC_CIRCLES}
  CC_CIRCLES    = 1;     { Can do circles                    }
  {$EXTERNALSYM CC_PIE}
  CC_PIE        = 2;     { Can do pie wedges                 }
  {$EXTERNALSYM CC_CHORD}
  CC_CHORD      = 4;     { Can do chord arcs                 }
  {$EXTERNALSYM CC_ELLIPSES}
  CC_ELLIPSES   = 8;     { Can do ellipese                   }
  {$EXTERNALSYM CC_WIDE}
  CC_WIDE       = $10;   { Can do wide lines                 }
  {$EXTERNALSYM CC_STYLED}
  CC_STYLED     = $20;   { Can do styled lines               }
  {$EXTERNALSYM CC_WIDESTYLED}
  CC_WIDESTYLED = $40;   { Can do wide styled lines          }
  {$EXTERNALSYM CC_INTERIORS}
  CC_INTERIORS  = $80;   { Can do interiors                  }
  {$EXTERNALSYM CC_ROUNDRECT}
  CC_ROUNDRECT  = $100;

{ Line Capabilities }

  {$EXTERNALSYM LC_NONE}
  LC_NONE       = 0;     { Lines not supported               }
  {$EXTERNALSYM LC_POLYLINE}
  LC_POLYLINE   = 2;     { Can do polylines                  }
  {$EXTERNALSYM LC_MARKER}
  LC_MARKER     = 4;     { Can do markers                    }
  {$EXTERNALSYM LC_POLYMARKER}
  LC_POLYMARKER = 8;     { Can do polymarkers                }
  {$EXTERNALSYM LC_WIDE}
  LC_WIDE       = $10;   { Can do wide lines                 }
  {$EXTERNALSYM LC_STYLED}
  LC_STYLED     = $20;   { Can do styled lines               }
  {$EXTERNALSYM LC_WIDESTYLED}
  LC_WIDESTYLED = $40;   { Can do wide styled lines          }
  {$EXTERNALSYM LC_INTERIORS}
  LC_INTERIORS  = $80;   { Can do interiors                  }

{ Polygonal Capabilities }

  {$EXTERNALSYM PC_NONE}
  PC_NONE        = 0;     { Polygonals not supported          }
  {$EXTERNALSYM PC_POLYGON}
  PC_POLYGON     = 1;     { Can do polygons                   }
  {$EXTERNALSYM PC_RECTANGLE}
  PC_RECTANGLE   = 2;     { Can do rectangles                 }
  {$EXTERNALSYM PC_WINDPOLYGON}
  PC_WINDPOLYGON = 4;     { Can do winding polygons           }
  {$EXTERNALSYM PC_TRAPEZOID}
  PC_TRAPEZOID   = 4;     { Can do trapezoids                 }
  {$EXTERNALSYM PC_SCANLINE}
  PC_SCANLINE    = 8;     { Can do scanlines                  }
  {$EXTERNALSYM PC_WIDE}
  PC_WIDE        = $10;   { Can do wide borders               }
  {$EXTERNALSYM PC_STYLED}
  PC_STYLED      = $20;   { Can do styled borders             }
  {$EXTERNALSYM PC_WIDESTYLED}
  PC_WIDESTYLED  = $40;   { Can do wide styled borders        }
  {$EXTERNALSYM PC_INTERIORS}
  PC_INTERIORS   = $80;   { Can do interiors                  }
  {$EXTERNALSYM PC_POLYPOLYGON}
  PC_POLYPOLYGON = $100;  { Can do polypolygons               }
  {$EXTERNALSYM PC_PATHS}
  PC_PATHS       = $200;  { Can do paths                      }

{ Clipping Capabilities }

  {$EXTERNALSYM CP_NONE}
  CP_NONE      = 0;     { No clipping of output             }
  {$EXTERNALSYM CP_RECTANGLE}
  CP_RECTANGLE = 1;     { Output clipped to rects           }
  {$EXTERNALSYM CP_REGION}
  CP_REGION    = 2;     { obsolete                          }

{ Text Capabilities }

  {$EXTERNALSYM TC_OP_CHARACTER}
  TC_OP_CHARACTER = 1;      { Can do OutputPrecision   CHARACTER       }
  {$EXTERNALSYM TC_OP_STROKE}
  TC_OP_STROKE    = 2;      { Can do OutputPrecision   STROKE          }
  {$EXTERNALSYM TC_CP_STROKE}
  TC_CP_STROKE    = 4;      { Can do ClipPrecision     STROKE          }
  {$EXTERNALSYM TC_CR_90}
  TC_CR_90        = 8;      { Can do CharRotAbility    90              }
  {$EXTERNALSYM TC_CR_ANY}
  TC_CR_ANY       = $10;    { Can do CharRotAbility    ANY             }
  {$EXTERNALSYM TC_SF_X_YINDEP}
  TC_SF_X_YINDEP  = $20;    { Can do ScaleFreedom      X_YINDEPENDENT  }
  {$EXTERNALSYM TC_SA_DOUBLE}
  TC_SA_DOUBLE    = $40;    { Can do ScaleAbility      DOUBLE          }
  {$EXTERNALSYM TC_SA_INTEGER}
  TC_SA_INTEGER   = $80;    { Can do ScaleAbility      INTEGER         }
  {$EXTERNALSYM TC_SA_CONTIN}
  TC_SA_CONTIN    = $100;   { Can do ScaleAbility      CONTINUOUS      }
  {$EXTERNALSYM TC_EA_DOUBLE}
  TC_EA_DOUBLE    = $200;   { Can do EmboldenAbility   DOUBLE          }
  {$EXTERNALSYM TC_IA_ABLE}
  TC_IA_ABLE      = $400;   { Can do ItalisizeAbility  ABLE            }
  {$EXTERNALSYM TC_UA_ABLE}
  TC_UA_ABLE      = $800;   { Can do UnderlineAbility  ABLE            }
  {$EXTERNALSYM TC_SO_ABLE}
  TC_SO_ABLE      = $1000;  { Can do StrikeOutAbility  ABLE            }
  {$EXTERNALSYM TC_RA_ABLE}
  TC_RA_ABLE      = $2000;  { Can do RasterFontAble    ABLE            }
  {$EXTERNALSYM TC_VA_ABLE}
  TC_VA_ABLE      = $4000;  { Can do VectorFontAble    ABLE            }
  {$EXTERNALSYM TC_RESERVED}
  TC_RESERVED     = $8000;
  {$EXTERNALSYM TC_SCROLLBLT}
  TC_SCROLLBLT    = $10000; { Don't do text scroll with blt            }

{ Raster Capabilities }

  {$EXTERNALSYM RC_BITBLT}
  RC_BITBLT       = 1;     { Can do standard BLT.              }
  {$EXTERNALSYM RC_BANDING}
  RC_BANDING      = 2;     { Device requires banding support   }
  {$EXTERNALSYM RC_SCALING}
  RC_SCALING      = 4;     { Device requires scaling support   }
  {$EXTERNALSYM RC_BITMAP64}
  RC_BITMAP64     = 8;     { Device can support >64K bitmap    }
  {$EXTERNALSYM RC_GDI20_OUTPUT}
  RC_GDI20_OUTPUT = $10;   { has 2.0 output calls          }
  {$EXTERNALSYM RC_GDI20_STATE}
  RC_GDI20_STATE  = $20;
  {$EXTERNALSYM RC_SAVEBITMAP}
  RC_SAVEBITMAP   = $40;
  {$EXTERNALSYM RC_DI_BITMAP}
  RC_DI_BITMAP    = $80;   { supports DIB to memory        }
  {$EXTERNALSYM RC_PALETTE}
  RC_PALETTE      = $100;  { supports a palette            }
  {$EXTERNALSYM RC_DIBTODEV}
  RC_DIBTODEV     = $200;  { supports DIBitsToDevice       }
  {$EXTERNALSYM RC_BIGFONT}
  RC_BIGFONT      = $400;  { supports >64K fonts           }
  {$EXTERNALSYM RC_STRETCHBLT}
  RC_STRETCHBLT   = $800;  { supports StretchBlt           }
  {$EXTERNALSYM RC_FLOODFILL}
  RC_FLOODFILL    = $1000; { supports FloodFill            }
  {$EXTERNALSYM RC_STRETCHDIB}
  RC_STRETCHDIB   = $2000; { supports StretchDIBits        }
  {$EXTERNALSYM RC_OP_DX_OUTPUT}
  RC_OP_DX_OUTPUT = $4000;
  {$EXTERNALSYM RC_DEVBITS}
  RC_DEVBITS      = $8000;

{ Shading and blending caps }
  {$EXTERNALSYM SB_NONE}
  SB_NONE = 0;
  {$EXTERNALSYM SB_CONST_ALPHA}
  SB_CONST_ALPHA = 1;
  {$EXTERNALSYM SB_PIXEL_ALPHA}
  SB_PIXEL_ALPHA = 2;
  {$EXTERNALSYM SB_PREMULT_ALPHA}
  SB_PREMULT_ALPHA = 4;
  {$EXTERNALSYM SB_GRAD_RECT}
  SB_GRAD_RECT = $10;
  {$EXTERNALSYM SB_GRAD_TRI}
  SB_GRAD_TRI = $20;

{ DIB color table identifiers }

  {$EXTERNALSYM DIB_RGB_COLORS}
  DIB_RGB_COLORS = 0;     { color table in RGBs  }
  {$EXTERNALSYM DIB_PAL_COLORS}
  DIB_PAL_COLORS = 1;     { color table in palette indices  }

{ constants for GetSetSystemPaletteUse() }

  {$EXTERNALSYM SYSPAL_ERROR}
  SYSPAL_ERROR = 0;
  {$EXTERNALSYM SYSPAL_STATIC}
  SYSPAL_STATIC = 1;
  {$EXTERNALSYM SYSPAL_NOSTATIC}
  SYSPAL_NOSTATIC = 2;

{ constants for CreateDIBitmap }

  {$EXTERNALSYM CBM_INIT}
  CBM_INIT = 4;     { initialize bitmap  }

{ ExtFloodFill style flags }

  {$EXTERNALSYM FLOODFILLBORDER}
  FLOODFILLBORDER = 0;
  {$EXTERNALSYM FLOODFILLSURFACE}
  FLOODFILLSURFACE = 1;

  {$EXTERNALSYM CCHDEVICENAME}
  CCHDEVICENAME = 32;     { size of a device name string  }
  {$EXTERNALSYM CCHFORMNAME}
  CCHFORMNAME   = 32;     { size of a form name string  }

type
  PDeviceModeA = ^TDeviceModeA;
  PDeviceModeW = ^TDeviceModeW;
  PDeviceMode = PDeviceModeA;
  {$EXTERNALSYM _devicemodeA}
  _devicemodeA = packed record
    dmDeviceName: array[0..CCHDEVICENAME - 1] of AnsiChar;
    dmSpecVersion: Word;
    dmDriverVersion: Word;
    dmSize: Word;
    dmDriverExtra: Word;
    dmFields: DWORD;
    dmOrientation: SHORT;
    dmPaperSize: SHORT;
    dmPaperLength: SHORT;
    dmPaperWidth: SHORT;
    dmScale: SHORT;
    dmCopies: SHORT;
    dmDefaultSource: SHORT;
    dmPrintQuality: SHORT;
    dmColor: SHORT;
    dmDuplex: SHORT;
    dmYResolution: SHORT;
    dmTTOption: SHORT;
    dmCollate: SHORT;
    dmFormName: array[0..CCHFORMNAME - 1] of AnsiChar;
    dmLogPixels: Word;
    dmBitsPerPel: DWORD;
    dmPelsWidth: DWORD;
    dmPelsHeight: DWORD;
    dmDisplayFlags: DWORD;
    dmDisplayFrequency: DWORD;
    dmICMMethod: DWORD;
    dmICMIntent: DWORD;
    dmMediaType: DWORD;
    dmDitherType: DWORD;
    dmICCManufacturer: DWORD;
    dmICCModel: DWORD;
    dmPanningWidth: DWORD;
    dmPanningHeight: DWORD;
  end;
  {$EXTERNALSYM _devicemodeW}
  _devicemodeW = packed record
    dmDeviceName: array[0..CCHDEVICENAME - 1] of WideChar;
    dmSpecVersion: Word;
    dmDriverVersion: Word;
    dmSize: Word;
    dmDriverExtra: Word;
    dmFields: DWORD;
    dmOrientation: SHORT;
    dmPaperSize: SHORT;
    dmPaperLength: SHORT;
    dmPaperWidth: SHORT;
    dmScale: SHORT;
    dmCopies: SHORT;
    dmDefaultSource: SHORT;
    dmPrintQuality: SHORT;
    dmColor: SHORT;
    dmDuplex: SHORT;
    dmYResolution: SHORT;
    dmTTOption: SHORT;
    dmCollate: SHORT;
    dmFormName: array[0..CCHFORMNAME - 1] of WideChar;
    dmLogPixels: Word;
    dmBitsPerPel: DWORD;
    dmPelsWidth: DWORD;
    dmPelsHeight: DWORD;
    dmDisplayFlags: DWORD;
    dmDisplayFrequency: DWORD;
    dmICMMethod: DWORD;
    dmICMIntent: DWORD;
    dmMediaType: DWORD;
    dmDitherType: DWORD;
    dmICCManufacturer: DWORD;
    dmICCModel: DWORD;
    dmPanningWidth: DWORD;
    dmPanningHeight: DWORD;
  end;
  {$EXTERNALSYM _devicemode}
  _devicemode = _devicemodeA;
  TDeviceModeA = _devicemodeA;
  TDeviceModeW = _devicemodeW;
  TDeviceMode = TDeviceModeA;
  {$EXTERNALSYM DEVMODEA}
  DEVMODEA = _devicemodeA;
  {$EXTERNALSYM DEVMODEW}
  DEVMODEW = _devicemodeW;
  {$EXTERNALSYM DEVMODE}
  DEVMODE = DEVMODEA;

  PDevMode = PDeviceMode;  {compatibility with Delphi 1.0}
  TDevMode = TDeviceMode;  {compatibility with Delphi 1.0}

const
  {$EXTERNALSYM DM_SPECVERSION}
  DM_SPECVERSION = $401;  { current version of specification }

{ field selection bits }

  {$EXTERNALSYM DM_ORIENTATION}
  DM_ORIENTATION = 1;
  {$EXTERNALSYM DM_PAPERSIZE}
  DM_PAPERSIZE = 2;
  {$EXTERNALSYM DM_PAPERLENGTH}
  DM_PAPERLENGTH = 4;
  {$EXTERNALSYM DM_PAPERWIDTH}
  DM_PAPERWIDTH = 8;
  {$EXTERNALSYM DM_SCALE}
  DM_SCALE = $10;
  {$EXTERNALSYM DM_POSITION}
  DM_POSITION = $20;
  {$EXTERNALSYM DM_COPIES}
  DM_COPIES = $100;
  {$EXTERNALSYM DM_DEFAULTSOURCE}
  DM_DEFAULTSOURCE = $200;
  {$EXTERNALSYM DM_PRINTQUALITY}
  DM_PRINTQUALITY = $400;
  {$EXTERNALSYM DM_COLOR}
  DM_COLOR = $800;
  {$EXTERNALSYM DM_DUPLEX}
  DM_DUPLEX = $1000;
  {$EXTERNALSYM DM_YRESOLUTION}
  DM_YRESOLUTION = $2000;
  {$EXTERNALSYM DM_TTOPTION}
  DM_TTOPTION = $4000;
  {$EXTERNALSYM DM_COLLATE}
  DM_COLLATE = $8000;
  {$EXTERNALSYM DM_FORMNAME}
  DM_FORMNAME = $10000;
  {$EXTERNALSYM DM_LOGPIXELS}
  DM_LOGPIXELS = $20000;
  {$EXTERNALSYM DM_BITSPERPEL}
  DM_BITSPERPEL = $40000;
  {$EXTERNALSYM DM_PELSWIDTH}
  DM_PELSWIDTH = $80000;
  {$EXTERNALSYM DM_PELSHEIGHT}
  DM_PELSHEIGHT = $100000;
  {$EXTERNALSYM DM_DISPLAYFLAGS}
  DM_DISPLAYFLAGS = $200000;
  {$EXTERNALSYM DM_DISPLAYFREQUENCY}
  DM_DISPLAYFREQUENCY = $400000;
  {$EXTERNALSYM DM_PANNINGWIDTH}
  DM_PANNINGWIDTH = $00800000;
  {$EXTERNALSYM DM_PANNINGHEIGHT}
  DM_PANNINGHEIGHT = $01000000;
  {$EXTERNALSYM DM_ICMMETHOD}
  DM_ICMMETHOD = $2000000;
  {$EXTERNALSYM DM_ICMINTENT}
  DM_ICMINTENT = $4000000;
  {$EXTERNALSYM DM_MEDIATYPE}
  DM_MEDIATYPE = $8000000;
  {$EXTERNALSYM DM_DITHERTYPE}
  DM_DITHERTYPE = $10000000;
  {$EXTERNALSYM DM_ICCMANUFACTURER}
  DM_ICCMANUFACTURER = $20000000;
  {$EXTERNALSYM DM_ICCMODEL}
  DM_ICCMODEL = $40000000;

{ orientation selections }

  {$EXTERNALSYM DMORIENT_PORTRAIT}
  DMORIENT_PORTRAIT = 1;
  {$EXTERNALSYM DMORIENT_LANDSCAPE}
  DMORIENT_LANDSCAPE = 2;

{ paper selections }

  {$EXTERNALSYM DMPAPER_LETTER}
  DMPAPER_LETTER      = 1;  { Letter 8 12 x 11 in               }
  {$EXTERNALSYM DMPAPER_FIRST}
  DMPAPER_FIRST       = DMPAPER_LETTER;
  {$EXTERNALSYM DMPAPER_LETTERSMALL}
  DMPAPER_LETTERSMALL = 2;  { Letter Small 8 12 x 11 in         }
  {$EXTERNALSYM DMPAPER_TABLOID}
  DMPAPER_TABLOID     = 3;  { Tabloid 11 x 17 in                }
  {$EXTERNALSYM DMPAPER_LEDGER}
  DMPAPER_LEDGER      = 4;  { Ledger 17 x 11 in                 }
  {$EXTERNALSYM DMPAPER_LEGAL}
  DMPAPER_LEGAL       = 5;  { Legal 8 12 x 14 in                }
  {$EXTERNALSYM DMPAPER_STATEMENT}
  DMPAPER_STATEMENT   = 6;  { Statement 5 12 x 8 12 in          }
  {$EXTERNALSYM DMPAPER_EXECUTIVE}
  DMPAPER_EXECUTIVE   = 7;  { Executive 7 14 x 10 12 in         }
  {$EXTERNALSYM DMPAPER_A3}
  DMPAPER_A3      = 8;      { A3 297 x 420 mm                     }
  {$EXTERNALSYM DMPAPER_A4}
  DMPAPER_A4      = 9;      { A4 210 x 297 mm                     }
  {$EXTERNALSYM DMPAPER_A4SMALL}
  DMPAPER_A4SMALL = 10;     { A4 Small 210 x 297 mm               }
  {$EXTERNALSYM DMPAPER_A5}
  DMPAPER_A5      = 11;     { A5 148 x 210 mm                     }
  {$EXTERNALSYM DMPAPER_B4}
  DMPAPER_B4      = 12;     { B4 (JIS) 250 x 354                  }
  {$EXTERNALSYM DMPAPER_B5}
  DMPAPER_B5      = 13;     { B5 (JIS) 182 x 257 mm               }
  {$EXTERNALSYM DMPAPER_FOLIO}
  DMPAPER_FOLIO   = 14;     { Folio 8 12 x 13 in                  }
  {$EXTERNALSYM DMPAPER_QUARTO}
  DMPAPER_QUARTO  = 15;     { Quarto 215 x 275 mm                 }
  {$EXTERNALSYM DMPAPER_10X14}
  DMPAPER_10X14   = 16;     { 10x14 in                            }
  {$EXTERNALSYM DMPAPER_11X17}
  DMPAPER_11X17   = 17;     { 11x17 in                            }
  {$EXTERNALSYM DMPAPER_NOTE}
  DMPAPER_NOTE    = 18;     { Note 8 12 x 11 in                   }
  {$EXTERNALSYM DMPAPER_ENV_9}
  DMPAPER_ENV_9   = 19;     { Envelope #9 3 78 x 8 78             }
  {$EXTERNALSYM DMPAPER_ENV_10}
  DMPAPER_ENV_10  = 20;     { Envelope #10 4 18 x 9 12            }
  {$EXTERNALSYM DMPAPER_ENV_11}
  DMPAPER_ENV_11  = 21;     { Envelope #11 4 12 x 10 38           }
  {$EXTERNALSYM DMPAPER_ENV_12}
  DMPAPER_ENV_12  = 22;     { Envelope #12 4 \276 x 11            }
  {$EXTERNALSYM DMPAPER_ENV_14}
  DMPAPER_ENV_14  = 23;     { Envelope #14 5 x 11 12              }
  {$EXTERNALSYM DMPAPER_CSHEET}
  DMPAPER_CSHEET  = 24;     { C size sheet                        }
  {$EXTERNALSYM DMPAPER_DSHEET}
  DMPAPER_DSHEET  = 25;     { D size sheet                        }
  {$EXTERNALSYM DMPAPER_ESHEET}
  DMPAPER_ESHEET  = 26;     { E size sheet                        }
  {$EXTERNALSYM DMPAPER_ENV_DL}
  DMPAPER_ENV_DL  = 27;     { Envelope DL 110 x 220mm             }
  {$EXTERNALSYM DMPAPER_ENV_C5}
  DMPAPER_ENV_C5  = 28;     { Envelope C5 162 x 229 mm            }
  {$EXTERNALSYM DMPAPER_ENV_C3}
  DMPAPER_ENV_C3  = 29;     { Envelope C3  324 x 458 mm           }
  {$EXTERNALSYM DMPAPER_ENV_C4}
  DMPAPER_ENV_C4  = 30;     { Envelope C4  229 x 324 mm           }
  {$EXTERNALSYM DMPAPER_ENV_C6}
  DMPAPER_ENV_C6  = 31;     { Envelope C6  114 x 162 mm           }
  {$EXTERNALSYM DMPAPER_ENV_C65}
  DMPAPER_ENV_C65  = 32;    { Envelope C65 114 x 229 mm           }
  {$EXTERNALSYM DMPAPER_ENV_B4}
  DMPAPER_ENV_B4   = 33;    { Envelope B4  250 x 353 mm           }
  {$EXTERNALSYM DMPAPER_ENV_B5}
  DMPAPER_ENV_B5   = 34;    { Envelope B5  176 x 250 mm           }
  {$EXTERNALSYM DMPAPER_ENV_B6}
  DMPAPER_ENV_B6   = 35;    { Envelope B6  176 x 125 mm           }
  {$EXTERNALSYM DMPAPER_ENV_ITALY}
  DMPAPER_ENV_ITALY          = 36;  { Envelope 110 x 230 mm               }
  {$EXTERNALSYM DMPAPER_ENV_MONARCH}
  DMPAPER_ENV_MONARCH        = 37;  { Envelope Monarch 3.875 x 7.5 in     }
  {$EXTERNALSYM DMPAPER_ENV_PERSONAL}
  DMPAPER_ENV_PERSONAL       = 38;  { 6 34 Envelope 3 58 x 6 12 in        }
  {$EXTERNALSYM DMPAPER_FANFOLD_US}
  DMPAPER_FANFOLD_US         = 39;  { US Std Fanfold 14 78 x 11 in        }
  {$EXTERNALSYM DMPAPER_FANFOLD_STD_GERMAN}
  DMPAPER_FANFOLD_STD_GERMAN = 40;  { German Std Fanfold 8 12 x 12 in    }
  {$EXTERNALSYM DMPAPER_FANFOLD_LGL_GERMAN}
  DMPAPER_FANFOLD_LGL_GERMAN = 41;  { German Legal Fanfold 8 12 x 13 in  }
  {$EXTERNALSYM DMPAPER_ISO_B4}
  DMPAPER_ISO_B4             = 42;  { B4 (ISO) 250 x 353 mm               }
  {$EXTERNALSYM DMPAPER_JAPANESE_POSTCARD}
  DMPAPER_JAPANESE_POSTCARD  = 43;  { Japanese Postcard 100 x 148 mm      }
  {$EXTERNALSYM DMPAPER_9X11}
  DMPAPER_9X11               = 44;  { 9 x 11 in                           }
  {$EXTERNALSYM DMPAPER_10X11}
  DMPAPER_10X11              = 45;  { 10 x 11 in                          }
  {$EXTERNALSYM DMPAPER_15X11}
  DMPAPER_15X11              = 46;  { 15 x 11 in                          }
  {$EXTERNALSYM DMPAPER_ENV_INVITE}
  DMPAPER_ENV_INVITE         = 47;  { Envelope Invite 220 x 220 mm        }
  {$EXTERNALSYM DMPAPER_RESERVED_48}
  DMPAPER_RESERVED_48        = 48;  { RESERVED--DO NOT USE                }
  {$EXTERNALSYM DMPAPER_RESERVED_49}
  DMPAPER_RESERVED_49        = 49;  { RESERVED--DO NOT USE                }
  {$EXTERNALSYM DMPAPER_LETTER_EXTRA}
  DMPAPER_LETTER_EXTRA       = 50;  { Letter Extra 9 \275 x 12 in         }
  {$EXTERNALSYM DMPAPER_LEGAL_EXTRA}
  DMPAPER_LEGAL_EXTRA        = 51;  { Legal Extra 9 \275 x 15 in          }
  {$EXTERNALSYM DMPAPER_TABLOID_EXTRA}
  DMPAPER_TABLOID_EXTRA      = 52;  { Tabloid Extra 11.69 x 18 in         }
  {$EXTERNALSYM DMPAPER_A4_EXTRA}
  DMPAPER_A4_EXTRA           = 53;  { A4 Extra 9.27 x 12.69 in            }
  {$EXTERNALSYM DMPAPER_LETTER_TRANSVERSE}
  DMPAPER_LETTER_TRANSVERSE  = 54;  { Letter Transverse 8 \275 x 11 in    }
  {$EXTERNALSYM DMPAPER_A4_TRANSVERSE}
  DMPAPER_A4_TRANSVERSE      = 55;  { A4 Transverse 210 x 297 mm          }
  {$EXTERNALSYM DMPAPER_LETTER_EXTRA_TRANSVERSE}
  DMPAPER_LETTER_EXTRA_TRANSVERSE = 56;     { Letter Extra Transverse 9\275 x 12 in  }
  {$EXTERNALSYM DMPAPER_A_PLUS}
  DMPAPER_A_PLUS        = 57;     { SuperASuperAA4 227 x 356 mm       }
  {$EXTERNALSYM DMPAPER_B_PLUS}
  DMPAPER_B_PLUS        = 58;     { SuperBSuperBA3 305 x 487 mm       }
  {$EXTERNALSYM DMPAPER_LETTER_PLUS}
  DMPAPER_LETTER_PLUS   = 59;     { Letter Plus 8.5 x 12.69 in          }
  {$EXTERNALSYM DMPAPER_A4_PLUS}
  DMPAPER_A4_PLUS       = 60;     { A4 Plus 210 x 330 mm                }
  {$EXTERNALSYM DMPAPER_A5_TRANSVERSE}
  DMPAPER_A5_TRANSVERSE = 61;     { A5 Transverse 148 x 210 mm          }
  {$EXTERNALSYM DMPAPER_B5_TRANSVERSE}
  DMPAPER_B5_TRANSVERSE = 62;     { B5 (JIS) Transverse 182 x 257 mm    }
  {$EXTERNALSYM DMPAPER_A3_EXTRA}
  DMPAPER_A3_EXTRA      = 63;     { A3 Extra 322 x 445 mm               }
  {$EXTERNALSYM DMPAPER_A5_EXTRA}
  DMPAPER_A5_EXTRA      = $40;    { A5 Extra 174 x 235 mm               }
  {$EXTERNALSYM DMPAPER_B5_EXTRA}
  DMPAPER_B5_EXTRA      = 65;     { B5 (ISO) Extra 201 x 276 mm         }
  {$EXTERNALSYM DMPAPER_A2}
  DMPAPER_A2            = 66;     { A2 420 x 594 mm                     }
  {$EXTERNALSYM DMPAPER_A3_TRANSVERSE}
  DMPAPER_A3_TRANSVERSE = 67;     { A3 Transverse 297 x 420 mm          }
  {$EXTERNALSYM DMPAPER_A3_EXTRA_TRANSVERSE}
  DMPAPER_A3_EXTRA_TRANSVERSE = 68;     { A3 Extra Transverse 322 x 445 mm    }
{
 ** the following sizes are reserved for the Far East version of Win95.
 ** Rotated papers rotate the physical page but not the logical page.
}
  {$EXTERNALSYM DMPAPER_DBL_JAPANESE_POSTCARD}
  DMPAPER_DBL_JAPANESE_POSTCARD = 69; { Japanese Double Postcard 200 x 148 mm }

  {$EXTERNALSYM DMPAPER_A6}
  DMPAPER_A6                  = 70;  { A6 105 x 148 mm                 }

  {$EXTERNALSYM DMPAPER_JENV_KAKU2          }
  DMPAPER_JENV_KAKU2          = 71;  { Japanese Envelope Kaku #2       }
  {$EXTERNALSYM DMPAPER_JENV_KAKU3          }
  DMPAPER_JENV_KAKU3          = 72;  { Japanese Envelope Kaku #3       }
  {$EXTERNALSYM DMPAPER_JENV_CHOU3          }
  DMPAPER_JENV_CHOU3          = 73;  { Japanese Envelope Chou #3       }
  {$EXTERNALSYM DMPAPER_JENV_CHOU4          }
  DMPAPER_JENV_CHOU4          = 74;  { Japanese Envelope Chou #4       }
  {$EXTERNALSYM DMPAPER_LETTER_ROTATED      }
  DMPAPER_LETTER_ROTATED      = 75;  { Letter Rotated 11 x 8 1/2 11 in }
  {$EXTERNALSYM DMPAPER_A3_ROTATED          }
  DMPAPER_A3_ROTATED          = 76;  { A3 Rotated 420 x 297 mm         }
  {$EXTERNALSYM DMPAPER_A4_ROTATED          }
  DMPAPER_A4_ROTATED          = 77;  { A4 Rotated 297 x 210 mm         }
  {$EXTERNALSYM DMPAPER_A5_ROTATED          }
  DMPAPER_A5_ROTATED          = 78;  { A5 Rotated 210 x 148 mm         }
  {$EXTERNALSYM DMPAPER_B4_JIS_ROTATED      }
  DMPAPER_B4_JIS_ROTATED      = 79;  { B4 (JIS) Rotated 364 x 257 mm   }
  {$EXTERNALSYM DMPAPER_B5_JIS_ROTATED      }
  DMPAPER_B5_JIS_ROTATED      = 80;  { B5 (JIS) Rotated 257 x 182 mm   }
  {$EXTERNALSYM DMPAPER_JAPANESE_POSTCARD_ROTATED }
  DMPAPER_JAPANESE_POSTCARD_ROTATED = 81; { Japanese Postcard Rotated 148 x 100 mm }
  {$EXTERNALSYM DMPAPER_DBL_JAPANESE_POSTCARD_ROTATED }
  DMPAPER_DBL_JAPANESE_POSTCARD_ROTATED = 82; { Double Japanese Postcard Rotated 148 x 200 mm }
  {$EXTERNALSYM DMPAPER_A6_ROTATED          }
  DMPAPER_A6_ROTATED          = 83;  { A6 Rotated 148 x 105 mm         }
  {$EXTERNALSYM DMPAPER_JENV_KAKU2_ROTATED  }
  DMPAPER_JENV_KAKU2_ROTATED  = 84;  { Japanese Envelope Kaku #2 Rotated}
  {$EXTERNALSYM DMPAPER_JENV_KAKU3_ROTATED  }
  DMPAPER_JENV_KAKU3_ROTATED  = 85;  { Japanese Envelope Kaku #3 Rotated}
  {$EXTERNALSYM DMPAPER_JENV_CHOU3_ROTATED  }
  DMPAPER_JENV_CHOU3_ROTATED  = 86;  { Japanese Envelope Chou #3 Rotated}
  {$EXTERNALSYM DMPAPER_JENV_CHOU4_ROTATED  }
  DMPAPER_JENV_CHOU4_ROTATED  = 87;  { Japanese Envelope Chou #4 Rotated}
  {$EXTERNALSYM DMPAPER_B6_JIS              }
  DMPAPER_B6_JIS              = 88;  { B6 (JIS) 128 x 182 mm           }
  {$EXTERNALSYM DMPAPER_B6_JIS_ROTATED      }
  DMPAPER_B6_JIS_ROTATED      = 89;  { B6 (JIS) Rotated 182 x 128 mm   }
  {$EXTERNALSYM DMPAPER_12X11               }
  DMPAPER_12X11               = 90;  { 12 x 11 in                      }
  {$EXTERNALSYM DMPAPER_JENV_YOU4           }
  DMPAPER_JENV_YOU4           = 91;  { Japanese Envelope You #4        }
  {$EXTERNALSYM DMPAPER_JENV_YOU4_ROTATED   }
  DMPAPER_JENV_YOU4_ROTATED   = 92;  { Japanese Envelope You #4 Rotated}
  {$EXTERNALSYM DMPAPER_P16K                }
  DMPAPER_P16K                = 93;  { PRC 16K 146 x 215 mm            }
  {$EXTERNALSYM DMPAPER_P32K                }
  DMPAPER_P32K                = 94;  { PRC 32K 97 x 151 mm             }
  {$EXTERNALSYM DMPAPER_P32KBIG             }
  DMPAPER_P32KBIG             = 95;  { PRC 32K(Big) 97 x 151 mm        }
  {$EXTERNALSYM DMPAPER_PENV_1              }
  DMPAPER_PENV_1              = 96;  { PRC Envelope #1 102 x 165 mm    }
  {$EXTERNALSYM DMPAPER_PENV_2              }
  DMPAPER_PENV_2              = 97;  { PRC Envelope #2 102 x 176 mm    }
  {$EXTERNALSYM DMPAPER_PENV_3              }
  DMPAPER_PENV_3              = 98;  { PRC Envelope #3 125 x 176 mm    }
  {$EXTERNALSYM DMPAPER_PENV_4              }
  DMPAPER_PENV_4              = 99;  { PRC Envelope #4 110 x 208 mm    }
  {$EXTERNALSYM DMPAPER_PENV_5              }
  DMPAPER_PENV_5              = 100; { PRC Envelope #5 110 x 220 mm    }
  {$EXTERNALSYM DMPAPER_PENV_6              }
  DMPAPER_PENV_6              = 101; { PRC Envelope #6 120 x 230 mm    }
  {$EXTERNALSYM DMPAPER_PENV_7              }
  DMPAPER_PENV_7              = 102; { PRC Envelope #7 160 x 230 mm    }
  {$EXTERNALSYM DMPAPER_PENV_8              }
  DMPAPER_PENV_8              = 103; { PRC Envelope #8 120 x 309 mm    }
  {$EXTERNALSYM DMPAPER_PENV_9              }
  DMPAPER_PENV_9              = 104; { PRC Envelope #9 229 x 324 mm    }
  {$EXTERNALSYM DMPAPER_PENV_10             }
  DMPAPER_PENV_10             = 105; { PRC Envelope #10 324 x 458 mm   }
  {$EXTERNALSYM DMPAPER_P16K_ROTATED        }
  DMPAPER_P16K_ROTATED        = 106; { PRC 16K Rotated                 }
  {$EXTERNALSYM DMPAPER_P32K_ROTATED        }
  DMPAPER_P32K_ROTATED        = 107; { PRC 32K Rotated                 }
  {$EXTERNALSYM DMPAPER_P32KBIG_ROTATED     }
  DMPAPER_P32KBIG_ROTATED     = 108; { PRC 32K(Big) Rotated            }
  {$EXTERNALSYM DMPAPER_PENV_1_ROTATED      }
  DMPAPER_PENV_1_ROTATED      = 109; { PRC Envelope #1 Rotated 165 x 102 mm}
  {$EXTERNALSYM DMPAPER_PENV_2_ROTATED      }
  DMPAPER_PENV_2_ROTATED      = 110; { PRC Envelope #2 Rotated 176 x 102 mm}
  {$EXTERNALSYM DMPAPER_PENV_3_ROTATED      }
  DMPAPER_PENV_3_ROTATED      = 111; { PRC Envelope #3 Rotated 176 x 125 mm}
  {$EXTERNALSYM DMPAPER_PENV_4_ROTATED      }
  DMPAPER_PENV_4_ROTATED      = 112; { PRC Envelope #4 Rotated 208 x 110 mm}
  {$EXTERNALSYM DMPAPER_PENV_5_ROTATED      }
  DMPAPER_PENV_5_ROTATED      = 113; { PRC Envelope #5 Rotated 220 x 110 mm}
  {$EXTERNALSYM DMPAPER_PENV_6_ROTATED      }
  DMPAPER_PENV_6_ROTATED      = 114; { PRC Envelope #6 Rotated 230 x 120 mm}
  {$EXTERNALSYM DMPAPER_PENV_7_ROTATED      }
  DMPAPER_PENV_7_ROTATED      = 115; { PRC Envelope #7 Rotated 230 x 160 mm}
  {$EXTERNALSYM DMPAPER_PENV_8_ROTATED      }
  DMPAPER_PENV_8_ROTATED      = 116; { PRC Envelope #8 Rotated 309 x 120 mm}
  {$EXTERNALSYM DMPAPER_PENV_9_ROTATED      }
  DMPAPER_PENV_9_ROTATED      = 117; { PRC Envelope #9 Rotated 324 x 229 mm}
  {$EXTERNALSYM DMPAPER_PENV_10_ROTATED     }
  DMPAPER_PENV_10_ROTATED     = 118; { PRC Envelope #10 Rotated 458 x 324 mm }
  {$EXTERNALSYM DMPAPER_LAST}
  DMPAPER_LAST                = DMPAPER_PENV_10_ROTATED;
  {$EXTERNALSYM DMPAPER_USER}
  DMPAPER_USER                = $100;

{ bin selections }

  {$EXTERNALSYM DMBIN_UPPER}
  DMBIN_UPPER = 1;
  {$EXTERNALSYM DMBIN_FIRST}
  DMBIN_FIRST = DMBIN_UPPER;
  {$EXTERNALSYM DMBIN_ONLYONE}
  DMBIN_ONLYONE = 1;
  {$EXTERNALSYM DMBIN_LOWER}
  DMBIN_LOWER = 2;
  {$EXTERNALSYM DMBIN_MIDDLE}
  DMBIN_MIDDLE = 3;
  {$EXTERNALSYM DMBIN_MANUAL}
  DMBIN_MANUAL = 4;
  {$EXTERNALSYM DMBIN_ENVELOPE}
  DMBIN_ENVELOPE = 5;
  {$EXTERNALSYM DMBIN_ENVMANUAL}
  DMBIN_ENVMANUAL = 6;
  {$EXTERNALSYM DMBIN_AUTO}
  DMBIN_AUTO = 7;
  {$EXTERNALSYM DMBIN_TRACTOR}
  DMBIN_TRACTOR = 8;
  {$EXTERNALSYM DMBIN_SMALLFMT}
  DMBIN_SMALLFMT = 9;
  {$EXTERNALSYM DMBIN_LARGEFMT}
  DMBIN_LARGEFMT = 10;
  {$EXTERNALSYM DMBIN_LARGECAPACITY}
  DMBIN_LARGECAPACITY = 11;
  {$EXTERNALSYM DMBIN_CASSETTE}
  DMBIN_CASSETTE = 14;
  {$EXTERNALSYM DMBIN_FORMSOURCE}
  DMBIN_FORMSOURCE = 15;
  {$EXTERNALSYM DMBIN_LAST}
  DMBIN_LAST = DMBIN_FORMSOURCE;
  {$EXTERNALSYM DMBIN_USER}
  DMBIN_USER = $100;   { device specific bins start here }

  { print qualities }
  {$EXTERNALSYM DMRES_DRAFT}
  DMRES_DRAFT = LongWord(-1);
  {$EXTERNALSYM DMRES_LOW}
  DMRES_LOW = LongWord(-2);
  {$EXTERNALSYM DMRES_MEDIUM}
  DMRES_MEDIUM = LongWord(-3);
  {$EXTERNALSYM DMRES_HIGH}
  DMRES_HIGH = LongWord(-4);

  { color enabledisable for color printers }
  {$EXTERNALSYM DMCOLOR_MONOCHROME}
  DMCOLOR_MONOCHROME = 1;
  {$EXTERNALSYM DMCOLOR_COLOR}
  DMCOLOR_COLOR = 2;

  { duplex enable }
  {$EXTERNALSYM DMDUP_SIMPLEX}
  DMDUP_SIMPLEX = 1;
  {$EXTERNALSYM DMDUP_VERTICAL}
  DMDUP_VERTICAL = 2;
  {$EXTERNALSYM DMDUP_HORIZONTAL}
  DMDUP_HORIZONTAL = 3;

  { TrueType options }
  {$EXTERNALSYM DMTT_BITMAP}
  DMTT_BITMAP           = 1;     { print TT fonts as graphics  }
  {$EXTERNALSYM DMTT_DOWNLOAD}
  DMTT_DOWNLOAD         = 2;     { download TT fonts as soft fonts  }
  {$EXTERNALSYM DMTT_SUBDEV}
  DMTT_SUBDEV           = 3;     { substitute device fonts for TT fonts  }
  {$EXTERNALSYM DMTT_DOWNLOAD_OUTLINE}
  DMTT_DOWNLOAD_OUTLINE = 4;     { download TT fonts as outline soft fonts  }

  { Collation selections }
  {$EXTERNALSYM DMCOLLATE_FALSE}
  DMCOLLATE_FALSE = 0;
  {$EXTERNALSYM DMCOLLATE_TRUE}
  DMCOLLATE_TRUE = 1;

  { DEVMODE dmDisplayFlags flags }
  {$EXTERNALSYM DM_GRAYSCALE}
  DM_GRAYSCALE = $00000001;  { removed in 4.0 SDK }
  {$EXTERNALSYM DM_INTERLACED}
  DM_INTERLACED = $00000002; { removed in 4.0 SDK }
  {$EXTERNALSYM DM_TEXTMODE}
  DM_TEXTMODE = $00000004;   { removed in 4.0 SDK }
  {$EXTERNALSYM DMDISPLAYFLAGS_TEXTMODE}
  DMDISPLAYFLAGS_TEXTMODE     = $00000004;

  { ICM methods }
  {$EXTERNALSYM DMICMMETHOD_NONE}
  DMICMMETHOD_NONE   = 1;     { ICM disabled  }
  {$EXTERNALSYM DMICMMETHOD_SYSTEM}
  DMICMMETHOD_SYSTEM = 2;     { ICM handled by system  }
  {$EXTERNALSYM DMICMMETHOD_DRIVER}
  DMICMMETHOD_DRIVER = 3;     { ICM handled by driver  }
  {$EXTERNALSYM DMICMMETHOD_DEVICE}
  DMICMMETHOD_DEVICE = 4;     { ICM handled by device  }

  {$EXTERNALSYM DMICMMETHOD_USER}
  DMICMMETHOD_USER = $100;    { Device-specific methods start here  }

  { ICM Intents }
  {$EXTERNALSYM DMICM_SATURATE}
  DMICM_SATURATE    = 1;     { Maximize color saturation  }
  {$EXTERNALSYM DMICM_CONTRAST}
  DMICM_CONTRAST    = 2;     { Maximize color contrast  }
  {$EXTERNALSYM DMICM_COLORMETRIC}
  DMICM_COLORMETRIC = 3;     { Use specific color metric  }

  {$EXTERNALSYM DMICM_USER}
  DMICM_USER = $100;     { Device-specific intents start here  }


  { Media types }
  {$EXTERNALSYM DMMEDIA_STANDARD}
  DMMEDIA_STANDARD     = 1;     { Standard paper  }
  {$EXTERNALSYM DMMEDIA_TRANSPARENCY}
  DMMEDIA_TRANSPARENCY = 2;     { Transparency  }
  {$EXTERNALSYM DMMEDIA_GLOSSY}
  DMMEDIA_GLOSSY       = 3;     { Glossy paper  }

  {$EXTERNALSYM DMMEDIA_USER}
  DMMEDIA_USER = $100;     { Device-specific media start here  }


  { Dither types }
  {$EXTERNALSYM DMDITHER_NONE}
  DMDITHER_NONE      = 1;     { No dithering  }
  {$EXTERNALSYM DMDITHER_COARSE}
  DMDITHER_COARSE    = 2;     { Dither with a coarse brush  }
  {$EXTERNALSYM DMDITHER_FINE}
  DMDITHER_FINE      = 3;     { Dither with a fine brush  }
  {$EXTERNALSYM DMDITHER_LINEART}
  DMDITHER_LINEART   = 4;     { LineArt dithering  }
  {$EXTERNALSYM DMDITHER_ERRORDIFFUSION}
  DMDITHER_ERRORDIFFUSION = 5; { LineArt dithering }
  {$EXTERNALSYM DMDITHER_RESERVED6}
  DMDITHER_RESERVED6 = 6;      { LineArt dithering }
  {$EXTERNALSYM DMDITHER_RESERVED7}
  DMDITHER_RESERVED7 = 7;      { LineArt dithering }
  {$EXTERNALSYM DMDITHER_RESERVED8}
  DMDITHER_RESERVED8 = 8;      { LineArt dithering }
  {$EXTERNALSYM DMDITHER_RESERVED9}
  DMDITHER_RESERVED9 = 9;      { LineArt dithering }
  {$EXTERNALSYM DMDITHER_GRAYSCALE}
  DMDITHER_GRAYSCALE = 10;     { Device does grayscaling  }

  {$EXTERNALSYM DMDITHER_USER}
  DMDITHER_USER = 256;        { Device-specific dithers start here  }

type
  PDisplayDeviceA = ^TDisplayDeviceA;
  PDisplayDeviceW = ^TDisplayDeviceW;
  PDisplayDevice = PDisplayDeviceA;
  {$EXTERNALSYM _DISPLAY_DEVICEA}
  _DISPLAY_DEVICEA = packed record
    cb: DWORD;
    DeviceName: array[0..31] of AnsiChar;
    DeviceString: array[0..127] of AnsiChar;
    StateFlags: DWORD;
  end;
  {$EXTERNALSYM _DISPLAY_DEVICEW}
  _DISPLAY_DEVICEW = packed record
    cb: DWORD;
    DeviceName: array[0..31] of WideChar;
    DeviceString: array[0..127] of WideChar;
    StateFlags: DWORD;
  end;
  {$EXTERNALSYM _DISPLAY_DEVICE}
  _DISPLAY_DEVICE = _DISPLAY_DEVICEA;
  TDisplayDeviceA = _DISPLAY_DEVICEA;
  TDisplayDeviceW = _DISPLAY_DEVICEW;
  TDisplayDevice = TDisplayDeviceA;

const
  {$EXTERNALSYM DISPLAY_DEVICE_ATTACHED_TO_DESKTOP}
  DISPLAY_DEVICE_ATTACHED_TO_DESKTOP = $00000001;
  {$EXTERNALSYM DISPLAY_DEVICE_MULTI_DRIVER}
  DISPLAY_DEVICE_MULTI_DRIVER = $00000002;
  {$EXTERNALSYM DISPLAY_DEVICE_PRIMARY_DEVICE}
  DISPLAY_DEVICE_PRIMARY_DEVICE = $00000004;
  {$EXTERNALSYM DISPLAY_DEVICE_MIRRORING_DRIVER}
  DISPLAY_DEVICE_MIRRORING_DRIVER = $00000008;
  {$EXTERNALSYM DISPLAY_DEVICE_VGA_COMPATIBLE}
  DISPLAY_DEVICE_VGA_COMPATIBLE = $00000010;

{ GetRegionData / ExtCreateRegion }

  {$EXTERNALSYM RDH_RECTANGLES}
  RDH_RECTANGLES = 1;

type
  PRgnDataHeader = ^TRgnDataHeader;
  {$EXTERNALSYM _RGNDATAHEADER}
  _RGNDATAHEADER = packed record
    dwSize: DWORD;
    iType: DWORD;
    nCount: DWORD;
    nRgnSize: DWORD;
    rcBound: TRect;
  end;
  TRgnDataHeader = _RGNDATAHEADER;
  {$EXTERNALSYM RGNDATAHEADER}
  RGNDATAHEADER = _RGNDATAHEADER;

  PRgnData = ^TRgnData;
  {$EXTERNALSYM _RGNDATA}
  _RGNDATA = record
    rdh: TRgnDataHeader;
    Buffer: array[0..0] of CHAR;
    Reserved: array[0..2] of CHAR;
  end;
  TRgnData = _RGNDATA;
  {$EXTERNALSYM RGNDATA}
  RGNDATA = _RGNDATA;

  {$EXTERNALSYM PABC}
  PABC = ^TABC;
  {$EXTERNALSYM _ABC}
  _ABC = packed record
    abcA: Integer;
    abcB: UINT;
    abcC: Integer;
  end;
  TABC = _ABC;
  {$EXTERNALSYM ABC}
  ABC = _ABC;

  PABCFloat = ^TABCFloat;
  {$EXTERNALSYM _ABCFLOAT}
  _ABCFLOAT = packed record
    abcfA: Single;
    abcfB: Single;
    abcfC: Single;
  end;
  TABCFloat = _ABCFLOAT;
  {$EXTERNALSYM ABCFLOAT}
  ABCFLOAT = _ABCFLOAT;

  POutlineTextmetricA = ^TOutlineTextmetricA;
  POutlineTextmetricW = ^TOutlineTextmetricW;
  POutlineTextmetric = POutlineTextmetricA;
  {$EXTERNALSYM _OUTLINETEXTMETRICA}
  _OUTLINETEXTMETRICA = record
    otmSize: UINT;
    otmTextMetrics: TTextMetricA;
    otmFiller: Byte;
    otmPanoseNumber: TPanose;
    otmfsSelection: UINT;
    otmfsType: UINT;
    otmsCharSlopeRise: Integer;
    otmsCharSlopeRun: Integer;
    otmItalicAngle: Integer;
    otmEMSquare: UINT;
    otmAscent: Integer;
    otmDescent: Integer;
    otmLineGap: UINT;
    otmsCapEmHeight: UINT;
    otmsXHeight: UINT;
    otmrcFontBox: TRect;
    otmMacAscent: Integer;
    otmMacDescent: Integer;
    otmMacLineGap: UINT;
    otmusMinimumPPEM: UINT;
    otmptSubscriptSize: TPoint;
    otmptSubscriptOffset: TPoint;
    otmptSuperscriptSize: TPoint;
    otmptSuperscriptOffset: TPoint;
    otmsStrikeoutSize: UINT;
    otmsStrikeoutPosition: Integer;
    otmsUnderscoreSize: Integer;
    otmsUnderscorePosition: Integer;
    otmpFamilyName: PAnsiChar;
    otmpFaceName: PAnsiChar;
    otmpStyleName: PAnsiChar;
    otmpFullName: PAnsiChar;
  end;
  {$EXTERNALSYM _OUTLINETEXTMETRICW}
  _OUTLINETEXTMETRICW = record
    otmSize: UINT;
    otmTextMetrics: TTextMetricW;
    otmFiller: Byte;
    otmPanoseNumber: TPanose;
    otmfsSelection: UINT;
    otmfsType: UINT;
    otmsCharSlopeRise: Integer;
    otmsCharSlopeRun: Integer;
    otmItalicAngle: Integer;
    otmEMSquare: UINT;
    otmAscent: Integer;
    otmDescent: Integer;
    otmLineGap: UINT;
    otmsCapEmHeight: UINT;
    otmsXHeight: UINT;
    otmrcFontBox: TRect;
    otmMacAscent: Integer;
    otmMacDescent: Integer;
    otmMacLineGap: UINT;
    otmusMinimumPPEM: UINT;
    otmptSubscriptSize: TPoint;
    otmptSubscriptOffset: TPoint;
    otmptSuperscriptSize: TPoint;
    otmptSuperscriptOffset: TPoint;
    otmsStrikeoutSize: UINT;
    otmsStrikeoutPosition: Integer;
    otmsUnderscoreSize: Integer;
    otmsUnderscorePosition: Integer;
    otmpFamilyName: PWideChar;
    otmpFaceName: PWideChar;
    otmpStyleName: PWideChar;
    otmpFullName: PWideChar;
  end;
  {$EXTERNALSYM _OUTLINETEXTMETRIC}
  _OUTLINETEXTMETRIC = _OUTLINETEXTMETRICA;
  TOutlineTextmetricA = _OUTLINETEXTMETRICA;
  TOutlineTextmetricW = _OUTLINETEXTMETRICW;
  TOutlineTextmetric = TOutlineTextmetricA;
  {$EXTERNALSYM OUTLINETEXTMETRICA}
  OUTLINETEXTMETRICA = _OUTLINETEXTMETRICA;
  {$EXTERNALSYM OUTLINETEXTMETRICW}
  OUTLINETEXTMETRICW = _OUTLINETEXTMETRICW;
  {$EXTERNALSYM OUTLINETEXTMETRIC}
  OUTLINETEXTMETRIC = OUTLINETEXTMETRICA;

type
  PPolyTextA = ^TPolyTextA;
  PPolyTextW = ^TPolyTextW;
  PPolyText = PPolyTextA;
  {$EXTERNALSYM tagPOLYTEXTA}
  tagPOLYTEXTA = packed record
    x: Integer;
    y: Integer;
    n: UINT;
    PAnsiChar: PAnsiChar;
    uiFlags: UINT;
    rcl: TRect;
    pdx: PINT;
  end;
  {$EXTERNALSYM tagPOLYTEXTW}
  tagPOLYTEXTW = packed record
    x: Integer;
    y: Integer;
    n: UINT;
    PAnsiChar: PWideChar;
    uiFlags: UINT;
    rcl: TRect;
    pdx: PINT;
  end;
  {$EXTERNALSYM tagPOLYTEXT}
  tagPOLYTEXT = tagPOLYTEXTA;
  TPolyTextA = tagPOLYTEXTA;
  TPolyTextW = tagPOLYTEXTW;
  TPolyText = TPolyTextA;
  {$EXTERNALSYM POLYTEXTA}
  POLYTEXTA = tagPOLYTEXTA;
  {$EXTERNALSYM POLYTEXTW}
  POLYTEXTW = tagPOLYTEXTW;
  {$EXTERNALSYM POLYTEXT}
  POLYTEXT = POLYTEXTA;

  {$EXTERNALSYM _FIXED}
  _FIXED = packed record
    fract: Word;
    value: SHORT;
  end;
  TFixed = _FIXED;
  {$EXTERNALSYM FIXED}
  FIXED = _FIXED;

  PMat2 = ^TMat2;
  {$EXTERNALSYM _MAT2}
  _MAT2 = packed record
    eM11: TFixed;
    eM12: TFixed;
    eM21: TFixed;
    eM22: TFixed;
  end;
  TMat2 = _MAT2;
  {$EXTERNALSYM MAT2}
  MAT2 = _MAT2;

  PGlyphMetrics = ^TGlyphMetrics;
  {$EXTERNALSYM _GLYPHMETRICS}
  _GLYPHMETRICS = packed record
    gmBlackBoxX: UINT;
    gmBlackBoxY: UINT;
    gmptGlyphOrigin: TPoint;
    gmCellIncX: SHORT;
    gmCellIncY: SHORT;
  end;
  TGlyphMetrics = _GLYPHMETRICS;
  {$EXTERNALSYM GLYPHMETRICS}
  GLYPHMETRICS = _GLYPHMETRICS;

const
  { GetGlyphOutline constants }
  {$EXTERNALSYM GGO_METRICS}
  GGO_METRICS = 0;
  {$EXTERNALSYM GGO_BITMAP}
  GGO_BITMAP = 1;
  {$EXTERNALSYM GGO_NATIVE}
  GGO_NATIVE = 2;

  {$EXTERNALSYM GGO_GRAY2_BITMAP}
  GGO_GRAY2_BITMAP = 4;
  {$EXTERNALSYM GGO_GRAY4_BITMAP}
  GGO_GRAY4_BITMAP = 5;
  {$EXTERNALSYM GGO_GRAY8_BITMAP}
  GGO_GRAY8_BITMAP = 6;
  {$EXTERNALSYM GGO_GLYPH_INDEX}
  GGO_GLYPH_INDEX = $80;

  {$EXTERNALSYM TT_POLYGON_TYPE}
  TT_POLYGON_TYPE = 24;
  {$EXTERNALSYM TT_PRIM_LINE}
  TT_PRIM_LINE = 1;
  {$EXTERNALSYM TT_PRIM_QSPLINE}
  TT_PRIM_QSPLINE = 2;

type
  PPointfx = ^TPointfx;
  {$EXTERNALSYM tagPOINTFX}
  tagPOINTFX = packed record
    x: TFixed;
    y: TFixed;
  end;
  TPointfx = tagPOINTFX;
  {$EXTERNALSYM POINTFX}
  POINTFX = tagPOINTFX;

  PTTPolyCurve = ^TTTPolyCurve;
  {$EXTERNALSYM tagTTPOLYCURVE}
  tagTTPOLYCURVE = packed record
    wType: Word;
    cpfx: Word;
    apfx: array[0..0] of TPointFX;
  end;
  TTTPolyCurve = tagTTPOLYCURVE;
  {$EXTERNALSYM TTPOLYCURVE}
  TTPOLYCURVE = tagTTPOLYCURVE;

  PTTPolygonHeader = ^TTTPolygonHeader;
  {$EXTERNALSYM tagTTPOLYGONHEADER}
  tagTTPOLYGONHEADER = packed record
    cb: DWORD;
    dwType: DWORD;
    pfxStart: TPointFX;
  end;
  TTTPolygonHeader = tagTTPOLYGONHEADER;
  {$EXTERNALSYM TTPOLYGONHEADER}
  TTPOLYGONHEADER = tagTTPOLYGONHEADER;

const
  {$EXTERNALSYM GCP_DBCS}
  GCP_DBCS = 1;
  {$EXTERNALSYM GCP_REORDER}
  GCP_REORDER = 2;
  {$EXTERNALSYM GCP_USEKERNING}
  GCP_USEKERNING = 8;
  {$EXTERNALSYM GCP_GLYPHSHAPE}
  GCP_GLYPHSHAPE = $10;
  {$EXTERNALSYM GCP_LIGATE}
  GCP_LIGATE = 32;
  GCP_GLYPHINDEXING = $0080; // commented out in Windows Headers

  {$EXTERNALSYM GCP_DIACRITIC}
  GCP_DIACRITIC = $100;
  {$EXTERNALSYM GCP_KASHIDA}
  GCP_KASHIDA = $400;
  {$EXTERNALSYM GCP_ERROR}
  GCP_ERROR = $8000;
  {$EXTERNALSYM FLI_MASK}
  FLI_MASK = 4155;

  {$EXTERNALSYM GCP_JUSTIFY}
  GCP_JUSTIFY = $10000;
  GCP_NODIACRITICS = $00020000; // commented out in Windows Headers

  {$EXTERNALSYM FLI_GLYPHS}
  FLI_GLYPHS = $40000;
  {$EXTERNALSYM GCP_CLASSIN}
  GCP_CLASSIN = $80000;
  {$EXTERNALSYM GCP_MAXEXTENT}
  GCP_MAXEXTENT = $100000;
  {$EXTERNALSYM GCP_JUSTIFYIN}
  GCP_JUSTIFYIN = $200000;
  {$EXTERNALSYM GCP_DISPLAYZWG}
  GCP_DISPLAYZWG = $400000;
  {$EXTERNALSYM GCP_SYMSWAPOFF}
  GCP_SYMSWAPOFF = $800000;
  {$EXTERNALSYM GCP_NUMERICOVERRIDE}
  GCP_NUMERICOVERRIDE = $1000000;
  {$EXTERNALSYM GCP_NEUTRALOVERRIDE}
  GCP_NEUTRALOVERRIDE = $2000000;
  {$EXTERNALSYM GCP_NUMERICSLATIN}
  GCP_NUMERICSLATIN = $4000000;
  {$EXTERNALSYM GCP_NUMERICSLOCAL}
  GCP_NUMERICSLOCAL = $8000000;

  {$EXTERNALSYM GCPCLASS_LATIN}
  GCPCLASS_LATIN = 1;
  {$EXTERNALSYM GCPCLASS_HEBREW}
  GCPCLASS_HEBREW = 2;
  {$EXTERNALSYM GCPCLASS_ARABIC}
  GCPCLASS_ARABIC = 2;
  {$EXTERNALSYM GCPCLASS_NEUTRAL}
  GCPCLASS_NEUTRAL = 3;
  {$EXTERNALSYM GCPCLASS_LOCALNUMBER}
  GCPCLASS_LOCALNUMBER = 4;
  {$EXTERNALSYM GCPCLASS_LATINNUMBER}
  GCPCLASS_LATINNUMBER = 5;
  {$EXTERNALSYM GCPCLASS_LATINNUMERICTERMINATOR}
  GCPCLASS_LATINNUMERICTERMINATOR = 6;
  {$EXTERNALSYM GCPCLASS_LATINNUMERICSEPARATOR}
  GCPCLASS_LATINNUMERICSEPARATOR = 7;
  {$EXTERNALSYM GCPCLASS_NUMERICSEPARATOR}
  GCPCLASS_NUMERICSEPARATOR = 8;
  {$EXTERNALSYM GCPCLASS_PREBOUNDRTL}
  GCPCLASS_PREBOUNDRTL = $80;
  {$EXTERNALSYM GCPCLASS_PREBOUNDLTR}
  GCPCLASS_PREBOUNDLTR = $40;
  {$EXTERNALSYM GCPCLASS_POSTBOUNDLTR}
  GCPCLASS_POSTBOUNDLTR        = $20;
  {$EXTERNALSYM GCPCLASS_POSTBOUNDRTL}
  GCPCLASS_POSTBOUNDRTL        = $10;

  {$EXTERNALSYM GCPGLYPH_LINKBEFORE}
  GCPGLYPH_LINKBEFORE          = $8000;
  {$EXTERNALSYM GCPGLYPH_LINKAFTER}
  GCPGLYPH_LINKAFTER           = $4000;


type
  PGCPResultsA = ^TGCPResultsA;
  PGCPResultsW = ^TGCPResultsW;
  PGCPResults = PGCPResultsA;
  {$EXTERNALSYM tagGCP_RESULTSA}
  tagGCP_RESULTSA = packed record
    lStructSize: DWORD;
    lpOutString: PAnsiChar;
    lpOrder: PUINT;
    lpDx: PINT;
    lpCaretPos: PINT;
    lpClass: PAnsiChar;
    lpGlyphs: PUINT;
    nGlyphs: UINT;
    nMaxFit: Integer;
  end;
  {$EXTERNALSYM tagGCP_RESULTSW}
  tagGCP_RESULTSW = packed record
    lStructSize: DWORD;
    lpOutString: PWideChar;
    lpOrder: PUINT;
    lpDx: PINT;
    lpCaretPos: PINT;
    lpClass: PWideChar;
    lpGlyphs: PUINT;
    nGlyphs: UINT;
    nMaxFit: Integer;
  end;
  {$EXTERNALSYM tagGCP_RESULTS}
  tagGCP_RESULTS = tagGCP_RESULTSA;
  TGCPResultsA = tagGCP_RESULTSA;
  TGCPResultsW = tagGCP_RESULTSW;
  TGCPResults = TGCPResultsA;
  {$EXTERNALSYM GCP_RESULTSA}
  GCP_RESULTSA = tagGCP_RESULTSA;
  {$EXTERNALSYM GCP_RESULTSW}
  GCP_RESULTSW = tagGCP_RESULTSW;
  {$EXTERNALSYM GCP_RESULTS}
  GCP_RESULTS = GCP_RESULTSA;

  PRasterizerStatus = ^TRasterizerStatus;
  {$EXTERNALSYM _RASTERIZER_STATUS}
  _RASTERIZER_STATUS = packed record
    nSize: SHORT;
    wFlags: SHORT;
    nLanguageID: SHORT;
  end;
  TRasterizerStatus = _RASTERIZER_STATUS;
  {$EXTERNALSYM RASTERIZER_STATUS}
  RASTERIZER_STATUS = _RASTERIZER_STATUS;

const
  { bits defined in wFlags of RASTERIZER_STATUS }
  {$EXTERNALSYM TT_AVAILABLE}
  TT_AVAILABLE = 1;
  {$EXTERNALSYM TT_ENABLED}
  TT_ENABLED = 2;

type
  { Pixel format descriptor }
  PPixelFormatDescriptor = ^TPixelFormatDescriptor;
  {$EXTERNALSYM tagPIXELFORMATDESCRIPTOR}
  tagPIXELFORMATDESCRIPTOR = packed record
    nSize: Word;
    nVersion: Word;
    dwFlags: DWORD;
    iPixelType: Byte;
    cColorBits: Byte;
    cRedBits: Byte;
    cRedShift: Byte;
    cGreenBits: Byte;
    cGreenShift: Byte;
    cBlueBits: Byte;
    cBlueShift: Byte;
    cAlphaBits: Byte;
    cAlphaShift: Byte;
    cAccumBits: Byte;
    cAccumRedBits: Byte;
    cAccumGreenBits: Byte;
    cAccumBlueBits: Byte;
    cAccumAlphaBits: Byte;
    cDepthBits: Byte;
    cStencilBits: Byte;
    cAuxBuffers: Byte;
    iLayerType: Byte;
    bReserved: Byte;
    dwLayerMask: DWORD;
    dwVisibleMask: DWORD;
    dwDamageMask: DWORD;
  end;
  TPixelFormatDescriptor = tagPIXELFORMATDESCRIPTOR;
  {$EXTERNALSYM PIXELFORMATDESCRIPTOR}
  PIXELFORMATDESCRIPTOR = tagPIXELFORMATDESCRIPTOR;

const
  { pixel types }
  {$EXTERNALSYM PFD_TYPE_RGBA}
  PFD_TYPE_RGBA = 0;
  {$EXTERNALSYM PFD_TYPE_COLORINDEX}
  PFD_TYPE_COLORINDEX = 1;

  { layer types }
  {$EXTERNALSYM PFD_MAIN_PLANE}
  PFD_MAIN_PLANE = 0;
  {$EXTERNALSYM PFD_OVERLAY_PLANE}
  PFD_OVERLAY_PLANE = 1;
  {$EXTERNALSYM PFD_UNDERLAY_PLANE}
  PFD_UNDERLAY_PLANE = LongWord(-1);

  { TPixelFormatDescriptor flags }
  {$EXTERNALSYM PFD_DOUBLEBUFFER}
  PFD_DOUBLEBUFFER                = $00000001;
  {$EXTERNALSYM PFD_STEREO}
  PFD_STEREO                      = $00000002;
  {$EXTERNALSYM PFD_DRAW_TO_WINDOW}
  PFD_DRAW_TO_WINDOW              = $00000004;
  {$EXTERNALSYM PFD_DRAW_TO_BITMAP}
  PFD_DRAW_TO_BITMAP              = $00000008;
  {$EXTERNALSYM PFD_SUPPORT_GDI}
  PFD_SUPPORT_GDI                 = $00000010;
  {$EXTERNALSYM PFD_SUPPORT_OPENGL}
  PFD_SUPPORT_OPENGL              = $00000020;
  {$EXTERNALSYM PFD_GENERIC_FORMAT}
  PFD_GENERIC_FORMAT              = $00000040;
  {$EXTERNALSYM PFD_NEED_PALETTE}
  PFD_NEED_PALETTE                = $00000080;
  {$EXTERNALSYM PFD_NEED_SYSTEM_PALETTE}
  PFD_NEED_SYSTEM_PALETTE         = $00000100;
  {$EXTERNALSYM PFD_SWAP_EXCHANGE}
  PFD_SWAP_EXCHANGE               = $00000200;
  {$EXTERNALSYM PFD_SWAP_COPY}
  PFD_SWAP_COPY                   = $00000400;
  {$EXTERNALSYM PFD_SWAP_LAYER_BUFFERS}
  PFD_SWAP_LAYER_BUFFERS          = $00000800;
  {$EXTERNALSYM PFD_GENERIC_ACCELERATED}
  PFD_GENERIC_ACCELERATED         = $00001000;

  { TPixelFormatDescriptor flags for use in ChoosePixelFormat only }
  {$EXTERNALSYM PFD_DEPTH_DONTCARE}
  PFD_DEPTH_DONTCARE              = $20000000;
  {$EXTERNALSYM PFD_DOUBLEBUFFER_DONTCARE}
  PFD_DOUBLEBUFFER_DONTCARE       = $40000000;
  {$EXTERNALSYM PFD_STEREO_DONTCARE}
  PFD_STEREO_DONTCARE             = DWORD($80000000);

type












  TFNOldFontEnumProcA = TFarProc;
  TFNOldFontEnumProcW = TFarProc;
  TFNOldFontEnumProc = TFNOldFontEnumProcA;
  TFNGObjEnumProc = TFarProc;
  TFNLineDDAProc = TFarProc;
  TFNFontEnumProcA = TFarProc;
  TFNFontEnumProcW = TFarProc;
  TFNFontEnumProc = TFNFontEnumProcA;




{$EXTERNALSYM AddFontResource}
function AddFontResource(FileName: PChar): Integer; stdcall;
{$EXTERNALSYM AddFontResourceA}
function AddFontResourceA(FileName: PAnsiChar): Integer; stdcall;
{$EXTERNALSYM AddFontResourceW}
function AddFontResourceW(FileName: PWideChar): Integer; stdcall;
{$EXTERNALSYM AnimatePalette}
function AnimatePalette(PHandle: HPALETTE; StartIndex, Entries: UINT; Replacement: PPaletteEntry): BOOL; stdcall;
{$EXTERNALSYM Arc}
function Arc(hDC: HDC; left, top, right, bottom, startX, startY, endX, endY: Integer): BOOL; stdcall;
{$EXTERNALSYM BitBlt}
function BitBlt(DestDC: HDC; X, Y, Width, Height: Integer; SrcDC: HDC;
  XSrc, YSrc: Integer; Rop: DWORD): BOOL; stdcall;
{$EXTERNALSYM CancelDC}
function CancelDC(DC: HDC): BOOL; stdcall;
{$EXTERNALSYM Chord}
function Chord(DC: HDC; X1, Y1, X2, Y2, X3, Y3, X4, Y4: Integer): BOOL; stdcall;
{$EXTERNALSYM ChoosePixelFormat}
function ChoosePixelFormat(DC: HDC; p2: PPixelFormatDescriptor): Integer; stdcall;
{$EXTERNALSYM CloseMetaFile}
function CloseMetaFile(DC: HDC): HMETAFILE; stdcall;
{$EXTERNALSYM CombineRgn}
function CombineRgn(p1, p2, p3: HRGN; p4: Integer): Integer; stdcall;
{$EXTERNALSYM CopyMetaFile}
function CopyMetaFile(p1: HMETAFILE; p2: PChar): HMETAFILE; stdcall;
{$EXTERNALSYM CopyMetaFileA}
function CopyMetaFileA(p1: HMETAFILE; p2: PAnsiChar): HMETAFILE; stdcall;
{$EXTERNALSYM CopyMetaFileW}
function CopyMetaFileW(p1: HMETAFILE; p2: PWideChar): HMETAFILE; stdcall;
{$EXTERNALSYM CreateBitmap}
function CreateBitmap(Width, Height: Integer; Planes, BitCount: Longint;
  Bits: Pointer): HBITMAP; stdcall;
{$EXTERNALSYM CreateBitmapIndirect}
function CreateBitmapIndirect(const p1: TBitmap): HBITMAP; stdcall;
{$EXTERNALSYM CreateBrushIndirect}
function CreateBrushIndirect(const p1: TLogBrush): HBRUSH; stdcall;
{$EXTERNALSYM CreateCompatibleBitmap}
function CreateCompatibleBitmap(DC: HDC; Width, Height: Integer): HBITMAP; stdcall;
{$EXTERNALSYM CreateDiscardableBitmap}
function CreateDiscardableBitmap(DC: HDC; p2, p3: Integer): HBITMAP; stdcall;
{$EXTERNALSYM CreateCompatibleDC}
function CreateCompatibleDC(DC: HDC): HDC; stdcall;
{$EXTERNALSYM CreateDC}
function CreateDC(lpszDriver, lpszDevice, lpszOutput: PChar;
  lpdvmInit: PDeviceMode): HDC; stdcall;
{$EXTERNALSYM CreateDCA}
function CreateDCA(lpszDriver, lpszDevice, lpszOutput: PAnsiChar;
  lpdvmInit: PDeviceModeA): HDC; stdcall;
{$EXTERNALSYM CreateDCW}
function CreateDCW(lpszDriver, lpszDevice, lpszOutput: PWideChar;
  lpdvmInit: PDeviceModeW): HDC; stdcall;
{$EXTERNALSYM CreateDIBitmap}
function CreateDIBitmap(DC: HDC; var InfoHeader: TBitmapInfoHeader;
  dwUsage: DWORD; InitBits: PChar; var InitInfo: TBitmapInfo;
  wUsage: UINT): HBITMAP; stdcall;
{$EXTERNALSYM CreateDIBPatternBrush}
function CreateDIBPatternBrush(p1: HGLOBAL; p2: UINT): HBRUSH; stdcall;
{$EXTERNALSYM CreateDIBPatternBrushPt}
function CreateDIBPatternBrushPt(const p1: Pointer; p2: UINT): HBRUSH; stdcall;
{$EXTERNALSYM CreateEllipticRgn}
function CreateEllipticRgn(p1, p2, p3, p4: Integer): HRGN; stdcall;
{$EXTERNALSYM CreateEllipticRgnIndirect}
function CreateEllipticRgnIndirect(const p1: TRect): HRGN; stdcall;
{$EXTERNALSYM CreateFontIndirect}
function CreateFontIndirect(const p1: TLogFont): HFONT; stdcall;
{$EXTERNALSYM CreateFontIndirectA}
function CreateFontIndirectA(const p1: TLogFontA): HFONT; stdcall;
{$EXTERNALSYM CreateFontIndirectW}
function CreateFontIndirectW(const p1: TLogFontW): HFONT; stdcall;
{$EXTERNALSYM CreateFont}
function CreateFont(nHeight, nWidth, nEscapement, nOrientaion, fnWeight: Integer;
  fdwItalic, fdwUnderline, fdwStrikeOut, fdwCharSet, fdwOutputPrecision,
  fdwClipPrecision, fdwQuality, fdwPitchAndFamily: DWORD; lpszFace: PChar): HFONT; stdcall;
{$EXTERNALSYM CreateFontA}
function CreateFontA(nHeight, nWidth, nEscapement, nOrientaion, fnWeight: Integer;
  fdwItalic, fdwUnderline, fdwStrikeOut, fdwCharSet, fdwOutputPrecision,
  fdwClipPrecision, fdwQuality, fdwPitchAndFamily: DWORD; lpszFace: PAnsiChar): HFONT; stdcall;
{$EXTERNALSYM CreateFontW}
function CreateFontW(nHeight, nWidth, nEscapement, nOrientaion, fnWeight: Integer;
  fdwItalic, fdwUnderline, fdwStrikeOut, fdwCharSet, fdwOutputPrecision,
  fdwClipPrecision, fdwQuality, fdwPitchAndFamily: DWORD; lpszFace: PWideChar): HFONT; stdcall;
{$EXTERNALSYM CreateHatchBrush}
function CreateHatchBrush(p1: Integer; p2: COLORREF): HBRUSH; stdcall;
{$EXTERNALSYM CreateIC}
function CreateIC(lpszDriver, lpszDevice, lpszOutput: PChar; lpdvmInit: PDeviceMode): HDC; stdcall;
{$EXTERNALSYM CreateICA}
function CreateICA(lpszDriver, lpszDevice, lpszOutput: PAnsiChar; lpdvmInit: PDeviceModeA): HDC; stdcall;
{$EXTERNALSYM CreateICW}
function CreateICW(lpszDriver, lpszDevice, lpszOutput: PWideChar; lpdvmInit: PDeviceModeW): HDC; stdcall;
{$EXTERNALSYM CreateMetaFile}
function CreateMetaFile(p1: PChar): HDC; stdcall;
{$EXTERNALSYM CreateMetaFileA}
function CreateMetaFileA(p1: PAnsiChar): HDC; stdcall;
{$EXTERNALSYM CreateMetaFileW}
function CreateMetaFileW(p1: PWideChar): HDC; stdcall;
{$EXTERNALSYM CreatePalette}
function CreatePalette(const LogPalette: TLogPalette): HPalette; stdcall;
{$EXTERNALSYM CreatePen}
function CreatePen(Style, Width: Integer; Color: COLORREF): HPEN; stdcall;
{$EXTERNALSYM CreatePenIndirect}
function CreatePenIndirect(const LogPen: TLogPen): HPEN; stdcall;
{$EXTERNALSYM CreatePolyPolygonRgn}
function CreatePolyPolygonRgn(const pPtStructs; const pIntArray; p3, p4: Integer): HRGN; stdcall;
{$EXTERNALSYM CreatePatternBrush}
function CreatePatternBrush(Bitmap: HBITMAP): HBRUSH; stdcall;
{$EXTERNALSYM CreateRectRgn}
function CreateRectRgn(p1, p2, p3, p4: Integer): HRGN; stdcall;
{$EXTERNALSYM CreateRectRgnIndirect}
function CreateRectRgnIndirect(const p1: TRect): HRGN; stdcall;
{$EXTERNALSYM CreateRoundRectRgn}
function CreateRoundRectRgn(p1, p2, p3, p4, p5, p6: Integer): HRGN; stdcall;
{$EXTERNALSYM CreateScalableFontResource}
function CreateScalableFontResource(p1: DWORD; p2, p3, p4: PChar): BOOL; stdcall;
{$EXTERNALSYM CreateScalableFontResourceA}
function CreateScalableFontResourceA(p1: DWORD; p2, p3, p4: PAnsiChar): BOOL; stdcall;
{$EXTERNALSYM CreateScalableFontResourceW}
function CreateScalableFontResourceW(p1: DWORD; p2, p3, p4: PWideChar): BOOL; stdcall;
{$EXTERNALSYM CreateSolidBrush}
function CreateSolidBrush(p1: COLORREF): HBRUSH; stdcall;
{$EXTERNALSYM DeleteDC}
function DeleteDC(DC: HDC): BOOL; stdcall;
{$EXTERNALSYM DeleteMetaFile}
function DeleteMetaFile(p1: HMETAFILE): BOOL; stdcall;
{$EXTERNALSYM DeleteObject}
function DeleteObject(p1: HGDIOBJ): BOOL; stdcall;
{$EXTERNALSYM DescribePixelFormat}
function DescribePixelFormat(DC: HDC; p2: Integer; p3: UINT; var p4: TPixelFormatDescriptor): BOOL; stdcall;

{ define types of pointers to ExtDeviceMode() and DeviceCapabilities()
  functions for Win 3.1 compatibility }

type





  TFNDevMode = TFarProc;






  TFNDevCaps = TFarProc;


const
  { mode selections for the device mode function }
  {$EXTERNALSYM DM_UPDATE}
  DM_UPDATE = 1;
  {$EXTERNALSYM DM_COPY}
  DM_COPY = 2;
  {$EXTERNALSYM DM_PROMPT}
  DM_PROMPT = 4;
  {$EXTERNALSYM DM_MODIFY}
  DM_MODIFY = 8;

  {$EXTERNALSYM DM_IN_BUFFER}
  DM_IN_BUFFER = DM_MODIFY;
  {$EXTERNALSYM DM_IN_PROMPT}
  DM_IN_PROMPT = DM_PROMPT;
  {$EXTERNALSYM DM_OUT_BUFFER}
  DM_OUT_BUFFER = DM_COPY;
  {$EXTERNALSYM DM_OUT_DEFAULT}
  DM_OUT_DEFAULT = DM_UPDATE;

  { device capabilities indices }
  {$EXTERNALSYM DC_FIELDS}
  DC_FIELDS = 1;
  {$EXTERNALSYM DC_PAPERS}
  DC_PAPERS = 2;
  {$EXTERNALSYM DC_PAPERSIZE}
  DC_PAPERSIZE = 3;
  {$EXTERNALSYM DC_MINEXTENT}
  DC_MINEXTENT = 4;
  {$EXTERNALSYM DC_MAXEXTENT}
  DC_MAXEXTENT = 5;
  {$EXTERNALSYM DC_BINS}
  DC_BINS = 6;
  {$EXTERNALSYM DC_DUPLEX}
  DC_DUPLEX = 7;
  {$EXTERNALSYM DC_SIZE}
  DC_SIZE = 8;
  {$EXTERNALSYM DC_EXTRA}
  DC_EXTRA = 9;
  {$EXTERNALSYM DC_VERSION}
  DC_VERSION = 10;
  {$EXTERNALSYM DC_DRIVER}
  DC_DRIVER = 11;
  {$EXTERNALSYM DC_BINNAMES}
  DC_BINNAMES = 12;
  {$EXTERNALSYM DC_ENUMRESOLUTIONS}
  DC_ENUMRESOLUTIONS = 13;
  {$EXTERNALSYM DC_FILEDEPENDENCIES}
  DC_FILEDEPENDENCIES = 14;
  {$EXTERNALSYM DC_TRUETYPE}
  DC_TRUETYPE = 15;
  {$EXTERNALSYM DC_PAPERNAMES}
  DC_PAPERNAMES = 16;
  {$EXTERNALSYM DC_ORIENTATION}
  DC_ORIENTATION = 17;
  {$EXTERNALSYM DC_COPIES}
  DC_COPIES = 18;
  {$EXTERNALSYM DC_BINADJUST}
  DC_BINADJUST = 19;
  {$EXTERNALSYM DC_EMF_COMPLIANT}
  DC_EMF_COMPLIANT = 20;
  {$EXTERNALSYM DC_DATATYPE_PRODUCED}
  DC_DATATYPE_PRODUCED = 21;
  {$EXTERNALSYM DC_COLLATE}
  DC_COLLATE = 22;
  {$EXTERNALSYM DC_MANUFACTURER}
  DC_MANUFACTURER = 23;
  {$EXTERNALSYM DC_MODEL}
  DC_MODEL = 24;
  {$EXTERNALSYM DC_COLORDEVICE}
  DC_COLORDEVICE = 23;
  {$EXTERNALSYM DC_NUP}
  DC_NUP = 24;
  {$EXTERNALSYM DC_PERSONALITY}
  DC_PERSONALITY = 25;
  {$EXTERNALSYM DC_PRINTRATE}
  DC_PRINTRATE = 26;
  {$EXTERNALSYM DC_PRINTRATEUNIT}
  DC_PRINTRATEUNIT = 27;
  {$EXTERNALSYM PRINTRATEUNIT_PPM}
  PRINTRATEUNIT_PPM = 1;
  {$EXTERNALSYM PRINTRATEUNIT_CPS}
  PRINTRATEUNIT_CPS = 2;
  {$EXTERNALSYM PRINTRATEUNIT_LPM}
  PRINTRATEUNIT_LPM = 3;
  {$EXTERNALSYM PRINTRATEUNIT_IPM}
  PRINTRATEUNIT_IPM = 4;
  {$EXTERNALSYM DC_PRINTERMEM}
  DC_PRINTERMEM = 28;
  {$EXTERNALSYM DC_MEDIAREADY}
  DC_MEDIAREADY = 29;


  { bit fields of the return value (DWORD) for DC_TRUETYPE }
  {$EXTERNALSYM DCTT_BITMAP}
  DCTT_BITMAP = 1;
  {$EXTERNALSYM DCTT_DOWNLOAD}
  DCTT_DOWNLOAD = 2;
  {$EXTERNALSYM DCTT_SUBDEV}
  DCTT_SUBDEV = 4;
  {$EXTERNALSYM DCTT_DOWNLOAD_OUTLINE}
  DCTT_DOWNLOAD_OUTLINE = 8;


  { return values for DC_BINADJUST }
  {$EXTERNALSYM DCBA_FACEUPNONE}
  DCBA_FACEUPNONE = 0;
  {$EXTERNALSYM DCBA_FACEUPCENTER}
  DCBA_FACEUPCENTER = 1;
  {$EXTERNALSYM DCBA_FACEUPLEFT}
  DCBA_FACEUPLEFT = 2;
  {$EXTERNALSYM DCBA_FACEUPRIGHT}
  DCBA_FACEUPRIGHT = 3;
  {$EXTERNALSYM DCBA_FACEDOWNNONE}
  DCBA_FACEDOWNNONE = $100;
  {$EXTERNALSYM DCBA_FACEDOWNCENTER}
  DCBA_FACEDOWNCENTER = 257;
  {$EXTERNALSYM DCBA_FACEDOWNLEFT}
  DCBA_FACEDOWNLEFT = 258;
  {$EXTERNALSYM DCBA_FACEDOWNRIGHT}
  DCBA_FACEDOWNRIGHT = 259;


{$EXTERNALSYM DeviceCapabilities}
function DeviceCapabilities(pDriverName, pDeviceName, pPort: PChar;
  iIndex: Integer; pOutput: PChar; DevMode: PDeviceMode): Integer; stdcall;
{$EXTERNALSYM DeviceCapabilitiesA}
function DeviceCapabilitiesA(pDriverName, pDeviceName, pPort: PAnsiChar;
  iIndex: Integer; pOutput: PAnsiChar; DevMode: PDeviceModeA): Integer; stdcall;
{$EXTERNALSYM DeviceCapabilitiesW}
function DeviceCapabilitiesW(pDriverName, pDeviceName, pPort: PWideChar;
  iIndex: Integer; pOutput: PWideChar; DevMode: PDeviceModeW): Integer; stdcall;

{$EXTERNALSYM DrawEscape}
function DrawEscape(DC: HDC; p2, p3: Integer; p4: LPCSTR): BOOL; stdcall;
{$EXTERNALSYM Ellipse}
function Ellipse(DC: HDC; X1, Y1, X2, Y2: Integer): BOOL; stdcall;
{$EXTERNALSYM EnumFontFamiliesEx}
function EnumFontFamiliesEx(DC: HDC; var p2: TLogFont;
  p3: TFNFontEnumProc; p4: LPARAM; p5: DWORD): BOOL; stdcall;
{$EXTERNALSYM EnumFontFamiliesExA}
function EnumFontFamiliesExA(DC: HDC; var p2: TLogFontA;
  p3: TFNFontEnumProcA; p4: LPARAM; p5: DWORD): BOOL; stdcall;
{$EXTERNALSYM EnumFontFamiliesExW}
function EnumFontFamiliesExW(DC: HDC; var p2: TLogFontW;
  p3: TFNFontEnumProcW; p4: LPARAM; p5: DWORD): BOOL; stdcall;
{$EXTERNALSYM EnumFontFamilies}
function EnumFontFamilies(DC: HDC; p2: PChar; p3: TFNFontEnumProc; p4: LPARAM): BOOL; stdcall;
{$EXTERNALSYM EnumFontFamiliesA}
function EnumFontFamiliesA(DC: HDC; p2: PAnsiChar; p3: TFNFontEnumProcA; p4: LPARAM): BOOL; stdcall;
{$EXTERNALSYM EnumFontFamiliesW}
function EnumFontFamiliesW(DC: HDC; p2: PWideChar; p3: TFNFontEnumProcW; p4: LPARAM): BOOL; stdcall;
{$EXTERNALSYM EnumFonts}
function EnumFonts(DC: HDC; lpszFace: PChar; fntenmprc: TFNFontEnumProc;
  lpszData: PChar): Integer; stdcall;
{$EXTERNALSYM EnumFontsA}
function EnumFontsA(DC: HDC; lpszFace: PAnsiChar; fntenmprc: TFNFontEnumProcA;
  lpszData: PChar): Integer; stdcall;
{$EXTERNALSYM EnumFontsW}
function EnumFontsW(DC: HDC; lpszFace: PWideChar; fntenmprc: TFNFontEnumProcW;
  lpszData: PChar): Integer; stdcall;
{$EXTERNALSYM EnumObjects}
function EnumObjects(DC: HDC; p2: Integer; p3: TFNGObjEnumProc; p4: LPARAM): Integer; stdcall;
{$EXTERNALSYM EqualRgn}
function EqualRgn(p1, p2: HRGN): BOOL; stdcall;
{$EXTERNALSYM Escape}
function Escape(DC: HDC; p2, p3: Integer; p4: LPCSTR; p5: Pointer): Integer; stdcall;
{$EXTERNALSYM ExtEscape}
function ExtEscape(DC: HDC; p2, p3: Integer;
  const p4: LPCSTR; p5: Integer; p6: LPSTR): Integer; stdcall;
{$EXTERNALSYM ExcludeClipRect}
function ExcludeClipRect(DC: HDC; LeftRect, TopRect, RightRect, BottomRect: Integer): Integer; stdcall;
{$EXTERNALSYM ExtCreateRegion}
function ExtCreateRegion(XForm: PXForm; Count: DWORD; const RgnData: TRgnData): HRGN; stdcall;
{$EXTERNALSYM ExtFloodFill}
function ExtFloodFill(DC: HDC; X, Y: Integer; Color: COLORREF; FillType: UINT): BOOL; stdcall;
{$EXTERNALSYM FillRgn}
function FillRgn(DC: HDC; hrgn: HRGN; hbr: HBRUSH): BOOL; stdcall;
{$EXTERNALSYM FloodFill}
function FloodFill(DC: HDC; nXStart, nYStart: Integer; crFill: COLORREF): BOOL; stdcall;
{$EXTERNALSYM FrameRgn}
function FrameRgn(DC: HDC; hrgn: HRGN; hbr: HBRUSH; Width, Height: Integer): BOOL; stdcall;
{$EXTERNALSYM GetROP2}
function GetROP2(DC: HDC): Integer; stdcall;
{$EXTERNALSYM GetAspectRatioFilterEx}
function GetAspectRatioFilterEx(DC: HDC; var AspectRatio: TSize): BOOL; stdcall;
{$EXTERNALSYM GetBkColor}
function GetBkColor(hDC: HDC): COLORREF; stdcall;
{$EXTERNALSYM GetDCBrushColor}
function GetDCBrushColor(DC: HDC): COLORREF; stdcall;
{$EXTERNALSYM GetDCPenColor}
function GetDCPenColor(DC: HDC): COLORREF; stdcall;
{$EXTERNALSYM GetBkMode}
function GetBkMode(hDC: HDC): Integer; stdcall;
{$EXTERNALSYM GetBitmapBits}
function GetBitmapBits(Bitmap: HBITMAP; Count: Longint;
  Bits: Pointer): Longint; stdcall;
{$EXTERNALSYM GetBitmapDimensionEx}
function GetBitmapDimensionEx(Bitmap: HBITMAP; var Dimension: TSize): BOOL; stdcall;
{$EXTERNALSYM GetBoundsRect}
function GetBoundsRect(DC: HDC; var Bounds: TRect; Flags: UINT): UINT; stdcall;
{$EXTERNALSYM GetBrushOrgEx}
function GetBrushOrgEx(DC: HDC; var lppt: TPoint): BOOL; stdcall;
{$EXTERNALSYM GetCharWidth}
function GetCharWidth(DC: HDC; FirstChar, LastChar: UINT; const Widths): BOOL; stdcall;
{$EXTERNALSYM GetCharWidthA}
function GetCharWidthA(DC: HDC; FirstChar, LastChar: UINT; const Widths): BOOL; stdcall;
{$EXTERNALSYM GetCharWidthW}
function GetCharWidthW(DC: HDC; FirstChar, LastChar: UINT; const Widths): BOOL; stdcall;
{$EXTERNALSYM GetCharWidth32}
function GetCharWidth32(DC: HDC; FirstChar, LastChar: UINT; const Widths): BOOL; stdcall;
{$EXTERNALSYM GetCharWidth32A}
function GetCharWidth32A(DC: HDC; FirstChar, LastChar: UINT; const Widths): BOOL; stdcall;
{$EXTERNALSYM GetCharWidth32W}
function GetCharWidth32W(DC: HDC; FirstChar, LastChar: UINT; const Widths): BOOL; stdcall;
{$EXTERNALSYM GetCharWidthFloat}
function GetCharWidthFloat(DC: HDC; FirstChar, LastChar: UINT; const Widths): BOOL; stdcall;
{$EXTERNALSYM GetCharWidthFloatA}
function GetCharWidthFloatA(DC: HDC; FirstChar, LastChar: UINT; const Widths): BOOL; stdcall;
{$EXTERNALSYM GetCharWidthFloatW}
function GetCharWidthFloatW(DC: HDC; FirstChar, LastChar: UINT; const Widths): BOOL; stdcall;
{$EXTERNALSYM GetCharABCWidths}
function GetCharABCWidths(DC: HDC; FirstChar, LastChar: UINT; const ABCStructs): BOOL; stdcall;
{$EXTERNALSYM GetCharABCWidthsA}
function GetCharABCWidthsA(DC: HDC; FirstChar, LastChar: UINT; const ABCStructs): BOOL; stdcall;
{$EXTERNALSYM GetCharABCWidthsW}
function GetCharABCWidthsW(DC: HDC; FirstChar, LastChar: UINT; const ABCStructs): BOOL; stdcall;
{$EXTERNALSYM GetCharABCWidthsFloat}
function GetCharABCWidthsFloat(DC: HDC; FirstChar, LastChar: UINT; const ABCFloatSturcts): BOOL; stdcall;
{$EXTERNALSYM GetCharABCWidthsFloatA}
function GetCharABCWidthsFloatA(DC: HDC; FirstChar, LastChar: UINT; const ABCFloatSturcts): BOOL; stdcall;
{$EXTERNALSYM GetCharABCWidthsFloatW}
function GetCharABCWidthsFloatW(DC: HDC; FirstChar, LastChar: UINT; const ABCFloatSturcts): BOOL; stdcall;
{$EXTERNALSYM GetClipBox}
function GetClipBox(DC: HDC; var Rect: TRect): Integer; stdcall;
{$EXTERNALSYM GetClipRgn}
function GetClipRgn(DC: HDC; rgn: HRGN): Integer; stdcall;
{$EXTERNALSYM GetMetaRgn}
function GetMetaRgn(DC: HDC; rgn: HRGN): Integer; stdcall;
{$EXTERNALSYM GetCurrentObject}
function GetCurrentObject(DC: HDC; p2: UINT): HGDIOBJ; stdcall;
{$EXTERNALSYM GetCurrentPositionEx}
function GetCurrentPositionEx(DC: HDC; Point: PPoint): BOOL; stdcall;
{$EXTERNALSYM GetDeviceCaps}
function GetDeviceCaps(DC: HDC; Index: Integer): Integer; stdcall;
{$EXTERNALSYM GetDIBits}
function GetDIBits(DC: HDC; Bitmap: HBitmap; StartScan, NumScans: UINT;
  Bits: Pointer; var BitInfo: TBitmapInfo; Usage: UINT): Integer; stdcall;
{$EXTERNALSYM GetFontData}
function GetFontData(DC: HDC; p2, p3: DWORD; p4: Pointer; p5: DWORD): DWORD; stdcall;
{$EXTERNALSYM GetGlyphOutline}
function GetGlyphOutline(DC: HDC; uChar, uFormat: UINT;
  const lpgm: TGlyphMetrics; cbBuffer: DWORD; lpvBuffer: Pointer; const lpmat2: TMat2): DWORD; stdcall;
{$EXTERNALSYM GetGlyphOutlineA}
function GetGlyphOutlineA(DC: HDC; uChar, uFormat: UINT;
  const lpgm: TGlyphMetrics; cbBuffer: DWORD; lpvBuffer: Pointer; const lpmat2: TMat2): DWORD; stdcall;
{$EXTERNALSYM GetGlyphOutlineW}
function GetGlyphOutlineW(DC: HDC; uChar, uFormat: UINT;
  const lpgm: TGlyphMetrics; cbBuffer: DWORD; lpvBuffer: Pointer; const lpmat2: TMat2): DWORD; stdcall;
{$EXTERNALSYM GetGraphicsMode}
function GetGraphicsMode(DC: HDC): Integer; stdcall;
{$EXTERNALSYM GetMapMode}
function GetMapMode(DC: HDC): Integer; stdcall;
{$EXTERNALSYM GetMetaFileBitsEx}
function GetMetaFileBitsEx(p1: HMETAFILE; p2: UINT; p3: Pointer): UINT; stdcall;
{$EXTERNALSYM GetMetaFile}
function GetMetaFile(p1: PChar): HMETAFILE; stdcall;
{$EXTERNALSYM GetMetaFileA}
function GetMetaFileA(p1: PAnsiChar): HMETAFILE; stdcall;
{$EXTERNALSYM GetMetaFileW}
function GetMetaFileW(p1: PWideChar): HMETAFILE; stdcall;
{$EXTERNALSYM GetNearestColor}
function GetNearestColor(DC: HDC; p2: COLORREF): COLORREF; stdcall;
{$EXTERNALSYM GetNearestPaletteIndex}
function GetNearestPaletteIndex(p1: HPALETTE; p2: COLORREF): UINT; stdcall;
{$EXTERNALSYM GetObjectType}
function GetObjectType(h: HGDIOBJ): DWORD; stdcall;
{$EXTERNALSYM GetOutlineTextMetrics}
function GetOutlineTextMetrics(DC: HDC; p2: UINT; OTMetricStructs: Pointer): UINT; stdcall;
{$EXTERNALSYM GetOutlineTextMetricsA}
function GetOutlineTextMetricsA(DC: HDC; p2: UINT; OTMetricStructs: Pointer): UINT; stdcall;
{$EXTERNALSYM GetOutlineTextMetricsW}
function GetOutlineTextMetricsW(DC: HDC; p2: UINT; OTMetricStructs: Pointer): UINT; stdcall;
{$EXTERNALSYM GetPaletteEntries}
function GetPaletteEntries(Palette: HPALETTE; StartIndex, NumEntries: UINT;
  var PaletteEntries): UINT; stdcall;
{$EXTERNALSYM GetPixel}
function GetPixel(DC: HDC; X, Y: Integer): COLORREF; stdcall;
{$EXTERNALSYM GetPixelFormat}
function GetPixelFormat(DC: HDC): Integer; stdcall;
{$EXTERNALSYM GetPolyFillMode}
function GetPolyFillMode(DC: HDC): Integer; stdcall;
{$EXTERNALSYM GetRasterizerCaps}
function GetRasterizerCaps(var p1: TRasterizerStatus; p2: UINT): BOOL; stdcall;
{$EXTERNALSYM GetRegionData}
function GetRegionData(RGN: HRGN; p2: DWORD; p3: PRgnData): DWORD; stdcall;
{$EXTERNALSYM GetRgnBox}
function GetRgnBox(RGN: HRGN; var p2: TRect): Integer; stdcall;
{$EXTERNALSYM GetStockObject}
function GetStockObject(Index: Integer): HGDIOBJ; stdcall;
{$EXTERNALSYM GetStretchBltMode}
function GetStretchBltMode(DC: HDC): Integer; stdcall;
{$EXTERNALSYM GetSystemPaletteEntries}
function GetSystemPaletteEntries(DC: HDC; StartIndex, NumEntries: UINT;
  var PaletteEntries): UINT; stdcall;
{$EXTERNALSYM GetSystemPaletteUse}
function GetSystemPaletteUse(DC: HDC): UINT; stdcall;
{$EXTERNALSYM GetTextCharacterExtra}
function GetTextCharacterExtra(DC: HDC): Integer; stdcall;
{$EXTERNALSYM GetTextAlign}
function GetTextAlign(DC: HDC): UINT; stdcall;
{$EXTERNALSYM GetTextColor}
function GetTextColor(DC: HDC): COLORREF; stdcall;
{$EXTERNALSYM GetTextExtentPoint}
function GetTextExtentPoint(DC: HDC; Str: PChar; Count: Integer;
  var Size: TSize): BOOL; stdcall;
{$EXTERNALSYM GetTextExtentPointA}
function GetTextExtentPointA(DC: HDC; Str: PAnsiChar; Count: Integer;
  var Size: TSize): BOOL; stdcall;
{$EXTERNALSYM GetTextExtentPointW}
function GetTextExtentPointW(DC: HDC; Str: PWideChar; Count: Integer;
  var Size: TSize): BOOL; stdcall;
{$EXTERNALSYM GetTextExtentPoint32}
function GetTextExtentPoint32(DC: HDC; Str: PChar; Count: Integer;
  var Size: TSize): BOOL; stdcall;
{$EXTERNALSYM GetTextExtentPoint32A}
function GetTextExtentPoint32A(DC: HDC; Str: PAnsiChar; Count: Integer;
  var Size: TSize): BOOL; stdcall;
{$EXTERNALSYM GetTextExtentPoint32W}
function GetTextExtentPoint32W(DC: HDC; Str: PWideChar; Count: Integer;
  var Size: TSize): BOOL; stdcall;
{$EXTERNALSYM GetTextExtentExPoint}
function GetTextExtentExPoint(DC: HDC; p2: PChar;
  p3, p4: Integer; p5, p6: PInteger; var p7: TSize): BOOL; stdcall;
{$EXTERNALSYM GetTextExtentExPointA}
function GetTextExtentExPointA(DC: HDC; p2: PAnsiChar;
  p3, p4: Integer; p5, p6: PInteger; var p7: TSize): BOOL; stdcall;
{$EXTERNALSYM GetTextExtentExPointW}
function GetTextExtentExPointW(DC: HDC; p2: PWideChar;
  p3, p4: Integer; p5, p6: PInteger; var p7: TSize): BOOL; stdcall;
{$EXTERNALSYM GetTextCharset}
function GetTextCharset(hdc: HDC): Integer; stdcall;
{$EXTERNALSYM GetTextCharsetInfo}
function GetTextCharsetInfo(hdc: HDC; lpSig: PFontSignature; dwFlags: DWORD): BOOL; stdcall;
{$EXTERNALSYM TranslateCharsetInfo}
function TranslateCharsetInfo(var lpSrc: DWORD; var lpCs: TCharsetInfo; dwFlags: DWORD): BOOL; 
{$EXTERNALSYM GetFontLanguageInfo}
function GetFontLanguageInfo(DC: HDC): DWORD; stdcall;
{$EXTERNALSYM GetCharacterPlacement}
function GetCharacterPlacement(DC: HDC; p2: PChar; p3, p4: Integer;
  var p5: TGCPResults; p6: DWORD): DWORD; stdcall;
{$EXTERNALSYM GetCharacterPlacementA}
function GetCharacterPlacementA(DC: HDC; p2: PAnsiChar; p3, p4: Integer;
  var p5: TGCPResultsA; p6: DWORD): DWORD; stdcall;
{$EXTERNALSYM GetCharacterPlacementW}
function GetCharacterPlacementW(DC: HDC; p2: PWideChar; p3, p4: Integer;
  var p5: TGCPResultsW; p6: DWORD): DWORD; stdcall;

type
  PWCRange = ^TWCRange;
  {$EXTERNALSYM tagWCRANGE}
  tagWCRANGE = packed record
    wcLow: WCHAR;
    cGlyphs: SHORT;
  end;
  TWCRange = tagWCRANGE;

  PGlyphSet = ^TGlyphSet;
  {$EXTERNALSYM tagGLYPHSET}
  tagGLYPHSET = packed record
    cbThis: DWORD;
    flAccel: DWORD;
    cGlyphsSupported: DWORD;
    cRanges: DWORD;
    ranges: array[0..0] of TWCRange;
  end;
  TGlyphSet = tagGLYPHSET;

const
  { flAccel flags for the TGlyphSet structure above }
  {$EXTERNALSYM GS_8BIT_INDICES}
  GS_8BIT_INDICES = 1;
  { flags for GetGlyphIndices }
  {$EXTERNALSYM GGI_MARK_NONEXISTING_GLYPHS}
  GGI_MARK_NONEXISTING_GLYPHS = 1;

{$EXTERNALSYM GetFontUnicodeRanges}
function GetFontUnicodeRanges(DC: HDC; lpgs: PGlyphSet): DWORD; stdcall;
{$EXTERNALSYM GetGlyphIndices}
function GetGlyphIndices(DC: HDC; p2: PChar; p3: Integer; p4: PWORD; p5: DWORD): DWORD; stdcall;
{$EXTERNALSYM GetGlyphIndicesA}
function GetGlyphIndicesA(DC: HDC; p2: PAnsiChar; p3: Integer; p4: PWORD; p5: DWORD): DWORD; stdcall;
{$EXTERNALSYM GetGlyphIndicesW}
function GetGlyphIndicesW(DC: HDC; p2: PWideChar; p3: Integer; p4: PWORD; p5: DWORD): DWORD; stdcall;
{$EXTERNALSYM GetTextExtentPointI}
function GetTextExtentPointI(DC: HDC; p2: PWORD; p3: Integer; var p4: TSize): BOOL; stdcall;
{$EXTERNALSYM GetTextExtentExPointI}
function GetTextExtentExPointI(DC: HDC; p2: PWORD; p3, p4: Integer; p5, p6: PINT; var p7: TSize): BOOL; stdcall;
{$EXTERNALSYM GetCharWidthI}
function GetCharWidthI(DC: HDC; p2, p3: UINT; p4: PWORD; const Widths): BOOL; stdcall;
{$EXTERNALSYM GetCharABCWidthsI}
function GetCharABCWidthsI(DC: HDC; p2, p3: UINT; p4: PWORD; const Widths): BOOL; stdcall;

const
  {$EXTERNALSYM STAMP_DESIGNVECTOR}
  STAMP_DESIGNVECTOR = $80000000 + Ord('d') + (Ord('v') shl 8);
  {$EXTERNALSYM STAMP_AXESLIST}
  STAMP_AXESLIST = $80000000 + Ord('a') + (Ord('l') shl 8);
  {$EXTERNALSYM MM_MAX_NUMAXES}
  MM_MAX_NUMAXES = 16;

type
  PDesignVector = ^TDesignVector;
  {$EXTERNALSYM tagDESIGNVECTOR}
  tagDESIGNVECTOR = packed record
    dvReserved: DWORD;
    dvNumAxes: DWORD;
    dvValues: array[0..MM_MAX_NUMAXES-1] of Longint;
  end;
  TDesignVector = tagDESIGNVECTOR;

{$EXTERNALSYM AddFontResourceEx}
function AddFontResourceEx(p1: PChar; p2: DWORD; p3: PDesignVector): Integer; stdcall;
{$EXTERNALSYM AddFontResourceExA}
function AddFontResourceExA(p1: PAnsiChar; p2: DWORD; p3: PDesignVector): Integer; stdcall;
{$EXTERNALSYM AddFontResourceExW}
function AddFontResourceExW(p1: PWideChar; p2: DWORD; p3: PDesignVector): Integer; stdcall;
{$EXTERNALSYM RemoveFontResourceEx}
function RemoveFontResourceEx(p1: PChar; p2: DWORD; p3: PDesignVector): BOOL; stdcall;
{$EXTERNALSYM RemoveFontResourceExA}
function RemoveFontResourceExA(p1: PAnsiChar; p2: DWORD; p3: PDesignVector): BOOL; stdcall;
{$EXTERNALSYM RemoveFontResourceExW}
function RemoveFontResourceExW(p1: PWideChar; p2: DWORD; p3: PDesignVector): BOOL; stdcall;

{$EXTERNALSYM AddFontMemResourceEx}
function AddFontMemResourceEx(p1: Pointer; p2: DWORD; p3: PDesignVector; p4: LPDWORD): THandle; stdcall;
{$EXTERNALSYM RemoveFontMemResourceEx}
function RemoveFontMemResourceEx(p1: THandle): BOOL; stdcall;

const
  {$EXTERNALSYM FR_PRIVATE}
  FR_PRIVATE = $10;
  {$EXTERNALSYM FR_NOT_ENUM}
  FR_NOT_ENUM = $20;
  {$EXTERNALSYM MM_MAX_AXES_NAMELEN}
  MM_MAX_AXES_NAMELEN = 16;

type
  PAxisInfoA = ^TAxisInfoA;
  {$EXTERNALSYM tagAXISINFOA}
  tagAXISINFOA = packed record
    axMinValue: Longint;
    axMaxValue: Longint;
    axAxisName: array[0..MM_MAX_AXES_NAMELEN-1] of AnsiChar;
  end;
  TAxisInfoA = tagAXISINFOA;
  PAxisInfoW = ^TAxisInfoW;
  {$EXTERNALSYM tagAXISINFOW}
  tagAXISINFOW = packed record
    axMinValue: Longint;
    axMaxValue: Longint;
    axAxisName: array[0..MM_MAX_AXES_NAMELEN-1] of WideChar;
  end;
  TAxisInfoW = tagAXISINFOW;
  PAxisInfo = PAxisInfoA;

  PAxesListA = ^TAxesListA;
  {$EXTERNALSYM tagAXESLISTA}
  tagAXESLISTA = packed record
    axlReserved: DWORD;
    axlNumAxes: DWORD;
    axlAxisInfo: array[0..MM_MAX_NUMAXES-1] of TAxisInfoA;
  end;
  TAxesListA = tagAXESLISTA;
  PAxesListW = ^TAxesListW;
  {$EXTERNALSYM tagAXESLISTW}
  tagAXESLISTW = packed record
    axlReserved: DWORD;
    axlNumAxes: DWORD;
    axlAxisInfo: array[0..MM_MAX_NUMAXES-1] of TAxisInfoW;
  end;
  TAxesListW = tagAXESLISTW;
  PAxesList = PAxesListA;

  PEnumLogFontExDVA = ^TEnumLogFontExDVA;
  {$EXTERNALSYM tagENUMLOGFONTEXDVA}
  tagENUMLOGFONTEXDVA = packed record
    elfEnumLogfontEx: TEnumLogFontExA;
    elfDesignVector: TDesignVector;
  end;
  TEnumLogFontExDVA = tagENUMLOGFONTEXDVA;
  PEnumLogFontExDVW = ^TEnumLogFontExDVW;
  {$EXTERNALSYM tagENUMLOGFONTEXDVW}
  tagENUMLOGFONTEXDVW = packed record
    elfEnumLogfontEx: TEnumLogFontExW;
    elfDesignVector: TDesignVector;
  end;
  TEnumLogFontExDVW = tagENUMLOGFONTEXDVW;
  PEnumLogFontExDV = PEnumLogFontExDVA;

{$EXTERNALSYM CreateFontIndirectEx}
function CreateFontIndirectEx(const p1: PEnumLogFontExDV): HFONT; stdcall;
{$EXTERNALSYM CreateFontIndirectExA}
function CreateFontIndirectExA(const p1: PEnumLogFontExDVA): HFONT; stdcall;
{$EXTERNALSYM CreateFontIndirectExW}
function CreateFontIndirectExW(const p1: PEnumLogFontExDVW): HFONT; stdcall;

type
  PEnumTextMetricA = ^TEnumTextMetricA;
  {$EXTERNALSYM tagENUMTEXTMETRICA}
  tagENUMTEXTMETRICA = packed record
    etmNewTextMetricEx: TNewTextMetricExA;
    etmAxesList: TAxesListA;
  end;
  TEnumTextMetricA = tagENUMTEXTMETRICA;
  PEnumTextMetricW = ^TEnumTextMetricW;
  {$EXTERNALSYM tagENUMTEXTMETRICW}
  tagENUMTEXTMETRICW = packed record
    etmNewTextMetricEx: TNewTextMetricExW;
    etmAxesList: TAxesListW;
  end;
  TEnumTextMetricW = tagENUMTEXTMETRICW;
  PEnumTextMetric = PEnumTextMetricA;

{$EXTERNALSYM GetViewportExtEx}
function GetViewportExtEx(DC: HDC; var Size: TSize): BOOL; stdcall;
{$EXTERNALSYM GetViewportOrgEx}
function GetViewportOrgEx(DC: HDC; var Point: TPoint): BOOL; stdcall;
{$EXTERNALSYM GetWindowExtEx}
function GetWindowExtEx(DC: HDC; var Size: TSize): BOOL; stdcall;
{$EXTERNALSYM GetWindowOrgEx}
function GetWindowOrgEx(DC: HDC; var Point: TPoint): BOOL; stdcall;
{$EXTERNALSYM IntersectClipRect}
function IntersectClipRect(DC: HDC; X1, Y1, X2, Y2: Integer): Integer; stdcall;
{$EXTERNALSYM InvertRgn}
function InvertRgn(DC: HDC; p2: HRGN): BOOL; stdcall;
{$EXTERNALSYM LineDDA}
function LineDDA(XStart, YStart, XEnd, YEnd: Integer; LineFunc: TFNLineDDAProc; Data: LPARAM): BOOL; stdcall;
{$EXTERNALSYM LineTo}
function LineTo(DC: HDC; X, Y: Integer): BOOL; stdcall;
{$EXTERNALSYM MaskBlt}
function MaskBlt(DestDC: HDC; XDest, YDest, Width, Height: Integer; SrcDC: HDC;
  XScr, YScr: Integer; Mask: HBITMAP; xMask, yMask: Integer; Rop: DWORD): BOOL; stdcall;
{$EXTERNALSYM PlgBlt}
function PlgBlt(DestDC: HDC; const PointsArray; SrcDC: HDC;
  XSrc, YSrc, Width, Height: Integer; Mask: HBITMAP; xMask, yMask: Integer): BOOL; stdcall;
{$EXTERNALSYM OffsetClipRgn}
function OffsetClipRgn(DC: HDC; XOffset, YOffset: Integer): Integer; stdcall;
{$EXTERNALSYM OffsetRgn}
function OffsetRgn(RGN: HRGN; XOffset, YOffset: Integer): Integer; stdcall;
{$EXTERNALSYM PatBlt}
function PatBlt(DC: HDC; X, Y, Width, Height: Integer; Rop: DWORD): BOOL; stdcall;
{$EXTERNALSYM Pie}
function Pie(DC: HDC; X1, Y1, X2, Y2, X3, Y3, X4, Y4: Integer): BOOL; stdcall;
{$EXTERNALSYM PlayMetaFile}
function PlayMetaFile(DC: HDC; MF: HMETAFILE): BOOL; stdcall;
{$EXTERNALSYM PaintRgn}
function PaintRgn(DC: HDC; RGN: HRGN): BOOL; stdcall;
{$EXTERNALSYM PolyPolygon}
function PolyPolygon(DC: HDC; var Points; var nPoints; p4: Integer): BOOL; stdcall;
{$EXTERNALSYM PtInRegion}
function PtInRegion(RGN: HRGN; X, Y: Integer): BOOL; stdcall;
{$EXTERNALSYM PtVisible}
function PtVisible(DC: HDC; X, Y: Integer): BOOL; stdcall;
{$EXTERNALSYM RectInRegion}
function RectInRegion(RGN: HRGN; const Rect: TRect): BOOL; stdcall;
{$EXTERNALSYM RectVisible}
function RectVisible(DC: HDC; const Rect: TRect): BOOL; stdcall;
{$EXTERNALSYM Rectangle}
function Rectangle(DC: HDC; X1, Y1, X2, Y2: Integer): BOOL; stdcall;
{$EXTERNALSYM RestoreDC}
function RestoreDC(DC: HDC; SavedDC: Integer): BOOL; stdcall;
{$EXTERNALSYM ResetDC}
function ResetDC(DC: HDC; const InitData: TDeviceMode): HDC; stdcall;
{$EXTERNALSYM ResetDCA}
function ResetDCA(DC: HDC; const InitData: TDeviceModeA): HDC; stdcall;
{$EXTERNALSYM ResetDCW}
function ResetDCW(DC: HDC; const InitData: TDeviceModeW): HDC; stdcall;
{$EXTERNALSYM RealizePalette}
function RealizePalette(DC: HDC): UINT; stdcall;
{$EXTERNALSYM RemoveFontResource}
function RemoveFontResource(FileName: PChar): BOOL; stdcall;
{$EXTERNALSYM RemoveFontResourceA}
function RemoveFontResourceA(FileName: PAnsiChar): BOOL; stdcall;
{$EXTERNALSYM RemoveFontResourceW}
function RemoveFontResourceW(FileName: PWideChar): BOOL; stdcall;
{$EXTERNALSYM RoundRect}
function RoundRect(DC: HDC; X1, Y1, X2, Y2, X3, Y3: Integer): BOOL; stdcall;
{$EXTERNALSYM ResizePalette}
function ResizePalette(Palette: HPALETTE; Entries: UINT): BOOL; stdcall;
{$EXTERNALSYM SaveDC}
function SaveDC(DC: HDC): Integer; stdcall;
{$EXTERNALSYM SelectClipRgn}
function SelectClipRgn(DC: HDC; Region: HRGN): Integer; stdcall;
{$EXTERNALSYM ExtSelectClipRgn}
function ExtSelectClipRgn(DC: HDC; Region: HRGN; Mode: Integer): Integer; stdcall;
{$EXTERNALSYM SetMetaRgn}
function SetMetaRgn(DC: HDC): Integer; stdcall;
{$EXTERNALSYM SelectObject}
function SelectObject(DC: HDC; p2: HGDIOBJ): HGDIOBJ; stdcall;
{$EXTERNALSYM SelectPalette}
function SelectPalette(DC: HDC; Palette: HPALETTE;
  ForceBackground: Bool): HPALETTE; stdcall;
{$EXTERNALSYM SetBkColor}
function SetBkColor(DC: HDC; Color: COLORREF): COLORREF; stdcall;
{$EXTERNALSYM SetDCBrushColor}
function SetDCBrushColor(DC: HDC; Color: COLORREF): COLORREF; stdcall;
{$EXTERNALSYM SetDCPenColor}
function SetDCPenColor(DC: HDC; Color: COLORREF): COLORREF; stdcall;
{$EXTERNALSYM SetBkMode}
function SetBkMode(DC: HDC; BkMode: Integer): Integer; stdcall;
{$EXTERNALSYM SetBitmapBits}
function SetBitmapBits(p1: HBITMAP; p2: DWORD; bits: Pointer): Longint; stdcall;
{$EXTERNALSYM SetBoundsRect}
function SetBoundsRect(DC: HDC; p2: PRect; p3: UINT): UINT; stdcall;
{$EXTERNALSYM SetDIBits}
function SetDIBits(DC: HDC; Bitmap: HBITMAP; StartScan, NumScans: UINT;
  Bits: Pointer; var BitsInfo: TBitmapInfo; Usage: UINT): Integer; stdcall;
{$EXTERNALSYM SetDIBitsToDevice}
function SetDIBitsToDevice(DC: HDC; DestX, DestY: Integer; Width, Height: DWORD;
  SrcX, SrcY: Integer; nStartScan, NumScans: UINT; Bits: Pointer;
  var BitsInfo: TBitmapInfo; Usage: UINT): Integer; stdcall;
{$EXTERNALSYM SetMapperFlags}
function SetMapperFlags(DC: HDC; Flag: DWORD): DWORD; stdcall;
{$EXTERNALSYM SetGraphicsMode}
function SetGraphicsMode(hdc: HDC; iMode: Integer): Integer; stdcall;
{$EXTERNALSYM SetMapMode}
function SetMapMode(DC: HDC; p2: Integer): Integer; stdcall;
{$EXTERNALSYM SetMetaFileBitsEx}
function SetMetaFileBitsEx(Size: UINT; const Data: PChar): HMETAFILE; stdcall;
{$EXTERNALSYM SetPaletteEntries}
function SetPaletteEntries(Palette: HPALETTE; StartIndex, NumEntries: UINT;
  var PaletteEntries): UINT; stdcall;
{$EXTERNALSYM SetPixel}
function SetPixel(DC: HDC; X, Y: Integer; Color: COLORREF): COLORREF; stdcall;
{$EXTERNALSYM SetPixelV}
function SetPixelV(DC: HDC; X, Y: Integer; Color: COLORREF): BOOL; stdcall;
{$EXTERNALSYM SetPixelFormat}
function SetPixelFormat(DC: HDC; PixelFormat: Integer; FormatDef: PPixelFormatDescriptor): BOOL; stdcall;
{$EXTERNALSYM SetPolyFillMode}
function SetPolyFillMode(DC: HDC; PolyFillMode: Integer): Integer; stdcall;
{$EXTERNALSYM StretchBlt}
function StretchBlt(DestDC: HDC; X, Y, Width, Height: Integer; SrcDC: HDC;
  XSrc, YSrc, SrcWidth, SrcHeight: Integer; Rop: DWORD): BOOL; stdcall;
{$EXTERNALSYM SetRectRgn}
function SetRectRgn(Rgn: HRgn; X1, Y1, X2, Y2: Integer): BOOL; stdcall;
function StretchDIBits(DC: HDC; DestX, DestY, DestWidth, DestHeight, SrcX,
  SrcY, SrcWidth, SrcHeight: Integer; Bits: Pointer; var BitsInfo: TBitmapInfo;
  Usage: UINT; Rop: DWORD): Integer; stdcall;
{$EXTERNALSYM StretchDIBits}
{$EXTERNALSYM SetROP2}
function SetROP2(DC: HDC; p2: Integer): Integer; stdcall;
{$EXTERNALSYM SetStretchBltMode}
function SetStretchBltMode(DC: HDC; StretchMode: Integer): Integer; stdcall;
{$EXTERNALSYM SetSystemPaletteUse}
function SetSystemPaletteUse(DC: HDC; p2: UINT): UINT; stdcall;
{$EXTERNALSYM SetTextCharacterExtra}
function SetTextCharacterExtra(DC: HDC; CharExtra: Integer): Integer; stdcall;
{$EXTERNALSYM SetTextColor}
function SetTextColor(DC: HDC; Color: COLORREF): COLORREF; stdcall;
{$EXTERNALSYM SetTextAlign}
function SetTextAlign(DC: HDC; Flags: UINT): UINT; stdcall;
{$EXTERNALSYM SetTextJustification}
function SetTextJustification(DC: HDC; BreakExtra, BreakCount: Integer): Integer; stdcall;
{$EXTERNALSYM UpdateColors}
function UpdateColors(DC: HDC): BOOL; stdcall;

type
  {$EXTERNALSYM COLOR16}
  COLOR16 = Word;

  PTriVertex = ^TTriVertex;
  {$EXTERNALSYM _TRIVERTEX}
  _TRIVERTEX = packed record
    x: Longint;
    y: Longint;
    Red: COLOR16;
    Green: COLOR16;
    Blue: COLOR16;
    Alpha: COLOR16;
  end;
  TTriVertex = _TRIVERTEX;
  {$EXTERNALSYM TRIVERTEX}
  TRIVERTEX = _TRIVERTEX;

  PGradientTriangle = ^TGradientTriangle;
  {$EXTERNALSYM _GRADIENT_TRIANGLE}
  _GRADIENT_TRIANGLE = packed record
    Vertex1: ULONG;
    Vertex2: ULONG;
    Vertex3: ULONG;
  end;
  TGradientTriangle = _GRADIENT_TRIANGLE;
  {$EXTERNALSYM GRADIENT_TRIANGLE}
  GRADIENT_TRIANGLE = _GRADIENT_TRIANGLE;

  PGradientRect = ^TGradientRect;
  {$EXTERNALSYM _GRADIENT_RECT}
  _GRADIENT_RECT = packed record
    UpperLeft: ULONG;
    LowerRight: ULONG;
  end;
  TGradientRect = _GRADIENT_RECT;
  {$EXTERNALSYM GRADIENT_RECT}
  GRADIENT_RECT = _GRADIENT_RECT;

  PBlendFunction = ^TBlendFunction;
  {$EXTERNALSYM _BLENDFUNCTION}
  _BLENDFUNCTION = packed record
    BlendOp: BYTE;
    BlendFlags: BYTE;
    SourceConstantAlpha: BYTE;
    AlphaFormat: BYTE;
  end;
  TBlendFunction = _BLENDFUNCTION;
  {$EXTERNALSYM BLENDFUNCTION}
  BLENDFUNCTION = _BLENDFUNCTION;

const
  { currentlly defined blend function }
  {$EXTERNALSYM AC_SRC_OVER}
  AC_SRC_OVER = $00;
  {$EXTERNALSYM AC_SRC_ALPHA}
  AC_SRC_ALPHA = $01;

  { alpha format flags }
  {$EXTERNALSYM AC_SRC_NO_PREMULT_ALPHA}
  AC_SRC_NO_PREMULT_ALPHA = $01;
  {$EXTERNALSYM AC_SRC_NO_ALPHA}
  AC_SRC_NO_ALPHA = $02;
  {$EXTERNALSYM AC_DST_NO_PREMULT_ALPHA}
  AC_DST_NO_PREMULT_ALPHA = $10;
  {$EXTERNALSYM AC_DST_NO_ALPHA}
  AC_DST_NO_ALPHA = $20;

{$EXTERNALSYM AlphaBlend}
function AlphaBlend(DC: HDC; p2, p3, p4, p5: Integer; DC6: HDC; p7, p8, p9, p10: Integer; p11: TBlendFunction): BOOL; stdcall;
{$EXTERNALSYM AlphaDIBBlend}
function AlphaDIBBlend(DC: HDC; p2, p3, p4, p5: Integer; const p6: Pointer;
        const p7: PBitmapInfo; p8: UINT; p9, p10, p11, p12: Integer; p13: TBlendFunction): BOOL; stdcall;
{$EXTERNALSYM TransparentBlt}
function TransparentBlt(DC: HDC; p2, p3, p4, p5: Integer; DC6: HDC; p7, p8, p9, p10: Integer; p11: UINT): BOOL; stdcall;
{$EXTERNALSYM TransparentDIBits}
function TransparentDIBits(DC: HDC; p2, p3, p4, p5: Integer; const p6: Pointer;
        const p7: PBitmapInfo; p8: UINT; p9, p10, p11, p12: Integer; p13: UINT): BOOL; stdcall;

const
  { gradient drawing modes }
  {$EXTERNALSYM GRADIENT_FILL_RECT_H}
  GRADIENT_FILL_RECT_H = $00000000;
  {$EXTERNALSYM GRADIENT_FILL_RECT_V}
  GRADIENT_FILL_RECT_V = $00000001;
  {$EXTERNALSYM GRADIENT_FILL_TRIANGLE}
   GRADIENT_FILL_TRIANGLE = $00000002;
  {$EXTERNALSYM GRADIENT_FILL_OP_FLAG}
  GRADIENT_FILL_OP_FLAG = $000000ff;

{$EXTERNALSYM GradientFill}
function GradientFill(DC: HDC; Vertex: PTriVertex; NumVertex: ULONG; Mesh: Pointer; NumMesh, Mode: ULONG): BOOL; stdcall;

{$EXTERNALSYM PlayMetaFileRecord}
function PlayMetaFileRecord(DC: HDC; const p2: THandleTable; const p3: TMetaRecord; p4: UINT): BOOL; stdcall;

type






  TFNMFEnumProc = TFarProc;
  TFNEnhMFEnumProc = TFarProc;


{$EXTERNALSYM EnumMetaFile}
function EnumMetaFile(DC: HDC; Handle: HMETAFILE; MetaFunc: TFNMFEnumProc; lParam: LPARAM): BOOL; stdcall;

{ Enhanced Metafile Function Declarations }

{$EXTERNALSYM CloseEnhMetaFile}
function CloseEnhMetaFile(DC: HDC): HENHMETAFILE; stdcall;
{$EXTERNALSYM CopyEnhMetaFile}
function CopyEnhMetaFile(p1: HENHMETAFILE; p2: PChar): HENHMETAFILE; stdcall;
{$EXTERNALSYM CopyEnhMetaFileA}
function CopyEnhMetaFileA(p1: HENHMETAFILE; p2: PAnsiChar): HENHMETAFILE; stdcall;
{$EXTERNALSYM CopyEnhMetaFileW}
function CopyEnhMetaFileW(p1: HENHMETAFILE; p2: PWideChar): HENHMETAFILE; stdcall;
{$EXTERNALSYM CreateEnhMetaFile}
function CreateEnhMetaFile(DC: HDC; FileName: PChar; Rect: PRect; Desc: PChar): HDC; stdcall;
{$EXTERNALSYM CreateEnhMetaFileA}
function CreateEnhMetaFileA(DC: HDC; FileName: PAnsiChar; Rect: PRect; Desc: PAnsiChar): HDC; stdcall;
{$EXTERNALSYM CreateEnhMetaFileW}
function CreateEnhMetaFileW(DC: HDC; FileName: PWideChar; Rect: PRect; Desc: PWideChar): HDC; stdcall;
{$EXTERNALSYM DeleteEnhMetaFile}
function DeleteEnhMetaFile(p1: HENHMETAFILE): BOOL; stdcall;
{$EXTERNALSYM EnumEnhMetaFile}
function EnumEnhMetaFile(DC: HDC; Emf: HENHMETAFILE; EnhMetaFunc: TFNEnhMFEnumProc; Data: Pointer; const Rect: TRect): BOOL; stdcall;
{$EXTERNALSYM GetEnhMetaFile}
function GetEnhMetaFile(p1: PChar): HENHMETAFILE; stdcall;
{$EXTERNALSYM GetEnhMetaFileA}
function GetEnhMetaFileA(p1: PAnsiChar): HENHMETAFILE; stdcall;
{$EXTERNALSYM GetEnhMetaFileW}
function GetEnhMetaFileW(p1: PWideChar): HENHMETAFILE; stdcall;
{$EXTERNALSYM GetEnhMetaFileBits}
function GetEnhMetaFileBits(p1: HENHMETAFILE; p2: UINT; p3: PByte): UINT; stdcall;
{$EXTERNALSYM GetEnhMetaFileDescription}
function GetEnhMetaFileDescription(p1: HENHMETAFILE; p2: UINT; p3: PChar): UINT; stdcall;
{$EXTERNALSYM GetEnhMetaFileDescriptionA}
function GetEnhMetaFileDescriptionA(p1: HENHMETAFILE; p2: UINT; p3: PAnsiChar): UINT; stdcall;
{$EXTERNALSYM GetEnhMetaFileDescriptionW}
function GetEnhMetaFileDescriptionW(p1: HENHMETAFILE; p2: UINT; p3: PWideChar): UINT; stdcall;
{$EXTERNALSYM GetEnhMetaFileHeader}
function GetEnhMetaFileHeader(p1: HENHMETAFILE; p2: UINT; p3: PEnhMetaHeader): UINT; stdcall;
{$EXTERNALSYM GetEnhMetaFilePaletteEntries}
function GetEnhMetaFilePaletteEntries(p1: HENHMETAFILE; p2: UINT; p3: Pointer): UINT; stdcall;
{$EXTERNALSYM GetEnhMetaFilePixelFormat}
function GetEnhMetaFilePixelFormat(p1: HENHMETAFILE; p2: Cardinal;
  var p3: TPixelFormatDescriptor): UINT; stdcall;
{$EXTERNALSYM GetWinMetaFileBits}
function GetWinMetaFileBits(p1: HENHMETAFILE; p2: UINT; p3: PByte;
  p4: Integer; p5: HDC): UINT; stdcall;
{$EXTERNALSYM PlayEnhMetaFile}
function PlayEnhMetaFile(DC: HDC; p2: HENHMETAFILE; const p3: TRect): BOOL; stdcall;
{$EXTERNALSYM PlayEnhMetaFileRecord}
function PlayEnhMetaFileRecord(DC: HDC; var p2: THandleTable;
  const p3: TEnhMetaRecord; p4: UINT): BOOL; stdcall;
{$EXTERNALSYM SetEnhMetaFileBits}
function SetEnhMetaFileBits(p1: UINT; p2: PChar): HENHMETAFILE; stdcall;
{$EXTERNALSYM SetWinMetaFileBits}
function SetWinMetaFileBits(p1: UINT; p2: PChar; p3: HDC;
  const p4: TMetaFilePict): HENHMETAFILE; stdcall;
{$EXTERNALSYM GdiComment}
function GdiComment(DC: HDC; p2: UINT; p3: PChar): BOOL; stdcall;
{$EXTERNALSYM GetTextMetrics}
function GetTextMetrics(DC: HDC; var TM: TTextMetric): BOOL; stdcall;
{$EXTERNALSYM GetTextMetricsA}
function GetTextMetricsA(DC: HDC; var TM: TTextMetricA): BOOL; stdcall;
{$EXTERNALSYM GetTextMetricsW}
function GetTextMetricsW(DC: HDC; var TM: TTextMetricW): BOOL; stdcall;

{ new GDI }

type
  PDIBSection = ^TDIBSection;
  {$EXTERNALSYM tagDIBSECTION}
  tagDIBSECTION = packed record
    dsBm: TBitmap;
    dsBmih: TBitmapInfoHeader;
    dsBitfields: array[0..2] of DWORD;
    dshSection: THandle;
    dsOffset: DWORD;
  end;
  TDIBSection = tagDIBSECTION;
  {$EXTERNALSYM DIBSECTION}
  DIBSECTION = tagDIBSECTION;

{$EXTERNALSYM AngleArc}
function AngleArc(DC: HDC; p2, p3: Integer; p4: DWORD; p5, p6: Single): BOOL; stdcall;
{$EXTERNALSYM PolyPolyline}
function PolyPolyline(DC: HDC; const PointStructs; const Points; p4: DWORD): BOOL; stdcall;
{$EXTERNALSYM GetWorldTransform}
function GetWorldTransform(DC: HDC; var p2: TXForm): BOOL; stdcall;
{$EXTERNALSYM SetWorldTransform}
function SetWorldTransform(DC: HDC; const p2: TXForm): BOOL; stdcall;
{$EXTERNALSYM ModifyWorldTransform}
function ModifyWorldTransform(DC: HDC; const p2: TXForm; p3: DWORD): BOOL; stdcall;
{$EXTERNALSYM CombineTransform}
function CombineTransform(var p1: TXForm; const p2, p3: TXForm): BOOL; stdcall;
{$EXTERNALSYM CreateDIBSection}
function CreateDIBSection(DC: HDC; const p2: TBitmapInfo; p3: UINT;
  var p4: Pointer; p5: THandle; p6: DWORD): HBITMAP; stdcall;
{$EXTERNALSYM GetDIBColorTable}
function GetDIBColorTable(DC: HDC; p2, p3: UINT; var RGBQuadStructs): UINT; stdcall;
{$EXTERNALSYM SetDIBColorTable}
function SetDIBColorTable(DC: HDC; p2, p3: UINT; var RGBQuadSTructs): UINT; stdcall;

const
  { Flags value for COLORADJUSTMENT }
  {$EXTERNALSYM CA_NEGATIVE}
  CA_NEGATIVE = 1;
  {$EXTERNALSYM CA_LOG_FILTER}
  CA_LOG_FILTER = 2;

  { IlluminantIndex values }
  {$EXTERNALSYM ILLUMINANT_DEVICE_DEFAULT}
  ILLUMINANT_DEVICE_DEFAULT = 0;
  {$EXTERNALSYM ILLUMINANT_A}
  ILLUMINANT_A = 1;
  {$EXTERNALSYM ILLUMINANT_B}
  ILLUMINANT_B = 2;
  {$EXTERNALSYM ILLUMINANT_C}
  ILLUMINANT_C = 3;
  {$EXTERNALSYM ILLUMINANT_D50}
  ILLUMINANT_D50 = 4;
  {$EXTERNALSYM ILLUMINANT_D55}
  ILLUMINANT_D55 = 5;
  {$EXTERNALSYM ILLUMINANT_D65}
  ILLUMINANT_D65 = 6;
  {$EXTERNALSYM ILLUMINANT_D75}
  ILLUMINANT_D75 = 7;
  {$EXTERNALSYM ILLUMINANT_F2}
  ILLUMINANT_F2 = 8;

  {$EXTERNALSYM ILLUMINANT_MAX_INDEX}
  ILLUMINANT_MAX_INDEX = ILLUMINANT_F2;
  {$EXTERNALSYM ILLUMINANT_TUNGSTEN}
  ILLUMINANT_TUNGSTEN = ILLUMINANT_A;
  {$EXTERNALSYM ILLUMINANT_DAYLIGHT}
  ILLUMINANT_DAYLIGHT = ILLUMINANT_C;
  {$EXTERNALSYM ILLUMINANT_FLUORESCENT}
  ILLUMINANT_FLUORESCENT = ILLUMINANT_F2;
  {$EXTERNALSYM ILLUMINANT_NTSC}
  ILLUMINANT_NTSC = ILLUMINANT_C;

  { Min and max for RedGamma, GreenGamma, BlueGamma }
  {$EXTERNALSYM RGB_GAMMA_MIN}
  RGB_GAMMA_MIN = 02500;
  {$EXTERNALSYM RGB_GAMMA_MAX}
  RGB_GAMMA_MAX = 65000;

  { Min and max for ReferenceBlack and ReferenceWhite }
  {$EXTERNALSYM REFERENCE_WHITE_MIN}
  REFERENCE_WHITE_MIN = 6000;
  {$EXTERNALSYM REFERENCE_WHITE_MAX}
  REFERENCE_WHITE_MAX = 10000;
  {$EXTERNALSYM REFERENCE_BLACK_MIN}
  REFERENCE_BLACK_MIN = 0;
  {$EXTERNALSYM REFERENCE_BLACK_MAX}
  REFERENCE_BLACK_MAX = 4000;

  { Min and max for Contrast, Brightness, Colorfulness, RedGreenTint }
  {$EXTERNALSYM COLOR_ADJ_MIN}
  COLOR_ADJ_MIN = -100;
  {$EXTERNALSYM COLOR_ADJ_MAX}
  COLOR_ADJ_MAX = 100;

type
  PColorAdjustment = ^TColorAdjustment;
  {$EXTERNALSYM tagCOLORADJUSTMENT}
  tagCOLORADJUSTMENT = packed record
    caSize: Word;
    caFlags: Word;
    caIlluminantIndex: Word;
    caRedGamma: Word;
    caGreenGamma: Word;
    caBlueGamma: Word;
    caReferenceBlack: Word;
    caReferenceWhite: Word;
    caContrast: SHORT;
    caBrightness: SHORT;
    caColorfulness: SHORT;
    caRedGreenTint: SHORT;
  end;
  TColorAdjustment = tagCOLORADJUSTMENT;
  {$EXTERNALSYM COLORADJUSTMENT}
  COLORADJUSTMENT = tagCOLORADJUSTMENT;

{$EXTERNALSYM SetColorAdjustment}
function SetColorAdjustment(DC: HDC; const p2: TColorAdjustment): BOOL; stdcall;
{$EXTERNALSYM GetColorAdjustment}
function GetColorAdjustment(DC: HDC; var p2: TColorAdjustment): BOOL; stdcall;
{$EXTERNALSYM CreateHalftonePalette}
function CreateHalftonePalette(DC: HDC): HPALETTE; stdcall;

type
  TFNAbortProc = function (DC: HDC; p2: Integer): BOOL stdcall stdcall;

  PDocInfoA = ^TDocInfoA;
  PDocInfoW = ^TDocInfoW;
  PDocInfo = PDocInfoA;
  {$EXTERNALSYM _DOCINFOA}
  _DOCINFOA = packed record
    cbSize: Integer;
    lpszDocName: PAnsiChar;
    lpszOutput: PAnsiChar;
    lpszDatatype: PAnsiChar;
    fwType: DWORD;
  end;
  {$EXTERNALSYM _DOCINFOW}
  _DOCINFOW = packed record
    cbSize: Integer;
    lpszDocName: PWideChar;
    lpszOutput: PWideChar;
    lpszDatatype: PWideChar;
    fwType: DWORD;
  end;
  {$EXTERNALSYM _DOCINFO}
  _DOCINFO = _DOCINFOA;
  TDocInfoA = _DOCINFOA;
  TDocInfoW = _DOCINFOW;
  TDocInfo = TDocInfoA;
  {$EXTERNALSYM DOCINFOA}
  DOCINFOA = _DOCINFOA;
  {$EXTERNALSYM DOCINFOW}
  DOCINFOW = _DOCINFOW;
  {$EXTERNALSYM DOCINFO}
  DOCINFO = DOCINFOA;

const
  {$EXTERNALSYM DI_APPBANDING}
  DI_APPBANDING = 1;

{$EXTERNALSYM StartDoc}
function StartDoc(DC: HDC; const p2: TDocInfo): Integer; stdcall;
{$EXTERNALSYM StartDocA}
function StartDocA(DC: HDC; const p2: TDocInfoA): Integer; stdcall;
{$EXTERNALSYM StartDocW}
function StartDocW(DC: HDC; const p2: TDocInfoW): Integer; stdcall;
{$EXTERNALSYM EndDoc}
function EndDoc(DC: HDC): Integer; stdcall;
{$EXTERNALSYM StartPage}
function StartPage(DC: HDC): Integer; stdcall;
{$EXTERNALSYM EndPage}
function EndPage(DC: HDC): Integer; stdcall;
{$EXTERNALSYM AbortDoc}
function AbortDoc(DC: HDC): Integer; stdcall;
{$EXTERNALSYM SetAbortProc}
function SetAbortProc(DC: HDC; lpAbortProc: TFNAbortProc): Integer; stdcall;
{$EXTERNALSYM AbortPath}
function AbortPath(DC: HDC): BOOL; stdcall;
{$EXTERNALSYM ArcTo}
function ArcTo(DC: HDC; RLeft, RTop, RRight, RBottom: Integer;
  X1, Y1, X2, Y2: Integer): BOOL; stdcall;
{$EXTERNALSYM BeginPath}
function BeginPath(DC: HDC): BOOL; stdcall;
{$EXTERNALSYM CloseFigure}
function CloseFigure(DC: HDC): BOOL; stdcall;
{$EXTERNALSYM EndPath}
function EndPath(DC: HDC): BOOL; stdcall;
{$EXTERNALSYM FillPath}
function FillPath(DC: HDC): BOOL; stdcall;
{$EXTERNALSYM FlattenPath}
function FlattenPath(DC: HDC): BOOL; stdcall;
{$EXTERNALSYM GetPath}
function GetPath(DC: HDC; var Points, Types; nSize: Integer): Integer; stdcall;
{$EXTERNALSYM PathToRegion}
function PathToRegion(DC: HDC): HRGN; stdcall;
{$EXTERNALSYM PolyDraw}
function PolyDraw(DC: HDC; const Points, Types; cCount: Integer): BOOL; stdcall;
{$EXTERNALSYM SelectClipPath}
function SelectClipPath(DC: HDC; Mode: Integer): BOOL; stdcall;
{$EXTERNALSYM SetArcDirection}
function SetArcDirection(DC: HDC; Direction: Integer): Integer; stdcall;
{$EXTERNALSYM SetMiterLimit}
function SetMiterLimit(DC: HDC; NewLimit: Single; OldLimit: PSingle): BOOL; stdcall;
{$EXTERNALSYM StrokeAndFillPath}
function StrokeAndFillPath(DC: HDC): BOOL; stdcall;
{$EXTERNALSYM StrokePath}
function StrokePath(DC: HDC): BOOL; stdcall;
{$EXTERNALSYM WidenPath}
function WidenPath(DC: HDC): BOOL; stdcall;
{$EXTERNALSYM ExtCreatePen}
function ExtCreatePen(PenStyle, Width: DWORD; const Brush: TLogBrush;
  StyleCount: DWORD; Style: Pointer): HPEN; stdcall;
{$EXTERNALSYM GetMiterLimit}
function GetMiterLimit(DC: HDC; var Limit: Single): BOOL; stdcall;
{$EXTERNALSYM GetArcDirection}
function GetArcDirection(DC: HDC): Integer; stdcall;
{$EXTERNALSYM GetObject}
function GetObject(p1: HGDIOBJ; p2: Integer; p3: Pointer): Integer; stdcall;
{$EXTERNALSYM GetObjectA}
function GetObjectA(p1: HGDIOBJ; p2: Integer; p3: Pointer): Integer; stdcall;
{$EXTERNALSYM GetObjectW}
function GetObjectW(p1: HGDIOBJ; p2: Integer; p3: Pointer): Integer; stdcall;
{$EXTERNALSYM MoveToEx}
function MoveToEx(DC: HDC; p2, p3: Integer; p4: PPoint): BOOL; stdcall;
{$EXTERNALSYM TextOut}
function TextOut(DC: HDC; X, Y: Integer; Str: PChar; Count: Integer): BOOL; stdcall;
{$EXTERNALSYM TextOutA}
function TextOutA(DC: HDC; X, Y: Integer; Str: PAnsiChar; Count: Integer): BOOL; stdcall;
{$EXTERNALSYM TextOutW}
function TextOutW(DC: HDC; X, Y: Integer; Str: PWideChar; Count: Integer): BOOL; stdcall;
{$EXTERNALSYM ExtTextOut}
function ExtTextOut(DC: HDC; X, Y: Integer; Options: Longint;
  Rect: PRect; Str: PChar; Count: Longint; Dx: PInteger): BOOL; stdcall;
{$EXTERNALSYM ExtTextOutA}
function ExtTextOutA(DC: HDC; X, Y: Integer; Options: Longint;
  Rect: PRect; Str: PAnsiChar; Count: Longint; Dx: PInteger): BOOL; stdcall;
{$EXTERNALSYM ExtTextOutW}
function ExtTextOutW(DC: HDC; X, Y: Integer; Options: Longint;
  Rect: PRect; Str: PWideChar; Count: Longint; Dx: PInteger): BOOL; stdcall;
{$EXTERNALSYM PolyTextOut}
function PolyTextOut(DC: HDC; const PolyTextArray; Strings: Integer): BOOL; stdcall;
{$EXTERNALSYM PolyTextOutA}
function PolyTextOutA(DC: HDC; const PolyTextArray; Strings: Integer): BOOL; stdcall;
{$EXTERNALSYM PolyTextOutW}
function PolyTextOutW(DC: HDC; const PolyTextArray; Strings: Integer): BOOL; stdcall;
{$EXTERNALSYM CreatePolygonRgn}
function CreatePolygonRgn(const Points; Count, FillMode: Integer): HRGN; stdcall;
{$EXTERNALSYM DPtoLP}
function DPtoLP(DC: HDC; var Points; Count: Integer): BOOL; stdcall;
{$EXTERNALSYM LPtoDP}
function LPtoDP(DC: HDC; var Points; Count: Integer): BOOL; stdcall;
{$EXTERNALSYM Polygon}
function Polygon(DC: HDC; var Points; Count: Integer): BOOL; stdcall;
{$EXTERNALSYM Polyline}
function Polyline(DC: HDC; var Points; Count: Integer): BOOL; stdcall;
{$EXTERNALSYM PolyBezier}
function PolyBezier(DC: HDC; const Points; Count: DWORD): BOOL; stdcall;
{$EXTERNALSYM PolyBezierTo}
function PolyBezierTo(DC: HDC; const Points; Count: DWORD): BOOL; stdcall;
{$EXTERNALSYM PolyLineTo}
function PolyLineTo(DC: HDC; const Points; Count: DWORD): BOOL; stdcall;
{$EXTERNALSYM SetViewportExtEx}
function SetViewportExtEx(DC: HDC; XExt, YExt: Integer; Size: PSize): BOOL; stdcall;
{$EXTERNALSYM SetViewportOrgEx}
function SetViewportOrgEx(DC: HDC; X, Y: Integer; Point: PPoint): BOOL; stdcall;
{$EXTERNALSYM SetWindowExtEx}
function SetWindowExtEx(DC: HDC; XExt, YExt: Integer; Size: PSize): BOOL; stdcall;
{$EXTERNALSYM SetWindowOrgEx}
function SetWindowOrgEx(DC: HDC; X, Y: Integer; Point: PPoint): BOOL; stdcall;
{$EXTERNALSYM OffsetViewportOrgEx}
function OffsetViewportOrgEx(DC: HDC; X, Y: Integer; var Points): BOOL; stdcall; overload;
{$EXTERNALSYM OffsetWindowOrgEx}
function OffsetWindowOrgEx(DC: HDC; X, Y: Integer; var Points): BOOL; stdcall; overload;
{$EXTERNALSYM OffsetViewportOrgEx}
function OffsetViewportOrgEx(DC: HDC; X, Y: Integer; Points: PPoint): BOOL; stdcall; overload;
{$EXTERNALSYM OffsetWindowOrgEx}
function OffsetWindowOrgEx(DC: HDC; X, Y: Integer; Points: PPoint): BOOL; stdcall; overload;
{$EXTERNALSYM ScaleViewportExtEx}
function ScaleViewportExtEx(DC: HDC; XM, XD, YM, YD: Integer; Size: PSize): BOOL; stdcall;
{$EXTERNALSYM ScaleWindowExtEx}
function ScaleWindowExtEx(DC: HDC; XM, XD, YM, YD: Integer; Size: PSize): BOOL; stdcall;
{$EXTERNALSYM SetBitmapDimensionEx}
function SetBitmapDimensionEx(hBitmap: HBITMAP; Width, Height: Integer; Size: PSize): BOOL; stdcall;
{$EXTERNALSYM SetBrushOrgEx}
function SetBrushOrgEx(DC: HDC; X, Y: Integer; PrevPt: PPoint): BOOL; stdcall;
{$EXTERNALSYM GetTextFace}
function GetTextFace(DC: HDC; Count: Integer; Buffer: PChar): Integer; stdcall;
{$EXTERNALSYM GetTextFaceA}
function GetTextFaceA(DC: HDC; Count: Integer; Buffer: PAnsiChar): Integer; stdcall;
{$EXTERNALSYM GetTextFaceW}
function GetTextFaceW(DC: HDC; Count: Integer; Buffer: PWideChar): Integer; stdcall;

const
  {$EXTERNALSYM FONTMAPPER_MAX}
  FONTMAPPER_MAX = 10;

type
  PKerningPair = ^TKerningPair;
  {$EXTERNALSYM tagKERNINGPAIR}
  tagKERNINGPAIR = packed record
    wFirst: Word;
    wSecond: Word;
    iKernAmount: Integer;
  end;
  TKerningPair = tagKERNINGPAIR;
  {$EXTERNALSYM KERNINGPAIR}
  KERNINGPAIR = tagKERNINGPAIR;

{$EXTERNALSYM GetKerningPairs}
function GetKerningPairs(DC: HDC; Count: DWORD; var KerningPairs): DWORD; stdcall;
{$EXTERNALSYM GetDCOrgEx}
function GetDCOrgEx(DC: HDC; var Origin: TPoint): BOOL; stdcall;
{$EXTERNALSYM UnrealizeObject}
function UnrealizeObject(hGDIObj: HGDIOBJ): BOOL; stdcall;
{$EXTERNALSYM GdiFlush}
function GdiFlush: BOOL; stdcall;
{$EXTERNALSYM GdiSetBatchLimit}
function GdiSetBatchLimit(Limit: DWORD): DWORD; stdcall;
{$EXTERNALSYM GdiGetBatchLimit}
function GdiGetBatchLimit: DWORD; stdcall;

const
  {$EXTERNALSYM ICM_OFF}
  ICM_OFF = 1;
  {$EXTERNALSYM ICM_ON}
  ICM_ON = 2;
  {$EXTERNALSYM ICM_QUERY}
  ICM_QUERY = 3;

  {$EXTERNALSYM ICM_ADDPROFILE}
  ICM_ADDPROFILE = 1; { removed in 4.0 SDK }
  {$EXTERNALSYM ICM_DELETEPROFILE}
  ICM_DELETEPROFILE = 2; { removed in 4.0 SDK }
  {$EXTERNALSYM ICM_QUERYPROFILE}
  ICM_QUERYPROFILE = 3; { removed in 4.0 SDK }
  {$EXTERNALSYM ICM_SETDEFAULTPROFILE}
  ICM_SETDEFAULTPROFILE = 4; { removed in 4.0 SDK }
  {$EXTERNALSYM ICM_REGISTERICMATCHER}
  ICM_REGISTERICMATCHER = 5; { removed in 4.0 SDK }
  {$EXTERNALSYM ICM_UNREGISTERICMATCHER}
  ICM_UNREGISTERICMATCHER = 6; { removed in 4.0 SDK }
  {$EXTERNALSYM ICM_QUERYMATCH}
  ICM_QUERYMATCH = 7; { removed in 4.0 SDK }

{$EXTERNALSYM SetICMMode}
function SetICMMode(DC: HDC; Mode: Integer): Integer; stdcall;
{$EXTERNALSYM CheckColorsInGamut}
function CheckColorsInGamut(DC: HDC; var RGBQuads, Results; Count: DWORD): BOOL; stdcall;
{$EXTERNALSYM GetColorSpace}
function GetColorSpace(DC: HDC): THandle; stdcall;
{$EXTERNALSYM GetLogColorSpace}
function GetLogColorSpace(p1: HCOLORSPACE; var ColorSpace: TLogColorSpace; Size: DWORD): BOOL; stdcall;
{$EXTERNALSYM GetLogColorSpaceA}
function GetLogColorSpaceA(p1: HCOLORSPACE; var ColorSpace: TLogColorSpaceA; Size: DWORD): BOOL; stdcall;
{$EXTERNALSYM GetLogColorSpaceW}
function GetLogColorSpaceW(p1: HCOLORSPACE; var ColorSpace: TLogColorSpaceW; Size: DWORD): BOOL; stdcall;
{$EXTERNALSYM CreateColorSpace}
function CreateColorSpace(var ColorSpace: TLogColorSpace): HCOLORSPACE; stdcall;
{$EXTERNALSYM CreateColorSpaceA}
function CreateColorSpaceA(var ColorSpace: TLogColorSpaceA): HCOLORSPACE; stdcall;
{$EXTERNALSYM CreateColorSpaceW}
function CreateColorSpaceW(var ColorSpace: TLogColorSpaceW): HCOLORSPACE; stdcall;
{$EXTERNALSYM SetColorSpace}
function SetColorSpace(DC: HDC; ColorSpace: HCOLORSPACE): BOOL; stdcall;
{$EXTERNALSYM DeleteColorSpace}
function DeleteColorSpace(ColorSpace: HCOLORSPACE): BOOL; stdcall;
{$EXTERNALSYM GetICMProfile}
function GetICMProfile(DC: HDC; var Size: DWORD; Name: PChar): BOOL; stdcall;
{$EXTERNALSYM GetICMProfileA}
function GetICMProfileA(DC: HDC; var Size: DWORD; Name: PAnsiChar): BOOL; stdcall;
{$EXTERNALSYM GetICMProfileW}
function GetICMProfileW(DC: HDC; var Size: DWORD; Name: PWideChar): BOOL; stdcall;
{$EXTERNALSYM SetICMProfile}
function SetICMProfile(DC: HDC; Name: PChar): BOOL; stdcall;
{$EXTERNALSYM SetICMProfileA}
function SetICMProfileA(DC: HDC; Name: PAnsiChar): BOOL; stdcall;
{$EXTERNALSYM SetICMProfileW}
function SetICMProfileW(DC: HDC; Name: PWideChar): BOOL; stdcall;
{$EXTERNALSYM GetDeviceGammaRamp}
function GetDeviceGammaRamp(DC: HDC; var Ramp): BOOL; stdcall;
{$EXTERNALSYM SetDeviceGammaRamp}
function SetDeviceGammaRamp(DC: HDC; var Ramp): BOOL; stdcall;
{$EXTERNALSYM ColorMatchToTarget}
function ColorMatchToTarget(DC: HDC; Target: HDC; Action: DWORD): BOOL; stdcall;

type



  TFNICMEnumProc = TFarProc;


{$EXTERNALSYM EnumICMProfiles}
function EnumICMProfiles(DC: HDC; ICMProc: TFNICMEnumProc; p3: LPARAM): Integer; stdcall;
{$EXTERNALSYM EnumICMProfilesA}
function EnumICMProfilesA(DC: HDC; ICMProc: TFNICMEnumProc; p3: LPARAM): Integer; stdcall;
{$EXTERNALSYM EnumICMProfilesW}
function EnumICMProfilesW(DC: HDC; ICMProc: TFNICMEnumProc; p3: LPARAM): Integer; stdcall;

{$EXTERNALSYM UpdateICMRegKey}
function UpdateICMRegKey(p1: DWORD; p2, p3: PChar; p4: UINT): BOOL; stdcall;
{$EXTERNALSYM UpdateICMRegKeyA}
function UpdateICMRegKeyA(p1: DWORD; p2, p3: PAnsiChar; p4: UINT): BOOL; stdcall;
{$EXTERNALSYM UpdateICMRegKeyW}
function UpdateICMRegKeyW(p1: DWORD; p2, p3: PWideChar; p4: UINT): BOOL; stdcall;

{$EXTERNALSYM ColorCorrectPalette}
function ColorCorrectPalette(DC: HDC; p2: HPALETTE; p3, p4: DWORD): BOOL; stdcall;

const
  {$EXTERNALSYM ENHMETA_SIGNATURE}
  ENHMETA_SIGNATURE = $464D4520;  { Enhanced metafile constants. }

{ Stock object flag used in the object handle index in the enhanced
  metafile records.
  E.g. The object handle index (META_STOCK_OBJECT or BLACK_BRUSH)
  represents the stock object BLACK_BRUSH. }

  {$EXTERNALSYM ENHMETA_STOCK_OBJECT}
  ENHMETA_STOCK_OBJECT = DWORD($80000000);

{ Enhanced metafile record types.}

  {$EXTERNALSYM EMR_HEADER}
  EMR_HEADER = 1;
  {$EXTERNALSYM EMR_POLYBEZIER}
  EMR_POLYBEZIER = 2;
  {$EXTERNALSYM EMR_POLYGON}
  EMR_POLYGON = 3;
  {$EXTERNALSYM EMR_POLYLINE}
  EMR_POLYLINE = 4;
  {$EXTERNALSYM EMR_POLYBEZIERTO}
  EMR_POLYBEZIERTO = 5;
  {$EXTERNALSYM EMR_POLYLINETO}
  EMR_POLYLINETO = 6;
  {$EXTERNALSYM EMR_POLYPOLYLINE}
  EMR_POLYPOLYLINE = 7;
  {$EXTERNALSYM EMR_POLYPOLYGON}
  EMR_POLYPOLYGON = 8;
  {$EXTERNALSYM EMR_SETWINDOWEXTEX}
  EMR_SETWINDOWEXTEX = 9;
  {$EXTERNALSYM EMR_SETWINDOWORGEX}
  EMR_SETWINDOWORGEX = 10;
  {$EXTERNALSYM EMR_SETVIEWPORTEXTEX}
  EMR_SETVIEWPORTEXTEX = 11;
  {$EXTERNALSYM EMR_SETVIEWPORTORGEX}
  EMR_SETVIEWPORTORGEX = 12;
  {$EXTERNALSYM EMR_SETBRUSHORGEX}
  EMR_SETBRUSHORGEX = 13;
  {$EXTERNALSYM EMR_EOF}
  EMR_EOF = 14;
  {$EXTERNALSYM EMR_SETPIXELV}
  EMR_SETPIXELV = 15;
  {$EXTERNALSYM EMR_SETMAPPERFLAGS}
  EMR_SETMAPPERFLAGS = $10;
  {$EXTERNALSYM EMR_SETMAPMODE}
  EMR_SETMAPMODE = 17;
  {$EXTERNALSYM EMR_SETBKMODE}
  EMR_SETBKMODE = 18;
  {$EXTERNALSYM EMR_SETPOLYFILLMODE}
  EMR_SETPOLYFILLMODE = 19;
  {$EXTERNALSYM EMR_SETROP2}
  EMR_SETROP2 = 20;
  {$EXTERNALSYM EMR_SETSTRETCHBLTMODE}
  EMR_SETSTRETCHBLTMODE = 21;
  {$EXTERNALSYM EMR_SETTEXTALIGN}
  EMR_SETTEXTALIGN = 22;
  {$EXTERNALSYM EMR_SETCOLORADJUSTMENT}
  EMR_SETCOLORADJUSTMENT = 23;
  {$EXTERNALSYM EMR_SETTEXTCOLOR}
  EMR_SETTEXTCOLOR = 24;
  {$EXTERNALSYM EMR_SETBKCOLOR}
  EMR_SETBKCOLOR = 25;
  {$EXTERNALSYM EMR_OFFSETCLIPRGN}
  EMR_OFFSETCLIPRGN = 26;
  {$EXTERNALSYM EMR_MOVETOEX}
  EMR_MOVETOEX = 27;
  {$EXTERNALSYM EMR_SETMETARGN}
  EMR_SETMETARGN = 28;
  {$EXTERNALSYM EMR_EXCLUDECLIPRECT}
  EMR_EXCLUDECLIPRECT = 29;
  {$EXTERNALSYM EMR_INTERSECTCLIPRECT}
  EMR_INTERSECTCLIPRECT = 30;
  {$EXTERNALSYM EMR_SCALEVIEWPORTEXTEX}
  EMR_SCALEVIEWPORTEXTEX = 31;
  {$EXTERNALSYM EMR_SCALEWINDOWEXTEX}
  EMR_SCALEWINDOWEXTEX = 32;
  {$EXTERNALSYM EMR_SAVEDC}
  EMR_SAVEDC = 33;
  {$EXTERNALSYM EMR_RESTOREDC}
  EMR_RESTOREDC = 34;
  {$EXTERNALSYM EMR_SETWORLDTRANSFORM}
  EMR_SETWORLDTRANSFORM = 35;
  {$EXTERNALSYM EMR_MODIFYWORLDTRANSFORM}
  EMR_MODIFYWORLDTRANSFORM = 36;
  {$EXTERNALSYM EMR_SELECTOBJECT}
  EMR_SELECTOBJECT = 37;
  {$EXTERNALSYM EMR_CREATEPEN}
  EMR_CREATEPEN = 38;
  {$EXTERNALSYM EMR_CREATEBRUSHINDIRECT}
  EMR_CREATEBRUSHINDIRECT = 39;
  {$EXTERNALSYM EMR_DELETEOBJECT}
  EMR_DELETEOBJECT = 40;
  {$EXTERNALSYM EMR_ANGLEARC}
  EMR_ANGLEARC = 41;
  {$EXTERNALSYM EMR_ELLIPSE}
  EMR_ELLIPSE = 42;
  {$EXTERNALSYM EMR_RECTANGLE}
  EMR_RECTANGLE = 43;
  {$EXTERNALSYM EMR_ROUNDRECT}
  EMR_ROUNDRECT = 44;
  {$EXTERNALSYM EMR_ARC}
  EMR_ARC = 45;
  {$EXTERNALSYM EMR_CHORD}
  EMR_CHORD = 46;
  {$EXTERNALSYM EMR_PIE}
  EMR_PIE = 47;
  {$EXTERNALSYM EMR_SELECTPALETTE}
  EMR_SELECTPALETTE = 48;
  {$EXTERNALSYM EMR_CREATEPALETTE}
  EMR_CREATEPALETTE = 49;
  {$EXTERNALSYM EMR_SETPALETTEENTRIES}
  EMR_SETPALETTEENTRIES = 50;
  {$EXTERNALSYM EMR_RESIZEPALETTE}
  EMR_RESIZEPALETTE = 51;
  {$EXTERNALSYM EMR_REALIZEPALETTE}
  EMR_REALIZEPALETTE = 52;
  {$EXTERNALSYM EMR_EXTFLOODFILL}
  EMR_EXTFLOODFILL = 53;
  {$EXTERNALSYM EMR_LINETO}
  EMR_LINETO = 54;
  {$EXTERNALSYM EMR_ARCTO}
  EMR_ARCTO = 55;
  {$EXTERNALSYM EMR_POLYDRAW}
  EMR_POLYDRAW = 56;
  {$EXTERNALSYM EMR_SETARCDIRECTION}
  EMR_SETARCDIRECTION = 57;
  {$EXTERNALSYM EMR_SETMITERLIMIT}
  EMR_SETMITERLIMIT = 58;
  {$EXTERNALSYM EMR_BEGINPATH}
  EMR_BEGINPATH = 59;
  {$EXTERNALSYM EMR_ENDPATH}
  EMR_ENDPATH = 60;
  {$EXTERNALSYM EMR_CLOSEFIGURE}
  EMR_CLOSEFIGURE = 61;
  {$EXTERNALSYM EMR_FILLPATH}
  EMR_FILLPATH = 62;
  {$EXTERNALSYM EMR_STROKEANDFILLPATH}
  EMR_STROKEANDFILLPATH = 63;
  {$EXTERNALSYM EMR_STROKEPATH}
  EMR_STROKEPATH = $40;
  {$EXTERNALSYM EMR_FLATTENPATH}
  EMR_FLATTENPATH = 65;
  {$EXTERNALSYM EMR_WIDENPATH}
  EMR_WIDENPATH = 66;
  {$EXTERNALSYM EMR_SELECTCLIPPATH}
  EMR_SELECTCLIPPATH = 67;
  {$EXTERNALSYM EMR_ABORTPATH}
  EMR_ABORTPATH = 68;

  {$EXTERNALSYM EMR_GDICOMMENT}
  EMR_GDICOMMENT = 70;
  {$EXTERNALSYM EMR_FILLRGN}
  EMR_FILLRGN = 71;
  {$EXTERNALSYM EMR_FRAMERGN}
  EMR_FRAMERGN = 72;
  {$EXTERNALSYM EMR_INVERTRGN}
  EMR_INVERTRGN = 73;
  {$EXTERNALSYM EMR_PAINTRGN}
  EMR_PAINTRGN = 74;
  {$EXTERNALSYM EMR_EXTSELECTCLIPRGN}
  EMR_EXTSELECTCLIPRGN = 75;
  {$EXTERNALSYM EMR_BITBLT}
  EMR_BITBLT = 76;
  {$EXTERNALSYM EMR_STRETCHBLT}
  EMR_STRETCHBLT = 77;
  {$EXTERNALSYM EMR_MASKBLT}
  EMR_MASKBLT = 78;
  {$EXTERNALSYM EMR_PLGBLT}
  EMR_PLGBLT = 79;
  {$EXTERNALSYM EMR_SETDIBITSTODEVICE}
  EMR_SETDIBITSTODEVICE = 80;
  {$EXTERNALSYM EMR_STRETCHDIBITS}
  EMR_STRETCHDIBITS = 81;
  {$EXTERNALSYM EMR_EXTCREATEFONTINDIRECTW}
  EMR_EXTCREATEFONTINDIRECTW = 82;
  {$EXTERNALSYM EMR_EXTTEXTOUTA}
  EMR_EXTTEXTOUTA = 83;
  {$EXTERNALSYM EMR_EXTTEXTOUTW}
  EMR_EXTTEXTOUTW = 84;
  {$EXTERNALSYM EMR_POLYBEZIER16}
  EMR_POLYBEZIER16 = 85;
  {$EXTERNALSYM EMR_POLYGON16}
  EMR_POLYGON16 = 86;
  {$EXTERNALSYM EMR_POLYLINE16}
  EMR_POLYLINE16 = 87;
  {$EXTERNALSYM EMR_POLYBEZIERTO16}
  EMR_POLYBEZIERTO16 = 88;
  {$EXTERNALSYM EMR_POLYLINETO16}
  EMR_POLYLINETO16 = 89;
  {$EXTERNALSYM EMR_POLYPOLYLINE16}
  EMR_POLYPOLYLINE16 = 90;
  {$EXTERNALSYM EMR_POLYPOLYGON16}
  EMR_POLYPOLYGON16 = 91;
  {$EXTERNALSYM EMR_POLYDRAW16}
  EMR_POLYDRAW16 = 92;
  {$EXTERNALSYM EMR_CREATEMONOBRUSH}
  EMR_CREATEMONOBRUSH = 93;
  {$EXTERNALSYM EMR_CREATEDIBPATTERNBRUSHPT}
  EMR_CREATEDIBPATTERNBRUSHPT = 94;
  {$EXTERNALSYM EMR_EXTCREATEPEN}
  EMR_EXTCREATEPEN = 95;
  {$EXTERNALSYM EMR_POLYTEXTOUTA}
  EMR_POLYTEXTOUTA = 96;
  {$EXTERNALSYM EMR_POLYTEXTOUTW}
  EMR_POLYTEXTOUTW = 97;
  {$EXTERNALSYM EMR_SETICMMODE}
  EMR_SETICMMODE = 98;
  {$EXTERNALSYM EMR_CREATECOLORSPACE}
  EMR_CREATECOLORSPACE = 99;
  {$EXTERNALSYM EMR_SETCOLORSPACE}
  EMR_SETCOLORSPACE = 100;
  {$EXTERNALSYM EMR_DELETECOLORSPACE}
  EMR_DELETECOLORSPACE = 101;
  {$EXTERNALSYM EMR_GLSRECORD}
  EMR_GLSRECORD = 102;
  {$EXTERNALSYM EMR_GLSBOUNDEDRECORD}
  EMR_GLSBOUNDEDRECORD = 103;
  {$EXTERNALSYM EMR_PIXELFORMAT}
  EMR_PIXELFORMAT = 104;
  {$EXTERNALSYM EMR_DRAWESCAPE}
  EMR_DRAWESCAPE = 105;
  {$EXTERNALSYM EMR_EXTESCAPE}
  EMR_EXTESCAPE = 106;
  {$EXTERNALSYM EMR_STARTDOC}
  EMR_STARTDOC = 107;
  {$EXTERNALSYM EMR_SMALLTEXTOUT}
  EMR_SMALLTEXTOUT = 108;
  {$EXTERNALSYM EMR_FORCEUFIMAPPING}
  EMR_FORCEUFIMAPPING = 109;
  {$EXTERNALSYM EMR_NAMEDESCAPE}
  EMR_NAMEDESCAPE = 110;
  {$EXTERNALSYM EMR_COLORCORRECTPALETTE}
  EMR_COLORCORRECTPALETTE = 111;
  {$EXTERNALSYM EMR_SETICMPROFILEA}
  EMR_SETICMPROFILEA = 112;
  {$EXTERNALSYM EMR_SETICMPROFILEW}
  EMR_SETICMPROFILEW = 113;
  {$EXTERNALSYM EMR_ALPHABLEND}
  EMR_ALPHABLEND = 114;
  {$EXTERNALSYM EMR_ALPHADIBBLEND}
  EMR_ALPHADIBBLEND = 115;
  {$EXTERNALSYM EMR_TRANSPARENTBLT}
  EMR_TRANSPARENTBLT = 116;
  {$EXTERNALSYM EMR_TRANSPARENTDIB}
  EMR_TRANSPARENTDIB = 117;
  {$EXTERNALSYM EMR_GRADIENTFILL}
  EMR_GRADIENTFILL = 118;
  {$EXTERNALSYM EMR_SETLINKEDUFIS}
  EMR_SETLINKEDUFIS = 119;
  {$EXTERNALSYM EMR_SETTEXTJUSTIFICATION}
  EMR_SETTEXTJUSTIFICATION = 120;
  {$EXTERNALSYM EMR_MAX}
  EMR_MAX = 120;
  {$EXTERNALSYM EMR_MIN}
  EMR_MIN = 1;


type
  { Base record type for the enhanced metafile.}
  {$EXTERNALSYM PEMR}
  PEMR = ^TEMR;
  {$EXTERNALSYM tagEMR}
  tagEMR = packed record
    iType: DWORD; { Enhanced metafile record type}
    nSize: DWORD; { Length of the record in bytes.}
                  { This must be a multiple of 4.}
  end;
  TEMR = tagEMR;
  {$EXTERNALSYM EMR}
  EMR = tagEMR;

  { Base text record type for the enhanced metafile.}
  PEMRText = ^TEMRText;
  {$EXTERNALSYM tagEMRTEXT}
  tagEMRTEXT = packed record
    ptlReference: TPoint;
    nChars: DWORD;
    offString: DWORD; { Offset to the string}
    fOptions: DWORD;
    rcl: TRect;
    offDx: DWORD;     { Offset to the inter-character spacing array.}
                      { This is always given.}
  end;
  TEMRText = tagEMRTEXT;
  {$EXTERNALSYM EMRTEXT}
  EMRTEXT = tagEMRTEXT;


  { Record structures for the enhanced metafile.}
  PAbortPath = ^TAbortPath;
  {$EXTERNALSYM tagABORTPATH}
  tagABORTPATH = packed record
    emr: TEMR;
  end;
  TAbortPath = tagABORTPATH;
  {$EXTERNALSYM EMRABORTPATH}
  EMRABORTPATH = tagABORTPATH;
  TEMRAbortPath = TAbortPath;
  PEMRAbortPath = PAbortPath;
  TEMRBeginPath = TAbortPath;
  PEMRBeginPath = PAbortPath;
  TEMREndPath = TAbortPath;
  PEMREndPath = PAbortPath;
  TEMRCloseFigure = TAbortPath;
  PEMRCloseFigure = PAbortPath;
  TEMRFlattenPath = TAbortPath;
  PEMRFlattenPath = PAbortPath;
  TEMRWidenPath = TAbortPath;
  PEMRWidenPath = PAbortPath;
  TEMRSetMetaRgn = TAbortPath;
  PEMRSetMetaRgn = PAbortPath;
  TEMRSaveDC = TAbortPath;
  PEMRSaveDC = PAbortPath;
  TEMRRealizePalette = TAbortPath;
  PEMRRealizePalette = PAbortPath;

  PEMRSelectclippath = ^TEMRSelectClipPath;
  {$EXTERNALSYM tagEMRSELECTCLIPPATH}
  tagEMRSELECTCLIPPATH = packed record
    emr: TEMR;
    iMode: DWORD;
  end;
  TEMRSelectClipPath = tagEMRSELECTCLIPPATH;
  {$EXTERNALSYM EMRSELECTCLIPPATH}
  EMRSELECTCLIPPATH = tagEMRSELECTCLIPPATH;
  TEMRSetBkMode = TEMRSelectClipPath;
  PEMRSetBkMode = PEMRSelectClipPath;
  TEMRSetMapMode = TEMRSelectClipPath;
  PEMRSetMapMode = PEMRSelectClipPath;
  TEMRSetPolyFillMode = TEMRSelectClipPath;
  PEMRSetPolyFillMode = PEMRSelectClipPath;
  TEMRSetRop2 = TEMRSelectClipPath;
  PEMRSetRop2 = PEMRSelectClipPath;
  TEMRSetStretchBltMode = TEMRSelectClipPath;
  PEMRSetStretchBltMode = PEMRSelectClipPath;
  TEMRSetICMMode = TEMRSelectClipPath;
  PEMRSetICMMode = PEMRSelectClipPath;
  TEMRSetTextAlign = TEMRSelectClipPath;
  PEMRSetTextAlign = PEMRSelectClipPath;

  PEMRSetMiterLimit = ^TEMRSetMiterLimit;
  {$EXTERNALSYM tagEMRSETMITERLIMIT}
  tagEMRSETMITERLIMIT = packed record
    emr: TEMR;
    eMiterLimit: Single;
  end;
  TEMRSetMiterLimit = tagEMRSETMITERLIMIT;
  {$EXTERNALSYM EMRSETMITERLIMIT}
  EMRSETMITERLIMIT = tagEMRSETMITERLIMIT;

  PEMRRestoreDC = ^TEMRRestoreDC;
  {$EXTERNALSYM tagEMRRESTOREDC}
  tagEMRRESTOREDC = packed record
    emr: TEMR;
    iRelative: Longint;   { Specifies a relative instance}
  end;
  TEMRRestoreDC = tagEMRRESTOREDC;
  {$EXTERNALSYM EMRRESTOREDC}
  EMRRESTOREDC = tagEMRRESTOREDC;

  PEMRSetArcDirection = ^TEMRSetArcDirection;
  {$EXTERNALSYM tagEMRSETARCDIRECTION}
  tagEMRSETARCDIRECTION = packed record
    emr: TEMR;
    iArcDirection: DWORD; { Specifies the arc direction in the advanced graphics mode.}
  end;
  TEMRSetArcDirection = tagEMRSETARCDIRECTION;
  {$EXTERNALSYM EMRSETARCDIRECTION}
  EMRSETARCDIRECTION = tagEMRSETARCDIRECTION;

  PEMRSetMapperFlags = ^TEMRSetMapperFlags;
  {$EXTERNALSYM tagEMRSETMAPPERFLAGS}
  tagEMRSETMAPPERFLAGS = packed record
    emr: TEMR;
    dwFlags: DWORD;
  end;
  TEMRSetMapperFlags = tagEMRSETMAPPERFLAGS;
  {$EXTERNALSYM EMRSETMAPPERFLAGS}
  EMRSETMAPPERFLAGS = tagEMRSETMAPPERFLAGS;

  PEMRSetTextColor = ^TEMRSetTextColor;
  {$EXTERNALSYM tagEMRSETTEXTCOLOR}
  tagEMRSETTEXTCOLOR = packed record
    emr: TEMR;
    crColor: COLORREF;
  end;
  TEMRSetTextColor = tagEMRSETTEXTCOLOR;
  {$EXTERNALSYM EMRSETTEXTCOLOR}
  EMRSETTEXTCOLOR = tagEMRSETTEXTCOLOR;
  TEMRSetBkColor = TEMRSetTextColor;
  PEMRSetBkColor = PEMRSetTextColor;

  PEMRSelectObject = ^TEMRSelectObject;
  {$EXTERNALSYM tagEMRSELECTOBJECT}
  tagEMRSELECTOBJECT = packed record
    emr: TEMR;
    ihObject: DWORD;   { Object handle index }
  end;
  TEMRSelectObject = tagEMRSELECTOBJECT;
  {$EXTERNALSYM EMRSELECTOBJECT}
  EMRSELECTOBJECT = tagEMRSELECTOBJECT;
  EMRDeleteObject = TEMRSelectObject;
  PEMRDeleteObject = PEMRSelectObject;

  PEMRSelectColorSpace = ^TEMRSelectColorSpace;
  {$EXTERNALSYM tagEMRSETCOLORSPACE}
  tagEMRSETCOLORSPACE = packed record
    emr: TEMR;
    ihCS: DWORD;  { ColorSpace handle index }
  end;
  TEMRSelectColorSpace = tagEMRSETCOLORSPACE;
  {$EXTERNALSYM EMRSELECTCOLORSPACE}
  EMRSELECTCOLORSPACE = tagEMRSETCOLORSPACE;
  EMRDeleteColorSpace = TEMRSelectColorSpace;
  PEMRDeleteColorSpace = PEMRSelectColorSpace;

  PEMRSelectPalette = ^TEMRSelectPalette;
  {$EXTERNALSYM tagEMRSELECTPALETTE}
  tagEMRSELECTPALETTE = packed record
    emr: TEMR;
    ihPal: DWORD;   { Palette handle index, background mode only }
  end;
  TEMRSelectPalette = tagEMRSELECTPALETTE;
  {$EXTERNALSYM EMRSELECTPALETTE}
  EMRSELECTPALETTE = tagEMRSELECTPALETTE;

  PEMRResizePalette = ^TEMRResizePalette;
  {$EXTERNALSYM tagEMRRESIZEPALETTE}
  tagEMRRESIZEPALETTE = packed record
    emr: TEMR;
    ihPal: DWORD;   { Palette handle index }
    cEntries: DWORD;
  end;
  TEMRResizePalette = tagEMRRESIZEPALETTE;
  {$EXTERNALSYM EMRRESIZEPALETTE}
  EMRRESIZEPALETTE = tagEMRRESIZEPALETTE;

  PEMRSetPaletteEntries = ^TEMRSetPaletteEntries;
  {$EXTERNALSYM tagEMRSETPALETTEENTRIES}
  tagEMRSETPALETTEENTRIES = packed record
    emr: TEMR;
    ihPal: DWORD;      { Palette handle index }
    iStart: DWORD;
    cEntries: DWORD;
    aPalEntries: array[0..0] of TPaletteEntry; { The peFlags fields do not contain any flags }
  end;
  TEMRSetPaletteEntries = tagEMRSETPALETTEENTRIES;
  {$EXTERNALSYM EMRSETPALETTEENTRIES}
  EMRSETPALETTEENTRIES = tagEMRSETPALETTEENTRIES;

  PEMRSetColorAdjustment = ^TEMRSetColorAdjustment;
  {$EXTERNALSYM tagEMRSETCOLORADJUSTMENT}
  tagEMRSETCOLORADJUSTMENT = packed record
    emr: TEMR;
    ColorAdjustment: TColorAdjustment;
  end;
  TEMRSetColorAdjustment = tagEMRSETCOLORADJUSTMENT;
  {$EXTERNALSYM EMRSETCOLORADJUSTMENT}
  EMRSETCOLORADJUSTMENT = tagEMRSETCOLORADJUSTMENT;

  PEMRGDIComment = ^TEMRGDIComment;
  {$EXTERNALSYM tagEMRGDICOMMENT}
  tagEMRGDICOMMENT = record
    emr: TEMR;
    cbData: DWORD;   { Size of data in bytes}
    Data: array[0..0] of Byte;
  end;
  TEMRGDIComment = tagEMRGDICOMMENT;
  {$EXTERNALSYM EMRGDICOMMENT}
  EMRGDICOMMENT = tagEMRGDICOMMENT;

  {$EXTERNALSYM PEMREOF}
  PEMREOF = ^TEMREOF;
  {$EXTERNALSYM tagEMREOF}
  tagEMREOF = packed record
    emr: TEMR;
    nPalEntries: DWORD;   { Number of palette entries }
    offPalEntries: DWORD; { Offset to the palette entries }
    nSizeLast: DWORD;     { Same as nSize and must be the last DWORD }
                          { of the record.  The palette entries, }
                          { if exist, precede this field. }
  end;
  TEMREOF = tagEMREOF;
  {$EXTERNALSYM EMREOF}
  EMREOF = tagEMREOF;

  PEMRLineTo = ^TEMRLineTo;
  {$EXTERNALSYM tagEMRLINETO}
  tagEMRLINETO = packed record
    emr: TEMR;
    ptl: TPoint;
  end;
  TEMRLineTo = tagEMRLINETO;
  {$EXTERNALSYM EMRLINETO}
  EMRLINETO = tagEMRLINETO;
  EMRMoveToEx = TEMRLineTo;
  PEMRMoveToEx = PEMRLineTo;

  PEMROffsetClipRgn = ^TEMROffsetClipRgn;
  {$EXTERNALSYM tagEMROFFSETCLIPRGN}
  tagEMROFFSETCLIPRGN = packed record
    emr: TEMR;
    ptlOffset: TPoint;
  end;
  TEMROffsetClipRgn = tagEMROFFSETCLIPRGN;
  {$EXTERNALSYM EMROFFSETCLIPRGN}
  EMROFFSETCLIPRGN = tagEMROFFSETCLIPRGN;

  PEMRFillPath = ^TEMRFillPath;
  {$EXTERNALSYM tagEMRFILLPATH}
  tagEMRFILLPATH = packed record
    emr: TEMR;
    rclBounds: TRect; { Inclusive-inclusive bounds in device units}
  end;
  TEMRFillPath = tagEMRFILLPATH;
  {$EXTERNALSYM EMRFILLPATH}
  EMRFILLPATH = tagEMRFILLPATH;
  EMRStrokeAndFillPath = TEMRFillPath;
  PEMRStrokeAndFillPath = PEMRFillPath;
  EMRStrokePath = TEMRFillPath;
  PEMRStrokePath = PEMRFillPath;

  PEMRExcludeClipRect = ^TEMRExcludeClipRect;
  {$EXTERNALSYM tagEMREXCLUDECLIPRECT}
  tagEMREXCLUDECLIPRECT = packed record
    emr: TEMR;
    rclClip: TRect;
  end;
  TEMRExcludeClipRect = tagEMREXCLUDECLIPRECT;
  {$EXTERNALSYM EMREXCLUDECLIPRECT}
  EMREXCLUDECLIPRECT = tagEMREXCLUDECLIPRECT;
  EMRIntersectClipRect = TEMRExcludeClipRect;
  PEMRIntersectClipRect = PEMRExcludeClipRect;

  PEMRSetViewportOrgEx = ^TEMRSetViewportOrgEx;
  {$EXTERNALSYM tagEMRSETVIEWPORTORGEX}
  tagEMRSETVIEWPORTORGEX = packed record
    emr: TEMR;
    ptlOrigin: TPoint;
  end;
  TEMRSetViewportOrgEx = tagEMRSETVIEWPORTORGEX;
  {$EXTERNALSYM EMRSETVIEWPORTORGEX}
  EMRSETVIEWPORTORGEX = tagEMRSETVIEWPORTORGEX;
  EMRSetWindowOrgEx = TEMRSetViewportOrgEx;
  PEMRSetWindowOrgEx = PEMRSetViewportOrgEx;
  EMRSetBrushOrgEx = TEMRSetViewportOrgEx;
  PEMRSetBrushOrgEx = PEMRSetViewportOrgEx;

  PEMRSetViewportExtEx = ^TEMRSetViewportExtEx;
  {$EXTERNALSYM tagEMRSETVIEWPORTEXTEX}
  tagEMRSETVIEWPORTEXTEX = packed record
    emr: TEMR;
    szlExtent: TSize;
  end;
  TEMRSetViewportExtEx = tagEMRSETVIEWPORTEXTEX;
  {$EXTERNALSYM EMRSETVIEWPORTEXTEX}
  EMRSETVIEWPORTEXTEX = tagEMRSETVIEWPORTEXTEX;
  EMRSetWindowExtEx = TEMRSetViewportExtEx;
  PEMRSetWindowExtEx = PEMRSetViewportExtEx;

  PEMRScaleViewportExtEx = ^TEMRScaleViewportExtEx;
  {$EXTERNALSYM tagEMRSCALEVIEWPORTEXTEX}
  tagEMRSCALEVIEWPORTEXTEX = packed record
    emr: TEMR;
    xNum: Longint;
    xDenom: Longint;
    yNum: Longint;
    yDenom: Longint;
  end;
  TEMRScaleViewportExtEx = tagEMRSCALEVIEWPORTEXTEX;
  {$EXTERNALSYM EMRSCALEVIEWPORTEXTEX}
  EMRSCALEVIEWPORTEXTEX = tagEMRSCALEVIEWPORTEXTEX;
  EMRScaleWindowExtEx = TEMRScaleViewportExtEx;
  PEMRScaleWindowExtEx = PEMRScaleViewportExtEx;

  PEMRSetWorldTransform = ^TEMRSetWorldTransform;
  {$EXTERNALSYM tagEMRSETWORLDTRANSFORM}
  tagEMRSETWORLDTRANSFORM = packed record
    emr: TEMR;
    xform: TXForm;
  end;
  TEMRSetWorldTransform = tagEMRSETWORLDTRANSFORM;
  {$EXTERNALSYM EMRSETWORLDTRANSFORM}
  EMRSETWORLDTRANSFORM = tagEMRSETWORLDTRANSFORM;

  PEMRModifyWorldTransform = ^TEMRModifyWorldTransform;
  {$EXTERNALSYM tagEMRMODIFYWORLDTRANSFORM}
  tagEMRMODIFYWORLDTRANSFORM = packed record
    emr: TEMR;
    xform: TXForm;
    iMode: DWORD;
  end;
  TEMRModifyWorldTransform = tagEMRMODIFYWORLDTRANSFORM;
  {$EXTERNALSYM EMRMODIFYWORLDTRANSFORM}
  EMRMODIFYWORLDTRANSFORM = tagEMRMODIFYWORLDTRANSFORM;

  PEMRSetPixelV = ^TEMRSetPixelV;
  {$EXTERNALSYM tagEMRSETPIXELV}
  tagEMRSETPIXELV = packed record
    emr: TEMR;
    ptlPixel: TPoint;
    crColor: COLORREF;
  end;
  TEMRSetPixelV = tagEMRSETPIXELV;
  {$EXTERNALSYM EMRSETPIXELV}
  EMRSETPIXELV = tagEMRSETPIXELV;

  PEMRExtFloodFill = ^TEMRExtFloodFill;
  {$EXTERNALSYM tagEMREXTFLOODFILL}
  tagEMREXTFLOODFILL = packed record
    emr: TEMR;
    ptlStart: TPoint;
    crColor: COLORREF;
    iMode: DWORD;
  end;
  TEMRExtFloodFill = tagEMREXTFLOODFILL;
  {$EXTERNALSYM EMREXTFLOODFILL}
  EMREXTFLOODFILL = tagEMREXTFLOODFILL;

  PEMREllipse = ^TEMREllipse;
  {$EXTERNALSYM tagEMRELLIPSE}
  tagEMRELLIPSE = packed record
    emr: TEMR;
    rclBox: TRect; { Inclusive-inclusive bounding rectangle}
  end;
  TEMREllipse = tagEMRELLIPSE;
  {$EXTERNALSYM EMRELLIPSE}
  EMRELLIPSE = tagEMRELLIPSE;
  EMRRectangle = TEMREllipse;
  PEMRRectangle = PEMREllipse;

  PEMRRoundRect = ^TEMRRoundRect;
  {$EXTERNALSYM tagEMRROUNDRECT}
  tagEMRROUNDRECT = packed record
    emr: TEMR;
    rclBox: TRect;     { Inclusive-inclusive bounding rectangle }
    szlCorner: TSize;
  end;
  TEMRRoundRect = tagEMRROUNDRECT;
  {$EXTERNALSYM EMRROUNDRECT}
  EMRROUNDRECT = tagEMRROUNDRECT;

  PEMRArc = ^TEMRArc;
  {$EXTERNALSYM tagEMRARC}
  tagEMRARC = packed record
    emr: TEMR;
    rclBox: TRect;     { Inclusive-inclusive bounding rectangle }
    ptlStart: TPoint;
    ptlEnd: TPoint;
  end;
  TEMRArc = tagEMRARC;
  {$EXTERNALSYM EMRARC}
  EMRARC = tagEMRARC;
  EMRArcTo = TEMRArc;
  PEMRArcTo = PEMRArc;
  EMRChord = TEMRArc;
  PEMRChord = PEMRArc;
  EMRPie = TEMRArc;
  PEMRPie = PEMRArc;

  PEMRAngleArc = ^TEMRAngleArc;
  {$EXTERNALSYM tagEMRANGLEARC}
  tagEMRANGLEARC = packed record
    emr: TEMR;
    ptlCenter: TPoint;
    nRadius: DWORD;
    eStartAngle: Single;
    eSweepAngle: Single;
  end;
  TEMRAngleArc = tagEMRANGLEARC;
  {$EXTERNALSYM EMRANGLEARC}
  EMRANGLEARC = tagEMRANGLEARC;

  PEMRPolyline = ^TEMRPolyline;
  {$EXTERNALSYM tagEMRPOLYLINE}
  tagEMRPOLYLINE = packed record
    emr: TEMR;
    rclBounds: TRect;    { Inclusive-inclusive bounds in device units }
    cptl: DWORD;
    aptl: array[0..0] of TPoint;
  end;
  TEMRPolyline = tagEMRPOLYLINE;
  {$EXTERNALSYM EMRPOLYLINE}
  EMRPOLYLINE = tagEMRPOLYLINE;
  EMRPolyBezier = TEMRPolyLine;
  PEMRPolyBezier = PEMRPolyLine;
  EMRPolyGON = TEMRPolyLine;
  PEMRPolyGON = PEMRPolyLine;
  EMRPolyBezierTo = TEMRPolyLine;
  PEMRPolyBezierTo = PEMRPolyLine;
  EMRPolyLineTo = TEMRPolyLine;
  PEMRPolyLineTo = PEMRPolyLine;

  PEMRPolyline16 = ^TEMRPolyline16;
  {$EXTERNALSYM tagEMRPOLYLINE16}
  tagEMRPOLYLINE16 = packed record
    emr: TEMR;
    rclBounds: TRect; { Inclusive-inclusive bounds in device units}
    cpts: DWORD;
    apts: array[0..0] of TSmallPoint;
  end;
  TEMRPolyline16 = tagEMRPOLYLINE16;
  {$EXTERNALSYM EMRPOLYLINE16}
  EMRPOLYLINE16 = tagEMRPOLYLINE16;
  EMRPolyBezier16 = TEMRPolyLine16;
  PEMRPolyBezier16 = PEMRPolyLine16;
  EMRPolygon16 = TEMRPolyLine16;
  PEMRPolygon16 = PEMRPolyLine16;
  EMRPolyBezierTo16 = TEMRPolyLine16;
  PEMRPolyBezierTo16 = PEMRPolyLine16;
  EMRPolyLineTo16 = TEMRPolyLine16;
  PEMRPolyLineTo16 = PEMRPolyLine16;

  PEMRPolyDraw = ^TEMRPolyDraw;
  {$EXTERNALSYM tagEMRPOLYDRAW}
  tagEMRPOLYDRAW = record
    emr: TEMR;
    rclBounds: TRect;    { Inclusive-inclusive bounds in device units}
    cptl: DWORD;         { Number of points}
    aptl: array[0..0] of TPoint;  { Array of points}
    abTypes: array[0..0] of Byte; { Array of point types}
  end;
  TEMRPolyDraw = tagEMRPOLYDRAW;
  {$EXTERNALSYM EMRPOLYDRAW}
  EMRPOLYDRAW = tagEMRPOLYDRAW;

  PEMRPolyDraw16 = ^TEMRPolyDraw16;
  {$EXTERNALSYM tagEMRPOLYDRAW16}
  tagEMRPOLYDRAW16 = record
    emr: TEMR;
    rclBounds: TRect;
    cpts: DWORD;
    apts: array[0..0] of TSmallPoint;
    abTypes: array[0..0] of Byte;
  end;
  TEMRPolyDraw16 = tagEMRPOLYDRAW16;
  {$EXTERNALSYM EMRPOLYDRAW16}
  EMRPOLYDRAW16 = tagEMRPOLYDRAW16;

  PEMRPolyPolyline = ^TEMRPolyPolyline;
  {$EXTERNALSYM tagEMRPOLYPOLYLINE}
  tagEMRPOLYPOLYLINE = packed record
    emr: TEMR;
    rclBounds: TRect; { Inclusive-inclusive bounds in device units}
    nPolys: DWORD;    { Number of polys}
    cptl: DWORD;      { Total number of points in all polys}
    aPolyCounts: array[0..0] of DWORD; { Array of point counts for each poly}
    aptl: array[0..0] of TPoint;       { Array of points}
  end;
  TEMRPolyPolyline = tagEMRPOLYPOLYLINE;
  {$EXTERNALSYM EMRPOLYPOLYLINE}
  EMRPOLYPOLYLINE = tagEMRPOLYPOLYLINE;
  EMRPolyPolygon = TEMRPolyPolyline;
  PEMRPolyPolygon = PEMRPolyPolyline;

  PEMRPolyPolyline16 = ^TEMRPolyPolyline16;
  {$EXTERNALSYM tagEMRPOLYPOLYLINE16}
  tagEMRPOLYPOLYLINE16 = packed record
    emr: TEMR;
    rclBounds: TRect;
    nPolys: DWORD;
    cpts: DWORD;
    aPolyCounts: array[0..0] of DWORD;
    apts: array[0..0] of TSmallPoint;
  end;
  TEMRPolyPolyline16 = tagEMRPOLYPOLYLINE16;
  {$EXTERNALSYM EMRPOLYPOLYLINE16}
  EMRPOLYPOLYLINE16 = tagEMRPOLYPOLYLINE16;
  EMRPolyPolygon16 = TEMRPolyPolyline16;
  PEMRPolyPolygon16 = PEMRPolyPolyline16;

  PEMRInvertRgn = ^TEMRInvertRgn;
  {$EXTERNALSYM tagEMRINVERTRGN}
  tagEMRINVERTRGN = record
    emr: TEMR;
    rclBounds: TRect; { Inclusive-inclusive bounds in device units }
    cbRgnData: DWORD; { Size of region data in bytes}
    RgnData: array[0..0] of Byte;
  end;
  TEMRInvertRgn = tagEMRINVERTRGN;
  {$EXTERNALSYM EMRINVERTRGN}
  EMRINVERTRGN = tagEMRINVERTRGN;
  EMRPaintRgn = TEMRInvertRgn;
  PEMRPaintRgn = PEMRInvertRgn;

  PEMRFillRgn = ^TEMRFillRgn;
  {$EXTERNALSYM tagEMRFILLRGN}
  tagEMRFILLRGN = record
    emr: TEMR;
    rclBounds: TRect;  { Inclusive-inclusive bounds in device units}
    cbRgnData: DWORD;  { Size of region data in bytes}
    ihBrush: DWORD;    { Brush handle index }
    RgnData: array[0..0] of Byte;
  end;
  TEMRFillRgn = tagEMRFILLRGN;
  {$EXTERNALSYM EMRFILLRGN}
  EMRFILLRGN = tagEMRFILLRGN;

  PEMRFrameRgn = ^TEMRFrameRgn;
  {$EXTERNALSYM tagEMRFRAMERGN}
  tagEMRFRAMERGN = record
    emr: TEMR;
    rclBounds: TRect;   { Inclusive-inclusive bounds in device units}
    cbRgnData: DWORD;   { Size of region data in bytes}
    ihBrush: DWORD;     { Brush handle index}
    szlStroke: TSize;
    RgnData: array[0..0] of Byte;
  end;
  TEMRFrameRgn = tagEMRFRAMERGN;
  {$EXTERNALSYM EMRFRAMERGN}
  EMRFRAMERGN = tagEMRFRAMERGN;

  {$EXTERNALSYM PEMGradientFill}
  PEMGradientFill = ^TEMGradientFill;
  {$EXTERNALSYM tagEMRGRADIENTFILL}
  tagEMRGRADIENTFILL = record
    emr: TEMR;
    rclBounds: TRect;   { Inclusive-inclusive bounds in device units}
    nVer: DWORD;
    nTri: DWORD;
    ulMode: ULONG;
    Ver: array[0..0] of TTriVertex;
  end;
  {$EXTERNALSYM TEMGradientFill}
  TEMGradientFill = tagEMRGRADIENTFILL;
  {$EXTERNALSYM EMRGRADIENTFILL}
  EMRGRADIENTFILL = tagEMRGRADIENTFILL;

  PEMRExtSelectClipRgn = ^TEMRExtSelectClipRgn;
  {$EXTERNALSYM tagEMREXTSELECTCLIPRGN}
  tagEMREXTSELECTCLIPRGN = record
    emr: TEMR;
    cbRgnData: DWORD; { Size of region data in bytes}
    iMode: DWORD;
    RgnData: array[0..0] of Byte;
  end;
  TEMRExtSelectClipRgn = tagEMREXTSELECTCLIPRGN;
  {$EXTERNALSYM EMREXTSELECTCLIPRGN}
  EMREXTSELECTCLIPRGN = tagEMREXTSELECTCLIPRGN;

  PEMRExtTextOut = ^TEMRExtTextOut;
  {$EXTERNALSYM tagEMREXTTEXTOUTA}
  tagEMREXTTEXTOUTA = packed record
    emr: TEMR;
    rclBounds: TRect;     { Inclusive-inclusive bounds in device units}
    iGraphicsMode: DWORD; { Current graphics mode}
    exScale: Single;       { X and Y scales from Page units to .01mm units}
    eyScale: Single;       {   if graphics mode is GM_COMPATIBLE.}
    emrtext: TEMRText;    { This is followed by the string and spacing array}
  end;
  TEMRExtTextOut = tagEMREXTTEXTOUTA;
  {$EXTERNALSYM EMREXTTEXTOUTA}
  EMREXTTEXTOUTA = tagEMREXTTEXTOUTA;

  PEMRPolyTextOut = ^TEMRPolyTextOut;
  {$EXTERNALSYM tagEMRPOLYTEXTOUTA}
  tagEMRPOLYTEXTOUTA = packed record
    emr: TEMR;
    rclBounds: TRect;     { Inclusive-inclusive bounds in device units}
    iGraphicsMode: DWORD; { Current graphics mode}
    exScale: Single;       { X and Y scales from Page units to .01mm units}
    eyScale: Single;       {   if graphics mode is GM_COMPATIBLE.}
    cStrings: Longint;
    aemrtext: array[0..0] of TEMRText; { array of TEMRText structures.  This is}
                                       { followed by the strings and spacing arrays.}
  end;
  TEMRPolyTextOut = tagEMRPOLYTEXTOUTA;
  {$EXTERNALSYM EMRPOLYTEXTOUTA}
  EMRPOLYTEXTOUTA = tagEMRPOLYTEXTOUTA;

  PEMRBitBlt = ^TEMRBitBlt;
  {$EXTERNALSYM tagEMRBITBLT}
  tagEMRBITBLT = packed record
    emr: TEMR;
    rclBounds: TRect;        { Inclusive-inclusive bounds in device units}
    xDest: Longint;
    yDest: Longint;
    cxDest: Longint;
    cyDest: Longint;
    dwRop: DWORD;
    xSrc: Longint;
    ySrc: Longint;
    xformSrc: TXForm;        { Source DC transform}
    crBkColorSrc: COLORREF; { Source DC BkColor in RGB}
    iUsageSrc: DWORD;        { Source bitmap info color table usage}
                             { (DIB_RGB_COLORS)}
    offBmiSrc: DWORD;        { Offset to the source TBitmapInfo structure}
    cbBmiSrc: DWORD;         { Size of the source TBitmapInfo structure}
    offBitsSrc: DWORD;       { Offset to the source bitmap bits}
    cbBitsSrc: DWORD;        { Size of the source bitmap bits}
  end;
  TEMRBitBlt = tagEMRBITBLT;
  {$EXTERNALSYM EMRBITBLT}
  EMRBITBLT = tagEMRBITBLT;

  PEMRStretchBlt = ^TEMRStretchBlt;
  {$EXTERNALSYM tagEMRSTRETCHBLT}
  tagEMRSTRETCHBLT = packed record
    emr: TEMR;
    rclBounds: TRect; { Inclusive-inclusive bounds in device units}
    xDest: Longint;
    yDest: Longint;
    cxDest: Longint;
    cyDest: Longint;
    dwRop: DWORD;
    xSrc: Longint;
    ySrc: Longint;
    xformSrc: TXForm;        { Source DC transform}
    crBkColorSrc: COLORREF; { Source DC BkColor in RGB}
    iUsageSrc: DWORD;        { Source bitmap info color table usage}
                             { (DIB_RGB_COLORS)}
    offBmiSrc: DWORD;        { Offset to the source TBitmapInfo structure}
    cbBmiSrc: DWORD;         { Size of the source TBitmapInfo structure}
    offBitsSrc: DWORD;       { Offset to the source bitmap bits}
    cbBitsSrc: DWORD;        { Size of the source bitmap bits}
    cxSrc: Longint;
    cySrc: Longint;
  end;
  TEMRStretchBlt = tagEMRSTRETCHBLT;
  {$EXTERNALSYM EMRSTRETCHBLT}
  EMRSTRETCHBLT = tagEMRSTRETCHBLT;

  PEMRMaskBlt = ^TEMRMaskBlt;
  {$EXTERNALSYM tagEMRMASKBLT}
  tagEMRMASKBLT = packed record
    emr: TEMR;
    rclBounds: TRect;        { Inclusive-inclusive bounds in device units}
    xDest: Longint;
    yDest: Longint;
    cxDest: Longint;
    cyDest: Longint;
    dwRop: DWORD;
    xSrc: Longint;
    ySrc: Longint;
    xformSrc: TXForm;        { Source DC transform}
    crBkColorSrc: COLORREF; { Source DC BkColor in RGB}
    iUsageSrc: DWORD;        { Source bitmap info color table usage}
                             { (DIB_RGB_COLORS)}
    offBmiSrc: DWORD;        { Offset to the source TBitmapInfo structure}
    cbBmiSrc: DWORD;         { Size of the source TBitmapInfo structure}
    offBitsSrc: DWORD;       { Offset to the source bitmap bits}
    cbBitsSrc: DWORD;        { Size of the source bitmap bits}
    xMask: Longint;
    yMask: Longint;
    iUsageMask: DWORD;       { Mask bitmap info color table usage}
    offBmiMask: DWORD;       { Offset to the mask TBitmapInfo structure if any}
    cbBmiMask: DWORD;        { Size of the mask TBitmapInfo structure if any}
    offBitsMask: DWORD;      { Offset to the mask bitmap bits if any}
    cbBitsMask: DWORD;       { Size of the mask bitmap bits if any}
  end;
  TEMRMaskBlt = tagEMRMASKBLT;
  {$EXTERNALSYM EMRMASKBLT}
  EMRMASKBLT = tagEMRMASKBLT;

  PEMRPLGBlt = ^TEMRPLGBlt;
  {$EXTERNALSYM tagEMRPLGBLT}
  tagEMRPLGBLT = packed record
    emr: TEMR;
    rclBounds: TRect;
    aptlDest: array[0..2] of TPoint;
    xSrc: Longint;
    ySrc: Longint;
    cxSrc: Longint;
    cySrc: Longint;
    xformSrc: TXForm;        { Source DC transform}
    crBkColorSrc: COLORREF; { Source DC BkColor in RGB}
    iUsageSrc: DWORD;        { Source bitmap info color table usage}
                             { (DIB_RGB_COLORS)}
    offBmiSrc: DWORD;        { Offset to the source TBitmapInfo structure}
    cbBmiSrc: DWORD;         { Size of the source TBitmapInfo structure}
    offBitsSrc: DWORD;       { Offset to the source bitmap bits}
    cbBitsSrc: DWORD;        { Size of the source bitmap bits}
    xMask: Longint;
    yMask: Longint;
    iUsageMask: DWORD;       { Mask bitmap info color table usage}
    offBmiMask: DWORD;       { Offset to the mask TBitmapInfo structure if any}
    cbBmiMask: DWORD;        { Size of the mask TBitmapInfo structure if any}
    offBitsMask: DWORD;      { Offset to the mask bitmap bits if any}
    cbBitsMask: DWORD;       { Size of the mask bitmap bits if any}
  end;
  TEMRPLGBlt = tagEMRPLGBLT;
  {$EXTERNALSYM EMRPLGBLT}
  EMRPLGBLT = tagEMRPLGBLT;

  PEMRSetDIBitsToDevice = ^TEMRSetDIBitsToDevice;
  {$EXTERNALSYM tagEMRSETDIBITSTODEVICE}
  tagEMRSETDIBITSTODEVICE = packed record
    emr: TEMR;
    rclBounds: TRect;
    xDest: Longint;
    yDest: Longint;
    xSrc: Longint;
    ySrc: Longint;
    cxSrc: Longint;
    cySrc: Longint;
    offBmiSrc: DWORD;        { Offset to the source TBitmapInfo structure}
    cbBmiSrc: DWORD;         { Size of the source TBitmapInfo structure}
    offBitsSrc: DWORD;       { Offset to the source bitmap bits}
    cbBitsSrc: DWORD;        { Size of the source bitmap bits}
    iUsageSrc: DWORD;        { Source bitmap info color table usage}
    iStartScan: DWORD;
    cScans: DWORD;
  end;
  TEMRSetDIBitsToDevice = tagEMRSETDIBITSTODEVICE;
  {$EXTERNALSYM EMRSETDIBITSTODEVICE}
  EMRSETDIBITSTODEVICE = tagEMRSETDIBITSTODEVICE;

  PEMRStretchDIBits = ^TEMRStretchDIBits;
  {$EXTERNALSYM tagEMRSTRETCHDIBITS}
  tagEMRSTRETCHDIBITS = packed record
    emr: TEMR;
    rclBounds: TRect;
    xDest: Longint;
    yDest: Longint;
    xSrc: Longint;
    ySrc: Longint;
    cxSrc: Longint;
    cySrc: Longint;
    offBmiSrc: DWORD;        { Offset to the source TBitmapInfo structure}
    cbBmiSrc: DWORD;         { Size of the source TBitmapInfo structure}
    offBitsSrc: DWORD;       { Offset to the source bitmap bits}
    cbBitsSrc: DWORD;        { Size of the source bitmap bits}
    iUsageSrc: DWORD;        { Source bitmap info color table usage}
    dwRop: DWORD;
    cxDest: Longint;
    cyDest: Longint;
  end;
  TEMRStretchDIBits = tagEMRSTRETCHDIBITS;
  {$EXTERNALSYM EMRSTRETCHDIBITS}
  EMRSTRETCHDIBITS = tagEMRSTRETCHDIBITS;

  {$EXTERNALSYM PEMRAlphaBlend}
  PEMRAlphaBlend = ^TEMRAlphaBlend;
  {$EXTERNALSYM tagEMRALPHABLEND}
  tagEMRALPHABLEND = packed record
    emr: TEMR;
    rclBounds: TRect;
    xDest: Longint;
    yDest: Longint;
    cxDest: Longint;
    cyDest: Longint;
    dwRop: DWORD;
    xSrc: Longint;
    ySrc: Longint;
    xformSrc: XFORM;         { Source DC transform}
    crBkColorSrc: COLORREF;  { Source DC BkColor in RGB}
    iUsageSrc: DWORD;        { Source bitmap info color table usage}
    offBmiSrc: DWORD;        { Offset to the source TBitmapInfo structure}
    cbBmiSrc: DWORD;         { Size of the source TBitmapInfo structure}
    offBitsSrc: DWORD;       { Offset to the source bitmap bits}
    cbBitsSrc: DWORD;        { Size of the source bitmap bits}
    cxSrc: Longint;
    cySrc: Longint;
  end;
  {$EXTERNALSYM TEMRAlphaBlend}
  TEMRAlphaBlend = tagEMRALPHABLEND;
  {$EXTERNALSYM EMRALPHABLEND}
  EMRALPHABLEND = tagEMRALPHABLEND;

  PEMRTransparentBLT = ^TEMRTransparentBLT;
  {$EXTERNALSYM tagEMRTRANSPARENTBLT}
  tagEMRTRANSPARENTBLT = packed record
    emr: TEMR;
    rclBounds: TRect;
    xDest: Longint;
    yDest: Longint;
    cxDest: Longint;
    cyDest: Longint;
    dwRop: DWORD;
    xSrc: Longint;
    ySrc: Longint;
    xformSrc: XFORM;         { Source DC transform}
    crBkColorSrc: COLORREF;  { Source DC BkColor in RGB}
    iUsageSrc: DWORD;        { Source bitmap info color table usage}
    offBmiSrc: DWORD;        { Offset to the source TBitmapInfo structure}
    cbBmiSrc: DWORD;         { Size of the source TBitmapInfo structure}
    offBitsSrc: DWORD;       { Offset to the source bitmap bits}
    cbBitsSrc: DWORD;        { Size of the source bitmap bits}
    cxSrc: Longint;
    cySrc: Longint;
  end;
  TEMRTransparentBLT = tagEMRTRANSPARENTBLT;
  {$EXTERNALSYM EMRTRANSPARENTBLT}
  EMRTRANSPARENTBLT = tagEMRTRANSPARENTBLT;

  PEMRExtCreateFontIndirect = ^TEMRExtCreateFontIndirect;
  {$EXTERNALSYM tagEMREXTCREATEFONTINDIRECTW}
  tagEMREXTCREATEFONTINDIRECTW = record
    emr: TEMR;
    ihFont: DWORD;     { Font handle index}
    elfw: TExtLogFontW;
  end;
  TEMRExtCreateFontIndirect = tagEMREXTCREATEFONTINDIRECTW;
  {$EXTERNALSYM EMREXTCREATEFONTINDIRECTW}
  EMREXTCREATEFONTINDIRECTW = tagEMREXTCREATEFONTINDIRECTW;

  PEMRCreatePalette = ^TEMRCreatePalette;
  {$EXTERNALSYM tagEMRCREATEPALETTE}
  tagEMRCREATEPALETTE = packed record
    emr: TEMR;
    ihPal: DWORD;        { Palette handle index}
    lgpl: TLogPalette;   { The peFlags fields in the palette entries}
                         { do not contain any flags}
  end;
  TEMRCreatePalette = tagEMRCREATEPALETTE;
  {$EXTERNALSYM EMRCREATEPALETTE}
  EMRCREATEPALETTE = tagEMRCREATEPALETTE;

  PEMRCreateColorSpace = ^TEMRCreateColorSpace;
  {$EXTERNALSYM tagEMRCREATECOLORSPACE}
  tagEMRCREATECOLORSPACE = packed record
    emr: TEMR;
    ihCS: DWORD;          { ColorSpace handle index}
    lcs: TLogColorSpaceW;
  end;
  TEMRCreateColorSpace = tagEMRCREATECOLORSPACE;
  {$EXTERNALSYM EMRCREATECOLORSPACE}
  EMRCREATECOLORSPACE = tagEMRCREATECOLORSPACE;

  PEMRCreatePen = ^TEMRCreatePen;
  {$EXTERNALSYM tagEMRCREATEPEN}
  tagEMRCREATEPEN = packed record
    emr: TEMR;
    ihPen: DWORD;   { Pen handle index}
    lopn: TLogPen;
  end;
  TEMRCreatePen = tagEMRCREATEPEN;
  {$EXTERNALSYM EMRCREATEPEN}
  EMRCREATEPEN = tagEMRCREATEPEN;

  PEMRExtCreatePen = ^TEMRExtCreatePen;
  {$EXTERNALSYM tagEMREXTCREATEPEN}
  tagEMREXTCREATEPEN = packed record
    emr: TEMR;
    ihPen: DWORD;      { Pen handle index}
    offBmi: DWORD;     { Offset to the TBitmapInfo structure if any}
    cbBmi: DWORD;      { Size of the TBitmapInfo structure if any}
                       { The bitmap info is followed by the bitmap}
                       { bits to form a packed DIB.}
    offBits: DWORD;    { Offset to the brush bitmap bits if any}
    cbBits: DWORD;     { Size of the brush bitmap bits if any}
    elp: TExtLogPen;   { The extended pen with the style array.}
  end;
  TEMRExtCreatePen = tagEMREXTCREATEPEN;
  {$EXTERNALSYM EMREXTCREATEPEN}
  EMREXTCREATEPEN = tagEMREXTCREATEPEN;

  PEMRCreateBrushIndirect = ^TEMRCreateBrushIndirect;
  {$EXTERNALSYM tagEMRCREATEBRUSHINDIRECT}
  tagEMRCREATEBRUSHINDIRECT = packed record
    emr: TEMR;
    ihBrush: DWORD; { Brush handle index}
    lb: TLogBrush;  { The style must be BS_SOLID, BS_HOLLOW,}
                    { BS_NULL or BS_HATCHED.}
  end;
  TEMRCreateBrushIndirect = tagEMRCREATEBRUSHINDIRECT;
  {$EXTERNALSYM EMRCREATEBRUSHINDIRECT}
  EMRCREATEBRUSHINDIRECT = tagEMRCREATEBRUSHINDIRECT;

  PEMRCreateMonoBrush = ^TEMRCreateMonoBrush;
  {$EXTERNALSYM tagEMRCREATEMONOBRUSH}
  tagEMRCREATEMONOBRUSH = packed record
    emr: TEMR;
    ihBrush: DWORD; { Brush handle index}
    iUsage: DWORD;  { Bitmap info color table usage}
    offBmi: DWORD;  { Offset to the TBitmapInfo structure}
    cbBmi: DWORD;   { Size of the TBitmapInfo structure if any}
                    { The bitmap info is followed by the bitmap}
                    { bits to form a packed DIB.}
    offBits: DWORD; { Offset to the bitmap bits}
    cbBits: DWORD;  { Size of the bitmap bits}
  end;
  TEMRCreateMonoBrush = tagEMRCREATEMONOBRUSH;
  {$EXTERNALSYM EMRCREATEMONOBRUSH}
  EMRCREATEMONOBRUSH = tagEMRCREATEMONOBRUSH;

  PEMRCreateDIBPatternBrushPt = ^TEMRCreateDIBPatternBrushPt;
  {$EXTERNALSYM tagEMRCREATEDIBPATTERNBRUSHPT}
  tagEMRCREATEDIBPATTERNBRUSHPT = packed record
    emr: TEMR;
    ihBrush: DWORD; { Brush handle index}
    iUsage: DWORD;  { Bitmap info color table usage}
    offBmi: DWORD;  { Offset to the TBitmapInfo structure}
    cbBmi: DWORD;   { Size of the TBitmapInfo structure if any}
                    { The bitmap info is followed by the bitmap}
                    { bits to form a packed DIB.}
    offBits: DWORD; { Offset to the bitmap bits}
    cbBits: DWORD;  { Size of the bitmap bits}
  end;
  TEMRCreateDIBPatternBrushPt = tagEMRCREATEDIBPATTERNBRUSHPT;
  {$EXTERNALSYM EMRCREATEDIBPATTERNBRUSHPT}
  EMRCREATEDIBPATTERNBRUSHPT = tagEMRCREATEDIBPATTERNBRUSHPT;

  PEMRFormat = ^TEMRFormat;
  {$EXTERNALSYM tagEMRFORMAT}
  tagEMRFORMAT = packed record
    dSignature: DWORD; { Format signature, e.g. ENHMETA_SIGNATURE.}
    nVersion: DWORD;   { Format version number.}
    cbData: DWORD;     { Size of data in bytes.}
    offData: DWORD;    { Offset to data from GDICOMMENT_IDENTIFIER.}
                       { It must begin at a DWORD offset.}
  end;
  TEMRFormat = tagEMRFORMAT;
  {$EXTERNALSYM EMRFORMAT}
  EMRFORMAT = tagEMRFORMAT;

  PEMRGLSRecord = ^TEMRGLSRecord;
  {$EXTERNALSYM tagEMRGLSRECORD}
  tagEMRGLSRECORD = packed record
    emr: TEMR;
    cbData: DWORD;              { Size of data in bytes }
    Data: packed array[0..0] of Byte;
  end;
  TEMRGLSRecord = tagEMRGLSRECORD;
  {$EXTERNALSYM EMRGLSRECORD}
  EMRGLSRECORD = tagEMRGLSRECORD;


  PEMRGLSBoundedRecord = ^TEMRGLSBoundedRecord;
  {$EXTERNALSYM tagEMRGLSBOUNDEDRECORD}
  tagEMRGLSBOUNDEDRECORD = packed record
    emr: TEMR;
    rclBounds: TRect;           { Bounds in recording coordinates }
    cbData: DWORD;              { Size of data in bytes }
    Data: packed array[0..0] of Byte;
  end;
  TEMRGLSBoundedRecord = tagEMRGLSBOUNDEDRECORD;
  {$EXTERNALSYM EMRGLSBOUNDEDRECORD}
  EMRGLSBOUNDEDRECORD = tagEMRGLSBOUNDEDRECORD;

  PEMRPixelFormat = ^TEMRPixelFormat;
  {$EXTERNALSYM tagEMRPIXELFORMAT}
  tagEMRPIXELFORMAT = packed record
    emr: TEMR;
    pfd: TPixelFormatDescriptor;
  end;
  TEMRPixelFormat = tagEMRPIXELFORMAT;
  {$EXTERNALSYM EMRPIXELFORMAT}
  EMRPIXELFORMAT = tagEMRPIXELFORMAT;

const
  {$EXTERNALSYM GDICOMMENT_IDENTIFIER}
  GDICOMMENT_IDENTIFIER = $43494447;
  {$EXTERNALSYM GDICOMMENT_WINDOWS_METAFILE}
  GDICOMMENT_WINDOWS_METAFILE = DWORD($80000001);
  {$EXTERNALSYM GDICOMMENT_BEGINGROUP}
  GDICOMMENT_BEGINGROUP = 2;
  {$EXTERNALSYM GDICOMMENT_ENDGROUP}
  GDICOMMENT_ENDGROUP = 3;
  {$EXTERNALSYM GDICOMMENT_MULTIFORMATS}
  GDICOMMENT_MULTIFORMATS = $40000004;
  {$EXTERNALSYM EPS_SIGNATURE}
  EPS_SIGNATURE = $46535045;

{ OpenGL wgl prototypes}

{$EXTERNALSYM wglCopyContext}
function wglCopyContext(p1: HGLRC; p2: HGLRC; p3: Cardinal): BOOL; stdcall;
{$EXTERNALSYM wglCreateContext}
function wglCreateContext(DC: HDC): HGLRC; stdcall;
{$EXTERNALSYM wglCreateLayerContext}
function wglCreateLayerContext(p1: HDC; p2: Integer): HGLRC; stdcall;
{$EXTERNALSYM wglDeleteContext}
function wglDeleteContext(p1: HGLRC): BOOL; stdcall;
{$EXTERNALSYM wglGetCurrentContext:}
function wglGetCurrentContext: HGLRC; stdcall;
{$EXTERNALSYM wglGetCurrentDC:}
function wglGetCurrentDC: HDC; stdcall;
{$EXTERNALSYM wglMakeCurrent}
function wglMakeCurrent(DC: HDC; p2: HGLRC): BOOL; stdcall;
{$EXTERNALSYM wglShareLists}
function wglShareLists(p1, p2: HGLRC): BOOL; stdcall;
{$EXTERNALSYM wglUseFontBitmaps}
function wglUseFontBitmaps(DC: HDC; p2, p3, p4: DWORD): BOOL; stdcall;
{$EXTERNALSYM wglUseFontBitmapsA}
function wglUseFontBitmapsA(DC: HDC; p2, p3, p4: DWORD): BOOL; stdcall;
{$EXTERNALSYM wglUseFontBitmapsW}
function wglUseFontBitmapsW(DC: HDC; p2, p3, p4: DWORD): BOOL; stdcall;
{$EXTERNALSYM SwapBuffers}
function SwapBuffers(DC: HDC): BOOL; stdcall;

type
  PPointFloat = ^TPointFloat;
  {$EXTERNALSYM _POINTFLOAT}
  _POINTFLOAT = packed record
    x: Single;
    y: Single;
  end;
  TPointFloat = _POINTFLOAT;
  {$EXTERNALSYM POINTFLOAT}
  POINTFLOAT = _POINTFLOAT;

  PGlyphMetricsFloat = ^TGlyphMetricsFloat;
  {$EXTERNALSYM _GLYPHMETRICSFLOAT}
  _GLYPHMETRICSFLOAT = packed record
    gmfBlackBoxX: Single;
    gmfBlackBoxY: Single;
    gmfptGlyphOrigin: TPointFloat;
    gmfCellIncX: Single;
    gmfCellIncY: Single;
  end;
  TGlyphMetricsFloat = _GLYPHMETRICSFLOAT;
  {$EXTERNALSYM GLYPHMETRICSFLOAT}
  GLYPHMETRICSFLOAT = _GLYPHMETRICSFLOAT;

const
  {$EXTERNALSYM WGL_FONT_LINES}
  WGL_FONT_LINES = 0;
  {$EXTERNALSYM WGL_FONT_POLYGONS}
  WGL_FONT_POLYGONS = 1;

{$EXTERNALSYM wglUseFontOutlines}
function wglUseFontOutlines(p1: HDC; p2, p3, p4: DWORD;
  p5, p6: Single; p7: Integer; p8: PGlyphMetricsFloat): BOOL; stdcall;
{$EXTERNALSYM wglUseFontOutlinesA}
function wglUseFontOutlinesA(p1: HDC; p2, p3, p4: DWORD;
  p5, p6: Single; p7: Integer; p8: PGlyphMetricsFloat): BOOL; stdcall;
{$EXTERNALSYM wglUseFontOutlinesW}
function wglUseFontOutlinesW(p1: HDC; p2, p3, p4: DWORD;
  p5, p6: Single; p7: Integer; p8: PGlyphMetricsFloat): BOOL; stdcall;

{ Layer plane descriptor }
type
  PLayerPlaneDescriptor = ^TLayerPlaneDescriptor;
  {$EXTERNALSYM tagLAYERPLANEDESCRIPTOR}
  tagLAYERPLANEDESCRIPTOR = packed record   { lpd }
    nSize: Word;
    nVersion: Word;
    dwFlags: DWORD;
    iPixelType: Byte;
    cColorBits: Byte;
    cRedBits: Byte;
    cRedShift: Byte;
    cGreenBits: Byte;
    cGreenShift: Byte;
    cBlueBits: Byte;
    cBlueShift: Byte;
    cAlphaBits: Byte;
    cAlphaShift: Byte;
    cAccumBits: Byte;
    cAccumRedBits: Byte;
    cAccumGreenBits: Byte;
    cAccumBlueBits: Byte;
    cAccumAlphaBits: Byte;
    cDepthBits: Byte;
    cStencilBits: Byte;
    cAuxBuffers: Byte;
    iLayerPlane: Byte;
    bReserved: Byte;
    crTransparent: COLORREF;
  end;
  TLayerPlaneDescriptor = tagLAYERPLANEDESCRIPTOR;
  {$EXTERNALSYM LAYERPLANEDESCRIPTOR}
  LAYERPLANEDESCRIPTOR = tagLAYERPLANEDESCRIPTOR;


{ TLayerPlaneDescriptor flags }
const
  {$EXTERNALSYM LPD_DOUBLEBUFFER}
  LPD_DOUBLEBUFFER = $00000001;
  {$EXTERNALSYM LPD_STEREO}
  LPD_STEREO = $00000002;
  {$EXTERNALSYM LPD_SUPPORT_GDI}
  LPD_SUPPORT_GDI = $00000010;
  {$EXTERNALSYM LPD_SUPPORT_OPENGL}
  LPD_SUPPORT_OPENGL = $00000020;
  {$EXTERNALSYM LPD_SHARE_DEPTH}
  LPD_SHARE_DEPTH = $00000040;
  {$EXTERNALSYM LPD_SHARE_STENCIL}
  LPD_SHARE_STENCIL = $00000080;
  {$EXTERNALSYM LPD_SHARE_ACCUM}
  LPD_SHARE_ACCUM = $00000100;
  {$EXTERNALSYM LPD_SWAP_EXCHANGE}
  LPD_SWAP_EXCHANGE = $00000200;
  {$EXTERNALSYM LPD_SWAP_COPY}
  LPD_SWAP_COPY = $00000400;
  {$EXTERNALSYM LPD_TRANSPARENT}
  LPD_TRANSPARENT = $00001000;

  {$EXTERNALSYM LPD_TYPE_RGBA}
  LPD_TYPE_RGBA = 0;
  {$EXTERNALSYM LPD_TYPE_COLORINDEX}
  LPD_TYPE_COLORINDEX = 1;

{ wglSwapLayerBuffers flags }
  {$EXTERNALSYM WGL_SWAP_MAIN_PLANE}
  WGL_SWAP_MAIN_PLANE = $00000001;
  {$EXTERNALSYM WGL_SWAP_OVERLAY1}
  WGL_SWAP_OVERLAY1 = $00000002;
  {$EXTERNALSYM WGL_SWAP_OVERLAY2}
  WGL_SWAP_OVERLAY2 = $00000004;
  {$EXTERNALSYM WGL_SWAP_OVERLAY3}
  WGL_SWAP_OVERLAY3 = $00000008;
  {$EXTERNALSYM WGL_SWAP_OVERLAY4}
  WGL_SWAP_OVERLAY4 = $00000010;
  {$EXTERNALSYM WGL_SWAP_OVERLAY5}
  WGL_SWAP_OVERLAY5 = $00000020;
  {$EXTERNALSYM WGL_SWAP_OVERLAY6}
  WGL_SWAP_OVERLAY6 = $00000040;
  {$EXTERNALSYM WGL_SWAP_OVERLAY7}
  WGL_SWAP_OVERLAY7 = $00000080;
  {$EXTERNALSYM WGL_SWAP_OVERLAY8}
  WGL_SWAP_OVERLAY8 = $00000100;
  {$EXTERNALSYM WGL_SWAP_OVERLAY9}
  WGL_SWAP_OVERLAY9 = $00000200;
  {$EXTERNALSYM WGL_SWAP_OVERLAY10}
  WGL_SWAP_OVERLAY10 = $00000400;
  {$EXTERNALSYM WGL_SWAP_OVERLAY11}
  WGL_SWAP_OVERLAY11 = $00000800;
  {$EXTERNALSYM WGL_SWAP_OVERLAY12}
  WGL_SWAP_OVERLAY12 = $00001000;
  {$EXTERNALSYM WGL_SWAP_OVERLAY13}
  WGL_SWAP_OVERLAY13 = $00002000;
  {$EXTERNALSYM WGL_SWAP_OVERLAY14}
  WGL_SWAP_OVERLAY14 = $00004000;
  {$EXTERNALSYM WGL_SWAP_OVERLAY15}
  WGL_SWAP_OVERLAY15 = $00008000;
  {$EXTERNALSYM WGL_SWAP_UNDERLAY1}
  WGL_SWAP_UNDERLAY1 = $00010000;
  {$EXTERNALSYM WGL_SWAP_UNDERLAY2}
  WGL_SWAP_UNDERLAY2 = $00020000;
  {$EXTERNALSYM WGL_SWAP_UNDERLAY3}
  WGL_SWAP_UNDERLAY3 = $00040000;
  {$EXTERNALSYM WGL_SWAP_UNDERLAY4}
  WGL_SWAP_UNDERLAY4 = $00080000;
  {$EXTERNALSYM WGL_SWAP_UNDERLAY5}
  WGL_SWAP_UNDERLAY5 = $00100000;
  {$EXTERNALSYM WGL_SWAP_UNDERLAY6}
  WGL_SWAP_UNDERLAY6 = $00200000;
  {$EXTERNALSYM WGL_SWAP_UNDERLAY7}
  WGL_SWAP_UNDERLAY7 = $00400000;
  {$EXTERNALSYM WGL_SWAP_UNDERLAY8}
  WGL_SWAP_UNDERLAY8 = $00800000;
  {$EXTERNALSYM WGL_SWAP_UNDERLAY9}
  WGL_SWAP_UNDERLAY9 = $01000000;
  {$EXTERNALSYM WGL_SWAP_UNDERLAY10}
  WGL_SWAP_UNDERLAY10 = $02000000;
  {$EXTERNALSYM WGL_SWAP_UNDERLAY11}
  WGL_SWAP_UNDERLAY11 = $04000000;
  {$EXTERNALSYM WGL_SWAP_UNDERLAY12}
  WGL_SWAP_UNDERLAY12 = $08000000;
  {$EXTERNALSYM WGL_SWAP_UNDERLAY13}
  WGL_SWAP_UNDERLAY13 = $10000000;
  {$EXTERNALSYM WGL_SWAP_UNDERLAY14}
  WGL_SWAP_UNDERLAY14 = $20000000;
  {$EXTERNALSYM WGL_SWAP_UNDERLAY15}
  WGL_SWAP_UNDERLAY15 = $40000000;

{$EXTERNALSYM wglDescribeLayerPlane}
function wglDescribeLayerPlane(p1: HDC; p2, p3: Integer; p4: Cardinal;
  var p5: TLayerPlaneDescriptor): BOOL; stdcall;
{$EXTERNALSYM wglSetLayerPaletteEntries}
function wglSetLayerPaletteEntries(p1: HDC; p2, p3, p4: Integer;
  var pcr): Integer; stdcall;
{$EXTERNALSYM wglGetLayerPaletteEntries}
function wglGetLayerPaletteEntries(p1: HDC; p2, p3, p4: Integer;
  var pcr): Integer; stdcall;
{$EXTERNALSYM wglRealizeLayerPalette}
function wglRealizeLayerPalette(p1: HDC; p2: Integer; p3: BOOL): BOOL; stdcall;
{$EXTERNALSYM wglSwapLayerBuffers}
function wglSwapLayerBuffers(p1: HDC; p2: Cardinal): BOOL; stdcall;

type
  {$EXTERNALSYM PWGLSwap}
  PWGLSwap = ^TWGLSwap;
  {$EXTERNALSYM _WGLSWAP}
  _WGLSWAP = packed record
    hdc: HDC;
    uiFlags: UINT;
  end;
  {$EXTERNALSYM TWGLSwap}
  TWGLSwap = _WGLSWAP;
  {$EXTERNALSYM WGLSWAP}
  WGLSWAP = _WGLSWAP;

const
  {$EXTERNALSYM WGL_SWAPMULTIPLE_MAX}
  WGL_SWAPMULTIPLE_MAX = 16;

{$EXTERNALSYM wglSwapMultipleBuffers}
function wglSwapMultipleBuffers(p1: UINT; const p2: PWGLSwap): DWORD; stdcall;

{ Translated from WINUSER.H }

type
  {$EXTERNALSYM HDWP}
  HDWP = THandle;
  PMENUTEMPLATE = Pointer;
  {$EXTERNALSYM PMENUTEMPLATE}
  {$EXTERNALSYM va_list}
  va_list = PChar;










  TFNWndProc = TFarProc;
  TFNDlgProc = TFarProc;
  TFNTimerProc = TFarProc;
  TFNGrayStringProc = TFarProc;
  TFNWndEnumProc = TFarProc;
  TFNSendAsyncProc = TFarProc;
  TFNDrawStateProc = TFarProc;


  TFNHookProc = function (code: Integer; wparam: WPARAM; lparam: LPARAM): LRESULT stdcall;

type







  TFNPropEnumProc = TFarProc;
  TFNPropEnumProcEx = TFarProc;
  TFNEditWordBreakProc = TFarProc;
  TFNNameEnumProc = TFarProc;

  TFNWinStaEnumProc = TFNNameEnumProc;
  TFNDeskTopEnumProc = TFNNameEnumProc;

  MakeIntResourceA = PAnsiChar;
  MakeIntResourceW = PWideChar;
  MakeIntResource = MakeIntResourceA;

const
  { Predefined Resource Types }
  {$EXTERNALSYM RT_CURSOR}
  RT_CURSOR       = MakeIntResource(1);
  {$EXTERNALSYM RT_BITMAP}
  RT_BITMAP       = MakeIntResource(2);
  {$EXTERNALSYM RT_ICON}
  RT_ICON         = MakeIntResource(3);
  {$EXTERNALSYM RT_MENU}
  RT_MENU         = MakeIntResource(4);
  {$EXTERNALSYM RT_DIALOG}
  RT_DIALOG       = MakeIntResource(5);
  {$EXTERNALSYM RT_STRING}
  RT_STRING       = MakeIntResource(6);
  {$EXTERNALSYM RT_FONTDIR}
  RT_FONTDIR      = MakeIntResource(7);
  {$EXTERNALSYM RT_FONT}
  RT_FONT         = MakeIntResource(8);
  {$EXTERNALSYM RT_ACCELERATOR}
  RT_ACCELERATOR  = MakeIntResource(9);
  {$EXTERNALSYM RT_RCDATA}
  RT_RCDATA       = Types.RT_RCDATA; //MakeIntResource(10);
  {$EXTERNALSYM RT_MESSAGETABLE}
  RT_MESSAGETABLE = MakeIntResource(11);

  {$EXTERNALSYM DIFFERENCE}
  DIFFERENCE = 11;

  {$EXTERNALSYM RT_GROUP_CURSOR}
  RT_GROUP_CURSOR = MakeIntResource(DWORD(RT_CURSOR + DIFFERENCE));
  {$EXTERNALSYM RT_GROUP_ICON}
  RT_GROUP_ICON   = MakeIntResource(DWORD(RT_ICON + DIFFERENCE));
  {$EXTERNALSYM RT_VERSION}
  RT_VERSION      = MakeIntResource(16);
  {$EXTERNALSYM RT_DLGINCLUDE}
  RT_DLGINCLUDE   = MakeIntResource(17);
  {$EXTERNALSYM RT_PLUGPLAY}
  RT_PLUGPLAY     = MakeIntResource(19);
  {$EXTERNALSYM RT_VXD}
  RT_VXD          = MakeIntResource(20);
  {$EXTERNALSYM RT_ANICURSOR}
  RT_ANICURSOR    = MakeIntResource(21);
  {$EXTERNALSYM RT_ANIICON}
  RT_ANIICON      = MakeIntResource(22);

{$EXTERNALSYM wvsprintf}
function wvsprintf(Output: PChar; Format: PChar; arglist: va_list): Integer; stdcall;
{$EXTERNALSYM wvsprintfA}
function wvsprintfA(Output: PAnsiChar; Format: PAnsiChar; arglist: va_list): Integer; stdcall;
{$EXTERNALSYM wvsprintfW}
function wvsprintfW(Output: PWideChar; Format: PWideChar; arglist: va_list): Integer; stdcall;
{$EXTERNALSYM wsprintf}
function wsprintf(Output: PChar; Format: PChar): Integer; stdcall;
{$EXTERNALSYM wsprintfA}
function wsprintfA(Output: PAnsiChar; Format: PAnsiChar): Integer; stdcall;
{$EXTERNALSYM wsprintfW}
function wsprintfW(Output: PWideChar; Format: PWideChar): Integer; stdcall;

const
  { Scroll Bar Constants }
  {$EXTERNALSYM SB_HORZ}
  SB_HORZ = 0;
  {$EXTERNALSYM SB_VERT}
  SB_VERT = 1;
  {$EXTERNALSYM SB_CTL}
  SB_CTL = 2;
  {$EXTERNALSYM SB_BOTH}
  SB_BOTH = 3;

  { Scroll Bar Commands }
  {$EXTERNALSYM SB_LINEUP}
  SB_LINEUP = 0;
  {$EXTERNALSYM SB_LINELEFT}
  SB_LINELEFT = 0;
  {$EXTERNALSYM SB_LINEDOWN}
  SB_LINEDOWN = 1;
  {$EXTERNALSYM SB_LINERIGHT}
  SB_LINERIGHT = 1;
  {$EXTERNALSYM SB_PAGEUP}
  SB_PAGEUP = 2;
  {$EXTERNALSYM SB_PAGELEFT}
  SB_PAGELEFT = 2;
  {$EXTERNALSYM SB_PAGEDOWN}
  SB_PAGEDOWN = 3;
  {$EXTERNALSYM SB_PAGERIGHT}
  SB_PAGERIGHT = 3;
  {$EXTERNALSYM SB_THUMBPOSITION}
  SB_THUMBPOSITION = 4;
  {$EXTERNALSYM SB_THUMBTRACK}
  SB_THUMBTRACK = 5;
  {$EXTERNALSYM SB_TOP}
  SB_TOP = 6;
  {$EXTERNALSYM SB_LEFT}
  SB_LEFT = 6;
  {$EXTERNALSYM SB_BOTTOM}
  SB_BOTTOM = 7;
  {$EXTERNALSYM SB_RIGHT}
  SB_RIGHT = 7;
  {$EXTERNALSYM SB_ENDSCROLL}
  SB_ENDSCROLL = 8;

  { ShowWindow() Commands }
  {$EXTERNALSYM SW_HIDE}
  SW_HIDE = 0;
  {$EXTERNALSYM SW_SHOWNORMAL}
  SW_SHOWNORMAL = 1;
  {$EXTERNALSYM SW_NORMAL}
  SW_NORMAL = 1;
  {$EXTERNALSYM SW_SHOWMINIMIZED}
  SW_SHOWMINIMIZED = 2;
  {$EXTERNALSYM SW_SHOWMAXIMIZED}
  SW_SHOWMAXIMIZED = 3;
  {$EXTERNALSYM SW_MAXIMIZE}
  SW_MAXIMIZE = 3;
  {$EXTERNALSYM SW_SHOWNOACTIVATE}
  SW_SHOWNOACTIVATE = 4;
  {$EXTERNALSYM SW_SHOW}
  SW_SHOW = 5;
  {$EXTERNALSYM SW_MINIMIZE}
  SW_MINIMIZE = 6;
  {$EXTERNALSYM SW_SHOWMINNOACTIVE}
  SW_SHOWMINNOACTIVE = 7;
  {$EXTERNALSYM SW_SHOWNA}
  SW_SHOWNA = 8;
  {$EXTERNALSYM SW_RESTORE}
  SW_RESTORE = 9;
  {$EXTERNALSYM SW_SHOWDEFAULT}
  SW_SHOWDEFAULT = 10;
  {$EXTERNALSYM SW_MAX}
  SW_MAX = 10;

  { Old ShowWindow() Commands }
  {$EXTERNALSYM HIDE_WINDOW}
  HIDE_WINDOW = 0;
  {$EXTERNALSYM SHOW_OPENWINDOW}
  SHOW_OPENWINDOW = 1;
  {$EXTERNALSYM SHOW_ICONWINDOW}
  SHOW_ICONWINDOW = 2;
  {$EXTERNALSYM SHOW_FULLSCREEN}
  SHOW_FULLSCREEN = 3;
  {$EXTERNALSYM SHOW_OPENNOACTIVATE}
  SHOW_OPENNOACTIVATE = 4;

  { Identifiers for the WM_SHOWWINDOW message }
  {$EXTERNALSYM SW_PARENTCLOSING}
  SW_PARENTCLOSING = 1;
  {$EXTERNALSYM SW_OTHERZOOM}
  SW_OTHERZOOM = 2;
  {$EXTERNALSYM SW_PARENTOPENING}
  SW_PARENTOPENING = 3;
  {$EXTERNALSYM SW_OTHERUNZOOM}
  SW_OTHERUNZOOM = 4;

  {$EXTERNALSYM AW_HOR_POSITIVE}
  AW_HOR_POSITIVE = $00000001;
  {$EXTERNALSYM AW_HOR_NEGATIVE}
  AW_HOR_NEGATIVE = $00000002;
  {$EXTERNALSYM AW_VER_POSITIVE}
  AW_VER_POSITIVE = $00000004;
  {$EXTERNALSYM AW_VER_NEGATIVE}
  AW_VER_NEGATIVE = $00000008;
  {$EXTERNALSYM AW_CENTER}
  AW_CENTER = $00000010;
  {$EXTERNALSYM AW_HIDE}
  AW_HIDE = $00010000;
  {$EXTERNALSYM AW_ACTIVATE}
  AW_ACTIVATE = $00020000;
  {$EXTERNALSYM AW_SLIDE}
  AW_SLIDE = $00040000;
  {$EXTERNALSYM AW_BLEND}
  AW_BLEND = $00080000;

  { WM_KEYUPDOWNCHAR HiWord(lParam) flags }
  {$EXTERNALSYM KF_EXTENDED}
  KF_EXTENDED = $100;
  {$EXTERNALSYM KF_DLGMODE}
  KF_DLGMODE = $800;
  {$EXTERNALSYM KF_MENUMODE}
  KF_MENUMODE = $1000;
  {$EXTERNALSYM KF_ALTDOWN}
  KF_ALTDOWN = $2000;
  {$EXTERNALSYM KF_REPEAT}
  KF_REPEAT = $4000;
  {$EXTERNALSYM KF_UP}
  KF_UP = $8000;

  { Virtual Keys, Standard Set }
  {$EXTERNALSYM VK_LBUTTON}
  VK_LBUTTON = 1;
  {$EXTERNALSYM VK_RBUTTON}
  VK_RBUTTON = 2;
  {$EXTERNALSYM VK_CANCEL}
  VK_CANCEL = 3;
  {$EXTERNALSYM VK_MBUTTON}
  VK_MBUTTON = 4;  { NOT contiguous with L & RBUTTON }
  {$EXTERNALSYM VK_XBUTTON1}
  VK_XBUTTON1 = 5;
  {$EXTERNALSYM VK_XBUTTON2}
  VK_XBUTTON2 = 6;
  {$EXTERNALSYM VK_BACK}
  VK_BACK = 8;
  {$EXTERNALSYM VK_TAB}
  VK_TAB = 9;
  {$EXTERNALSYM VK_CLEAR}
  VK_CLEAR = 12;
  {$EXTERNALSYM VK_RETURN}
  VK_RETURN = 13;
  {$EXTERNALSYM VK_SHIFT}
  VK_SHIFT = $10;
  {$EXTERNALSYM VK_CONTROL}
  VK_CONTROL = 17;
  {$EXTERNALSYM VK_MENU}
  VK_MENU = 18;
  {$EXTERNALSYM VK_PAUSE}
  VK_PAUSE = 19;
  {$EXTERNALSYM VK_CAPITAL}
  VK_CAPITAL = 20;
  {$EXTERNALSYM VK_KANA }
  VK_KANA = 21;
  {$EXTERNALSYM VK_HANGUL }
  VK_HANGUL = 21;
  {$EXTERNALSYM VK_JUNJA }
  VK_JUNJA = 23;
  {$EXTERNALSYM VK_FINAL }
  VK_FINAL = 24;
  {$EXTERNALSYM VK_HANJA }
  VK_HANJA = 25;
  {$EXTERNALSYM VK_KANJI }
  VK_KANJI = 25;
  {$EXTERNALSYM VK_CONVERT }
  VK_CONVERT = 28;
  {$EXTERNALSYM VK_NONCONVERT }
  VK_NONCONVERT = 29;
  {$EXTERNALSYM VK_ACCEPT }
  VK_ACCEPT = 30;
  {$EXTERNALSYM VK_MODECHANGE }
  VK_MODECHANGE = 31;
  {$EXTERNALSYM VK_ESCAPE}
  VK_ESCAPE = 27;
  {$EXTERNALSYM VK_SPACE}
  VK_SPACE = $20;
  {$EXTERNALSYM VK_PRIOR}
  VK_PRIOR = 33;
  {$EXTERNALSYM VK_NEXT}
  VK_NEXT = 34;
  {$EXTERNALSYM VK_END}
  VK_END = 35;
  {$EXTERNALSYM VK_HOME}
  VK_HOME = 36;
  {$EXTERNALSYM VK_LEFT}
  VK_LEFT = 37;
  {$EXTERNALSYM VK_UP}
  VK_UP = 38;
  {$EXTERNALSYM VK_RIGHT}
  VK_RIGHT = 39;
  {$EXTERNALSYM VK_DOWN}
  VK_DOWN = 40;
  {$EXTERNALSYM VK_SELECT}
  VK_SELECT = 41;
  {$EXTERNALSYM VK_PRINT}
  VK_PRINT = 42;
  {$EXTERNALSYM VK_EXECUTE}
  VK_EXECUTE = 43;
  {$EXTERNALSYM VK_SNAPSHOT}
  VK_SNAPSHOT = 44;
  {$EXTERNALSYM VK_INSERT}
  VK_INSERT = 45;
  {$EXTERNALSYM VK_DELETE}
  VK_DELETE = 46;
  {$EXTERNALSYM VK_HELP}
  VK_HELP = 47;
{ VK_0 thru VK_9 are the same as ASCII '0' thru '9' ($30 - $39) }
{ VK_A thru VK_Z are the same as ASCII 'A' thru 'Z' ($41 - $5A) }
  {$EXTERNALSYM VK_LWIN}
  VK_LWIN = 91;
  {$EXTERNALSYM VK_RWIN}
  VK_RWIN = 92;
  {$EXTERNALSYM VK_APPS}
  VK_APPS = 93;
  {$EXTERNALSYM VK_SLEEP}
  VK_SLEEP = 95;
  {$EXTERNALSYM VK_NUMPAD0}
  VK_NUMPAD0 = 96;
  {$EXTERNALSYM VK_NUMPAD1}
  VK_NUMPAD1 = 97;
  {$EXTERNALSYM VK_NUMPAD2}
  VK_NUMPAD2 = 98;
  {$EXTERNALSYM VK_NUMPAD3}
  VK_NUMPAD3 = 99;
  {$EXTERNALSYM VK_NUMPAD4}
  VK_NUMPAD4 = 100;
  {$EXTERNALSYM VK_NUMPAD5}
  VK_NUMPAD5 = 101;
  {$EXTERNALSYM VK_NUMPAD6}
  VK_NUMPAD6 = 102;
  {$EXTERNALSYM VK_NUMPAD7}
  VK_NUMPAD7 = 103;
  {$EXTERNALSYM VK_NUMPAD8}
  VK_NUMPAD8 = 104;
  {$EXTERNALSYM VK_NUMPAD9}
  VK_NUMPAD9 = 105;
  {$EXTERNALSYM VK_MULTIPLY}
  VK_MULTIPLY = 106;
  {$EXTERNALSYM VK_ADD}
  VK_ADD = 107;
  {$EXTERNALSYM VK_SEPARATOR}
  VK_SEPARATOR = 108;
  {$EXTERNALSYM VK_SUBTRACT}
  VK_SUBTRACT = 109;
  {$EXTERNALSYM VK_DECIMAL}
  VK_DECIMAL = 110;
  {$EXTERNALSYM VK_DIVIDE}
  VK_DIVIDE = 111;
  {$EXTERNALSYM VK_F1}
  VK_F1 = 112;
  {$EXTERNALSYM VK_F2}
  VK_F2 = 113;
  {$EXTERNALSYM VK_F3}
  VK_F3 = 114;
  {$EXTERNALSYM VK_F4}
  VK_F4 = 115;
  {$EXTERNALSYM VK_F5}
  VK_F5 = 116;
  {$EXTERNALSYM VK_F6}
  VK_F6 = 117;
  {$EXTERNALSYM VK_F7}
  VK_F7 = 118;
  {$EXTERNALSYM VK_F8}
  VK_F8 = 119;
  {$EXTERNALSYM VK_F9}
  VK_F9 = 120;
  {$EXTERNALSYM VK_F10}
  VK_F10 = 121;
  {$EXTERNALSYM VK_F11}
  VK_F11 = 122;
  {$EXTERNALSYM VK_F12}
  VK_F12 = 123;
  {$EXTERNALSYM VK_F13}
  VK_F13 = 124;
  {$EXTERNALSYM VK_F14}
  VK_F14 = 125;
  {$EXTERNALSYM VK_F15}
  VK_F15 = 126;
  {$EXTERNALSYM VK_F16}
  VK_F16 = 127;
  {$EXTERNALSYM VK_F17}
  VK_F17 = 128;
  {$EXTERNALSYM VK_F18}
  VK_F18 = 129;
  {$EXTERNALSYM VK_F19}
  VK_F19 = 130;
  {$EXTERNALSYM VK_F20}
  VK_F20 = 131;
  {$EXTERNALSYM VK_F21}
  VK_F21 = 132;
  {$EXTERNALSYM VK_F22}
  VK_F22 = 133;
  {$EXTERNALSYM VK_F23}
  VK_F23 = 134;
  {$EXTERNALSYM VK_F24}
  VK_F24 = 135;
  {$EXTERNALSYM VK_NUMLOCK}
  VK_NUMLOCK = 144;
  {$EXTERNALSYM VK_SCROLL}
  VK_SCROLL = 145;
{ VK_L & VK_R - left and right Alt, Ctrl and Shift virtual keys.
  Used only as parameters to GetAsyncKeyState() and GetKeyState().
  No other API or message will distinguish left and right keys in this way. }
  {$EXTERNALSYM VK_LSHIFT}
  VK_LSHIFT = 160;
  {$EXTERNALSYM VK_RSHIFT}
  VK_RSHIFT = 161;
  {$EXTERNALSYM VK_LCONTROL}
  VK_LCONTROL = 162;
  {$EXTERNALSYM VK_RCONTROL}
  VK_RCONTROL = 163;
  {$EXTERNALSYM VK_LMENU}
  VK_LMENU = 164;
  {$EXTERNALSYM VK_RMENU}
  VK_RMENU = 165;

  {$EXTERNALSYM VK_BROWSER_BACK}
  VK_BROWSER_BACK = 166;
  {$EXTERNALSYM VK_BROWSER_FORWARD}
  VK_BROWSER_FORWARD = 167;
  {$EXTERNALSYM VK_BROWSER_REFRESH}
  VK_BROWSER_REFRESH = 168;
  {$EXTERNALSYM VK_BROWSER_STOP}
  VK_BROWSER_STOP = 169;
  {$EXTERNALSYM VK_BROWSER_SEARCH}
  VK_BROWSER_SEARCH = 170;
  {$EXTERNALSYM VK_BROWSER_FAVORITES}
  VK_BROWSER_FAVORITES = 171;
  {$EXTERNALSYM VK_BROWSER_HOME}
  VK_BROWSER_HOME = 172;
  {$EXTERNALSYM VK_VOLUME_MUTE}
  VK_VOLUME_MUTE = 173;
  {$EXTERNALSYM VK_VOLUME_DOWN}
  VK_VOLUME_DOWN = 174;
  {$EXTERNALSYM VK_VOLUME_UP}
  VK_VOLUME_UP = 175;
  {$EXTERNALSYM VK_MEDIA_NEXT_TRACK}
  VK_MEDIA_NEXT_TRACK = 176;
  {$EXTERNALSYM VK_MEDIA_PREV_TRACK}
  VK_MEDIA_PREV_TRACK = 177;
  {$EXTERNALSYM VK_MEDIA_STOP}
  VK_MEDIA_STOP = 178;
  {$EXTERNALSYM VK_MEDIA_PLAY_PAUSE}
  VK_MEDIA_PLAY_PAUSE = 179;
  {$EXTERNALSYM VK_LAUNCH_MAIL}
  VK_LAUNCH_MAIL = 180;
  {$EXTERNALSYM VK_LAUNCH_MEDIA_SELECT}
  VK_LAUNCH_MEDIA_SELECT = 181;
  {$EXTERNALSYM VK_LAUNCH_APP1}
  VK_LAUNCH_APP1 = 182;
  {$EXTERNALSYM VK_LAUNCH_APP2}
  VK_LAUNCH_APP2 = 183;

  {$EXTERNALSYM VK_OEM_1}
  VK_OEM_1 = 186;
  {$EXTERNALSYM VK_OEM_PLUS}
  VK_OEM_PLUS = 187;
  {$EXTERNALSYM VK_OEM_COMMA}
  VK_OEM_COMMA = 188;
  {$EXTERNALSYM VK_OEM_MINUS}
  VK_OEM_MINUS = 189;
  {$EXTERNALSYM VK_OEM_PERIOD}
  VK_OEM_PERIOD = 190;
  {$EXTERNALSYM VK_OEM_2}
  VK_OEM_2 = 191;
  {$EXTERNALSYM VK_OEM_3}
  VK_OEM_3 = 192;
  {$EXTERNALSYM VK_OEM_4}
  VK_OEM_4 = 219;
  {$EXTERNALSYM VK_OEM_5}
  VK_OEM_5 = 220;
  {$EXTERNALSYM VK_OEM_6}
  VK_OEM_6 = 221;
  {$EXTERNALSYM VK_OEM_7}
  VK_OEM_7 = 222;
  {$EXTERNALSYM VK_OEM_8}
  VK_OEM_8 = 223;
  {$EXTERNALSYM VK_OEM_102}
  VK_OEM_102 = 226;
  {$EXTERNALSYM VK_PACKET}
  VK_PACKET = 231;
  {$EXTERNALSYM VK_PROCESSKEY}
  VK_PROCESSKEY = 229;
  {$EXTERNALSYM VK_ATTN}
  VK_ATTN = 246;
  {$EXTERNALSYM VK_CRSEL}
  VK_CRSEL = 247;
  {$EXTERNALSYM VK_EXSEL}
  VK_EXSEL = 248;
  {$EXTERNALSYM VK_EREOF}
  VK_EREOF = 249;
  {$EXTERNALSYM VK_PLAY}
  VK_PLAY = 250;
  {$EXTERNALSYM VK_ZOOM}
  VK_ZOOM = 251;
  {$EXTERNALSYM VK_NONAME}
  VK_NONAME = 252;
  {$EXTERNALSYM VK_PA1}
  VK_PA1 = 253;
  {$EXTERNALSYM VK_OEM_CLEAR}
  VK_OEM_CLEAR = 254;


  { SetWindowsHook() codes }
  {$EXTERNALSYM WH_MIN}
  WH_MIN = -1;
  {$EXTERNALSYM WH_MSGFILTER}
  WH_MSGFILTER = -1;
  {$EXTERNALSYM WH_JOURNALRECORD}
  WH_JOURNALRECORD = 0;
  {$EXTERNALSYM WH_JOURNALPLAYBACK}
  WH_JOURNALPLAYBACK = 1;
  {$EXTERNALSYM WH_KEYBOARD}
  WH_KEYBOARD = 2;
  {$EXTERNALSYM WH_GETMESSAGE}
  WH_GETMESSAGE = 3;
  {$EXTERNALSYM WH_CALLWNDPROC}
  WH_CALLWNDPROC = 4;
  {$EXTERNALSYM WH_CBT}
  WH_CBT = 5;
  {$EXTERNALSYM WH_SYSMSGFILTER}
  WH_SYSMSGFILTER = 6;
  {$EXTERNALSYM WH_MOUSE}
  WH_MOUSE = 7;
  {$EXTERNALSYM WH_HARDWARE}
  WH_HARDWARE = 8;
  {$EXTERNALSYM WH_DEBUG}
  WH_DEBUG = 9;
  {$EXTERNALSYM WH_SHELL}
  WH_SHELL = 10;
  {$EXTERNALSYM WH_FOREGROUNDIDLE}
  WH_FOREGROUNDIDLE = 11;
  {$EXTERNALSYM WH_CALLWNDPROCRET}
  WH_CALLWNDPROCRET = 12;
  {$EXTERNALSYM WH_MAX}
  WH_MAX = 12;
  {$EXTERNALSYM WH_MINHOOK}
  WH_MINHOOK = WH_MIN;
  {$EXTERNALSYM WH_MAXHOOK}
  WH_MAXHOOK = WH_MAX;

  { Hook Codes }
  {$EXTERNALSYM HC_ACTION}
  HC_ACTION = 0;
  {$EXTERNALSYM HC_GETNEXT}
  HC_GETNEXT = 1;
  {$EXTERNALSYM HC_SKIP}
  HC_SKIP = 2;
  {$EXTERNALSYM HC_NOREMOVE}
  HC_NOREMOVE = 3;
  {$EXTERNALSYM HC_NOREM}
  HC_NOREM = HC_NOREMOVE;
  {$EXTERNALSYM HC_SYSMODALON}
  HC_SYSMODALON = 4;
  {$EXTERNALSYM HC_SYSMODALOFF}
  HC_SYSMODALOFF = 5;

  { CBT Hook Codes }
  {$EXTERNALSYM HCBT_MOVESIZE}
  HCBT_MOVESIZE = 0;
  {$EXTERNALSYM HCBT_MINMAX}
  HCBT_MINMAX = 1;
  {$EXTERNALSYM HCBT_QS}
  HCBT_QS = 2;
  {$EXTERNALSYM HCBT_CREATEWND}
  HCBT_CREATEWND = 3;
  {$EXTERNALSYM HCBT_DESTROYWND}
  HCBT_DESTROYWND = 4;
  {$EXTERNALSYM HCBT_ACTIVATE}
  HCBT_ACTIVATE = 5;
  {$EXTERNALSYM HCBT_CLICKSKIPPED}
  HCBT_CLICKSKIPPED = 6;
  {$EXTERNALSYM HCBT_KEYSKIPPED}
  HCBT_KEYSKIPPED = 7;
  {$EXTERNALSYM HCBT_SYSCOMMAND}
  HCBT_SYSCOMMAND = 8;
  {$EXTERNALSYM HCBT_SETFOCUS}
  HCBT_SETFOCUS = 9;


type
  PCreateStructA = ^TCreateStructA;
  PCreateStructW = ^TCreateStructW;
  PCreateStruct = PCreateStructA;
  {$EXTERNALSYM tagCREATESTRUCTA}
  tagCREATESTRUCTA = packed record
    lpCreateParams: Pointer;
    hInstance: HINST;
    hMenu: HMENU;
    hwndParent: HWND;
    cy: Integer;
    cx: Integer;
    y: Integer;
    x: Integer;
    style: Longint;
    lpszName: PAnsiChar;
    lpszClass: PAnsiChar;
    dwExStyle: DWORD;
  end;
  {$EXTERNALSYM tagCREATESTRUCTW}
  tagCREATESTRUCTW = packed record
    lpCreateParams: Pointer;
    hInstance: HINST;
    hMenu: HMENU;
    hwndParent: HWND;
    cy: Integer;
    cx: Integer;
    y: Integer;
    x: Integer;
    style: Longint;
    lpszName: PWideChar;
    lpszClass: PWideChar;
    dwExStyle: DWORD;
  end;
  {$EXTERNALSYM tagCREATESTRUCT}
  tagCREATESTRUCT = tagCREATESTRUCTA;
  TCreateStructA = tagCREATESTRUCTA;
  TCreateStructW = tagCREATESTRUCTW;
  TCreateStruct = TCreateStructA;
  {$EXTERNALSYM CREATESTRUCTA}
  CREATESTRUCTA = tagCREATESTRUCTA;
  {$EXTERNALSYM CREATESTRUCTW}
  CREATESTRUCTW = tagCREATESTRUCTW;
  {$EXTERNALSYM CREATESTRUCT}
  CREATESTRUCT = CREATESTRUCTA;

  { HCBT_CREATEWND parameters pointed to by lParam }
  PCBTCreateWnd = ^TCBTCreateWnd;
  {$EXTERNALSYM tagCBT_CREATEWNDA}
  tagCBT_CREATEWNDA = packed record
    lpcs: PCreateStruct;
    hwndInsertAfter: HWND;
  end;
  TCBTCreateWnd = tagCBT_CREATEWNDA;
  {$EXTERNALSYM CBT_CREATEWND}
  CBT_CREATEWND = tagCBT_CREATEWNDA;

  { HCBT_ACTIVATE structure pointed to by lParam }
  PCBTActivateStruct = ^TCBTActivateStruct;
  {$EXTERNALSYM tagCBTACTIVATESTRUCT}
  tagCBTACTIVATESTRUCT = packed record
    fMouse: BOOL;
    hWndActive: HWND;
  end;
  TCBTActivateStruct = tagCBTACTIVATESTRUCT;
  {$EXTERNALSYM CBTACTIVATESTRUCT}
  CBTACTIVATESTRUCT = tagCBTACTIVATESTRUCT;

const
  
{ codes passed in WPARAM for WM_WTSSESSION_CHANGE }

  WTS_CONSOLE_CONNECT = $1;
  WTS_CONSOLE_DISCONNECT = $2;
  WTS_REMOTE_CONNECT = $3;
  WTS_REMOTE_DISCONNECT = $4;
  WTS_SESSION_LOGON = $5;
  WTS_SESSION_LOGOFF = $6;
  WTS_SESSION_LOCK = $7;
  WTS_SESSION_UNLOCK = $8;

  { WH_MSGFILTER Filter Proc Codes }
  {$EXTERNALSYM MSGF_DIALOGBOX}
  MSGF_DIALOGBOX = 0;
  {$EXTERNALSYM MSGF_MESSAGEBOX}
  MSGF_MESSAGEBOX = 1;
  {$EXTERNALSYM MSGF_MENU}
  MSGF_MENU = 2;
  {$EXTERNALSYM MSGF_MOVE}
  MSGF_MOVE = 3;
  {$EXTERNALSYM MSGF_SIZE}
  MSGF_SIZE = 4;
  {$EXTERNALSYM MSGF_SCROLLBAR}
  MSGF_SCROLLBAR = 5;
  {$EXTERNALSYM MSGF_NEXTWINDOW}
  MSGF_NEXTWINDOW = 6;
  {$EXTERNALSYM MSGF_MAINLOOP}
  MSGF_MAINLOOP = 8;
  {$EXTERNALSYM MSGF_MAX}
  MSGF_MAX = 8;
  {$EXTERNALSYM MSGF_USER}
  MSGF_USER = $1000;

  { Shell support }
  {$EXTERNALSYM HSHELL_WINDOWCREATED}
  HSHELL_WINDOWCREATED = 1;
  {$EXTERNALSYM HSHELL_WINDOWDESTROYED}
  HSHELL_WINDOWDESTROYED = 2;
  {$EXTERNALSYM HSHELL_ACTIVATESHELLWINDOW}
  HSHELL_ACTIVATESHELLWINDOW = 3;
  {$EXTERNALSYM HSHELL_WINDOWACTIVATED}
  HSHELL_WINDOWACTIVATED = 4;
  {$EXTERNALSYM HSHELL_GETMINRECT}
  HSHELL_GETMINRECT = 5;
  {$EXTERNALSYM HSHELL_REDRAW}
  HSHELL_REDRAW = 6;
  {$EXTERNALSYM HSHELL_TASKMAN}
  HSHELL_TASKMAN = 7;
  {$EXTERNALSYM HSHELL_LANGUAGE}
  HSHELL_LANGUAGE = 8;
  {$EXTERNALSYM HSHELL_ACCESSIBILITYSTATE}
  HSHELL_ACCESSIBILITYSTATE = 11;
  {$EXTERNALSYM HSHELL_APPCOMMAND}
  HSHELL_APPCOMMAND = 12;
  {$EXTERNALSYM HSHELL_WINDOWREPLACED}
  HSHELL_WINDOWREPLACED = 13;
  {$EXTERNALSYM ACCESS_STICKYKEYS}
  ACCESS_STICKYKEYS = $0001;
  {$EXTERNALSYM ACCESS_FILTERKEYS}
  ACCESS_FILTERKEYS = $0002;
  {$EXTERNALSYM ACCESS_MOUSEKEYS}
  ACCESS_MOUSEKEYS = $0003;


type
  { Message Structure used in Journaling }
  PEventMsg = ^TEventMsg;
  {$EXTERNALSYM tagEVENTMSG}
  tagEVENTMSG = packed record
    message: UINT;
    paramL: UINT;
    paramH: UINT;
    time: DWORD;
    hwnd: HWND;
  end;
  TEventMsg = tagEVENTMSG;
  {$EXTERNALSYM EVENTMSG}
  EVENTMSG = tagEVENTMSG;

  { Message structure used by WH_CALLWNDPROC }
  PCWPStruct = ^TCWPStruct;
  {$EXTERNALSYM tagCWPSTRUCT}
  tagCWPSTRUCT = packed record
    lParam: LPARAM;
    wParam: WPARAM;
    message: UINT;
    hwnd: HWND;
  end;
  TCWPStruct = tagCWPSTRUCT;
  {$EXTERNALSYM CWPSTRUCT}
  CWPSTRUCT = tagCWPSTRUCT;

  { Message structure used by WH_CALLWNDPROCRET }
  PCWPRetStruct = ^TCWPRetStruct;
  {$EXTERNALSYM tagCWPRETSTRUCT}
  tagCWPRETSTRUCT = packed record
    lResult: LRESULT;
    lParam: LPARAM;
    wParam: WPARAM;
    message: UINT;
    hwnd: HWND;
  end;
  TCWPRetStruct = tagCWPRETSTRUCT;
  {$EXTERNALSYM CWPRETSTRUCT}
  CWPRETSTRUCT = tagCWPRETSTRUCT;

  { Structure used by WH_DEBUG }
  PDebugHookInfo = ^TDebugHookInfo;
  {$EXTERNALSYM tagDEBUGHOOKINFO}
  tagDEBUGHOOKINFO = packed record
    idThread: DWORD;
    idThreadInstaller: DWORD;
    lParam: LPARAM;
    wParam: WPARAM;
    code: Integer;
  end;
  TDebugHookInfo = tagDEBUGHOOKINFO;
  {$EXTERNALSYM DEBUGHOOKINFO}
  DEBUGHOOKINFO = tagDEBUGHOOKINFO;

  { Structure used by WH_MOUSE }
  PMouseHookStruct = ^TMouseHookStruct;
  {$EXTERNALSYM tagMOUSEHOOKSTRUCT}
  tagMOUSEHOOKSTRUCT = packed record
    pt: TPoint;
    hwnd: HWND;
    wHitTestCode: UINT;
    dwExtraInfo: DWORD;
  end;
  TMouseHookStruct = tagMOUSEHOOKSTRUCT;
  {$EXTERNALSYM MOUSEHOOKSTRUCT}
  MOUSEHOOKSTRUCT = tagMOUSEHOOKSTRUCT;

  { Structure used by WH_HARDWARE }
  PHardwareHookStruct = ^THardwareHookStruct;
  {$EXTERNALSYM tagHARDWAREHOOKSTRUCT}
  tagHARDWAREHOOKSTRUCT = packed record
    hwnd: HWND;
    message: UINT;
    wParam: WPARAM;
    lParam: LPARAM;
  end;
  THardwareHookStruct = tagHARDWAREHOOKSTRUCT;
  {$EXTERNALSYM HARDWAREHOOKSTRUCT}
  HARDWAREHOOKSTRUCT = tagHARDWAREHOOKSTRUCT;

const
  { Keyboard Layout API }
  {$EXTERNALSYM HKL_PREV}
  HKL_PREV = 0;
  {$EXTERNALSYM HKL_NEXT}
  HKL_NEXT = 1;

  {$EXTERNALSYM KLF_ACTIVATE}
  KLF_ACTIVATE = 1;
  {$EXTERNALSYM KLF_SUBSTITUTE_OK}
  KLF_SUBSTITUTE_OK = 2;
  {$EXTERNALSYM KLF_UNLOADPREVIOUS}
  KLF_UNLOADPREVIOUS = 4;
  {$EXTERNALSYM KLF_REORDER}
  KLF_REORDER = 8;
  {$EXTERNALSYM KLF_REPLACELANG}
  KLF_REPLACELANG = $10;
  {$EXTERNALSYM KLF_NOTELLSHELL}
  KLF_NOTELLSHELL = 128;

  { Size of KeyboardLayoutName (number of characters), including nul terminator }
  {$EXTERNALSYM KL_NAMELENGTH}
  KL_NAMELENGTH = 9;


{$EXTERNALSYM LoadKeyboardLayout}
function LoadKeyboardLayout(pwszKLID: PChar; Flags: UINT): HKL; stdcall;
{$EXTERNALSYM LoadKeyboardLayoutA}
function LoadKeyboardLayoutA(pwszKLID: PAnsiChar; Flags: UINT): HKL; stdcall;
{$EXTERNALSYM LoadKeyboardLayoutW}
function LoadKeyboardLayoutW(pwszKLID: PWideChar; Flags: UINT): HKL; stdcall;
{$EXTERNALSYM ActivateKeyboardLayout}
function ActivateKeyboardLayout(hkl: HKL; Flags: UINT): HKL; stdcall;
{$EXTERNALSYM UnloadKeyboardLayout}
function UnloadKeyboardLayout(hkl: HKL): BOOL; stdcall;
{$EXTERNALSYM ToUnicodeEx}
function ToUnicodeEx(wVirtKey, wScanCode: UINT; lpKeyState: PByte;
  pwszBuff: PWideChar; cchBuff: Integer; wFlags: UINT; dwhkl: HKL): Integer; stdcall;
{$EXTERNALSYM GetKeyboardLayoutName}
function GetKeyboardLayoutName(pwszKLID: PChar): BOOL; stdcall;
{$EXTERNALSYM GetKeyboardLayoutNameA}
function GetKeyboardLayoutNameA(pwszKLID: PAnsiChar): BOOL; stdcall;
{$EXTERNALSYM GetKeyboardLayoutNameW}
function GetKeyboardLayoutNameW(pwszKLID: PWideChar): BOOL; stdcall;
{$EXTERNALSYM GetKeyboardLayoutList}
function GetKeyboardLayoutList(nBuff: Integer; var List): UINT; stdcall;
{$EXTERNALSYM GetKeyboardLayout}
function GetKeyboardLayout(dwLayout: DWORD): HKL; stdcall;

type
  {$EXTERNALSYM PMouseMovePoint}
  PMouseMovePoint = ^TMouseMovePoint;
  {$EXTERNALSYM tagMOUSEMOVEPOINT}
  tagMOUSEMOVEPOINT = packed record
    x: Integer;
    y: Integer;
    time: DWORD;
    dwExtraInfo: DWORD;
  end;
  {$EXTERNALSYM TMouseMovePoint}
  TMouseMovePoint = tagMOUSEMOVEPOINT;
  {$EXTERNALSYM MOUSEMOVEPOINT}
  MOUSEMOVEPOINT = tagMOUSEMOVEPOINT;

const
  { Values for resolution parameter of GetMouseMovePoints }
  {$EXTERNALSYM GMMP_USE_DISPLAY_POINTS}
  GMMP_USE_DISPLAY_POINTS = 1;
  {$EXTERNALSYM GMMP_USE_DRIVER_POINTS}
  GMMP_USE_DRIVER_POINTS = 2;

{$EXTERNALSYM GetMouseMovePoints}
function GetMouseMovePoints(cbSize: UINT; var lppt, lpptBuf: TMouseMovePoint; nBufPoints: Integer;
  resolution: DWORD): Integer; stdcall;


const
  { Desktop-specific access flags }
  {$EXTERNALSYM DESKTOP_READOBJECTS}
  DESKTOP_READOBJECTS = 1;
  {$EXTERNALSYM DESKTOP_CREATEWINDOW}
  DESKTOP_CREATEWINDOW = 2;
  {$EXTERNALSYM DESKTOP_CREATEMENU}
  DESKTOP_CREATEMENU = 4;
  {$EXTERNALSYM DESKTOP_HOOKCONTROL}
  DESKTOP_HOOKCONTROL = 8;
  {$EXTERNALSYM DESKTOP_JOURNALRECORD}
  DESKTOP_JOURNALRECORD = $10;
  {$EXTERNALSYM DESKTOP_JOURNALPLAYBACK}
  DESKTOP_JOURNALPLAYBACK = $20;
  {$EXTERNALSYM DESKTOP_ENUMERATE}
  DESKTOP_ENUMERATE = $40;
  {$EXTERNALSYM DESKTOP_WRITEOBJECTS}
  DESKTOP_WRITEOBJECTS = 128;
  {$EXTERNALSYM DESKTOP_SWITCHDESKTOP}
  DESKTOP_SWITCHDESKTOP = $100;

  { Desktop-specific control flags }
  {$EXTERNALSYM DF_ALLOWOTHERACCOUNTHOOK}
  DF_ALLOWOTHERACCOUNTHOOK = 1;


{$EXTERNALSYM CreateDesktop}
function CreateDesktop(lpszDesktop, lpszDevice: PChar;
  pDevmode: PDeviceMode; dwFlags: DWORD; dwDesiredAccess:
  DWORD; lpsa: PSecurityAttributes): HDESK; stdcall;
{$EXTERNALSYM CreateDesktopA}
function CreateDesktopA(lpszDesktop, lpszDevice: PAnsiChar;
  pDevmode: PDeviceModeA; dwFlags: DWORD; dwDesiredAccess:
  DWORD; lpsa: PSecurityAttributes): HDESK; stdcall;
{$EXTERNALSYM CreateDesktopW}
function CreateDesktopW(lpszDesktop, lpszDevice: PWideChar;
  pDevmode: PDeviceModeW; dwFlags: DWORD; dwDesiredAccess:
  DWORD; lpsa: PSecurityAttributes): HDESK; stdcall;
{$EXTERNALSYM OpenDesktop}
function OpenDesktop(lpszDesktop: PChar; dwFlags: DWORD; fInherit: BOOL;
  dwDesiredAccess: DWORD): HDESK; stdcall;
{$EXTERNALSYM OpenDesktopA}
function OpenDesktopA(lpszDesktop: PAnsiChar; dwFlags: DWORD; fInherit: BOOL;
  dwDesiredAccess: DWORD): HDESK; stdcall;
{$EXTERNALSYM OpenDesktopW}
function OpenDesktopW(lpszDesktop: PWideChar; dwFlags: DWORD; fInherit: BOOL;
  dwDesiredAccess: DWORD): HDESK; stdcall;
{$EXTERNALSYM EnumDesktops}
function EnumDesktops(hwinsta: HWINSTA; lpEnumFunc: TFNDeskTopEnumProc; lParam: LPARAM): BOOL; stdcall;
{$EXTERNALSYM EnumDesktopsA}
function EnumDesktopsA(hwinsta: HWINSTA; lpEnumFunc: TFNDeskTopEnumProc; lParam: LPARAM): BOOL; stdcall;
{$EXTERNALSYM EnumDesktopsW}
function EnumDesktopsW(hwinsta: HWINSTA; lpEnumFunc: TFNDeskTopEnumProc; lParam: LPARAM): BOOL; stdcall;
{$EXTERNALSYM OpenInputDesktop}
function OpenInputDesktop(dwFlags: DWORD; fInherit: BOOL; dwDesiredAccess: DWORD): HDESK; stdcall;
{$EXTERNALSYM EnumDesktopWindows}
function EnumDesktopWindows(hDesktop: HDESK; lpfn: TFNWndEnumProc; lParam: LPARAM): BOOL; stdcall;
{$EXTERNALSYM SwitchDesktop}
function SwitchDesktop(hDesktop: HDESK): BOOL; stdcall;
{$EXTERNALSYM SetThreadDesktop}
function SetThreadDesktop(hDesktop: HDESK): BOOL; stdcall;
{$EXTERNALSYM CloseDesktop}
function CloseDesktop(hDesktop: HDESK): BOOL; stdcall;
{$EXTERNALSYM GetThreadDesktop}
function GetThreadDesktop(dwThreadId: DWORD): HDESK; stdcall;

const
  { Windowstation-specific access flags }
  {$EXTERNALSYM WINSTA_ENUMDESKTOPS}
  WINSTA_ENUMDESKTOPS = 1;
  {$EXTERNALSYM WINSTA_READATTRIBUTES}
  WINSTA_READATTRIBUTES = 2;
  {$EXTERNALSYM WINSTA_ACCESSCLIPBOARD}
  WINSTA_ACCESSCLIPBOARD = 4;
  {$EXTERNALSYM WINSTA_CREATEDESKTOP}
  WINSTA_CREATEDESKTOP = 8;
  {$EXTERNALSYM WINSTA_WRITEATTRIBUTES}
  WINSTA_WRITEATTRIBUTES = $10;
  {$EXTERNALSYM WINSTA_ACCESSGLOBALATOMS}
  WINSTA_ACCESSGLOBALATOMS = $20;
  {$EXTERNALSYM WINSTA_EXITWINDOWS}
  WINSTA_EXITWINDOWS = $40;
  {$EXTERNALSYM WINSTA_ENUMERATE}
  WINSTA_ENUMERATE = $100;
  {$EXTERNALSYM WINSTA_READSCREEN}
  WINSTA_READSCREEN = $200;

  { Windowstation-specific attribute flags }
  {$EXTERNALSYM WSF_VISIBLE}
  WSF_VISIBLE = 1;

{$EXTERNALSYM CreateWindowStation}
function CreateWindowStation(lpwinsta: PChar; dwReserved, dwDesiredAccess: DWORD;
  lpsa: PSecurityAttributes): HWINSTA; stdcall;
{$EXTERNALSYM CreateWindowStationA}
function CreateWindowStationA(lpwinsta: PAnsiChar; dwReserved, dwDesiredAccess: DWORD;
  lpsa: PSecurityAttributes): HWINSTA; stdcall;
{$EXTERNALSYM CreateWindowStationW}
function CreateWindowStationW(lpwinsta: PWideChar; dwReserved, dwDesiredAccess: DWORD;
  lpsa: PSecurityAttributes): HWINSTA; stdcall;
{$EXTERNALSYM OpenWindowStation}
function OpenWindowStation(lpszWinSta: PChar; fInherit: BOOL;
  dwDesiredAccess: DWORD): HWINSTA; stdcall;
{$EXTERNALSYM OpenWindowStationA}
function OpenWindowStationA(lpszWinSta: PAnsiChar; fInherit: BOOL;
  dwDesiredAccess: DWORD): HWINSTA; stdcall;
{$EXTERNALSYM OpenWindowStationW}
function OpenWindowStationW(lpszWinSta: PWideChar; fInherit: BOOL;
  dwDesiredAccess: DWORD): HWINSTA; stdcall;
{$EXTERNALSYM EnumWindowStations}
function EnumWindowStations(lpEnumFunc: TFNWinStaEnumProc; lParam: LPARAM): BOOL; stdcall;
{$EXTERNALSYM EnumWindowStationsA}
function EnumWindowStationsA(lpEnumFunc: TFNWinStaEnumProc; lParam: LPARAM): BOOL; stdcall;
{$EXTERNALSYM EnumWindowStationsW}
function EnumWindowStationsW(lpEnumFunc: TFNWinStaEnumProc; lParam: LPARAM): BOOL; stdcall;
{$EXTERNALSYM CloseWindowStation}
function CloseWindowStation(hWinSta: HWINSTA): BOOL; stdcall;
{$EXTERNALSYM SetProcessWindowStation}
function SetProcessWindowStation(hWinSta: HWINSTA): BOOL; stdcall;
{$EXTERNALSYM GetProcessWindowStation}
function GetProcessWindowStation: HWINSTA; stdcall;
{$EXTERNALSYM SetUserObjectSecurity}
function SetUserObjectSecurity(hObj: THandle; var pSIRequested: DWORD;
  pSID: PSecurityDescriptor): BOOL; stdcall;
{$EXTERNALSYM GetUserObjectSecurity}
function GetUserObjectSecurity(hObj: THandle; var pSIRequested: DWORD;
  pSID: PSecurityDescriptor; nLength: DWORD; var lpnLengthNeeded: DWORD): BOOL; stdcall;

const
  {$EXTERNALSYM UOI_FLAGS}
  UOI_FLAGS = 1;
  {$EXTERNALSYM UOI_NAME}
  UOI_NAME = 2;
  {$EXTERNALSYM UOI_TYPE}
  UOI_TYPE = 3;
  {$EXTERNALSYM UOI_USER_SID}
  UOI_USER_SID = 4;

type
  PUserObjectFlags = ^TUserObjectFlags;
  {$EXTERNALSYM tagUSEROBJECTFLAGS}
  tagUSEROBJECTFLAGS = packed record
    fInherit: BOOL;
    fReserved: BOOL;
    dwFlags: DWORD;
  end;
  TUserObjectFlags = tagUSEROBJECTFLAGS;
  {$EXTERNALSYM USEROBJECTFLAGS}
  USEROBJECTFLAGS = tagUSEROBJECTFLAGS;

{$EXTERNALSYM GetUserObjectInformation}
function GetUserObjectInformation(hObj: THandle; nIndex: Integer; pvInfo: Pointer;
  nLength: DWORD; var lpnLengthNeeded: DWORD): BOOL; stdcall;
{$EXTERNALSYM GetUserObjectInformationA}
function GetUserObjectInformationA(hObj: THandle; nIndex: Integer; pvInfo: Pointer;
  nLength: DWORD; var lpnLengthNeeded: DWORD): BOOL; stdcall;
{$EXTERNALSYM GetUserObjectInformationW}
function GetUserObjectInformationW(hObj: THandle; nIndex: Integer; pvInfo: Pointer;
  nLength: DWORD; var lpnLengthNeeded: DWORD): BOOL; stdcall;
{$EXTERNALSYM SetUserObjectInformation}
function SetUserObjectInformation(hObj: THandle; nIndex: Integer;
  pvInfo: Pointer; nLength: DWORD): BOOL; stdcall;
{$EXTERNALSYM SetUserObjectInformationA}
function SetUserObjectInformationA(hObj: THandle; nIndex: Integer;
  pvInfo: Pointer; nLength: DWORD): BOOL; stdcall;
{$EXTERNALSYM SetUserObjectInformationW}
function SetUserObjectInformationW(hObj: THandle; nIndex: Integer;
  pvInfo: Pointer; nLength: DWORD): BOOL; stdcall;

type
  PWndClassExA = ^TWndClassExA;
  PWndClassExW = ^TWndClassExW;
  PWndClassEx = PWndClassExA;
  {$EXTERNALSYM tagWNDCLASSEXA}
  tagWNDCLASSEXA = packed record
    cbSize: UINT;
    style: UINT;
    lpfnWndProc: TFNWndProc;
    cbClsExtra: Integer;
    cbWndExtra: Integer;
    hInstance: HINST;
    hIcon: HICON;
    hCursor: HCURSOR;
    hbrBackground: HBRUSH;
    lpszMenuName: PAnsiChar;
    lpszClassName: PAnsiChar;
    hIconSm: HICON;
  end;
  {$EXTERNALSYM tagWNDCLASSEXW}
  tagWNDCLASSEXW = packed record
    cbSize: UINT;
    style: UINT;
    lpfnWndProc: TFNWndProc;
    cbClsExtra: Integer;
    cbWndExtra: Integer;
    hInstance: HINST;
    hIcon: HICON;
    hCursor: HCURSOR;
    hbrBackground: HBRUSH;
    lpszMenuName: PWideChar;
    lpszClassName: PWideChar;
    hIconSm: HICON;
  end;
  {$EXTERNALSYM tagWNDCLASSEX}
  tagWNDCLASSEX = tagWNDCLASSEXA;
  TWndClassExA = tagWNDCLASSEXA;
  TWndClassExW = tagWNDCLASSEXW;
  TWndClassEx = TWndClassExA;
  {$EXTERNALSYM WNDCLASSEXA}
  WNDCLASSEXA = tagWNDCLASSEXA;
  {$EXTERNALSYM WNDCLASSEXW}
  WNDCLASSEXW = tagWNDCLASSEXW;
  {$EXTERNALSYM WNDCLASSEX}
  WNDCLASSEX = WNDCLASSEXA;

  PWndClassA = ^TWndClassA;
  PWndClassW = ^TWndClassW;
  PWndClass = PWndClassA;
  {$EXTERNALSYM tagWNDCLASSA}
  tagWNDCLASSA = packed record
    style: UINT;
    lpfnWndProc: TFNWndProc;
    cbClsExtra: Integer;
    cbWndExtra: Integer;
    hInstance: HINST;
    hIcon: HICON;
    hCursor: HCURSOR;
    hbrBackground: HBRUSH;
    lpszMenuName: PAnsiChar;
    lpszClassName: PAnsiChar;
  end;
  {$EXTERNALSYM tagWNDCLASSW}
  tagWNDCLASSW = packed record
    style: UINT;
    lpfnWndProc: TFNWndProc;
    cbClsExtra: Integer;
    cbWndExtra: Integer;
    hInstance: HINST;
    hIcon: HICON;
    hCursor: HCURSOR;
    hbrBackground: HBRUSH;
    lpszMenuName: PWideChar;
    lpszClassName: PWideChar;
  end;
  {$EXTERNALSYM tagWNDCLASS}
  tagWNDCLASS = tagWNDCLASSA;
  TWndClassA = tagWNDCLASSA;
  TWndClassW = tagWNDCLASSW;
  TWndClass = TWndClassA;
  {$EXTERNALSYM WNDCLASSA}
  WNDCLASSA = tagWNDCLASSA;
  {$EXTERNALSYM WNDCLASSW}
  WNDCLASSW = tagWNDCLASSW;
  {$EXTERNALSYM WNDCLASS}
  WNDCLASS = WNDCLASSA;

{ Message structure }
  PMsg = ^TMsg;
  tagMSG = packed record
    hwnd: HWND;
    message: UINT;
    wParam: WPARAM;
    lParam: LPARAM;
    time: DWORD;
    pt: TPoint;
  end;
  {$EXTERNALSYM tagMSG}
  TMsg = tagMSG;
  MSG = tagMSG;
  {$EXTERNALSYM MSG}

function SmallPointToPoint(const P: TSmallPoint): TPoint; inline;
{$EXTERNALSYM SmallPointToPoint}
function PointToSmallPoint(const P: TPoint): TSmallPoint; inline;
{$EXTERNALSYM PointToSmallPoint}
function MakeWParam(l, h: Word): WPARAM; inline;
{$EXTERNALSYM MakeWParam}
function MakeLParam(l, h: Word): LPARAM; inline;
{$EXTERNALSYM MakeLParam}
function MakeLResult(l, h: Word): LRESULT; inline;
{$EXTERNALSYM MakeLResult}


const
{ Window field offsets for GetWindowLong() }

  {$EXTERNALSYM GWL_WNDPROC}
  GWL_WNDPROC = -4;
  {$EXTERNALSYM GWL_HINSTANCE}
  GWL_HINSTANCE = -6;
  {$EXTERNALSYM GWL_HWNDPARENT}
  GWL_HWNDPARENT = -8;
  {$EXTERNALSYM GWL_STYLE}
  GWL_STYLE = -16;
  {$EXTERNALSYM GWL_EXSTYLE}
  GWL_EXSTYLE = -20;
  {$EXTERNALSYM GWL_USERDATA}
  GWL_USERDATA = -21;
  {$EXTERNALSYM GWL_ID}
  GWL_ID = -12;

  { Class field offsets for GetClassLong() }
  {$EXTERNALSYM GCL_MENUNAME}
  GCL_MENUNAME = -8;
  {$EXTERNALSYM GCL_HBRBACKGROUND}
  GCL_HBRBACKGROUND = -10;
  {$EXTERNALSYM GCL_HCURSOR}
  GCL_HCURSOR = -12;
  {$EXTERNALSYM GCL_HICON}
  GCL_HICON = -14;
  {$EXTERNALSYM GCL_HMODULE}
  GCL_HMODULE = -16;
  {$EXTERNALSYM GCL_CBWNDEXTRA}
  GCL_CBWNDEXTRA = -18;
  {$EXTERNALSYM GCL_CBCLSEXTRA}
  GCL_CBCLSEXTRA = -20;
  {$EXTERNALSYM GCL_WNDPROC}
  GCL_WNDPROC = -24;
  {$EXTERNALSYM GCL_STYLE}
  GCL_STYLE = -26;
  {$EXTERNALSYM GCW_ATOM}
  GCW_ATOM = -32;
  {$EXTERNALSYM GCL_HICONSM}
  GCL_HICONSM = -34;

const
  { WM_ACTIVATE state values }
  {$EXTERNALSYM WA_INACTIVE}
  WA_INACTIVE = 0;
  {$EXTERNALSYM WA_ACTIVE}
  WA_ACTIVE = 1;
  {$EXTERNALSYM WA_CLICKACTIVE}
  WA_CLICKACTIVE = 2;

type
  { Struct pointed to by WM_GETMINMAXINFO lParam }
  PMinMaxInfo = ^TMinMaxInfo;
  {$EXTERNALSYM tagMINMAXINFO}
  tagMINMAXINFO = packed record
    ptReserved: TPoint;
    ptMaxSize: TPoint;
    ptMaxPosition: TPoint;
    ptMinTrackSize: TPoint;
    ptMaxTrackSize: TPoint;
  end;
  TMinMaxInfo = tagMINMAXINFO;
  {$EXTERNALSYM MINMAXINFO}
  MINMAXINFO = tagMINMAXINFO;

const
  { wParam for WM_POWER window message and DRV_POWER driver notification }
  {$EXTERNALSYM PWR_OK}
  PWR_OK = 1;
  {$EXTERNALSYM PWR_FAIL}
  PWR_FAIL = -1;
  {$EXTERNALSYM PWR_SUSPENDREQUEST}
  PWR_SUSPENDREQUEST = 1;
  {$EXTERNALSYM PWR_SUSPENDRESUME}
  PWR_SUSPENDRESUME = 2;
  {$EXTERNALSYM PWR_CRITICALRESUME}
  PWR_CRITICALRESUME = 3;

type
  { lParam of WM_COPYDATA message points to... }
  PCopyDataStruct = ^TCopyDataStruct;
  {$EXTERNALSYM tagCOPYDATASTRUCT}
  tagCOPYDATASTRUCT = packed record
    dwData: DWORD;
    cbData: DWORD;
    lpData: Pointer;
  end;
  TCopyDataStruct = tagCOPYDATASTRUCT;
  {$EXTERNALSYM COPYDATASTRUCT}
  COPYDATASTRUCT = tagCOPYDATASTRUCT;

const
  {$EXTERNALSYM NFR_ANSI}
  NFR_ANSI = 1;
  {$EXTERNALSYM NFR_UNICODE}
  NFR_UNICODE = 2;
  {$EXTERNALSYM NF_QUERY}
  NF_QUERY = 3;
  {$EXTERNALSYM NF_REQUERY}
  NF_REQUERY = 4;

  {$EXTERNALSYM WHEEL_DELTA}
  WHEEL_DELTA = 120;            { Value for rolling one detent }
  {$EXTERNALSYM WHEEL_PAGESCROLL}
  WHEEL_PAGESCROLL = MAXDWORD;  { Scroll one page }

  {$EXTERNALSYM MENULOOP_WINDOW}
  MENULOOP_WINDOW = 0;
  {$EXTERNALSYM MENULOOP_POPUP}
  MENULOOP_POPUP = 1;

type
  PMDINextMenu = ^TMDINextMenu;
  {$EXTERNALSYM tagMDINEXTMENU}
  tagMDINEXTMENU = packed record
    hmenuIn: HMENU;
    hmenuNext: HMENU;
    hwndNext: HWND;
  end;
  TMDINextMenu = tagMDINEXTMENU;
  {$EXTERNALSYM MDINEXTMENU}
  MDINEXTMENU = tagMDINEXTMENU;

const
  {$EXTERNALSYM UNICODE_NOCHAR}
  UNICODE_NOCHAR = $FFFF;

  { LOWORD(wParam) values in WM_*UISTATE* }
  {$EXTERNALSYM UIS_SET}
  UIS_SET = 1;
  {$EXTERNALSYM UIS_CLEAR}
  UIS_CLEAR = 2;
  {$EXTERNALSYM UIS_INITIALIZE}
  UIS_INITIALIZE = 3;

  { HIWORD(wParam) values in WM_*UISTATE* }
  {$EXTERNALSYM UISF_HIDEFOCUS}
  UISF_HIDEFOCUS = $1;
  {$EXTERNALSYM UISF_HIDEACCEL}
  UISF_HIDEACCEL = $2;
  {$EXTERNALSYM UISF_ACTIVE}
  UISF_ACTIVE =$4;

const
  { wParam for WM_POWERBROADCAST message  }

  {$EXTERNALSYM PBT_APMQUERYSUSPEND}
  PBT_APMQUERYSUSPEND             = $0000;
  {$EXTERNALSYM PBT_APMQUERYSTANDBY}
  PBT_APMQUERYSTANDBY             = $0001;
  {$EXTERNALSYM PBT_APMQUERYSUSPENDFAILED}
  PBT_APMQUERYSUSPENDFAILED       = $0002;
  {$EXTERNALSYM PBT_APMQUERYSTANDBYFAILED}
  PBT_APMQUERYSTANDBYFAILED       = $0003;
  {$EXTERNALSYM PBT_APMSUSPEND}
  PBT_APMSUSPEND                  = $0004;
  {$EXTERNALSYM PBT_APMSTANDBY}
  PBT_APMSTANDBY                  = $0005;
  {$EXTERNALSYM PBT_APMRESUMECRITICAL}
  PBT_APMRESUMECRITICAL           = $0006;
  {$EXTERNALSYM PBT_APMRESUMESUSPEND}
  PBT_APMRESUMESUSPEND            = $0007;
  {$EXTERNALSYM PBT_APMRESUMESTANDBY}
  PBT_APMRESUMESTANDBY            = $0008;
  {$EXTERNALSYM PBTF_APMRESUMEFROMFAILURE}
  PBTF_APMRESUMEFROMFAILURE       = $00000001;
  {$EXTERNALSYM PBT_APMBATTERYLOW}
  PBT_APMBATTERYLOW               = $0009;
  {$EXTERNALSYM PBT_APMPOWERSTATUSCHANGE}
  PBT_APMPOWERSTATUSCHANGE        = $000A;
  {$EXTERNALSYM PBT_APMOEMEVENT}
  PBT_APMOEMEVENT                 = $000B;
  {$EXTERNALSYM PBT_APMRESUMEAUTOMATIC}
  PBT_APMRESUMEAUTOMATIC          = $0012;

const
  { wParam for WM_NOTIFYWOW message  }

  { wParam for WM_SIZING message  }
  {$EXTERNALSYM WMSZ_LEFT}
  WMSZ_LEFT = 1;
  {$EXTERNALSYM WMSZ_RIGHT}
  WMSZ_RIGHT = 2;
  {$EXTERNALSYM WMSZ_TOP}
  WMSZ_TOP = 3;
  {$EXTERNALSYM WMSZ_TOPLEFT}
  WMSZ_TOPLEFT = 4;
  {$EXTERNALSYM WMSZ_TOPRIGHT}
  WMSZ_TOPRIGHT = 5;
  {$EXTERNALSYM WMSZ_BOTTOM}
  WMSZ_BOTTOM = 6;
  {$EXTERNALSYM WMSZ_BOTTOMLEFT}
  WMSZ_BOTTOMLEFT = 7;
  {$EXTERNALSYM WMSZ_BOTTOMRIGHT}
  WMSZ_BOTTOMRIGHT = 8;

  { WM_SYNCTASK Commands }
  {$EXTERNALSYM ST_BEGINSWP}
  ST_BEGINSWP = 0;
  {$EXTERNALSYM ST_ENDSWP}
  ST_ENDSWP = 1;

  { WM_NCHITTEST and MOUSEHOOKSTRUCT Mouse Position Codes }
  {$EXTERNALSYM HTERROR}
  HTERROR = -2;
  {$EXTERNALSYM HTTRANSPARENT}
  HTTRANSPARENT = -1;
  {$EXTERNALSYM HTNOWHERE}
  HTNOWHERE = 0;
  {$EXTERNALSYM HTCLIENT}
  HTCLIENT = 1;
  {$EXTERNALSYM HTCAPTION}
  HTCAPTION = 2;
  {$EXTERNALSYM HTSYSMENU}
  HTSYSMENU = 3;
  {$EXTERNALSYM HTGROWBOX}
  HTGROWBOX = 4;
  {$EXTERNALSYM HTSIZE}
  HTSIZE = HTGROWBOX;
  {$EXTERNALSYM HTMENU}
  HTMENU = 5;
  {$EXTERNALSYM HTHSCROLL}
  HTHSCROLL = 6;
  {$EXTERNALSYM HTVSCROLL}
  HTVSCROLL = 7;
  {$EXTERNALSYM HTMINBUTTON}
  HTMINBUTTON = 8;
  {$EXTERNALSYM HTMAXBUTTON}
  HTMAXBUTTON = 9;
  {$EXTERNALSYM HTLEFT}
  HTLEFT = 10;
  {$EXTERNALSYM HTRIGHT}
  HTRIGHT = 11;
  {$EXTERNALSYM HTTOP}
  HTTOP = 12;
  {$EXTERNALSYM HTTOPLEFT}
  HTTOPLEFT = 13;
  {$EXTERNALSYM HTTOPRIGHT}
  HTTOPRIGHT = 14;
  {$EXTERNALSYM HTBOTTOM}
  HTBOTTOM = 15;
  {$EXTERNALSYM HTBOTTOMLEFT}
  HTBOTTOMLEFT = $10;
  {$EXTERNALSYM HTBOTTOMRIGHT}
  HTBOTTOMRIGHT = 17;
  {$EXTERNALSYM HTBORDER}
  HTBORDER = 18;
  {$EXTERNALSYM HTREDUCE}
  HTREDUCE = HTMINBUTTON;
  {$EXTERNALSYM HTZOOM}
  HTZOOM = HTMAXBUTTON;
  {$EXTERNALSYM HTSIZEFIRST}
  HTSIZEFIRST = HTLEFT;
  {$EXTERNALSYM HTSIZELAST}
  HTSIZELAST = HTBOTTOMRIGHT;
  {$EXTERNALSYM HTOBJECT}
  HTOBJECT = 19;
  {$EXTERNALSYM HTCLOSE}
  HTCLOSE = 20;
  {$EXTERNALSYM HTHELP}
  HTHELP = 21;

  { SendMessageTimeout values }
  {$EXTERNALSYM SMTO_NORMAL}
  SMTO_NORMAL = 0;
  {$EXTERNALSYM SMTO_BLOCK}
  SMTO_BLOCK = 1;
  {$EXTERNALSYM SMTO_ABORTIFHUNG}
  SMTO_ABORTIFHUNG = 2;
  {$EXTERNALSYM SMTO_NOTIMEOUTIFNOTHUNG}
  SMTO_NOTIMEOUTIFNOTHUNG = 8;

  { WM_MOUSEACTIVATE Return Codes }
  {$EXTERNALSYM MA_ACTIVATE}
  MA_ACTIVATE = 1;
  {$EXTERNALSYM MA_ACTIVATEANDEAT}
  MA_ACTIVATEANDEAT = 2;
  {$EXTERNALSYM MA_NOACTIVATE}
  MA_NOACTIVATE = 3;
  {$EXTERNALSYM MA_NOACTIVATEANDEAT}
  MA_NOACTIVATEANDEAT = 4;

  { WM_SETICON / WM_GETICON Type Codes }
  {$EXTERNALSYM ICON_SMALL}
  ICON_SMALL = 0;
  {$EXTERNALSYM ICON_BIG}
  ICON_BIG = 1;
  {$EXTERNALSYM ICON_SMALL2}
  ICON_SMALL2 = 2;

function RegisterWindowMessage(lpString: PChar): UINT; stdcall;
{$EXTERNALSYM RegisterWindowMessage}
function RegisterWindowMessageA(lpString: PAnsiChar): UINT; stdcall;
{$EXTERNALSYM RegisterWindowMessageA}
function RegisterWindowMessageW(lpString: PWideChar): UINT; stdcall;
{$EXTERNALSYM RegisterWindowMessageW}

const
  { WM_SIZE message wParam values }
  {$EXTERNALSYM SIZE_RESTORED}
  SIZE_RESTORED = 0;
  {$EXTERNALSYM SIZE_MINIMIZED}
  SIZE_MINIMIZED = 1;
  {$EXTERNALSYM SIZE_MAXIMIZED}
  SIZE_MAXIMIZED = 2;
  {$EXTERNALSYM SIZE_MAXSHOW}
  SIZE_MAXSHOW = 3;
  {$EXTERNALSYM SIZE_MAXHIDE}
  SIZE_MAXHIDE = 4;

  { Obsolete constant names }
  {$EXTERNALSYM SIZENORMAL}
  SIZENORMAL = SIZE_RESTORED;
  {$EXTERNALSYM SIZEICONIC}
  SIZEICONIC = SIZE_MINIMIZED;
  {$EXTERNALSYM SIZEFULLSCREEN}
  SIZEFULLSCREEN = SIZE_MAXIMIZED;
  {$EXTERNALSYM SIZEZOOMSHOW}
  SIZEZOOMSHOW = SIZE_MAXSHOW;
  {$EXTERNALSYM SIZEZOOMHIDE}
  SIZEZOOMHIDE = SIZE_MAXHIDE;


type
  { WM_WINDOWPOSCHANGINGCHANGED struct pointed to by lParam }
  PWindowPos = ^TWindowPos;
  {$EXTERNALSYM tagWINDOWPOS}
  tagWINDOWPOS = packed record
    hwnd: HWND;
    hwndInsertAfter: HWND;
    x: Integer;
    y: Integer;
    cx: Integer;
    cy: Integer;
    flags: UINT;
  end;
  TWindowPos = tagWINDOWPOS;
  {$EXTERNALSYM WINDOWPOS}
  WINDOWPOS = tagWINDOWPOS;

  { WM_NCCALCSIZE parameter structure }
  PNCCalcSizeParams = ^TNCCalcSizeParams;
  {$EXTERNALSYM tagNCCALCSIZE_PARAMS}
  tagNCCALCSIZE_PARAMS = packed record
    rgrc: array[0..2] of TRect;
    lppos: PWindowPos;
  end;
  TNCCalcSizeParams = tagNCCALCSIZE_PARAMS;
  {$EXTERNALSYM NCCALCSIZE_PARAMS}
  NCCALCSIZE_PARAMS = tagNCCALCSIZE_PARAMS;


const
  { WM_NCCALCSIZE "window valid rect" return values }
  {$EXTERNALSYM WVR_ALIGNTOP}
  WVR_ALIGNTOP = $10;
  {$EXTERNALSYM WVR_ALIGNLEFT}
  WVR_ALIGNLEFT = $20;
  {$EXTERNALSYM WVR_ALIGNBOTTOM}
  WVR_ALIGNBOTTOM = $40;
  {$EXTERNALSYM WVR_ALIGNRIGHT}
  WVR_ALIGNRIGHT = $80;
  {$EXTERNALSYM WVR_HREDRAW}
  WVR_HREDRAW = $100;
  {$EXTERNALSYM WVR_VREDRAW}
  WVR_VREDRAW = $200;
  {$EXTERNALSYM WVR_REDRAW}
  WVR_REDRAW = (WVR_HREDRAW or WVR_VREDRAW);
  {$EXTERNALSYM WVR_VALIDRECTS}
  WVR_VALIDRECTS = $400;

  { Key State Masks for Mouse Messages }
  {$EXTERNALSYM MK_LBUTTON}
  MK_LBUTTON = 1;
  {$EXTERNALSYM MK_RBUTTON}
  MK_RBUTTON = 2;
  {$EXTERNALSYM MK_SHIFT}
  MK_SHIFT = 4;
  {$EXTERNALSYM MK_CONTROL}
  MK_CONTROL = 8;
  {$EXTERNALSYM MK_MBUTTON}
  MK_MBUTTON = $10;

  {$EXTERNALSYM TME_HOVER}
  TME_HOVER           = $00000001;
  {$EXTERNALSYM TME_LEAVE}
  TME_LEAVE           = $00000002;
  {$EXTERNALSYM TME_QUERY}
  TME_QUERY           = $40000000;
  {$EXTERNALSYM TME_CANCEL}
  TME_CANCEL          = DWORD($80000000);

  {$EXTERNALSYM HOVER_DEFAULT}
  HOVER_DEFAULT       = DWORD($FFFFFFFF);

type
  {$EXTERNALSYM PTrackMouseEvent}
  PTrackMouseEvent = ^TTrackMouseEvent;
  {$EXTERNALSYM tagTRACKMOUSEEVENT}
  tagTRACKMOUSEEVENT = record
    cbSize: DWORD;
    dwFlags: DWORD;
    hwndTrack: HWND;
    dwHoverTime: DWORD;
  end;
  TTrackMouseEvent = tagTRACKMOUSEEVENT;
  {$EXTERNALSYM TTrackMouseEvent}

{$EXTERNALSYM TrackMouseEvent}
function TrackMouseEvent(var EventTrack: TTrackMouseEvent): BOOL; stdcall;

const
  { Window Styles }
  {$EXTERNALSYM WS_OVERLAPPED}
  WS_OVERLAPPED = 0;
  {$EXTERNALSYM WS_POPUP}
  WS_POPUP = DWORD($80000000);
  {$EXTERNALSYM WS_CHILD}
  WS_CHILD = $40000000;
  {$EXTERNALSYM WS_MINIMIZE}
  WS_MINIMIZE = $20000000;
  {$EXTERNALSYM WS_VISIBLE}
  WS_VISIBLE = $10000000;
  {$EXTERNALSYM WS_DISABLED}
  WS_DISABLED = $8000000;
  {$EXTERNALSYM WS_CLIPSIBLINGS}
  WS_CLIPSIBLINGS = $4000000;
  {$EXTERNALSYM WS_CLIPCHILDREN}
  WS_CLIPCHILDREN = $2000000;
  {$EXTERNALSYM WS_MAXIMIZE}
  WS_MAXIMIZE = $1000000;
  {$EXTERNALSYM WS_CAPTION}
  WS_CAPTION = $C00000;      { WS_BORDER or WS_DLGFRAME  }
  {$EXTERNALSYM WS_BORDER}
  WS_BORDER = $800000;
  {$EXTERNALSYM WS_DLGFRAME}
  WS_DLGFRAME = $400000;
  {$EXTERNALSYM WS_VSCROLL}
  WS_VSCROLL = $200000;
  {$EXTERNALSYM WS_HSCROLL}
  WS_HSCROLL = $100000;
  {$EXTERNALSYM WS_SYSMENU}
  WS_SYSMENU = $80000;
  {$EXTERNALSYM WS_THICKFRAME}
  WS_THICKFRAME = $40000;
  {$EXTERNALSYM WS_GROUP}
  WS_GROUP = $20000;
  {$EXTERNALSYM WS_TABSTOP}
  WS_TABSTOP = $10000;

  {$EXTERNALSYM WS_MINIMIZEBOX}
  WS_MINIMIZEBOX = $20000;
  {$EXTERNALSYM WS_MAXIMIZEBOX}
  WS_MAXIMIZEBOX = $10000;

  {$EXTERNALSYM WS_TILED}
  WS_TILED = WS_OVERLAPPED;
  {$EXTERNALSYM WS_ICONIC}
  WS_ICONIC = WS_MINIMIZE;
  {$EXTERNALSYM WS_SIZEBOX}
  WS_SIZEBOX = WS_THICKFRAME;

  { Common Window Styles }
  {$EXTERNALSYM WS_OVERLAPPEDWINDOW}
  WS_OVERLAPPEDWINDOW = (WS_OVERLAPPED or WS_CAPTION or WS_SYSMENU or
    WS_THICKFRAME or WS_MINIMIZEBOX or WS_MAXIMIZEBOX);
  {$EXTERNALSYM WS_TILEDWINDOW}
  WS_TILEDWINDOW = WS_OVERLAPPEDWINDOW;
  {$EXTERNALSYM WS_POPUPWINDOW}
  WS_POPUPWINDOW = (WS_POPUP or WS_BORDER or WS_SYSMENU);
  {$EXTERNALSYM WS_CHILDWINDOW}
  WS_CHILDWINDOW = (WS_CHILD);

  { Extended Window Styles }
  {$EXTERNALSYM WS_EX_DLGMODALFRAME}
  WS_EX_DLGMODALFRAME = 1;
  {$EXTERNALSYM WS_EX_NOPARENTNOTIFY}
  WS_EX_NOPARENTNOTIFY = 4;
  {$EXTERNALSYM WS_EX_TOPMOST}
  WS_EX_TOPMOST = 8;
  {$EXTERNALSYM WS_EX_ACCEPTFILES}
  WS_EX_ACCEPTFILES = $10;
  {$EXTERNALSYM WS_EX_TRANSPARENT}
  WS_EX_TRANSPARENT = $20;
  {$EXTERNALSYM WS_EX_MDICHILD}
  WS_EX_MDICHILD = $40;
  {$EXTERNALSYM WS_EX_TOOLWINDOW}
  WS_EX_TOOLWINDOW = $80;
  {$EXTERNALSYM WS_EX_WINDOWEDGE}
  WS_EX_WINDOWEDGE = $100;
  {$EXTERNALSYM WS_EX_CLIENTEDGE}
  WS_EX_CLIENTEDGE = $200;
  {$EXTERNALSYM WS_EX_CONTEXTHELP}
  WS_EX_CONTEXTHELP = $400;

  {$EXTERNALSYM WS_EX_RIGHT}
  WS_EX_RIGHT = $1000;
  {$EXTERNALSYM WS_EX_LEFT}
  WS_EX_LEFT = 0;
  {$EXTERNALSYM WS_EX_RTLREADING}
  WS_EX_RTLREADING = $2000;
  {$EXTERNALSYM WS_EX_LTRREADING}
  WS_EX_LTRREADING = 0;
  {$EXTERNALSYM WS_EX_LEFTSCROLLBAR}
  WS_EX_LEFTSCROLLBAR = $4000;
  {$EXTERNALSYM WS_EX_RIGHTSCROLLBAR}
  WS_EX_RIGHTSCROLLBAR = 0;

  {$EXTERNALSYM WS_EX_CONTROLPARENT}
  WS_EX_CONTROLPARENT = $10000;
  {$EXTERNALSYM WS_EX_STATICEDGE}
  WS_EX_STATICEDGE = $20000;
  {$EXTERNALSYM WS_EX_APPWINDOW}
  WS_EX_APPWINDOW = $40000;
  {$EXTERNALSYM WS_EX_OVERLAPPEDWINDOW}
  WS_EX_OVERLAPPEDWINDOW = (WS_EX_WINDOWEDGE or WS_EX_CLIENTEDGE);
  {$EXTERNALSYM WS_EX_PALETTEWINDOW}
  WS_EX_PALETTEWINDOW = (WS_EX_WINDOWEDGE or WS_EX_TOOLWINDOW or WS_EX_TOPMOST);

  {$EXTERNALSYM WS_EX_LAYERED}
  WS_EX_LAYERED = $00080000;
  {$EXTERNALSYM WS_EX_NOINHERITLAYOUT}
  WS_EX_NOINHERITLAYOUT = $00100000; // Disable inheritence of mirroring by children
  {$EXTERNALSYM WS_EX_LAYOUTRTL}
  WS_EX_LAYOUTRTL = $00400000; // Right to left mirroring
  {$EXTERNALSYM WS_EX_COMPOSITED}
  WS_EX_COMPOSITED = $02000000;
  {$EXTERNALSYM WS_EX_NOACTIVATE}
  WS_EX_NOACTIVATE = $08000000;

  { Class styles }
  {$EXTERNALSYM CS_VREDRAW}
  CS_VREDRAW = DWORD(1);
  {$EXTERNALSYM CS_HREDRAW}
  CS_HREDRAW = DWORD(2);
  {$EXTERNALSYM CS_KEYCVTWINDOW}
  CS_KEYCVTWINDOW = 4;
  {$EXTERNALSYM CS_DBLCLKS}
  CS_DBLCLKS = 8;
  {$EXTERNALSYM CS_OWNDC}
  CS_OWNDC = $20;
  {$EXTERNALSYM CS_CLASSDC}
  CS_CLASSDC = $40;
  {$EXTERNALSYM CS_PARENTDC}
  CS_PARENTDC = $80;
  {$EXTERNALSYM CS_NOKEYCVT}
  CS_NOKEYCVT = $100;
  {$EXTERNALSYM CS_NOCLOSE}
  CS_NOCLOSE = $200;
  {$EXTERNALSYM CS_SAVEBITS}
  CS_SAVEBITS = $800;
  {$EXTERNALSYM CS_BYTEALIGNCLIENT}
  CS_BYTEALIGNCLIENT = $1000;
  {$EXTERNALSYM CS_BYTEALIGNWINDOW}
  CS_BYTEALIGNWINDOW = $2000;
  {$EXTERNALSYM CS_GLOBALCLASS}
  CS_GLOBALCLASS = $4000;

  {$EXTERNALSYM CS_IME}
  CS_IME = $10000;
  {$EXTERNALSYM CS_DROPSHADOW}
  CS_DROPSHADOW = $20000;

  { WM_PRINT flags }
  {$EXTERNALSYM PRF_CHECKVISIBLE}
  PRF_CHECKVISIBLE = 1;
  {$EXTERNALSYM PRF_NONCLIENT}
  PRF_NONCLIENT = 2;
  {$EXTERNALSYM PRF_CLIENT}
  PRF_CLIENT = 4;
  {$EXTERNALSYM PRF_ERASEBKGND}
  PRF_ERASEBKGND = 8;
  {$EXTERNALSYM PRF_CHILDREN}
  PRF_CHILDREN = $10;
  {$EXTERNALSYM PRF_OWNED}
  PRF_OWNED = $20;

  { 3D border styles }
  {$EXTERNALSYM BDR_RAISEDOUTER}
  BDR_RAISEDOUTER = 1;
  {$EXTERNALSYM BDR_SUNKENOUTER}
  BDR_SUNKENOUTER = 2;
  {$EXTERNALSYM BDR_RAISEDINNER}
  BDR_RAISEDINNER = 4;
  {$EXTERNALSYM BDR_SUNKENINNER}
  BDR_SUNKENINNER = 8;

  {$EXTERNALSYM BDR_OUTER}
  BDR_OUTER = 3;
  {$EXTERNALSYM BDR_INNER}
  BDR_INNER = 12;
  {$EXTERNALSYM BDR_RAISED}
  BDR_RAISED = 5;
  {$EXTERNALSYM BDR_SUNKEN}
  BDR_SUNKEN = 10;

  {$EXTERNALSYM EDGE_RAISED}
  EDGE_RAISED = (BDR_RAISEDOUTER or BDR_RAISEDINNER);
  {$EXTERNALSYM EDGE_SUNKEN}
  EDGE_SUNKEN = (BDR_SUNKENOUTER or BDR_SUNKENINNER);
  {$EXTERNALSYM EDGE_ETCHED}
  EDGE_ETCHED = (BDR_SUNKENOUTER or BDR_RAISEDINNER);
  {$EXTERNALSYM EDGE_BUMP}
  EDGE_BUMP = (BDR_RAISEDOUTER or BDR_SUNKENINNER);

  { Border flags }
  {$EXTERNALSYM BF_LEFT}
  BF_LEFT = 1;
  {$EXTERNALSYM BF_TOP}
  BF_TOP = 2;
  {$EXTERNALSYM BF_RIGHT}
  BF_RIGHT = 4;
  {$EXTERNALSYM BF_BOTTOM}
  BF_BOTTOM = 8;

  {$EXTERNALSYM BF_TOPLEFT}
  BF_TOPLEFT = (BF_TOP or BF_LEFT);
  {$EXTERNALSYM BF_TOPRIGHT}
  BF_TOPRIGHT = (BF_TOP or BF_RIGHT);
  {$EXTERNALSYM BF_BOTTOMLEFT}
  BF_BOTTOMLEFT = (BF_BOTTOM or BF_LEFT);
  {$EXTERNALSYM BF_BOTTOMRIGHT}
  BF_BOTTOMRIGHT = (BF_BOTTOM or BF_RIGHT);
  {$EXTERNALSYM BF_RECT}
  BF_RECT = (BF_LEFT or BF_TOP or BF_RIGHT or BF_BOTTOM);

  {$EXTERNALSYM BF_DIAGONAL}
  BF_DIAGONAL = $10;

  { For diagonal lines, the BF_RECT flags specify the end point of the}
  { vector bounded by the rectangle parameter.}
  {$EXTERNALSYM BF_DIAGONAL_ENDTOPRIGHT}
  BF_DIAGONAL_ENDTOPRIGHT = (BF_DIAGONAL or BF_TOP or BF_RIGHT);
  {$EXTERNALSYM BF_DIAGONAL_ENDTOPLEFT}
  BF_DIAGONAL_ENDTOPLEFT = (BF_DIAGONAL or BF_TOP or BF_LEFT);
  {$EXTERNALSYM BF_DIAGONAL_ENDBOTTOMLEFT}
  BF_DIAGONAL_ENDBOTTOMLEFT = (BF_DIAGONAL or BF_BOTTOM or BF_LEFT);
  {$EXTERNALSYM BF_DIAGONAL_ENDBOTTOMRIGHT}
  BF_DIAGONAL_ENDBOTTOMRIGHT = (BF_DIAGONAL or BF_BOTTOM or BF_RIGHT);

  {$EXTERNALSYM BF_MIDDLE}
  BF_MIDDLE = $800;   { Fill in the middle }
  {$EXTERNALSYM BF_SOFT}
  BF_SOFT = $1000;    { For softer buttons }
  {$EXTERNALSYM BF_ADJUST}
  BF_ADJUST = $2000;  { Calculate the space left over }
  {$EXTERNALSYM BF_FLAT}
  BF_FLAT = $4000;    { For flat rather than 3D borders }
  {$EXTERNALSYM BF_MONO}
  BF_MONO = $8000;    { For monochrome borders }

{$EXTERNALSYM DrawEdge}
function DrawEdge(hdc: HDC; var qrc: TRect; edge: UINT; grfFlags: UINT): BOOL; stdcall;

const
  { flags for DrawFrameControl }
  {$EXTERNALSYM DFC_CAPTION}
  DFC_CAPTION = 1;
  {$EXTERNALSYM DFC_MENU}
  DFC_MENU = 2;
  {$EXTERNALSYM DFC_SCROLL}
  DFC_SCROLL = 3;
  {$EXTERNALSYM DFC_BUTTON}
  DFC_BUTTON = 4;
  {$EXTERNALSYM DFC_POPUPMENU}
  DFC_POPUPMENU = 5;

  {$EXTERNALSYM DFCS_CAPTIONCLOSE}
  DFCS_CAPTIONCLOSE = 0;
  {$EXTERNALSYM DFCS_CAPTIONMIN}
  DFCS_CAPTIONMIN = 1;
  {$EXTERNALSYM DFCS_CAPTIONMAX}
  DFCS_CAPTIONMAX = 2;
  {$EXTERNALSYM DFCS_CAPTIONRESTORE}
  DFCS_CAPTIONRESTORE = 3;
  {$EXTERNALSYM DFCS_CAPTIONHELP}
  DFCS_CAPTIONHELP = 4;

  {$EXTERNALSYM DFCS_MENUARROW}
  DFCS_MENUARROW = 0;
  {$EXTERNALSYM DFCS_MENUCHECK}
  DFCS_MENUCHECK = 1;
  {$EXTERNALSYM DFCS_MENUBULLET}
  DFCS_MENUBULLET = 2;
  {$EXTERNALSYM DFCS_MENUARROWRIGHT}
  DFCS_MENUARROWRIGHT = 4;

  {$EXTERNALSYM DFCS_SCROLLUP}
  DFCS_SCROLLUP = 0;
  {$EXTERNALSYM DFCS_SCROLLDOWN}
  DFCS_SCROLLDOWN = 1;
  {$EXTERNALSYM DFCS_SCROLLLEFT}
  DFCS_SCROLLLEFT = 2;
  {$EXTERNALSYM DFCS_SCROLLRIGHT}
  DFCS_SCROLLRIGHT = 3;
  {$EXTERNALSYM DFCS_SCROLLCOMBOBOX}
  DFCS_SCROLLCOMBOBOX = 5;
  {$EXTERNALSYM DFCS_SCROLLSIZEGRIP}
  DFCS_SCROLLSIZEGRIP = 8;
  {$EXTERNALSYM DFCS_SCROLLSIZEGRIPRIGHT}
  DFCS_SCROLLSIZEGRIPRIGHT = $10;

  {$EXTERNALSYM DFCS_BUTTONCHECK}
  DFCS_BUTTONCHECK = 0;
  {$EXTERNALSYM DFCS_BUTTONRADIOIMAGE}
  DFCS_BUTTONRADIOIMAGE = 1;
  {$EXTERNALSYM DFCS_BUTTONRADIOMASK}
  DFCS_BUTTONRADIOMASK = 2;
  {$EXTERNALSYM DFCS_BUTTONRADIO}
  DFCS_BUTTONRADIO = 4;
  {$EXTERNALSYM DFCS_BUTTON3STATE}
  DFCS_BUTTON3STATE = 8;
  {$EXTERNALSYM DFCS_BUTTONPUSH}
  DFCS_BUTTONPUSH = $10;

  {$EXTERNALSYM DFCS_INACTIVE}
  DFCS_INACTIVE = $100;
  {$EXTERNALSYM DFCS_PUSHED}
  DFCS_PUSHED = $200;
  {$EXTERNALSYM DFCS_CHECKED}
  DFCS_CHECKED = $400;
  {$EXTERNALSYM DFCS_TRANSPARENT}
  DFCS_TRANSPARENT = $800;
  {$EXTERNALSYM DFCS_HOT}
  DFCS_HOT = $1000;
  {$EXTERNALSYM DFCS_ADJUSTRECT}
  DFCS_ADJUSTRECT = $2000;
  {$EXTERNALSYM DFCS_FLAT}
  DFCS_FLAT = $4000;
  {$EXTERNALSYM DFCS_MONO}
  DFCS_MONO = $8000;

{$EXTERNALSYM DrawFrameControl}
function DrawFrameControl(DC: HDC; const Rect: TRect; uType, uState: UINT): BOOL; stdcall;

const
  { flags for DrawCaption }
  {$EXTERNALSYM DC_ACTIVE}
  DC_ACTIVE = 1;
  {$EXTERNALSYM DC_SMALLCAP}
  DC_SMALLCAP = 2;
  {$EXTERNALSYM DC_ICON}
  DC_ICON = 4;
  {$EXTERNALSYM DC_TEXT}
  DC_TEXT = 8;
  {$EXTERNALSYM DC_INBUTTON}
  DC_INBUTTON = $10;
  {$EXTERNALSYM DC_GRADIENT}
  DC_GRADIENT = $20;
  {$EXTERNALSYM DC_BUTTONS}
  DC_BUTTONS = $1000;

{!!! doesn't match help !!!}
{$EXTERNALSYM DrawCaption}
function DrawCaption(p1: HWND; p2: HDC; const p3: TRect; p4: UINT): BOOL; stdcall;

const
  {$EXTERNALSYM IDANI_OPEN}
  IDANI_OPEN = 1;
  {$EXTERNALSYM IDANI_CLOSE}
  IDANI_CLOSE = 2;
  {$EXTERNALSYM IDANI_CAPTION}
  IDANI_CAPTION = 3;

{$EXTERNALSYM DrawAnimatedRects}
function DrawAnimatedRects(hwnd: HWND; idAni: Integer; const lprcFrom, lprcTo: TRect): BOOL; stdcall;

const
  { Predefined Clipboard Formats }
  {$EXTERNALSYM CF_TEXT}
  CF_TEXT = 1;
  {$EXTERNALSYM CF_BITMAP}
  CF_BITMAP = 2;
  {$EXTERNALSYM CF_METAFILEPICT}
  CF_METAFILEPICT = 3;
  {$EXTERNALSYM CF_SYLK}
  CF_SYLK = 4;
  {$EXTERNALSYM CF_DIF}
  CF_DIF = 5;
  {$EXTERNALSYM CF_TIFF}
  CF_TIFF = 6;
  {$EXTERNALSYM CF_OEMTEXT}
  CF_OEMTEXT = 7;
  {$EXTERNALSYM CF_DIB}
  CF_DIB = 8;
  {$EXTERNALSYM CF_PALETTE}
  CF_PALETTE = 9;
  {$EXTERNALSYM CF_PENDATA}
  CF_PENDATA = 10;
  {$EXTERNALSYM CF_RIFF}
  CF_RIFF = 11;
  {$EXTERNALSYM CF_WAVE}
  CF_WAVE = 12;
  {$EXTERNALSYM CF_UNICODETEXT}
  CF_UNICODETEXT = 13;
  {$EXTERNALSYM CF_ENHMETAFILE}
  CF_ENHMETAFILE = 14;
  {$EXTERNALSYM CF_HDROP}
  CF_HDROP = 15;
  {$EXTERNALSYM CF_LOCALE}
  CF_LOCALE = $10;
  {$EXTERNALSYM CF_MAX}
  CF_MAX = 17;
  {$EXTERNALSYM CF_DIBV5}
  CF_DIBV5 = 17;

  {$EXTERNALSYM CF_MAX_XP}
  CF_MAX_XP = 18;

  {$EXTERNALSYM CF_OWNERDISPLAY}
  CF_OWNERDISPLAY = 128;
  {$EXTERNALSYM CF_DSPTEXT}
  CF_DSPTEXT = 129;
  {$EXTERNALSYM CF_DSPBITMAP}
  CF_DSPBITMAP = 130;
  {$EXTERNALSYM CF_DSPMETAFILEPICT}
  CF_DSPMETAFILEPICT = 131;
  {$EXTERNALSYM CF_DSPENHMETAFILE}
  CF_DSPENHMETAFILE = 142;

  { "Private" formats don't get GlobalFree()'d }
  {$EXTERNALSYM CF_PRIVATEFIRST}
  CF_PRIVATEFIRST = $200;
  {$EXTERNALSYM CF_PRIVATELAST}
  CF_PRIVATELAST = 767;

  { "GDIOBJ" formats do get DeleteObject()'d }
  {$EXTERNALSYM CF_GDIOBJFIRST}
  CF_GDIOBJFIRST = 768;
  {$EXTERNALSYM CF_GDIOBJLAST}
  CF_GDIOBJLAST = 1023;


  { Defines for the fVirt field of the Accelerator table structure. }
  {$EXTERNALSYM FVIRTKEY}
  FVIRTKEY = 1;
  {$EXTERNALSYM FNOINVERT}
  FNOINVERT = 2;
  {$EXTERNALSYM FSHIFT}
  FSHIFT = 4;
  {$EXTERNALSYM FCONTROL}
  FCONTROL = 8;
  {$EXTERNALSYM FALT}
  FALT = $10;

type
  PAccel = ^TAccel;
  {$EXTERNALSYM tagACCEL}
  tagACCEL = packed record
    fVirt: Word;     { Also called the flags field }
    key: Word;
    cmd: Word;
  end;
  TAccel = tagACCEL;
  {$EXTERNALSYM ACCEL}
  ACCEL = tagACCEL;

  PPaintStruct = ^TPaintStruct;
  {$EXTERNALSYM tagPAINTSTRUCT}
  tagPAINTSTRUCT = packed record
    hdc: HDC;
    fErase: BOOL;
    rcPaint: TRect;
    fRestore: BOOL;
    fIncUpdate: BOOL;
    rgbReserved: array[0..31] of Byte;
  end;
  TPaintStruct = tagPAINTSTRUCT;
  {$EXTERNALSYM PAINTSTRUCT}
  PAINTSTRUCT = tagPAINTSTRUCT;

  PWindowPlacement = ^TWindowPlacement;
  {$EXTERNALSYM tagWINDOWPLACEMENT}
  tagWINDOWPLACEMENT = packed record
    length: UINT;
    flags: UINT;
    showCmd: UINT;
    ptMinPosition: TPoint;
    ptMaxPosition: TPoint;
    rcNormalPosition: TRect;
  end;
  TWindowPlacement = tagWINDOWPLACEMENT;
  {$EXTERNALSYM WINDOWPLACEMENT}
  WINDOWPLACEMENT = tagWINDOWPLACEMENT;

const
  {$EXTERNALSYM WPF_SETMINPOSITION}
  WPF_SETMINPOSITION = 1;
  {$EXTERNALSYM WPF_RESTORETOMAXIMIZED}
  WPF_RESTORETOMAXIMIZED = 2;

type
  PNMHdr = ^TNMHdr;
  {$EXTERNALSYM tagNMHDR}
  tagNMHDR = packed record
    hwndFrom: HWND;
    idFrom: UINT;
    code: Integer;     { NM_ code }
  end;
  TNMHdr = tagNMHDR;
  {$EXTERNALSYM NMHDR}
  NMHDR = tagNMHDR;

  PStyleStruct = ^TStyleStruct;
  {$EXTERNALSYM tagSTYLESTRUCT}
  tagSTYLESTRUCT = packed record
    styleOld: DWORD;
    styleNew: DWORD;
  end;
  TStyleStruct = tagSTYLESTRUCT;
  {$EXTERNALSYM STYLESTRUCT}
  STYLESTRUCT = tagSTYLESTRUCT;

const
  { Owner draw control types }
  {$EXTERNALSYM ODT_MENU}
  ODT_MENU = 1;
  {$EXTERNALSYM ODT_LISTBOX}
  ODT_LISTBOX = 2;
  {$EXTERNALSYM ODT_COMBOBOX}
  ODT_COMBOBOX = 3;
  {$EXTERNALSYM ODT_BUTTON}
  ODT_BUTTON = 4;
  {$EXTERNALSYM ODT_STATIC}
  ODT_STATIC = 5;

  { Owner draw actions }
  {$EXTERNALSYM ODA_DRAWENTIRE}
  ODA_DRAWENTIRE = 1;
  {$EXTERNALSYM ODA_SELECT}
  ODA_SELECT = 2;
  {$EXTERNALSYM ODA_FOCUS}
  ODA_FOCUS = 4;

  { Owner draw state }
  {$EXTERNALSYM ODS_SELECTED}
  ODS_SELECTED = 1;
  {$EXTERNALSYM ODS_GRAYED}
  ODS_GRAYED = 2;
  {$EXTERNALSYM ODS_DISABLED}
  ODS_DISABLED = 4;
  {$EXTERNALSYM ODS_CHECKED}
  ODS_CHECKED = 8;
  {$EXTERNALSYM ODS_FOCUS}
  ODS_FOCUS = $10;
  {$EXTERNALSYM ODS_DEFAULT}
  ODS_DEFAULT = $20;
  {$EXTERNALSYM ODS_COMBOBOXEDIT}
  ODS_COMBOBOXEDIT = $1000;
  {$EXTERNALSYM ODS_HOTLIGHT}
  ODS_HOTLIGHT = $40;
  {$EXTERNALSYM ODS_INACTIVE}
  ODS_INACTIVE = $80;

type  
  TOwnerDrawState = set of (odSelected, odGrayed, odDisabled, odChecked,
    odFocused, odDefault, odHotLight, odInactive, odNoAccel, odNoFocusRect,
    odReserved1, odReserved2, odComboBoxEdit);

type
  { for ownerdraw }
  PMeasureItemStruct = ^TMeasureItemStruct;
  {$EXTERNALSYM tagMEASUREITEMSTRUCT}
  tagMEASUREITEMSTRUCT = packed record
    CtlType: UINT;
    CtlID: UINT;
    itemID: UINT;
    itemWidth: UINT;
    itemHeight: UINT;
    itemData: DWORD;
  end;
  TMeasureItemStruct = tagMEASUREITEMSTRUCT;
  {$EXTERNALSYM MEASUREITEMSTRUCT}
  MEASUREITEMSTRUCT = tagMEASUREITEMSTRUCT;

  { for ownerdraw }
  PDrawItemStruct = ^TDrawItemStruct;
  {$EXTERNALSYM tagDRAWITEMSTRUCT}
  tagDRAWITEMSTRUCT = packed record
    CtlType: UINT;
    CtlID: UINT;
    itemID: UINT;
    itemAction: UINT;
    itemState: UINT;
    hwndItem: HWND;
    hDC: HDC;
    rcItem: TRect;
    itemData: DWORD;
  end;
  TDrawItemStruct = tagDRAWITEMSTRUCT;
  {$EXTERNALSYM DRAWITEMSTRUCT}
  DRAWITEMSTRUCT = tagDRAWITEMSTRUCT;

  { for ownerdraw }
  PDeleteItemStruct = ^TDeleteItemStruct;
  {$EXTERNALSYM tagDELETEITEMSTRUCT}
  tagDELETEITEMSTRUCT = packed record
    CtlType: UINT;
    CtlID: UINT;
    itemID: UINT;
    hwndItem: HWND;
    itemData: UINT;
  end;
  TDeleteItemStruct = tagDELETEITEMSTRUCT;
  {$EXTERNALSYM DELETEITEMSTRUCT}
  DELETEITEMSTRUCT = tagDELETEITEMSTRUCT;

  { for ownerdraw sorting }
  PCompareItemStruct = ^TCompareItemStruct;
  {$EXTERNALSYM tagCOMPAREITEMSTRUCT}
  tagCOMPAREITEMSTRUCT = packed record
    CtlType: UINT;
    CtlID: UINT;
    hwndItem: HWND;
    itemID1: UINT;
    itemData1: DWORD;
    itemID2: UINT;
    itemData2: DWORD;
    dwLocaleId: DWORD;
  end;
  TCompareItemStruct = tagCOMPAREITEMSTRUCT;
  {$EXTERNALSYM COMPAREITEMSTRUCT}
  COMPAREITEMSTRUCT = tagCOMPAREITEMSTRUCT;

{ Message Function Templates }

{$EXTERNALSYM GetMessage}
function GetMessage(var lpMsg: TMsg; hWnd: HWND;
  wMsgFilterMin, wMsgFilterMax: UINT): BOOL; stdcall;
{$EXTERNALSYM GetMessageA}
function GetMessageA(var lpMsg: TMsg; hWnd: HWND;
  wMsgFilterMin, wMsgFilterMax: UINT): BOOL; stdcall;
{$EXTERNALSYM GetMessageW}
function GetMessageW(var lpMsg: TMsg; hWnd: HWND;
  wMsgFilterMin, wMsgFilterMax: UINT): BOOL; stdcall;
{$EXTERNALSYM DispatchMessage}
function DispatchMessage(const lpMsg: TMsg): Longint; stdcall;
{$EXTERNALSYM DispatchMessageA}
function DispatchMessageA(const lpMsg: TMsg): Longint; stdcall;
{$EXTERNALSYM DispatchMessageW}
function DispatchMessageW(const lpMsg: TMsg): Longint; stdcall;
{$EXTERNALSYM TranslateMessage}
function TranslateMessage(const lpMsg: TMsg): BOOL; stdcall;
{$EXTERNALSYM SetMessageQueue}
function SetMessageQueue(cMessagesMax: Integer): BOOL; stdcall;
{$EXTERNALSYM PeekMessage}
function PeekMessage(var lpMsg: TMsg; hWnd: HWND;
  wMsgFilterMin, wMsgFilterMax, wRemoveMsg: UINT): BOOL; stdcall;
{$EXTERNALSYM PeekMessageA}
function PeekMessageA(var lpMsg: TMsg; hWnd: HWND;
  wMsgFilterMin, wMsgFilterMax, wRemoveMsg: UINT): BOOL; stdcall;
{$EXTERNALSYM PeekMessageW}
function PeekMessageW(var lpMsg: TMsg; hWnd: HWND;
  wMsgFilterMin, wMsgFilterMax, wRemoveMsg: UINT): BOOL; stdcall;

const
  { PeekMessage() Options }
  {$EXTERNALSYM PM_NOREMOVE}
  PM_NOREMOVE = 0;
  {$EXTERNALSYM PM_REMOVE}
  PM_REMOVE = 1;
  {$EXTERNALSYM PM_NOYIELD}
  PM_NOYIELD = 2;

{$EXTERNALSYM RegisterHotKey}
function RegisterHotKey(hWnd: HWND; id: Integer; fsModifiers, vk: UINT): BOOL; stdcall;
{$EXTERNALSYM UnregisterHotKey}
function UnregisterHotKey(hWnd: HWND; id: Integer): BOOL; stdcall;

const
  {$EXTERNALSYM MOD_ALT}
  MOD_ALT = 1;
  {$EXTERNALSYM MOD_CONTROL}
  MOD_CONTROL = 2;
  {$EXTERNALSYM MOD_SHIFT}
  MOD_SHIFT = 4;
  {$EXTERNALSYM MOD_WIN}
  MOD_WIN = 8;

  {$EXTERNALSYM IDHOT_SNAPWINDOW}
  IDHOT_SNAPWINDOW = -1;    { SHIFT-PRINTSCRN  }
  {$EXTERNALSYM IDHOT_SNAPDESKTOP}
  IDHOT_SNAPDESKTOP = -2;   { PRINTSCRN        }

  {$EXTERNALSYM EW_RESTARTWINDOWS}
  EW_RESTARTWINDOWS        = $0042;
  {$EXTERNALSYM EW_REBOOTSYSTEM}
  EW_REBOOTSYSTEM          = $0043;
  {$EXTERNALSYM EW_EXITANDEXECAPP}
  EW_EXITANDEXECAPP        = $0044;

  {$EXTERNALSYM ENDSESSION_LOGOFF}
  ENDSESSION_LOGOFF        = DWORD($80000000);

  {$EXTERNALSYM EWX_LOGOFF}
  EWX_LOGOFF = 0;
  {$EXTERNALSYM EWX_SHUTDOWN}
  EWX_SHUTDOWN = 1;
  {$EXTERNALSYM EWX_REBOOT}
  EWX_REBOOT = 2;
  {$EXTERNALSYM EWX_FORCE}
  EWX_FORCE = 4;
  {$EXTERNALSYM EWX_POWEROFF}
  EWX_POWEROFF = 8;
  {$EXTERNALSYM EWX_FORCEIFHUNG}
  EWX_FORCEIFHUNG = $10;


{$EXTERNALSYM ExitWindows}
function ExitWindows(dwReserved: DWORD; Code: Word): BOOL; inline;

{$EXTERNALSYM ExitWindowsEx}
function ExitWindowsEx(uFlags: UINT; dwReserved: DWORD): BOOL; stdcall;
{$EXTERNALSYM SwapMouseButton}
function SwapMouseButton(fSwap: BOOL): BOOL; stdcall;
{$EXTERNALSYM GetMessagePos}
function GetMessagePos: DWORD; stdcall;
{$EXTERNALSYM GetMessageTime}
function GetMessageTime: Longint; stdcall;
{$EXTERNALSYM GetMessageExtraInfo}
function GetMessageExtraInfo: Longint; stdcall;
{$EXTERNALSYM SetMessageExtraInfo}
function SetMessageExtraInfo(lParam: LPARAM): LPARAM; stdcall;

{$EXTERNALSYM SendMessage}
function SendMessage(hWnd: HWND; Msg: UINT; wParam: WPARAM; lParam: LPARAM): LRESULT; stdcall;
{$EXTERNALSYM SendMessageA}
function SendMessageA(hWnd: HWND; Msg: UINT; wParam: WPARAM; lParam: LPARAM): LRESULT; stdcall;
{$EXTERNALSYM SendMessageW}
function SendMessageW(hWnd: HWND; Msg: UINT; wParam: WPARAM; lParam: LPARAM): LRESULT; stdcall;
{$EXTERNALSYM SendMessageTimeout}
function SendMessageTimeout(hWnd: HWND; Msg: UINT; wParam: WPARAM;
  lParam: LPARAM; fuFlags, uTimeout: UINT; var lpdwResult: DWORD): LRESULT; stdcall;
{$EXTERNALSYM SendMessageTimeoutA}
function SendMessageTimeoutA(hWnd: HWND; Msg: UINT; wParam: WPARAM;
  lParam: LPARAM; fuFlags, uTimeout: UINT; var lpdwResult: DWORD): LRESULT; stdcall;
{$EXTERNALSYM SendMessageTimeoutW}
function SendMessageTimeoutW(hWnd: HWND; Msg: UINT; wParam: WPARAM;
  lParam: LPARAM; fuFlags, uTimeout: UINT; var lpdwResult: DWORD): LRESULT; stdcall;
{$EXTERNALSYM SendNotifyMessage}
function SendNotifyMessage(hWnd: HWND; Msg: UINT; wParam: WPARAM;
  lParam: LPARAM): BOOL; stdcall;
{$EXTERNALSYM SendNotifyMessageA}
function SendNotifyMessageA(hWnd: HWND; Msg: UINT; wParam: WPARAM;
  lParam: LPARAM): BOOL; stdcall;
{$EXTERNALSYM SendNotifyMessageW}
function SendNotifyMessageW(hWnd: HWND; Msg: UINT; wParam: WPARAM;
  lParam: LPARAM): BOOL; stdcall;
{$EXTERNALSYM SendMessageCallback}
function SendMessageCallback(hWnd: HWND; Msg: UINT; wParam: WPARAM;
  lParam: LPARAM; lpResultCallBack: TFNSendAsyncProc; dwData: DWORD): BOOL; stdcall;
{$EXTERNALSYM SendMessageCallbackA}
function SendMessageCallbackA(hWnd: HWND; Msg: UINT; wParam: WPARAM;
  lParam: LPARAM; lpResultCallBack: TFNSendAsyncProc; dwData: DWORD): BOOL; stdcall;
{$EXTERNALSYM SendMessageCallbackW}
function SendMessageCallbackW(hWnd: HWND; Msg: UINT; wParam: WPARAM;
  lParam: LPARAM; lpResultCallBack: TFNSendAsyncProc; dwData: DWORD): BOOL; stdcall;
{$EXTERNALSYM BroadcastSystemMessage}
function BroadcastSystemMessage(Flags: DWORD; Recipients: PDWORD;
  uiMessage: UINT; wParam: WPARAM; lParam: LPARAM): Longint; stdcall;
{$EXTERNALSYM BroadcastSystemMessageA}
function BroadcastSystemMessageA(Flags: DWORD; Recipients: PDWORD;
  uiMessage: UINT; wParam: WPARAM; lParam: LPARAM): Longint; stdcall;
{$EXTERNALSYM BroadcastSystemMessageW}
function BroadcastSystemMessageW(Flags: DWORD; Recipients: PDWORD;
  uiMessage: UINT; wParam: WPARAM; lParam: LPARAM): Longint; stdcall;

const
  { Broadcast Special Message Recipient list }
  {$EXTERNALSYM BSM_ALLCOMPONENTS}
  BSM_ALLCOMPONENTS = $00000000;
  {$EXTERNALSYM BSM_VXDS}
  BSM_VXDS = $00000001;
  {$EXTERNALSYM BSM_NETDRIVER}
  BSM_NETDRIVER = $00000002;
  {$EXTERNALSYM BSM_INSTALLABLEDRIVERS}
  BSM_INSTALLABLEDRIVERS = $00000004;
  {$EXTERNALSYM BSM_APPLICATIONS}
  BSM_APPLICATIONS = $00000008;
  {$EXTERNALSYM BSM_ALLDESKTOPS}
  BSM_ALLDESKTOPS = $00000010;

  { Broadcast Special Message Flags }
  {$EXTERNALSYM BSF_QUERY}
  BSF_QUERY = $00000001;
  {$EXTERNALSYM BSF_IGNORECURRENTTASK}
  BSF_IGNORECURRENTTASK = $00000002;
  {$EXTERNALSYM BSF_FLUSHDISK}
  BSF_FLUSHDISK = $00000004;
  {$EXTERNALSYM BSF_NOHANG}
  BSF_NOHANG = $00000008;
  {$EXTERNALSYM BSF_POSTMESSAGE}
  BSF_POSTMESSAGE = $00000010;
  {$EXTERNALSYM BSF_FORCEIFHUNG}
  BSF_FORCEIFHUNG = $00000020;
  {$EXTERNALSYM BSF_NOTIMEOUTIFNOTHUNG}
  BSF_NOTIMEOUTIFNOTHUNG = $00000040;

type
  PBroadcastSysMsg = ^TBroadcastSysMsg;
//  {$EXTERNALSYM tagBROADCASTSYSMSG}
  tagBROADCASTSYSMSG = packed record
    uiMessage: UINT;
    wParam: WPARAM;
    lParam: LPARAM;
  end;
  TBroadcastSysMsg = tagBROADCASTSYSMSG;
//  {$EXTERNALSYM BROADCASTSYSMSG}
  BROADCASTSYSMSG = tagBROADCASTSYSMSG;

const
  {$EXTERNALSYM DBWF_LPARAMPOINTER}
  DBWF_LPARAMPOINTER = $8000;

  {$EXTERNALSYM BROADCAST_QUERY_DENY}
  BROADCAST_QUERY_DENY = $424D5144;  { Return this value to deny a query. }

type
  {$EXTERNALSYM HDEVNOTIFY}
  HDEVNOTIFY = Pointer;
  {$EXTERNALSYM PHDEVNOTIFY}
  PHDEVNOTIFY = ^HDEVNOTIFY;

const
  {$EXTERNALSYM DEVICE_NOTIFY_WINDOW_HANDLE}
  DEVICE_NOTIFY_WINDOW_HANDLE = 0;

{$EXTERNALSYM RegisterDeviceNotification}
function RegisterDeviceNotification(hRecipient: THandle; NotificationFilter: Pointer; Flags: DWORD): HDEVNOTIFY; stdcall;
{$EXTERNALSYM RegisterDeviceNotificationA}
function RegisterDeviceNotificationA(hRecipient: THandle; NotificationFilter: Pointer; Flags: DWORD): HDEVNOTIFY; stdcall;
{$EXTERNALSYM RegisterDeviceNotificationW}
function RegisterDeviceNotificationW(hRecipient: THandle; NotificationFilter: Pointer; Flags: DWORD): HDEVNOTIFY; stdcall;
{$EXTERNALSYM UnregisterDeviceNotification}
function UnregisterDeviceNotification(Handle: HDEVNOTIFY): BOOL; stdcall;

{$EXTERNALSYM PostMessage}
function PostMessage(hWnd: HWND; Msg: UINT; wParam: WPARAM; lParam: LPARAM): BOOL; stdcall;
{$EXTERNALSYM PostMessageA}
function PostMessageA(hWnd: HWND; Msg: UINT; wParam: WPARAM; lParam: LPARAM): BOOL; stdcall;
{$EXTERNALSYM PostMessageW}
function PostMessageW(hWnd: HWND; Msg: UINT; wParam: WPARAM; lParam: LPARAM): BOOL; stdcall;
{$EXTERNALSYM PostThreadMessage}
function PostThreadMessage(idThread: DWORD; Msg: UINT; wParam: WPARAM; lParam: LPARAM): BOOL; stdcall;
{$EXTERNALSYM PostThreadMessageA}
function PostThreadMessageA(idThread: DWORD; Msg: UINT; wParam: WPARAM; lParam: LPARAM): BOOL; stdcall;
{$EXTERNALSYM PostThreadMessageW}
function PostThreadMessageW(idThread: DWORD; Msg: UINT; wParam: WPARAM; lParam: LPARAM): BOOL; stdcall;
{$EXTERNALSYM PostAppMessage}
function PostAppMessage(idThread: DWORD; Msg: UINT; wParam: WPARAM; lParam: LPARAM): BOOL;
{$EXTERNALSYM PostAppMessageA}
function PostAppMessageA(idThread: DWORD; Msg: UINT; wParam: WPARAM; lParam: LPARAM): BOOL;
{$EXTERNALSYM PostAppMessageW}
function PostAppMessageW(idThread: DWORD; Msg: UINT; wParam: WPARAM; lParam: LPARAM): BOOL;

const
  { Special HWND value for use with PostMessage() and SendMessage() }
  {$EXTERNALSYM HWND_BROADCAST}
  HWND_BROADCAST = $FFFF;
  wnd_Broadcast = HWND_BROADCAST;

  {$EXTERNALSYM HWND_MESSAGE}
  HWND_MESSAGE = HWND(-3);

// to eliminate the compiler warrnings from Windows.hpp
// to be further investigated in more detail!
//  {$EXTERNALSYM wnd_Message}
//  (*$HPPEMIT 'static const HWND wnd_Message = (HWND)HWND_MESSAGE;'*)
//  wnd_Message = HWND_MESSAGE;

{$EXTERNALSYM AttachThreadInput}
function AttachThreadInput(idAttach, idAttachTo: DWORD; fAttach: BOOL): BOOL; stdcall;
{$EXTERNALSYM ReplyMessage}
function ReplyMessage(lResult: LRESULT): BOOL; stdcall;
{$EXTERNALSYM WaitMessage}
function WaitMessage: BOOL; stdcall;
{$EXTERNALSYM WaitForInputIdle}
function WaitForInputIdle(hProcess: THandle; dwMilliseconds: DWORD): DWORD; stdcall;
{$EXTERNALSYM DefWindowProc}
function DefWindowProc(hWnd: HWND; Msg: UINT; wParam: WPARAM; lParam: LPARAM): LRESULT; stdcall;
{$EXTERNALSYM DefWindowProcA}
function DefWindowProcA(hWnd: HWND; Msg: UINT; wParam: WPARAM; lParam: LPARAM): LRESULT; stdcall;
{$EXTERNALSYM DefWindowProcW}
function DefWindowProcW(hWnd: HWND; Msg: UINT; wParam: WPARAM; lParam: LPARAM): LRESULT; stdcall;
{$EXTERNALSYM CallWindowProc}
function CallWindowProc(lpPrevWndFunc: TFNWndProc; hWnd: HWND; Msg: UINT; wParam: WPARAM; lParam: LPARAM): LRESULT; stdcall;
{$EXTERNALSYM CallWindowProcA}
function CallWindowProcA(lpPrevWndFunc: TFNWndProc; hWnd: HWND; Msg: UINT; wParam: WPARAM; lParam: LPARAM): LRESULT; stdcall;
{$EXTERNALSYM CallWindowProcW}
function CallWindowProcW(lpPrevWndFunc: TFNWndProc; hWnd: HWND; Msg: UINT; wParam: WPARAM; lParam: LPARAM): LRESULT; stdcall;
{$EXTERNALSYM PostQuitMessage}
procedure PostQuitMessage(nExitCode: Integer); stdcall;
{$EXTERNALSYM InSendMessage}
function InSendMessage: BOOL; stdcall;
{$EXTERNALSYM InSendMessageEx}
function InSendMessageEx(lpReserved: Pointer): DWORD; stdcall;

const
  { InSendMessageEx return value }
  {$EXTERNALSYM ISMEX_NOSEND}
  ISMEX_NOSEND = 0;
  {$EXTERNALSYM ISMEX_SEND}
  ISMEX_SEND = 1;
  {$EXTERNALSYM ISMEX_NOTIFY}
  ISMEX_NOTIFY = 2;
  {$EXTERNALSYM ISMEX_CALLBACK}
  ISMEX_CALLBACK = 4;
  {$EXTERNALSYM ISMEX_REPLIED}
  ISMEX_REPLIED = 8;

{$EXTERNALSYM GetDoubleClickTime}
function GetDoubleClickTime: UINT; stdcall;
{$EXTERNALSYM SetDoubleClickTime}
function SetDoubleClickTime(Interval: UINT): BOOL; stdcall;
{$EXTERNALSYM RegisterClass}
function RegisterClass(const lpWndClass: TWndClass): ATOM; stdcall;
{$EXTERNALSYM RegisterClassA}
function RegisterClassA(const lpWndClass: TWndClassA): ATOM; stdcall;
{$EXTERNALSYM RegisterClassW}
function RegisterClassW(const lpWndClass: TWndClassW): ATOM; stdcall;
{$EXTERNALSYM UnregisterClass}
function UnregisterClass(lpClassName: PChar; hInstance: HINST): BOOL; stdcall;
{$EXTERNALSYM UnregisterClassA}
function UnregisterClassA(lpClassName: PAnsiChar; hInstance: HINST): BOOL; stdcall;
{$EXTERNALSYM UnregisterClassW}
function UnregisterClassW(lpClassName: PWideChar; hInstance: HINST): BOOL; stdcall;
{$EXTERNALSYM GetClassInfo}
function GetClassInfo(hInstance: HINST; lpClassName: PChar;
  var lpWndClass: TWndClass): BOOL; stdcall;
{$EXTERNALSYM GetClassInfoA}
function GetClassInfoA(hInstance: HINST; lpClassName: PAnsiChar;
  var lpWndClass: TWndClassA): BOOL; stdcall;
{$EXTERNALSYM GetClassInfoW}
function GetClassInfoW(hInstance: HINST; lpClassName: PWideChar;
  var lpWndClass: TWndClassW): BOOL; stdcall;
{$EXTERNALSYM RegisterClassEx}
function RegisterClassEx(const WndClass: TWndClassEx): ATOM; stdcall;
{$EXTERNALSYM RegisterClassExA}
function RegisterClassExA(const WndClass: TWndClassExA): ATOM; stdcall;
{$EXTERNALSYM RegisterClassExW}
function RegisterClassExW(const WndClass: TWndClassExW): ATOM; stdcall;
{$EXTERNALSYM GetClassInfoEx}
function GetClassInfoEx(Instance: HINST; Classname: PChar; var WndClass: TWndClassEx): BOOL; stdcall;
{$EXTERNALSYM GetClassInfoExA}
function GetClassInfoExA(Instance: HINST; Classname: PAnsiChar; var WndClass: TWndClassExA): BOOL; stdcall;
{$EXTERNALSYM GetClassInfoExW}
function GetClassInfoExW(Instance: HINST; Classname: PWideChar; var WndClass: TWndClassExW): BOOL; stdcall;

const
  {$EXTERNALSYM CW_USEDEFAULT}
  CW_USEDEFAULT = DWORD($80000000);

  { Special value for CreateWindow, et al. }
  {$EXTERNALSYM HWND_DESKTOP}
  HWND_DESKTOP = 0;

{$EXTERNALSYM CreateWindowEx}
function CreateWindowEx(dwExStyle: DWORD; lpClassName: PChar;
  lpWindowName: PChar; dwStyle: DWORD; X, Y, nWidth, nHeight: Integer;
  hWndParent: HWND; hMenu: HMENU; hInstance: HINST; lpParam: Pointer): HWND;
{$EXTERNALSYM CreateWindowExA}
function CreateWindowExA(dwExStyle: DWORD; lpClassName: PAnsiChar;
  lpWindowName: PAnsiChar; dwStyle: DWORD; X, Y, nWidth, nHeight: Integer;
  hWndParent: HWND; hMenu: HMENU; hInstance: HINST; lpParam: Pointer): HWND;
{$EXTERNALSYM CreateWindowExW}
function CreateWindowExW(dwExStyle: DWORD; lpClassName: PWideChar;
  lpWindowName: PWideChar; dwStyle: DWORD; X, Y, nWidth, nHeight: Integer;
  hWndParent: HWND; hMenu: HMENU; hInstance: HINST; lpParam: Pointer): HWND;
{$EXTERNALSYM CreateWindow}
function CreateWindow(lpClassName: PChar; lpWindowName: PChar;
  dwStyle: DWORD; X, Y, nWidth, nHeight: Integer; hWndParent: HWND;
  hMenu: HMENU; hInstance: HINST; lpParam: Pointer): HWND;
{$EXTERNALSYM CreateWindowA}
function CreateWindowA(lpClassName: PAnsiChar; lpWindowName: PAnsiChar;
  dwStyle: DWORD; X, Y, nWidth, nHeight: Integer; hWndParent: HWND;
  hMenu: HMENU; hInstance: HINST; lpParam: Pointer): HWND;
{$EXTERNALSYM CreateWindowW}
function CreateWindowW(lpClassName: PWideChar; lpWindowName: PWideChar;
  dwStyle: DWORD; X, Y, nWidth, nHeight: Integer; hWndParent: HWND;
  hMenu: HMENU; hInstance: HINST; lpParam: Pointer): HWND;

{$EXTERNALSYM IsWindow}
function IsWindow(hWnd: HWND): BOOL; stdcall;
{$EXTERNALSYM IsMenu}
function IsMenu(hMenu: HMENU): BOOL; stdcall;
{$EXTERNALSYM IsChild}
function IsChild(hWndParent, hWnd: HWND): BOOL; stdcall;
{$EXTERNALSYM DestroyWindow}
function DestroyWindow(hWnd: HWND): BOOL; stdcall;
{$EXTERNALSYM ShowWindow}
function ShowWindow(hWnd: HWND; nCmdShow: Integer): BOOL; stdcall;
{$EXTERNALSYM AnimateWindow}
function AnimateWindow(hWnd: HWND; dwTime: DWORD; dwFlags: DWORD): BOOL; stdcall;
{$EXTERNALSYM ShowWindowAsync}
function ShowWindowAsync(hWnd: HWND; nCmdShow: Integer): BOOL; stdcall;
{$EXTERNALSYM FlashWindow}
function FlashWindow(hWnd: HWND; bInvert: BOOL): BOOL; stdcall;
{$EXTERNALSYM UpdateLayeredWindow}
function UpdateLayeredWindow(Handle: THandle; hdcDest: HDC; pptDst: PPoint; _psize: PSize;
                             hdcSrc: HDC; pptSrc: PPoint; crKey: COLORREF; pblend: PBLENDFUNCTION; dwFlags: DWORD): Boolean; stdcall;
{$EXTERNALSYM SetLayeredWindowAttributes}
function SetLayeredWindowAttributes(Hwnd: THandle; crKey: COLORREF; bAlpha: Byte; dwFlags: DWORD): Boolean;

const
{$EXTERNALSYM LWA_COLORKEY}
  LWA_COLORKEY = $00000001;
{$EXTERNALSYM LWA_ALPHA}
  LWA_ALPHA = $00000002;

{$EXTERNALSYM ULW_COLORKEY}
  ULW_COLORKEY = $00000001;
{$EXTERNALSYM ULW_ALPHA}
  ULW_ALPHA = $00000002;
{$EXTERNALSYM ULW_OPAQUE}
  ULW_OPAQUE = $00000004;

type
  {$EXTERNALSYM FLASHWINFO}
  FLASHWINFO = record
    cbSize: UINT;
    hwnd: HWND;
    dwFlags: DWORD;
    uCount: UINT;
    dwTimeout: DWORD;
  end;
  {$EXTERNALSYM PFLASHWINFO}
  PFLASHWINFO = ^FLASHWINFO;
  {$EXTERNALSYM TFlashWInfo}
  TFlashWInfo = FLASHWINFO;

function FlashWindowEx(var pfwi: FLASHWINFO): BOOL; stdcall;
{$EXTERNALSYM FlashWindowEx}  

const
  {$EXTERNALSYM FLASHW_STOP}
  FLASHW_STOP = $0;
  {$EXTERNALSYM FLASHW_CAPTION}
  FLASHW_CAPTION = $1;
  {$EXTERNALSYM FLASHW_TRAY}
  FLASHW_TRAY = $2;
  {$EXTERNALSYM FLASHW_ALL}
  FLASHW_ALL = FLASHW_CAPTION or FLASHW_TRAY;
  {$EXTERNALSYM FLASHW_TIMER}
  FLASHW_TIMER = $4;
  {$EXTERNALSYM FLASHW_TIMERNOFG}
  FLASHW_TIMERNOFG = $C;

{$EXTERNALSYM ShowOwnedPopups}
function ShowOwnedPopups(hWnd: HWND; fShow: BOOL): BOOL; stdcall;
{$EXTERNALSYM OpenIcon}
function OpenIcon(hWnd: HWND): BOOL; stdcall;
{$EXTERNALSYM CloseWindow}
function CloseWindow(hWnd: HWND): BOOL; stdcall;
{$EXTERNALSYM MoveWindow}
function MoveWindow(hWnd: HWND; X, Y, nWidth, nHeight: Integer; bRepaint: BOOL): BOOL; stdcall;
{$EXTERNALSYM SetWindowPos}
function SetWindowPos(hWnd: HWND; hWndInsertAfter: HWND;
  X, Y, cx, cy: Integer; uFlags: UINT): BOOL; stdcall;
{$EXTERNALSYM GetWindowPlacement}
function GetWindowPlacement(hWnd: HWND; WindowPlacement: PWindowPlacement): BOOL; stdcall;
{$EXTERNALSYM SetWindowPlacement}
function SetWindowPlacement(hWnd: HWND; WindowPlacement: PWindowPlacement): BOOL; stdcall;
{$EXTERNALSYM BeginDeferWindowPos}
function BeginDeferWindowPos(nNumWindows: Integer): HDWP; stdcall;
{$EXTERNALSYM DeferWindowPos}
function DeferWindowPos(hWinPosInfo: HDWP; hWnd: HWND;
  hWndInsertAfter: HWND; x, y, cx, cy: Integer; uFlags: UINT): HDWP; stdcall;
{$EXTERNALSYM EndDeferWindowPos}
function EndDeferWindowPos(hWinPosInfo: HDWP): BOOL; stdcall;
{$EXTERNALSYM IsWindowVisible}
function IsWindowVisible(hWnd: HWND): BOOL; stdcall;
{$EXTERNALSYM IsIconic}
function IsIconic(hWnd: HWND): BOOL; stdcall;
{$EXTERNALSYM AnyPopup}
function AnyPopup: BOOL; stdcall;
{$EXTERNALSYM BringWindowToTop}
function BringWindowToTop(hWnd: HWND): BOOL; stdcall;
{$EXTERNALSYM IsZoomed}
function IsZoomed(hWnd: HWND): BOOL; stdcall;


const
  { SetWindowPos Flags }
  {$EXTERNALSYM SWP_NOSIZE}
  SWP_NOSIZE = 1;
  {$EXTERNALSYM SWP_NOMOVE}
  SWP_NOMOVE = 2;
  {$EXTERNALSYM SWP_NOZORDER}
  SWP_NOZORDER = 4;
  {$EXTERNALSYM SWP_NOREDRAW}
  SWP_NOREDRAW = 8;
  {$EXTERNALSYM SWP_NOACTIVATE}
  SWP_NOACTIVATE = $10;
  {$EXTERNALSYM SWP_FRAMECHANGED}
  SWP_FRAMECHANGED = $20;    { The frame changed: send WM_NCCALCSIZE }
  {$EXTERNALSYM SWP_SHOWWINDOW}
  SWP_SHOWWINDOW = $40;
  {$EXTERNALSYM SWP_HIDEWINDOW}
  SWP_HIDEWINDOW = $80;
  {$EXTERNALSYM SWP_NOCOPYBITS}
  SWP_NOCOPYBITS = $100;
  {$EXTERNALSYM SWP_NOOWNERZORDER}
  SWP_NOOWNERZORDER = $200;  { Don't do owner Z ordering }
  {$EXTERNALSYM SWP_NOSENDCHANGING}
  SWP_NOSENDCHANGING = $400;  { Don't send WM_WINDOWPOSCHANGING }
  {$EXTERNALSYM SWP_DRAWFRAME}
  SWP_DRAWFRAME = SWP_FRAMECHANGED;
  {$EXTERNALSYM SWP_NOREPOSITION}
  SWP_NOREPOSITION = SWP_NOOWNERZORDER;
  {$EXTERNALSYM SWP_DEFERERASE}
  SWP_DEFERERASE = $2000;
  {$EXTERNALSYM SWP_ASYNCWINDOWPOS}
  SWP_ASYNCWINDOWPOS = $4000;

  {$EXTERNALSYM HWND_TOP}
  HWND_TOP = 0;
  {$EXTERNALSYM HWND_BOTTOM}
  HWND_BOTTOM = 1;
  {$EXTERNALSYM HWND_TOPMOST}
  HWND_TOPMOST = HWND(-1);
  {$EXTERNALSYM HWND_NOTOPMOST}
  HWND_NOTOPMOST = HWND(-2);

type
  PDlgTemplate = ^TDlgTemplate;
  {$EXTERNALSYM DLGTEMPLATE}
  DLGTEMPLATE = packed record
    style: DWORD;
    dwExtendedStyle: DWORD;
    cdit: Word;
    x: SHORT;
    y: SHORT;
    cx: SHORT;
    cy: SHORT;
  end;
  TDlgTemplate = DLGTEMPLATE;

  { 32 bit Dialog item template. }
  PDlgItemTemplate = ^TDlgItemTemplate;
  {$EXTERNALSYM DLGITEMTEMPLATE}
  DLGITEMTEMPLATE = packed record
    style: DWORD;
    dwExtendedStyle: DWORD;
    x: SHORT;
    y: SHORT;
    cx: SHORT;
    cy: SHORT;
    id: Word;
  end;
  TDlgItemTemplate = DLGITEMTEMPLATE;

{$EXTERNALSYM CreateDialogParam}
function CreateDialogParam(hInstance: HINST; lpTemplateName: PChar;
  hWndParent: HWND; lpDialogFunc: TFNDlgProc; dwInitParam: LPARAM): HWND; stdcall;
{$EXTERNALSYM CreateDialogParamA}
function CreateDialogParamA(hInstance: HINST; lpTemplateName: PAnsiChar;
  hWndParent: HWND; lpDialogFunc: TFNDlgProc; dwInitParam: LPARAM): HWND; stdcall;
{$EXTERNALSYM CreateDialogParamW}
function CreateDialogParamW(hInstance: HINST; lpTemplateName: PWideChar;
  hWndParent: HWND; lpDialogFunc: TFNDlgProc; dwInitParam: LPARAM): HWND; stdcall;
{$EXTERNALSYM CreateDialogIndirectParam}
function CreateDialogIndirectParam(hInstance: HINST; const lpTemplate: TDlgTemplate;
  hWndParent: HWND; lpDialogFunc: TFNDlgProc; dwInitParam: LPARAM): HWND; stdcall;
{$EXTERNALSYM CreateDialogIndirectParamA}
function CreateDialogIndirectParamA(hInstance: HINST; const lpTemplate: TDlgTemplate;
  hWndParent: HWND; lpDialogFunc: TFNDlgProc; dwInitParam: LPARAM): HWND; stdcall;
{$EXTERNALSYM CreateDialogIndirectParamW}
function CreateDialogIndirectParamW(hInstance: HINST; const lpTemplate: TDlgTemplate;
  hWndParent: HWND; lpDialogFunc: TFNDlgProc; dwInitParam: LPARAM): HWND; stdcall;
{$EXTERNALSYM CreateDialog}
function CreateDialog(hInstance: HINST; lpTemplateName: PChar;
  hWndParent: HWND; lpDialogFunc: TFNDlgProc): HWND;
{$EXTERNALSYM CreateDialogA}
function CreateDialogA(hInstance: HINST; lpTemplateName: PAnsiChar;
  hWndParent: HWND; lpDialogFunc: TFNDlgProc): HWND;
{$EXTERNALSYM CreateDialogW}
function CreateDialogW(hInstance: HINST; lpTemplateName: PWideChar;
  hWndParent: HWND; lpDialogFunc: TFNDlgProc): HWND;
{$EXTERNALSYM CreateDialogIndirect}
function CreateDialogIndirect(hInstance: HINST; const lpTemplate: TDlgTemplate;
  hWndParent: HWND; lpDialogFunc: TFNDlgProc): HWND;
{$EXTERNALSYM CreateDialogIndirectA}
function CreateDialogIndirectA(hInstance: HINST; const lpTemplate: TDlgTemplate;
  hWndParent: HWND; lpDialogFunc: TFNDlgProc): HWND;
{$EXTERNALSYM CreateDialogIndirectW}
function CreateDialogIndirectW(hInstance: HINST; const lpTemplate: TDlgTemplate;
  hWndParent: HWND; lpDialogFunc: TFNDlgProc): HWND;
{$EXTERNALSYM DialogBoxParam}
function DialogBoxParam(hInstance: HINST; lpTemplateName: PChar;
  hWndParent: HWND; lpDialogFunc: TFNDlgProc; dwInitParam: LPARAM): Integer; stdcall;
{$EXTERNALSYM DialogBoxParamA}
function DialogBoxParamA(hInstance: HINST; lpTemplateName: PAnsiChar;
  hWndParent: HWND; lpDialogFunc: TFNDlgProc; dwInitParam: LPARAM): Integer; stdcall;
{$EXTERNALSYM DialogBoxParamW}
function DialogBoxParamW(hInstance: HINST; lpTemplateName: PWideChar;
  hWndParent: HWND; lpDialogFunc: TFNDlgProc; dwInitParam: LPARAM): Integer; stdcall;
{$EXTERNALSYM DialogBoxIndirectParam}
function DialogBoxIndirectParam(hInstance: HINST; const lpDialogTemplate: TDlgTemplate;
  hWndParent: HWND; lpDialogFunc: TFNDlgProc; dwInitParam: LPARAM): Integer; stdcall;
{$EXTERNALSYM DialogBoxIndirectParamA}
function DialogBoxIndirectParamA(hInstance: HINST; const lpDialogTemplate: TDlgTemplate;
  hWndParent: HWND; lpDialogFunc: TFNDlgProc; dwInitParam: LPARAM): Integer; stdcall;
{$EXTERNALSYM DialogBoxIndirectParamW}
function DialogBoxIndirectParamW(hInstance: HINST; const lpDialogTemplate: TDlgTemplate;
  hWndParent: HWND; lpDialogFunc: TFNDlgProc; dwInitParam: LPARAM): Integer; stdcall;
{$EXTERNALSYM DialogBox}
function DialogBox(hInstance: HINST; lpTemplate: PChar;
  hWndParent: HWND; lpDialogFunc: TFNDlgProc): Integer;
{$EXTERNALSYM DialogBoxA}
function DialogBoxA(hInstance: HINST; lpTemplate: PAnsiChar;
  hWndParent: HWND; lpDialogFunc: TFNDlgProc): Integer;
{$EXTERNALSYM DialogBoxW}
function DialogBoxW(hInstance: HINST; lpTemplate: PWideChar;
  hWndParent: HWND; lpDialogFunc: TFNDlgProc): Integer;
{$EXTERNALSYM DialogBoxIndirect}
function DialogBoxIndirect(hInstance: HINST; const lpDialogTemplate: TDlgTemplate;
  hWndParent: HWND; lpDialogFunc: TFNDlgProc): Integer;
{$EXTERNALSYM DialogBoxIndirectA}
function DialogBoxIndirectA(hInstance: HINST; const lpDialogTemplate: TDlgTemplate;
  hWndParent: HWND; lpDialogFunc: TFNDlgProc): Integer;
{$EXTERNALSYM DialogBoxIndirectW}
function DialogBoxIndirectW(hInstance: HINST; const lpDialogTemplate: TDlgTemplate;
  hWndParent: HWND; lpDialogFunc: TFNDlgProc): Integer;
{$EXTERNALSYM EndDialog}
function EndDialog(hDlg: HWND; nResult: Integer): BOOL; stdcall;
{$EXTERNALSYM GetDlgItem}
function GetDlgItem(hDlg: HWND; nIDDlgItem: Integer): HWND; stdcall;
{$EXTERNALSYM SetDlgItemInt}
function SetDlgItemInt(hDlg: HWND; nIDDlgItem: Integer; uValue: UINT; bSigned: BOOL): BOOL; stdcall;
{$EXTERNALSYM GetDlgItemInt}
function GetDlgItemInt(hDlg: HWND; nIDDlgItem: Integer;
  var lpTranslated: BOOL; bSigned: BOOL): UINT; stdcall;
{$EXTERNALSYM SetDlgItemText}
function SetDlgItemText(hDlg: HWND; nIDDlgItem: Integer; lpString: PChar): BOOL; stdcall;
{$EXTERNALSYM SetDlgItemTextA}
function SetDlgItemTextA(hDlg: HWND; nIDDlgItem: Integer; lpString: PAnsiChar): BOOL; stdcall;
{$EXTERNALSYM SetDlgItemTextW}
function SetDlgItemTextW(hDlg: HWND; nIDDlgItem: Integer; lpString: PWideChar): BOOL; stdcall;
{$EXTERNALSYM GetDlgItemText}
function GetDlgItemText(hDlg: HWND; nIDDlgItem: Integer;
  lpString: PChar; nMaxCount: Integer): UINT; stdcall;
{$EXTERNALSYM GetDlgItemTextA}
function GetDlgItemTextA(hDlg: HWND; nIDDlgItem: Integer;
  lpString: PAnsiChar; nMaxCount: Integer): UINT; stdcall;
{$EXTERNALSYM GetDlgItemTextW}
function GetDlgItemTextW(hDlg: HWND; nIDDlgItem: Integer;
  lpString: PWideChar; nMaxCount: Integer): UINT; stdcall;
{$EXTERNALSYM CheckDlgButton}
function CheckDlgButton(hDlg: HWND; nIDButton: Integer; uCheck: UINT): BOOL; stdcall;
{$EXTERNALSYM CheckRadioButton}
function CheckRadioButton(hDlg: HWND; nIDFirstButton, nIDLastButton, nIDCheckButton: Integer): BOOL; stdcall;
{$EXTERNALSYM IsDlgButtonChecked}
function IsDlgButtonChecked(hDlg: HWND; nIDButton: Integer): UINT; stdcall;
{$EXTERNALSYM SendDlgItemMessage}
function SendDlgItemMessage(hDlg: HWND; nIDDlgItem: Integer;
  Msg: UINT; wParam: WPARAM; lParam: LPARAM): Longint; stdcall;
{$EXTERNALSYM SendDlgItemMessageA}
function SendDlgItemMessageA(hDlg: HWND; nIDDlgItem: Integer;
  Msg: UINT; wParam: WPARAM; lParam: LPARAM): Longint; stdcall;
{$EXTERNALSYM SendDlgItemMessageW}
function SendDlgItemMessageW(hDlg: HWND; nIDDlgItem: Integer;
  Msg: UINT; wParam: WPARAM; lParam: LPARAM): Longint; stdcall;
{$EXTERNALSYM GetNextDlgGroupItem}
function GetNextDlgGroupItem(hDlg: HWND; hCtl: HWND; bPrevious: BOOL): HWND; stdcall;
{$EXTERNALSYM GetNextDlgTabItem}
function GetNextDlgTabItem(hDlg: HWND; hCtl: HWND; bPrevious: BOOL): HWND; stdcall;
{$EXTERNALSYM GetDlgCtrlID}
function GetDlgCtrlID(hWnd: HWND): Integer; stdcall;
{$EXTERNALSYM GetDialogBaseUnits}
function GetDialogBaseUnits: Longint; stdcall;
{$EXTERNALSYM DefDlgProc}
function DefDlgProc(hDlg: HWND; Msg: UINT; wParam: WPARAM; lParam: LPARAM): LRESULT; stdcall;
{$EXTERNALSYM DefDlgProcA}
function DefDlgProcA(hDlg: HWND; Msg: UINT; wParam: WPARAM; lParam: LPARAM): LRESULT; stdcall;
{$EXTERNALSYM DefDlgProcW}
function DefDlgProcW(hDlg: HWND; Msg: UINT; wParam: WPARAM; lParam: LPARAM): LRESULT; stdcall;

const
  { Window extra byted needed for private dialog classes. }
  {$EXTERNALSYM DLGWINDOWEXTRA}
  DLGWINDOWEXTRA = 30;

{$EXTERNALSYM CallMsgFilter}
function CallMsgFilter(var lpMsg: TMsg; nCode: Integer): BOOL; stdcall;
{$EXTERNALSYM CallMsgFilterA}
function CallMsgFilterA(var lpMsg: TMsg; nCode: Integer): BOOL; stdcall;
{$EXTERNALSYM CallMsgFilterW}
function CallMsgFilterW(var lpMsg: TMsg; nCode: Integer): BOOL; stdcall;

{ Clipboard Manager Functions }

{$EXTERNALSYM OpenClipboard}
function OpenClipboard(hWndNewOwner: HWND): BOOL; stdcall;
{$EXTERNALSYM CloseClipboard}
function CloseClipboard: BOOL; stdcall;
{$EXTERNALSYM GetClipboardSequenceNumber}
function GetClipboardSequenceNumber: DWORD; stdcall;
{$EXTERNALSYM GetClipboardOwner}
function GetClipboardOwner: HWND; stdcall;
{$EXTERNALSYM SetClipboardViewer}
function SetClipboardViewer(hWndNewViewer: HWND): HWND; stdcall;
{$EXTERNALSYM GetClipboardViewer}
function GetClipboardViewer: HWND; stdcall;
{$EXTERNALSYM ChangeClipboardChain}
function ChangeClipboardChain(hWndRemove, hWndNewNext: HWND): BOOL; stdcall;
{$EXTERNALSYM SetClipboardData}
function SetClipboardData(uFormat: UINT; hMem: THandle): THandle; stdcall;
{$EXTERNALSYM GetClipboardData}
function GetClipboardData(uFormat: UINT): THandle; stdcall;
{$EXTERNALSYM RegisterClipboardFormat}
function RegisterClipboardFormat(lpszFormat: PChar): UINT; stdcall;
{$EXTERNALSYM RegisterClipboardFormatA}
function RegisterClipboardFormatA(lpszFormat: PAnsiChar): UINT; stdcall;
{$EXTERNALSYM RegisterClipboardFormatW}
function RegisterClipboardFormatW(lpszFormat: PWideChar): UINT; stdcall;
{$EXTERNALSYM CountClipboardFormats}
function CountClipboardFormats: Integer; stdcall;
{$EXTERNALSYM EnumClipboardFormats}
function EnumClipboardFormats(format: UINT): UINT; stdcall;
{$EXTERNALSYM GetClipboardFormatName}
function GetClipboardFormatName(format: UINT; lpszFormatName: PChar;
  cchMaxCount: Integer): Integer; stdcall;
{$EXTERNALSYM GetClipboardFormatNameA}
function GetClipboardFormatNameA(format: UINT; lpszFormatName: PAnsiChar;
  cchMaxCount: Integer): Integer; stdcall;
{$EXTERNALSYM GetClipboardFormatNameW}
function GetClipboardFormatNameW(format: UINT; lpszFormatName: PWideChar;
  cchMaxCount: Integer): Integer; stdcall;
{$EXTERNALSYM EmptyClipboard}
function EmptyClipboard: BOOL; stdcall;
{$EXTERNALSYM IsClipboardFormatAvailable}
function IsClipboardFormatAvailable(format: UINT): BOOL; stdcall;
{$EXTERNALSYM GetPriorityClipboardFormat}
function GetPriorityClipboardFormat(var paFormatPriorityList; cFormats: Integer): Integer; stdcall;
{$EXTERNALSYM GetOpenClipboardWindow}
function GetOpenClipboardWindow: HWND; stdcall;

{ Character Translation Routines }

{$EXTERNALSYM CharToOem}
function CharToOem(lpszSrc: PChar; lpszDst: PChar): BOOL; stdcall;
{$EXTERNALSYM CharToOemA}
function CharToOemA(lpszSrc: PAnsiChar; lpszDst: PAnsiChar): BOOL; stdcall;
{$EXTERNALSYM CharToOemW}
function CharToOemW(lpszSrc: PWideChar; lpszDst: PWideChar): BOOL; stdcall;
{$EXTERNALSYM OemToChar}
function OemToChar(lpszSrc: PChar; lpszDst: PChar): BOOL; stdcall;
{$EXTERNALSYM OemToCharA}
function OemToCharA(lpszSrc: PAnsiChar; lpszDst: PAnsiChar): BOOL; stdcall;
{$EXTERNALSYM OemToCharW}
function OemToCharW(lpszSrc: PWideChar; lpszDst: PWideChar): BOOL; stdcall;
{$EXTERNALSYM CharToOemBuff}
function CharToOemBuff(lpszSrc: PChar; lpszDst: PChar; cchDstLength: DWORD): BOOL; stdcall;
{$EXTERNALSYM CharToOemBuffA}
function CharToOemBuffA(lpszSrc: PAnsiChar; lpszDst: PAnsiChar; cchDstLength: DWORD): BOOL; stdcall;
{$EXTERNALSYM CharToOemBuffW}
function CharToOemBuffW(lpszSrc: PWideChar; lpszDst: PWideChar; cchDstLength: DWORD): BOOL; stdcall;
{$EXTERNALSYM OemToCharBuff}
function OemToCharBuff(lpszSrc: PChar; lpszDst: PChar; cchDstLength: DWORD): BOOL; stdcall;
{$EXTERNALSYM OemToCharBuffA}
function OemToCharBuffA(lpszSrc: PAnsiChar; lpszDst: PAnsiChar; cchDstLength: DWORD): BOOL; stdcall;
{$EXTERNALSYM OemToCharBuffW}
function OemToCharBuffW(lpszSrc: PWideChar; lpszDst: PWideChar; cchDstLength: DWORD): BOOL; stdcall;
{$EXTERNALSYM CharUpper}
function CharUpper(lpsz: PChar): PChar; stdcall;
{$EXTERNALSYM CharUpperA}
function CharUpperA(lpsz: PAnsiChar): PAnsiChar; stdcall;
{$EXTERNALSYM CharUpperW}
function CharUpperW(lpsz: PWideChar): PWideChar; stdcall;
{$EXTERNALSYM CharUpperBuff}
function CharUpperBuff(lpsz: PChar; cchLength: DWORD): DWORD; stdcall;
{$EXTERNALSYM CharUpperBuffA}
function CharUpperBuffA(lpsz: PAnsiChar; cchLength: DWORD): DWORD; stdcall;
{$EXTERNALSYM CharUpperBuffW}
function CharUpperBuffW(lpsz: PWideChar; cchLength: DWORD): DWORD; stdcall;
{$EXTERNALSYM CharLower}
function CharLower(lpsz: PChar): PChar; stdcall;
{$EXTERNALSYM CharLowerA}
function CharLowerA(lpsz: PAnsiChar): PAnsiChar; stdcall;
{$EXTERNALSYM CharLowerW}
function CharLowerW(lpsz: PWideChar): PWideChar; stdcall;
{$EXTERNALSYM CharLowerBuff}
function CharLowerBuff(lpsz: PChar; cchLength: DWORD): DWORD; stdcall;
{$EXTERNALSYM CharLowerBuffA}
function CharLowerBuffA(lpsz: PAnsiChar; cchLength: DWORD): DWORD; stdcall;
{$EXTERNALSYM CharLowerBuffW}
function CharLowerBuffW(lpsz: PWideChar; cchLength: DWORD): DWORD; stdcall;
{$EXTERNALSYM CharNext}
function CharNext(lpsz: PChar): PChar; stdcall;
{$EXTERNALSYM CharNextA}
function CharNextA(lpsz: PAnsiChar): PAnsiChar; stdcall;
{$EXTERNALSYM CharNextW}
function CharNextW(lpsz: PWideChar): PWideChar; stdcall;
{$EXTERNALSYM CharPrev}
function CharPrev(lpszStart: PChar; lpszCurrent: PChar): PChar; stdcall;
{$EXTERNALSYM CharPrevA}
function CharPrevA(lpszStart: PAnsiChar; lpszCurrent: PAnsiChar): PAnsiChar; stdcall;
{$EXTERNALSYM CharPrevW}
function CharPrevW(lpszStart: PWideChar; lpszCurrent: PWideChar): PWideChar; stdcall;

{$EXTERNALSYM CharNextExA}
function CharNextExA(CodePage: Word; lpCurrentChar: LPCSTR; dwFlags: DWORD): LPSTR; stdcall;
{$EXTERNALSYM CharNextEx}
function CharNextEx(CodePage: Word; lpCurrentChar: LPCSTR; dwFlags: DWORD): LPSTR; stdcall;
{$EXTERNALSYM CharPrevEx}
function CharPrevEx(CodePage: Word; lpStart, lpCurrentChar: LPCSTR; dwFlags: DWORD): LPSTR; stdcall;
{$EXTERNALSYM CharPrevExA}
function CharPrevExA(CodePage: Word; lpStart, lpCurrentChar: LPCSTR; dwFlags: DWORD): LPSTR; stdcall;

{ Compatibility defines for character translation routines }

{$EXTERNALSYM AnsiToOem}
function AnsiToOem(const lpszSrc: LPCSTR; lpszDst: LPSTR): BOOL; stdcall;
{$EXTERNALSYM OemToAnsi}
function OemToAnsi(const lpszSrc: LPCSTR; lpszDst: LPSTR): BOOL; stdcall;
{$EXTERNALSYM AnsiToOemBuff}
function AnsiToOemBuff(lpszSrc: LPCSTR; lpszDst: LPSTR; cchDstLength: DWORD): BOOL; stdcall;
{$EXTERNALSYM OemToAnsiBuff}
function OemToAnsiBuff(lpszSrc: LPCSTR; lpszDst: LPSTR; cchDstLength: DWORD): BOOL; stdcall;
{$EXTERNALSYM AnsiUpper}
function AnsiUpper(lpsz: LPSTR): LPSTR; stdcall;
{$EXTERNALSYM AnsiUpperBuff}
function AnsiUpperBuff(lpsz: LPSTR; cchLength: DWORD): DWORD; stdcall;
{$EXTERNALSYM AnsiLower}
function AnsiLower(lpsz: LPSTR): LPSTR; stdcall;
{$EXTERNALSYM AnsiLowerBuff}
function AnsiLowerBuff(lpsz: LPSTR; cchLength: DWORD): DWORD; stdcall;
{$EXTERNALSYM AnsiNext}
function AnsiNext(const lpsz: LPCSTR): LPSTR; stdcall;
{$EXTERNALSYM AnsiPrev}
function AnsiPrev(const lpszStart: LPCSTR; const lpszCurrent: LPCSTR): LPSTR; stdcall;

{ Language dependent Routines }

{$EXTERNALSYM IsCharAlpha}
function IsCharAlpha(ch: Char): BOOL; stdcall;
{$EXTERNALSYM IsCharAlphaA}
function IsCharAlphaA(ch: AnsiChar): BOOL; stdcall;
{$EXTERNALSYM IsCharAlphaW}
function IsCharAlphaW(ch: WideChar): BOOL; stdcall;
{$EXTERNALSYM IsCharAlphaNumeric}
function IsCharAlphaNumeric(ch: Char): BOOL; stdcall;
{$EXTERNALSYM IsCharAlphaNumericA}
function IsCharAlphaNumericA(ch: AnsiChar): BOOL; stdcall;
{$EXTERNALSYM IsCharAlphaNumericW}
function IsCharAlphaNumericW(ch: WideChar): BOOL; stdcall;
{$EXTERNALSYM IsCharUpper}
function IsCharUpper(ch: Char): BOOL; stdcall;
{$EXTERNALSYM IsCharUpperA}
function IsCharUpperA(ch: AnsiChar): BOOL; stdcall;
{$EXTERNALSYM IsCharUpperW}
function IsCharUpperW(ch: WideChar): BOOL; stdcall;
{$EXTERNALSYM IsCharLower}
function IsCharLower(ch: Char): BOOL; stdcall;
{$EXTERNALSYM IsCharLowerA}
function IsCharLowerA(ch: AnsiChar): BOOL; stdcall;
{$EXTERNALSYM IsCharLowerW}
function IsCharLowerW(ch: WideChar): BOOL; stdcall;

{$EXTERNALSYM SetFocus}
function SetFocus(hWnd: HWND): HWND; stdcall;
{$EXTERNALSYM GetActiveWindow}
function GetActiveWindow: HWND; stdcall;
{$EXTERNALSYM GetFocus}
function GetFocus: HWND; stdcall;
{$EXTERNALSYM GetKBCodePage}
function GetKBCodePage: UINT; stdcall;
{$EXTERNALSYM GetKeyState}
function GetKeyState(nVirtKey: Integer): SHORT; stdcall;
{$EXTERNALSYM GetAsyncKeyState}
function GetAsyncKeyState(vKey: Integer): SHORT; stdcall;

type
  PKeyboardState = ^TKeyboardState;
  TKeyboardState = array[0..255] of Byte;

{$EXTERNALSYM GetKeyboardState}
function GetKeyboardState(var KeyState: TKeyboardState): BOOL; stdcall;
{$EXTERNALSYM SetKeyboardState}
function SetKeyboardState(var KeyState: TKeyboardState): BOOL; stdcall;
{$EXTERNALSYM GetKeyNameText}
function GetKeyNameText(lParam: Longint; lpString: PChar; nSize: Integer): Integer; stdcall;
{$EXTERNALSYM GetKeyNameTextA}
function GetKeyNameTextA(lParam: Longint; lpString: PAnsiChar; nSize: Integer): Integer; stdcall;
{$EXTERNALSYM GetKeyNameTextW}
function GetKeyNameTextW(lParam: Longint; lpString: PWideChar; nSize: Integer): Integer; stdcall;
{$EXTERNALSYM GetKeyboardType}
function GetKeyboardType(nTypeFlag: Integer): Integer; stdcall;
{$EXTERNALSYM ToAscii}
function ToAscii(uVirtKey, uScanCode: UINT; const KeyState: TKeyboardState;
  lpChar: PChar; uFlags: UINT): Integer; stdcall;
{$EXTERNALSYM ToAsciiEx}
function ToAsciiEx(uVirtKey: UINT; uScanCode: UINT; const KeyState: TKeyboardState;
  lpChar: PChar; uFlags: UINT; dwhkl: HKL): Integer; stdcall;
{$EXTERNALSYM ToUnicode}
function ToUnicode(wVirtKey, wScanCode: UINT; const KeyState: TKeyboardState;
  var pwszBuff; cchBuff: Integer; wFlags: UINT): Integer; stdcall;
{$EXTERNALSYM OemKeyScan}
function OemKeyScan(wOemChar: Word): DWORD; stdcall;

{$EXTERNALSYM VkKeyScan}
function VkKeyScan(ch: Char): SHORT; stdcall;
{$EXTERNALSYM VkKeyScanA}
function VkKeyScanA(ch: AnsiChar): SHORT; stdcall;
{$EXTERNALSYM VkKeyScanW}
function VkKeyScanW(ch: WideChar): SHORT; stdcall;
{$EXTERNALSYM VkKeyScanEx}
function VkKeyScanEx(ch: Char; dwhkl: HKL): SHORT; stdcall;
{$EXTERNALSYM VkKeyScanExA}
function VkKeyScanExA(ch: AnsiChar; dwhkl: HKL): SHORT; stdcall;
{$EXTERNALSYM VkKeyScanExW}
function VkKeyScanExW(ch: WideChar; dwhkl: HKL): SHORT; stdcall;

const
  {$EXTERNALSYM KEYEVENTF_EXTENDEDKEY}
  KEYEVENTF_EXTENDEDKEY = 1;
  {$EXTERNALSYM KEYEVENTF_KEYUP}
  KEYEVENTF_KEYUP = 2;

{$EXTERNALSYM keybd_event}
procedure keybd_event(bVk: Byte; bScan: Byte; dwFlags, dwExtraInfo: DWORD); stdcall;

const
  {$EXTERNALSYM MOUSEEVENTF_MOVE}
  MOUSEEVENTF_MOVE            = $0001; { mouse move }
  {$EXTERNALSYM MOUSEEVENTF_LEFTDOWN}
  MOUSEEVENTF_LEFTDOWN        = $0002; { left button down }
  {$EXTERNALSYM MOUSEEVENTF_LEFTUP}
  MOUSEEVENTF_LEFTUP          = $0004; { left button up }
  {$EXTERNALSYM MOUSEEVENTF_RIGHTDOWN}
  MOUSEEVENTF_RIGHTDOWN       = $0008; { right button down }
  {$EXTERNALSYM MOUSEEVENTF_RIGHTUP}
  MOUSEEVENTF_RIGHTUP         = $0010; { right button up }
  {$EXTERNALSYM MOUSEEVENTF_MIDDLEDOWN}
  MOUSEEVENTF_MIDDLEDOWN      = $0020; { middle button down }
  {$EXTERNALSYM MOUSEEVENTF_MIDDLEUP}
  MOUSEEVENTF_MIDDLEUP        = $0040; { middle button up }
  {$EXTERNALSYM MOUSEEVENTF_WHEEL}
  MOUSEEVENTF_WHEEL           = $0800; { wheel button rolled }
  {$EXTERNALSYM MOUSEEVENTF_ABSOLUTE}
  MOUSEEVENTF_ABSOLUTE        = $8000; { absolute move }

{$EXTERNALSYM mouse_event}
procedure mouse_event(dwFlags, dx, dy, dwData, dwExtraInfo: DWORD); stdcall;

type
  PMouseInput = ^TMouseInput;
  {$EXTERNALSYM tagMOUSEINPUT}
  tagMOUSEINPUT = packed record
    dx: Longint;
    dy: Longint;
    mouseData: DWORD;
    dwFlags: DWORD;
    time: DWORD;
    dwExtraInfo: DWORD;
  end;
  TMouseInput = tagMOUSEINPUT;

  PKeybdInput = ^TKeybdInput;
  {$EXTERNALSYM tagKEYBDINPUT}
  tagKEYBDINPUT = packed record
    wVk: WORD;
    wScan: WORD;
    dwFlags: DWORD;
    time: DWORD;
    dwExtraInfo: DWORD;
  end;
  TKeybdInput = tagKEYBDINPUT;

  PHardwareInput = ^THardwareInput;
  {$EXTERNALSYM tagHARDWAREINPUT}
  tagHARDWAREINPUT = packed record
    uMsg: DWORD;
    wParamL: WORD;
    wParamH: WORD;
  end;
  THardwareInput = tagHARDWAREINPUT;

const
  {$EXTERNALSYM INPUT_MOUSE}
  INPUT_MOUSE = 0;
  {$EXTERNALSYM INPUT_KEYBOARD}
  INPUT_KEYBOARD = 1;
  {$EXTERNALSYM INPUT_HARDWARE}
  INPUT_HARDWARE = 2;

type
  PInput = ^TInput;
  {$EXTERNALSYM tagINPUT}
  tagINPUT = packed record
    Itype: DWORD;
    case Integer of
      0: (mi: TMouseInput);
      1: (ki: TKeybdInput);
      2: (hi: THardwareInput);
  end;
  TInput = tagINPUT;

{$EXTERNALSYM SendInput}
function SendInput(cInputs: UINT; var pInputs: TInput; cbSize: Integer): UINT; stdcall;

type
  PLastInputInfo = ^TLastInputInfo;
  {$EXTERNALSYM tagLASTINPUTINFO}
  tagLASTINPUTINFO = packed record
    cbSize: UINT;
    dwTime: DWORD;
  end;
  TLastInputInfo = tagLASTINPUTINFO;

{$EXTERNALSYM GetLastInputInfo}
function GetLastInputInfo(var plii: TLastInputInfo): BOOL; stdcall;

{$EXTERNALSYM MapVirtualKey}
function MapVirtualKey(uCode, uMapType: UINT): UINT; stdcall;
{$EXTERNALSYM MapVirtualKeyA}
function MapVirtualKeyA(uCode, uMapType: UINT): UINT; stdcall;
{$EXTERNALSYM MapVirtualKeyW}
function MapVirtualKeyW(uCode, uMapType: UINT): UINT; stdcall;
{$EXTERNALSYM MapVirtualKeyEx}
function MapVirtualKeyEx(uCode, uMapType: UINT; dwhkl: HKL): UINT; stdcall;
{$EXTERNALSYM MapVirtualKeyExA}
function MapVirtualKeyExA(uCode, uMapType: UINT; dwhkl: HKL): UINT; stdcall;
{$EXTERNALSYM MapVirtualKeyExW}
function MapVirtualKeyExW(uCode, uMapType: UINT; dwhkl: HKL): UINT; stdcall;
{$EXTERNALSYM GetInputState}
function GetInputState: BOOL; stdcall;
{$EXTERNALSYM GetQueueStatus}
function GetQueueStatus(flags: UINT): DWORD; stdcall;
{$EXTERNALSYM GetCapture}
function GetCapture: HWND; stdcall;
{$EXTERNALSYM SetCapture}
function SetCapture(hWnd: HWND): HWND; stdcall;
{$EXTERNALSYM ReleaseCapture}
function ReleaseCapture: BOOL; stdcall;
{$EXTERNALSYM MsgWaitForMultipleObjects}
function MsgWaitForMultipleObjects(nCount: DWORD; var pHandles;
  fWaitAll: BOOL; dwMilliseconds, dwWakeMask: DWORD): DWORD; stdcall;
{$EXTERNALSYM MsgWaitForMultipleObjectsEx}
function MsgWaitForMultipleObjectsEx(nCount: DWORD; var pHandles;
  dwMilliseconds, dwWakeMask, dwFlags: DWORD): DWORD; stdcall;

const
  {$EXTERNALSYM MWMO_WAITALL}
  MWMO_WAITALL = $0001;
  {$EXTERNALSYM MWMO_ALERTABLE}
  MWMO_ALERTABLE = $0002;

  { Queue status flags for GetQueueStatus() and MsgWaitForMultipleObjects() }
  {$EXTERNALSYM QS_KEY}
  QS_KEY                  = $0001;
  {$EXTERNALSYM QS_MOUSEMOVE}
  QS_MOUSEMOVE            = $0002;
  {$EXTERNALSYM QS_MOUSEBUTTON}
  QS_MOUSEBUTTON          = $0004;
  {$EXTERNALSYM QS_POSTMESSAGE}
  QS_POSTMESSAGE          = $0008;
  {$EXTERNALSYM QS_TIMER}
  QS_TIMER                = $0010;
  {$EXTERNALSYM QS_PAINT}
  QS_PAINT                = $0020;
  {$EXTERNALSYM QS_SENDMESSAGE}
  QS_SENDMESSAGE          = $0040;
  {$EXTERNALSYM QS_HOTKEY}
  QS_HOTKEY               = $0080;
  {$EXTERNALSYM QS_ALLPOSTMESSAGE}
  QS_ALLPOSTMESSAGE       = $0100;

  {$EXTERNALSYM QS_MOUSE}
  QS_MOUSE = (QS_MOUSEMOVE or QS_MOUSEBUTTON);
  {$EXTERNALSYM QS_INPUT}
  QS_INPUT = (QS_MOUSE or QS_KEY);
  {$EXTERNALSYM QS_ALLEVENTS}
  QS_ALLEVENTS = (QS_INPUT or QS_POSTMESSAGE or QS_TIMER or QS_PAINT
    or QS_HOTKEY);
  {$EXTERNALSYM QS_ALLINPUT}
  QS_ALLINPUT = (QS_INPUT or QS_POSTMESSAGE or QS_TIMER or QS_PAINT
    or QS_HOTKEY or QS_SENDMESSAGE);


{ Windows Functions }

{$EXTERNALSYM SetTimer}
function SetTimer(hWnd: HWND; nIDEvent, uElapse: UINT;
  lpTimerFunc: TFNTimerProc): UINT; stdcall;
{$EXTERNALSYM KillTimer}
function KillTimer(hWnd: HWND; uIDEvent: UINT): BOOL; stdcall;
{$EXTERNALSYM IsWindowUnicode}
function IsWindowUnicode(hWnd: HWND): BOOL; stdcall;
{$EXTERNALSYM EnableWindow}
function EnableWindow(hWnd: HWND; bEnable: BOOL): BOOL; stdcall;
{$EXTERNALSYM IsWindowEnabled}
function IsWindowEnabled(hWnd: HWND): BOOL; stdcall;
{$EXTERNALSYM LoadAccelerators}
function LoadAccelerators(hInstance: HINST; lpTableName: PChar): HACCEL; stdcall;
{$EXTERNALSYM LoadAcceleratorsA}
function LoadAcceleratorsA(hInstance: HINST; lpTableName: PAnsiChar): HACCEL; stdcall;
{$EXTERNALSYM LoadAcceleratorsW}
function LoadAcceleratorsW(hInstance: HINST; lpTableName: PWideChar): HACCEL; stdcall;
{$EXTERNALSYM CreateAcceleratorTable}
function CreateAcceleratorTable(var Accel; Count: Integer): HACCEL; stdcall;
{$EXTERNALSYM CreateAcceleratorTableA}
function CreateAcceleratorTableA(var Accel; Count: Integer): HACCEL; stdcall;
{$EXTERNALSYM CreateAcceleratorTableW}
function CreateAcceleratorTableW(var Accel; Count: Integer): HACCEL; stdcall;
{$EXTERNALSYM CopyAcceleratorTable}
function CopyAcceleratorTable(hAccelSrc: HACCEL; var lpAccelDst; cAccelEntries: Integer): Integer; stdcall;
{$EXTERNALSYM CopyAcceleratorTableA}
function CopyAcceleratorTableA(hAccelSrc: HACCEL; var lpAccelDst; cAccelEntries: Integer): Integer; stdcall;
{$EXTERNALSYM CopyAcceleratorTableW}
function CopyAcceleratorTableW(hAccelSrc: HACCEL; var lpAccelDst; cAccelEntries: Integer): Integer; stdcall;
{$EXTERNALSYM TranslateAccelerator}
function TranslateAccelerator(hWnd: HWND; hAccTable: HACCEL; var lpMsg: TMsg): Integer; stdcall;
{$EXTERNALSYM TranslateAcceleratorA}
function TranslateAcceleratorA(hWnd: HWND; hAccTable: HACCEL; var lpMsg: TMsg): Integer; stdcall;
{$EXTERNALSYM TranslateAcceleratorW}
function TranslateAcceleratorW(hWnd: HWND; hAccTable: HACCEL; var lpMsg: TMsg): Integer; stdcall;
{$EXTERNALSYM DestroyAcceleratorTable}
function DestroyAcceleratorTable(hAccel: HACCEL): BOOL; stdcall;

const
  { GetSystemMetrics() codes }
  {$EXTERNALSYM SM_CXSCREEN}
  SM_CXSCREEN = 0;
  {$EXTERNALSYM SM_CYSCREEN}
  SM_CYSCREEN = 1;
  {$EXTERNALSYM SM_CXVSCROLL}
  SM_CXVSCROLL = 2;
  {$EXTERNALSYM SM_CYHSCROLL}
  SM_CYHSCROLL = 3;
  {$EXTERNALSYM SM_CYCAPTION}
  SM_CYCAPTION = 4;
  {$EXTERNALSYM SM_CXBORDER}
  SM_CXBORDER = 5;
  {$EXTERNALSYM SM_CYBORDER}
  SM_CYBORDER = 6;
  {$EXTERNALSYM SM_CXDLGFRAME}
  SM_CXDLGFRAME = 7;
  {$EXTERNALSYM SM_CYDLGFRAME}
  SM_CYDLGFRAME = 8;
  {$EXTERNALSYM SM_CYVTHUMB}
  SM_CYVTHUMB = 9;
  {$EXTERNALSYM SM_CXHTHUMB}
  SM_CXHTHUMB = 10;
  {$EXTERNALSYM SM_CXICON}
  SM_CXICON = 11;
  {$EXTERNALSYM SM_CYICON}
  SM_CYICON = 12;
  {$EXTERNALSYM SM_CXCURSOR}
  SM_CXCURSOR = 13;
  {$EXTERNALSYM SM_CYCURSOR}
  SM_CYCURSOR = 14;
  {$EXTERNALSYM SM_CYMENU}
  SM_CYMENU = 15;
  {$EXTERNALSYM SM_CXFULLSCREEN}
  SM_CXFULLSCREEN = $10;
  {$EXTERNALSYM SM_CYFULLSCREEN}
  SM_CYFULLSCREEN = 17;
  {$EXTERNALSYM SM_CYKANJIWINDOW}
  SM_CYKANJIWINDOW = 18;
  {$EXTERNALSYM SM_MOUSEPRESENT}
  SM_MOUSEPRESENT = 19;
  {$EXTERNALSYM SM_CYVSCROLL}
  SM_CYVSCROLL = 20;
  {$EXTERNALSYM SM_CXHSCROLL}
  SM_CXHSCROLL = 21;
  {$EXTERNALSYM SM_DEBUG}
  SM_DEBUG = 22;
  {$EXTERNALSYM SM_SWAPBUTTON}
  SM_SWAPBUTTON = 23;
  {$EXTERNALSYM SM_RESERVED1}
  SM_RESERVED1 = 24;
  {$EXTERNALSYM SM_RESERVED2}
  SM_RESERVED2 = 25;
  {$EXTERNALSYM SM_RESERVED3}
  SM_RESERVED3 = 26;
  {$EXTERNALSYM SM_RESERVED4}
  SM_RESERVED4 = 27;
  {$EXTERNALSYM SM_CXMIN}
  SM_CXMIN = 28;
  {$EXTERNALSYM SM_CYMIN}
  SM_CYMIN = 29;
  {$EXTERNALSYM SM_CXSIZE}
  SM_CXSIZE = 30;
  {$EXTERNALSYM SM_CYSIZE}
  SM_CYSIZE = 31;
  {$EXTERNALSYM SM_CXFRAME}
  SM_CXFRAME = $20;
  {$EXTERNALSYM SM_CYFRAME}
  SM_CYFRAME = 33;
  {$EXTERNALSYM SM_CXMINTRACK}
  SM_CXMINTRACK = 34;
  {$EXTERNALSYM SM_CYMINTRACK}
  SM_CYMINTRACK = 35;
  {$EXTERNALSYM SM_CXDOUBLECLK}
  SM_CXDOUBLECLK = 36;
  {$EXTERNALSYM SM_CYDOUBLECLK}
  SM_CYDOUBLECLK = 37;
  {$EXTERNALSYM SM_CXICONSPACING}
  SM_CXICONSPACING = 38;
  {$EXTERNALSYM SM_CYICONSPACING}
  SM_CYICONSPACING = 39;
  {$EXTERNALSYM SM_MENUDROPALIGNMENT}
  SM_MENUDROPALIGNMENT = 40;
  {$EXTERNALSYM SM_PENWINDOWS}
  SM_PENWINDOWS = 41;
  {$EXTERNALSYM SM_DBCSENABLED}
  SM_DBCSENABLED = 42;
  {$EXTERNALSYM SM_CMOUSEBUTTONS}
  SM_CMOUSEBUTTONS = 43;

  {$EXTERNALSYM SM_CXFIXEDFRAME}
  SM_CXFIXEDFRAME = SM_CXDLGFRAME; { win40 name change }
  {$EXTERNALSYM SM_CYFIXEDFRAME}
  SM_CYFIXEDFRAME = SM_CYDLGFRAME; { win40 name change }
  {$EXTERNALSYM SM_CXSIZEFRAME}
  SM_CXSIZEFRAME = SM_CXFRAME;     { win40 name change }
  {$EXTERNALSYM SM_CYSIZEFRAME}
  SM_CYSIZEFRAME = SM_CYFRAME;     { win40 name change }

  {$EXTERNALSYM SM_SECURE}
  SM_SECURE = 44;
  {$EXTERNALSYM SM_CXEDGE}
  SM_CXEDGE = 45;
  {$EXTERNALSYM SM_CYEDGE}
  SM_CYEDGE = 46;
  {$EXTERNALSYM SM_CXMINSPACING}
  SM_CXMINSPACING = 47;
  {$EXTERNALSYM SM_CYMINSPACING}
  SM_CYMINSPACING = 48;
  {$EXTERNALSYM SM_CXSMICON}
  SM_CXSMICON = 49;
  {$EXTERNALSYM SM_CYSMICON}
  SM_CYSMICON = 50;
  {$EXTERNALSYM SM_CYSMCAPTION}
  SM_CYSMCAPTION = 51;
  {$EXTERNALSYM SM_CXSMSIZE}
  SM_CXSMSIZE = 52;
  {$EXTERNALSYM SM_CYSMSIZE}
  SM_CYSMSIZE = 53;
  {$EXTERNALSYM SM_CXMENUSIZE}
  SM_CXMENUSIZE = 54;
  {$EXTERNALSYM SM_CYMENUSIZE}
  SM_CYMENUSIZE = 55;
  {$EXTERNALSYM SM_ARRANGE}
  SM_ARRANGE = 56;
  {$EXTERNALSYM SM_CXMINIMIZED}
  SM_CXMINIMIZED = 57;
  {$EXTERNALSYM SM_CYMINIMIZED}
  SM_CYMINIMIZED = 58;
  {$EXTERNALSYM SM_CXMAXTRACK}
  SM_CXMAXTRACK = 59;
  {$EXTERNALSYM SM_CYMAXTRACK}
  SM_CYMAXTRACK = 60;
  {$EXTERNALSYM SM_CXMAXIMIZED}
  SM_CXMAXIMIZED = 61;
  {$EXTERNALSYM SM_CYMAXIMIZED}
  SM_CYMAXIMIZED = 62;
  {$EXTERNALSYM SM_NETWORK}
  SM_NETWORK = 63;
  {$EXTERNALSYM SM_CLEANBOOT}
  SM_CLEANBOOT = 67;
  {$EXTERNALSYM SM_CXDRAG}
  SM_CXDRAG = 68;
  {$EXTERNALSYM SM_CYDRAG}
  SM_CYDRAG = 69;
  {$EXTERNALSYM SM_SHOWSOUNDS}
  SM_SHOWSOUNDS = 70;
  {$EXTERNALSYM SM_CXMENUCHECK}
  SM_CXMENUCHECK = 71;     { Use instead of GetMenuCheckMarkDimensions()! }
  {$EXTERNALSYM SM_CYMENUCHECK}
  SM_CYMENUCHECK = 72;
  {$EXTERNALSYM SM_SLOWMACHINE}
  SM_SLOWMACHINE = 73;
  {$EXTERNALSYM SM_MIDEASTENABLED}
  SM_MIDEASTENABLED = 74;
  {$EXTERNALSYM SM_MOUSEWHEELPRESENT}
  SM_MOUSEWHEELPRESENT = 75;
  {$EXTERNALSYM SM_CMETRICS}
  SM_CMETRICS = 76;
  {$EXTERNALSYM SM_XVIRTUALSCREEN}
  SM_XVIRTUALSCREEN = 76;
  {$EXTERNALSYM SM_YVIRTUALSCREEN}
  SM_YVIRTUALSCREEN = 77;
  {$EXTERNALSYM SM_CXVIRTUALSCREEN}
  SM_CXVIRTUALSCREEN = 78;
  {$EXTERNALSYM SM_CYVIRTUALSCREEN}
  SM_CYVIRTUALSCREEN = 79;
  {$EXTERNALSYM SM_CMONITORS}
  SM_CMONITORS = 80;
  {$EXTERNALSYM SM_SAMEDISPLAYFORMAT}
  SM_SAMEDISPLAYFORMAT = 81;
  {$EXTERNALSYM SM_IMMENABLED}
  SM_IMMENABLED = 82;
  {$EXTERNALSYM SM_CXFOCUSBORDER}
  SM_CXFOCUSBORDER = 83;
  {$EXTERNALSYM SM_CYFOCUSBORDER}
  SM_CYFOCUSBORDER = 84;

{$EXTERNALSYM GetSystemMetrics}
function GetSystemMetrics(nIndex: Integer): Integer; stdcall;
{$EXTERNALSYM LoadMenu}
function LoadMenu(hInstance: HINST; lpMenuName: PChar): HMENU; stdcall;
{$EXTERNALSYM LoadMenuA}
function LoadMenuA(hInstance: HINST; lpMenuName: PAnsiChar): HMENU; stdcall;
{$EXTERNALSYM LoadMenuW}
function LoadMenuW(hInstance: HINST; lpMenuName: PWideChar): HMENU; stdcall;
{$EXTERNALSYM LoadMenuIndirect}
function LoadMenuIndirect(lpMenuTemplate: Pointer): HMENU; stdcall;
{$EXTERNALSYM LoadMenuIndirectA}
function LoadMenuIndirectA(lpMenuTemplate: Pointer): HMENU; stdcall;
{$EXTERNALSYM LoadMenuIndirectW}
function LoadMenuIndirectW(lpMenuTemplate: Pointer): HMENU; stdcall;
{$EXTERNALSYM GetMenu}
function GetMenu(hWnd: HWND): HMENU; stdcall;
{$EXTERNALSYM SetMenu}
function SetMenu(hWnd: HWND; hMenu: HMENU): BOOL; stdcall;
{$EXTERNALSYM ChangeMenu}
function ChangeMenu(hMenu: HMENU; cmd: UINT; lpszNewItem: PChar;
  cmdInsert: UINT; flags: UINT): BOOL; stdcall;
{$EXTERNALSYM ChangeMenuA}
function ChangeMenuA(hMenu: HMENU; cmd: UINT; lpszNewItem: PAnsiChar;
  cmdInsert: UINT; flags: UINT): BOOL; stdcall;
{$EXTERNALSYM ChangeMenuW}
function ChangeMenuW(hMenu: HMENU; cmd: UINT; lpszNewItem: PWideChar;
  cmdInsert: UINT; flags: UINT): BOOL; stdcall;
{$EXTERNALSYM HiliteMenuItem}
function HiliteMenuItem(hWnd: HWND; hMenu: HMENU; uIDHiliteItem: UINT;
  uHilite: UINT): BOOL; stdcall;
{$EXTERNALSYM GetMenuString}
function GetMenuString(hMenu: HMENU; uIDItem: UINT; lpString: PChar;
  nMaxCount: Integer; uFlag: UINT): Integer; stdcall;
{$EXTERNALSYM GetMenuStringA}
function GetMenuStringA(hMenu: HMENU; uIDItem: UINT; lpString: PAnsiChar;
  nMaxCount: Integer; uFlag: UINT): Integer; stdcall;
{$EXTERNALSYM GetMenuStringW}
function GetMenuStringW(hMenu: HMENU; uIDItem: UINT; lpString: PWideChar;
  nMaxCount: Integer; uFlag: UINT): Integer; stdcall;
{$EXTERNALSYM GetMenuState}
function GetMenuState(hMenu: HMENU; uId, uFlags: UINT): UINT; stdcall;
{$EXTERNALSYM DrawMenuBar}
function DrawMenuBar(hWnd: HWND): BOOL; stdcall;
{$EXTERNALSYM GetSystemMenu}
function GetSystemMenu(hWnd: HWND; bRevert: BOOL): HMENU; stdcall;
{$EXTERNALSYM CreateMenu}
function CreateMenu: HMENU; stdcall;
{$EXTERNALSYM CreatePopupMenu}
function CreatePopupMenu: HMENU; stdcall;
{$EXTERNALSYM DestroyMenu}
function DestroyMenu(hMenu: HMENU): BOOL; stdcall;
{$EXTERNALSYM CheckMenuItem}
function CheckMenuItem(hMenu: HMENU; uIDCheckItem, uCheck: UINT): DWORD; stdcall;
{$EXTERNALSYM EnableMenuItem}
function EnableMenuItem(hMenu: HMENU; uIDEnableItem, uEnable: UINT): BOOL; stdcall;
{$EXTERNALSYM GetSubMenu}
function GetSubMenu(hMenu: HMENU; nPos: Integer): HMENU; stdcall;
{$EXTERNALSYM GetMenuItemID}
function GetMenuItemID(hMenu: HMENU; nPos: Integer): UINT; stdcall;
{$EXTERNALSYM GetMenuItemCount}
function GetMenuItemCount(hMenu: HMENU): Integer; stdcall;
{$EXTERNALSYM InsertMenu}
function InsertMenu(hMenu: HMENU; uPosition, uFlags, uIDNewItem: UINT;
  lpNewItem: PChar): BOOL; stdcall;
{$EXTERNALSYM InsertMenuA}
function InsertMenuA(hMenu: HMENU; uPosition, uFlags, uIDNewItem: UINT;
  lpNewItem: PAnsiChar): BOOL; stdcall;
{$EXTERNALSYM InsertMenuW}
function InsertMenuW(hMenu: HMENU; uPosition, uFlags, uIDNewItem: UINT;
  lpNewItem: PWideChar): BOOL; stdcall;
{$EXTERNALSYM AppendMenu}
function AppendMenu(hMenu: HMENU; uFlags, uIDNewItem: UINT;
  lpNewItem: PChar): BOOL; stdcall;
{$EXTERNALSYM AppendMenuA}
function AppendMenuA(hMenu: HMENU; uFlags, uIDNewItem: UINT;
  lpNewItem: PAnsiChar): BOOL; stdcall;
{$EXTERNALSYM AppendMenuW}
function AppendMenuW(hMenu: HMENU; uFlags, uIDNewItem: UINT;
  lpNewItem: PWideChar): BOOL; stdcall;
{$EXTERNALSYM ModifyMenu}
function ModifyMenu(hMnu: HMENU; uPosition, uFlags, uIDNewItem: UINT;
  lpNewItem: PChar): BOOL; stdcall;
{$EXTERNALSYM ModifyMenuA}
function ModifyMenuA(hMnu: HMENU; uPosition, uFlags, uIDNewItem: UINT;
  lpNewItem: PAnsiChar): BOOL; stdcall;
{$EXTERNALSYM ModifyMenuW}
function ModifyMenuW(hMnu: HMENU; uPosition, uFlags, uIDNewItem: UINT;
  lpNewItem: PWideChar): BOOL; stdcall;
{$EXTERNALSYM RemoveMenu}
function RemoveMenu(hMenu: HMENU; uPosition, uFlags: UINT): BOOL; stdcall;
{$EXTERNALSYM DeleteMenu}
function DeleteMenu(hMenu: HMENU; uPosition, uFlags: UINT): BOOL; stdcall;
{$EXTERNALSYM SetMenuItemBitmaps}
function SetMenuItemBitmaps(hMenu: HMENU; uPosition, uFlags: UINT;
  hBitmapUnchecked: HBITMAP; hBitmapChecked: HBITMAP): BOOL; stdcall;
{$EXTERNALSYM GetMenuCheckMarkDimensions}
function GetMenuCheckMarkDimensions: Longint; stdcall;
{$EXTERNALSYM TrackPopupMenu}
function TrackPopupMenu(hMenu: HMENU; uFlags: UINT; x, y, nReserved: Integer;
  hWnd: HWND; prcRect: PRect): BOOL; stdcall;


const
  { return codes for WM_MENUCHAR }
  {$EXTERNALSYM MNC_IGNORE}
  MNC_IGNORE = 0;
  {$EXTERNALSYM MNC_CLOSE}
  MNC_CLOSE = 1;
  {$EXTERNALSYM MNC_EXECUTE}
  MNC_EXECUTE = 2;
  {$EXTERNALSYM MNC_SELECT}
  MNC_SELECT = 3;

type
  PTPMParams = ^TTPMParams;
  {$EXTERNALSYM tagTPMPARAMS}
  tagTPMPARAMS = packed record
    cbSize: UINT;     { Size of structure }
    rcExclude: TRect; { Screen coordinates of rectangle to exclude when positioning }
  end;
  TTPMParams = tagTPMPARAMS;
  {$EXTERNALSYM TPMPARAMS}
  TPMPARAMS = tagTPMPARAMS;

{$EXTERNALSYM TrackPopupMenuEx}
function TrackPopupMenuEx(hMenu: HMENU; Flags: UINT; x, y: Integer;
  Wnd: HWND; TPMParams: PTPMParams): BOOL; stdcall;

const
  {$EXTERNALSYM MNS_NOCHECK}
  MNS_NOCHECK = $80000000;
  {$EXTERNALSYM MNS_MODELESS}
  MNS_MODELESS = $40000000;
  {$EXTERNALSYM MNS_DRAGDROP}
  MNS_DRAGDROP = $20000000;
  {$EXTERNALSYM MNS_AUTODISMISS}
  MNS_AUTODISMISS = $10000000;
  {$EXTERNALSYM MNS_NOTIFYBYPOS}
  MNS_NOTIFYBYPOS = $8000000;
  {$EXTERNALSYM MNS_CHECKORBMP}
  MNS_CHECKORBMP = $4000000;

  {$EXTERNALSYM MIM_MAXHEIGHT}
  MIM_MAXHEIGHT = 1;
  {$EXTERNALSYM MIM_BACKGROUND}
  MIM_BACKGROUND = 2;
  {$EXTERNALSYM MIM_HELPID}
  MIM_HELPID = 4;
  {$EXTERNALSYM MIM_MENUDATA}
  MIM_MENUDATA = 8;
  {$EXTERNALSYM MIM_STYLE}
  MIM_STYLE = $10;
  {$EXTERNALSYM MIM_APPLYTOSUBMENUS}
  MIM_APPLYTOSUBMENUS = $80000000;

type
  {$EXTERNALSYM PMenuInfo}
  PMenuInfo = ^TMenuInfo;
  {$EXTERNALSYM tagMENUINFO}
  tagMENUINFO = packed record
    cbSize: DWORD;
    fMask: DWORD;
    dwStyle: DWORD;
    cyMax: UINT;
    hbrBack: HBRUSH;
    dwContextHelpID: DWORD;
    dwMenuData: DWORD;
  end;
  {$EXTERNALSYM TMenuInfo}
  TMenuInfo = tagMENUINFO;

{$EXTERNALSYM GetMenuInfo}
function GetMenuInfo(hMenu: HMENU; var lpmi: TMenuInfo): BOOL; stdcall;
{$EXTERNALSYM SetMenuInfo}
function SetMenuInfo(hMenu: HMENU; const lpcmi: TMenuInfo): BOOL; stdcall;
{$EXTERNALSYM EndMenu}
function EndMenu: BOOL; stdcall;

const
  { WM_MENUDRAG return values }
  {$EXTERNALSYM MND_CONTINUE}
  MND_CONTINUE = 0;
  {$EXTERNALSYM MND_ENDMENU}
  MND_ENDMENU = 1;

type
  {$EXTERNALSYM PMenuGetObjectInfo}
  PMenuGetObjectInfo = ^TMenuGetObjectInfo;
  {$EXTERNALSYM tagMENUGETOBJECTINFO}
  tagMENUGETOBJECTINFO = packed record
    dwFlags: DWORD;
    uPos: UINT;
    hmenu: HMENU;
    riid: Pointer;
    pvObj: Pointer;
  end;
  {$EXTERNALSYM TMenuGetObjectInfo}
  TMenuGetObjectInfo = tagMENUGETOBJECTINFO;


const
  { MENUGETOBJECTINFO dwFlags values }
  {$EXTERNALSYM MNGOF_GAP}
  MNGOF_GAP = 3;

  { MENUGETOBJECT returns values }
  {$EXTERNALSYM MNGO_NOINTERFACE}
  MNGO_NOINTERFACE = 0;
  {$EXTERNALSYM MNGO_NOERROR}
  MNGO_NOERROR = 1;

  {$EXTERNALSYM MIIM_STATE}
  MIIM_STATE = 1;
  {$EXTERNALSYM MIIM_ID}
  MIIM_ID = 2;
  {$EXTERNALSYM MIIM_SUBMENU}
  MIIM_SUBMENU = 4;
  {$EXTERNALSYM MIIM_CHECKMARKS}
  MIIM_CHECKMARKS = 8;
  {$EXTERNALSYM MIIM_TYPE}
  MIIM_TYPE = $10;
  {$EXTERNALSYM MIIM_DATA}
  MIIM_DATA = $20;
  {$EXTERNALSYM MIIM_STRING}
  MIIM_STRING = $40;
  {$EXTERNALSYM MIIM_BITMAP}
  MIIM_BITMAP = $80;
  {$EXTERNALSYM MIIM_FTYPE}
  MIIM_FTYPE = $100;

  {$EXTERNALSYM HBMMENU_CALLBACK}
  HBMMENU_CALLBACK = -1;
  {$EXTERNALSYM HBMMENU_SYSTEM}
  HBMMENU_SYSTEM = 1;
  {$EXTERNALSYM HBMMENU_MBAR_RESTORE}
  HBMMENU_MBAR_RESTORE = 2;
  {$EXTERNALSYM HBMMENU_MBAR_MINIMIZE}
  HBMMENU_MBAR_MINIMIZE = 3;
  {$EXTERNALSYM HBMMENU_MBAR_CLOSE}
  HBMMENU_MBAR_CLOSE = 5;
  {$EXTERNALSYM HBMMENU_MBAR_CLOSE_D}
  HBMMENU_MBAR_CLOSE_D = 6;
  {$EXTERNALSYM HBMMENU_MBAR_MINIMIZE_D}
  HBMMENU_MBAR_MINIMIZE_D = 7;
  {$EXTERNALSYM HBMMENU_POPUP_CLOSE}
  HBMMENU_POPUP_CLOSE = 8;
  {$EXTERNALSYM HBMMENU_POPUP_RESTORE}
  HBMMENU_POPUP_RESTORE = 9;
  {$EXTERNALSYM HBMMENU_POPUP_MAXIMIZE}
  HBMMENU_POPUP_MAXIMIZE = 10;
  {$EXTERNALSYM HBMMENU_POPUP_MINIMIZE}
  HBMMENU_POPUP_MINIMIZE = 11;


type
  PMenuItemInfoA = ^TMenuItemInfoA;
  PMenuItemInfoW = ^TMenuItemInfoW;
  PMenuItemInfo = PMenuItemInfoA;
  {$EXTERNALSYM tagMENUITEMINFOA}
  tagMENUITEMINFOA = packed record
    cbSize: UINT;
    fMask: UINT;
    fType: UINT;             { used if MIIM_TYPE}
    fState: UINT;            { used if MIIM_STATE}
    wID: UINT;               { used if MIIM_ID}
    hSubMenu: HMENU;         { used if MIIM_SUBMENU}
    hbmpChecked: HBITMAP;    { used if MIIM_CHECKMARKS}
    hbmpUnchecked: HBITMAP;  { used if MIIM_CHECKMARKS}
    dwItemData: DWORD;       { used if MIIM_DATA}
    dwTypeData: PAnsiChar;      { used if MIIM_TYPE}
    cch: UINT;               { used if MIIM_TYPE}
    hbmpItem: HBITMAP;       { used if MIIM_BITMAP}
  end;
  {$EXTERNALSYM tagMENUITEMINFOW}
  tagMENUITEMINFOW = packed record
    cbSize: UINT;
    fMask: UINT;
    fType: UINT;             { used if MIIM_TYPE}
    fState: UINT;            { used if MIIM_STATE}
    wID: UINT;               { used if MIIM_ID}
    hSubMenu: HMENU;         { used if MIIM_SUBMENU}
    hbmpChecked: HBITMAP;    { used if MIIM_CHECKMARKS}
    hbmpUnchecked: HBITMAP;  { used if MIIM_CHECKMARKS}
    dwItemData: DWORD;       { used if MIIM_DATA}
    dwTypeData: PWideChar;      { used if MIIM_TYPE}
    cch: UINT;               { used if MIIM_TYPE}
    hbmpItem: HBITMAP;       { used if MIIM_BITMAP}
  end;
  {$EXTERNALSYM tagMENUITEMINFO}
  tagMENUITEMINFO = tagMENUITEMINFOA;
  TMenuItemInfoA = tagMENUITEMINFOA;
  TMenuItemInfoW = tagMENUITEMINFOW;
  TMenuItemInfo = TMenuItemInfoA;
  {$EXTERNALSYM MENUITEMINFOA}
  MENUITEMINFOA = tagMENUITEMINFOA;
  {$EXTERNALSYM MENUITEMINFOW}
  MENUITEMINFOW = tagMENUITEMINFOW;
  {$EXTERNALSYM MENUITEMINFO}
  MENUITEMINFO = MENUITEMINFOA;

{$EXTERNALSYM InsertMenuItem}
function InsertMenuItem(p1: HMENU; p2: UINT; p3: BOOL; const p4: TMenuItemInfo): BOOL; stdcall;
{$EXTERNALSYM InsertMenuItemA}
function InsertMenuItemA(p1: HMENU; p2: UINT; p3: BOOL; const p4: TMenuItemInfoA): BOOL; stdcall;
{$EXTERNALSYM InsertMenuItemW}
function InsertMenuItemW(p1: HMENU; p2: UINT; p3: BOOL; const p4: TMenuItemInfoW): BOOL; stdcall;
{$EXTERNALSYM GetMenuItemInfo}
function GetMenuItemInfo(p1: HMENU; p2: UINT; p3: BOOL; var p4: TMenuItemInfo): BOOL; stdcall;
{$EXTERNALSYM GetMenuItemInfoA}
function GetMenuItemInfoA(p1: HMENU; p2: UINT; p3: BOOL; var p4: TMenuItemInfoA): BOOL; stdcall;
{$EXTERNALSYM GetMenuItemInfoW}
function GetMenuItemInfoW(p1: HMENU; p2: UINT; p3: BOOL; var p4: TMenuItemInfoW): BOOL; stdcall;
{$EXTERNALSYM SetMenuItemInfo}
function SetMenuItemInfo(p1: HMENU; p2: UINT; p3: BOOL; const p4: TMenuItemInfo): BOOL; stdcall;
{$EXTERNALSYM SetMenuItemInfoA}
function SetMenuItemInfoA(p1: HMENU; p2: UINT; p3: BOOL; const p4: TMenuItemInfoA): BOOL; stdcall;
{$EXTERNALSYM SetMenuItemInfoW}
function SetMenuItemInfoW(p1: HMENU; p2: UINT; p3: BOOL; const p4: TMenuItemInfoW): BOOL; stdcall;

const
  {$EXTERNALSYM GMDI_USEDISABLED}
  GMDI_USEDISABLED = 1;
  {$EXTERNALSYM GMDI_GOINTOPOPUPS}
  GMDI_GOINTOPOPUPS = 2;

{$EXTERNALSYM GetMenuDefaultItem}
function GetMenuDefaultItem(hMenu: HMENU; fByPos, gmdiFlags: UINT): UINT; stdcall;
{$EXTERNALSYM SetMenuDefaultItem}
function SetMenuDefaultItem(hMenu: HMENU; uItem, fByPos: UINT): BOOL; stdcall;
{$EXTERNALSYM GetMenuItemRect}
function GetMenuItemRect(hWnd: HWND; hMenu: HMENU; uItem: UINT;
  var lprcItem: TRect): BOOL; stdcall;
{$EXTERNALSYM MenuItemFromPoint}
function MenuItemFromPoint(hWnd: HWND; hMenu: HMENU; ptScreen: TPoint): BOOL; stdcall;

const
  { Flags for TrackPopupMenu }
  {$EXTERNALSYM TPM_LEFTBUTTON}
  TPM_LEFTBUTTON = 0;
  {$EXTERNALSYM TPM_RIGHTBUTTON}
  TPM_RIGHTBUTTON = 2;
  {$EXTERNALSYM TPM_LEFTALIGN}
  TPM_LEFTALIGN = 0;
  {$EXTERNALSYM TPM_CENTERALIGN}
  TPM_CENTERALIGN = 4;
  {$EXTERNALSYM TPM_RIGHTALIGN}
  TPM_RIGHTALIGN = 8;
  {$EXTERNALSYM TPM_TOPALIGN}
  TPM_TOPALIGN = 0;
  {$EXTERNALSYM TPM_VCENTERALIGN}
  TPM_VCENTERALIGN = $10;
  {$EXTERNALSYM TPM_BOTTOMALIGN}
  TPM_BOTTOMALIGN = $20;

  {$EXTERNALSYM TPM_HORIZONTAL}
  TPM_HORIZONTAL = 0;   { Horz alignment matters more }
  {$EXTERNALSYM TPM_VERTICAL}
  TPM_VERTICAL = $40;   { Vert alignment matters more }
  {$EXTERNALSYM TPM_NONOTIFY}
  TPM_NONOTIFY = $80;   { Don't send any notification msgs }
  {$EXTERNALSYM TPM_RETURNCMD}
  TPM_RETURNCMD = $100;
  {$EXTERNALSYM TPM_RECURSE}
  TPM_RECURSE = $1;
  {$EXTERNALSYM TPM_HORPOSANIMATION}
  TPM_HORPOSANIMATION = $0400;
  {$EXTERNALSYM TPM_HORNEGANIMATION}
  TPM_HORNEGANIMATION = $0800;
  {$EXTERNALSYM TPM_VERPOSANIMATION}
  TPM_VERPOSANIMATION = $1000;
  {$EXTERNALSYM TPM_VERNEGANIMATION}
  TPM_VERNEGANIMATION = $2000;
  {$EXTERNALSYM TPM_NOANIMATION}
  TPM_NOANIMATION     = $4000;


{ Drag-and-drop support }

type
  PDropStruct = ^TDropStruct;
  {$EXTERNALSYM tagDROPSTRUCT}
  tagDROPSTRUCT = packed record
    hwndSource: HWND;
    hwndSink: HWND;
    wFmt: DWORD;
    dwData: DWORD;
    ptDrop: TPoint;
    dwControlData: DWORD;
  end;
  TDropStruct = tagDROPSTRUCT;
  {$EXTERNALSYM DROPSTRUCT}
  DROPSTRUCT = tagDROPSTRUCT;

const
  {$EXTERNALSYM DOF_EXECUTABLE}
  DOF_EXECUTABLE = 32769;
  {$EXTERNALSYM DOF_DOCUMENT}
  DOF_DOCUMENT = 32770;
  {$EXTERNALSYM DOF_DIRECTORY}
  DOF_DIRECTORY = 32771;
  {$EXTERNALSYM DOF_MULTIPLE}
  DOF_MULTIPLE = 32772;
  {$EXTERNALSYM DOF_PROGMAN}
  DOF_PROGMAN = 1;
  {$EXTERNALSYM DOF_SHELLDATA}
  DOF_SHELLDATA = 2;

  {$EXTERNALSYM DO_DROPFILE}
  DO_DROPFILE = $454C4946;
  {$EXTERNALSYM DO_PRINTFILE}
  DO_PRINTFILE = $544E5250;

{$EXTERNALSYM DragObject}
function DragObject(p1, p2: HWND; p3: UINT; p4: DWORD;
  p5: HICON): DWORD; stdcall;
{$EXTERNALSYM DragDetect}
function DragDetect(p1: HWND; p2: TPoint): BOOL; stdcall;
{$EXTERNALSYM DrawIcon}
function DrawIcon(hDC: HDC; X, Y: Integer; hIcon: HICON): BOOL; stdcall;

const
  { DrawText() Format Flags }
  {$EXTERNALSYM DT_TOP}
  DT_TOP = 0;
  {$EXTERNALSYM DT_LEFT}
  DT_LEFT = 0;
  {$EXTERNALSYM DT_CENTER}
  DT_CENTER = 1;
  {$EXTERNALSYM DT_RIGHT}
  DT_RIGHT = 2;
  {$EXTERNALSYM DT_VCENTER}
  DT_VCENTER = 4;
  {$EXTERNALSYM DT_BOTTOM}
  DT_BOTTOM = 8;
  {$EXTERNALSYM DT_WORDBREAK}
  DT_WORDBREAK = $10;
  {$EXTERNALSYM DT_SINGLELINE}
  DT_SINGLELINE = $20;
  {$EXTERNALSYM DT_EXPANDTABS}
  DT_EXPANDTABS = $40;
  {$EXTERNALSYM DT_TABSTOP}
  DT_TABSTOP = $80;
  {$EXTERNALSYM DT_NOCLIP}
  DT_NOCLIP = $100;
  {$EXTERNALSYM DT_EXTERNALLEADING}
  DT_EXTERNALLEADING = $200;
  {$EXTERNALSYM DT_CALCRECT}
  DT_CALCRECT = $400;
  {$EXTERNALSYM DT_NOPREFIX}
  DT_NOPREFIX = $800;
  {$EXTERNALSYM DT_INTERNAL}
  DT_INTERNAL = $1000;
  {$EXTERNALSYM DT_HIDEPREFIX}
  DT_HIDEPREFIX = $00100000;
  {$EXTERNALSYM DT_PREFIXONLY}
  DT_PREFIXONLY = $00200000;

  {$EXTERNALSYM DT_EDITCONTROL}
  DT_EDITCONTROL = $2000;
  {$EXTERNALSYM DT_PATH_ELLIPSIS}
  DT_PATH_ELLIPSIS = $4000;
  {$EXTERNALSYM DT_END_ELLIPSIS}
  DT_END_ELLIPSIS = $8000;
  {$EXTERNALSYM DT_MODIFYSTRING}
  DT_MODIFYSTRING = $10000;
  {$EXTERNALSYM DT_RTLREADING}
  DT_RTLREADING = $20000;
  {$EXTERNALSYM DT_WORD_ELLIPSIS}
  DT_WORD_ELLIPSIS = $40000;

type
  PDrawTextParams = ^TDrawTextParams;
  {$EXTERNALSYM tagDRAWTEXTPARAMS}
  tagDRAWTEXTPARAMS = packed record
    cbSize: UINT;
    iTabLength: Integer;
    iLeftMargin: Integer;
    iRightMargin: Integer;
    uiLengthDrawn: UINT;
  end;
  TDrawTextParams = tagDRAWTEXTPARAMS;
  {$EXTERNALSYM DRAWTEXTPARAMS}
  DRAWTEXTPARAMS = tagDRAWTEXTPARAMS;

{$EXTERNALSYM DrawText}
function DrawText(hDC: HDC; lpString: PChar; nCount: Integer;
  var lpRect: TRect; uFormat: UINT): Integer; stdcall;
{$EXTERNALSYM DrawTextA}
function DrawTextA(hDC: HDC; lpString: PAnsiChar; nCount: Integer;
  var lpRect: TRect; uFormat: UINT): Integer; stdcall;
{$EXTERNALSYM DrawTextW}
function DrawTextW(hDC: HDC; lpString: PWideChar; nCount: Integer;
  var lpRect: TRect; uFormat: UINT): Integer; stdcall;
{$EXTERNALSYM DrawTextEx}
function DrawTextEx(DC: HDC; lpchText: PChar; cchText: Integer; var p4: TRect;
  dwDTFormat: UINT; DTParams: PDrawTextParams): Integer; stdcall;
{$EXTERNALSYM DrawTextExA}
function DrawTextExA(DC: HDC; lpchText: PAnsiChar; cchText: Integer; var p4: TRect;
  dwDTFormat: UINT; DTParams: PDrawTextParams): Integer; stdcall;
{$EXTERNALSYM DrawTextExW}
function DrawTextExW(DC: HDC; lpchText: PWideChar; cchText: Integer; var p4: TRect;
  dwDTFormat: UINT; DTParams: PDrawTextParams): Integer; stdcall;
{$EXTERNALSYM GrayString}
function GrayString(hDC: HDC; hBrush: HBRUSH; lpOutputFunc: TFNGrayStringProc;
  lpData: LPARAM; nCount, X, Y, nWidth, nHeight: Integer): BOOL; stdcall;
{$EXTERNALSYM GrayStringA}
function GrayStringA(hDC: HDC; hBrush: HBRUSH; lpOutputFunc: TFNGrayStringProc;
  lpData: LPARAM; nCount, X, Y, nWidth, nHeight: Integer): BOOL; stdcall;
{$EXTERNALSYM GrayStringW}
function GrayStringW(hDC: HDC; hBrush: HBRUSH; lpOutputFunc: TFNGrayStringProc;
  lpData: LPARAM; nCount, X, Y, nWidth, nHeight: Integer): BOOL; stdcall;


{ Monolithic state-drawing routine }

const
  { Image type }
  {$EXTERNALSYM DST_COMPLEX}
  DST_COMPLEX = 0;
  {$EXTERNALSYM DST_TEXT}
  DST_TEXT = 1;
  {$EXTERNALSYM DST_PREFIXTEXT}
  DST_PREFIXTEXT = 2;
  {$EXTERNALSYM DST_ICON}
  DST_ICON = 3;
  {$EXTERNALSYM DST_BITMAP}
  DST_BITMAP = 4;

  { State type }
  {$EXTERNALSYM DSS_NORMAL}
  DSS_NORMAL = 0;
  {$EXTERNALSYM DSS_UNION}
  DSS_UNION = $10;     { Gray string appearance }
  {$EXTERNALSYM DSS_DISABLED}
  DSS_DISABLED = $20;
  {$EXTERNALSYM DSS_MONO}
  DSS_MONO = $80;
  {$EXTERNALSYM DSS_RIGHT}
  DSS_RIGHT = $8000;

{$EXTERNALSYM DrawState}
function DrawState(DC: HDC; Brush: HBRUSH; CBFunc: TFNDrawStateProc;
  lData: LPARAM; wData: WPARAM; x, y, cx, cy: Integer; Flags: UINT): BOOL; stdcall;
{$EXTERNALSYM DrawStateA}
function DrawStateA(DC: HDC; Brush: HBRUSH; CBFunc: TFNDrawStateProc;
  lData: LPARAM; wData: WPARAM; x, y, cx, cy: Integer; Flags: UINT): BOOL; stdcall;
{$EXTERNALSYM DrawStateW}
function DrawStateW(DC: HDC; Brush: HBRUSH; CBFunc: TFNDrawStateProc;
  lData: LPARAM; wData: WPARAM; x, y, cx, cy: Integer; Flags: UINT): BOOL; stdcall;
{$EXTERNALSYM TabbedTextOut}
function TabbedTextOut(hDC: HDC; X, Y: Integer; lpString: PChar; nCount, nTabPositions: Integer;
  var lpnTabStopPositions; nTabOrigin: Integer): Longint; stdcall;
{$EXTERNALSYM TabbedTextOutA}
function TabbedTextOutA(hDC: HDC; X, Y: Integer; lpString: PAnsiChar; nCount, nTabPositions: Integer;
  var lpnTabStopPositions; nTabOrigin: Integer): Longint; stdcall;
{$EXTERNALSYM TabbedTextOutW}
function TabbedTextOutW(hDC: HDC; X, Y: Integer; lpString: PWideChar; nCount, nTabPositions: Integer;
  var lpnTabStopPositions; nTabOrigin: Integer): Longint; stdcall;
{$EXTERNALSYM GetTabbedTextExtent}
function GetTabbedTextExtent(hDC: HDC; lpString: PChar;
  nCount, nTabPositions: Integer; var lpnTabStopPositions): DWORD; stdcall;
{$EXTERNALSYM GetTabbedTextExtentA}
function GetTabbedTextExtentA(hDC: HDC; lpString: PAnsiChar;
  nCount, nTabPositions: Integer; var lpnTabStopPositions): DWORD; stdcall;
{$EXTERNALSYM GetTabbedTextExtentW}
function GetTabbedTextExtentW(hDC: HDC; lpString: PWideChar;
  nCount, nTabPositions: Integer; var lpnTabStopPositions): DWORD; stdcall;
{$EXTERNALSYM UpdateWindow}
function UpdateWindow(hWnd: HWND): BOOL; stdcall;
{$EXTERNALSYM SetActiveWindow}
function SetActiveWindow(hWnd: HWND): HWND; stdcall;
{$EXTERNALSYM GetForegroundWindow}
function GetForegroundWindow: HWND; stdcall;
{$EXTERNALSYM PaintDesktop}
function PaintDesktop(hdc: HDC): BOOL; stdcall;
{$EXTERNALSYM SetForegroundWindow}
function SetForegroundWindow(hWnd: HWND): BOOL; stdcall;
{$EXTERNALSYM WindowFromDC}
function WindowFromDC(hDC: HDC): HWND; stdcall;
{$EXTERNALSYM GetDC}
function GetDC(hWnd: HWND): HDC; stdcall;
{$EXTERNALSYM GetDCEx}
function GetDCEx(hWnd: HWND; hrgnClip: HRGN; flags: DWORD): HDC; stdcall;

const
  { GetDCEx() flags }
  {$EXTERNALSYM DCX_WINDOW}
  DCX_WINDOW = 1;
  {$EXTERNALSYM DCX_CACHE}
  DCX_CACHE = 2;
  {$EXTERNALSYM DCX_NORESETATTRS}
  DCX_NORESETATTRS = 4;
  {$EXTERNALSYM DCX_CLIPCHILDREN}
  DCX_CLIPCHILDREN = 8;
  {$EXTERNALSYM DCX_CLIPSIBLINGS}
  DCX_CLIPSIBLINGS = $10;
  {$EXTERNALSYM DCX_PARENTCLIP}
  DCX_PARENTCLIP = $20;
  {$EXTERNALSYM DCX_EXCLUDERGN}
  DCX_EXCLUDERGN = $40;
  {$EXTERNALSYM DCX_INTERSECTRGN}
  DCX_INTERSECTRGN = $80;
  {$EXTERNALSYM DCX_EXCLUDEUPDATE}
  DCX_EXCLUDEUPDATE = $100;
  {$EXTERNALSYM DCX_INTERSECTUPDATE}
  DCX_INTERSECTUPDATE = $200;
  {$EXTERNALSYM DCX_LOCKWINDOWUPDATE}
  DCX_LOCKWINDOWUPDATE = $400;
  {$EXTERNALSYM DCX_VALIDATE}
  DCX_VALIDATE = $200000;

{$EXTERNALSYM GetWindowDC}
function GetWindowDC(hWnd: HWND): HDC; stdcall;
{$EXTERNALSYM ReleaseDC}
function ReleaseDC(hWnd: HWND; hDC: HDC): Integer; stdcall;
{$EXTERNALSYM BeginPaint}
function BeginPaint(hWnd: HWND; var lpPaint: TPaintStruct): HDC; stdcall;
{$EXTERNALSYM EndPaint}
function EndPaint(hWnd: HWND; const lpPaint: TPaintStruct): BOOL; stdcall;
{$EXTERNALSYM GetUpdateRect}
function GetUpdateRect(hWnd: HWND; var lpRect: TRect; bErase: BOOL): BOOL; stdcall; overload;
{$EXTERNALSYM GetUpdateRect}
function GetUpdateRect(hWnd: HWND; lpRect: PRect; bErase: BOOL): BOOL; stdcall; overload;
{$EXTERNALSYM GetUpdateRgn}
function GetUpdateRgn(hWnd: HWND; hRgn: HRGN; bErase: BOOL): Integer; stdcall;
{$EXTERNALSYM SetWindowRgn}
function SetWindowRgn(hWnd: HWND; hRgn: HRGN; bRedraw: BOOL): Integer; stdcall;
{$EXTERNALSYM GetWindowRgn}
function GetWindowRgn(hWnd: HWND; hRgn: HRGN): Integer; stdcall;
{$EXTERNALSYM ExcludeUpdateRgn}
function ExcludeUpdateRgn(hDC: HDC; hWnd: HWND): Integer; stdcall;
{$EXTERNALSYM InvalidateRect}
function InvalidateRect(hWnd: HWND; lpRect: PRect; bErase: BOOL): BOOL; stdcall;
{$EXTERNALSYM ValidateRect}
function ValidateRect(hWnd: HWND; lpRect: PRect): BOOL; stdcall;
{$EXTERNALSYM InvalidateRgn}
function InvalidateRgn(hWnd: HWND; hRgn: HRGN; bErase: BOOL): BOOL; stdcall;
{$EXTERNALSYM ValidateRgn}
function ValidateRgn(hWnd: HWND; hRgn: HRGN): BOOL; stdcall;
{$EXTERNALSYM RedrawWindow}
function RedrawWindow(hWnd: HWND; lprcUpdate: PRect; hrgnUpdate: HRGN; flags: UINT): BOOL; stdcall;

const
  { RedrawWindow() flags }
  {$EXTERNALSYM RDW_INVALIDATE}
  RDW_INVALIDATE = 1;
  {$EXTERNALSYM RDW_INTERNALPAINT}
  RDW_INTERNALPAINT = 2;
  {$EXTERNALSYM RDW_ERASE}
  RDW_ERASE = 4;
  {$EXTERNALSYM RDW_VALIDATE}
  RDW_VALIDATE = 8;
  {$EXTERNALSYM RDW_NOINTERNALPAINT}
  RDW_NOINTERNALPAINT = $10;
  {$EXTERNALSYM RDW_NOERASE}
  RDW_NOERASE = $20;
  {$EXTERNALSYM RDW_NOCHILDREN}
  RDW_NOCHILDREN = $40;
  {$EXTERNALSYM RDW_ALLCHILDREN}
  RDW_ALLCHILDREN = $80;
  {$EXTERNALSYM RDW_UPDATENOW}
  RDW_UPDATENOW = $100;
  {$EXTERNALSYM RDW_ERASENOW}
  RDW_ERASENOW = $200;
  {$EXTERNALSYM RDW_FRAME}
  RDW_FRAME = $400;
  {$EXTERNALSYM RDW_NOFRAME}
  RDW_NOFRAME = $800;


{ LockWindowUpdate API }

{$EXTERNALSYM LockWindowUpdate}
function LockWindowUpdate(hWndLock: HWND): BOOL; stdcall;
{$EXTERNALSYM ScrollWindow}
function ScrollWindow(hWnd: HWND; XAmount, YAmount: Integer;
  Rect, ClipRect: PRect): BOOL; stdcall;
{$EXTERNALSYM ScrollDC}
function ScrollDC(DC: HDC; DX, DY: Integer; var Scroll, Clip: TRect; Rgn: HRGN;
  Update: PRect): BOOL; stdcall;
{$EXTERNALSYM ScrollWindowEx}
function ScrollWindowEx(hWnd: HWND; dx, dy: Integer;
  prcScroll, prcClip: PRect;
  hrgnUpdate: HRGN; prcUpdate: PRect; flags: UINT): BOOL; stdcall;

const
  {$EXTERNALSYM SW_SCROLLCHILDREN}
  SW_SCROLLCHILDREN = 1;  { Scroll children within lprcScroll. }
  {$EXTERNALSYM SW_INVALIDATE}
  SW_INVALIDATE = 2;      { Invalidate after scrolling }
  {$EXTERNALSYM SW_ERASE}
  SW_ERASE = 4;           { If SW_INVALIDATE, don't send WM_ERASEBACKGROUND }
  {$EXTERNALSYM SW_SMOOTHSCROLL}
  SW_SMOOTHSCROLL = $10;   { Use smooth scrolling }

{$EXTERNALSYM SetScrollPos}
function SetScrollPos(hWnd: HWND; nBar, nPos: Integer; bRedraw: BOOL): Integer; stdcall;
{$EXTERNALSYM GetScrollPos}
function GetScrollPos(hWnd: HWND; nBar: Integer): Integer; stdcall;
{$EXTERNALSYM SetScrollRange}
function SetScrollRange(hWnd: HWND; nBar, nMinPos, nMaxPos: Integer; bRedraw: BOOL): BOOL; stdcall;
{$EXTERNALSYM GetScrollRange}
function GetScrollRange(hWnd: HWND; nBar: Integer; var lpMinPos, lpMaxPos: Integer): BOOL; stdcall;
{$EXTERNALSYM ShowScrollBar}
function ShowScrollBar(hWnd: HWND; wBar: Integer; bShow: BOOL): BOOL; stdcall;
{$EXTERNALSYM EnableScrollBar}
function EnableScrollBar(hWnd: HWND; wSBflags, wArrows: UINT): BOOL; stdcall;


const
  { EnableScrollBar() flags }
  {$EXTERNALSYM ESB_ENABLE_BOTH}
  ESB_ENABLE_BOTH = 0;
  {$EXTERNALSYM ESB_DISABLE_BOTH}
  ESB_DISABLE_BOTH = 3;
  {$EXTERNALSYM ESB_DISABLE_LEFT}
  ESB_DISABLE_LEFT = 1;
  {$EXTERNALSYM ESB_DISABLE_RIGHT}
  ESB_DISABLE_RIGHT = 2;
  {$EXTERNALSYM ESB_DISABLE_UP}
  ESB_DISABLE_UP = 1;
  {$EXTERNALSYM ESB_DISABLE_DOWN}
  ESB_DISABLE_DOWN = 2;
  {$EXTERNALSYM ESB_DISABLE_LTUP}
  ESB_DISABLE_LTUP = ESB_DISABLE_LEFT;
  {$EXTERNALSYM ESB_DISABLE_RTDN}
  ESB_DISABLE_RTDN = ESB_DISABLE_RIGHT;

{$EXTERNALSYM SetProp}
function SetProp(hWnd: HWND; lpString: PChar; hData: THandle): BOOL; stdcall;
{$EXTERNALSYM SetPropA}
function SetPropA(hWnd: HWND; lpString: PAnsiChar; hData: THandle): BOOL; stdcall;
{$EXTERNALSYM SetPropW}
function SetPropW(hWnd: HWND; lpString: PWideChar; hData: THandle): BOOL; stdcall;
{$EXTERNALSYM GetProp}
function GetProp(hWnd: HWND; lpString: PChar): THandle; stdcall;
{$EXTERNALSYM GetPropA}
function GetPropA(hWnd: HWND; lpString: PAnsiChar): THandle; stdcall;
{$EXTERNALSYM GetPropW}
function GetPropW(hWnd: HWND; lpString: PWideChar): THandle; stdcall;
{$EXTERNALSYM RemoveProp}
function RemoveProp(hWnd: HWND; lpString: PChar): THandle; stdcall;
{$EXTERNALSYM RemovePropA}
function RemovePropA(hWnd: HWND; lpString: PAnsiChar): THandle; stdcall;
{$EXTERNALSYM RemovePropW}
function RemovePropW(hWnd: HWND; lpString: PWideChar): THandle; stdcall;
{$EXTERNALSYM EnumPropsEx}
function EnumPropsEx(hWnd: HWND; lpEnumFunc: TFNPropEnumProcEx; lParam: LPARAM): Integer; stdcall;
{$EXTERNALSYM EnumPropsExA}
function EnumPropsExA(hWnd: HWND; lpEnumFunc: TFNPropEnumProcEx; lParam: LPARAM): Integer; stdcall;
{$EXTERNALSYM EnumPropsExW}
function EnumPropsExW(hWnd: HWND; lpEnumFunc: TFNPropEnumProcEx; lParam: LPARAM): Integer; stdcall;
{$EXTERNALSYM EnumProps}
function EnumProps(hWnd: HWND; lpEnumFunc: TFNPropEnumProc): Integer; stdcall;
{$EXTERNALSYM EnumPropsA}
function EnumPropsA(hWnd: HWND; lpEnumFunc: TFNPropEnumProc): Integer; stdcall;
{$EXTERNALSYM EnumPropsW}
function EnumPropsW(hWnd: HWND; lpEnumFunc: TFNPropEnumProc): Integer; stdcall;
{$EXTERNALSYM SetWindowText}
function SetWindowText(hWnd: HWND; lpString: PChar): BOOL; stdcall;
{$EXTERNALSYM SetWindowTextA}
function SetWindowTextA(hWnd: HWND; lpString: PAnsiChar): BOOL; stdcall;
{$EXTERNALSYM SetWindowTextW}
function SetWindowTextW(hWnd: HWND; lpString: PWideChar): BOOL; stdcall;
{$EXTERNALSYM GetWindowText}
function GetWindowText(hWnd: HWND; lpString: PChar; nMaxCount: Integer): Integer; stdcall;
{$EXTERNALSYM GetWindowTextA}
function GetWindowTextA(hWnd: HWND; lpString: PAnsiChar; nMaxCount: Integer): Integer; stdcall;
{$EXTERNALSYM GetWindowTextW}
function GetWindowTextW(hWnd: HWND; lpString: PWideChar; nMaxCount: Integer): Integer; stdcall;
{$EXTERNALSYM GetWindowTextLength}
function GetWindowTextLength(hWnd: HWND): Integer; stdcall;
{$EXTERNALSYM GetWindowTextLengthA}
function GetWindowTextLengthA(hWnd: HWND): Integer; stdcall;
{$EXTERNALSYM GetWindowTextLengthW}
function GetWindowTextLengthW(hWnd: HWND): Integer; stdcall;

{$EXTERNALSYM GetClientRect}
function GetClientRect(hWnd: HWND; var lpRect: TRect): BOOL; stdcall;
{$EXTERNALSYM GetWindowRect}
function GetWindowRect(hWnd: HWND; var lpRect: TRect): BOOL; stdcall;
{$EXTERNALSYM AdjustWindowRect}
function AdjustWindowRect(var lpRect: TRect; dwStyle: DWORD; bMenu: BOOL): BOOL; stdcall;
{$EXTERNALSYM AdjustWindowRectEx}
function AdjustWindowRectEx(var lpRect: TRect; dwStyle: DWORD; bMenu: BOOL;
  dwExStyle: DWORD): BOOL; stdcall;

const
  {$EXTERNALSYM HELPINFO_WINDOW}
  HELPINFO_WINDOW = 1;
  {$EXTERNALSYM HELPINFO_MENUITEM}
  HELPINFO_MENUITEM = 2;
type
  PHelpInfo = ^THelpInfo;
  {$EXTERNALSYM tagHELPINFO}
  tagHELPINFO = packed record       { Structure pointed to by lParam of WM_HELP }
    cbSize: UINT;          { Size in bytes of this struct  }
    iContextType: Integer; { Either HELPINFO_WINDOW or HELPINFO_MENUITEM }
    iCtrlId: Integer;      { Control Id or a Menu item Id. }
    hItemHandle: THandle;  { hWnd of control or hMenu.     }
    dwContextId: DWORD;    { Context Id associated with this item }
    MousePos: TPoint;      { Mouse Position in screen co-ordinates }
  end;
  THelpInfo = tagHELPINFO;
  {$EXTERNALSYM HELPINFO}
  HELPINFO = tagHELPINFO;

{$EXTERNALSYM SetWindowContextHelpId}
function SetWindowContextHelpId(hWnd: HWND; HelpID: DWORD): BOOL; stdcall;
{$EXTERNALSYM GetWindowContextHelpId}
function GetWindowContextHelpId(hWnd: HWND): DWORD; stdcall;
{$EXTERNALSYM SetMenuContextHelpId}
function SetMenuContextHelpId(hMenu: HMENU; HelpID: DWORD): BOOL; stdcall;
{$EXTERNALSYM GetMenuContextHelpId}
function GetMenuContextHelpId(hMenu: HMENU): DWORD; stdcall;

const
  { MessageBox() Flags }
  {$EXTERNALSYM MB_OK}
  MB_OK = $00000000;
  {$EXTERNALSYM MB_OKCANCEL}
  MB_OKCANCEL = $00000001;
  {$EXTERNALSYM MB_ABORTRETRYIGNORE}
  MB_ABORTRETRYIGNORE = $00000002;
  {$EXTERNALSYM MB_YESNOCANCEL}
  MB_YESNOCANCEL = $00000003;
  {$EXTERNALSYM MB_YESNO}
  MB_YESNO = $00000004;
  {$EXTERNALSYM MB_RETRYCANCEL}
  MB_RETRYCANCEL = $00000005;

  {$EXTERNALSYM MB_ICONHAND}
  MB_ICONHAND = $00000010;
  {$EXTERNALSYM MB_ICONQUESTION}
  MB_ICONQUESTION = $00000020;
  {$EXTERNALSYM MB_ICONEXCLAMATION}
  MB_ICONEXCLAMATION = $00000030;
  {$EXTERNALSYM MB_ICONASTERISK}
  MB_ICONASTERISK = $00000040;
  {$EXTERNALSYM MB_USERICON}
  MB_USERICON = $00000080;
  {$EXTERNALSYM MB_ICONWARNING}
  MB_ICONWARNING                 = MB_ICONEXCLAMATION;
  {$EXTERNALSYM MB_ICONERROR}
  MB_ICONERROR                   = MB_ICONHAND;
  {$EXTERNALSYM MB_ICONINFORMATION}
  MB_ICONINFORMATION             = MB_ICONASTERISK;
  {$EXTERNALSYM MB_ICONSTOP}
  MB_ICONSTOP                    = MB_ICONHAND;

  {$EXTERNALSYM MB_DEFBUTTON1}
  MB_DEFBUTTON1 = $00000000;
  {$EXTERNALSYM MB_DEFBUTTON2}
  MB_DEFBUTTON2 = $00000100;
  {$EXTERNALSYM MB_DEFBUTTON3}
  MB_DEFBUTTON3 = $00000200;
  {$EXTERNALSYM MB_DEFBUTTON4}
  MB_DEFBUTTON4 = $00000300;

  {$EXTERNALSYM MB_APPLMODAL}
  MB_APPLMODAL = $00000000;
  {$EXTERNALSYM MB_SYSTEMMODAL}
  MB_SYSTEMMODAL = $00001000;
  {$EXTERNALSYM MB_TASKMODAL}
  MB_TASKMODAL = $00002000;
  {$EXTERNALSYM MB_HELP}
  MB_HELP = $00004000;                          { Help Button }

  {$EXTERNALSYM MB_NOFOCUS}
  MB_NOFOCUS = $00008000;
  {$EXTERNALSYM MB_SETFOREGROUND}
  MB_SETFOREGROUND = $00010000;
  {$EXTERNALSYM MB_DEFAULT_DESKTOP_ONLY}
  MB_DEFAULT_DESKTOP_ONLY = $00020000;

  {$EXTERNALSYM MB_TOPMOST}
  MB_TOPMOST = $00040000;
  {$EXTERNALSYM MB_RIGHT}
  MB_RIGHT = $00080000;
  {$EXTERNALSYM MB_RTLREADING}
  MB_RTLREADING = $00100000;

  {$EXTERNALSYM MB_SERVICE_NOTIFICATION}
  MB_SERVICE_NOTIFICATION = $00200000;
  {$EXTERNALSYM MB_SERVICE_NOTIFICATION_NT3X}
  MB_SERVICE_NOTIFICATION_NT3X = $00040000;

  {$EXTERNALSYM MB_TYPEMASK}
  MB_TYPEMASK = $0000000F;
  {$EXTERNALSYM MB_ICONMASK}
  MB_ICONMASK = $000000F0;
  {$EXTERNALSYM MB_DEFMASK}
  MB_DEFMASK = $00000F00;
  {$EXTERNALSYM MB_MODEMASK}
  MB_MODEMASK = $00003000;
  {$EXTERNALSYM MB_MISCMASK}
  MB_MISCMASK = $0000C000;


{$EXTERNALSYM MessageBox}
function MessageBox(hWnd: HWND; lpText, lpCaption: PChar; uType: UINT): Integer; stdcall;
{$EXTERNALSYM MessageBoxA}
function MessageBoxA(hWnd: HWND; lpText, lpCaption: PAnsiChar; uType: UINT): Integer; stdcall;
{$EXTERNALSYM MessageBoxW}
function MessageBoxW(hWnd: HWND; lpText, lpCaption: PWideChar; uType: UINT): Integer; stdcall;
{$EXTERNALSYM MessageBoxEx}
function MessageBoxEx(hWnd: HWND; lpText, lpCaption: PChar;
  uType: UINT; wLanguageId: Word): Integer; stdcall;
{$EXTERNALSYM MessageBoxExA}
function MessageBoxExA(hWnd: HWND; lpText, lpCaption: PAnsiChar;
  uType: UINT; wLanguageId: Word): Integer; stdcall;
{$EXTERNALSYM MessageBoxExW}
function MessageBoxExW(hWnd: HWND; lpText, lpCaption: PWideChar;
  uType: UINT; wLanguageId: Word): Integer; stdcall;

type
  TPRMsgBoxCallback = procedure(var lpHelpInfo: THelpInfo);

  PMsgBoxParamsA = ^TMsgBoxParamsA;
  PMsgBoxParamsW = ^TMsgBoxParamsW;
  PMsgBoxParams = PMsgBoxParamsA;
  {$EXTERNALSYM tagMSGBOXPARAMSA}
  tagMSGBOXPARAMSA = packed record
    cbSize: UINT;
    hwndOwner: HWND;
    hInstance: HINST;
    lpszText: PAnsiChar;
    lpszCaption: PAnsiChar;
    dwStyle: DWORD;
    lpszIcon: PAnsiChar;
    dwContextHelpId: DWORD;
    lpfnMsgBoxCallback: TPRMsgBoxCallback;
    dwLanguageId: DWORD;
  end;
  {$EXTERNALSYM tagMSGBOXPARAMSW}
  tagMSGBOXPARAMSW = packed record
    cbSize: UINT;
    hwndOwner: HWND;
    hInstance: HINST;
    lpszText: PWideChar;
    lpszCaption: PWideChar;
    dwStyle: DWORD;
    lpszIcon: PWideChar;
    dwContextHelpId: DWORD;
    lpfnMsgBoxCallback: TPRMsgBoxCallback;
    dwLanguageId: DWORD;
  end;
  {$EXTERNALSYM tagMSGBOXPARAMS}
  tagMSGBOXPARAMS = tagMSGBOXPARAMSA;
  TMsgBoxParamsA = tagMSGBOXPARAMSA;
  TMsgBoxParamsW = tagMSGBOXPARAMSW;
  TMsgBoxParams = TMsgBoxParamsA;
  {$EXTERNALSYM MSGBOXPARAMSA}
  MSGBOXPARAMSA = tagMSGBOXPARAMSA;
  {$EXTERNALSYM MSGBOXPARAMSW}
  MSGBOXPARAMSW = tagMSGBOXPARAMSW;
  {$EXTERNALSYM MSGBOXPARAMS}
  MSGBOXPARAMS = MSGBOXPARAMSA;

{$EXTERNALSYM MessageBoxIndirect}
function MessageBoxIndirect(const MsgBoxParams: TMsgBoxParams): BOOL; stdcall;
{$EXTERNALSYM MessageBoxIndirectA}
function MessageBoxIndirectA(const MsgBoxParams: TMsgBoxParamsA): BOOL; stdcall;
{$EXTERNALSYM MessageBoxIndirectW}
function MessageBoxIndirectW(const MsgBoxParams: TMsgBoxParamsW): BOOL; stdcall;

{$EXTERNALSYM MessageBeep}
function MessageBeep(uType: UINT): BOOL; stdcall;
{$EXTERNALSYM ShowCursor}
function ShowCursor(bShow: BOOL): Integer; stdcall;
{$EXTERNALSYM SetCursorPos}
function SetCursorPos(X, Y: Integer): BOOL; stdcall;
{$EXTERNALSYM SetCursor}
function SetCursor(hCursor: HICON): HCURSOR; stdcall;
{$EXTERNALSYM GetCursorPos}
function GetCursorPos(var lpPoint: TPoint): BOOL; stdcall;
{$EXTERNALSYM ClipCursor}
function ClipCursor(lpRect: PRect): BOOL; stdcall;
{$EXTERNALSYM GetClipCursor}
function GetClipCursor(var lpRect: TRect): BOOL; stdcall;
{$EXTERNALSYM GetCursor}
function GetCursor: HCURSOR; stdcall;
{$EXTERNALSYM CreateCaret}
function CreateCaret(hWnd: HWND; hBitmap: HBITMAP; nWidth, nHeight: Integer): BOOL; stdcall;
{$EXTERNALSYM GetCaretBlinkTime}
function GetCaretBlinkTime: UINT; stdcall;
{$EXTERNALSYM SetCaretBlinkTime}
function SetCaretBlinkTime(uMSeconds: UINT): BOOL; stdcall;
{$EXTERNALSYM DestroyCaret}
function DestroyCaret: BOOL; stdcall;
{$EXTERNALSYM HideCaret}
function HideCaret(hWnd: HWND): BOOL; stdcall;
{$EXTERNALSYM ShowCaret}
function ShowCaret(hWnd: HWND): BOOL; stdcall;
{$EXTERNALSYM SetCaretPos}
function SetCaretPos(X, Y: Integer): BOOL; stdcall;
{$EXTERNALSYM GetCaretPos}
function GetCaretPos(var lpPoint: TPoint): BOOL; stdcall;
{$EXTERNALSYM ClientToScreen}
function ClientToScreen(hWnd: HWND; var lpPoint: TPoint): BOOL; stdcall;
{$EXTERNALSYM ScreenToClient}
function ScreenToClient(hWnd: HWND; var lpPoint: TPoint): BOOL; stdcall;
{$EXTERNALSYM MapWindowPoints}
function MapWindowPoints(hWndFrom, hWndTo: HWND; var lpPoints; cPoints: UINT): Integer; stdcall;
{$EXTERNALSYM WindowFromPoint}
function WindowFromPoint(Point: TPoint): HWND; stdcall;
{$EXTERNALSYM ChildWindowFromPoint}
function ChildWindowFromPoint(hWndParent: HWND; Point: TPoint): HWND; stdcall;

const
  {$EXTERNALSYM CWP_ALL}
  CWP_ALL = 0;
  {$EXTERNALSYM CWP_SKIPINVISIBLE}
  CWP_SKIPINVISIBLE = 1;
  {$EXTERNALSYM CWP_SKIPDISABLED}
  CWP_SKIPDISABLED = 2;
  {$EXTERNALSYM CWP_SKIPTRANSPARENT}
  CWP_SKIPTRANSPARENT = 4;

{$EXTERNALSYM ChildWindowFromPointEx}
function ChildWindowFromPointEx(hWnd: HWND; Point: TPoint; Flags: UINT): HWND; stdcall;

const
  { Color Types }
  {$EXTERNALSYM CTLCOLOR_MSGBOX}
  CTLCOLOR_MSGBOX = 0;
  {$EXTERNALSYM CTLCOLOR_EDIT}
  CTLCOLOR_EDIT = 1;
  {$EXTERNALSYM CTLCOLOR_LISTBOX}
  CTLCOLOR_LISTBOX = 2;
  {$EXTERNALSYM CTLCOLOR_BTN}
  CTLCOLOR_BTN = 3;
  {$EXTERNALSYM CTLCOLOR_DLG}
  CTLCOLOR_DLG = 4;
  {$EXTERNALSYM CTLCOLOR_SCROLLBAR}
  CTLCOLOR_SCROLLBAR = 5;
  {$EXTERNALSYM CTLCOLOR_STATIC}
  CTLCOLOR_STATIC = 6;
  {$EXTERNALSYM CTLCOLOR_MAX}
  CTLCOLOR_MAX = 7;

  {$EXTERNALSYM COLOR_SCROLLBAR}
  COLOR_SCROLLBAR = 0;
  {$EXTERNALSYM COLOR_BACKGROUND}
  COLOR_BACKGROUND = 1;
  {$EXTERNALSYM COLOR_ACTIVECAPTION}
  COLOR_ACTIVECAPTION = 2;
  {$EXTERNALSYM COLOR_INACTIVECAPTION}
  COLOR_INACTIVECAPTION = 3;
  {$EXTERNALSYM COLOR_MENU}
  COLOR_MENU = 4;
  {$EXTERNALSYM COLOR_WINDOW}
  COLOR_WINDOW = 5;
  {$EXTERNALSYM COLOR_WINDOWFRAME}
  COLOR_WINDOWFRAME = 6;
  {$EXTERNALSYM COLOR_MENUTEXT}
  COLOR_MENUTEXT = 7;
  {$EXTERNALSYM COLOR_WINDOWTEXT}
  COLOR_WINDOWTEXT = 8;
  {$EXTERNALSYM COLOR_CAPTIONTEXT}
  COLOR_CAPTIONTEXT = 9;
  {$EXTERNALSYM COLOR_ACTIVEBORDER}
  COLOR_ACTIVEBORDER = 10;
  {$EXTERNALSYM COLOR_INACTIVEBORDER}
  COLOR_INACTIVEBORDER = 11;
  {$EXTERNALSYM COLOR_APPWORKSPACE}
  COLOR_APPWORKSPACE = 12;
  {$EXTERNALSYM COLOR_HIGHLIGHT}
  COLOR_HIGHLIGHT = 13;
  {$EXTERNALSYM COLOR_HIGHLIGHTTEXT}
  COLOR_HIGHLIGHTTEXT = 14;
  {$EXTERNALSYM COLOR_BTNFACE}
  COLOR_BTNFACE = 15;
  {$EXTERNALSYM COLOR_BTNSHADOW}
  COLOR_BTNSHADOW = $10;
  {$EXTERNALSYM COLOR_GRAYTEXT}
  COLOR_GRAYTEXT = 17;
  {$EXTERNALSYM COLOR_BTNTEXT}
  COLOR_BTNTEXT = 18;
  {$EXTERNALSYM COLOR_INACTIVECAPTIONTEXT}
  COLOR_INACTIVECAPTIONTEXT = 19;
  {$EXTERNALSYM COLOR_BTNHIGHLIGHT}
  COLOR_BTNHIGHLIGHT = 20;

  {$EXTERNALSYM COLOR_3DDKSHADOW}
  COLOR_3DDKSHADOW = 21;
  {$EXTERNALSYM COLOR_3DLIGHT}
  COLOR_3DLIGHT = 22;
  {$EXTERNALSYM COLOR_INFOTEXT}
  COLOR_INFOTEXT = 23;
  {$EXTERNALSYM COLOR_INFOBK}
  COLOR_INFOBK = 24;

  {$EXTERNALSYM COLOR_HOTLIGHT}
  COLOR_HOTLIGHT = 26;
  {$EXTERNALSYM COLOR_GRADIENTACTIVECAPTION}
  COLOR_GRADIENTACTIVECAPTION = 27;
  {$EXTERNALSYM COLOR_GRADIENTINACTIVECAPTION}
  COLOR_GRADIENTINACTIVECAPTION = 28;

  {$EXTERNALSYM COLOR_MENUHILIGHT}
  COLOR_MENUHILIGHT = 29;
  {$EXTERNALSYM COLOR_MENUBAR}
  COLOR_MENUBAR = 30;

  COLOR_ENDCOLORS = COLOR_MENUBAR;

  {$EXTERNALSYM COLOR_DESKTOP}
  COLOR_DESKTOP = COLOR_BACKGROUND;
  {$EXTERNALSYM COLOR_3DFACE}
  COLOR_3DFACE = COLOR_BTNFACE;
  {$EXTERNALSYM COLOR_3DSHADOW}
  COLOR_3DSHADOW = COLOR_BTNSHADOW;
  {$EXTERNALSYM COLOR_3DHIGHLIGHT}
  COLOR_3DHIGHLIGHT = COLOR_BTNHIGHLIGHT;
  {$EXTERNALSYM COLOR_3DHILIGHT}
  COLOR_3DHILIGHT = COLOR_BTNHIGHLIGHT;
  {$EXTERNALSYM COLOR_BTNHILIGHT}
  COLOR_BTNHILIGHT = COLOR_BTNHIGHLIGHT;

{$EXTERNALSYM GetSysColor}
function GetSysColor(nIndex: Integer): DWORD; stdcall;
{$EXTERNALSYM GetSysColorBrush}
function GetSysColorBrush(nIndex: Integer): HBRUSH; stdcall;
{$EXTERNALSYM SetSysColors}
function SetSysColors(cElements: Integer; const lpaElements;
  const lpaRgbValues): BOOL; stdcall;
{$EXTERNALSYM DrawFocusRect}
function DrawFocusRect(hDC: HDC; const lprc: TRect): BOOL; stdcall;
{$EXTERNALSYM FillRect}
function FillRect(hDC: HDC; const lprc: TRect; hbr: HBRUSH): Integer; stdcall;
{$EXTERNALSYM FrameRect}
function FrameRect(hDC: HDC; const lprc: TRect; hbr: HBRUSH): Integer; stdcall;
{$EXTERNALSYM InvertRect}
function InvertRect(hDC: HDC; const lprc: TRect): BOOL; stdcall;
{$EXTERNALSYM SetRect}
function SetRect(var lprc: TRect; xLeft, yTop, xRight, yBottom: Integer): BOOL; stdcall;
{$EXTERNALSYM SetRectEmpty}
function SetRectEmpty(var lprc: TRect): BOOL; stdcall;
{$EXTERNALSYM CopyRect}
function CopyRect(var lprcDst: TRect; const lprcSrc: TRect): BOOL; stdcall;
{$EXTERNALSYM InflateRect}
function InflateRect(var lprc: TRect; dx, dy: Integer): BOOL; stdcall;
{$EXTERNALSYM IntersectRect}
function IntersectRect(var lprcDst: TRect; const lprcSrc1, lprcSrc2: TRect): BOOL; stdcall;
{$EXTERNALSYM UnionRect}
function UnionRect(var lprcDst: TRect; const lprcSrc1, lprcSrc2: TRect): BOOL; stdcall;
{$EXTERNALSYM SubtractRect}
function SubtractRect(var lprcDst: TRect; const lprcSrc1, lprcSrc2: TRect): BOOL; stdcall;
{$EXTERNALSYM OffsetRect}
function OffsetRect(var lprc: TRect; dx, dy: Integer): BOOL; stdcall;
{$EXTERNALSYM IsRectEmpty}
function IsRectEmpty(const lprc: TRect): BOOL; stdcall;
{$EXTERNALSYM EqualRect}
function EqualRect(const lprc1, lprc2: TRect): BOOL; stdcall;
{$EXTERNALSYM PtInRect}
function PtInRect(const lprc: TRect; pt: TPoint): BOOL; stdcall;
{$EXTERNALSYM GetWindowWord}
function GetWindowWord(hWnd: HWND; nIndex: Integer): Word; stdcall;
{$EXTERNALSYM SetWindowWord}
function SetWindowWord(hWnd: HWND; nIndex: Integer; wNewWord: Word): Word; stdcall;
{$EXTERNALSYM GetWindowLong}
function GetWindowLong(hWnd: HWND; nIndex: Integer): Longint; stdcall;
{$EXTERNALSYM GetWindowLongA}
function GetWindowLongA(hWnd: HWND; nIndex: Integer): Longint; stdcall;
{$EXTERNALSYM GetWindowLongW}
function GetWindowLongW(hWnd: HWND; nIndex: Integer): Longint; stdcall;
{$EXTERNALSYM SetWindowLong}
function SetWindowLong(hWnd: HWND; nIndex: Integer; dwNewLong: Longint): Longint; stdcall;
{$EXTERNALSYM SetWindowLongA}
function SetWindowLongA(hWnd: HWND; nIndex: Integer; dwNewLong: Longint): Longint; stdcall;
{$EXTERNALSYM SetWindowLongW}
function SetWindowLongW(hWnd: HWND; nIndex: Integer; dwNewLong: Longint): Longint; stdcall;
{$EXTERNALSYM GetClassWord}
function GetClassWord(hWnd: HWND; nIndex: Integer): Word; stdcall;
{$EXTERNALSYM SetClassWord}
function SetClassWord(hWnd: HWND; nIndex: Integer; wNewWord: Word): Word; stdcall;
{$EXTERNALSYM GetClassLong}
function GetClassLong(hWnd: HWND; nIndex: Integer): DWORD; stdcall;
{$EXTERNALSYM GetClassLongA}
function GetClassLongA(hWnd: HWND; nIndex: Integer): DWORD; stdcall;
{$EXTERNALSYM GetClassLongW}
function GetClassLongW(hWnd: HWND; nIndex: Integer): DWORD; stdcall;
{$EXTERNALSYM SetClassLong}
function SetClassLong(hWnd: HWND; nIndex: Integer; dwNewLong: Longint): DWORD; stdcall;
{$EXTERNALSYM SetClassLongA}
function SetClassLongA(hWnd: HWND; nIndex: Integer; dwNewLong: Longint): DWORD; stdcall;
{$EXTERNALSYM SetClassLongW}
function SetClassLongW(hWnd: HWND; nIndex: Integer; dwNewLong: Longint): DWORD; stdcall;
{$EXTERNALSYM GetDesktopWindow}
function GetDesktopWindow: HWND; stdcall;
{$EXTERNALSYM GetParent}
function GetParent(hWnd: HWND): HWND; stdcall;
{$EXTERNALSYM SetParent}
function SetParent(hWndChild, hWndNewParent: HWND): HWND; stdcall;
{$EXTERNALSYM EnumChildWindows}
function EnumChildWindows(hWndParent: HWND; lpEnumFunc: TFNWndEnumProc;
  lParam: LPARAM): BOOL; stdcall;
{$EXTERNALSYM FindWindow}
function FindWindow(lpClassName, lpWindowName: PChar): HWND; stdcall;
{$EXTERNALSYM FindWindowA}
function FindWindowA(lpClassName, lpWindowName: PAnsiChar): HWND; stdcall;
{$EXTERNALSYM FindWindowW}
function FindWindowW(lpClassName, lpWindowName: PWideChar): HWND; stdcall;
{$EXTERNALSYM FindWindowEx}
function FindWindowEx(Parent, Child: HWND; ClassName, WindowName: PChar): HWND; stdcall;
{$EXTERNALSYM FindWindowExA}
function FindWindowExA(Parent, Child: HWND; ClassName, WindowName: PAnsiChar): HWND; stdcall;
{$EXTERNALSYM FindWindowExW}
function FindWindowExW(Parent, Child: HWND; ClassName, WindowName: PWideChar): HWND; stdcall;
{$EXTERNALSYM EnumWindows}
function EnumWindows(lpEnumFunc: TFNWndEnumProc; lParam: LPARAM): BOOL; stdcall;
{$EXTERNALSYM EnumThreadWindows}
function EnumThreadWindows(dwThreadId: DWORD; lpfn: TFNWndEnumProc; lParam: LPARAM): BOOL; stdcall;
{$EXTERNALSYM EnumTaskWindows}
function EnumTaskWindows(hTask: THandle; lpfn: FARPROC; lParam: LPARAM): BOOL;
{$EXTERNALSYM GetClassName}
function GetClassName(hWnd: HWND; lpClassName: PChar; nMaxCount: Integer): Integer; stdcall;
{$EXTERNALSYM GetClassNameA}
function GetClassNameA(hWnd: HWND; lpClassName: PAnsiChar; nMaxCount: Integer): Integer; stdcall;
{$EXTERNALSYM GetClassNameW}
function GetClassNameW(hWnd: HWND; lpClassName: PWideChar; nMaxCount: Integer): Integer; stdcall;
function GetTopWindow(hWnd: HWND): HWND; stdcall;
{$EXTERNALSYM GetTopWindow}
function GetNextWindow(hWnd: HWND; uCmd: UINT): HWND; stdcall;
{$EXTERNALSYM GetNextWindow}
function GetWindowThreadProcessId(hWnd: HWND; lpdwProcessId: Pointer = nil): DWORD; stdcall; overload;
{$EXTERNALSYM GetWindowThreadProcessId}
function GetWindowThreadProcessId(hWnd: HWND; var dwProcessId: DWORD): DWORD; stdcall; overload;
function GetWindowTask(hWnd: HWND): THandle; inline;
{$EXTERNALSYM GetWindowTask}
function GetLastActivePopup(hWnd: HWND): HWND; stdcall;
{$EXTERNALSYM GetLastActivePopup}

const
  { GetWindow() Constants }
  {$EXTERNALSYM GW_HWNDFIRST}
  GW_HWNDFIRST = 0;
  {$EXTERNALSYM GW_HWNDLAST}
  GW_HWNDLAST = 1;
  {$EXTERNALSYM GW_HWNDNEXT}
  GW_HWNDNEXT = 2;
  {$EXTERNALSYM GW_HWNDPREV}
  GW_HWNDPREV = 3;
  {$EXTERNALSYM GW_OWNER}
  GW_OWNER = 4;
  {$EXTERNALSYM GW_CHILD}
  GW_CHILD = 5;
  {$EXTERNALSYM GW_MAX}
  GW_MAX = 5;

{$EXTERNALSYM GetWindow}
function GetWindow(hWnd: HWND; uCmd: UINT): HWND; stdcall;
{$EXTERNALSYM SetWindowsHook}
function SetWindowsHook(nFilterType: Integer; pfnFilterProc: TFNHookProc): HHOOK; stdcall;
{$EXTERNALSYM SetWindowsHookA}
function SetWindowsHookA(nFilterType: Integer; pfnFilterProc: TFNHookProc): HHOOK; stdcall;
{$EXTERNALSYM SetWindowsHookW}
function SetWindowsHookW(nFilterType: Integer; pfnFilterProc: TFNHookProc): HHOOK; stdcall;
{$EXTERNALSYM SetWindowsHookEx}
function SetWindowsHookEx(idHook: Integer; lpfn: TFNHookProc; hmod: HINST; dwThreadId: DWORD): HHOOK; stdcall;
{$EXTERNALSYM SetWindowsHookExA}
function SetWindowsHookExA(idHook: Integer; lpfn: TFNHookProc; hmod: HINST; dwThreadId: DWORD): HHOOK; stdcall;
{$EXTERNALSYM SetWindowsHookExW}
function SetWindowsHookExW(idHook: Integer; lpfn: TFNHookProc; hmod: HINST; dwThreadId: DWORD): HHOOK; stdcall;
{$EXTERNALSYM UnhookWindowsHook}
function UnhookWindowsHook(nCode: Integer; pfnFilterProc: TFNHookProc): BOOL; stdcall;
{$EXTERNALSYM UnhookWindowsHookEx}
function UnhookWindowsHookEx(hhk: HHOOK): BOOL; stdcall;
{$EXTERNALSYM CallNextHookEx}
function CallNextHookEx(hhk: HHOOK; nCode: Integer; wParam: WPARAM; lParam: LPARAM): LRESULT; stdcall;

{ Macros for source-level compatibility with old functions. }

{$EXTERNALSYM DefHookProc}
function DefHookProc(nCode: Integer; wParam: WPARAM; lParam: LPARAM; phhk: FARPROC): LRESULT;

const
{ Menu flags for AddCheckEnableMenuItem() }

  {$EXTERNALSYM MF_INSERT}
  MF_INSERT = 0;
  {$EXTERNALSYM MF_CHANGE}
  MF_CHANGE = $80;
  {$EXTERNALSYM MF_APPEND}
  MF_APPEND = $100;
  {$EXTERNALSYM MF_DELETE}
  MF_DELETE = $200;
  {$EXTERNALSYM MF_REMOVE}
  MF_REMOVE = $1000;

  {$EXTERNALSYM MF_BYCOMMAND}
  MF_BYCOMMAND = 0;
  {$EXTERNALSYM MF_BYPOSITION}
  MF_BYPOSITION = $400;

  {$EXTERNALSYM MF_SEPARATOR}
  MF_SEPARATOR = $800;

  {$EXTERNALSYM MF_ENABLED}
  MF_ENABLED = 0;
  {$EXTERNALSYM MF_GRAYED}
  MF_GRAYED = 1;
  {$EXTERNALSYM MF_DISABLED}
  MF_DISABLED = 2;

  {$EXTERNALSYM MF_UNCHECKED}
  MF_UNCHECKED = 0;
  {$EXTERNALSYM MF_CHECKED}
  MF_CHECKED = 8;
  {$EXTERNALSYM MF_USECHECKBITMAPS}
  MF_USECHECKBITMAPS = $200;

  {$EXTERNALSYM MF_STRING}
  MF_STRING = 0;
  {$EXTERNALSYM MF_BITMAP}
  MF_BITMAP = 4;
  {$EXTERNALSYM MF_OWNERDRAW}
  MF_OWNERDRAW = $100;

  {$EXTERNALSYM MF_POPUP}
  MF_POPUP = $10;
  {$EXTERNALSYM MF_MENUBARBREAK}
  MF_MENUBARBREAK = $20;
  {$EXTERNALSYM MF_MENUBREAK}
  MF_MENUBREAK = $40;

  {$EXTERNALSYM MF_UNHILITE}
  MF_UNHILITE = 0;
  {$EXTERNALSYM MF_HILITE}
  MF_HILITE = $80;

  {$EXTERNALSYM MF_DEFAULT}
  MF_DEFAULT = $1000;
  {$EXTERNALSYM MF_SYSMENU}
  MF_SYSMENU = $2000;
  {$EXTERNALSYM MF_HELP}
  MF_HELP = $4000;
  {$EXTERNALSYM MF_RIGHTJUSTIFY}
  MF_RIGHTJUSTIFY = $4000;

  {$EXTERNALSYM MF_MOUSESELECT}
  MF_MOUSESELECT = $8000;
  {$EXTERNALSYM MF_END}
  MF_END = $80;            { Obsolete -- only used by old RES files }

  {$EXTERNALSYM MFT_STRING}
  MFT_STRING = MF_STRING;
  {$EXTERNALSYM MFT_BITMAP}
  MFT_BITMAP = MF_BITMAP;
  {$EXTERNALSYM MFT_MENUBARBREAK}
  MFT_MENUBARBREAK = MF_MENUBARBREAK;
  {$EXTERNALSYM MFT_MENUBREAK}
  MFT_MENUBREAK = MF_MENUBREAK;
  {$EXTERNALSYM MFT_OWNERDRAW}
  MFT_OWNERDRAW = MF_OWNERDRAW;
  {$EXTERNALSYM MFT_RADIOCHECK}
  MFT_RADIOCHECK = $200;
  {$EXTERNALSYM MFT_SEPARATOR}
  MFT_SEPARATOR = MF_SEPARATOR;
  {$EXTERNALSYM MFT_RIGHTORDER}
  MFT_RIGHTORDER = $2000;
  {$EXTERNALSYM MFT_RIGHTJUSTIFY}
  MFT_RIGHTJUSTIFY = MF_RIGHTJUSTIFY;

  { Menu flags for AddCheckEnableMenuItem() }
  {$EXTERNALSYM MFS_GRAYED}
  MFS_GRAYED = 3;
  {$EXTERNALSYM MFS_DISABLED}
  MFS_DISABLED = MFS_GRAYED;
  {$EXTERNALSYM MFS_CHECKED}
  MFS_CHECKED = MF_CHECKED;
  {$EXTERNALSYM MFS_HILITE}
  MFS_HILITE = MF_HILITE;
  {$EXTERNALSYM MFS_ENABLED}
  MFS_ENABLED = MF_ENABLED;
  {$EXTERNALSYM MFS_UNCHECKED}
  MFS_UNCHECKED = MF_UNCHECKED;
  {$EXTERNALSYM MFS_UNHILITE}
  MFS_UNHILITE = MF_UNHILITE;
  {$EXTERNALSYM MFS_DEFAULT}
  MFS_DEFAULT = MF_DEFAULT;

  {$EXTERNALSYM MFS_MASK}
  MFS_MASK = $108B;
  {$EXTERNALSYM MFS_HOTTRACKDRAWN}
  MFS_HOTTRACKDRAWN = $10000000;
  {$EXTERNALSYM MFS_CACHEDBMP}
  MFS_CACHEDBMP = $20000000;
  {$EXTERNALSYM MFS_BOTTOMGAPDROP}
  MFS_BOTTOMGAPDROP = $40000000;
  {$EXTERNALSYM MFS_TOPGAPDROP}
  MFS_TOPGAPDROP = $80000000;
  {$EXTERNALSYM MFS_GAPDROP}
  MFS_GAPDROP = $C0000000;

{$EXTERNALSYM CheckMenuRadioItem}
function CheckMenuRadioItem(hMenu: HMENU; First, Last, Check, Flags: UINT): BOOL; stdcall;

type
  { Menu item resource format }
  PMenuItemTemplateHeader = ^TMenuItemTemplateHeader;
  {$EXTERNALSYM MENUITEMTEMPLATEHEADER}
  MENUITEMTEMPLATEHEADER = packed record
    versionNumber: Word;
    offset: Word;
  end;
  TMenuItemTemplateHeader = MENUITEMTEMPLATEHEADER;

  PMenuItemTemplate = ^TMenuItemTemplate;
  {$EXTERNALSYM MENUITEMTEMPLATE}
  MENUITEMTEMPLATE = packed record {Version 0}
    mtOption: Word;
    mtID: Word;
    mtString: array[0..0] of WCHAR;
  end;
  TMenuItemTemplate = MENUITEMTEMPLATE;


const
  { System Menu Command Values }
  {$EXTERNALSYM SC_SIZE}
  SC_SIZE = 61440;
  {$EXTERNALSYM SC_MOVE}
  SC_MOVE = 61456;
  {$EXTERNALSYM SC_MINIMIZE}
  SC_MINIMIZE = 61472;
  {$EXTERNALSYM SC_MAXIMIZE}
  SC_MAXIMIZE = 61488;
  {$EXTERNALSYM SC_NEXTWINDOW}
  SC_NEXTWINDOW = 61504;
  {$EXTERNALSYM SC_PREVWINDOW}
  SC_PREVWINDOW = 61520;
  {$EXTERNALSYM SC_CLOSE}
  SC_CLOSE = 61536;
  {$EXTERNALSYM SC_VSCROLL}
  SC_VSCROLL = 61552;
  {$EXTERNALSYM SC_HSCROLL}
  SC_HSCROLL = 61568;
  {$EXTERNALSYM SC_MOUSEMENU}
  SC_MOUSEMENU = 61584;
  {$EXTERNALSYM SC_KEYMENU}
  SC_KEYMENU = 61696;
  {$EXTERNALSYM SC_ARRANGE}
  SC_ARRANGE = 61712;
  {$EXTERNALSYM SC_RESTORE}
  SC_RESTORE = 61728;
  {$EXTERNALSYM SC_TASKLIST}
  SC_TASKLIST = 61744;
  {$EXTERNALSYM SC_SCREENSAVE}
  SC_SCREENSAVE = 61760;
  {$EXTERNALSYM SC_HOTKEY}
  SC_HOTKEY = 61776;
  {$EXTERNALSYM SC_DEFAULT}
  SC_DEFAULT = 61792;
  {$EXTERNALSYM SC_MONITORPOWER}
  SC_MONITORPOWER = 61808;
  {$EXTERNALSYM SC_CONTEXTHELP}
  SC_CONTEXTHELP = 61824;
  {$EXTERNALSYM SC_SEPARATOR}
  SC_SEPARATOR = 61455;

  { Obsolete names }
  {$EXTERNALSYM SC_ICON}
  SC_ICON = SC_MINIMIZE;
  {$EXTERNALSYM SC_ZOOM}
  SC_ZOOM = SC_MAXIMIZE;

{ Resource Loading Routines }

{$EXTERNALSYM LoadBitmap}
function LoadBitmap(hInstance: HINST; lpBitmapName: PChar): HBITMAP; stdcall;
{$EXTERNALSYM LoadBitmapA}
function LoadBitmapA(hInstance: HINST; lpBitmapName: PAnsiChar): HBITMAP; stdcall;
{$EXTERNALSYM LoadBitmapW}
function LoadBitmapW(hInstance: HINST; lpBitmapName: PWideChar): HBITMAP; stdcall;
{$EXTERNALSYM LoadCursor}
function LoadCursor(hInstance: HINST; lpCursorName: PChar): HCURSOR; stdcall;
{$EXTERNALSYM LoadCursorA}
function LoadCursorA(hInstance: HINST; lpCursorName: PAnsiChar): HCURSOR; stdcall;
{$EXTERNALSYM LoadCursorW}
function LoadCursorW(hInstance: HINST; lpCursorName: PWideChar): HCURSOR; stdcall;
{$EXTERNALSYM LoadCursorFromFile}
function LoadCursorFromFile(lpFileName: PChar): HCURSOR; stdcall;
{$EXTERNALSYM LoadCursorFromFileA}
function LoadCursorFromFileA(lpFileName: PAnsiChar): HCURSOR; stdcall;
{$EXTERNALSYM LoadCursorFromFileW}
function LoadCursorFromFileW(lpFileName: PWideChar): HCURSOR; stdcall;
{$EXTERNALSYM CreateCursor}
function CreateCursor(hInst: HINST; xHotSpot, yHotSpot, nWidth, nHeight: Integer;
  pvANDPlaneter, pvXORPlane: Pointer): HCURSOR; stdcall;
{$EXTERNALSYM DestroyCursor}
function DestroyCursor(hCursor: HICON): BOOL; stdcall;

const
  { Standard Cursor IDs }
  {$EXTERNALSYM IDC_ARROW}
  IDC_ARROW = MakeIntResource(32512);
  {$EXTERNALSYM IDC_IBEAM}
  IDC_IBEAM = MakeIntResource(32513);
  {$EXTERNALSYM IDC_WAIT}
  IDC_WAIT = MakeIntResource(32514);
  {$EXTERNALSYM IDC_CROSS}
  IDC_CROSS = MakeIntResource(32515);
  {$EXTERNALSYM IDC_UPARROW}
  IDC_UPARROW = MakeIntResource(32516);
  {$EXTERNALSYM IDC_SIZE}
  IDC_SIZE = MakeIntResource(32640);
  {$EXTERNALSYM IDC_ICON}
  IDC_ICON = MakeIntResource(32641);
  {$EXTERNALSYM IDC_SIZENWSE}
  IDC_SIZENWSE = MakeIntResource(32642);
  {$EXTERNALSYM IDC_SIZENESW}
  IDC_SIZENESW = MakeIntResource(32643);
  {$EXTERNALSYM IDC_SIZEWE}
  IDC_SIZEWE = MakeIntResource(32644);
  {$EXTERNALSYM IDC_SIZENS}
  IDC_SIZENS = MakeIntResource(32645);
  {$EXTERNALSYM IDC_SIZEALL}
  IDC_SIZEALL = MakeIntResource(32646);
  {$EXTERNALSYM IDC_NO}
  IDC_NO = MakeIntResource(32648);
  {$EXTERNALSYM IDC_HAND}
  IDC_HAND = MakeIntResource(32649);
  {$EXTERNALSYM IDC_APPSTARTING}
  IDC_APPSTARTING = MakeIntResource(32650);
  {$EXTERNALSYM IDC_HELP}
  IDC_HELP = MakeIntResource(32651);

{$EXTERNALSYM SetSystemCursor}
function SetSystemCursor(hcur: HICON; id: DWORD): BOOL; stdcall;

type
  PIconInfo = ^TIconInfo;
  {$EXTERNALSYM _ICONINFO}
  _ICONINFO = packed record
    fIcon: BOOL;
    xHotspot: DWORD;
    yHotspot: DWORD;
    hbmMask: HBITMAP;
    hbmColor: HBITMAP;
  end;
  TIconInfo = _ICONINFO;
  {$EXTERNALSYM ICONINFO}
  ICONINFO = _ICONINFO;

{$EXTERNALSYM LoadIcon}
function LoadIcon(hInstance: HINST; lpIconName: PChar): HICON; stdcall;
{$EXTERNALSYM LoadIconA}
function LoadIconA(hInstance: HINST; lpIconName: PAnsiChar): HICON; stdcall;
{$EXTERNALSYM LoadIconW}
function LoadIconW(hInstance: HINST; lpIconName: PWideChar): HICON; stdcall;
{$EXTERNALSYM CreateIcon}
function CreateIcon(hInstance: HINST; nWidth, nHeight: Integer;
  cPlanes, cBitsPixel: Byte; lpbANDbits, lpbXORbits: Pointer): HICON; stdcall;
{$EXTERNALSYM DestroyIcon}
function DestroyIcon(hIcon: HICON): BOOL; stdcall;
{$EXTERNALSYM LookupIconIdFromDirectory}
function LookupIconIdFromDirectory(presbits: PByte; fIcon: BOOL): Integer; stdcall;
{$EXTERNALSYM LookupIconIdFromDirectoryEx}
function LookupIconIdFromDirectoryEx(presbits: PByte; fIcon: BOOL;
  cxDesired, cyDesired: Integer; Flags: UINT): Integer; stdcall;
{$EXTERNALSYM CreateIconFromResource}
function CreateIconFromResource(presbits: PByte; dwResSize: DWORD;
  fIcon: BOOL; dwVer: DWORD): HICON; stdcall;
{$EXTERNALSYM CreateIconFromResourceEx}
function CreateIconFromResourceEx(presbits: PByte; dwResSize: DWORD;
  fIcon: BOOL; dwVer: DWORD; cxDesired, cyDesired: Integer; Flags: UINT): HICON; stdcall;


type
  { IconCursor header }
  PCursorShape = ^TCursorShape;
  {$EXTERNALSYM tagCURSORSHAPE}
  tagCURSORSHAPE = record
    xHotSpot: Integer;
    yHotSpot: Integer;
    cx: Integer;
    cy: Integer;
    cbWidth: Integer;
    Planes: Byte;
    BitsPixel: Byte;
  end;
  TCursorShape = tagCURSORSHAPE;
  {$EXTERNALSYM CURSORSHAPE}
  CURSORSHAPE = tagCURSORSHAPE;

const
  {$EXTERNALSYM IMAGE_BITMAP}
  IMAGE_BITMAP = 0;
  {$EXTERNALSYM IMAGE_ICON}
  IMAGE_ICON = 1;
  {$EXTERNALSYM IMAGE_CURSOR}
  IMAGE_CURSOR = 2;
  {$EXTERNALSYM IMAGE_ENHMETAFILE}
  IMAGE_ENHMETAFILE = 3;

  {$EXTERNALSYM LR_DEFAULTCOLOR}
  LR_DEFAULTCOLOR = $0000;
  {$EXTERNALSYM LR_MONOCHROME}
  LR_MONOCHROME = $0001;
  {$EXTERNALSYM LR_COLOR}
  LR_COLOR = $0002;
  {$EXTERNALSYM LR_COPYRETURNORG}
  LR_COPYRETURNORG = $0004;
  {$EXTERNALSYM LR_COPYDELETEORG}
  LR_COPYDELETEORG = $0008;
  {$EXTERNALSYM LR_LOADFROMFILE}
  LR_LOADFROMFILE = $0010;
  {$EXTERNALSYM LR_LOADTRANSPARENT}
  LR_LOADTRANSPARENT = $0020;
  {$EXTERNALSYM LR_DEFAULTSIZE}
  LR_DEFAULTSIZE = $0040;
  {$EXTERNALSYM LR_VGACOLOR}
  LR_VGACOLOR = $0080;
  {$EXTERNALSYM LR_LOADMAP3DCOLORS}
  LR_LOADMAP3DCOLORS = $1000;
  {$EXTERNALSYM LR_CREATEDIBSECTION}
  LR_CREATEDIBSECTION = $2000;
  {$EXTERNALSYM LR_COPYFROMRESOURCE}
  LR_COPYFROMRESOURCE = $4000;
  {$EXTERNALSYM LR_SHARED}
  LR_SHARED = $8000;

{$EXTERNALSYM LoadImage}
function LoadImage(hInst: HINST; ImageName: PChar; ImageType: UINT; X, Y: Integer; Flags: UINT): THandle; stdcall;
{$EXTERNALSYM LoadImageA}
function LoadImageA(hInst: HINST; ImageName: PAnsiChar; ImageType: UINT; X, Y: Integer; Flags: UINT): THandle; stdcall;
{$EXTERNALSYM LoadImageW}
function LoadImageW(hInst: HINST; ImageName: PWideChar; ImageType: UINT; X, Y: Integer; Flags: UINT): THandle; stdcall;
{$EXTERNALSYM CopyImage}
function CopyImage(hImage: THandle; ImageType: UINT; X, Y: Integer; Flags: UINT): THandle; stdcall;

const
  {$EXTERNALSYM DI_MASK}
  DI_MASK = 1;
  {$EXTERNALSYM DI_IMAGE}
  DI_IMAGE = 2;
  {$EXTERNALSYM DI_NORMAL}
  DI_NORMAL = 3;
  {$EXTERNALSYM DI_COMPAT}
  DI_COMPAT = 4;
  {$EXTERNALSYM DI_DEFAULTSIZE}
  DI_DEFAULTSIZE = 8;

{$EXTERNALSYM DrawIconEx}
function DrawIconEx(hdc: HDC; xLeft, yTop: Integer; hIcon: HICON;
  cxWidth, cyWidth: Integer; istepIfAniCur: UINT;
  hbrFlickerFreeDraw: HBRUSH; diFlags: UINT): BOOL; stdcall;
{$EXTERNALSYM CreateIconIndirect}
function CreateIconIndirect(var piconinfo: TIconInfo): HICON; stdcall;
{$EXTERNALSYM CopyIcon}
function CopyIcon(hIcon: HICON): HICON; stdcall;
{$EXTERNALSYM GetIconInfo}
function GetIconInfo(hIcon: HICON; var piconinfo: TIconInfo): BOOL; stdcall;

const
  {$EXTERNALSYM OBM_CLOSE}
  OBM_CLOSE               = 32754;
  {$EXTERNALSYM OBM_UPARROW}
  OBM_UPARROW             = 32753;
  {$EXTERNALSYM OBM_DNARROW}
  OBM_DNARROW             = 32752;
  {$EXTERNALSYM OBM_RGARROW}
  OBM_RGARROW             = 32751;
  {$EXTERNALSYM OBM_LFARROW}
  OBM_LFARROW             = 32750;
  {$EXTERNALSYM OBM_REDUCE}
  OBM_REDUCE              = 32749;
  {$EXTERNALSYM OBM_ZOOM}
  OBM_ZOOM                = 32748;
  {$EXTERNALSYM OBM_RESTORE}
  OBM_RESTORE             = 32747;
  {$EXTERNALSYM OBM_REDUCED}
  OBM_REDUCED             = 32746;
  {$EXTERNALSYM OBM_ZOOMD}
  OBM_ZOOMD               = 32745;
  {$EXTERNALSYM OBM_RESTORED}
  OBM_RESTORED            = 32744;
  {$EXTERNALSYM OBM_UPARROWD}
  OBM_UPARROWD            = 32743;
  {$EXTERNALSYM OBM_DNARROWD}
  OBM_DNARROWD            = 32742;
  {$EXTERNALSYM OBM_RGARROWD}
  OBM_RGARROWD            = 32741;
  {$EXTERNALSYM OBM_LFARROWD}
  OBM_LFARROWD            = 32740;
  {$EXTERNALSYM OBM_MNARROW}
  OBM_MNARROW             = 32739;
  {$EXTERNALSYM OBM_COMBO}
  OBM_COMBO               = 32738;
  {$EXTERNALSYM OBM_UPARROWI}
  OBM_UPARROWI            = 32737;
  {$EXTERNALSYM OBM_DNARROWI}
  OBM_DNARROWI            = 32736;
  {$EXTERNALSYM OBM_RGARROWI}
  OBM_RGARROWI            = 32735;
  {$EXTERNALSYM OBM_LFARROWI}
  OBM_LFARROWI            = 32734;

  {$EXTERNALSYM OBM_OLD_CLOSE}
  OBM_OLD_CLOSE           = 32767;
  {$EXTERNALSYM OBM_SIZE}
  OBM_SIZE                = 32766;
  {$EXTERNALSYM OBM_OLD_UPARROW}
  OBM_OLD_UPARROW         = 32765;
  {$EXTERNALSYM OBM_OLD_DNARROW}
  OBM_OLD_DNARROW         = 32764;
  {$EXTERNALSYM OBM_OLD_RGARROW}
  OBM_OLD_RGARROW         = 32763;
  {$EXTERNALSYM OBM_OLD_LFARROW}
  OBM_OLD_LFARROW         = 32762;
  {$EXTERNALSYM OBM_BTSIZE}
  OBM_BTSIZE              = 32761;
  {$EXTERNALSYM OBM_CHECK}
  OBM_CHECK               = 32760;
  {$EXTERNALSYM OBM_CHECKBOXES}
  OBM_CHECKBOXES          = 32759;
  {$EXTERNALSYM OBM_BTNCORNERS}
  OBM_BTNCORNERS          = 32758;
  {$EXTERNALSYM OBM_OLD_REDUCE}
  OBM_OLD_REDUCE          = 32757;
  {$EXTERNALSYM OBM_OLD_ZOOM}
  OBM_OLD_ZOOM            = 32756;
  {$EXTERNALSYM OBM_OLD_RESTORE}
  OBM_OLD_RESTORE         = 32755;

  {$EXTERNALSYM OCR_NORMAL}
  OCR_NORMAL              = 32512;
  {$EXTERNALSYM OCR_IBEAM}
  OCR_IBEAM               = 32513;
  {$EXTERNALSYM OCR_WAIT}
  OCR_WAIT                = 32514;
  {$EXTERNALSYM OCR_CROSS}
  OCR_CROSS               = 32515;
  {$EXTERNALSYM OCR_UP}
  OCR_UP                  = 32516;
  {$EXTERNALSYM OCR_SIZE}
  OCR_SIZE                = 32640;  { OBSOLETE: use OCR_SIZEALL }
  {$EXTERNALSYM OCR_ICON}
  OCR_ICON                = 32641;  { OBSOLETE: use OCR_NORMAL }
  {$EXTERNALSYM OCR_SIZENWSE}
  OCR_SIZENWSE            = 32642;
  {$EXTERNALSYM OCR_SIZENESW}
  OCR_SIZENESW            = 32643;
  {$EXTERNALSYM OCR_SIZEWE}
  OCR_SIZEWE              = 32644;
  {$EXTERNALSYM OCR_SIZENS}
  OCR_SIZENS              = 32645;
  {$EXTERNALSYM OCR_SIZEALL}
  OCR_SIZEALL             = 32646;
  {$EXTERNALSYM OCR_ICOCUR}
  OCR_ICOCUR              = 32647;  { OBSOLETE: use OIC_WINLOGO }
  {$EXTERNALSYM OCR_NO}
  OCR_NO                  = 32648;
  {$EXTERNALSYM OCR_HAND}
  OCR_HAND                  = 32649;
  {$EXTERNALSYM OCR_APPSTARTING}
  OCR_APPSTARTING         = 32650;

  {$EXTERNALSYM OIC_SAMPLE}
  OIC_SAMPLE              = 32512;
  {$EXTERNALSYM OIC_HAND}
  OIC_HAND                = 32513;
  {$EXTERNALSYM OIC_QUES}
  OIC_QUES                = 32514;
  {$EXTERNALSYM OIC_BANG}
  OIC_BANG                = 32515;
  {$EXTERNALSYM OIC_NOTE}
  OIC_NOTE                = 32516;
  {$EXTERNALSYM OIC_WINLOGO}
  OIC_WINLOGO             = 32517;
  {$EXTERNALSYM OIC_WARNING}
  OIC_WARNING             = OIC_BANG;
  {$EXTERNALSYM OIC_ERROR}
  OIC_ERROR               = OIC_HAND;
  {$EXTERNALSYM OIC_INFORMATION}
  OIC_INFORMATION         = OIC_NOTE;

  {$EXTERNALSYM RES_ICON}
  RES_ICON = 1;
  {$EXTERNALSYM RES_CURSOR}
  RES_CURSOR = 2;

  { The ordinal number for the entry point of language drivers. }
  {$EXTERNALSYM ORD_LANGDRIVER}
  ORD_LANGDRIVER = 1;

  { Standard Icon IDs }
  {$EXTERNALSYM IDI_APPLICATION}
  IDI_APPLICATION = MakeIntResource(32512);
  {$EXTERNALSYM IDI_HAND}
  IDI_HAND = MakeIntResource(32513);
  {$EXTERNALSYM IDI_QUESTION}
  IDI_QUESTION = MakeIntResource(32514);
  {$EXTERNALSYM IDI_EXCLAMATION}
  IDI_EXCLAMATION = MakeIntResource(32515);
  {$EXTERNALSYM IDI_ASTERISK}
  IDI_ASTERISK = MakeIntResource(32516);
  {$EXTERNALSYM IDI_WINLOGO}
  IDI_WINLOGO = MakeIntResource(32517);
  {$EXTERNALSYM IDI_WARNING}
  IDI_WARNING = IDI_EXCLAMATION;
  {$EXTERNALSYM IDI_ERROR}
  IDI_ERROR = IDI_HAND;
  {$EXTERNALSYM IDI_INFORMATION}
  IDI_INFORMATION = IDI_ASTERISK;

{$EXTERNALSYM LoadString}
function LoadString(hInstance: HINST; uID: UINT; lpBuffer: PChar; nBufferMax: Integer): Integer; stdcall;
{$EXTERNALSYM LoadStringA}
function LoadStringA(hInstance: HINST; uID: UINT; lpBuffer: PAnsiChar; nBufferMax: Integer): Integer; stdcall;
{$EXTERNALSYM LoadStringW}
function LoadStringW(hInstance: HINST; uID: UINT; lpBuffer: PWideChar; nBufferMax: Integer): Integer; stdcall;

const
  { Dialog Box Command IDs }
  {$EXTERNALSYM IDOK}
  IDOK = 1;          ID_OK = IDOK;
  {$EXTERNALSYM IDCANCEL}
  IDCANCEL = 2;      ID_CANCEL = IDCANCEL;
  {$EXTERNALSYM IDABORT}
  IDABORT = 3;       ID_ABORT = IDABORT;
  {$EXTERNALSYM IDRETRY}
  IDRETRY = 4;       ID_RETRY = IDRETRY;
  {$EXTERNALSYM IDIGNORE}
  IDIGNORE = 5;      ID_IGNORE = IDIGNORE;
  {$EXTERNALSYM IDYES}
  IDYES = 6;         ID_YES = IDYES;
  {$EXTERNALSYM IDNO}
  IDNO = 7;          ID_NO = IDNO;
  {$EXTERNALSYM IDCLOSE}
  IDCLOSE = 8;       ID_CLOSE = IDCLOSE;
  {$EXTERNALSYM IDHELP}
  IDHELP = 9;        ID_HELP = IDHELP;
  {$EXTERNALSYM IDTRYAGAIN}
  IDTRYAGAIN = 10;
  {$EXTERNALSYM IDCONTINUE}
  IDCONTINUE = 11;


{ Control Manager Structures and Definitions }

  { Edit Control Styles }
  {$EXTERNALSYM ES_LEFT}
  ES_LEFT = 0;
  {$EXTERNALSYM ES_CENTER}
  ES_CENTER = 1;
  {$EXTERNALSYM ES_RIGHT}
  ES_RIGHT = 2;
  {$EXTERNALSYM ES_MULTILINE}
  ES_MULTILINE = 4;
  {$EXTERNALSYM ES_UPPERCASE}
  ES_UPPERCASE = 8;
  {$EXTERNALSYM ES_LOWERCASE}
  ES_LOWERCASE = $10;
  {$EXTERNALSYM ES_PASSWORD}
  ES_PASSWORD = $20;
  {$EXTERNALSYM ES_AUTOVSCROLL}
  ES_AUTOVSCROLL = $40;
  {$EXTERNALSYM ES_AUTOHSCROLL}
  ES_AUTOHSCROLL = $80;
  {$EXTERNALSYM ES_NOHIDESEL}
  ES_NOHIDESEL = $100;
  {$EXTERNALSYM ES_OEMCONVERT}
  ES_OEMCONVERT = $400;
  {$EXTERNALSYM ES_READONLY}
  ES_READONLY = $800;
  {$EXTERNALSYM ES_WANTRETURN}
  ES_WANTRETURN = $1000;
  {$EXTERNALSYM ES_NUMBER}
  ES_NUMBER = $2000;

  { Edit control EM_SETMARGIN parameters }
  {$EXTERNALSYM EC_LEFTMARGIN}
  EC_LEFTMARGIN = 1;
  {$EXTERNALSYM EC_RIGHTMARGIN}
  EC_RIGHTMARGIN = 2;
  {$EXTERNALSYM EC_USEFONTINFO}
  EC_USEFONTINFO = 65535;

  { wParam of EM_GET/SETIMESTATUS }
  {$EXTERNALSYM EMSIS_COMPOSITIONSTRING}
  EMSIS_COMPOSITIONSTRING = 1;

  { lParam for EMSIS_COMPOSITIONSTRING }
  {$EXTERNALSYM EIMES_GETCOMPSTRATONCE}
  EIMES_GETCOMPSTRATONCE = 1;
  {$EXTERNALSYM EIMES_CANCELCOMPSTRINGFOCUS}
  EIMES_CANCELCOMPSTRINGFOCUS = 2;
  {$EXTERNALSYM EIMES_COMPLETECOMPSTRKILLFOCUS}
  EIMES_COMPLETECOMPSTRKILLFOCUS = 4;

  { TFNEditWordBreakProc code values }
  {$EXTERNALSYM WB_LEFT}
  WB_LEFT = 0;
  {$EXTERNALSYM WB_RIGHT}
  WB_RIGHT = 1;
  {$EXTERNALSYM WB_ISDELIMITER}
  WB_ISDELIMITER = 2;

  { Button Control Styles }
  {$EXTERNALSYM BS_PUSHBUTTON}
  BS_PUSHBUTTON = 0;
  {$EXTERNALSYM BS_DEFPUSHBUTTON}
  BS_DEFPUSHBUTTON = 1;
  {$EXTERNALSYM BS_CHECKBOX}
  BS_CHECKBOX = 2;
  {$EXTERNALSYM BS_AUTOCHECKBOX}
  BS_AUTOCHECKBOX = 3;
  {$EXTERNALSYM BS_RADIOBUTTON}
  BS_RADIOBUTTON = 4;
  {$EXTERNALSYM BS_3STATE}
  BS_3STATE = 5;
  {$EXTERNALSYM BS_AUTO3STATE}
  BS_AUTO3STATE = 6;
  {$EXTERNALSYM BS_GROUPBOX}
  BS_GROUPBOX = 7;
  {$EXTERNALSYM BS_USERBUTTON}
  BS_USERBUTTON = 8;
  {$EXTERNALSYM BS_AUTORADIOBUTTON}
  BS_AUTORADIOBUTTON = 9;
  {$EXTERNALSYM BS_OWNERDRAW}
  BS_OWNERDRAW = 11;
  {$EXTERNALSYM BS_LEFTTEXT}
  BS_LEFTTEXT = $20;
  {$EXTERNALSYM BS_TEXT}
  BS_TEXT = 0;
  {$EXTERNALSYM BS_ICON}
  BS_ICON = $40;
  {$EXTERNALSYM BS_BITMAP}
  BS_BITMAP = $80;
  {$EXTERNALSYM BS_LEFT}
  BS_LEFT = $100;
  {$EXTERNALSYM BS_RIGHT}
  BS_RIGHT = $200;
  {$EXTERNALSYM BS_CENTER}
  BS_CENTER = 768;
  {$EXTERNALSYM BS_TOP}
  BS_TOP = $400;
  {$EXTERNALSYM BS_BOTTOM}
  BS_BOTTOM = $800;
  {$EXTERNALSYM BS_VCENTER}
  BS_VCENTER = 3072;
  {$EXTERNALSYM BS_PUSHLIKE}
  BS_PUSHLIKE = $1000;
  {$EXTERNALSYM BS_MULTILINE}
  BS_MULTILINE = $2000;
  {$EXTERNALSYM BS_NOTIFY}
  BS_NOTIFY = $4000;
  {$EXTERNALSYM BS_FLAT}
  BS_FLAT = $8000;
  {$EXTERNALSYM BS_RIGHTBUTTON}
  BS_RIGHTBUTTON = BS_LEFTTEXT;

  {$EXTERNALSYM BST_UNCHECKED}
  BST_UNCHECKED = 0;
  {$EXTERNALSYM BST_CHECKED}
  BST_CHECKED = 1;
  {$EXTERNALSYM BST_INDETERMINATE}
  BST_INDETERMINATE = 2;
  {$EXTERNALSYM BST_PUSHED}
  BST_PUSHED = 4;
  {$EXTERNALSYM BST_FOCUS}
  BST_FOCUS = 8;

  { Static Control Constants }
  {$EXTERNALSYM SS_LEFT}
  SS_LEFT = 0;
  {$EXTERNALSYM SS_CENTER}
  SS_CENTER = 1;
  {$EXTERNALSYM SS_RIGHT}
  SS_RIGHT = 2;
  {$EXTERNALSYM SS_ICON}
  SS_ICON = 3;
  {$EXTERNALSYM SS_BLACKRECT}
  SS_BLACKRECT = 4;
  {$EXTERNALSYM SS_GRAYRECT}
  SS_GRAYRECT = 5;
  {$EXTERNALSYM SS_WHITERECT}
  SS_WHITERECT = 6;
  {$EXTERNALSYM SS_BLACKFRAME}
  SS_BLACKFRAME = 7;
  {$EXTERNALSYM SS_GRAYFRAME}
  SS_GRAYFRAME = 8;
  {$EXTERNALSYM SS_WHITEFRAME}
  SS_WHITEFRAME = 9;
  {$EXTERNALSYM SS_USERITEM}
  SS_USERITEM = 10;
  {$EXTERNALSYM SS_SIMPLE}
  SS_SIMPLE = 11;
  {$EXTERNALSYM SS_LEFTNOWORDWRAP}
  SS_LEFTNOWORDWRAP = 12;
  {$EXTERNALSYM SS_BITMAP}
  SS_BITMAP = 14;
  {$EXTERNALSYM SS_OWNERDRAW}
  SS_OWNERDRAW = 13;
  {$EXTERNALSYM SS_ENHMETAFILE}
  SS_ENHMETAFILE = 15;
  {$EXTERNALSYM SS_ETCHEDHORZ}
  SS_ETCHEDHORZ = $10;
  {$EXTERNALSYM SS_ETCHEDVERT}
  SS_ETCHEDVERT = 17;
  {$EXTERNALSYM SS_ETCHEDFRAME}
  SS_ETCHEDFRAME = 18;
  {$EXTERNALSYM SS_TYPEMASK}
  SS_TYPEMASK = 31;
  {$EXTERNALSYM SS_NOPREFIX}
  SS_NOPREFIX = $80;      { Don't do "&" character translation }
  {$EXTERNALSYM SS_NOTIFY}
  SS_NOTIFY = $100;
  {$EXTERNALSYM SS_CENTERIMAGE}
  SS_CENTERIMAGE = $200;
  {$EXTERNALSYM SS_RIGHTJUST}
  SS_RIGHTJUST = $400;
  {$EXTERNALSYM SS_REALSIZEIMAGE}
  SS_REALSIZEIMAGE = $800;
  {$EXTERNALSYM SS_SUNKEN}
  SS_SUNKEN = $1000;
  {$EXTERNALSYM SS_ENDELLIPSIS}
  SS_ENDELLIPSIS =  $4000;
  {$EXTERNALSYM SS_PATHELLIPSIS}
  SS_PATHELLIPSIS = $8000;
  {$EXTERNALSYM SS_WORDELLIPSIS}
  SS_WORDELLIPSIS = $C000;
  {$EXTERNALSYM SS_ELLIPSISMASK}
  SS_ELLIPSISMASK = $C000;

  { Static Control Mesages }
  {$EXTERNALSYM STM_SETICON}
  STM_SETICON = 368;
  {$EXTERNALSYM STM_GETICON}
  STM_GETICON = 369;
  {$EXTERNALSYM STM_SETIMAGE}
  STM_SETIMAGE = 370;
  {$EXTERNALSYM STM_GETIMAGE}
  STM_GETIMAGE = 371;
  {$EXTERNALSYM STN_CLICKED}
  STN_CLICKED = 0;
  {$EXTERNALSYM STN_DBLCLK}
  STN_DBLCLK = 1;
  {$EXTERNALSYM STN_ENABLE}
  STN_ENABLE = 2;
  {$EXTERNALSYM STN_DISABLE}
  STN_DISABLE = 3;
  {$EXTERNALSYM STM_MSGMAX}
  STM_MSGMAX = 372;

  { Dialog window class }
  {$EXTERNALSYM WC_DIALOG}
  WC_DIALOG = MakeIntAtom($8002);

  { GetSetWindowWordLong offsets for use with WC_DIALOG windows }
  {$EXTERNALSYM DWL_MSGRESULT}
  DWL_MSGRESULT = 0;
  {$EXTERNALSYM DWL_DLGPROC}
  DWL_DLGPROC = 4;
  {$EXTERNALSYM DWL_USER}
  DWL_USER = 8;

{ Dialog Manager Routines }

{$EXTERNALSYM IsDialogMessage}
function IsDialogMessage(hDlg: HWND; var lpMsg: TMsg): BOOL; stdcall;
{$EXTERNALSYM IsDialogMessageA}
function IsDialogMessageA(hDlg: HWND; var lpMsg: TMsg): BOOL; stdcall;
{$EXTERNALSYM IsDialogMessageW}
function IsDialogMessageW(hDlg: HWND; var lpMsg: TMsg): BOOL; stdcall;
{$EXTERNALSYM MapDialogRect}
function MapDialogRect(hDlg: HWND; var lpRect: TRect): BOOL; stdcall;
{$EXTERNALSYM DlgDirList}
function DlgDirList(hDlg: HWND; lpPathSpec: PChar;
  nIDListBox, nIDStaticPath: Integer; uFileType: UINT): Integer; stdcall;
{$EXTERNALSYM DlgDirListA}
function DlgDirListA(hDlg: HWND; lpPathSpec: PAnsiChar;
  nIDListBox, nIDStaticPath: Integer; uFileType: UINT): Integer; stdcall;
{$EXTERNALSYM DlgDirListW}
function DlgDirListW(hDlg: HWND; lpPathSpec: PWideChar;
  nIDListBox, nIDStaticPath: Integer; uFileType: UINT): Integer; stdcall;

const
  { DlgDirList, DlgDirListComboBox flags values }
  {$EXTERNALSYM DDL_READWRITE}
  DDL_READWRITE = 0;
  {$EXTERNALSYM DDL_READONLY}
  DDL_READONLY = 1;
  {$EXTERNALSYM DDL_HIDDEN}
  DDL_HIDDEN = 2;
  {$EXTERNALSYM DDL_SYSTEM}
  DDL_SYSTEM = 4;
  {$EXTERNALSYM DDL_DIRECTORY}
  DDL_DIRECTORY = $10;
  {$EXTERNALSYM DDL_ARCHIVE}
  DDL_ARCHIVE = $20;

  {$EXTERNALSYM DDL_POSTMSGS}
  DDL_POSTMSGS = $2000;
  {$EXTERNALSYM DDL_DRIVES}
  DDL_DRIVES = $4000;
  {$EXTERNALSYM DDL_EXCLUSIVE}
  DDL_EXCLUSIVE = $8000;

{$EXTERNALSYM DlgDirSelectEx}
function DlgDirSelectEx(hDlg: HWND; lpString: PChar; nCount, nIDListBox: Integer): BOOL; stdcall;
{$EXTERNALSYM DlgDirSelectExA}
function DlgDirSelectExA(hDlg: HWND; lpString: PAnsiChar; nCount, nIDListBox: Integer): BOOL; stdcall;
{$EXTERNALSYM DlgDirSelectExW}
function DlgDirSelectExW(hDlg: HWND; lpString: PWideChar; nCount, nIDListBox: Integer): BOOL; stdcall;
{$EXTERNALSYM DlgDirListComboBox}
function DlgDirListComboBox(hDlg: HWND; lpPathSpec: PChar;
  nIDComboBox, nIDStaticPath: Integer; uFiletype: UINT): Integer; stdcall;
{$EXTERNALSYM DlgDirListComboBoxA}
function DlgDirListComboBoxA(hDlg: HWND; lpPathSpec: PAnsiChar;
  nIDComboBox, nIDStaticPath: Integer; uFiletype: UINT): Integer; stdcall;
{$EXTERNALSYM DlgDirListComboBoxW}
function DlgDirListComboBoxW(hDlg: HWND; lpPathSpec: PWideChar;
  nIDComboBox, nIDStaticPath: Integer; uFiletype: UINT): Integer; stdcall;
{$EXTERNALSYM DlgDirSelectComboBoxEx}
function DlgDirSelectComboBoxEx(hDlg: HWND; lpString: PChar;
  nCount, nIDComboBox: Integer): BOOL; stdcall;
{$EXTERNALSYM DlgDirSelectComboBoxExA}
function DlgDirSelectComboBoxExA(hDlg: HWND; lpString: PAnsiChar;
  nCount, nIDComboBox: Integer): BOOL; stdcall;
{$EXTERNALSYM DlgDirSelectComboBoxExW}
function DlgDirSelectComboBoxExW(hDlg: HWND; lpString: PWideChar;
  nCount, nIDComboBox: Integer): BOOL; stdcall;

const
  { Dialog Styles }
  {$EXTERNALSYM DS_ABSALIGN}
  DS_ABSALIGN = 1;
  {$EXTERNALSYM DS_SYSMODAL}
  DS_SYSMODAL = 2;
  {$EXTERNALSYM DS_LOCALEDIT}
  DS_LOCALEDIT = $20;         { Edit items get Local storage. }
  {$EXTERNALSYM DS_SETFONT}
  DS_SETFONT = $40;           { User specified font for Dlg controls }
  {$EXTERNALSYM DS_MODALFRAME}
  DS_MODALFRAME = $80;        { Can be combined with WS_CAPTION  }
  {$EXTERNALSYM DS_NOIDLEMSG}
  DS_NOIDLEMSG = $100;        { WM_ENTERIDLE message will not be sent }
  {$EXTERNALSYM DS_SETFOREGROUND}
  DS_SETFOREGROUND = $200;    { not in win3.1 }

  {$EXTERNALSYM DS_3DLOOK}
  DS_3DLOOK = 4;
  {$EXTERNALSYM DS_FIXEDSYS}
  DS_FIXEDSYS = 8;
  {$EXTERNALSYM DS_NOFAILCREATE}
  DS_NOFAILCREATE = $10;
  {$EXTERNALSYM DS_CONTROL}
  DS_CONTROL = $400;
  {$EXTERNALSYM DS_CENTER}
  DS_CENTER = $800;
  {$EXTERNALSYM DS_CENTERMOUSE}
  DS_CENTERMOUSE = $1000;
  {$EXTERNALSYM DS_CONTEXTHELP}
  DS_CONTEXTHELP = $2000;

  {$EXTERNALSYM PSI_SETACTIVE}
  PSI_SETACTIVE = 1;
  {$EXTERNALSYM PSI_KILLACTIVE}
  PSI_KILLACTIVE = 2;
  {$EXTERNALSYM PSI_APPLY}
  PSI_APPLY = 3;
  {$EXTERNALSYM PSI_RESET}
  PSI_RESET = 4;
  {$EXTERNALSYM PSI_HASHELP}
  PSI_HASHELP = 5;
  {$EXTERNALSYM PSI_HELP}
  PSI_HELP = 6;

  {$EXTERNALSYM PSI_CHANGED}
  PSI_CHANGED = 1;
  {$EXTERNALSYM PSI_GUISTART}
  PSI_GUISTART = 2;
  {$EXTERNALSYM PSI_REBOOT}
  PSI_REBOOT = 3;
  {$EXTERNALSYM PSI_GETSIBLINGS}
  PSI_GETSIBLINGS = 4;

  { Returned in HiWord() of DM_GETDEFID result if msg is supported }
  {$EXTERNALSYM DC_HASDEFID}
  DC_HASDEFID = 21323;

  { Dialog Codes }
  {$EXTERNALSYM DLGC_WANTARROWS}
  DLGC_WANTARROWS = 1;         { Control wants arrow keys         }
  {$EXTERNALSYM DLGC_WANTTAB}
  DLGC_WANTTAB = 2;            { Control wants tab keys           }
  {$EXTERNALSYM DLGC_WANTALLKEYS}
  DLGC_WANTALLKEYS = 4;        { Control wants all keys           }
  {$EXTERNALSYM DLGC_WANTMESSAGE}
  DLGC_WANTMESSAGE = 4;        { Pass message to control          }
  {$EXTERNALSYM DLGC_HASSETSEL}
  DLGC_HASSETSEL = 8;          { Understands EM_SETSEL message    }
  {$EXTERNALSYM DLGC_DEFPUSHBUTTON}
  DLGC_DEFPUSHBUTTON = $10;    { Default pushbutton               }
  {$EXTERNALSYM DLGC_UNDEFPUSHBUTTON}
  DLGC_UNDEFPUSHBUTTON = $20;  { Non-default pushbutton           }
  {$EXTERNALSYM DLGC_RADIOBUTTON}
  DLGC_RADIOBUTTON = $40;      { Radio button                     }
  {$EXTERNALSYM DLGC_WANTCHARS}
  DLGC_WANTCHARS = $80;        { Want WM_CHAR messages            }
  {$EXTERNALSYM DLGC_STATIC}
  DLGC_STATIC = $100;          { Static item: don't include       }
  {$EXTERNALSYM DLGC_BUTTON}
  DLGC_BUTTON = $2000;         { Button item: can be checked      }
  {$EXTERNALSYM LB_CTLCODE}
  LB_CTLCODE = 0;

  { Listbox Return Values }
  {$EXTERNALSYM LB_OKAY}
  LB_OKAY = 0;
  {$EXTERNALSYM LB_ERR}
  LB_ERR = -1;
  {$EXTERNALSYM LB_ERRSPACE}
  LB_ERRSPACE = -2;

  { Listbox Styles }
  {$EXTERNALSYM LBS_NOTIFY}
  LBS_NOTIFY = 1;
  {$EXTERNALSYM LBS_SORT}
  LBS_SORT = 2;
  {$EXTERNALSYM LBS_NOREDRAW}
  LBS_NOREDRAW = 4;
  {$EXTERNALSYM LBS_MULTIPLESEL}
  LBS_MULTIPLESEL = 8;
  {$EXTERNALSYM LBS_OWNERDRAWFIXED}
  LBS_OWNERDRAWFIXED = $10;
  {$EXTERNALSYM LBS_OWNERDRAWVARIABLE}
  LBS_OWNERDRAWVARIABLE = $20;
  {$EXTERNALSYM LBS_HASSTRINGS}
  LBS_HASSTRINGS = $40;
  {$EXTERNALSYM LBS_USETABSTOPS}
  LBS_USETABSTOPS = $80;
  {$EXTERNALSYM LBS_NOINTEGRALHEIGHT}
  LBS_NOINTEGRALHEIGHT = $100;
  {$EXTERNALSYM LBS_MULTICOLUMN}
  LBS_MULTICOLUMN = $200;
  {$EXTERNALSYM LBS_WANTKEYBOARDINPUT}
  LBS_WANTKEYBOARDINPUT = $400;
  {$EXTERNALSYM LBS_EXTENDEDSEL}
  LBS_EXTENDEDSEL = $800;
  {$EXTERNALSYM LBS_DISABLENOSCROLL}
  LBS_DISABLENOSCROLL = $1000;
  {$EXTERNALSYM LBS_NODATA}
  LBS_NODATA = $2000;
  {$EXTERNALSYM LBS_NOSEL}
  LBS_NOSEL = $4000;
  {$EXTERNALSYM LBS_STANDARD}
  LBS_STANDARD = (LBS_NOTIFY or LBS_SORT or WS_VSCROLL or WS_BORDER);

  { Combo Box return Values }
  {$EXTERNALSYM CB_OKAY}
  CB_OKAY = 0;
  {$EXTERNALSYM CB_ERR}
  CB_ERR = -1;
  {$EXTERNALSYM CB_ERRSPACE}
  CB_ERRSPACE = -2;

  { Combo Box styles }
  {$EXTERNALSYM CBS_SIMPLE}
  CBS_SIMPLE = 1;
  {$EXTERNALSYM CBS_DROPDOWN}
  CBS_DROPDOWN = 2;
  {$EXTERNALSYM CBS_DROPDOWNLIST}
  CBS_DROPDOWNLIST = 3;
  {$EXTERNALSYM CBS_OWNERDRAWFIXED}
  CBS_OWNERDRAWFIXED = $10;
  {$EXTERNALSYM CBS_OWNERDRAWVARIABLE}
  CBS_OWNERDRAWVARIABLE = $20;
  {$EXTERNALSYM CBS_AUTOHSCROLL}
  CBS_AUTOHSCROLL = $40;
  {$EXTERNALSYM CBS_OEMCONVERT}
  CBS_OEMCONVERT = $80;
  {$EXTERNALSYM CBS_SORT}
  CBS_SORT = $100;
  {$EXTERNALSYM CBS_HASSTRINGS}
  CBS_HASSTRINGS = $200;
  {$EXTERNALSYM CBS_NOINTEGRALHEIGHT}
  CBS_NOINTEGRALHEIGHT = $400;
  {$EXTERNALSYM CBS_DISABLENOSCROLL}
  CBS_DISABLENOSCROLL = $800;
  {$EXTERNALSYM CBS_UPPERCASE}
  CBS_UPPERCASE = $2000;
  {$EXTERNALSYM CBS_LOWERCASE}
  CBS_LOWERCASE = $4000;

  { Scroll Bar Styles }
  {$EXTERNALSYM SBS_HORZ}
  SBS_HORZ = 0;
  {$EXTERNALSYM SBS_VERT}
  SBS_VERT = 1;
  {$EXTERNALSYM SBS_TOPALIGN}
  SBS_TOPALIGN = 2;
  {$EXTERNALSYM SBS_LEFTALIGN}
  SBS_LEFTALIGN = 2;
  {$EXTERNALSYM SBS_BOTTOMALIGN}
  SBS_BOTTOMALIGN = 4;
  {$EXTERNALSYM SBS_RIGHTALIGN}
  SBS_RIGHTALIGN = 4;
  {$EXTERNALSYM SBS_SIZEBOXTOPLEFTALIGN}
  SBS_SIZEBOXTOPLEFTALIGN = 2;
  {$EXTERNALSYM SBS_SIZEBOXBOTTOMRIGHTALIGN}
  SBS_SIZEBOXBOTTOMRIGHTALIGN = 4;
  {$EXTERNALSYM SBS_SIZEBOX}
  SBS_SIZEBOX = 8;
  {$EXTERNALSYM SBS_SIZEGRIP}
  SBS_SIZEGRIP = $10;

  {$EXTERNALSYM SIF_RANGE}
  SIF_RANGE = 1;
  {$EXTERNALSYM SIF_PAGE}
  SIF_PAGE = 2;
  {$EXTERNALSYM SIF_POS}
  SIF_POS = 4;
  {$EXTERNALSYM SIF_DISABLENOSCROLL}
  SIF_DISABLENOSCROLL = 8;
  {$EXTERNALSYM SIF_TRACKPOS}
  SIF_TRACKPOS = $10;
  {$EXTERNALSYM SIF_ALL}
  SIF_ALL = (SIF_RANGE or SIF_PAGE or SIF_POS or SIF_TRACKPOS);

type
  {$EXTERNALSYM tagSCROLLINFO}
  tagSCROLLINFO = packed record
    cbSize: UINT;
    fMask: UINT;
    nMin: Integer;
    nMax: Integer;
    nPage: UINT;
    nPos: Integer;
    nTrackPos: Integer;
  end;
  PScrollInfo = ^TScrollInfo;
  TScrollInfo = tagSCROLLINFO;
  {$EXTERNALSYM SCROLLINFO}
  SCROLLINFO = tagSCROLLINFO;

{$EXTERNALSYM SetScrollInfo}
function SetScrollInfo(hWnd: HWND; BarFlag: Integer; const ScrollInfo: TScrollInfo; Redraw: BOOL): Integer; stdcall;
{$EXTERNALSYM GetScrollInfo}
function GetScrollInfo(hWnd: HWND; BarFlag: Integer; var ScrollInfo: TScrollInfo): BOOL; stdcall;


const
  { MDI client style bits }
  {$EXTERNALSYM MDIS_ALLCHILDSTYLES}
  MDIS_ALLCHILDSTYLES = 1;

  { wParam Flags for WM_MDITILE and WM_MDICASCADE messages. }
  {$EXTERNALSYM MDITILE_VERTICAL}
  MDITILE_VERTICAL = 0;       { not in win3.1  }
  {$EXTERNALSYM MDITILE_HORIZONTAL}
  MDITILE_HORIZONTAL = 1;     { not in win3.1  }
  {$EXTERNALSYM MDITILE_SKIPDISABLED}
  MDITILE_SKIPDISABLED = 2;   { not in win3.1  }

type
  PMDICreateStructA = ^TMDICreateStructA;
  PMDICreateStructW = ^TMDICreateStructW;
  PMDICreateStruct = PMDICreateStructA;
  {$EXTERNALSYM tagMDICREATESTRUCTA}
  tagMDICREATESTRUCTA = packed record
    szClass: PAnsiChar;
    szTitle: PAnsiChar;
    hOwner: THandle;
    x: Integer;
    y: Integer;
    cx: Integer;
    cy: Integer;
    style: DWORD;
    lParam: LPARAM;  { app-defined stuff }
  end;
  {$EXTERNALSYM tagMDICREATESTRUCTW}
  tagMDICREATESTRUCTW = packed record
    szClass: PWideChar;
    szTitle: PWideChar;
    hOwner: THandle;
    x: Integer;
    y: Integer;
    cx: Integer;
    cy: Integer;
    style: DWORD;
    lParam: LPARAM;  { app-defined stuff }
  end;
  {$EXTERNALSYM tagMDICREATESTRUCT}
  tagMDICREATESTRUCT = tagMDICREATESTRUCTA;
  TMDICreateStructA = tagMDICREATESTRUCTA;
  TMDICreateStructW = tagMDICREATESTRUCTW;
  TMDICreateStruct = TMDICreateStructA;
  {$EXTERNALSYM MDICREATESTRUCTA}
  MDICREATESTRUCTA = tagMDICREATESTRUCTA;
  {$EXTERNALSYM MDICREATESTRUCTW}
  MDICREATESTRUCTW = tagMDICREATESTRUCTW;
  {$EXTERNALSYM MDICREATESTRUCT}
  MDICREATESTRUCT = MDICREATESTRUCTA;

  PClientCreateStruct = ^TClientCreateStruct;
  {$EXTERNALSYM tagCLIENTCREATESTRUCT}
  tagCLIENTCREATESTRUCT = packed record
    hWindowMenu: THandle;
    idFirstChild: UINT;
  end;
  TClientCreateStruct = tagCLIENTCREATESTRUCT;
  {$EXTERNALSYM CLIENTCREATESTRUCT}
  CLIENTCREATESTRUCT = tagCLIENTCREATESTRUCT;

{$EXTERNALSYM DefFrameProc}
function DefFrameProc(hWnd, hWndMDIClient: HWND; uMsg: UINT; wParam: WPARAM; lParam: LPARAM): LRESULT; stdcall;
{$EXTERNALSYM DefFrameProcA}
function DefFrameProcA(hWnd, hWndMDIClient: HWND; uMsg: UINT; wParam: WPARAM; lParam: LPARAM): LRESULT; stdcall;
{$EXTERNALSYM DefFrameProcW}
function DefFrameProcW(hWnd, hWndMDIClient: HWND; uMsg: UINT; wParam: WPARAM; lParam: LPARAM): LRESULT; stdcall;
{$EXTERNALSYM DefMDIChildProc}
function DefMDIChildProc(hWnd: HWND; uMsg: UINT; wParam: WPARAM; lParam: LPARAM): LRESULT; stdcall;
{$EXTERNALSYM DefMDIChildProcA}
function DefMDIChildProcA(hWnd: HWND; uMsg: UINT; wParam: WPARAM; lParam: LPARAM): LRESULT; stdcall;
{$EXTERNALSYM DefMDIChildProcW}
function DefMDIChildProcW(hWnd: HWND; uMsg: UINT; wParam: WPARAM; lParam: LPARAM): LRESULT; stdcall;
{$EXTERNALSYM TranslateMDISysAccel}
function TranslateMDISysAccel(hWndClient: HWND; const lpMsg: TMsg): BOOL; stdcall;
{$EXTERNALSYM ArrangeIconicWindows}
function ArrangeIconicWindows(hWnd: HWND): UINT; stdcall;
{$EXTERNALSYM CreateMDIWindow}
function CreateMDIWindow(lpClassName, lpWindowName: PChar;
  dwStyle: DWORD; X, Y, nWidth, nHeight: Integer;
  hWndParent: HWND; hInstance: HINST; lParam: LPARAM): HWND; stdcall;
{$EXTERNALSYM CreateMDIWindowA}
function CreateMDIWindowA(lpClassName, lpWindowName: PAnsiChar;
  dwStyle: DWORD; X, Y, nWidth, nHeight: Integer;
  hWndParent: HWND; hInstance: HINST; lParam: LPARAM): HWND; stdcall;
{$EXTERNALSYM CreateMDIWindowW}
function CreateMDIWindowW(lpClassName, lpWindowName: PWideChar;
  dwStyle: DWORD; X, Y, nWidth, nHeight: Integer;
  hWndParent: HWND; hInstance: HINST; lParam: LPARAM): HWND; stdcall;
{$EXTERNALSYM TileWindows}
function TileWindows(hwndParent: HWND; wHow: UINT; lpRect: PRect; cKids: UINT; lpKids: Pointer): Word; stdcall;
{$EXTERNALSYM CascadeWindows}
function CascadeWindows(hwndParent: HWND; wHow: UINT; lpRect: PRect; cKids: UINT; lpKids: Pointer): Word; stdcall;


{ IME class support }

const
  { wParam for WM_IME_CONTROL (removed from 4.0 SDK) }
  {$EXTERNALSYM IMC_GETCANDIDATEPOS}
  IMC_GETCANDIDATEPOS = 7;
  {$EXTERNALSYM IMC_SETCANDIDATEPOS}
  IMC_SETCANDIDATEPOS = 8;
  {$EXTERNALSYM IMC_GETCOMPOSITIONFONT}
  IMC_GETCOMPOSITIONFONT = 9;
  {$EXTERNALSYM IMC_SETCOMPOSITIONFONT}
  IMC_SETCOMPOSITIONFONT = $0A;
  {$EXTERNALSYM IMC_GETCOMPOSITIONWINDOW}
  IMC_GETCOMPOSITIONWINDOW = $0B;
  {$EXTERNALSYM IMC_SETCOMPOSITIONWINDOW}
  IMC_SETCOMPOSITIONWINDOW = $0C;
  {$EXTERNALSYM IMC_GETSTATUSWINDOWPOS}
  IMC_GETSTATUSWINDOWPOS = $0F;
  {$EXTERNALSYM IMC_SETSTATUSWINDOWPOS}
  IMC_SETSTATUSWINDOWPOS = $10;
  {$EXTERNALSYM IMC_CLOSESTATUSWINDOW}
  IMC_CLOSESTATUSWINDOW = $21;
  {$EXTERNALSYM IMC_OPENSTATUSWINDOW}
  IMC_OPENSTATUSWINDOW = $22;

  { wParam of report message WM_IME_NOTIFY (removed from 4.0 SDK) }
  {$EXTERNALSYM IMN_CLOSESTATUSWINDOW}
  IMN_CLOSESTATUSWINDOW = 1;
  {$EXTERNALSYM IMN_OPENSTATUSWINDOW}
  IMN_OPENSTATUSWINDOW = 2;
  {$EXTERNALSYM IMN_CHANGECANDIDATE}
  IMN_CHANGECANDIDATE = 3;
  {$EXTERNALSYM IMN_CLOSECANDIDATE}
  IMN_CLOSECANDIDATE = 4;
  {$EXTERNALSYM IMN_OPENCANDIDATE}
  IMN_OPENCANDIDATE = 5;
  {$EXTERNALSYM IMN_SETCONVERSIONMODE}
  IMN_SETCONVERSIONMODE = 6;
  {$EXTERNALSYM IMN_SETSENTENCEMODE}
  IMN_SETSENTENCEMODE = 7;
  {$EXTERNALSYM IMN_SETOPENSTATUS}
  IMN_SETOPENSTATUS = 8;
  {$EXTERNALSYM IMN_SETCANDIDATEPOS}
  IMN_SETCANDIDATEPOS = 9;
  {$EXTERNALSYM IMN_SETCOMPOSITIONFONT}
  IMN_SETCOMPOSITIONFONT = 10;
  {$EXTERNALSYM IMN_SETCOMPOSITIONWINDOW}
  IMN_SETCOMPOSITIONWINDOW = 11;
  {$EXTERNALSYM IMN_SETSTATUSWINDOWPOS}
  IMN_SETSTATUSWINDOWPOS = 12;
  {$EXTERNALSYM IMN_GUIDELINE}
  IMN_GUIDELINE = 13;
  {$EXTERNALSYM IMN_PRIVATE}
  IMN_PRIVATE = 14;

{ Help support }

type
  {$EXTERNALSYM HELPPOLY}
  HELPPOLY = DWORD;
  PMultiKeyHelpA = ^TMultiKeyHelpA;
  PMultiKeyHelpW = ^TMultiKeyHelpW;
  PMultiKeyHelp = PMultiKeyHelpA;
  {$EXTERNALSYM tagMULTIKEYHELPA}
  tagMULTIKEYHELPA = record
    mkSize: DWORD;
    mkKeylist: AnsiChar;
    szKeyphrase: array[0..0] of AnsiChar;
  end;
  {$EXTERNALSYM tagMULTIKEYHELPW}
  tagMULTIKEYHELPW = record
    mkSize: DWORD;
    mkKeylist: WideChar;
    szKeyphrase: array[0..0] of WideChar;
  end;
  {$EXTERNALSYM tagMULTIKEYHELP}
  tagMULTIKEYHELP = tagMULTIKEYHELPA;
  TMultiKeyHelpA = tagMULTIKEYHELPA;
  TMultiKeyHelpW = tagMULTIKEYHELPW;
  TMultiKeyHelp = TMultiKeyHelpA;
  {$EXTERNALSYM MULTIKEYHELPA}
  MULTIKEYHELPA = tagMULTIKEYHELPA;
  {$EXTERNALSYM MULTIKEYHELPW}
  MULTIKEYHELPW = tagMULTIKEYHELPW;
  {$EXTERNALSYM MULTIKEYHELP}
  MULTIKEYHELP = MULTIKEYHELPA;

  PHelpWinInfoA = ^THelpWinInfoA;
  PHelpWinInfoW = ^THelpWinInfoW;
  PHelpWinInfo = PHelpWinInfoA;
  {$EXTERNALSYM tagHELPWININFOA}
  tagHELPWININFOA = record
    wStructSize: Integer;
    x: Integer;
    y: Integer;
    dx: Integer;
    dy: Integer;
    wMax: Integer;
    rgchMember: array[0..1] of AnsiChar;
  end;
  {$EXTERNALSYM tagHELPWININFOW}
  tagHELPWININFOW = record
    wStructSize: Integer;
    x: Integer;
    y: Integer;
    dx: Integer;
    dy: Integer;
    wMax: Integer;
    rgchMember: array[0..1] of WideChar;
  end;
  {$EXTERNALSYM tagHELPWININFO}
  tagHELPWININFO = tagHELPWININFOA;
  THelpWinInfoA = tagHELPWININFOA;
  THelpWinInfoW = tagHELPWININFOW;
  THelpWinInfo = THelpWinInfoA;
  {$EXTERNALSYM HELPWININFOA}
  HELPWININFOA = tagHELPWININFOA;
  {$EXTERNALSYM HELPWININFOW}
  HELPWININFOW = tagHELPWININFOW;
  {$EXTERNALSYM HELPWININFO}
  HELPWININFO = HELPWININFOA;

const
  { Commands to pass to WinHelp() }
  {$EXTERNALSYM HELP_CONTEXT}
  HELP_CONTEXT = 1;       { Display topic in ulTopic  }
  {$EXTERNALSYM HELP_QUIT}
  HELP_QUIT = 2;          { Terminate help  }
  {$EXTERNALSYM HELP_INDEX}
  HELP_INDEX = 3;         { Display index  }
  {$EXTERNALSYM HELP_CONTENTS}
  HELP_CONTENTS = 3;
  {$EXTERNALSYM HELP_HELPONHELP}
  HELP_HELPONHELP = 4;    { Display help on using help  }
  {$EXTERNALSYM HELP_SETINDEX}
  HELP_SETINDEX = 5;      { Set current Index for multi index help  }
  {$EXTERNALSYM HELP_SETCONTENTS}
  HELP_SETCONTENTS = 5;
  {$EXTERNALSYM HELP_CONTEXTPOPUP}
  HELP_CONTEXTPOPUP = 8;
  {$EXTERNALSYM HELP_FORCEFILE}
  HELP_FORCEFILE = 9;
  {$EXTERNALSYM HELP_KEY}
  HELP_KEY = 257;         { Display topic for keyword in offabData  }
  {$EXTERNALSYM HELP_COMMAND}
  HELP_COMMAND = 258;
  {$EXTERNALSYM HELP_PARTIALKEY}
  HELP_PARTIALKEY = 261;
  {$EXTERNALSYM HELP_MULTIKEY}
  HELP_MULTIKEY = 513;
  {$EXTERNALSYM HELP_SETWINPOS}
  HELP_SETWINPOS = 515;
  {$EXTERNALSYM HELP_CONTEXTMENU}
  HELP_CONTEXTMENU = 10;
  {$EXTERNALSYM HELP_FINDER}
  HELP_FINDER = 11;
  {$EXTERNALSYM HELP_WM_HELP}
  HELP_WM_HELP = 12;
  {$EXTERNALSYM HELP_SETPOPUP_POS}
  HELP_SETPOPUP_POS = 13;

  {$EXTERNALSYM HELP_TCARD}
  HELP_TCARD = $8000;
  {$EXTERNALSYM HELP_TCARD_DATA}
  HELP_TCARD_DATA = $10;
  {$EXTERNALSYM HELP_TCARD_OTHER_CALLER}
  HELP_TCARD_OTHER_CALLER = 17;

  { These are in winhelp.h in Win95. }
  {$EXTERNALSYM IDH_NO_HELP}
  IDH_NO_HELP = 28440;
  {$EXTERNALSYM IDH_MISSING_CONTEXT}
  IDH_MISSING_CONTEXT = 28441;      { Control doesn't have matching help context }
  {$EXTERNALSYM IDH_GENERIC_HELP_BUTTON}
  IDH_GENERIC_HELP_BUTTON = 28442;  { Property sheet help button }
  {$EXTERNALSYM IDH_OK}
  IDH_OK = 28443;
  {$EXTERNALSYM IDH_CANCEL}
  IDH_CANCEL = 28444;
  {$EXTERNALSYM IDH_HELP}
  IDH_HELP = 28445;

{$EXTERNALSYM WinHelp}
function WinHelp(hWndMain: HWND; lpszHelp: PChar; uCommand: UINT; dwData: DWORD): BOOL; stdcall;
{$EXTERNALSYM WinHelpA}
function WinHelpA(hWndMain: HWND; lpszHelp: PAnsiChar; uCommand: UINT; dwData: DWORD): BOOL; stdcall;
{$EXTERNALSYM WinHelpW}
function WinHelpW(hWndMain: HWND; lpszHelp: PWideChar; uCommand: UINT; dwData: DWORD): BOOL; stdcall;

const

{$EXTERNALSYM   HH_DISPLAY_TOPIC      }
  HH_DISPLAY_TOPIC      = 0;
{$EXTERNALSYM   HH_HELP_FINDER         }
  HH_HELP_FINDER         =    0;
{$EXTERNALSYM   HH_DISPLAY_TOC         }
  HH_DISPLAY_TOC         =    1;
{$EXTERNALSYM   HH_DISPLAY_INDEX       }
  HH_DISPLAY_INDEX       =    2;
{$EXTERNALSYM   HH_DISPLAY_SEARCH      }
  HH_DISPLAY_SEARCH      =    3;
{$EXTERNALSYM   HH_SET_WIN_TYPE        }
  HH_SET_WIN_TYPE        =    4;
{$EXTERNALSYM   HH_GET_WIN_TYPE        }
  HH_GET_WIN_TYPE        =    5;
{$EXTERNALSYM   HH_GET_WIN_HANDLE      }
  HH_GET_WIN_HANDLE      =    6;
{$EXTERNALSYM   HH_ENUM_INFO_TYPE      }
  HH_ENUM_INFO_TYPE      =    7;
{$EXTERNALSYM   HH_SET_INFO_TYPE       }
  HH_SET_INFO_TYPE       =    8;
{$EXTERNALSYM   HH_SYNC                }
  HH_SYNC                =    9;
{$EXTERNALSYM   HH_KEYWORD_LOOKUP      }
  HH_KEYWORD_LOOKUP      =   $d;
{$EXTERNALSYM   HH_DISPLAY_TEXT_POPUP  }
  HH_DISPLAY_TEXT_POPUP  =   $e;
{$EXTERNALSYM   HH_HELP_CONTEXT        }
  HH_HELP_CONTEXT        =   $f;
{$EXTERNALSYM   HH_TP_HELP_CONTEXTMENU }
  HH_TP_HELP_CONTEXTMENU =  $10;
{$EXTERNALSYM   HH_TP_HELP_WM_HELP     }
  HH_TP_HELP_WM_HELP     =  $11;
{$EXTERNALSYM   HH_CLOSE_ALL           }
  HH_CLOSE_ALL           =  $12;
{$EXTERNALSYM   HH_ALINK_LOOKUP        }
  HH_ALINK_LOOKUP        =  $13;
{$EXTERNALSYM   HH_GET_LAST_ERROR      }
  HH_GET_LAST_ERROR      =  $14;
{$EXTERNALSYM   HH_ENUM_CATEGORY       }
  HH_ENUM_CATEGORY       =  $15;
{$EXTERNALSYM   HH_ENUM_CATEGORY_IT    }
  HH_ENUM_CATEGORY_IT    =  $16;
{$EXTERNALSYM   HH_RESET_IT_FILTER     }
  HH_RESET_IT_FILTER     =  $17;
{$EXTERNALSYM   HH_SET_INCLUSIVE_FILTER }
  HH_SET_INCLUSIVE_FILTER = $18;
{$EXTERNALSYM   HH_SET_EXCLUSIVE_FILTER }
  HH_SET_EXCLUSIVE_FILTER = $19;
{$EXTERNALSYM   HH_INITIALIZE          }
  HH_INITIALIZE          =  $1c;
{$EXTERNALSYM   HH_UNINITIALIZE        }
  HH_UNINITIALIZE        =  $1d;
{$EXTERNALSYM   HH_SET_QUERYSERVICE    }
  HH_SET_QUERYSERVICE    =  $1e;
{$EXTERNALSYM   HH_PRETRANSLATEMESSAGE }
  HH_PRETRANSLATEMESSAGE =  $fd;
{$EXTERNALSYM   HH_GLOBALPROPERTY      }
  HH_GLOBALPROPERTY      =  $fc;

{$EXTERNALSYM   HHWIN_PROP_TAB_AUTOHIDESHOW }
  HHWIN_PROP_TAB_AUTOHIDESHOW = 1 shl  0;
{$EXTERNALSYM   HHWIN_PROP_ONTOP            }
  HHWIN_PROP_ONTOP            = 1 shl  1;
{$EXTERNALSYM   HHWIN_PROP_NOTITLEBAR       }
  HHWIN_PROP_NOTITLEBAR       = 1 shl  2;
{$EXTERNALSYM   HHWIN_PROP_NODEF_STYLES     }
  HHWIN_PROP_NODEF_STYLES     = 1 shl  3;
{$EXTERNALSYM   HHWIN_PROP_NODEF_EXSTYLES   }
  HHWIN_PROP_NODEF_EXSTYLES   = 1 shl  4;
{$EXTERNALSYM   HHWIN_PROP_TRI_PANE         }
  HHWIN_PROP_TRI_PANE         = 1 shl  5;
{$EXTERNALSYM   HHWIN_PROP_NOTB_TEXT        }
  HHWIN_PROP_NOTB_TEXT        = 1 shl  6;
{$EXTERNALSYM   HHWIN_PROP_POST_QUIT        }
  HHWIN_PROP_POST_QUIT        = 1 shl  7;
{$EXTERNALSYM   HHWIN_PROP_AUTO_SYNC        }
  HHWIN_PROP_AUTO_SYNC        = 1 shl  8;
{$EXTERNALSYM   HHWIN_PROP_TRACKING         }
  HHWIN_PROP_TRACKING         = 1 shl  9;
{$EXTERNALSYM   HHWIN_PROP_TAB_SEARCH       }
  HHWIN_PROP_TAB_SEARCH       = 1 shl 10;
{$EXTERNALSYM   HHWIN_PROP_TAB_HISTORY      }
  HHWIN_PROP_TAB_HISTORY      = 1 shl 11;
{$EXTERNALSYM   HHWIN_PROP_TAB_FAVORITES    }
  HHWIN_PROP_TAB_FAVORITES    = 1 shl 12;
{$EXTERNALSYM   HHWIN_PROP_CHANGE_TITLE     }
  HHWIN_PROP_CHANGE_TITLE     = 1 shl 13;
{$EXTERNALSYM   HHWIN_PROP_NAV_ONLY_WIN     }
  HHWIN_PROP_NAV_ONLY_WIN     = 1 shl 14;
{$EXTERNALSYM   HHWIN_PROP_NO_TOOLBAR       }
  HHWIN_PROP_NO_TOOLBAR       = 1 shl 15;
{$EXTERNALSYM   HHWIN_PROP_MENU             }
  HHWIN_PROP_MENU             = 1 shl 16;
{$EXTERNALSYM   HHWIN_PROP_TAB_ADVSEARCH    }
  HHWIN_PROP_TAB_ADVSEARCH    = 1 shl 17;
{$EXTERNALSYM   HHWIN_PROP_USER_POS         }
  HHWIN_PROP_USER_POS         = 1 shl 18;
{$EXTERNALSYM   HHWIN_PROP_TAB_CUSTOM1      }
  HHWIN_PROP_TAB_CUSTOM1      = 1 shl 19;
{$EXTERNALSYM   HHWIN_PROP_TAB_CUSTOM2      }
  HHWIN_PROP_TAB_CUSTOM2      = 1 shl 20;
{$EXTERNALSYM   HHWIN_PROP_TAB_CUSTOM3      }
  HHWIN_PROP_TAB_CUSTOM3      = 1 shl 21;
{$EXTERNALSYM   HHWIN_PROP_TAB_CUSTOM4      }
  HHWIN_PROP_TAB_CUSTOM4      = 1 shl 22;
{$EXTERNALSYM   HHWIN_PROP_TAB_CUSTOM5      }
  HHWIN_PROP_TAB_CUSTOM5      = 1 shl 23;
{$EXTERNALSYM   HHWIN_PROP_TAB_CUSTOM6      }
  HHWIN_PROP_TAB_CUSTOM6      = 1 shl 24;
{$EXTERNALSYM   HHWIN_PROP_TAB_CUSTOM7      }
  HHWIN_PROP_TAB_CUSTOM7      = 1 shl 25;
{$EXTERNALSYM   HHWIN_PROP_TAB_CUSTOM8      }
  HHWIN_PROP_TAB_CUSTOM8      = 1 shl 26;
{$EXTERNALSYM   HHWIN_PROP_TAB_CUSTOM9      }
  HHWIN_PROP_TAB_CUSTOM9      = 1 shl 27;
{$EXTERNALSYM   HHWIN_PROP_TB_MARGIN        }
  HHWIN_PROP_TB_MARGIN        = 1 shl 28;

{$EXTERNALSYM   HHWIN_PARAM_PROPERTIES      }
  HHWIN_PARAM_PROPERTIES      = 1 shl  1;
{$EXTERNALSYM   HHWIN_PARAM_STYLES          }
  HHWIN_PARAM_STYLES          = 1 shl  2;
{$EXTERNALSYM   HHWIN_PARAM_EXSTYLES        }
  HHWIN_PARAM_EXSTYLES        = 1 shl  3;
{$EXTERNALSYM   HHWIN_PARAM_RECT            }
  HHWIN_PARAM_RECT            = 1 shl  4;
{$EXTERNALSYM   HHWIN_PARAM_NAV_WIDTH       }
  HHWIN_PARAM_NAV_WIDTH       = 1 shl  5;
{$EXTERNALSYM   HHWIN_PARAM_SHOWSTATE       }
  HHWIN_PARAM_SHOWSTATE       = 1 shl  6;
{$EXTERNALSYM   HHWIN_PARAM_INFOTYPES       }
  HHWIN_PARAM_INFOTYPES       = 1 shl  7;
{$EXTERNALSYM   HHWIN_PARAM_TB_FLAGS        }
  HHWIN_PARAM_TB_FLAGS        = 1 shl  8;
{$EXTERNALSYM   HHWIN_PARAM_EXPANSION       }
  HHWIN_PARAM_EXPANSION       = 1 shl  9;
{$EXTERNALSYM   HHWIN_PARAM_TABPOS          }
  HHWIN_PARAM_TABPOS          = 1 shl 10;
{$EXTERNALSYM   HHWIN_PARAM_TABORDER        }
  HHWIN_PARAM_TABORDER        = 1 shl 11;
{$EXTERNALSYM   HHWIN_PARAM_HISTORY_COUNT   }
  HHWIN_PARAM_HISTORY_COUNT   = 1 shl 12;
{$EXTERNALSYM   HHWIN_PARAM_CUR_TAB         }
  HHWIN_PARAM_CUR_TAB         = 1 shl 13;

{$EXTERNALSYM   HHWIN_BUTTON_EXPAND         }
  HHWIN_BUTTON_EXPAND         = 1 shl  1;
{$EXTERNALSYM   HHWIN_BUTTON_BACK           }
  HHWIN_BUTTON_BACK           = 1 shl  2;
{$EXTERNALSYM   HHWIN_BUTTON_FORWARD        }
  HHWIN_BUTTON_FORWARD        = 1 shl  3;
{$EXTERNALSYM   HHWIN_BUTTON_STOP           }
  HHWIN_BUTTON_STOP           = 1 shl  4;
{$EXTERNALSYM   HHWIN_BUTTON_REFRESH        }
  HHWIN_BUTTON_REFRESH        = 1 shl  5;
{$EXTERNALSYM   HHWIN_BUTTON_HOME           }
  HHWIN_BUTTON_HOME           = 1 shl  6;
{$EXTERNALSYM   HHWIN_BUTTON_BROWSE_FWD     }
  HHWIN_BUTTON_BROWSE_FWD     = 1 shl  7;
{$EXTERNALSYM   HHWIN_BUTTON_BROWSE_BCK     }
  HHWIN_BUTTON_BROWSE_BCK     = 1 shl  8;
{$EXTERNALSYM   HHWIN_BUTTON_NOTES          }
  HHWIN_BUTTON_NOTES          = 1 shl  9;
{$EXTERNALSYM   HHWIN_BUTTON_CONTENTS       }
  HHWIN_BUTTON_CONTENTS       = 1 shl 10;
{$EXTERNALSYM   HHWIN_BUTTON_SYNC           }
  HHWIN_BUTTON_SYNC           = 1 shl 11;
{$EXTERNALSYM   HHWIN_BUTTON_OPTIONS        }
  HHWIN_BUTTON_OPTIONS        = 1 shl 12;
{$EXTERNALSYM   HHWIN_BUTTON_PRINT          }
  HHWIN_BUTTON_PRINT          = 1 shl 13;
{$EXTERNALSYM   HHWIN_BUTTON_INDEX          }
  HHWIN_BUTTON_INDEX          = 1 shl 14;
{$EXTERNALSYM   HHWIN_BUTTON_SEARCH         }
  HHWIN_BUTTON_SEARCH         = 1 shl 15;
{$EXTERNALSYM   HHWIN_BUTTON_HISTORY        }
  HHWIN_BUTTON_HISTORY        = 1 shl 16;
{$EXTERNALSYM   HHWIN_BUTTON_FAVORITES      }
  HHWIN_BUTTON_FAVORITES      = 1 shl 17;
{$EXTERNALSYM   HHWIN_BUTTON_JUMP1          }
  HHWIN_BUTTON_JUMP1          = 1 shl 18;
{$EXTERNALSYM   HHWIN_BUTTON_JUMP2          }
  HHWIN_BUTTON_JUMP2          = 1 shl 19;
{$EXTERNALSYM   HHWIN_BUTTON_ZOOM           }
  HHWIN_BUTTON_ZOOM           = 1 shl 20;
{$EXTERNALSYM   HHWIN_BUTTON_TOC_NEXT       }
  HHWIN_BUTTON_TOC_NEXT       = 1 shl 21;
{$EXTERNALSYM   HHWIN_BUTTON_TOC_PREV       }
  HHWIN_BUTTON_TOC_PREV       = 1 shl 22;

{$EXTERNALSYM   HHWIN_DEF_BUTTONS }
  HHWIN_DEF_BUTTONS = HHWIN_BUTTON_EXPAND or HHWIN_BUTTON_BACK or HHWIN_BUTTON_OPTIONS or HHWIN_BUTTON_PRINT;

{$EXTERNALSYM   IDTB_EXPAND      }
  IDTB_EXPAND      = 200;
{$EXTERNALSYM   IDTB_CONTRACT    }
  IDTB_CONTRACT    = 201;
{$EXTERNALSYM   IDTB_STOP        }
  IDTB_STOP        = 202;
{$EXTERNALSYM   IDTB_REFRESH     }
  IDTB_REFRESH     = 203;
{$EXTERNALSYM   IDTB_BACK        }
  IDTB_BACK        = 204;
{$EXTERNALSYM   IDTB_HOME        }
  IDTB_HOME        = 205;
{$EXTERNALSYM   IDTB_SYNC        }
  IDTB_SYNC        = 206;
{$EXTERNALSYM   IDTB_PRINT       }
  IDTB_PRINT       = 207;
{$EXTERNALSYM   IDTB_OPTIONS     }
  IDTB_OPTIONS     = 208;
{$EXTERNALSYM   IDTB_FORWARD     }
  IDTB_FORWARD     = 209;
{$EXTERNALSYM   IDTB_NOTES       }
  IDTB_NOTES       = 210;
{$EXTERNALSYM   IDTB_BROWSE_FWD  }
  IDTB_BROWSE_FWD  = 211;
{$EXTERNALSYM   IDTB_BROWSE_BACK }
  IDTB_BROWSE_BACK = 212;
{$EXTERNALSYM   IDTB_CONTENTS    }
  IDTB_CONTENTS    = 213;
{$EXTERNALSYM   IDTB_INDEX       }
  IDTB_INDEX       = 214;
{$EXTERNALSYM   IDTB_SEARCH      }
  IDTB_SEARCH      = 215;
{$EXTERNALSYM   IDTB_HISTORY     }
  IDTB_HISTORY     = 216;
{$EXTERNALSYM   IDTB_FAVORITES   }
  IDTB_FAVORITES   = 217;
{$EXTERNALSYM   IDTB_JUMP1       }
  IDTB_JUMP1       = 218;
{$EXTERNALSYM   IDTB_JUMP2       }
  IDTB_JUMP2       = 219;
{$EXTERNALSYM   IDTB_CUSTOMIZE   }
  IDTB_CUSTOMIZE   = 221;
{$EXTERNALSYM   IDTB_ZOOM        }
  IDTB_ZOOM        = 222;
{$EXTERNALSYM   IDTB_TOC_NEXT    }
  IDTB_TOC_NEXT    = 223;
{$EXTERNALSYM   IDTB_TOC_PREV    }
  IDTB_TOC_PREV    = 224;

{$EXTERNALSYM   HHN_FIRST         }
  HHN_FIRST         =       0 - 860;
{$EXTERNALSYM   HHN_LAST          }
  HHN_LAST          =       0 - 879;
{$EXTERNALSYM   HHN_NACVOMPLITE   }
  HHN_NACVOMPLITE   = HHN_FIRST - 0;
{$EXTERNALSYM   HHN_TRACK         }
  HHN_TRACK         = HHN_FIRST - 1;
{$EXTERNALSYM   HHN_WINDOW_CREATE }
  HHN_WINDOW_CREATE = HHN_FIRST - 2;

type

  PHHN_Notify = ^THHN_Notify;

  _HHN_NOTIFY = packed record
    hdr: TNMHDR;
    pszUrl: PChar;
  end;

  THHN_Notify = _HHN_NOTIFY;
  {$EXTERNALSYM HHN_NOTIFY}
  HHN_NOTIFY = _HHN_NOTIFY;

  PHH_POPUP = ^THH_Popup;

  _HH_POPUP = packed record
    cbStruct: Integer;
    hInst: HINST;
    idString: UINT;
    pszText : PChar;
    pt : TPoint;
    clrForeground: TColorRef;
    clrBackground: TColorRef;
    rcMargins: TRect;
    pszFont: PChar;
  end;

  THH_Popup = _HH_POPUP;
  {$EXTERNALSYM HH_POPUP}
  HH_POPUP = _HH_POPUP;

  PHH_AKLINK = ^THH_AKLink;

  _HH_AKLINK = packed record
    cbStruct: Integer;
    fReserved: Boolean; { must be FALSE }
    pszKeywords: PChar;
    pszUrl: PChar;
    pszMsgText: PChar;
    pszMsgTitle: PChar;
    pszWindow: PChar;
    fIndexOnFail: Boolean;
  end;

  THH_AKLink = _HH_AKLINK;
  {$EXTERNALSYM HH_AKLINK}
  HH_AKLINK = _HH_AKLINK;

  PHH_Enum_It = ^THH_Enum_It;

  _HH_ENUM_IT = packed record
    cbStruct: Integer;
    iType: Integer;
    pszCatName: PChar;
    pszITName: PChar;
    pszItDescription: PChar;
  end;

  THH_Enum_it = _HH_ENUM_IT;
  {$EXTERNALSYM HH_ENUM_IT}
  HH_ENUM_IT = _HH_ENUM_IT;

  PHH_Enum_Cat = ^THH_Enum_Cat;

  _HH_ENUM_CAT = packed record
    cbStruct: Integer;
    pszCatName: PChar;
    pszCatDescription: PChar;
  end;

  THH_Enum_Cat = _HH_ENUM_CAT;
  {$EXTERNALSYM HH_ENUM_CAT}
  HH_ENUM_CAT = _HH_ENUM_CAT;

  PHH_Set_Infotype = ^THH_Set_Infotype;

  _HH_SET_INFOTYPE = packed record
    cbStruct: Integer;
    pszCatName: PChar;
    pszInfoTypeName: PChar;
  end;

  THH_Set_Infotype = _HH_SET_INFOTYPE;
  {$EXTERNALSYM HH_SET_INFOTYPE}
  HH_SET_INFOTYPE = _HH_SET_INFOTYPE;

  PHH_Infotype = ^THH_Infotype;
  THH_Infotype = Dword;
  {$EXTERNALSYM HH_INFOTYPE}
  HH_INFOTYPE = THH_Infotype;

  PHH_Fts_Query = ^THH_Fts_Query;
  
  _HH_FTS_QUERY = packed record
    cbStruct: Integer;
    fUniCodeStrings: Boolean;
    pszSearchQuery: PChar;
    iProximity: longint;
    fStemmedSearch: Boolean;
    fTitleOnly: Boolean;
    fExecute: Boolean;
    pszWindow: PChar;
  end;

  THH_Fts_Query = _HH_FTS_QUERY;
  {$EXTERNALSYM HH_FTS_QUERY}
  HH_FTS_QUERY = _HH_FTS_QUERY;

  PHH_Wintype = ^THH_Wintype;
  
  _HH_WINTYPE = packed record
    cbStruct: Integer;
    fUniCodeStrings: Boolean;
    pszType: PChar;
    fsValidMembers: DWord;
    fsWinProperties: DWord;
    pszCaption: PChar;
    dwStyles: DWord;
    dwExStyles: DWord;
    rcWindowPos: TRect;
    nShowState: Integer;
    hwndHelp: HWND;
    hwndCaller: HWND;
    paInfoTypes: PHH_Infotype;
    hwndToolBar: HWND;
    hwndNavigation: HWND;
    hwndHTML: HWND;
    iNavWidth: Integer;
    rcHTML: TRect;
    pszToc: PChar;
    pszIndex: PChar;
    pszFile: PChar;
    pszHome: PChar;
    fsToolBarFlags: DWord;
    fNotExpanded: Boolean;
    curNavType: Integer;
    tabPos: Integer;
    idNotify: Integer;
    tabOrder: array[0..18] of Byte;
    cHistory: Integer;
    pszJump1: PChar;
    pszJump2: PChar;
    pszUrlJump1: PChar;
    pszUrlJump2: PChar;
    rcMinSize: TRect;
    cbInfoTYpes: Integer;
    pszCustomTabs: Integer;
  end;

  THH_WINTYPE = _HH_WINTYPE;
  {$EXTERNALSYM HH_WINTYPE}
  HH_WINTYPE = _HH_WINTYPE;

  PHH_NTrack = ^THH_NTrack;

  _HH_NTRACK = packed record
    hdr : TNMHdr;
    pszCurUrl: PChar;
    idAction: Integer;
  end;

  THH_NTrack = _HH_NTRACK;
  {$EXTERNALSYM HH_NTRACK}
  HH_NTRACK = _HH_NTRACK;

{$EXTERNALSYM HtmlHelp}
function HtmlHelp(hWndCaller: HWND; pszFile: PChar; uCommand: UINT; dwData: DWORD): HWND;
{$EXTERNALSYM HtmlHelpA}
function HtmlHelpA(hWndCaller: HWND; pszFile: PAnsiChar; uCommand: UINT; dwData: DWORD): HWND;
{$EXTERNALSYM HtmlHelpW}
function HtmlHelpW(hWndCaller: HWND; pszFile: PWideChar; uCommand: UINT; dwData: DWORD): HWND;

const
  {$EXTERNALSYM GR_GDIOBJECTS}
  GR_GDIOBJECTS = 0;    { Count of GDI objects }
  {$EXTERNALSYM GR_USEROBJECTS}
  GR_USEROBJECTS = 1;    { Count of USER objects }

{$EXTERNALSYM GetGuiResources}
function GetGuiResources(hProcess: THandle; uiFlags: DWORD): DWORD; stdcall;

const
  { Parameter for SystemParametersInfo() }
  {$EXTERNALSYM SPI_GETBEEP}
  SPI_GETBEEP = 1;
  {$EXTERNALSYM SPI_SETBEEP}
  SPI_SETBEEP = 2;
  {$EXTERNALSYM SPI_GETMOUSE}
  SPI_GETMOUSE = 3;
  {$EXTERNALSYM SPI_SETMOUSE}
  SPI_SETMOUSE = 4;
  {$EXTERNALSYM SPI_GETBORDER}
  SPI_GETBORDER = 5;
  {$EXTERNALSYM SPI_SETBORDER}
  SPI_SETBORDER = 6;
  {$EXTERNALSYM SPI_GETKEYBOARDSPEED}
  SPI_GETKEYBOARDSPEED = 10;
  {$EXTERNALSYM SPI_SETKEYBOARDSPEED}
  SPI_SETKEYBOARDSPEED = 11;
  {$EXTERNALSYM SPI_LANGDRIVER}
  SPI_LANGDRIVER = 12;
  {$EXTERNALSYM SPI_ICONHORIZONTALSPACING}
  SPI_ICONHORIZONTALSPACING = 13;
  {$EXTERNALSYM SPI_GETSCREENSAVETIMEOUT}
  SPI_GETSCREENSAVETIMEOUT = 14;
  {$EXTERNALSYM SPI_SETSCREENSAVETIMEOUT}
  SPI_SETSCREENSAVETIMEOUT = 15;
  {$EXTERNALSYM SPI_GETSCREENSAVEACTIVE}
  SPI_GETSCREENSAVEACTIVE = $10;
  {$EXTERNALSYM SPI_SETSCREENSAVEACTIVE}
  SPI_SETSCREENSAVEACTIVE = 17;
  {$EXTERNALSYM SPI_GETGRIDGRANULARITY}
  SPI_GETGRIDGRANULARITY = 18;
  {$EXTERNALSYM SPI_SETGRIDGRANULARITY}
  SPI_SETGRIDGRANULARITY = 19;
  {$EXTERNALSYM SPI_SETDESKWALLPAPER}
  SPI_SETDESKWALLPAPER = 20;
  {$EXTERNALSYM SPI_SETDESKPATTERN}
  SPI_SETDESKPATTERN = 21;
  {$EXTERNALSYM SPI_GETKEYBOARDDELAY}
  SPI_GETKEYBOARDDELAY = 22;
  {$EXTERNALSYM SPI_SETKEYBOARDDELAY}
  SPI_SETKEYBOARDDELAY = 23;
  {$EXTERNALSYM SPI_ICONVERTICALSPACING}
  SPI_ICONVERTICALSPACING = 24;
  {$EXTERNALSYM SPI_GETICONTITLEWRAP}
  SPI_GETICONTITLEWRAP = 25;
  {$EXTERNALSYM SPI_SETICONTITLEWRAP}
  SPI_SETICONTITLEWRAP = 26;
  {$EXTERNALSYM SPI_GETMENUDROPALIGNMENT}
  SPI_GETMENUDROPALIGNMENT = 27;
  {$EXTERNALSYM SPI_SETMENUDROPALIGNMENT}
  SPI_SETMENUDROPALIGNMENT = 28;
  {$EXTERNALSYM SPI_SETDOUBLECLKWIDTH}
  SPI_SETDOUBLECLKWIDTH = 29;
  {$EXTERNALSYM SPI_SETDOUBLECLKHEIGHT}
  SPI_SETDOUBLECLKHEIGHT = 30;
  {$EXTERNALSYM SPI_GETICONTITLELOGFONT}
  SPI_GETICONTITLELOGFONT = 31;
  {$EXTERNALSYM SPI_SETDOUBLECLICKTIME}
  SPI_SETDOUBLECLICKTIME = $20;
  {$EXTERNALSYM SPI_SETMOUSEBUTTONSWAP}
  SPI_SETMOUSEBUTTONSWAP = 33;
  {$EXTERNALSYM SPI_SETICONTITLELOGFONT}
  SPI_SETICONTITLELOGFONT = 34;
  {$EXTERNALSYM SPI_GETFASTTASKSWITCH}
  SPI_GETFASTTASKSWITCH = 35;
  {$EXTERNALSYM SPI_SETFASTTASKSWITCH}
  SPI_SETFASTTASKSWITCH = 36;
  {$EXTERNALSYM SPI_SETDRAGFULLWINDOWS}
  SPI_SETDRAGFULLWINDOWS = 37;
  {$EXTERNALSYM SPI_GETDRAGFULLWINDOWS}
  SPI_GETDRAGFULLWINDOWS = 38;
  {$EXTERNALSYM SPI_GETNONCLIENTMETRICS}
  SPI_GETNONCLIENTMETRICS = 41;
  {$EXTERNALSYM SPI_SETNONCLIENTMETRICS}
  SPI_SETNONCLIENTMETRICS = 42;
  {$EXTERNALSYM SPI_GETMINIMIZEDMETRICS}
  SPI_GETMINIMIZEDMETRICS = 43;
  {$EXTERNALSYM SPI_SETMINIMIZEDMETRICS}
  SPI_SETMINIMIZEDMETRICS = 44;
  {$EXTERNALSYM SPI_GETICONMETRICS}
  SPI_GETICONMETRICS = 45;
  {$EXTERNALSYM SPI_SETICONMETRICS}
  SPI_SETICONMETRICS = 46;
  {$EXTERNALSYM SPI_SETWORKAREA}
  SPI_SETWORKAREA = 47;
  {$EXTERNALSYM SPI_GETWORKAREA}
  SPI_GETWORKAREA = 48;
  {$EXTERNALSYM SPI_SETPENWINDOWS}
  SPI_SETPENWINDOWS = 49;

  {$EXTERNALSYM SPI_GETHIGHCONTRAST}
  SPI_GETHIGHCONTRAST = 66;
  {$EXTERNALSYM SPI_SETHIGHCONTRAST}
  SPI_SETHIGHCONTRAST = 67;
  {$EXTERNALSYM SPI_GETKEYBOARDPREF}
  SPI_GETKEYBOARDPREF = 68;
  {$EXTERNALSYM SPI_SETKEYBOARDPREF}
  SPI_SETKEYBOARDPREF = 69;
  {$EXTERNALSYM SPI_GETSCREENREADER}
  SPI_GETSCREENREADER = 70;
  {$EXTERNALSYM SPI_SETSCREENREADER}
  SPI_SETSCREENREADER = 71;
  {$EXTERNALSYM SPI_GETANIMATION}
  SPI_GETANIMATION = 72;
  {$EXTERNALSYM SPI_SETANIMATION}
  SPI_SETANIMATION = 73;
  {$EXTERNALSYM SPI_GETFONTSMOOTHING}
  SPI_GETFONTSMOOTHING = 74;
  {$EXTERNALSYM SPI_SETFONTSMOOTHING}
  SPI_SETFONTSMOOTHING = 75;
  {$EXTERNALSYM SPI_SETDRAGWIDTH}
  SPI_SETDRAGWIDTH = 76;
  {$EXTERNALSYM SPI_SETDRAGHEIGHT}
  SPI_SETDRAGHEIGHT = 77;
  {$EXTERNALSYM SPI_SETHANDHELD}
  SPI_SETHANDHELD = 78;
  {$EXTERNALSYM SPI_GETLOWPOWERTIMEOUT}
  SPI_GETLOWPOWERTIMEOUT = 79;
  {$EXTERNALSYM SPI_GETPOWEROFFTIMEOUT}
  SPI_GETPOWEROFFTIMEOUT = 80;
  {$EXTERNALSYM SPI_SETLOWPOWERTIMEOUT}
  SPI_SETLOWPOWERTIMEOUT = 81;
  {$EXTERNALSYM SPI_SETPOWEROFFTIMEOUT}
  SPI_SETPOWEROFFTIMEOUT = 82;
  {$EXTERNALSYM SPI_GETLOWPOWERACTIVE}
  SPI_GETLOWPOWERACTIVE = 83;
  {$EXTERNALSYM SPI_GETPOWEROFFACTIVE}
  SPI_GETPOWEROFFACTIVE = 84;
  {$EXTERNALSYM SPI_SETLOWPOWERACTIVE}
  SPI_SETLOWPOWERACTIVE = 85;
  {$EXTERNALSYM SPI_SETPOWEROFFACTIVE}
  SPI_SETPOWEROFFACTIVE = 86;
  {$EXTERNALSYM SPI_SETCURSORS}
  SPI_SETCURSORS = 87;
  {$EXTERNALSYM SPI_SETICONS}
  SPI_SETICONS = 88;
  {$EXTERNALSYM SPI_GETDEFAULTINPUTLANG}
  SPI_GETDEFAULTINPUTLANG = 89;
  {$EXTERNALSYM SPI_SETDEFAULTINPUTLANG}
  SPI_SETDEFAULTINPUTLANG = 90;
  {$EXTERNALSYM SPI_SETLANGTOGGLE}
  SPI_SETLANGTOGGLE = 91;
  {$EXTERNALSYM SPI_GETWINDOWSEXTENSION}
  SPI_GETWINDOWSEXTENSION = 92;
  {$EXTERNALSYM SPI_SETMOUSETRAILS}
  SPI_SETMOUSETRAILS = 93;
  {$EXTERNALSYM SPI_GETMOUSETRAILS}
  SPI_GETMOUSETRAILS = 94;
  {$EXTERNALSYM SPI_SCREENSAVERRUNNING}
  SPI_SCREENSAVERRUNNING = 97;
  {$EXTERNALSYM SPI_GETFILTERKEYS}
  SPI_GETFILTERKEYS = 50;
  {$EXTERNALSYM SPI_SETFILTERKEYS}
  SPI_SETFILTERKEYS = 51;
  {$EXTERNALSYM SPI_GETTOGGLEKEYS}
  SPI_GETTOGGLEKEYS = 52;
  {$EXTERNALSYM SPI_SETTOGGLEKEYS}
  SPI_SETTOGGLEKEYS = 53;
  {$EXTERNALSYM SPI_GETMOUSEKEYS}
  SPI_GETMOUSEKEYS = 54;
  {$EXTERNALSYM SPI_SETMOUSEKEYS}
  SPI_SETMOUSEKEYS = 55;
  {$EXTERNALSYM SPI_GETSHOWSOUNDS}
  SPI_GETSHOWSOUNDS = 56;
  {$EXTERNALSYM SPI_SETSHOWSOUNDS}
  SPI_SETSHOWSOUNDS = 57;
  {$EXTERNALSYM SPI_GETSTICKYKEYS}
  SPI_GETSTICKYKEYS = 58;
  {$EXTERNALSYM SPI_SETSTICKYKEYS}
  SPI_SETSTICKYKEYS = 59;
  {$EXTERNALSYM SPI_GETACCESSTIMEOUT}
  SPI_GETACCESSTIMEOUT = 60;
  {$EXTERNALSYM SPI_SETACCESSTIMEOUT}
  SPI_SETACCESSTIMEOUT = 61;
  {$EXTERNALSYM SPI_GETSERIALKEYS}
  SPI_GETSERIALKEYS = 62;
  {$EXTERNALSYM SPI_SETSERIALKEYS}
  SPI_SETSERIALKEYS = 63;
  {$EXTERNALSYM SPI_GETSOUNDSENTRY}
  SPI_GETSOUNDSENTRY = 64;
  {$EXTERNALSYM SPI_SETSOUNDSENTRY}
  SPI_SETSOUNDSENTRY = 65;

  {$EXTERNALSYM SPI_GETSNAPTODEFBUTTON}
  SPI_GETSNAPTODEFBUTTON = 95;
  {$EXTERNALSYM SPI_SETSNAPTODEFBUTTON}
  SPI_SETSNAPTODEFBUTTON = 96;
  {$EXTERNALSYM SPI_GETMOUSEHOVERWIDTH}
  SPI_GETMOUSEHOVERWIDTH = 98;
  {$EXTERNALSYM SPI_SETMOUSEHOVERWIDTH}
  SPI_SETMOUSEHOVERWIDTH = 99;
  {$EXTERNALSYM SPI_GETMOUSEHOVERHEIGHT}
  SPI_GETMOUSEHOVERHEIGHT = 100;
  {$EXTERNALSYM SPI_SETMOUSEHOVERHEIGHT}
  SPI_SETMOUSEHOVERHEIGHT = 101;
  {$EXTERNALSYM SPI_GETMOUSEHOVERTIME}
  SPI_GETMOUSEHOVERTIME = 102;
  {$EXTERNALSYM SPI_SETMOUSEHOVERTIME}
  SPI_SETMOUSEHOVERTIME = 103;
  {$EXTERNALSYM SPI_GETWHEELSCROLLLINES}
  SPI_GETWHEELSCROLLLINES = 104;
  {$EXTERNALSYM SPI_SETWHEELSCROLLLINES}
  SPI_SETWHEELSCROLLLINES = 105;         // For Win95 and WinNT3.51,
                                         // Mswheel broadcasts the message
                                         // WM_SETTINGCHANGE (equivalent to
                                         // WM_WININICHANGE) when the scroll
                                         // lines has changed.  Applications
                                         // will receive the WM_SETTINGCHANGE
                                         // message with the wParam set to
                                         // SPI_SETWHEELSCROLLLINES.  When
                                         // this message is received the
                                         // application should query Mswheel for
                                         // the new setting.
  {$EXTERNALSYM SPI_GETMENUSHOWDELAY}
  SPI_GETMENUSHOWDELAY = 106;
  {$EXTERNALSYM SPI_SETMENUSHOWDELAY}
  SPI_SETMENUSHOWDELAY = 107;
  {$EXTERNALSYM SPI_GETSHOWIMEUI}
  SPI_GETSHOWIMEUI = 110;
  {$EXTERNALSYM SPI_SETSHOWIMEUI}
  SPI_SETSHOWIMEUI = 111;
  {$EXTERNALSYM SPI_GETMOUSESPEED}
  SPI_GETMOUSESPEED = 112;
  {$EXTERNALSYM SPI_SETMOUSESPEED}
  SPI_SETMOUSESPEED = 113;
  {$EXTERNALSYM SPI_GETSCREENSAVERRUNNING}
  SPI_GETSCREENSAVERRUNNING = 114;

  {$EXTERNALSYM SPI_GETACTIVEWINDOWTRACKING}
  SPI_GETACTIVEWINDOWTRACKING = $1000;
  {$EXTERNALSYM SPI_SETACTIVEWINDOWTRACKING}
  SPI_SETACTIVEWINDOWTRACKING = $1001;
  {$EXTERNALSYM SPI_GETMENUANIMATION}
  SPI_GETMENUANIMATION = $1002;
  {$EXTERNALSYM SPI_SETMENUANIMATION}
  SPI_SETMENUANIMATION = $1003;
  {$EXTERNALSYM SPI_GETCOMBOBOXANIMATION}
  SPI_GETCOMBOBOXANIMATION = $1004;
  {$EXTERNALSYM SPI_SETCOMBOBOXANIMATION}
  SPI_SETCOMBOBOXANIMATION = $1005;
  {$EXTERNALSYM SPI_GETLISTBOXSMOOTHSCROLLING}
  SPI_GETLISTBOXSMOOTHSCROLLING = $1006;
  {$EXTERNALSYM SPI_SETLISTBOXSMOOTHSCROLLING}
  SPI_SETLISTBOXSMOOTHSCROLLING = $1007;
  {$EXTERNALSYM SPI_GETGRADIENTCAPTIONS}
  SPI_GETGRADIENTCAPTIONS = $1008;
  {$EXTERNALSYM SPI_SETGRADIENTCAPTIONS}
  SPI_SETGRADIENTCAPTIONS = $1009;
  {$EXTERNALSYM SPI_GETKEYBOARDCUES}
  SPI_GETKEYBOARDCUES = $100A;
  {$EXTERNALSYM SPI_SETKEYBOARDCUES}
  SPI_SETKEYBOARDCUES = $100B;
  {$EXTERNALSYM SPI_GETMENUUNDERLINES}
  SPI_GETMENUUNDERLINES = SPI_GETKEYBOARDCUES;
  {$EXTERNALSYM SPI_SETMENUUNDERLINES}
  SPI_SETMENUUNDERLINES = SPI_SETKEYBOARDCUES;
  {$EXTERNALSYM SPI_GETACTIVEWNDTRKZORDER}
  SPI_GETACTIVEWNDTRKZORDER = $100C;
  {$EXTERNALSYM SPI_SETACTIVEWNDTRKZORDER}
  SPI_SETACTIVEWNDTRKZORDER = $100D;
  {$EXTERNALSYM SPI_GETHOTTRACKING}
  SPI_GETHOTTRACKING = $100E;
  {$EXTERNALSYM SPI_SETHOTTRACKING}
  SPI_SETHOTTRACKING = $100F;

  {$EXTERNALSYM SPI_GETMENUFADE}
  SPI_GETMENUFADE = $1012;
  {$EXTERNALSYM SPI_SETMENUFADE}
  SPI_SETMENUFADE = $1013;
  {$EXTERNALSYM SPI_GETSELECTIONFADE}
  SPI_GETSELECTIONFADE = $1014;
  {$EXTERNALSYM SPI_SETSELECTIONFADE}
  SPI_SETSELECTIONFADE = $1015;
  {$EXTERNALSYM SPI_GETTOOLTIPANIMATION}
  SPI_GETTOOLTIPANIMATION = $1016;
  {$EXTERNALSYM SPI_SETTOOLTIPANIMATION}
  SPI_SETTOOLTIPANIMATION = $1017;
  {$EXTERNALSYM SPI_GETTOOLTIPFADE}
  SPI_GETTOOLTIPFADE = $1018;
  {$EXTERNALSYM SPI_SETTOOLTIPFADE}
  SPI_SETTOOLTIPFADE = $1019;
  {$EXTERNALSYM SPI_GETCURSORSHADOW}
  SPI_GETCURSORSHADOW = $101A;
  {$EXTERNALSYM SPI_SETCURSORSHADOW}
  SPI_SETCURSORSHADOW = $101B;

  {$EXTERNALSYM SPI_GETMOUSESONAR}
  SPI_GETMOUSESONAR = $101C;
  {$EXTERNALSYM SPI_SETMOUSESONAR}
  SPI_SETMOUSESONAR = $101D;
  {$EXTERNALSYM SPI_GETMOUSECLICKLOCK}
  SPI_GETMOUSECLICKLOCK = $101E;
  {$EXTERNALSYM SPI_SETMOUSECLICKLOCK}
  SPI_SETMOUSECLICKLOCK = $101F;
  {$EXTERNALSYM SPI_GETMOUSEVANISH}
  SPI_GETMOUSEVANISH = $1020;
  {$EXTERNALSYM SPI_SETMOUSEVANISH}
  SPI_SETMOUSEVANISH = $1021;
  {$EXTERNALSYM SPI_GETFLATMENU}
  SPI_GETFLATMENU = $1022;
  {$EXTERNALSYM SPI_SETFLATMENU}
  SPI_SETFLATMENU = $1023;
  {$EXTERNALSYM SPI_GETDROPSHADOW}
  SPI_GETDROPSHADOW = $1024;
  {$EXTERNALSYM SPI_SETDROPSHADOW}
  SPI_SETDROPSHADOW = $1025;

  {$EXTERNALSYM SPI_GETUIEFFECTS}
  SPI_GETUIEFFECTS = $103E;
  {$EXTERNALSYM SPI_SETUIEFFECTS}
  SPI_SETUIEFFECTS = $103F;

  {$EXTERNALSYM SPI_GETFOREGROUNDLOCKTIMEOUT}
  SPI_GETFOREGROUNDLOCKTIMEOUT = $2000;
  {$EXTERNALSYM SPI_SETFOREGROUNDLOCKTIMEOUT}
  SPI_SETFOREGROUNDLOCKTIMEOUT = $2001;
  {$EXTERNALSYM SPI_GETACTIVEWNDTRKTIMEOUT}
  SPI_GETACTIVEWNDTRKTIMEOUT = $2002;
  {$EXTERNALSYM SPI_SETACTIVEWNDTRKTIMEOUT}
  SPI_SETACTIVEWNDTRKTIMEOUT = $2003;
  {$EXTERNALSYM SPI_GETFOREGROUNDFLASHCOUNT}
  SPI_GETFOREGROUNDFLASHCOUNT = $2004;
  {$EXTERNALSYM SPI_SETFOREGROUNDFLASHCOUNT}
  SPI_SETFOREGROUNDFLASHCOUNT = $2005;
  {$EXTERNALSYM SPI_GETCARETWIDTH}
  SPI_GETCARETWIDTH = $2006;
  {$EXTERNALSYM SPI_SETCARETWIDTH}
  SPI_SETCARETWIDTH = $2007;
  {$EXTERNALSYM SPI_GETMOUSECLICKLOCKTIME}
  SPI_GETMOUSECLICKLOCKTIME = $2008;
  {$EXTERNALSYM SPI_SETMOUSECLICKLOCKTIME}
  SPI_SETMOUSECLICKLOCKTIME = $2009;
  {$EXTERNALSYM SPI_GETFONTSMOOTHINGTYPE}
  SPI_GETFONTSMOOTHINGTYPE = $200A;
  {$EXTERNALSYM SPI_SETFONTSMOOTHINGTYPE}
  SPI_SETFONTSMOOTHINGTYPE = $200B;

  { constants for SPI_GETFONTSMOOTHINGTYPE and SPI_SETFONTSMOOTHINGTYPE: }
  {$EXTERNALSYM FE_FONTSMOOTHINGSTANDARD}
  FE_FONTSMOOTHINGSTANDARD = $0001;
  {$EXTERNALSYM FE_FONTSMOOTHINGCLEARTYPE}
  FE_FONTSMOOTHINGCLEARTYPE = $0002;
  {$EXTERNALSYM FE_FONTSMOOTHINGDOCKING}
  FE_FONTSMOOTHINGDOCKING = $8000;

  {$EXTERNALSYM SPI_GETFONTSMOOTHINGCONTRAST}
  SPI_GETFONTSMOOTHINGCONTRAST = $200C;
  {$EXTERNALSYM SPI_SETFONTSMOOTHINGCONTRAST}
  SPI_SETFONTSMOOTHINGCONTRAST = $200D;
  {$EXTERNALSYM SPI_GETFOCUSBORDERWIDTH}
  SPI_GETFOCUSBORDERWIDTH = $200E;
  {$EXTERNALSYM SPI_SETFOCUSBORDERWIDTH}
  SPI_SETFOCUSBORDERWIDTH = $200F;
  {$EXTERNALSYM SPI_GETFOCUSBORDERHEIGHT}
  SPI_GETFOCUSBORDERHEIGHT = $2010;
  {$EXTERNALSYM SPI_SETFOCUSBORDERHEIGHT}
  SPI_SETFOCUSBORDERHEIGHT = $2011;

  { Flags }
  {$EXTERNALSYM SPIF_UPDATEINIFILE}
  SPIF_UPDATEINIFILE = 1;
  {$EXTERNALSYM SPIF_SENDWININICHANGE}
  SPIF_SENDWININICHANGE = 2;
  {$EXTERNALSYM SPIF_SENDCHANGE}
  SPIF_SENDCHANGE = SPIF_SENDWININICHANGE;

  {$EXTERNALSYM METRICS_USEDEFAULT}
  METRICS_USEDEFAULT = LongWord(-1);

type
  PNonClientMetricsA = ^TNonClientMetricsA;
  PNonClientMetricsW = ^TNonClientMetricsW;
  PNonClientMetrics = PNonClientMetricsA;
  {$EXTERNALSYM tagNONCLIENTMETRICSA}
  tagNONCLIENTMETRICSA = packed record
    cbSize: UINT;
    iBorderWidth: Integer;
    iScrollWidth: Integer;
    iScrollHeight: Integer;
    iCaptionWidth: Integer;
    iCaptionHeight: Integer;
    lfCaptionFont: TLogFontA;
    iSmCaptionWidth: Integer;
    iSmCaptionHeight: Integer;
    lfSmCaptionFont: TLogFontA;
    iMenuWidth: Integer;
    iMenuHeight: Integer;
    lfMenuFont: TLogFontA;
    lfStatusFont: TLogFontA;
    lfMessageFont: TLogFontA;
  end;
  {$EXTERNALSYM tagNONCLIENTMETRICSW}
  tagNONCLIENTMETRICSW = packed record
    cbSize: UINT;
    iBorderWidth: Integer;
    iScrollWidth: Integer;
    iScrollHeight: Integer;
    iCaptionWidth: Integer;
    iCaptionHeight: Integer;
    lfCaptionFont: TLogFontW;
    iSmCaptionWidth: Integer;
    iSmCaptionHeight: Integer;
    lfSmCaptionFont: TLogFontW;
    iMenuWidth: Integer;
    iMenuHeight: Integer;
    lfMenuFont: TLogFontW;
    lfStatusFont: TLogFontW;
    lfMessageFont: TLogFontW;
  end;
  {$EXTERNALSYM tagNONCLIENTMETRICS}
  tagNONCLIENTMETRICS = tagNONCLIENTMETRICSA;
  TNonClientMetricsA = tagNONCLIENTMETRICSA;
  TNonClientMetricsW = tagNONCLIENTMETRICSW;
  TNonClientMetrics = TNonClientMetricsA;
  {$EXTERNALSYM NONCLIENTMETRICSA}
  NONCLIENTMETRICSA = tagNONCLIENTMETRICSA;
  {$EXTERNALSYM NONCLIENTMETRICSW}
  NONCLIENTMETRICSW = tagNONCLIENTMETRICSW;
  {$EXTERNALSYM NONCLIENTMETRICS}
  NONCLIENTMETRICS = NONCLIENTMETRICSA;

const
  {$EXTERNALSYM ARW_BOTTOMLEFT}
  ARW_BOTTOMLEFT = 0;
  {$EXTERNALSYM ARW_BOTTOMRIGHT}
  ARW_BOTTOMRIGHT = 1;
  {$EXTERNALSYM ARW_TOPLEFT}
  ARW_TOPLEFT = 2;
  {$EXTERNALSYM ARW_TOPRIGHT}
  ARW_TOPRIGHT = 3;
  {$EXTERNALSYM ARW_STARTMASK}
  ARW_STARTMASK = 3;
  {$EXTERNALSYM ARW_STARTRIGHT}
  ARW_STARTRIGHT = 1;
  {$EXTERNALSYM ARW_STARTTOP}
  ARW_STARTTOP = 2;

  {$EXTERNALSYM ARW_LEFT}
  ARW_LEFT = 0;
  {$EXTERNALSYM ARW_RIGHT}
  ARW_RIGHT = 0;
  {$EXTERNALSYM ARW_UP}
  ARW_UP = 4;
  {$EXTERNALSYM ARW_DOWN}
  ARW_DOWN = 4;
  {$EXTERNALSYM ARW_HIDE}
  ARW_HIDE = 8;
  {$EXTERNALSYM ARW_VALID}
  ARW_VALID = 15;

type
  PMinimizedMetrics = ^TMinimizedMetrics;
  {$EXTERNALSYM tagMINIMIZEDMETRICS}
  tagMINIMIZEDMETRICS = packed record
    cbSize: UINT;
    iWidth: Integer;
    iHorzGap: Integer;
    iVertGap: Integer;
    iArrange: Integer;
  end;
  TMinimizedMetrics = tagMINIMIZEDMETRICS;
  {$EXTERNALSYM MINIMIZEDMETRICS}
  MINIMIZEDMETRICS = tagMINIMIZEDMETRICS;

  PIconMetricsA = ^TIconMetricsA;
  PIconMetricsW = ^TIconMetricsW;
  PIconMetrics = PIconMetricsA;
  {$EXTERNALSYM tagICONMETRICSA}
  tagICONMETRICSA = packed record
    cbSize: UINT;
    iHorzSpacing: Integer;
    iVertSpacing: Integer;
    iTitleWrap: Integer;
    lfFont: TLogFontA;
  end;
  {$EXTERNALSYM tagICONMETRICSW}
  tagICONMETRICSW = packed record
    cbSize: UINT;
    iHorzSpacing: Integer;
    iVertSpacing: Integer;
    iTitleWrap: Integer;
    lfFont: TLogFontW;
  end;
  {$EXTERNALSYM tagICONMETRICS}
  tagICONMETRICS = tagICONMETRICSA;
  TIconMetricsA = tagICONMETRICSA;
  TIconMetricsW = tagICONMETRICSW;
  TIconMetrics = TIconMetricsA;
  {$EXTERNALSYM ICONMETRICSA}
  ICONMETRICSA = tagICONMETRICSA;
  {$EXTERNALSYM ICONMETRICSW}
  ICONMETRICSW = tagICONMETRICSW;
  {$EXTERNALSYM ICONMETRICS}
  ICONMETRICS = ICONMETRICSA;

  PAnimationInfo = ^TAnimationInfo;
  {$EXTERNALSYM tagANIMATIONINFO}
  tagANIMATIONINFO = packed record
    cbSize: UINT;
    iMinAnimate: Integer;
  end;
  TAnimationInfo = tagANIMATIONINFO;
  {$EXTERNALSYM ANIMATIONINFO}
  ANIMATIONINFO = tagANIMATIONINFO;


type
  PSerialKeysA = ^TSerialKeysA;
  PSerialKeysW = ^TSerialKeysW;
  PSerialKeys = PSerialKeysA;
  {$EXTERNALSYM tagSERIALKEYSA}
  tagSERIALKEYSA = packed record
    cbSize: UINT;
    dwFlags: DWORD;
    lpszActivePort: PAnsiChar;
    lpszPort: PAnsiChar;
    iBaudRate: UINT;
    iPortState: UINT;
    iActive: UINT;
  end;
  {$EXTERNALSYM tagSERIALKEYSW}
  tagSERIALKEYSW = packed record
    cbSize: UINT;
    dwFlags: DWORD;
    lpszActivePort: PWideChar;
    lpszPort: PWideChar;
    iBaudRate: UINT;
    iPortState: UINT;
    iActive: UINT;
  end;
  {$EXTERNALSYM tagSERIALKEYS}
  tagSERIALKEYS = tagSERIALKEYSA;
  TSerialKeysA = tagSERIALKEYSA;
  TSerialKeysW = tagSERIALKEYSW;
  TSerialKeys = TSerialKeysA;
  {$EXTERNALSYM SERIALKEYSA}
  SERIALKEYSA = tagSERIALKEYSA;
  {$EXTERNALSYM SERIALKEYSW}
  SERIALKEYSW = tagSERIALKEYSW;
  {$EXTERNALSYM SERIALKEYS}
  SERIALKEYS = SERIALKEYSA;

const
  { flags for SERIALKEYS dwFlags field }
  {$EXTERNALSYM SERKF_SERIALKEYSON}
  SERKF_SERIALKEYSON = 1;
  {$EXTERNALSYM SERKF_AVAILABLE}
  SERKF_AVAILABLE = 2;
  {$EXTERNALSYM SERKF_INDICATOR}
  SERKF_INDICATOR = 4;

type
  PHighContrastA = ^THighContrastA;
  PHighContrastW = ^THighContrastW;
  PHighContrast = PHighContrastA;
  {$EXTERNALSYM tagHIGHCONTRASTA}
  tagHIGHCONTRASTA = packed record
    cbSize: UINT;
    dwFlags: DWORD;
    lpszDefaultScheme: PAnsiChar;
  end;
  {$EXTERNALSYM tagHIGHCONTRASTW}
  tagHIGHCONTRASTW = packed record
    cbSize: UINT;
    dwFlags: DWORD;
    lpszDefaultScheme: PWideChar;
  end;
  {$EXTERNALSYM tagHIGHCONTRAST}
  tagHIGHCONTRAST = tagHIGHCONTRASTA;
  THighContrastA = tagHIGHCONTRASTA;
  THighContrastW = tagHIGHCONTRASTW;
  THighContrast = THighContrastA;
  {$EXTERNALSYM HIGHCONTRASTA}
  HIGHCONTRASTA = tagHIGHCONTRASTA;
  {$EXTERNALSYM HIGHCONTRASTW}
  HIGHCONTRASTW = tagHIGHCONTRASTW;
  {$EXTERNALSYM HIGHCONTRAST}
  HIGHCONTRAST = HIGHCONTRASTA;


const
  { flags for HIGHCONTRAST dwFlags field }
  {$EXTERNALSYM HCF_HIGHCONTRASTON}
  HCF_HIGHCONTRASTON      = $00000001;
  {$EXTERNALSYM HCF_AVAILABLE}
  HCF_AVAILABLE           = $00000002;
  {$EXTERNALSYM HCF_HOTKEYACTIVE}
  HCF_HOTKEYACTIVE        = $00000004;
  {$EXTERNALSYM HCF_CONFIRMHOTKEY}
  HCF_CONFIRMHOTKEY       = $00000008;
  {$EXTERNALSYM HCF_HOTKEYSOUND}
  HCF_HOTKEYSOUND         = $00000010;
  {$EXTERNALSYM HCF_INDICATOR}
  HCF_INDICATOR           = $00000020;
  {$EXTERNALSYM HCF_HOTKEYAVAILABLE}
  HCF_HOTKEYAVAILABLE     = $00000040;

  { Flags for ChangeDisplaySettings }
  {$EXTERNALSYM CDS_UPDATEREGISTRY}
  CDS_UPDATEREGISTRY      = $00000001;
  {$EXTERNALSYM CDS_TEST}
  CDS_TEST                = $00000002;
  {$EXTERNALSYM CDS_FULLSCREEN}
  CDS_FULLSCREEN          = $00000004;
  {$EXTERNALSYM CDS_GLOBAL}
  CDS_GLOBAL              = $00000008;
  {$EXTERNALSYM CDS_SET_PRIMARY}
  CDS_SET_PRIMARY         = $00000010;
  {$EXTERNALSYM CDS_RESET}
  CDS_RESET               = $40000000;
  {$EXTERNALSYM CDS_SETRECT}
  CDS_SETRECT             = $20000000;
  {$EXTERNALSYM CDS_NORESET}
  CDS_NORESET             = $10000000;

  { Return values for ChangeDisplaySettings }
  {$EXTERNALSYM DISP_CHANGE_SUCCESSFUL}
  DISP_CHANGE_SUCCESSFUL           = 0;
  {$EXTERNALSYM DISP_CHANGE_RESTART}
  DISP_CHANGE_RESTART              = 1;
  {$EXTERNALSYM DISP_CHANGE_FAILED}
  DISP_CHANGE_FAILED              = -1;
  {$EXTERNALSYM DISP_CHANGE_BADMODE}
  DISP_CHANGE_BADMODE             = -2;
  {$EXTERNALSYM DISP_CHANGE_NOTUPDATED}
  DISP_CHANGE_NOTUPDATED          = -3;
  {$EXTERNALSYM DISP_CHANGE_BADFLAGS}
  DISP_CHANGE_BADFLAGS            = -4;
  {$EXTERNALSYM DISP_CHANGE_BADPARAM}
  DISP_CHANGE_BADPARAM            = -5;


{$EXTERNALSYM ChangeDisplaySettings}
function ChangeDisplaySettings(var lpDevMode: TDeviceMode; dwFlags: DWORD): Longint; stdcall;
{$EXTERNALSYM ChangeDisplaySettingsA}
function ChangeDisplaySettingsA(var lpDevMode: TDeviceModeA; dwFlags: DWORD): Longint; stdcall;
{$EXTERNALSYM ChangeDisplaySettingsW}
function ChangeDisplaySettingsW(var lpDevMode: TDeviceModeW; dwFlags: DWORD): Longint; stdcall;
{$EXTERNALSYM ChangeDisplaySettingsEx}
function ChangeDisplaySettingsEx(lpszDeviceName: PChar; var lpDevMode: TDeviceMode;
        wnd: HWND; dwFlags: DWORD; lParam: Pointer): Longint; stdcall;
{$EXTERNALSYM ChangeDisplaySettingsExA}
function ChangeDisplaySettingsExA(lpszDeviceName: PAnsiChar; var lpDevMode: TDeviceModeA;
        wnd: HWND; dwFlags: DWORD; lParam: Pointer): Longint; stdcall;
{$EXTERNALSYM ChangeDisplaySettingsExW}
function ChangeDisplaySettingsExW(lpszDeviceName: PWideChar; var lpDevMode: TDeviceModeW;
        wnd: HWND; dwFlags: DWORD; lParam: Pointer): Longint; stdcall;
{$EXTERNALSYM EnumDisplaySettings}
function EnumDisplaySettings(lpszDeviceName: PChar; iModeNum: DWORD;
  var lpDevMode: TDeviceMode): BOOL; stdcall;
{$EXTERNALSYM EnumDisplaySettingsA}
function EnumDisplaySettingsA(lpszDeviceName: PAnsiChar; iModeNum: DWORD;
  var lpDevMode: TDeviceModeA): BOOL; stdcall;
{$EXTERNALSYM EnumDisplaySettingsW}
function EnumDisplaySettingsW(lpszDeviceName: PWideChar; iModeNum: DWORD;
  var lpDevMode: TDeviceModeW): BOOL; stdcall;
{#END}
{$EXTERNALSYM EnumDisplayDevices}
function EnumDisplayDevices(Unused: Pointer; iDevNum: DWORD;
  var lpDisplayDevice: TDisplayDevice; dwFlags: DWORD): BOOL; stdcall;
{$EXTERNALSYM EnumDisplayDevicesA}
function EnumDisplayDevicesA(Unused: Pointer; iDevNum: DWORD;
  var lpDisplayDevice: TDisplayDeviceA; dwFlags: DWORD): BOOL; stdcall;
{$EXTERNALSYM EnumDisplayDevicesW}
function EnumDisplayDevicesW(Unused: Pointer; iDevNum: DWORD;
  var lpDisplayDevice: TDisplayDeviceW; dwFlags: DWORD): BOOL; stdcall;
{$EXTERNALSYM SystemParametersInfo}
function SystemParametersInfo(uiAction, uiParam: UINT;
  pvParam: Pointer; fWinIni: UINT): BOOL; stdcall;
{$EXTERNALSYM SystemParametersInfoA}
function SystemParametersInfoA(uiAction, uiParam: UINT;
  pvParam: Pointer; fWinIni: UINT): BOOL; stdcall;
{$EXTERNALSYM SystemParametersInfoW}
function SystemParametersInfoW(uiAction, uiParam: UINT;
  pvParam: Pointer; fWinIni: UINT): BOOL; stdcall;

type
  { Accessibility support }
  PFilterKeys = ^TFilterKeys;
  {$EXTERNALSYM tagFILTERKEYS}
  tagFILTERKEYS = packed record
    cbSize: UINT;
    dwFlags: DWORD;
    iWaitMSec: DWORD;       { Acceptance Delay}
    iDelayMSec: DWORD;      { Delay Until Repeat}
    iRepeatMSec: DWORD;     { Repeat Rate}
    iBounceMSec: DWORD;     { Debounce Time}
  end;
  TFilterKeys = tagFILTERKEYS;
  {$EXTERNALSYM FILTERKEYS}
  FILTERKEYS = tagFILTERKEYS;


const
  { TFilterKeys dwFlags field }
  {$EXTERNALSYM FKF_FILTERKEYSON}
  FKF_FILTERKEYSON = 1;
  {$EXTERNALSYM FKF_AVAILABLE}
  FKF_AVAILABLE = 2;
  {$EXTERNALSYM FKF_HOTKEYACTIVE}
  FKF_HOTKEYACTIVE = 4;
  {$EXTERNALSYM FKF_CONFIRMHOTKEY}
  FKF_CONFIRMHOTKEY = 8;
  {$EXTERNALSYM FKF_HOTKEYSOUND}
  FKF_HOTKEYSOUND = $10;
  {$EXTERNALSYM FKF_INDICATOR}
  FKF_INDICATOR = $20;
  {$EXTERNALSYM FKF_CLICKON}
  FKF_CLICKON = $40;

type
  PStickyKeys = ^TStickyKeys;
  {$EXTERNALSYM tagSTICKYKEYS}
  tagSTICKYKEYS = packed record
    cbSize: UINT;
    dwFlags: DWORD;
  end;
  TStickyKeys = tagSTICKYKEYS;
  {$EXTERNALSYM STICKYKEYS}
  STICKYKEYS = tagSTICKYKEYS;

const
  { TStickyKeys dwFlags field }
  {$EXTERNALSYM SKF_STICKYKEYSON}
  SKF_STICKYKEYSON = 1;
  {$EXTERNALSYM SKF_AVAILABLE}
  SKF_AVAILABLE = 2;
  {$EXTERNALSYM SKF_HOTKEYACTIVE}
  SKF_HOTKEYACTIVE = 4;
  {$EXTERNALSYM SKF_CONFIRMHOTKEY}
  SKF_CONFIRMHOTKEY = 8;
  {$EXTERNALSYM SKF_HOTKEYSOUND}
  SKF_HOTKEYSOUND = $10;
  {$EXTERNALSYM SKF_INDICATOR}
  SKF_INDICATOR = $20;
  {$EXTERNALSYM SKF_AUDIBLEFEEDBACK}
  SKF_AUDIBLEFEEDBACK = $40;
  {$EXTERNALSYM SKF_TRISTATE}
  SKF_TRISTATE = $80;
  {$EXTERNALSYM SKF_TWOKEYSOFF}
  SKF_TWOKEYSOFF = $100;
  {$EXTERNALSYM SKF_LALTLATCHED}
  SKF_LALTLATCHED = $10000000;
  {$EXTERNALSYM SKF_LCTLLATCHED}
  SKF_LCTLLATCHED = $04000000;
  {$EXTERNALSYM SKF_LSHIFTLATCHED}
  SKF_LSHIFTLATCHED = $01000000;
  {$EXTERNALSYM SKF_RALTLATCHED }
  SKF_RALTLATCHED = $20000000;
  {$EXTERNALSYM SKF_RCTLLATCHED}
  SKF_RCTLLATCHED = $08000000;
  {$EXTERNALSYM SKF_RSHIFTLATCHED}
  SKF_RSHIFTLATCHED = $02000000;
  {$EXTERNALSYM SKF_LWINLATCHED}
  SKF_LWINLATCHED = $40000000;
  {$EXTERNALSYM SKF_RWINLATCHED}
  SKF_RWINLATCHED = $80000000;
  {$EXTERNALSYM SKF_LALTLOCKED}
  SKF_LALTLOCKED = $00100000;
  {$EXTERNALSYM SKF_LCTLLOCKED}
  SKF_LCTLLOCKED = $00040000;
  {$EXTERNALSYM SKF_LSHIFTLOCKED}
  SKF_LSHIFTLOCKED = $00010000;
  {$EXTERNALSYM SKF_RALTLOCKED}
  SKF_RALTLOCKED = $00200000;
  {$EXTERNALSYM SKF_RCTLLOCKED}
  SKF_RCTLLOCKED = $00080000;
  {$EXTERNALSYM SKF_RSHIFTLOCKED}
  SKF_RSHIFTLOCKED = $00020000;
  {$EXTERNALSYM SKF_LWINLOCKED}
  SKF_LWINLOCKED = $00400000;
  {$EXTERNALSYM SKF_RWINLOCKED}
  SKF_RWINLOCKED = $00800000;

type
  PMouseKeys = ^TMouseKeys;
  {$EXTERNALSYM tagMOUSEKEYS}
  tagMOUSEKEYS = packed record
    cbSize: UINT;
    dwFlags: DWORD;
    iMaxSpeed: DWORD;
    iTimeToMaxSpeed: DWORD;
    iCtrlSpeed: DWORD;
    dwReserved1: DWORD;
    dwReserved2: DWORD;
  end;
  TMouseKeys = tagMOUSEKEYS;
  {$EXTERNALSYM MOUSEKEYS}
  MOUSEKEYS = tagMOUSEKEYS;

const
  { TMouseKeys dwFlags field }
  {$EXTERNALSYM MKF_MOUSEKEYSON}
  MKF_MOUSEKEYSON = 1;
  {$EXTERNALSYM MKF_AVAILABLE}
  MKF_AVAILABLE = 2;
  {$EXTERNALSYM MKF_HOTKEYACTIVE}
  MKF_HOTKEYACTIVE = 4;
  {$EXTERNALSYM MKF_CONFIRMHOTKEY}
  MKF_CONFIRMHOTKEY = 8;
  {$EXTERNALSYM MKF_HOTKEYSOUND}
  MKF_HOTKEYSOUND = $10;
  {$EXTERNALSYM MKF_INDICATOR}
  MKF_INDICATOR = $20;
  {$EXTERNALSYM MKF_MODIFIERS}
  MKF_MODIFIERS = $40;
  {$EXTERNALSYM MKF_REPLACENUMBERS}
  MKF_REPLACENUMBERS = $80;
  {$EXTERNALSYM MKF_LEFTBUTTONSEL}
  MKF_LEFTBUTTONSEL = $10000000;
  {$EXTERNALSYM MKF_RIGHTBUTTONSEL}
  MKF_RIGHTBUTTONSEL = $20000000;
  {$EXTERNALSYM MKF_LEFTBUTTONDOWN}
  MKF_LEFTBUTTONDOWN = $01000000;
  {$EXTERNALSYM MKF_RIGHTBUTTONDOWN}
  MKF_RIGHTBUTTONDOWN = $02000000;
  {$EXTERNALSYM MKF_MOUSEMODE}
  MKF_MOUSEMODE = $80000000;

type
  PAccessTimeout = ^TAccessTimeout;
  {$EXTERNALSYM tagACCESSTIMEOUT}
  tagACCESSTIMEOUT = packed record
    cbSize: UINT;
    dwFlags: DWORD;
    iTimeOutMSec: DWORD;
  end;
  TAccessTimeout = tagACCESSTIMEOUT;
  {$EXTERNALSYM ACCESSTIMEOUT}
  ACCESSTIMEOUT = tagACCESSTIMEOUT;

const
  { TAccessTimeout dwFlags field }
  {$EXTERNALSYM ATF_TIMEOUTON}
  ATF_TIMEOUTON = 1;
  {$EXTERNALSYM ATF_ONOFFFEEDBACK}
  ATF_ONOFFFEEDBACK = 2;

  { values for TSoundsEntry iFSGrafEffect field }
  {$EXTERNALSYM SSGF_NONE}
  SSGF_NONE = 0;
  {$EXTERNALSYM SSGF_DISPLAY}
  SSGF_DISPLAY = 3;

  { values for TSoundsEntry iFSTextEffect field }
  {$EXTERNALSYM SSTF_NONE}
  SSTF_NONE = 0;
  {$EXTERNALSYM SSTF_CHARS}
  SSTF_CHARS = 1;
  {$EXTERNALSYM SSTF_BORDER}
  SSTF_BORDER = 2;
  {$EXTERNALSYM SSTF_DISPLAY}
  SSTF_DISPLAY = 3;

  { values for TSoundsEntry iWindowsEffect field }
  {$EXTERNALSYM SSWF_NONE}
  SSWF_NONE = 0;
  {$EXTERNALSYM SSWF_TITLE}
  SSWF_TITLE = 1;
  {$EXTERNALSYM SSWF_WINDOW}
  SSWF_WINDOW = 2;
  {$EXTERNALSYM SSWF_DISPLAY}
  SSWF_DISPLAY = 3;
  {$EXTERNALSYM SSWF_CUSTOM}
  SSWF_CUSTOM = 4;

type
  PSoundsEntryA = ^TSoundsEntryA;
  PSoundsEntryW = ^TSoundsEntryW;
  PSoundsEntry = PSoundsEntryA;
  {$EXTERNALSYM tagSOUNDSENTRYA}
  tagSOUNDSENTRYA = packed record
    cbSize: UINT;
    dwFlags: DWORD;
    iFSTextEffect: DWORD;
    iFSTextEffectMSec: DWORD;
    iFSTextEffectColorBits: DWORD;
    iFSGrafEffect: DWORD;
    iFSGrafEffectMSec: DWORD;
    iFSGrafEffectColor: DWORD;
    iWindowsEffect: DWORD;
    iWindowsEffectMSec: DWORD;
    lpszWindowsEffectDLL: PAnsiChar;
    iWindowsEffectOrdinal: DWORD;
  end;
  {$EXTERNALSYM tagSOUNDSENTRYW}
  tagSOUNDSENTRYW = packed record
    cbSize: UINT;
    dwFlags: DWORD;
    iFSTextEffect: DWORD;
    iFSTextEffectMSec: DWORD;
    iFSTextEffectColorBits: DWORD;
    iFSGrafEffect: DWORD;
    iFSGrafEffectMSec: DWORD;
    iFSGrafEffectColor: DWORD;
    iWindowsEffect: DWORD;
    iWindowsEffectMSec: DWORD;
    lpszWindowsEffectDLL: PWideChar;
    iWindowsEffectOrdinal: DWORD;
  end;
  {$EXTERNALSYM tagSOUNDSENTRY}
  tagSOUNDSENTRY = tagSOUNDSENTRYA;
  TSoundsEntryA = tagSOUNDSENTRYA;
  TSoundsEntryW = tagSOUNDSENTRYW;
  TSoundsEntry = TSoundsEntryA;
  {$EXTERNALSYM SOUNDSENTRYA}
  SOUNDSENTRYA = tagSOUNDSENTRYA;
  {$EXTERNALSYM SOUNDSENTRYW}
  SOUNDSENTRYW = tagSOUNDSENTRYW;
  {$EXTERNALSYM SOUNDSENTRY}
  SOUNDSENTRY = SOUNDSENTRYA;

const
  { SOUNDSENTRY dwFlags field }
  {$EXTERNALSYM SSF_SOUNDSENTRYON}
  SSF_SOUNDSENTRYON = 1;
  {$EXTERNALSYM SSF_AVAILABLE}
  SSF_AVAILABLE = 2;
  {$EXTERNALSYM SSF_INDICATOR}
  SSF_INDICATOR = 4;


type
  PToggleKeys = ^TToggleKeys;
  {$EXTERNALSYM tagTOGGLEKEYS}
  tagTOGGLEKEYS = packed record
    cbSize: UINT;
    dwFlags: DWORD;
  end;
  TToggleKeys = tagTOGGLEKEYS;
  {$EXTERNALSYM TOGGLEKEYS}
  TOGGLEKEYS = tagTOGGLEKEYS;

const
  { TToggleKeys dwFlags field }
  {$EXTERNALSYM TKF_TOGGLEKEYSON}
  TKF_TOGGLEKEYSON = 1;
  {$EXTERNALSYM TKF_AVAILABLE}
  TKF_AVAILABLE = 2;
  {$EXTERNALSYM TKF_HOTKEYACTIVE}
  TKF_HOTKEYACTIVE = 4;
  {$EXTERNALSYM TKF_CONFIRMHOTKEY}
  TKF_CONFIRMHOTKEY = 8;
  {$EXTERNALSYM TKF_HOTKEYSOUND}
  TKF_HOTKEYSOUND = $10;
  {$EXTERNALSYM TKF_INDICATOR}
  TKF_INDICATOR = $20;

{$EXTERNALSYM SetDebugErrorLevel}
procedure SetDebugErrorLevel(dwLevel: DWORD); stdcall;

const
  { SetLastErrorEx() types. }
  {$EXTERNALSYM SLE_ERROR}
  SLE_ERROR = 1;
  {$EXTERNALSYM SLE_MINORERROR}
  SLE_MINORERROR = 2;
  {$EXTERNALSYM SLE_WARNING}
  SLE_WARNING = 3;

{$EXTERNALSYM SetLastErrorEx}
procedure SetLastErrorEx(dwErrCode, dwType: DWORD); stdcall;


{ WinEvents - Active Accessibility hooks }
{$EXTERNALSYM NotifyWinEvent}
procedure NotifyWinEvent(event: DWORD; hwnd: HWND; idObject, idChild: Cardinal); stdcall;

type
  {$EXTERNALSYM TFNWinEventProc}
    TFNWinEventProc = procedure (hWinEventHook: THandle; event: DWORD;
    hwnd: HWND; idObject, idChild: Longint; idEventThread, dwmsEventTime: DWORD); stdcall;

const
  {$EXTERNALSYM CHILDID_SELF}
  CHILDID_SELF = 0;
  {$EXTERNALSYM INDEXID_OBJECT}
  INDEXID_OBJECT = 0;
  {$EXTERNALSYM INDEXID_CONTAINER}
  INDEXID_CONTAINER = 0;

  { Reserved IDs for system objects}
  {$EXTERNALSYM OBJID_WINDOW}
  OBJID_WINDOW = $00000000;
  {$EXTERNALSYM OBJID_SYSMENU}
  OBJID_SYSMENU = $FFFFFFFF;
  {$EXTERNALSYM OBJID_TITLEBAR}
  OBJID_TITLEBAR = $FFFFFFFE;
  {$EXTERNALSYM OBJID_MENU}
  OBJID_MENU = $FFFFFFFD;
  {$EXTERNALSYM OBJID_CLIENT}
  OBJID_CLIENT = $FFFFFFFC;
  {$EXTERNALSYM OBJID_VSCROLL}
  OBJID_VSCROLL = $FFFFFFFB;
  {$EXTERNALSYM OBJID_HSCROLL}
  OBJID_HSCROLL = $FFFFFFFA;
  {$EXTERNALSYM OBJID_SIZEGRIP}
  OBJID_SIZEGRIP = $FFFFFFF9;
  {$EXTERNALSYM OBJID_CARET}
  OBJID_CARET = $FFFFFFF8;
  {$EXTERNALSYM OBJID_CURSOR}
  OBJID_CURSOR = $FFFFFFF7;
  {$EXTERNALSYM OBJID_ALERT}
  OBJID_ALERT = $FFFFFFF6;
  {$EXTERNALSYM OBJID_SOUND}
  OBJID_SOUND = $FFFFFFF5;

  { EVENT DEFINITION }
  {$EXTERNALSYM EVENT_MIN}
  EVENT_MIN = $00000001;
  {$EXTERNALSYM EVENT_MAX}
  EVENT_MAX = $7FFFFFFF;

  {$EXTERNALSYM EVENT_SYSTEM_SOUND}
  EVENT_SYSTEM_SOUND = $0001;
  {$EXTERNALSYM EVENT_SYSTEM_ALERT}
  EVENT_SYSTEM_ALERT = $0002;
  {$EXTERNALSYM EVENT_SYSTEM_FOREGROUND}
  EVENT_SYSTEM_FOREGROUND = $0003;
  {$EXTERNALSYM EVENT_SYSTEM_MENUSTART}
  EVENT_SYSTEM_MENUSTART = $0004;
  {$EXTERNALSYM EVENT_SYSTEM_MENUEND}
  EVENT_SYSTEM_MENUEND = $0005;
  {$EXTERNALSYM EVENT_SYSTEM_MENUPOPUPSTART}
  EVENT_SYSTEM_MENUPOPUPSTART  = $0006;
  {$EXTERNALSYM EVENT_SYSTEM_MENUPOPUPEND}
  EVENT_SYSTEM_MENUPOPUPEND    = $0007;
  {$EXTERNALSYM EVENT_SYSTEM_CAPTURESTART}
  EVENT_SYSTEM_CAPTURESTART    = $0008;
  {$EXTERNALSYM EVENT_SYSTEM_CAPTUREEND}
  EVENT_SYSTEM_CAPTUREEND      = $0009;
  {$EXTERNALSYM EVENT_SYSTEM_MOVESIZESTART}
  EVENT_SYSTEM_MOVESIZESTART   = $000A;
  {$EXTERNALSYM EVENT_SYSTEM_MOVESIZEEND}
  EVENT_SYSTEM_MOVESIZEEND     = $000B;
  {$EXTERNALSYM EVENT_SYSTEM_CONTEXTHELPSTART}
  EVENT_SYSTEM_CONTEXTHELPSTART= $000C;
  {$EXTERNALSYM EVENT_SYSTEM_CONTEXTHELPEND}
  EVENT_SYSTEM_CONTEXTHELPEND  = $000D;
  {$EXTERNALSYM EVENT_SYSTEM_DRAGDROPSTART}
  EVENT_SYSTEM_DRAGDROPSTART   = $000E;
  {$EXTERNALSYM EVENT_SYSTEM_DRAGDROPEND}
  EVENT_SYSTEM_DRAGDROPEND     = $000F;
  {$EXTERNALSYM EVENT_SYSTEM_DIALOGSTART}
  EVENT_SYSTEM_DIALOGSTART     = $0010;
  {$EXTERNALSYM EVENT_SYSTEM_DIALOGEND}
  EVENT_SYSTEM_DIALOGEND       = $0011;
  {$EXTERNALSYM EVENT_SYSTEM_SCROLLINGSTART}
  EVENT_SYSTEM_SCROLLINGSTART  = $0012;
  {$EXTERNALSYM EVENT_SYSTEM_SCROLLINGEND}
  EVENT_SYSTEM_SCROLLINGEND    = $0013;
  {$EXTERNALSYM EVENT_SYSTEM_SWITCHSTART}
  EVENT_SYSTEM_SWITCHSTART     = $0014;
  {$EXTERNALSYM EVENT_SYSTEM_SWITCHEND}
  EVENT_SYSTEM_SWITCHEND       = $0015;
  {$EXTERNALSYM EVENT_SYSTEM_MINIMIZESTART}
  EVENT_SYSTEM_MINIMIZESTART   = $0016;
  {$EXTERNALSYM EVENT_SYSTEM_MINIMIZEEND}
  EVENT_SYSTEM_MINIMIZEEND     = $0017;
  {$EXTERNALSYM EVENT_OBJECT_CREATE}
  EVENT_OBJECT_CREATE              = $8000;  { hwnd + ID + idChild is created item }
  {$EXTERNALSYM EVENT_OBJECT_DESTROY}
  EVENT_OBJECT_DESTROY             = $8001;  { hwnd + ID + idChild is destroyed item }
  {$EXTERNALSYM EVENT_OBJECT_SHOW}
  EVENT_OBJECT_SHOW                = $8002;  { hwnd + ID + idChild is shown item }
  {$EXTERNALSYM EVENT_OBJECT_HIDE}
  EVENT_OBJECT_HIDE                = $8003;  { hwnd + ID + idChild is hidden item }
  {$EXTERNALSYM EVENT_OBJECT_REORDER}
  EVENT_OBJECT_REORDER             = $8004;  { hwnd + ID + idChild is parent of zordering children }
  {$EXTERNALSYM EVENT_OBJECT_FOCUS}
  EVENT_OBJECT_FOCUS               = $8005;  { hwnd + ID + idChild is focused item }
  {$EXTERNALSYM EVENT_OBJECT_SELECTION}
  EVENT_OBJECT_SELECTION           = $8006;  { hwnd + ID + idChild is selected item (if only one), or idChild is OBJID_WINDOW if complex }
  {$EXTERNALSYM EVENT_OBJECT_SELECTIONADD}
  EVENT_OBJECT_SELECTIONADD        = $8007;  { hwnd + ID + idChild is item added }
  {$EXTERNALSYM EVENT_OBJECT_SELECTIONREMOVE}
  EVENT_OBJECT_SELECTIONREMOVE     = $8008;  { hwnd + ID + idChild is item removed }
  {$EXTERNALSYM EVENT_OBJECT_SELECTIONWITHIN}
  EVENT_OBJECT_SELECTIONWITHIN     = $8009;  { hwnd + ID + idChild is parent of changed selected items }
  {$EXTERNALSYM EVENT_OBJECT_STATECHANGE}
  EVENT_OBJECT_STATECHANGE         = $800A;  { hwnd + ID + idChild is item w/ state change }
  {$EXTERNALSYM EVENT_OBJECT_LOCATIONCHANGE}
  EVENT_OBJECT_LOCATIONCHANGE      = $800B;  { hwnd + ID + idChild is moved/sized item }
  {$EXTERNALSYM EVENT_OBJECT_NAMECHANGE}
  EVENT_OBJECT_NAMECHANGE          = $800C;  { hwnd + ID + idChild is item w/ name change }
  {$EXTERNALSYM EVENT_OBJECT_DESCRIPTIONCHANGE}
  EVENT_OBJECT_DESCRIPTIONCHANGE   = $800D;  { hwnd + ID + idChild is item w/ desc change }
  {$EXTERNALSYM EVENT_OBJECT_VALUECHANGE}
  EVENT_OBJECT_VALUECHANGE         = $800E;  { hwnd + ID + idChild is item w/ value change }
  {$EXTERNALSYM EVENT_OBJECT_PARENTCHANGE}
  EVENT_OBJECT_PARENTCHANGE        = $800F;  { hwnd + ID + idChild is item w/ new parent }
  {$EXTERNALSYM EVENT_OBJECT_HELPCHANGE}
  EVENT_OBJECT_HELPCHANGE          = $8010;  { hwnd + ID + idChild is item w/ help change }
  {$EXTERNALSYM EVENT_OBJECT_DEFACTIONCHANGE}
  EVENT_OBJECT_DEFACTIONCHANGE     = $8011;  { hwnd + ID + idChild is item w/ def action change }
  {$EXTERNALSYM EVENT_OBJECT_ACCELERATORCHANGE}
  EVENT_OBJECT_ACCELERATORCHANGE   = $8012;  { hwnd + ID + idChild is item w/ keybd accel change }
  {$EXTERNALSYM SOUND_SYSTEM_STARTUP}
  SOUND_SYSTEM_STARTUP           = 1;
  {$EXTERNALSYM SOUND_SYSTEM_SHUTDOWN}
  SOUND_SYSTEM_SHUTDOWN          = 2;
  {$EXTERNALSYM SOUND_SYSTEM_BEEP}
  SOUND_SYSTEM_BEEP              = 3;
  {$EXTERNALSYM SOUND_SYSTEM_ERROR}
  SOUND_SYSTEM_ERROR             = 4;
  {$EXTERNALSYM SOUND_SYSTEM_QUESTION}
  SOUND_SYSTEM_QUESTION          = 5;
  {$EXTERNALSYM SOUND_SYSTEM_WARNING}
  SOUND_SYSTEM_WARNING           = 6;
  {$EXTERNALSYM SOUND_SYSTEM_INFORMATION}
  SOUND_SYSTEM_INFORMATION       = 7;
  {$EXTERNALSYM SOUND_SYSTEM_MAXIMIZE}
  SOUND_SYSTEM_MAXIMIZE          = 8;
  {$EXTERNALSYM SOUND_SYSTEM_MINIMIZE}
  SOUND_SYSTEM_MINIMIZE          = 9;
  {$EXTERNALSYM SOUND_SYSTEM_RESTOREUP}
  SOUND_SYSTEM_RESTOREUP         = 10;
  {$EXTERNALSYM SOUND_SYSTEM_RESTOREDOWN}
  SOUND_SYSTEM_RESTOREDOWN       = 11;
  {$EXTERNALSYM SOUND_SYSTEM_APPSTART}
  SOUND_SYSTEM_APPSTART          = 12;
  {$EXTERNALSYM SOUND_SYSTEM_FAULT}
  SOUND_SYSTEM_FAULT             = 13;
  {$EXTERNALSYM SOUND_SYSTEM_APPEND}
  SOUND_SYSTEM_APPEND            = 14;
  {$EXTERNALSYM SOUND_SYSTEM_MENUCOMMAND}
  SOUND_SYSTEM_MENUCOMMAND       = 15;
  {$EXTERNALSYM SOUND_SYSTEM_MENUPOPUP}
  SOUND_SYSTEM_MENUPOPUP         = 16;
  {$EXTERNALSYM CSOUND_SYSTEM}
  CSOUND_SYSTEM                  = 16;
  {$EXTERNALSYM ALERT_SYSTEM_INFORMATIONAL}
  ALERT_SYSTEM_INFORMATIONAL     = 1;       { MB_INFORMATION }
  {$EXTERNALSYM ALERT_SYSTEM_WARNING}
  ALERT_SYSTEM_WARNING           = 2;       { MB_WARNING }
  {$EXTERNALSYM ALERT_SYSTEM_ERROR}
  ALERT_SYSTEM_ERROR             = 3;       { MB_ERROR }
  {$EXTERNALSYM ALERT_SYSTEM_QUERY}
  ALERT_SYSTEM_QUERY             = 4;       { MB_QUESTION }
  {$EXTERNALSYM ALERT_SYSTEM_CRITICAL}
  ALERT_SYSTEM_CRITICAL          = 5;       { HardSysErrBox }
  {$EXTERNALSYM CALERT_SYSTEM}
  CALERT_SYSTEM                  = 6;

function SetWinEventHook (eventMin, eventMax: DWORD; hmodWinEventProc: HMODULE;
  pfnWinEventProc: TFNWinEventProc; idProcess, idThread, dwFlags: DWORD): THandle; stdcall;
{$EXTERNALSYM SetWinEventHook}

function UnhookWinEvent(hWinEventHook: THandle): BOOL; stdcall;
{$EXTERNALSYM UnhookWinEvent}

const
  { dwFlags for SetWinEventHook }
  {$EXTERNALSYM WINEVENT_OUTOFCONTEXT}
  WINEVENT_OUTOFCONTEXT  = $0000;  { Events are ASYNC }
  {$EXTERNALSYM WINEVENT_SKIPOWNTHREAD}
  WINEVENT_SKIPOWNTHREAD = $0001;  { Don't call back for events on installer's thread }
  {$EXTERNALSYM WINEVENT_SKIPOWNPROCESS}
  WINEVENT_SKIPOWNPROCESS = $0002;  { Don't call back for events on installer's process }
  {$EXTERNALSYM WINEVENT_INCONTEXT}
  WINEVENT_INCONTEXT = $0004;  { Events are SYNC, this causes your dll to be injected into every process }

type
  {$EXTERNALSYM PGUIThreadInfo}
  PGUIThreadInfo = ^TGUIThreadInfo;
  {$EXTERNALSYM tagGUITHREADINFO}
  tagGUITHREADINFO = packed record
    cbSize: DWORD;
    flags: DWORD;
    hwndActive: HWND;
    hwndFocus: HWND;
    hwndCapture: HWND;
    hwndMenuOwner: HWND;
    hwndMoveSize: HWND;
    hwndCaret: HWND;
    rcCaret: TRect;
  end;
  {$EXTERNALSYM TGUIThreadInfo}
  TGUIThreadInfo = tagGUITHREADINFO;

const
  {$EXTERNALSYM GUI_CARETBLINKING}
  GUI_CARETBLINKING  = $00000001;
  {$EXTERNALSYM GUI_INMOVESIZE}
  GUI_INMOVESIZE     = $00000002;
  {$EXTERNALSYM GUI_INMENUMODE}
  GUI_INMENUMODE     = $00000004;
  {$EXTERNALSYM GUI_SYSTEMMENUMODE}
  GUI_SYSTEMMENUMODE = $00000008;
  {$EXTERNALSYM GUI_POPUPMENUMODE}
  GUI_POPUPMENUMODE  = $00000010;

{$EXTERNALSYM GetGUIThreadInfo}
function GetGUIThreadInfo (idThread: DWORD; var pgui: TGUIThreadinfo): BOOL; stdcall;

{$EXTERNALSYM GetWindowModuleFileName}
function GetWindowModuleFileName(hwnd: HWND; pszFileName: PChar; cchFileNameMax: UINT): UINT; stdcall;
{$EXTERNALSYM GetWindowModuleFileNameA}
function GetWindowModuleFileNameA(hwnd: HWND; pszFileName: PAnsiChar; cchFileNameMax: UINT): UINT; stdcall;
{$EXTERNALSYM GetWindowModuleFileNameW}
function GetWindowModuleFileNameW(hwnd: HWND; pszFileName: PWideChar; cchFileNameMax: UINT): UINT; stdcall;

const
  {$EXTERNALSYM STATE_SYSTEM_UNAVAILABLE}
  STATE_SYSTEM_UNAVAILABLE     = $00000001;  { Disabled }
  {$EXTERNALSYM STATE_SYSTEM_SELECTED}
  STATE_SYSTEM_SELECTED        = $00000002;
  {$EXTERNALSYM STATE_SYSTEM_FOCUSED}
  STATE_SYSTEM_FOCUSED         = $00000004;
  {$EXTERNALSYM STATE_SYSTEM_PRESSED}
  STATE_SYSTEM_PRESSED         = $00000008;
  {$EXTERNALSYM STATE_SYSTEM_CHECKED}
  STATE_SYSTEM_CHECKED         = $00000010;
  {$EXTERNALSYM STATE_SYSTEM_MIXED}
  STATE_SYSTEM_MIXED           = $00000020;  { 3-state checkbox or toolbar button }
  {$EXTERNALSYM STATE_SYSTEM_READONLY}
  STATE_SYSTEM_READONLY        = $00000040;
  {$EXTERNALSYM STATE_SYSTEM_HOTTRACKED}
  STATE_SYSTEM_HOTTRACKED      = $00000080;
  {$EXTERNALSYM STATE_SYSTEM_DEFAULT}
  STATE_SYSTEM_DEFAULT         = $00000100;
  {$EXTERNALSYM STATE_SYSTEM_EXPANDED}
  STATE_SYSTEM_EXPANDED        = $00000200;
  {$EXTERNALSYM STATE_SYSTEM_COLLAPSED}
  STATE_SYSTEM_COLLAPSED       = $00000400;
  {$EXTERNALSYM STATE_SYSTEM_BUSY}
  STATE_SYSTEM_BUSY            = $00000800;
  {$EXTERNALSYM STATE_SYSTEM_FLOATING}
  STATE_SYSTEM_FLOATING        = $00001000;  { Children "owned" not "contained" by parent }
  {$EXTERNALSYM STATE_SYSTEM_MARQUEED}
  STATE_SYSTEM_MARQUEED        = $00002000;
  {$EXTERNALSYM STATE_SYSTEM_ANIMATED}
  STATE_SYSTEM_ANIMATED        = $00004000;
  {$EXTERNALSYM STATE_SYSTEM_INVISIBLE}
  STATE_SYSTEM_INVISIBLE       = $00008000;
  {$EXTERNALSYM STATE_SYSTEM_OFFSCREEN}
  STATE_SYSTEM_OFFSCREEN       = $00010000;
  {$EXTERNALSYM STATE_SYSTEM_SIZEABLE}
  STATE_SYSTEM_SIZEABLE        = $00020000;
  {$EXTERNALSYM STATE_SYSTEM_MOVEABLE}
  STATE_SYSTEM_MOVEABLE        = $00040000;
  {$EXTERNALSYM STATE_SYSTEM_SELFVOICING}
  STATE_SYSTEM_SELFVOICING     = $00080000;
  {$EXTERNALSYM STATE_SYSTEM_FOCUSABLE}
  STATE_SYSTEM_FOCUSABLE       = $00100000;
  {$EXTERNALSYM STATE_SYSTEM_SELECTABLE}
  STATE_SYSTEM_SELECTABLE      = $00200000;
  {$EXTERNALSYM STATE_SYSTEM_LINKED}
  STATE_SYSTEM_LINKED          = $00400000;
  {$EXTERNALSYM STATE_SYSTEM_TRAVERSED}
  STATE_SYSTEM_TRAVERSED       = $00800000;
  {$EXTERNALSYM STATE_SYSTEM_MULTISELECTABLE}
  STATE_SYSTEM_MULTISELECTABLE = $01000000;  { Supports multiple selection }
  {$EXTERNALSYM STATE_SYSTEM_EXTSELECTABLE}
  STATE_SYSTEM_EXTSELECTABLE   = $02000000;  { Supports extended selection }
  {$EXTERNALSYM STATE_SYSTEM_ALERT_LOW}
  STATE_SYSTEM_ALERT_LOW       = $04000000;  { This information is of low priority }
  {$EXTERNALSYM STATE_SYSTEM_ALERT_MEDIUM}
  STATE_SYSTEM_ALERT_MEDIUM    = $08000000;  { This information is of medium priority }
  {$EXTERNALSYM STATE_SYSTEM_ALERT_HIGH}
  STATE_SYSTEM_ALERT_HIGH      = $10000000;  { This information is of high priority }
  {$EXTERNALSYM STATE_SYSTEM_VALID}
  STATE_SYSTEM_VALID           = $1FFFFFFF;

  {$EXTERNALSYM CCHILDREN_TITLEBAR}
  CCHILDREN_TITLEBAR           =   5;
  {$EXTERNALSYM CCHILDREN_SCROLLBAR}
  CCHILDREN_SCROLLBAR          =   5;

type
  { Information about the global cursor. }
  {$EXTERNALSYM PCursorInfo}
  PCursorInfo = ^TCursorInfo;
  {$EXTERNALSYM tagCURSORINFO}
  tagCURSORINFO = packed record
    cbSize: DWORD;
    flags: DWORD;
    hCursor: HCURSOR;
    ptScreenPos: TPoint;
  end;
  {$EXTERNALSYM TCursorInfo}
  TCursorInfo = tagCURSORINFO;

const
  {$EXTERNALSYM CURSOR_SHOWING}
  CURSOR_SHOWING = $00000001;

{$EXTERNALSYM GetCursorInfo}
function GetCursorInfo(var pci: TCursorInfo): BOOL; stdcall;

type
  { Window information snapshot }
  {$EXTERNALSYM PWindowInfo}
  PWindowInfo = ^TWindowInfo;
  {$EXTERNALSYM tagWINDOWINFO}
  tagWINDOWINFO = packed record
    cbSize: DWORD;
    rcWindow: TRect;
    rcClient: TRect;
    dwStyle: DWORD;
    dwExStyle: DWORD;
    dwOtherStuff: DWORD;
    cxWindowBorders: UINT;
    cyWindowBorders: UINT;
    atomWindowType: TAtom;
    wCreatorVersion: WORD;
  end;
  {$EXTERNALSYM TWindowInfo}
  TWindowInfo = tagWINDOWINFO;

const
  {$EXTERNALSYM WS_ACTIVECAPTION}
  WS_ACTIVECAPTION = $0001;

{$EXTERNALSYM GetWindowInfo}
function GetWindowInfo(hwnd: HWND; var pwi: TWindowInfo): BOOL; stdcall;

type
  { Titlebar information. }
  {$EXTERNALSYM PTitleBarInfo}
  PTitleBarInfo = ^TTitleBarInfo;
  {$EXTERNALSYM tagTITLEBARINFO}
  tagTITLEBARINFO = packed record
    cbSize: DWORD;
    rcTitleBar: TRect;
    rgstate: array [0..CCHILDREN_TITLEBAR] of DWORD;
  end;
  {$EXTERNALSYM TTitleBarInfo}
  TTitleBarInfo = tagTITLEBARINFO;

{$EXTERNALSYM GetTitleBarInfo}
function GetTitleBarInfo(hwnd: HWND; var pti: TTitleBarInfo): BOOL; stdcall;

type
  { Menubar information }
  {$EXTERNALSYM PMenuBarInfo}
  PMenuBarInfo = ^TMenuBarInfo;
  {$EXTERNALSYM tagMENUBARINFO}
  tagMENUBARINFO = packed record
    cbSize: DWORD;
    rcBar: TRect;        { rect of bar, popup, item }
    hMenu: HMENU;        { real menu handle of bar, popup }
    hwndMenu: HWND;      { hwnd of item submenu if one }
{    fBarFocused:1: BOOL;} { bar, popup has the focus }
{    fFocused:1: BOOL; }  { item has the focus }
    FocusedBits: BYTE;
  end;
  {$EXTERNALSYM TMenuBarInfo}
  TMenuBarInfo = tagMENUBARINFO;

{$EXTERNALSYM GetMenuBarInfo}
function GetMenuBarInfo(hend: HWND; idObject, idItem: Longint;
  var pmbi: TMenuBarInfo): BOOL; stdcall;

type
  { Scrollbar information }
  {$EXTERNALSYM PScrollBarInfo}
  PScrollBarInfo = ^TScrollBarInfo;
  {$EXTERNALSYM tagSCROLLBARINFO}
  tagSCROLLBARINFO = packed record
    cbSize: DWORD;
    rcScrollBar: TRect;
    dxyLineButton: Integer;
    xyThumbTop: Integer;
    xyThumbBottom: Integer;
    bogus: Integer;
    rgstate: array[0..CCHILDREN_SCROLLBAR] of DWORD;
  end;
  {$EXTERNALSYM TScrollBarInfo}
  TScrollBarInfo = tagSCROLLBARINFO;

{$EXTERNALSYM GetScrollBarInfo}
Function GetScrollBarInfo(hwnd: HWND; idObject: Longint;
  var psbi: TScrollBarInfo): BOOL; stdcall;

type
  { Combobox information }
  {$EXTERNALSYM PComboBoxInfo}
  PComboBoxInfo = ^TComboBoxInfo;
  {$EXTERNALSYM tagCOMBOBOXINFO}
  tagCOMBOBOXINFO = packed record
    cbSize: DWORD;
    rcItem: TRect;
    rcButton: TRect;
    stateButton: DWORD;
    hwndCombo: HWND;
    hwndItem: HWND;
    hwndList: HWND;
  end;
  {$EXTERNALSYM TComboBoxInfo}
  TComboBoxInfo = tagCOMBOBOXINFO;

{$EXTERNALSYM GetComboBoxInfo}
Function GetComboBoxInfo(hwndCombo: HWND; var pcbi: TComboBoxInfo): BOOL; stdcall;

const
  { The "real" ancestor window }
  {$EXTERNALSYM GA_MIC}
  GA_MIC       =   1;
  {$EXTERNALSYM GA_PARENT}
  GA_PARENT    =   1;
  {$EXTERNALSYM GA_ROOT}
  GA_ROOT      =   2;
  {$EXTERNALSYM GA_ROOTOWNER}
  GA_ROOTOWNER =   3;
  {$EXTERNALSYM GA_MAC}
  GA_MAC       =   4;

{$EXTERNALSYM GetAncestor}
FUNCTION GetAncestor(hwnd: HWND; gaFlags: UINT): HWND; stdcall;

{$EXTERNALSYM RealChildWindowFromPoint}
FUNCTION RealChildWindowFromPoint(hwndParent: HWND; ptParentClientCoords: TPoint): HWND; stdcall;

{$EXTERNALSYM RealGetWindowClass}
function RealGetWindowClass(hwnd: HWND; pszType: PChar; cchType: UINT): UINT; stdcall;
{$EXTERNALSYM RealGetWindowClassA}
function RealGetWindowClassA(hwnd: HWND; pszType: PAnsiChar; cchType: UINT): UINT; stdcall;
{$EXTERNALSYM RealGetWindowClassW}
function RealGetWindowClassW(hwnd: HWND; pszType: PWideChar; cchType: UINT): UINT; stdcall;

type
  { Alt-Tab Switch window information. }
  {$EXTERNALSYM PAltTabInfo}
  PAltTabInfo = ^TAltTabInfo;
  {$EXTERNALSYM tagALTTABINFO}
  tagALTTABINFO = packed record
    cbSize: DWORD;
    cItems: Integer;
    cColumns: Integer;
    cRows: Integer;
    iColFocus: Integer;
    iRowFocus: Integer;
    cxItem: Integer;
    cyItem: Integer;
    ptStart: TPoint;
  end;
  {$EXTERNALSYM TAltTabInfo}
  TAltTabInfo = tagALTTABINFO;

{$EXTERNALSYM GetAltTabInfo}
function GetAltTabInfo(hwnd: HWND; iItem: Integer; var pati: TAltTabInfo;
  pszItemText: PChar; cchItemText: UINT): BOOL; stdcall;
{$EXTERNALSYM GetAltTabInfoA}
function GetAltTabInfoA(hwnd: HWND; iItem: Integer; var pati: TAltTabInfo;
  pszItemText: PAnsiChar; cchItemText: UINT): BOOL; stdcall;
{$EXTERNALSYM GetAltTabInfoW}
function GetAltTabInfoW(hwnd: HWND; iItem: Integer; var pati: TAltTabInfo;
  pszItemText: PWideChar; cchItemText: UINT): BOOL; stdcall;

{ Listbox information. Returns the number of items per row. }
{$EXTERNALSYM GetListBoxInfo}
function GetListBoxInfo(hwnd: HWND): DWORD; stdcall;
{$EXTERNALSYM LockWorkStation}
function LockWorkStation: BOOL; stdcall;
{$EXTERNALSYM UserHandleGrantAccess}
function UserHandleGrantAccess(hUserHandle, hJob: THandle): BOOL; stdcall;

{ Translated from WINNLS.H }

const

{ String Length Maximums. }

  {$EXTERNALSYM MAX_LEADBYTES}
  MAX_LEADBYTES = 12; { 5 ranges, 2 bytes ea., 0 term. }
  {$EXTERNALSYM MAX_DEFAULTCHAR}
  MAX_DEFAULTCHAR = 2; { single or double byte }

{ MBCS and Unicode Translation Flags. }

  {$EXTERNALSYM MB_PRECOMPOSED}
  MB_PRECOMPOSED = 1; { use precomposed chars }
  {$EXTERNALSYM MB_COMPOSITE}
  MB_COMPOSITE = 2; { use composite chars }
  {$EXTERNALSYM MB_USEGLYPHCHARS}
  MB_USEGLYPHCHARS = 4; { use glyph chars, not ctrl chars }

  {$EXTERNALSYM WC_DEFAULTCHECK}
  WC_DEFAULTCHECK = $100; { check for default char }
  {$EXTERNALSYM WC_COMPOSITECHECK}
  WC_COMPOSITECHECK = $200; { convert composite to precomposed }
  {$EXTERNALSYM WC_DISCARDNS}
  WC_DISCARDNS = $10; { discard non-spacing chars }
  {$EXTERNALSYM WC_SEPCHARS}
  WC_SEPCHARS = $20; { generate separate chars }
  {$EXTERNALSYM WC_DEFAULTCHAR}
  WC_DEFAULTCHAR = $40; { replace w default char }

{ Character Type Flags. }

  {$EXTERNALSYM CT_CTYPE1}
  CT_CTYPE1 = 1; { ctype 1 information }
  {$EXTERNALSYM CT_CTYPE2}
  CT_CTYPE2 = 2; { ctype 2 information }
  {$EXTERNALSYM CT_CTYPE3}
  CT_CTYPE3 = 4; { ctype 3 information }

{ CType 1 Flag Bits. }

  {$EXTERNALSYM C1_UPPER}
  C1_UPPER = 1; { upper case }
  {$EXTERNALSYM C1_LOWER}
  C1_LOWER = 2; { lower case }
  {$EXTERNALSYM C1_DIGIT}
  C1_DIGIT = 4; { decimal digits }
  {$EXTERNALSYM C1_SPACE}
  C1_SPACE = 8; { spacing characters }
  {$EXTERNALSYM C1_PUNCT}
  C1_PUNCT = $10; { punctuation characters }
  {$EXTERNALSYM C1_CNTRL}
  C1_CNTRL = $20; { control characters }
  {$EXTERNALSYM C1_BLANK}
  C1_BLANK = $40; { blank characters }
  {$EXTERNALSYM C1_XDIGIT}
  C1_XDIGIT = $80; { other digits }
  {$EXTERNALSYM C1_ALPHA}
  C1_ALPHA = $100; { any letter }

{ CType 2 Flag Bits. }

  {$EXTERNALSYM C2_LEFTTORIGHT}
  C2_LEFTTORIGHT = 1; { left to right }
  {$EXTERNALSYM C2_RIGHTTOLEFT}
  C2_RIGHTTOLEFT = 2; { right to left }
  {$EXTERNALSYM C2_EUROPENUMBER}
  C2_EUROPENUMBER = 3; { European number, digit }
  {$EXTERNALSYM C2_EUROPESEPARATOR}
  C2_EUROPESEPARATOR = 4; { European numeric separator }
  {$EXTERNALSYM C2_EUROPETERMINATOR}
  C2_EUROPETERMINATOR = 5; { European numeric terminator }
  {$EXTERNALSYM C2_ARABICNUMBER}
  C2_ARABICNUMBER = 6; { Arabic number }
  {$EXTERNALSYM C2_COMMONSEPARATOR}
  C2_COMMONSEPARATOR = 7; { common numeric separator }
  {$EXTERNALSYM C2_BLOCKSEPARATOR}
  C2_BLOCKSEPARATOR = 8; { block separator }
  {$EXTERNALSYM C2_SEGMENTSEPARATOR}
  C2_SEGMENTSEPARATOR = 9; { segment separator }
  {$EXTERNALSYM C2_WHITESPACE}
  C2_WHITESPACE = 10; { white space }
  {$EXTERNALSYM C2_OTHERNEUTRAL}
  C2_OTHERNEUTRAL = 11; { other neutrals }
  {$EXTERNALSYM C2_NOTAPPLICABLE}
  C2_NOTAPPLICABLE = 0; { no implicit directionality }

{ CType 3 Flag Bits. }

  {$EXTERNALSYM C3_NONSPACING}
  C3_NONSPACING = 1; { nonspacing character }
  {$EXTERNALSYM C3_DIACRITIC}
  C3_DIACRITIC = 2; { diacritic mark }
  {$EXTERNALSYM C3_VOWELMARK}
  C3_VOWELMARK = 4; { vowel mark }
  {$EXTERNALSYM C3_SYMBOL}
  C3_SYMBOL = 8; { symbols }
  {$EXTERNALSYM C3_KATAKANA}
  C3_KATAKANA = $0010; { katakana character }
  {$EXTERNALSYM C3_HIRAGANA}
  C3_HIRAGANA = $0020; { hiragana character }
  {$EXTERNALSYM C3_HALFWIDTH}
  C3_HALFWIDTH = $0040; { half width character }
  {$EXTERNALSYM C3_FULLWIDTH}
  C3_FULLWIDTH = $0080; { full width character }
  {$EXTERNALSYM C3_IDEOGRAPH}
  C3_IDEOGRAPH = $0100; { ideographic character }
  {$EXTERNALSYM C3_KASHIDA}
  C3_KASHIDA = $0200; { Arabic kashida character }
  {$EXTERNALSYM C3_LEXICAL}
  C3_LEXICAL = $0400; { lexical character }
  {$EXTERNALSYM C3_ALPHA}
  C3_ALPHA = $8000; { any linguistic char (C1_ALPHA) }
  {$EXTERNALSYM C3_NOTAPPLICABLE}
  C3_NOTAPPLICABLE = 0; { ctype 3 is not applicable }

{ String Flags. }

  {$EXTERNALSYM NORM_IGNORECASE}
  NORM_IGNORECASE = 1; { ignore case }
  {$EXTERNALSYM NORM_IGNORENONSPACE}
  NORM_IGNORENONSPACE = 2; { ignore nonspacing chars }
  {$EXTERNALSYM NORM_IGNORESYMBOLS}
  NORM_IGNORESYMBOLS = 4; { ignore symbols }
  {$EXTERNALSYM NORM_IGNOREKANATYPE}
  NORM_IGNOREKANATYPE = $10000;
  {$EXTERNALSYM NORM_IGNOREWIDTH}
  NORM_IGNOREWIDTH = $20000;

{ Locale Independent Mapping Flags. }

  {$EXTERNALSYM MAP_FOLDCZONE}
  MAP_FOLDCZONE = $10; { fold compatibility zone chars }
  {$EXTERNALSYM MAP_PRECOMPOSED}
  MAP_PRECOMPOSED = $20; { convert to precomposed chars }
  {$EXTERNALSYM MAP_COMPOSITE}
  MAP_COMPOSITE = $40; { convert to composite chars }
  {$EXTERNALSYM MAP_FOLDDIGITS}
  MAP_FOLDDIGITS = $80; { all digits to ASCII 0-9 }

{ Locale Dependent Mapping Flags. }

  {$EXTERNALSYM LCMAP_LOWERCASE}
  LCMAP_LOWERCASE = $00000100;              { lower case letters }
  {$EXTERNALSYM LCMAP_UPPERCASE}
  LCMAP_UPPERCASE = $00000200;              { upper case letters }
  {$EXTERNALSYM LCMAP_SORTKEY}
  LCMAP_SORTKEY = $00000400;                { WC sort key (normalize) }
  {$EXTERNALSYM LCMAP_BYTEREV}
  LCMAP_BYTEREV = $00000800;                { byte reversal }

  {$EXTERNALSYM LCMAP_HIRAGANA}
  LCMAP_HIRAGANA = $00100000;               { map katakana to hiragana }
  {$EXTERNALSYM LCMAP_KATAKANA}
  LCMAP_KATAKANA = $00200000;               { map hiragana to katakana }
  {$EXTERNALSYM LCMAP_HALFWIDTH}
  LCMAP_HALFWIDTH = $00400000;              { map double byte to single byte }
  {$EXTERNALSYM LCMAP_FULLWIDTH}
  LCMAP_FULLWIDTH = $00800000;              { map single byte to double byte }

  {$EXTERNALSYM LCMAP_LINGUISTIC_CASING}
  LCMAP_LINGUISTIC_CASING = $01000000;      { use linguistic rules for casing }

  {$EXTERNALSYM LCMAP_SIMPLIFIED_CHINESE}
  LCMAP_SIMPLIFIED_CHINESE      = $02000000;  { map traditional chinese to simplified chinese }
  {$EXTERNALSYM LCMAP_TRADITIONAL_CHINESE}
  LCMAP_TRADITIONAL_CHINESE     = $04000000;  { map simplified chinese to traditional chinese }

{ Locale Enumeration Flags. }

  {$EXTERNALSYM LCID_INSTALLED}
  LCID_INSTALLED          = $00000001;  { installed locale ids }
  {$EXTERNALSYM LCID_SUPPORTED}
  LCID_SUPPORTED          = $00000002;  { supported locale ids }
  {$EXTERNALSYM LCID_ALTERNATE_SORTS}
  LCID_ALTERNATE_SORTS    = $00000004;  { alternate sort locale ids }

{ Code Page Enumeration Flags. }

  {$EXTERNALSYM CP_INSTALLED}
  CP_INSTALLED            = $00000001;  { installed code page ids }
  {$EXTERNALSYM CP_SUPPORTED}
  CP_SUPPORTED            = $00000002;  { supported code page ids }


{ Sorting Flags.

     WORD Sort:    culturally correct sort
                   hyphen and apostrophe are special cased
                   example: "coop" and "co-op" will sort together in a list

                         co_op     <-------  underscore (symbol)
                         coat
                         comb
                         coop
                         co-op     <-------  hyphen (punctuation)
                         cork
                         went
                         were
                         we're     <-------  apostrophe (punctuation)


     STRING Sort:  hyphen and apostrophe will sort with all other symbols

                         co-op     <-------  hyphen (punctuation)
                         co_op     <-------  underscore (symbol)
                         coat
                         comb
                         coop
                         cork
                         we're     <-------  apostrophe (punctuation)
                         went
                         were
 }

  {$EXTERNALSYM SORT_STRINGSORT}
  SORT_STRINGSORT = $1000; { use string sort method }

{ Compare String Return Values }

  {$EXTERNALSYM CSTR_LESS_THAN}
  CSTR_LESS_THAN           = 1;             { string 1 less than string 2 }
  {$EXTERNALSYM CSTR_EQUAL}
  CSTR_EQUAL               = 2;             { string 1 equal to string 2 }
  {$EXTERNALSYM CSTR_GREATER_THAN}
  CSTR_GREATER_THAN        = 3;             { string 1 greater than string 2 }

{ Code Page Default Values. }

  {$EXTERNALSYM CP_ACP}
  CP_ACP                   = 0;             { default to ANSI code page }
  {$EXTERNALSYM CP_OEMCP}
  CP_OEMCP                 = 1;             { default to OEM  code page }
  {$EXTERNALSYM CP_MACCP}
  CP_MACCP                 = 2;             { default to MAC  code page }
  {$EXTERNALSYM CP_THREAD_ACP}
  CP_THREAD_ACP            = 3;             { current thread's ANSI code page }
  {$EXTERNALSYM CP_SYMBOL}
  CP_SYMBOL                = 42;            { SYMBOL translations }

  {$EXTERNALSYM CP_UTF7}
  CP_UTF7                  = 65000;         { UTF-7 translation }
  {$EXTERNALSYM CP_UTF8}
  CP_UTF8                  = 65001;         { UTF-8 translation }

{ Country Codes. }

  {$EXTERNALSYM CTRY_DEFAULT}
  CTRY_DEFAULT = 0;
  {$EXTERNALSYM CTRY_AUSTRALIA}
  CTRY_AUSTRALIA = 61; { Australia }
  {$EXTERNALSYM CTRY_AUSTRIA}
  CTRY_AUSTRIA = 43; { Austria }
  {$EXTERNALSYM CTRY_BELGIUM}
  CTRY_BELGIUM = $20; { Belgium }
  {$EXTERNALSYM CTRY_BRAZIL}
  CTRY_BRAZIL = 55; { Brazil }
  {$EXTERNALSYM CTRY_CANADA}
  CTRY_CANADA = 2; { Canada }
  {$EXTERNALSYM CTRY_DENMARK}
  CTRY_DENMARK = 45; { Denmark }
  {$EXTERNALSYM CTRY_FINLAND}
  CTRY_FINLAND = 358; { Finland }
  {$EXTERNALSYM CTRY_FRANCE}
  CTRY_FRANCE = 33; { France }
  {$EXTERNALSYM CTRY_GERMANY}
  CTRY_GERMANY = 49; { Germany }
  {$EXTERNALSYM CTRY_ICELAND}
  CTRY_ICELAND = 354; { Iceland }
  {$EXTERNALSYM CTRY_IRELAND}
  CTRY_IRELAND = 353; { Ireland }
  {$EXTERNALSYM CTRY_ITALY}
  CTRY_ITALY = 39; { Italy }
  {$EXTERNALSYM CTRY_JAPAN}
  CTRY_JAPAN = 81; { Japan }
  {$EXTERNALSYM CTRY_MEXICO}
  CTRY_MEXICO = 52; { Mexico }
  {$EXTERNALSYM CTRY_NETHERLANDS}
  CTRY_NETHERLANDS = 31; { Netherlands }
  {$EXTERNALSYM CTRY_NEW_ZEALAND}
  CTRY_NEW_ZEALAND = $40; { New Zealand }
  {$EXTERNALSYM CTRY_NORWAY}
  CTRY_NORWAY = 47; { Norway }
  {$EXTERNALSYM CTRY_PORTUGAL}
  CTRY_PORTUGAL = 351; { Portugal }
  {$EXTERNALSYM CTRY_PRCHINA}
  CTRY_PRCHINA = 86; { PR China }
  {$EXTERNALSYM CTRY_SOUTH_KOREA}
  CTRY_SOUTH_KOREA = 82; { South Korea }
  {$EXTERNALSYM CTRY_SPAIN}
  CTRY_SPAIN = 34; { Spain }
  {$EXTERNALSYM CTRY_SWEDEN}
  CTRY_SWEDEN = 46; { Sweden }
  {$EXTERNALSYM CTRY_SWITZERLAND}
  CTRY_SWITZERLAND = 41; { Switzerland }
  {$EXTERNALSYM CTRY_TAIWAN}
  CTRY_TAIWAN = 886; { Taiwan }
  {$EXTERNALSYM CTRY_UNITED_KINGDOM}
  CTRY_UNITED_KINGDOM = 44; { United Kingdom }
  {$EXTERNALSYM CTRY_UNITED_STATES}
  CTRY_UNITED_STATES = 1; { United States }

{ Locale Types.
  These types are used for the GetLocaleInfoW NLS API routine. }

{ LOCALE_NOUSEROVERRIDE is also used in GetTimeFormatW and GetDateFormatW. }

  {$EXTERNALSYM LOCALE_NOUSEROVERRIDE}
  LOCALE_NOUSEROVERRIDE           = DWORD($80000000);   { do not use user overrides }
  {$EXTERNALSYM LOCALE_USE_CP_ACP}
  LOCALE_USE_CP_ACP               = $40000000;   { use the system ACP }

  {$EXTERNALSYM LOCALE_ILANGUAGE}
  LOCALE_ILANGUAGE                = $00000001;   { language id }
  {$EXTERNALSYM LOCALE_SLANGUAGE}
  LOCALE_SLANGUAGE                = $00000002;   { localized name of language }
  {$EXTERNALSYM LOCALE_SENGLANGUAGE}
  LOCALE_SENGLANGUAGE             = $00001001;   { English name of language }
  {$EXTERNALSYM LOCALE_SABBREVLANGNAME}
  LOCALE_SABBREVLANGNAME          = $00000003;   { abbreviated language name }
  {$EXTERNALSYM LOCALE_SNATIVELANGNAME}
  LOCALE_SNATIVELANGNAME          = $00000004;   { native name of language }

  {$EXTERNALSYM LOCALE_ICOUNTRY}
  LOCALE_ICOUNTRY                 = $00000005;   { country code }
  {$EXTERNALSYM LOCALE_SCOUNTRY}
  LOCALE_SCOUNTRY                 = $00000006;   { localized name of country }
  {$EXTERNALSYM LOCALE_SENGCOUNTRY}
  LOCALE_SENGCOUNTRY              = $00001002;   { English name of country }
  {$EXTERNALSYM LOCALE_SABBREVCTRYNAME}
  LOCALE_SABBREVCTRYNAME          = $00000007;   { abbreviated country name }
  {$EXTERNALSYM LOCALE_SNATIVECTRYNAME}
  LOCALE_SNATIVECTRYNAME          = $00000008;   { native name of country }

  {$EXTERNALSYM LOCALE_IDEFAULTLANGUAGE}
  LOCALE_IDEFAULTLANGUAGE         = $00000009;   { default language id }
  {$EXTERNALSYM LOCALE_IDEFAULTCOUNTRY}
  LOCALE_IDEFAULTCOUNTRY          = $0000000A;   { default country code }
  {$EXTERNALSYM LOCALE_IDEFAULTCODEPAGE}
  LOCALE_IDEFAULTCODEPAGE         = $0000000B;   { default oem code page }
  {$EXTERNALSYM LOCALE_IDEFAULTANSICODEPAGE}
  LOCALE_IDEFAULTANSICODEPAGE     = $00001004;   { default ansi code page }
  {$EXTERNALSYM LOCALE_IDEFAULTMACCODEPAGE}
  LOCALE_IDEFAULTMACCODEPAGE      = $00001011;   { default mac code page }

  {$EXTERNALSYM LOCALE_SLIST}
  LOCALE_SLIST                    = $0000000C;   { list item separator }
  {$EXTERNALSYM LOCALE_IMEASURE}
  LOCALE_IMEASURE                 = $0000000D;   { 0 = metric, 1 = US }

  {$EXTERNALSYM LOCALE_SDECIMAL}
  LOCALE_SDECIMAL                 = $0000000E;   { decimal separator }
  {$EXTERNALSYM LOCALE_STHOUSAND}
  LOCALE_STHOUSAND                = $0000000F;   { thousand separator }
  {$EXTERNALSYM LOCALE_SGROUPING}
  LOCALE_SGROUPING                = $00000010;   { digit grouping }
  {$EXTERNALSYM LOCALE_IDIGITS}
  LOCALE_IDIGITS                  = $00000011;   { number of fractional digits }
  {$EXTERNALSYM LOCALE_ILZERO}
  LOCALE_ILZERO                   = $00000012;   { leading zeros for decimal }
  {$EXTERNALSYM LOCALE_INEGNUMBER}
  LOCALE_INEGNUMBER               = $00001010;   { negative number mode }
  {$EXTERNALSYM LOCALE_SNATIVEDIGITS}
  LOCALE_SNATIVEDIGITS            = $00000013;   { native ascii 0-9 }

  {$EXTERNALSYM LOCALE_SCURRENCY}
  LOCALE_SCURRENCY                = $00000014;   { local monetary symbol }
  {$EXTERNALSYM LOCALE_SINTLSYMBOL}
  LOCALE_SINTLSYMBOL              = $00000015;   { intl monetary symbol }
  {$EXTERNALSYM LOCALE_SMONDECIMALSEP}
  LOCALE_SMONDECIMALSEP           = $00000016;   { monetary decimal separator }
  {$EXTERNALSYM LOCALE_SMONTHOUSANDSEP}
  LOCALE_SMONTHOUSANDSEP          = $00000017;   { monetary thousand separator }
  {$EXTERNALSYM LOCALE_SMONGROUPING}
  LOCALE_SMONGROUPING             = $00000018;   { monetary grouping }
  {$EXTERNALSYM LOCALE_ICURRDIGITS}
  LOCALE_ICURRDIGITS              = $00000019;   { # local monetary digits }
  {$EXTERNALSYM LOCALE_IINTLCURRDIGITS}
  LOCALE_IINTLCURRDIGITS          = $0000001A;   { # intl monetary digits }
  {$EXTERNALSYM LOCALE_ICURRENCY}
  LOCALE_ICURRENCY                = $0000001B;   { positive currency mode }
  {$EXTERNALSYM LOCALE_INEGCURR}
  LOCALE_INEGCURR                 = $0000001C;   { negative currency mode }

  {$EXTERNALSYM LOCALE_SDATE}
  LOCALE_SDATE                    = $0000001D;   { date separator }
  {$EXTERNALSYM LOCALE_STIME}
  LOCALE_STIME                    = $0000001E;   { time separator }
  {$EXTERNALSYM LOCALE_SSHORTDATE}
  LOCALE_SSHORTDATE               = $0000001F;   { short date format string }
  {$EXTERNALSYM LOCALE_SLONGDATE}
  LOCALE_SLONGDATE                = $00000020;   { long date format string }
  {$EXTERNALSYM LOCALE_STIMEFORMAT}
  LOCALE_STIMEFORMAT              = $00001003;   { time format string }
  {$EXTERNALSYM LOCALE_IDATE}
  LOCALE_IDATE                    = $00000021;   { short date format ordering }
  {$EXTERNALSYM LOCALE_ILDATE}
  LOCALE_ILDATE                   = $00000022;   { long date format ordering }
  {$EXTERNALSYM LOCALE_ITIME}
  LOCALE_ITIME                    = $00000023;   { time format specifier }
  {$EXTERNALSYM LOCALE_ITIMEMARKPOSN}
  LOCALE_ITIMEMARKPOSN            = $00001005;   { time marker position }
  {$EXTERNALSYM LOCALE_ICENTURY}
  LOCALE_ICENTURY                 = $00000024;   { century format specifier (short date) }
  {$EXTERNALSYM LOCALE_ITLZERO}
  LOCALE_ITLZERO                  = $00000025;   { leading zeros in time field }
  {$EXTERNALSYM LOCALE_IDAYLZERO}
  LOCALE_IDAYLZERO                = $00000026;   { leading zeros in day field (short date) }
  {$EXTERNALSYM LOCALE_IMONLZERO}
  LOCALE_IMONLZERO                = $00000027;   { leading zeros in month field (short date) }
  {$EXTERNALSYM LOCALE_S1159}
  LOCALE_S1159                    = $00000028;   { AM designator }
  {$EXTERNALSYM LOCALE_S2359}
  LOCALE_S2359                    = $00000029;   { PM designator }

  {$EXTERNALSYM LOCALE_ICALENDARTYPE}
  LOCALE_ICALENDARTYPE            = $00001009;   { type of calendar specifier }
  {$EXTERNALSYM LOCALE_IOPTIONALCALENDAR}
  LOCALE_IOPTIONALCALENDAR        = $0000100B;   { additional calendar types specifier }
  {$EXTERNALSYM LOCALE_IFIRSTDAYOFWEEK}
  LOCALE_IFIRSTDAYOFWEEK          = $0000100C;   { first day of week specifier }
  {$EXTERNALSYM LOCALE_IFIRSTWEEKOFYEAR}
  LOCALE_IFIRSTWEEKOFYEAR         = $0000100D;   { first week of year specifier }

  {$EXTERNALSYM LOCALE_SDAYNAME1}
  LOCALE_SDAYNAME1                = $0000002A;   { long name for Monday }
  {$EXTERNALSYM LOCALE_SDAYNAME2}
  LOCALE_SDAYNAME2                = $0000002B;   { long name for Tuesday }
  {$EXTERNALSYM LOCALE_SDAYNAME3}
  LOCALE_SDAYNAME3                = $0000002C;   { long name for Wednesday }
  {$EXTERNALSYM LOCALE_SDAYNAME4}
  LOCALE_SDAYNAME4                = $0000002D;   { long name for Thursday }
  {$EXTERNALSYM LOCALE_SDAYNAME5}
  LOCALE_SDAYNAME5                = $0000002E;   { long name for Friday }
  {$EXTERNALSYM LOCALE_SDAYNAME6}
  LOCALE_SDAYNAME6                = $0000002F;   { long name for Saturday }
  {$EXTERNALSYM LOCALE_SDAYNAME7}
  LOCALE_SDAYNAME7                = $00000030;   { long name for Sunday }
  {$EXTERNALSYM LOCALE_SABBREVDAYNAME1}
  LOCALE_SABBREVDAYNAME1          = $00000031;   { abbreviated name for Monday }
  {$EXTERNALSYM LOCALE_SABBREVDAYNAME2}
  LOCALE_SABBREVDAYNAME2          = $00000032;   { abbreviated name for Tuesday }
  {$EXTERNALSYM LOCALE_SABBREVDAYNAME3}
  LOCALE_SABBREVDAYNAME3          = $00000033;   { abbreviated name for Wednesday }
  {$EXTERNALSYM LOCALE_SABBREVDAYNAME4}
  LOCALE_SABBREVDAYNAME4          = $00000034;   { abbreviated name for Thursday }
  {$EXTERNALSYM LOCALE_SABBREVDAYNAME5}
  LOCALE_SABBREVDAYNAME5          = $00000035;   { abbreviated name for Friday }
  {$EXTERNALSYM LOCALE_SABBREVDAYNAME6}
  LOCALE_SABBREVDAYNAME6          = $00000036;   { abbreviated name for Saturday }
  {$EXTERNALSYM LOCALE_SABBREVDAYNAME7}
  LOCALE_SABBREVDAYNAME7          = $00000037;   { abbreviated name for Sunday }
  {$EXTERNALSYM LOCALE_SMONTHNAME1}
  LOCALE_SMONTHNAME1              = $00000038;   { long name for January }
  {$EXTERNALSYM LOCALE_SMONTHNAME2}
  LOCALE_SMONTHNAME2              = $00000039;   { long name for February }
  {$EXTERNALSYM LOCALE_SMONTHNAME3}
  LOCALE_SMONTHNAME3              = $0000003A;   { long name for March }
  {$EXTERNALSYM LOCALE_SMONTHNAME4}
  LOCALE_SMONTHNAME4              = $0000003B;   { long name for April }
  {$EXTERNALSYM LOCALE_SMONTHNAME5}
  LOCALE_SMONTHNAME5              = $0000003C;   { long name for May }
  {$EXTERNALSYM LOCALE_SMONTHNAME6}
  LOCALE_SMONTHNAME6              = $0000003D;   { long name for June }
  {$EXTERNALSYM LOCALE_SMONTHNAME7}
  LOCALE_SMONTHNAME7              = $0000003E;   { long name for July }
  {$EXTERNALSYM LOCALE_SMONTHNAME8}
  LOCALE_SMONTHNAME8              = $0000003F;   { long name for August }
  {$EXTERNALSYM LOCALE_SMONTHNAME9}
  LOCALE_SMONTHNAME9              = $00000040;   { long name for September }
  {$EXTERNALSYM LOCALE_SMONTHNAME10}
  LOCALE_SMONTHNAME10             = $00000041;   { long name for October }
  {$EXTERNALSYM LOCALE_SMONTHNAME11}
  LOCALE_SMONTHNAME11             = $00000042;   { long name for November }
  {$EXTERNALSYM LOCALE_SMONTHNAME12}
  LOCALE_SMONTHNAME12             = $00000043;   { long name for December }
  {$EXTERNALSYM LOCALE_SMONTHNAME13}
  LOCALE_SMONTHNAME13             = $0000100E;   { long name for 13th month (if exists) }
  {$EXTERNALSYM LOCALE_SABBREVMONTHNAME1}
  LOCALE_SABBREVMONTHNAME1        = $00000044;   { abbreviated name for January }
  {$EXTERNALSYM LOCALE_SABBREVMONTHNAME2}
  LOCALE_SABBREVMONTHNAME2        = $00000045;   { abbreviated name for February }
  {$EXTERNALSYM LOCALE_SABBREVMONTHNAME3}
  LOCALE_SABBREVMONTHNAME3        = $00000046;   { abbreviated name for March }
  {$EXTERNALSYM LOCALE_SABBREVMONTHNAME4}
  LOCALE_SABBREVMONTHNAME4        = $00000047;   { abbreviated name for April }
  {$EXTERNALSYM LOCALE_SABBREVMONTHNAME5}
  LOCALE_SABBREVMONTHNAME5        = $00000048;   { abbreviated name for May }
  {$EXTERNALSYM LOCALE_SABBREVMONTHNAME6}
  LOCALE_SABBREVMONTHNAME6        = $00000049;   { abbreviated name for June }
  {$EXTERNALSYM LOCALE_SABBREVMONTHNAME7}
  LOCALE_SABBREVMONTHNAME7        = $0000004A;   { abbreviated name for July }
  {$EXTERNALSYM LOCALE_SABBREVMONTHNAME8}
  LOCALE_SABBREVMONTHNAME8        = $0000004B;   { abbreviated name for August }
  {$EXTERNALSYM LOCALE_SABBREVMONTHNAME9}
  LOCALE_SABBREVMONTHNAME9        = $0000004C;   { abbreviated name for September }
  {$EXTERNALSYM LOCALE_SABBREVMONTHNAME10}
  LOCALE_SABBREVMONTHNAME10       = $0000004D;   { abbreviated name for October }
  {$EXTERNALSYM LOCALE_SABBREVMONTHNAME11}
  LOCALE_SABBREVMONTHNAME11       = $0000004E;   { abbreviated name for November }
  {$EXTERNALSYM LOCALE_SABBREVMONTHNAME12}
  LOCALE_SABBREVMONTHNAME12       = $0000004F;   { abbreviated name for December }
  {$EXTERNALSYM LOCALE_SABBREVMONTHNAME13}
  LOCALE_SABBREVMONTHNAME13       = $0000100F;   { abbreviated name for 13th month (if exists) }

  {$EXTERNALSYM LOCALE_SPOSITIVESIGN}
  LOCALE_SPOSITIVESIGN            = $00000050;   { positive sign }
  {$EXTERNALSYM LOCALE_SNEGATIVESIGN}
  LOCALE_SNEGATIVESIGN            = $00000051;   { negative sign }
  {$EXTERNALSYM LOCALE_IPOSSIGNPOSN}
  LOCALE_IPOSSIGNPOSN             = $00000052;   { positive sign position }
  {$EXTERNALSYM LOCALE_INEGSIGNPOSN}
  LOCALE_INEGSIGNPOSN             = $00000053;   { negative sign position }
  {$EXTERNALSYM LOCALE_IPOSSYMPRECEDES}
  LOCALE_IPOSSYMPRECEDES          = $00000054;   { mon sym precedes pos amt }
  {$EXTERNALSYM LOCALE_IPOSSEPBYSPACE}
  LOCALE_IPOSSEPBYSPACE           = $00000055;   { mon sym sep by space from pos amt }
  {$EXTERNALSYM LOCALE_INEGSYMPRECEDES}
  LOCALE_INEGSYMPRECEDES          = $00000056;   { mon sym precedes neg amt }
  {$EXTERNALSYM LOCALE_INEGSEPBYSPACE}
  LOCALE_INEGSEPBYSPACE           = $00000057;   { mon sym sep by space from neg amt }

  {$EXTERNALSYM LOCALE_FONTSIGNATURE}
  LOCALE_FONTSIGNATURE            = $00000058;   { font signature }
  {$EXTERNALSYM LOCALE_SISO639LANGNAME}
  LOCALE_SISO639LANGNAME          = $00000059;   { ISO abbreviated language name }
  {$EXTERNALSYM LOCALE_SISO3166CTRYNAME}
  LOCALE_SISO3166CTRYNAME         = $0000005A;   { ISO abbreviated country name }

{ Time Flags for GetTimeFormatW. }

  {$EXTERNALSYM TIME_NOMINUTESORSECONDS}
  TIME_NOMINUTESORSECONDS = 1; { do not use minutes or seconds }
  {$EXTERNALSYM TIME_NOSECONDS}
  TIME_NOSECONDS = 2; { do not use seconds }
  {$EXTERNALSYM TIME_NOTIMEMARKER}
  TIME_NOTIMEMARKER = 4; { do not use time marker }
  {$EXTERNALSYM TIME_FORCE24HOURFORMAT}
  TIME_FORCE24HOURFORMAT = 8; { always use 24 hour format }

{ Date Flags for GetDateFormatW. }

  {$EXTERNALSYM DATE_SHORTDATE}
  DATE_SHORTDATE = 1; { use short date picture }
  {$EXTERNALSYM DATE_LONGDATE}
  DATE_LONGDATE = 2; { use long date picture }
  {$EXTERNALSYM DATE_USE_ALT_CALENDAR}
  DATE_USE_ALT_CALENDAR = 4;   { use alternate calendar (if any) }

{ Calendar Types.
  These types are used for the GetALTCalendarInfoW NLS API routine. }

  {$EXTERNALSYM CAL_ICALINTVALUE}
  CAL_ICALINTVALUE = 1;   { calendar type }
  {$EXTERNALSYM CAL_SCALNAME}
  CAL_SCALNAME = 2;   { native name of calendar }
  {$EXTERNALSYM CAL_IYEAROFFSETRANGE}
  CAL_IYEAROFFSETRANGE = 3;   { starting years of eras }
  {$EXTERNALSYM CAL_SERASTRING}
  CAL_SERASTRING = 4;   { era name for IYearOffsetRanges }
  {$EXTERNALSYM CAL_SSHORTDATE}
  CAL_SSHORTDATE = 5;   { short date format string }
  {$EXTERNALSYM CAL_SLONGDATE}
  CAL_SLONGDATE = 6;   { long date format string }
  {$EXTERNALSYM CAL_SDAYNAME1}
  CAL_SDAYNAME1 = 7;   { native name for Monday }
  {$EXTERNALSYM CAL_SDAYNAME2}
  CAL_SDAYNAME2 = 8;   { native name for Tuesday }
  {$EXTERNALSYM CAL_SDAYNAME3}
  CAL_SDAYNAME3 = 9;   { native name for Wednesday }
  {$EXTERNALSYM CAL_SDAYNAME4}
  CAL_SDAYNAME4 = 10;   { native name for Thursday }
  {$EXTERNALSYM CAL_SDAYNAME5}
  CAL_SDAYNAME5 = 11;   { native name for Friday }
  {$EXTERNALSYM CAL_SDAYNAME6}
  CAL_SDAYNAME6 = 12;   { native name for Saturday }
  {$EXTERNALSYM CAL_SDAYNAME7}
  CAL_SDAYNAME7 = 13;   { native name for Sunday }
  {$EXTERNALSYM CAL_SABBREVDAYNAME1}
  CAL_SABBREVDAYNAME1 = 14;   { abbreviated name for Monday }
  {$EXTERNALSYM CAL_SABBREVDAYNAME2}
  CAL_SABBREVDAYNAME2 = 15;   { abbreviated name for Tuesday }
  {$EXTERNALSYM CAL_SABBREVDAYNAME3}
  CAL_SABBREVDAYNAME3 = $10;   { abbreviated name for Wednesday }
  {$EXTERNALSYM CAL_SABBREVDAYNAME4}
  CAL_SABBREVDAYNAME4 = 17;   { abbreviated name for Thursday }
  {$EXTERNALSYM CAL_SABBREVDAYNAME5}
  CAL_SABBREVDAYNAME5 = 18;   { abbreviated name for Friday }
  {$EXTERNALSYM CAL_SABBREVDAYNAME6}
  CAL_SABBREVDAYNAME6 = 19;   { abbreviated name for Saturday }
  {$EXTERNALSYM CAL_SABBREVDAYNAME7}
  CAL_SABBREVDAYNAME7 = 20;   { abbreviated name for Sunday }
  {$EXTERNALSYM CAL_SMONTHNAME1}
  CAL_SMONTHNAME1 = 21;   { native name for January }
  {$EXTERNALSYM CAL_SMONTHNAME2}
  CAL_SMONTHNAME2 = 22;   { native name for February }
  {$EXTERNALSYM CAL_SMONTHNAME3}
  CAL_SMONTHNAME3 = 23;   { native name for March }
  {$EXTERNALSYM CAL_SMONTHNAME4}
  CAL_SMONTHNAME4 = 24;   { native name for April }
  {$EXTERNALSYM CAL_SMONTHNAME5}
  CAL_SMONTHNAME5 = 25;   { native name for May }
  {$EXTERNALSYM CAL_SMONTHNAME6}
  CAL_SMONTHNAME6 = 26;   { native name for June }
  {$EXTERNALSYM CAL_SMONTHNAME7}
  CAL_SMONTHNAME7 = 27;   { native name for July }
  {$EXTERNALSYM CAL_SMONTHNAME8}
  CAL_SMONTHNAME8 = 28;   { native name for August }
  {$EXTERNALSYM CAL_SMONTHNAME9}
  CAL_SMONTHNAME9 = 29;   { native name for September }
  {$EXTERNALSYM CAL_SMONTHNAME10}
  CAL_SMONTHNAME10 = 30;   { native name for October }
  {$EXTERNALSYM CAL_SMONTHNAME11}
  CAL_SMONTHNAME11 = 31;   { native name for November }
  {$EXTERNALSYM CAL_SMONTHNAME12}
  CAL_SMONTHNAME12 = $20;   { native name for December }
  {$EXTERNALSYM CAL_SMONTHNAME13}
  CAL_SMONTHNAME13 = 33;   { native name for 13th month (if any) }
  {$EXTERNALSYM CAL_SABBREVMONTHNAME1}
  CAL_SABBREVMONTHNAME1 = 34;   { abbreviated name for January }
  {$EXTERNALSYM CAL_SABBREVMONTHNAME2}
  CAL_SABBREVMONTHNAME2 = 35;   { abbreviated name for February }
  {$EXTERNALSYM CAL_SABBREVMONTHNAME3}
  CAL_SABBREVMONTHNAME3 = 36;   { abbreviated name for March }
  {$EXTERNALSYM CAL_SABBREVMONTHNAME4}
  CAL_SABBREVMONTHNAME4 = 37;   { abbreviated name for April }
  {$EXTERNALSYM CAL_SABBREVMONTHNAME5}
  CAL_SABBREVMONTHNAME5 = 38;   { abbreviated name for May }
  {$EXTERNALSYM CAL_SABBREVMONTHNAME6}
  CAL_SABBREVMONTHNAME6 = 39;   { abbreviated name for June }
  {$EXTERNALSYM CAL_SABBREVMONTHNAME7}
  CAL_SABBREVMONTHNAME7 = 40;   { abbreviated name for July }
  {$EXTERNALSYM CAL_SABBREVMONTHNAME8}
  CAL_SABBREVMONTHNAME8 = 41;   { abbreviated name for August }
  {$EXTERNALSYM CAL_SABBREVMONTHNAME9}
  CAL_SABBREVMONTHNAME9 = 42;   { abbreviated name for September }
  {$EXTERNALSYM CAL_SABBREVMONTHNAME10}
  CAL_SABBREVMONTHNAME10 = 43;   { abbreviated name for October }
  {$EXTERNALSYM CAL_SABBREVMONTHNAME11}
  CAL_SABBREVMONTHNAME11 = 44;   { abbreviated name for November }
  {$EXTERNALSYM CAL_SABBREVMONTHNAME12}
  CAL_SABBREVMONTHNAME12 = 45;   { abbreviated name for December }
  {$EXTERNALSYM CAL_SABBREVMONTHNAME13}
  CAL_SABBREVMONTHNAME13 = 46;   { abbreviated name for 13th month (if any) }

{ Calendar Enumeration Value. }

  {$EXTERNALSYM ENUM_ALL_CALENDARS}
  ENUM_ALL_CALENDARS = DWORD($FFFFFFFF);   { enumerate all calendars }

{ Calendar ID Values. }

  {$EXTERNALSYM CAL_GREGORIAN}
  CAL_GREGORIAN = 1;           { Gregorian (localized) calendar }
  {$EXTERNALSYM CAL_GREGORIAN_US}
  CAL_GREGORIAN_US = 2;        { Gregorian (U.S.) calendar }
  {$EXTERNALSYM CAL_JAPAN}
  CAL_JAPAN = 3;               { Japanese Emperor Era calendar }
  {$EXTERNALSYM CAL_TAIWAN}
  CAL_TAIWAN = 4;              { Republic of China Era calendar }
  {$EXTERNALSYM CAL_KOREA}
  CAL_KOREA = 5;               { Korean Tangun Era calendar }
  {$EXTERNALSYM CAL_HIJRI}
  CAL_HIJRI = 6;               { Hijri (Arabic Lunar) calendar }
  {$EXTERNALSYM CAL_THAI}
  CAL_THAI = 7;                { Thai calendar }
  {$EXTERNALSYM CAL_HEBREW}
  CAL_HEBREW = 8;              { Hebrew calendar }


type
  {$EXTERNALSYM LCTYPE}
  LCTYPE = DWORD;   { Locale type constant. }
  {$EXTERNALSYM CALTYPE}
  CALTYPE = DWORD;  { Calendar type constant. }
  {$EXTERNALSYM CALID}
  CALID = DWORD;    { Calendar ID. }

  PCPInfo = ^TCPInfo;
  {$EXTERNALSYM _cpinfo}
  _cpinfo = record
    MaxCharSize: UINT;                       { max length (bytes) of a char }
    DefaultChar: array[0..MAX_DEFAULTCHAR - 1] of Byte; { default character }
    LeadByte: array[0..MAX_LEADBYTES - 1] of Byte;      { lead byte ranges }
  end;
  TCPInfo = _cpinfo;
  {$EXTERNALSYM CPINFO}
  CPINFO = _cpinfo;

type
  PNumberFmtA = ^TNumberFmtA;
  PNumberFmtW = ^TNumberFmtW;
  PNumberFmt = PNumberFmtA;
  {$EXTERNALSYM _numberfmtA}
  _numberfmtA = packed record
    NumDigits: UINT;        { number of decimal digits }
    LeadingZero: UINT;      { if leading zero in decimal fields }
    Grouping: UINT;         { group size left of decimal }
    lpDecimalSep: PAnsiChar;   { ptr to decimal separator string }
    lpThousandSep: PAnsiChar;  { ptr to thousand separator string }
    NegativeOrder: UINT;    { negative number ordering }
  end;
  {$EXTERNALSYM _numberfmtW}
  _numberfmtW = packed record
    NumDigits: UINT;        { number of decimal digits }
    LeadingZero: UINT;      { if leading zero in decimal fields }
    Grouping: UINT;         { group size left of decimal }
    lpDecimalSep: PWideChar;   { ptr to decimal separator string }
    lpThousandSep: PWideChar;  { ptr to thousand separator string }
    NegativeOrder: UINT;    { negative number ordering }
  end;
  {$EXTERNALSYM _numberfmt}
  _numberfmt = _numberfmtA;
  TNumberFmtA = _numberfmtA;
  TNumberFmtW = _numberfmtW;
  TNumberFmt = TNumberFmtA;
  {$EXTERNALSYM NUMBERFMTA}
  NUMBERFMTA = _numberfmtA;
  {$EXTERNALSYM NUMBERFMTW}
  NUMBERFMTW = _numberfmtW;
  {$EXTERNALSYM NUMBERFMT}
  NUMBERFMT = NUMBERFMTA;

  PCurrencyFmtA = ^TCurrencyFmtA;
  PCurrencyFmtW = ^TCurrencyFmtW;
  PCurrencyFmt = PCurrencyFmtA;
  {$EXTERNALSYM _currencyfmtA}
  _currencyfmtA = packed record
    NumDigits: UINT;           { number of decimal digits }
    LeadingZero: UINT;         { if leading zero in decimal fields }
    Grouping: UINT;            { group size left of decimal }
    lpDecimalSep: PAnsiChar;      { ptr to decimal separator string }
    lpThousandSep: PAnsiChar;     { ptr to thousand separator string }
    NegativeOrder: UINT;       { negative currency ordering }
    PositiveOrder: UINT;       { positive currency ordering }
    lpCurrencySymbol: PAnsiChar;  { ptr to currency symbol string }
  end;
  {$EXTERNALSYM _currencyfmtW}
  _currencyfmtW = packed record
    NumDigits: UINT;           { number of decimal digits }
    LeadingZero: UINT;         { if leading zero in decimal fields }
    Grouping: UINT;            { group size left of decimal }
    lpDecimalSep: PWideChar;      { ptr to decimal separator string }
    lpThousandSep: PWideChar;     { ptr to thousand separator string }
    NegativeOrder: UINT;       { negative currency ordering }
    PositiveOrder: UINT;       { positive currency ordering }
    lpCurrencySymbol: PWideChar;  { ptr to currency symbol string }
  end;
  {$EXTERNALSYM _currencyfmt}
  _currencyfmt = _currencyfmtA;
  TCurrencyFmtA = _currencyfmtA;
  TCurrencyFmtW = _currencyfmtW;
  TCurrencyFmt = TCurrencyFmtA;
  {$EXTERNALSYM CURRENCYFMTA}
  CURRENCYFMTA = _currencyfmtA;
  {$EXTERNALSYM CURRENCYFMTW}
  CURRENCYFMTW = _currencyfmtW;
  {$EXTERNALSYM CURRENCYFMT}
  CURRENCYFMT = CURRENCYFMTA;

{ Enumeration function constants. }








  TFNLocaleEnumProc = TFarProc;
  TFNCodepageEnumProc = TFarProc;
  TFNDateFmtEnumProc = TFarProc;
  TFNTimeFmtEnumProc = TFarProc;
  TFNCalInfoEnumProc = TFarProc;



{ Code Page Dependent APIs. }

{$EXTERNALSYM IsValidCodePage}
function IsValidCodePage(CodePage: UINT): BOOL; stdcall;
{$EXTERNALSYM GetACP}
function GetACP: UINT; stdcall;
{$EXTERNALSYM GetOEMCP}
function GetOEMCP: UINT; stdcall;
{$EXTERNALSYM GetCPInfo}
function GetCPInfo(CodePage: UINT; var lpCPInfo: TCPInfo): BOOL; stdcall;
{$EXTERNALSYM IsDBCSLeadByte}
function IsDBCSLeadByte(TestChar: Byte): BOOL; stdcall;
{$EXTERNALSYM IsDBCSLeadByteEx}
function IsDBCSLeadByteEx(CodePage: UINT; TestChar: Byte): BOOL; stdcall;
{$EXTERNALSYM MultiByteToWideChar}
function MultiByteToWideChar(CodePage: UINT; dwFlags: DWORD;
  const lpMultiByteStr: LPCSTR; cchMultiByte: Integer;
  lpWideCharStr: LPWSTR; cchWideChar: Integer): Integer; stdcall;
{$EXTERNALSYM WideCharToMultiByte}
function WideCharToMultiByte(CodePage: UINT; dwFlags: DWORD;
  lpWideCharStr: LPWSTR; cchWideChar: Integer; lpMultiByteStr: LPSTR;
  cchMultiByte: Integer; lpDefaultChar: LPCSTR; lpUsedDefaultChar: PBOOL): Integer; stdcall;

{ Locale Dependent APIs. }

{$EXTERNALSYM CompareString}
function CompareString(Locale: LCID; dwCmpFlags: DWORD; lpString1: PChar;
  cchCount1: Integer; lpString2: PChar; cchCount2: Integer): Integer; stdcall;
{$EXTERNALSYM CompareStringA}
function CompareStringA(Locale: LCID; dwCmpFlags: DWORD; lpString1: PAnsiChar;
  cchCount1: Integer; lpString2: PAnsiChar; cchCount2: Integer): Integer; stdcall;
{$EXTERNALSYM CompareStringW}
function CompareStringW(Locale: LCID; dwCmpFlags: DWORD; lpString1: PWideChar;
  cchCount1: Integer; lpString2: PWideChar; cchCount2: Integer): Integer; stdcall;
{$EXTERNALSYM LCMapString}
function LCMapString(Locale: LCID; dwMapFlags: DWORD; lpSrcStr: PChar;
  cchSrc: Integer; lpDestStr: PChar; cchDest: Integer): Integer; stdcall;
{$EXTERNALSYM LCMapStringA}
function LCMapStringA(Locale: LCID; dwMapFlags: DWORD; lpSrcStr: PAnsiChar;
  cchSrc: Integer; lpDestStr: PAnsiChar; cchDest: Integer): Integer; stdcall;
{$EXTERNALSYM LCMapStringW}
function LCMapStringW(Locale: LCID; dwMapFlags: DWORD; lpSrcStr: PWideChar;
  cchSrc: Integer; lpDestStr: PWideChar; cchDest: Integer): Integer; stdcall;
{$EXTERNALSYM GetLocaleInfo}
function GetLocaleInfo(Locale: LCID; LCType: LCTYPE; lpLCData: PChar; cchData: Integer): Integer; stdcall;
{$EXTERNALSYM GetLocaleInfoA}
function GetLocaleInfoA(Locale: LCID; LCType: LCTYPE; lpLCData: PAnsiChar; cchData: Integer): Integer; stdcall;
{$EXTERNALSYM GetLocaleInfoW}
function GetLocaleInfoW(Locale: LCID; LCType: LCTYPE; lpLCData: PWideChar; cchData: Integer): Integer; stdcall;
{$EXTERNALSYM SetLocaleInfo}
function SetLocaleInfo(Locale: LCID; LCType: LCTYPE; lpLCData: PChar): BOOL; stdcall;
{$EXTERNALSYM SetLocaleInfoA}
function SetLocaleInfoA(Locale: LCID; LCType: LCTYPE; lpLCData: PAnsiChar): BOOL; stdcall;
{$EXTERNALSYM SetLocaleInfoW}
function SetLocaleInfoW(Locale: LCID; LCType: LCTYPE; lpLCData: PWideChar): BOOL; stdcall;
{$EXTERNALSYM GetTimeFormat}
function GetTimeFormat(Locale: LCID; dwFlags: DWORD; lpTime: PSystemTime;
  lpFormat: PChar; lpTimeStr: PChar; cchTime: Integer): Integer; stdcall;
{$EXTERNALSYM GetTimeFormatA}
function GetTimeFormatA(Locale: LCID; dwFlags: DWORD; lpTime: PSystemTime;
  lpFormat: PAnsiChar; lpTimeStr: PAnsiChar; cchTime: Integer): Integer; stdcall;
{$EXTERNALSYM GetTimeFormatW}
function GetTimeFormatW(Locale: LCID; dwFlags: DWORD; lpTime: PSystemTime;
  lpFormat: PWideChar; lpTimeStr: PWideChar; cchTime: Integer): Integer; stdcall;
{$EXTERNALSYM GetDateFormat}
function GetDateFormat(Locale: LCID; dwFlags: DWORD; lpDate: PSystemTime;
  lpFormat: PChar; lpDateStr: PChar; cchDate: Integer): Integer; stdcall;
{$EXTERNALSYM GetDateFormatA}
function GetDateFormatA(Locale: LCID; dwFlags: DWORD; lpDate: PSystemTime;
  lpFormat: PAnsiChar; lpDateStr: PAnsiChar; cchDate: Integer): Integer; stdcall;
{$EXTERNALSYM GetDateFormatW}
function GetDateFormatW(Locale: LCID; dwFlags: DWORD; lpDate: PSystemTime;
  lpFormat: PWideChar; lpDateStr: PWideChar; cchDate: Integer): Integer; stdcall;
{$EXTERNALSYM GetNumberFormat}
function GetNumberFormat(Locale: LCID; dwFlags: DWORD; lpValue: PChar;
  lpFormat: PNumberFmt; lpNumberStr: PChar; cchNumber: Integer): Integer; stdcall;
{$EXTERNALSYM GetNumberFormatA}
function GetNumberFormatA(Locale: LCID; dwFlags: DWORD; lpValue: PAnsiChar;
  lpFormat: PNumberFmtA; lpNumberStr: PAnsiChar; cchNumber: Integer): Integer; stdcall;
{$EXTERNALSYM GetNumberFormatW}
function GetNumberFormatW(Locale: LCID; dwFlags: DWORD; lpValue: PWideChar;
  lpFormat: PNumberFmtW; lpNumberStr: PWideChar; cchNumber: Integer): Integer; stdcall;
{$EXTERNALSYM GetCurrencyFormat}
function GetCurrencyFormat(Locale: LCID; dwFlags: DWORD; lpValue: PChar;
  lpFormat: PCurrencyFmt; lpCurrencyStr: PChar; cchCurrency: Integer): Integer; stdcall;
{$EXTERNALSYM GetCurrencyFormatA}
function GetCurrencyFormatA(Locale: LCID; dwFlags: DWORD; lpValue: PAnsiChar;
  lpFormat: PCurrencyFmtA; lpCurrencyStr: PAnsiChar; cchCurrency: Integer): Integer; stdcall;
{$EXTERNALSYM GetCurrencyFormatW}
function GetCurrencyFormatW(Locale: LCID; dwFlags: DWORD; lpValue: PWideChar;
  lpFormat: PCurrencyFmtW; lpCurrencyStr: PWideChar; cchCurrency: Integer): Integer; stdcall;
{$EXTERNALSYM EnumCalendarInfo}
function EnumCalendarInfo(lpCalInfoEnumProc: TFNCalInfoEnumProc; Locale: LCID;
  Calendar: CALID; CalType: CALTYPE): BOOL; stdcall;
{$EXTERNALSYM EnumCalendarInfoA}
function EnumCalendarInfoA(lpCalInfoEnumProc: TFNCalInfoEnumProc; Locale: LCID;
  Calendar: CALID; CalType: CALTYPE): BOOL; stdcall;
{$EXTERNALSYM EnumCalendarInfoW}
function EnumCalendarInfoW(lpCalInfoEnumProc: TFNCalInfoEnumProc; Locale: LCID;
  Calendar: CALID; CalType: CALTYPE): BOOL; stdcall;
{$EXTERNALSYM EnumTimeFormats}
function EnumTimeFormats(lpTimeFmtEnumProc: TFNTimeFmtEnumProc;
  Locale: LCID; dwFlags: DWORD): BOOL; stdcall;
{$EXTERNALSYM EnumTimeFormatsA}
function EnumTimeFormatsA(lpTimeFmtEnumProc: TFNTimeFmtEnumProc;
  Locale: LCID; dwFlags: DWORD): BOOL; stdcall;
{$EXTERNALSYM EnumTimeFormatsW}
function EnumTimeFormatsW(lpTimeFmtEnumProc: TFNTimeFmtEnumProc;
  Locale: LCID; dwFlags: DWORD): BOOL; stdcall;
{$EXTERNALSYM EnumDateFormats}
function EnumDateFormats(lpDateFmtEnumProc: TFNDateFmtEnumProc;
  Locale: LCID; dwFlags: DWORD): BOOL; stdcall;
{$EXTERNALSYM EnumDateFormatsA}
function EnumDateFormatsA(lpDateFmtEnumProc: TFNDateFmtEnumProc;
  Locale: LCID; dwFlags: DWORD): BOOL; stdcall;
{$EXTERNALSYM EnumDateFormatsW}
function EnumDateFormatsW(lpDateFmtEnumProc: TFNDateFmtEnumProc;
  Locale: LCID; dwFlags: DWORD): BOOL; stdcall;
{$EXTERNALSYM IsValidLocale}
function IsValidLocale(Locale: LCID; dwFlags: DWORD): BOOL; stdcall;
{$EXTERNALSYM ConvertDefaultLocale}
function ConvertDefaultLocale(Locale: LCID): LCID; stdcall;
{$EXTERNALSYM GetThreadLocale}
function GetThreadLocale: LCID; stdcall;
{$EXTERNALSYM SetThreadLocale}
function SetThreadLocale(Locale: LCID): BOOL; stdcall;
{$EXTERNALSYM GetSystemDefaultLangID}
function GetSystemDefaultLangID: LANGID; stdcall;
{$EXTERNALSYM GetUserDefaultLangID}
function GetUserDefaultLangID: LANGID; stdcall;
{$EXTERNALSYM GetSystemDefaultLCID}
function GetSystemDefaultLCID: LCID; stdcall;
{$EXTERNALSYM GetUserDefaultLCID}
function GetUserDefaultLCID: LCID; stdcall;

{ Locale Independent APIs. }

{$EXTERNALSYM GetStringTypeEx}
function GetStringTypeEx(Locale: LCID; dwInfoType: DWORD;
  lpSrcStr: PChar; cchSrc: Integer; var lpCharType): BOOL; stdcall;
{$EXTERNALSYM GetStringTypeExA}
function GetStringTypeExA(Locale: LCID; dwInfoType: DWORD;
  lpSrcStr: PAnsiChar; cchSrc: Integer; var lpCharType): BOOL; stdcall;
{$EXTERNALSYM GetStringTypeExW}
function GetStringTypeExW(Locale: LCID; dwInfoType: DWORD;
  lpSrcStr: PWideChar; cchSrc: Integer; var lpCharType): BOOL; stdcall;

{  NOTE: The parameters for GetStringTypeA and GetStringTypeW are
         NOT the same.  The W version was shipped in NT 3.1.  The
         A version was then shipped in 16-bit OLE with the wrong
         parameters (ported from Win95).  To be compatible, we
         must break the relationship between the A and W versions
         of GetStringType.  There will be NO function call for the
         generic GetStringType.

         GetStringTypeEx (above) should be used instead. }

{$EXTERNALSYM GetStringTypeA}
function GetStringTypeA(Locale: LCID; dwInfoType: DWORD; const lpSrcStr: LPCSTR;
  cchSrc: BOOL; var lpCharType: Word): BOOL; stdcall;
{$EXTERNALSYM GetStringTypeW}
function GetStringTypeW(dwInfoType: DWORD; const lpSrcStr: WCHAR; cchSrc: BOOL;
  var lpCharType: Word): BOOL; stdcall;

{$EXTERNALSYM FoldString}
function FoldString(dwMapFlags: DWORD; lpSrcStr: PChar; cchSrc: Integer;
  lpDestStr: PChar; cchDest: Integer): Integer; stdcall;
{$EXTERNALSYM FoldStringA}
function FoldStringA(dwMapFlags: DWORD; lpSrcStr: PAnsiChar; cchSrc: Integer;
  lpDestStr: PAnsiChar; cchDest: Integer): Integer; stdcall;
{$EXTERNALSYM FoldStringW}
function FoldStringW(dwMapFlags: DWORD; lpSrcStr: PWideChar; cchSrc: Integer;
  lpDestStr: PWideChar; cchDest: Integer): Integer; stdcall;
{$EXTERNALSYM EnumSystemLocales}
function EnumSystemLocales(lpLocaleEnumProc: TFNLocaleEnumProc; dwFlags: DWORD): BOOL; stdcall;
{$EXTERNALSYM EnumSystemLocalesA}
function EnumSystemLocalesA(lpLocaleEnumProc: TFNLocaleEnumProc; dwFlags: DWORD): BOOL; stdcall;
{$EXTERNALSYM EnumSystemLocalesW}
function EnumSystemLocalesW(lpLocaleEnumProc: TFNLocaleEnumProc; dwFlags: DWORD): BOOL; stdcall;
{$EXTERNALSYM EnumSystemCodePages}
function EnumSystemCodePages(lpCodePageEnumProc: TFNCodepageEnumProc; dwFlags: DWORD): BOOL; stdcall;
{$EXTERNALSYM EnumSystemCodePagesA}
function EnumSystemCodePagesA(lpCodePageEnumProc: TFNCodepageEnumProc; dwFlags: DWORD): BOOL; stdcall;
{$EXTERNALSYM EnumSystemCodePagesW}
function EnumSystemCodePagesW(lpCodePageEnumProc: TFNCodepageEnumProc; dwFlags: DWORD): BOOL; stdcall;


{ Translated from WINCON.H }

{ This module contains the public data structures, data types,
    and procedures exported by the NT console subsystem. }

type
  PCoord = ^TCoord;
  {$EXTERNALSYM _COORD}
  _COORD = packed record
    X: SHORT;
    Y: SHORT;
  end;
  TCoord = _COORD;
  {$EXTERNALSYM COORD}
  COORD = _COORD;

  PSmallRect = ^TSmallRect;
  {$EXTERNALSYM _SMALL_RECT}
  _SMALL_RECT = packed record
    Left: SHORT;
    Top: SHORT;
    Right: SHORT;
    Bottom: SHORT;
  end;
  TSmallRect = _SMALL_RECT;
  {$EXTERNALSYM SMALL_RECT}
  SMALL_RECT = _SMALL_RECT;

  PKeyEventRecord = ^TKeyEventRecord;
  {$EXTERNALSYM _KEY_EVENT_RECORD}
  _KEY_EVENT_RECORD = packed record
    bKeyDown: BOOL;
    wRepeatCount: Word;
    wVirtualKeyCode: Word;
    wVirtualScanCode: Word;
    case Integer of
      0: (
        UnicodeChar: WCHAR;
        dwControlKeyState: DWORD);
      1: (
        AsciiChar: CHAR);
  end;
  TKeyEventRecord = _KEY_EVENT_RECORD;
  {$EXTERNALSYM KEY_EVENT_RECORD}
  KEY_EVENT_RECORD = _KEY_EVENT_RECORD;

const
{ ControlKeyState flags }

  {$EXTERNALSYM RIGHT_ALT_PRESSED}
  RIGHT_ALT_PRESSED = 1;     { the right alt key is pressed. }
  {$EXTERNALSYM LEFT_ALT_PRESSED}
  LEFT_ALT_PRESSED = 2;     { the left alt key is pressed. }
  {$EXTERNALSYM RIGHT_CTRL_PRESSED}
  RIGHT_CTRL_PRESSED = 4;     { the right ctrl key is pressed. }
  {$EXTERNALSYM LEFT_CTRL_PRESSED}
  LEFT_CTRL_PRESSED = 8;     { the left ctrl key is pressed. }
  {$EXTERNALSYM SHIFT_PRESSED}
  SHIFT_PRESSED = $10;     { the shift key is pressed. }
  {$EXTERNALSYM NUMLOCK_ON}
  NUMLOCK_ON = $20;     { the numlock light is on. }
  {$EXTERNALSYM SCROLLLOCK_ON}
  SCROLLLOCK_ON = $40;     { the scrolllock light is on. }
  {$EXTERNALSYM CAPSLOCK_ON}
  CAPSLOCK_ON = $80;     { the capslock light is on. }
  {$EXTERNALSYM ENHANCED_KEY}
  ENHANCED_KEY = $100;     { the key is enhanced. }

type
  PMouseEventRecord = ^TMouseEventRecord;
  {$EXTERNALSYM _MOUSE_EVENT_RECORD}
  _MOUSE_EVENT_RECORD = packed record
    dwMousePosition: TCoord;
    dwButtonState: DWORD;
    dwControlKeyState: DWORD;
    dwEventFlags: DWORD;
  end;
  TMouseEventRecord = _MOUSE_EVENT_RECORD;
  {$EXTERNALSYM MOUSE_EVENT_RECORD}
  MOUSE_EVENT_RECORD = _MOUSE_EVENT_RECORD;

const
{ ButtonState flags }

  {$EXTERNALSYM FROM_LEFT_1ST_BUTTON_PRESSED}
  FROM_LEFT_1ST_BUTTON_PRESSED = 1;
  {$EXTERNALSYM RIGHTMOST_BUTTON_PRESSED}
  RIGHTMOST_BUTTON_PRESSED = 2;
  {$EXTERNALSYM FROM_LEFT_2ND_BUTTON_PRESSED}
  FROM_LEFT_2ND_BUTTON_PRESSED = 4;
  {$EXTERNALSYM FROM_LEFT_3RD_BUTTON_PRESSED}
  FROM_LEFT_3RD_BUTTON_PRESSED = 8;
  {$EXTERNALSYM FROM_LEFT_4TH_BUTTON_PRESSED}
  FROM_LEFT_4TH_BUTTON_PRESSED = $10;

{ EventFlags }

  {$EXTERNALSYM MOUSE_MOVED}
  MOUSE_MOVED = 1;
  {$EXTERNALSYM DOUBLE_CLICK}
  DOUBLE_CLICK = 2;

type
  PWindowBufferSizeRecord = ^TWindowBufferSizeRecord;
  {$EXTERNALSYM _WINDOW_BUFFER_SIZE_RECORD}
  _WINDOW_BUFFER_SIZE_RECORD = packed record
    dwSize: TCoord;
  end;
  TWindowBufferSizeRecord = _WINDOW_BUFFER_SIZE_RECORD;
  {$EXTERNALSYM WINDOW_BUFFER_SIZE_RECORD}
  WINDOW_BUFFER_SIZE_RECORD = _WINDOW_BUFFER_SIZE_RECORD;

  PMenuEventRecord = ^TMenuEventRecord;
  {$EXTERNALSYM _MENU_EVENT_RECORD}
  _MENU_EVENT_RECORD = packed record
    dwCommandId: UINT;
  end;
  TMenuEventRecord = _MENU_EVENT_RECORD;
  {$EXTERNALSYM MENU_EVENT_RECORD}
  MENU_EVENT_RECORD = _MENU_EVENT_RECORD;

  PFocusEventRecord = ^TFocusEventRecord;
  {$EXTERNALSYM _FOCUS_EVENT_RECORD}
  _FOCUS_EVENT_RECORD = packed record
    bSetFocus: BOOL;
  end;
  TFocusEventRecord = _FOCUS_EVENT_RECORD;
  {$EXTERNALSYM FOCUS_EVENT_RECORD}
  FOCUS_EVENT_RECORD = _FOCUS_EVENT_RECORD;

  PInputRecord = ^TInputRecord;
  {$EXTERNALSYM _INPUT_RECORD}
  _INPUT_RECORD = record
    EventType: Word;
    Reserved: Word;
    Event: Record case Integer of
      0: (KeyEvent: TKeyEventRecord);
      1: (MouseEvent: TMouseEventRecord);
      2: (WindowBufferSizeEvent: TWindowBufferSizeRecord);
      3: (MenuEvent: TMenuEventRecord);
      4: (FocusEvent: TFocusEventRecord);
    end;
  end;
  TInputRecord = _INPUT_RECORD;
  {$EXTERNALSYM INPUT_RECORD}
  INPUT_RECORD = _INPUT_RECORD;


const
{  EventType flags: }

  {$EXTERNALSYM KEY_EVENT}
  KEY_EVENT = 1;       { Event contains key event record}
  _MOUSE_EVENT = 2;  { Renamed }   { Event contains mouse event record }
  {$EXTERNALSYM WINDOW_BUFFER_SIZE_EVENT}
  WINDOW_BUFFER_SIZE_EVENT = 4;  { Event contains window change event record }
  {$EXTERNALSYM MENU_EVENT}
  MENU_EVENT = 8;     { Event contains menu event record }
  {$EXTERNALSYM FOCUS_EVENT}
  FOCUS_EVENT = $10;  { event contains focus change }

type
  PCharInfo = ^TCharInfo;
  {$EXTERNALSYM _CHAR_INFO}
  _CHAR_INFO = record
    case Integer of
      0: (
        UnicodeChar: WCHAR;
        Attributes: Word);
      1: (
        AsciiChar: CHAR);
  end;
  TCharInfo = _CHAR_INFO;
  {$EXTERNALSYM CHAR_INFO}
  CHAR_INFO = _CHAR_INFO;

const
{ Attributes flags:}

  {$EXTERNALSYM FOREGROUND_BLUE}
  FOREGROUND_BLUE = 1;    { text color contains blue.}
  {$EXTERNALSYM FOREGROUND_GREEN}
  FOREGROUND_GREEN = 2;     { text color contains green. }
  {$EXTERNALSYM FOREGROUND_RED}
  FOREGROUND_RED = 4;     { text color contains red. }
  {$EXTERNALSYM FOREGROUND_INTENSITY}
  FOREGROUND_INTENSITY = 8;     { text color is intensified. }
  {$EXTERNALSYM BACKGROUND_BLUE}
  BACKGROUND_BLUE = $10;     { background color contains blue. }
  {$EXTERNALSYM BACKGROUND_GREEN}
  BACKGROUND_GREEN = $20;     { background color contains green. }
  {$EXTERNALSYM BACKGROUND_RED}
  BACKGROUND_RED = $40;     { background color contains red. }
  {$EXTERNALSYM BACKGROUND_INTENSITY}
  BACKGROUND_INTENSITY = $80;     { background color is intensified. }

type
  PConsoleScreenBufferInfo = ^TConsoleScreenBufferInfo;
  {$EXTERNALSYM _CONSOLE_SCREEN_BUFFER_INFO}
  _CONSOLE_SCREEN_BUFFER_INFO = packed record
    dwSize: TCoord;
    dwCursorPosition: TCoord;
    wAttributes: Word;
    srWindow: TSmallRect;
    dwMaximumWindowSize: TCoord;
  end;
  TConsoleScreenBufferInfo = _CONSOLE_SCREEN_BUFFER_INFO;
  {$EXTERNALSYM CONSOLE_SCREEN_BUFFER_INFO}
  CONSOLE_SCREEN_BUFFER_INFO = _CONSOLE_SCREEN_BUFFER_INFO;

  PConsoleCursorInfo = ^TConsoleCursorInfo;
  {$EXTERNALSYM _CONSOLE_CURSOR_INFO}
  _CONSOLE_CURSOR_INFO = packed record
    dwSize: DWORD;
    bVisible: BOOL;
  end;
  TConsoleCursorInfo = _CONSOLE_CURSOR_INFO;
  {$EXTERNALSYM CONSOLE_CURSOR_INFO}
  CONSOLE_CURSOR_INFO = _CONSOLE_CURSOR_INFO;




  TFNHandlerRoutine = TFarProc;


const
  {$EXTERNALSYM CTRL_C_EVENT}
  CTRL_C_EVENT = 0;
  {$EXTERNALSYM CTRL_BREAK_EVENT}
  CTRL_BREAK_EVENT = 1;
  {$EXTERNALSYM CTRL_CLOSE_EVENT}
  CTRL_CLOSE_EVENT = 2;
  { 3 is reserved! }
  { 4 is reserved! }

  {$EXTERNALSYM CTRL_LOGOFF_EVENT}
  CTRL_LOGOFF_EVENT = 5;
  {$EXTERNALSYM CTRL_SHUTDOWN_EVENT}
  CTRL_SHUTDOWN_EVENT = 6;
  {$EXTERNALSYM ENABLE_PROCESSED_INPUT}
  ENABLE_PROCESSED_INPUT = 1;     {  Input Mode flags: }
  {$EXTERNALSYM ENABLE_LINE_INPUT}
  ENABLE_LINE_INPUT = 2;
  {$EXTERNALSYM ENABLE_ECHO_INPUT}
  ENABLE_ECHO_INPUT = 4;
  {$EXTERNALSYM ENABLE_WINDOW_INPUT}
  ENABLE_WINDOW_INPUT = 8;
  {$EXTERNALSYM ENABLE_MOUSE_INPUT}
  ENABLE_MOUSE_INPUT = $10;
  {$EXTERNALSYM ENABLE_PROCESSED_OUTPUT}
  ENABLE_PROCESSED_OUTPUT = 1;     { Output Mode flags: }
  {$EXTERNALSYM ENABLE_WRAP_AT_EOL_OUTPUT}
  ENABLE_WRAP_AT_EOL_OUTPUT = 2;

{ direct API definitions. }
{$EXTERNALSYM PeekConsoleInput}
function PeekConsoleInput(hConsoleInput: THandle; var lpBuffer: TInputRecord;
  nLength: DWORD; var lpNumberOfEventsRead: DWORD): BOOL; stdcall;
{$EXTERNALSYM PeekConsoleInputA}
function PeekConsoleInputA(hConsoleInput: THandle; var lpBuffer: TInputRecord;
  nLength: DWORD; var lpNumberOfEventsRead: DWORD): BOOL; stdcall;
{$EXTERNALSYM PeekConsoleInputW}
function PeekConsoleInputW(hConsoleInput: THandle; var lpBuffer: TInputRecord;
  nLength: DWORD; var lpNumberOfEventsRead: DWORD): BOOL; stdcall;
{$EXTERNALSYM ReadConsoleInput}
function ReadConsoleInput(hConsoleInput: THandle; var lpBuffer: TInputRecord;
  nLength: DWORD; var lpNumberOfEventsRead: DWORD): BOOL; stdcall;
{$EXTERNALSYM ReadConsoleInputA}
function ReadConsoleInputA(hConsoleInput: THandle; var lpBuffer: TInputRecord;
  nLength: DWORD; var lpNumberOfEventsRead: DWORD): BOOL; stdcall;
{$EXTERNALSYM ReadConsoleInputW}
function ReadConsoleInputW(hConsoleInput: THandle; var lpBuffer: TInputRecord;
  nLength: DWORD; var lpNumberOfEventsRead: DWORD): BOOL; stdcall;
{$EXTERNALSYM WriteConsoleInput}
function WriteConsoleInput(hConsoleInput: THandle; const lpBuffer: TInputRecord;
  nLength: DWORD; var lpNumberOfEventsWritten: DWORD): BOOL; stdcall;
{$EXTERNALSYM WriteConsoleInputA}
function WriteConsoleInputA(hConsoleInput: THandle; const lpBuffer: TInputRecord;
  nLength: DWORD; var lpNumberOfEventsWritten: DWORD): BOOL; stdcall;
{$EXTERNALSYM WriteConsoleInputW}
function WriteConsoleInputW(hConsoleInput: THandle; const lpBuffer: TInputRecord;
  nLength: DWORD; var lpNumberOfEventsWritten: DWORD): BOOL; stdcall;
{$EXTERNALSYM ReadConsoleOutput}
function ReadConsoleOutput(hConsoleOutput: THandle; lpBuffer: Pointer;
  dwBufferSize, dwBufferCoord: TCoord; var lpReadRegion: TSmallRect): BOOL; stdcall;
{$EXTERNALSYM ReadConsoleOutputA}
function ReadConsoleOutputA(hConsoleOutput: THandle; lpBuffer: Pointer;
  dwBufferSize, dwBufferCoord: TCoord; var lpReadRegion: TSmallRect): BOOL; stdcall;
{$EXTERNALSYM ReadConsoleOutputW}
function ReadConsoleOutputW(hConsoleOutput: THandle; lpBuffer: Pointer;
  dwBufferSize, dwBufferCoord: TCoord; var lpReadRegion: TSmallRect): BOOL; stdcall;
{$EXTERNALSYM WriteConsoleOutput}
function WriteConsoleOutput(hConsoleOutput: THandle; lpBuffer: Pointer;
  dwBufferSize, dwBufferCoord: TCoord; var lpWriteRegion: TSmallRect): BOOL; stdcall;
{$EXTERNALSYM WriteConsoleOutputA}
function WriteConsoleOutputA(hConsoleOutput: THandle; lpBuffer: Pointer;
  dwBufferSize, dwBufferCoord: TCoord; var lpWriteRegion: TSmallRect): BOOL; stdcall;
{$EXTERNALSYM WriteConsoleOutputW}
function WriteConsoleOutputW(hConsoleOutput: THandle; lpBuffer: Pointer;
  dwBufferSize, dwBufferCoord: TCoord; var lpWriteRegion: TSmallRect): BOOL; stdcall;
{$EXTERNALSYM ReadConsoleOutputCharacter}
function ReadConsoleOutputCharacter(hConsoleOutput: THandle; lpCharacter: PChar;
  nLength: DWORD; dwReadCoord: TCoord; var lpNumberOfCharsRead: DWORD): BOOL; stdcall;
{$EXTERNALSYM ReadConsoleOutputCharacterA}
function ReadConsoleOutputCharacterA(hConsoleOutput: THandle; lpCharacter: PAnsiChar;
  nLength: DWORD; dwReadCoord: TCoord; var lpNumberOfCharsRead: DWORD): BOOL; stdcall;
{$EXTERNALSYM ReadConsoleOutputCharacterW}
function ReadConsoleOutputCharacterW(hConsoleOutput: THandle; lpCharacter: PWideChar;
  nLength: DWORD; dwReadCoord: TCoord; var lpNumberOfCharsRead: DWORD): BOOL; stdcall;
{$EXTERNALSYM ReadConsoleOutputAttribute}
function ReadConsoleOutputAttribute(hConsoleOutput: THandle; lpAttribute: Pointer;
  nLength: DWORD; dwReadCoord: TCoord; var lpNumberOfAttrsRead: DWORD): BOOL; stdcall;
{$EXTERNALSYM WriteConsoleOutputCharacter}
function WriteConsoleOutputCharacter(hConsoleOutput: THandle;lpCharacter: PChar;
  nLength: DWORD; dwWriteCoord: TCoord; var lpNumberOfCharsWritten: DWORD): BOOL; stdcall;
{$EXTERNALSYM WriteConsoleOutputCharacterA}
function WriteConsoleOutputCharacterA(hConsoleOutput: THandle;lpCharacter: PAnsiChar;
  nLength: DWORD; dwWriteCoord: TCoord; var lpNumberOfCharsWritten: DWORD): BOOL; stdcall;
{$EXTERNALSYM WriteConsoleOutputCharacterW}
function WriteConsoleOutputCharacterW(hConsoleOutput: THandle;lpCharacter: PWideChar;
  nLength: DWORD; dwWriteCoord: TCoord; var lpNumberOfCharsWritten: DWORD): BOOL; stdcall;
{$EXTERNALSYM WriteConsoleOutputAttribute}
function WriteConsoleOutputAttribute(hConsoleOutput: THandle; lpAttribute: Pointer;
  nLength: DWORD; dwWriteCoord: TCoord; var lpNumberOfAttrsWritten: DWORD): BOOL; stdcall;
{$EXTERNALSYM FillConsoleOutputCharacter}
function FillConsoleOutputCharacter(hConsoleOutput: THandle; cCharacter: Char;
  nLength: DWORD; dwWriteCoord: TCoord; var lpNumberOfCharsWritten: DWORD): BOOL; stdcall;
{$EXTERNALSYM FillConsoleOutputCharacterA}
function FillConsoleOutputCharacterA(hConsoleOutput: THandle; cCharacter: AnsiChar;
  nLength: DWORD; dwWriteCoord: TCoord; var lpNumberOfCharsWritten: DWORD): BOOL; stdcall;
{$EXTERNALSYM FillConsoleOutputCharacterW}
function FillConsoleOutputCharacterW(hConsoleOutput: THandle; cCharacter: WideChar;
  nLength: DWORD; dwWriteCoord: TCoord; var lpNumberOfCharsWritten: DWORD): BOOL; stdcall;
{$EXTERNALSYM FillConsoleOutputAttribute}
function FillConsoleOutputAttribute(hConsoleOutput: THandle; wAttribute: Word;
  nLength: DWORD; dwWriteCoord: TCoord; var lpNumberOfAttrsWritten: DWORD): BOOL; stdcall;
{$EXTERNALSYM GetConsoleMode}
function GetConsoleMode(hConsoleHandle: THandle; var lpMode: DWORD): BOOL; stdcall;
{$EXTERNALSYM GetNumberOfConsoleInputEvents}
function GetNumberOfConsoleInputEvents(hConsoleInput: THandle;
  var lpNumberOfEvents: DWORD): BOOL; stdcall;
{$EXTERNALSYM GetConsoleScreenBufferInfo}
function GetConsoleScreenBufferInfo(hConsoleOutput: THandle;
  var lpConsoleScreenBufferInfo: TConsoleScreenBufferInfo): BOOL; stdcall;
{$EXTERNALSYM GetLargestConsoleWindowSize}
function GetLargestConsoleWindowSize(hConsoleOutput: THandle): TCoord; stdcall;
{$EXTERNALSYM GetConsoleCursorInfo}
function GetConsoleCursorInfo(hConsoleOutput: THandle;
  var lpConsoleCursorInfo: TConsoleCursorInfo): BOOL; stdcall;
{$EXTERNALSYM GetNumberOfConsoleMouseButtons}
function GetNumberOfConsoleMouseButtons(var lpNumberOfMouseButtons: DWORD): BOOL; stdcall;
{$EXTERNALSYM SetConsoleMode}
function SetConsoleMode(hConsoleHandle: THandle; dwMode: DWORD): BOOL; stdcall;
{$EXTERNALSYM SetConsoleActiveScreenBuffer}
function SetConsoleActiveScreenBuffer(hConsoleOutput: THandle): BOOL; stdcall;
{$EXTERNALSYM FlushConsoleInputBuffer}
function FlushConsoleInputBuffer(hConsoleInput: THandle): BOOL; stdcall;
{$EXTERNALSYM SetConsoleScreenBufferSize}
function SetConsoleScreenBufferSize(hConsoleOutput: THandle; dwSize: TCoord): BOOL; stdcall;
{$EXTERNALSYM SetConsoleCursorPosition}
function SetConsoleCursorPosition(hConsoleOutput: THandle; dwCursorPosition: TCoord): BOOL; stdcall;
{$EXTERNALSYM SetConsoleCursorInfo}
function SetConsoleCursorInfo(hConsoleOutput: THandle;
  const lpConsoleCursorInfo: TConsoleCursorInfo): BOOL; stdcall;
{$EXTERNALSYM ScrollConsoleScreenBuffer}
function ScrollConsoleScreenBuffer(hConsoleOutput: THandle;
  const lpScrollRectangle: TSmallRect; lpClipRectangle: PSmallRect;
  dwDestinationOrigin: TCoord; var lpFill: TCharInfo): BOOL; stdcall;
{$EXTERNALSYM ScrollConsoleScreenBufferA}
function ScrollConsoleScreenBufferA(hConsoleOutput: THandle;
  const lpScrollRectangle: TSmallRect; lpClipRectangle: PSmallRect;
  dwDestinationOrigin: TCoord; var lpFill: TCharInfo): BOOL; stdcall;
{$EXTERNALSYM ScrollConsoleScreenBufferW}
function ScrollConsoleScreenBufferW(hConsoleOutput: THandle;
  const lpScrollRectangle: TSmallRect; lpClipRectangle: PSmallRect;
  dwDestinationOrigin: TCoord; var lpFill: TCharInfo): BOOL; stdcall;
{$EXTERNALSYM SetConsoleWindowInfo}
function SetConsoleWindowInfo(hConsoleOutput: THandle; bAbsolute: BOOL;
  const lpConsoleWindow: TSmallRect): BOOL; stdcall;
{$EXTERNALSYM SetConsoleTextAttribute}
function SetConsoleTextAttribute(hConsoleOutput: THandle; wAttributes: Word): BOOL; stdcall;
{$EXTERNALSYM SetConsoleCtrlHandler}
function SetConsoleCtrlHandler(HandlerRoutine: TFNHandlerRoutine; Add: BOOL): BOOL; stdcall;
{$EXTERNALSYM GenerateConsoleCtrlEvent}
function GenerateConsoleCtrlEvent(dwCtrlEvent: DWORD; dwProcessGroupId: DWORD): BOOL; stdcall;
{$EXTERNALSYM AllocConsole}
function AllocConsole: BOOL; stdcall;
{$EXTERNALSYM FreeConsole}
function FreeConsole: BOOL; stdcall;
{$EXTERNALSYM GetConsoleTitle}
function GetConsoleTitle(lpConsoleTitle: PChar; nSize: DWORD): DWORD; stdcall;
{$EXTERNALSYM GetConsoleTitleA}
function GetConsoleTitleA(lpConsoleTitle: PAnsiChar; nSize: DWORD): DWORD; stdcall;
{$EXTERNALSYM GetConsoleTitleW}
function GetConsoleTitleW(lpConsoleTitle: PWideChar; nSize: DWORD): DWORD; stdcall;
{$EXTERNALSYM SetConsoleTitle}
function SetConsoleTitle(lpConsoleTitle: PChar): BOOL; stdcall;
{$EXTERNALSYM SetConsoleTitleA}
function SetConsoleTitleA(lpConsoleTitle: PAnsiChar): BOOL; stdcall;
{$EXTERNALSYM SetConsoleTitleW}
function SetConsoleTitleW(lpConsoleTitle: PWideChar): BOOL; stdcall;
{$EXTERNALSYM ReadConsole}
function ReadConsole(hConsoleInput: THandle; lpBuffer: Pointer;
  nNumberOfCharsToRead: DWORD; var lpNumberOfCharsRead: DWORD; lpReserved: Pointer): BOOL; stdcall;
{$EXTERNALSYM ReadConsoleA}
function ReadConsoleA(hConsoleInput: THandle; lpBuffer: Pointer;
  nNumberOfCharsToRead: DWORD; var lpNumberOfCharsRead: DWORD; lpReserved: Pointer): BOOL; stdcall;
{$EXTERNALSYM ReadConsoleW}
function ReadConsoleW(hConsoleInput: THandle; lpBuffer: Pointer;
  nNumberOfCharsToRead: DWORD; var lpNumberOfCharsRead: DWORD; lpReserved: Pointer): BOOL; stdcall;
{$EXTERNALSYM WriteConsole}
function WriteConsole(hConsoleOutput: THandle; const lpBuffer: Pointer;
  nNumberOfCharsToWrite: DWORD; var lpNumberOfCharsWritten: DWORD; lpReserved: Pointer): BOOL; stdcall;
{$EXTERNALSYM WriteConsoleA}
function WriteConsoleA(hConsoleOutput: THandle; const lpBuffer: Pointer;
  nNumberOfCharsToWrite: DWORD; var lpNumberOfCharsWritten: DWORD; lpReserved: Pointer): BOOL; stdcall;
{$EXTERNALSYM WriteConsoleW}
function WriteConsoleW(hConsoleOutput: THandle; const lpBuffer: Pointer;
  nNumberOfCharsToWrite: DWORD; var lpNumberOfCharsWritten: DWORD; lpReserved: Pointer): BOOL; stdcall;

const
  {$EXTERNALSYM CONSOLE_TEXTMODE_BUFFER}
  CONSOLE_TEXTMODE_BUFFER = 1;

{$EXTERNALSYM CreateConsoleScreenBuffer}
function CreateConsoleScreenBuffer(dwDesiredAccess, dwShareMode: DWORD;
  lpSecurityAttributes: PSecurityAttributes; dwFlags: DWORD; lpScreenBufferData: Pointer): THandle; stdcall;
{$EXTERNALSYM GetConsoleCP}
function GetConsoleCP: UINT; stdcall;
{$EXTERNALSYM SetConsoleCP}
function SetConsoleCP(wCodePageID: UINT): BOOL; stdcall;
{$EXTERNALSYM GetConsoleOutputCP}
function GetConsoleOutputCP: UINT; stdcall;
{$EXTERNALSYM SetConsoleOutputCP}
function SetConsoleOutputCP(wCodePageID: UINT): BOOL; stdcall;


{ Translated from WINVER.H }

{ Version management functions, types, and definitions
  Include file for VER.DLL.  This library is designed to allow version
  stamping of Windows executable files and of special .VER files for
  DOS executable files. }

const
{ Symbols }

  {$EXTERNALSYM VS_FILE_INFO}
  VS_FILE_INFO = RT_VERSION;
  {$EXTERNALSYM VS_VERSION_INFO}
  VS_VERSION_INFO = 1;
  {$EXTERNALSYM VS_USER_DEFINED}
  VS_USER_DEFINED = 100;

{ VS_VERSION.dwFileFlags }

  {$EXTERNALSYM VS_FFI_SIGNATURE}
  VS_FFI_SIGNATURE = DWORD($FEEF04BD);
  {$EXTERNALSYM VS_FFI_STRUCVERSION}
  VS_FFI_STRUCVERSION = $10000;
  {$EXTERNALSYM VS_FFI_FILEFLAGSMASK}
  VS_FFI_FILEFLAGSMASK = 63;

{ VS_VERSION.dwFileFlags }

  {$EXTERNALSYM VS_FF_DEBUG}
  VS_FF_DEBUG = 1;
  {$EXTERNALSYM VS_FF_PRERELEASE}
  VS_FF_PRERELEASE = 2;
  {$EXTERNALSYM VS_FF_PATCHED}
  VS_FF_PATCHED = 4;
  {$EXTERNALSYM VS_FF_PRIVATEBUILD}
  VS_FF_PRIVATEBUILD = 8;
  {$EXTERNALSYM VS_FF_INFOINFERRED}
  VS_FF_INFOINFERRED = $10;
  {$EXTERNALSYM VS_FF_SPECIALBUILD}
  VS_FF_SPECIALBUILD = $20;

{ VS_VERSION.dwFileOS }

  {$EXTERNALSYM VOS_UNKNOWN}
  VOS_UNKNOWN = 0;
  {$EXTERNALSYM VOS_DOS}
  VOS_DOS = $10000;
  {$EXTERNALSYM VOS_OS216}
  VOS_OS216 = $20000;
  {$EXTERNALSYM VOS_OS232}
  VOS_OS232 = $30000;
  {$EXTERNALSYM VOS_NT}
  VOS_NT = $40000;

  {$EXTERNALSYM VOS__BASE}
  VOS__BASE = 0;
  {$EXTERNALSYM VOS__WINDOWS16}
  VOS__WINDOWS16 = 1;
  {$EXTERNALSYM VOS__PM16}
  VOS__PM16 = 2;
  {$EXTERNALSYM VOS__PM32}
  VOS__PM32 = 3;
  {$EXTERNALSYM VOS__WINDOWS32}
  VOS__WINDOWS32 = 4;

  {$EXTERNALSYM VOS_DOS_WINDOWS16}
  VOS_DOS_WINDOWS16 = $10001;
  {$EXTERNALSYM VOS_DOS_WINDOWS32}
  VOS_DOS_WINDOWS32 = $10004;
  {$EXTERNALSYM VOS_OS216_PM16}
  VOS_OS216_PM16 = $20002;
  {$EXTERNALSYM VOS_OS232_PM32}
  VOS_OS232_PM32 = $30003;
  {$EXTERNALSYM VOS_NT_WINDOWS32}
  VOS_NT_WINDOWS32 = $40004;

{ VS_VERSION.dwFileType }

  {$EXTERNALSYM VFT_UNKNOWN}
  VFT_UNKNOWN = 0;
  {$EXTERNALSYM VFT_APP}
  VFT_APP = 1;
  {$EXTERNALSYM VFT_DLL}
  VFT_DLL = 2;
  {$EXTERNALSYM VFT_DRV}
  VFT_DRV = 3;
  {$EXTERNALSYM VFT_FONT}
  VFT_FONT = 4;
  {$EXTERNALSYM VFT_VXD}
  VFT_VXD = 5;
  {$EXTERNALSYM VFT_STATIC_LIB}
  VFT_STATIC_LIB = 7;

{ VS_VERSION.dwFileSubtype for VFT_WINDOWS_DRV }

  {$EXTERNALSYM VFT2_UNKNOWN}
  VFT2_UNKNOWN = 0;
  {$EXTERNALSYM VFT2_DRV_PRINTER}
  VFT2_DRV_PRINTER = 1;
  {$EXTERNALSYM VFT2_DRV_KEYBOARD}
  VFT2_DRV_KEYBOARD = 2;
  {$EXTERNALSYM VFT2_DRV_LANGUAGE}
  VFT2_DRV_LANGUAGE = 3;
  {$EXTERNALSYM VFT2_DRV_DISPLAY}
  VFT2_DRV_DISPLAY = 4;
  {$EXTERNALSYM VFT2_DRV_MOUSE}
  VFT2_DRV_MOUSE = 5;
  {$EXTERNALSYM VFT2_DRV_NETWORK}
  VFT2_DRV_NETWORK = 6;
  {$EXTERNALSYM VFT2_DRV_SYSTEM}
  VFT2_DRV_SYSTEM = 7;
  {$EXTERNALSYM VFT2_DRV_INSTALLABLE}
  VFT2_DRV_INSTALLABLE = 8;
  {$EXTERNALSYM VFT2_DRV_SOUND}
  VFT2_DRV_SOUND = 9;
  {$EXTERNALSYM VFT2_DRV_COMM}
  VFT2_DRV_COMM = 10;

{ VS_VERSION.dwFileSubtype for VFT_WINDOWS_FONT }

  {$EXTERNALSYM VFT2_FONT_RASTER}
  VFT2_FONT_RASTER = 1;
  {$EXTERNALSYM VFT2_FONT_VECTOR}
  VFT2_FONT_VECTOR = 2;
  {$EXTERNALSYM VFT2_FONT_TRUETYPE}
  VFT2_FONT_TRUETYPE = 3;

{ VerFindFile() flags }

  {$EXTERNALSYM VFFF_ISSHAREDFILE}
  VFFF_ISSHAREDFILE = 1;

  {$EXTERNALSYM VFF_CURNEDEST}
  VFF_CURNEDEST = 1;
  {$EXTERNALSYM VFF_FILEINUSE}
  VFF_FILEINUSE = 2;
  {$EXTERNALSYM VFF_BUFFTOOSMALL}
  VFF_BUFFTOOSMALL = 4;

{ VerInstallFile() flags }

  {$EXTERNALSYM VIFF_FORCEINSTALL}
  VIFF_FORCEINSTALL = 1;
  {$EXTERNALSYM VIFF_DONTDELETEOLD}
  VIFF_DONTDELETEOLD = 2;

  {$EXTERNALSYM VIF_TEMPFILE}
  VIF_TEMPFILE = 1;
  {$EXTERNALSYM VIF_MISMATCH}
  VIF_MISMATCH = 2;
  {$EXTERNALSYM VIF_SRCOLD}
  VIF_SRCOLD = 4;

  {$EXTERNALSYM VIF_DIFFLANG}
  VIF_DIFFLANG = 8;
  {$EXTERNALSYM VIF_DIFFCODEPG}
  VIF_DIFFCODEPG = $10;
  {$EXTERNALSYM VIF_DIFFTYPE}
  VIF_DIFFTYPE = $20;

  {$EXTERNALSYM VIF_WRITEPROT}
  VIF_WRITEPROT = $40;
  {$EXTERNALSYM VIF_FILEINUSE}
  VIF_FILEINUSE = $80;
  {$EXTERNALSYM VIF_OUTOFSPACE}
  VIF_OUTOFSPACE = $100;
  {$EXTERNALSYM VIF_ACCESSVIOLATION}
  VIF_ACCESSVIOLATION = $200;
  {$EXTERNALSYM VIF_SHARINGVIOLATION}
  VIF_SHARINGVIOLATION = $400;
  {$EXTERNALSYM VIF_CANNOTCREATE}
  VIF_CANNOTCREATE = $800;
  {$EXTERNALSYM VIF_CANNOTDELETE}
  VIF_CANNOTDELETE = $1000;
  {$EXTERNALSYM VIF_CANNOTRENAME}
  VIF_CANNOTRENAME = $2000;
  {$EXTERNALSYM VIF_CANNOTDELETECUR}
  VIF_CANNOTDELETECUR = $4000;
  {$EXTERNALSYM VIF_OUTOFMEMORY}
  VIF_OUTOFMEMORY = $8000;

  {$EXTERNALSYM VIF_CANNOTREADSRC}
  VIF_CANNOTREADSRC = $10000;
  {$EXTERNALSYM VIF_CANNOTREADDST}
  VIF_CANNOTREADDST = $20000;

  {$EXTERNALSYM VIF_BUFFTOOSMALL}
  VIF_BUFFTOOSMALL = $40000;

type
  PVSFixedFileInfo = ^TVSFixedFileInfo;
  {$EXTERNALSYM tagVS_FIXEDFILEINFO}
  tagVS_FIXEDFILEINFO = packed record
    dwSignature: DWORD;        { e.g. $feef04bd }
    dwStrucVersion: DWORD;     { e.g. $00000042 = "0.42" }
    dwFileVersionMS: DWORD;    { e.g. $00030075 = "3.75" }
    dwFileVersionLS: DWORD;    { e.g. $00000031 = "0.31" }
    dwProductVersionMS: DWORD; { e.g. $00030010 = "3.10" }
    dwProductVersionLS: DWORD; { e.g. $00000031 = "0.31" }
    dwFileFlagsMask: DWORD;    { = $3F for version "0.42" }
    dwFileFlags: DWORD;        { e.g. VFF_DEBUG | VFF_PRERELEASE }
    dwFileOS: DWORD;           { e.g. VOS_DOS_WINDOWS16 }
    dwFileType: DWORD;         { e.g. VFT_DRIVER }
    dwFileSubtype: DWORD;      { e.g. VFT2_DRV_KEYBOARD }
    dwFileDateMS: DWORD;       { e.g. 0 }
    dwFileDateLS: DWORD;       { e.g. 0 }
  end;
  TVSFixedFileInfo = tagVS_FIXEDFILEINFO;
  {$EXTERNALSYM VS_FIXEDFILEINFO}
  VS_FIXEDFILEINFO = tagVS_FIXEDFILEINFO;

{$EXTERNALSYM VerFindFile}
function VerFindFile(uFlags: DWORD; szFileName, szWinDir, szAppDir, szCurDir: PChar;
  var lpuCurDirLen: UINT; szDestDir: PChar; var lpuDestDirLen: UINT): DWORD; stdcall;
{$EXTERNALSYM VerFindFileA}
function VerFindFileA(uFlags: DWORD; szFileName, szWinDir, szAppDir, szCurDir: PAnsiChar;
  var lpuCurDirLen: UINT; szDestDir: PAnsiChar; var lpuDestDirLen: UINT): DWORD; stdcall;
{$EXTERNALSYM VerFindFileW}
function VerFindFileW(uFlags: DWORD; szFileName, szWinDir, szAppDir, szCurDir: PWideChar;
  var lpuCurDirLen: UINT; szDestDir: PWideChar; var lpuDestDirLen: UINT): DWORD; stdcall;
{$EXTERNALSYM VerInstallFile}
function VerInstallFile(uFlags: DWORD;
  szSrcFileName, szDestFileName, szSrcDir, szDestDir, szCurDir, szTmpFile: PChar;
  var lpuTmpFileLen: UINT): DWORD; stdcall;
{$EXTERNALSYM VerInstallFileA}
function VerInstallFileA(uFlags: DWORD;
  szSrcFileName, szDestFileName, szSrcDir, szDestDir, szCurDir, szTmpFile: PAnsiChar;
  var lpuTmpFileLen: UINT): DWORD; stdcall;
{$EXTERNALSYM VerInstallFileW}
function VerInstallFileW(uFlags: DWORD;
  szSrcFileName, szDestFileName, szSrcDir, szDestDir, szCurDir, szTmpFile: PWideChar;
  var lpuTmpFileLen: UINT): DWORD; stdcall;

{$EXTERNALSYM GetFileVersionInfoSize}
function GetFileVersionInfoSize(lptstrFilename: PChar; var lpdwHandle: DWORD): DWORD; stdcall;
{$EXTERNALSYM GetFileVersionInfoSizeA}
function GetFileVersionInfoSizeA(lptstrFilename: PAnsiChar; var lpdwHandle: DWORD): DWORD; stdcall;
{$EXTERNALSYM GetFileVersionInfoSizeW}
function GetFileVersionInfoSizeW(lptstrFilename: PWideChar; var lpdwHandle: DWORD): DWORD; stdcall;
{$EXTERNALSYM GetFileVersionInfo}
function GetFileVersionInfo(lptstrFilename: PChar; dwHandle, dwLen: DWORD;
  lpData: Pointer): BOOL; stdcall;
{$EXTERNALSYM GetFileVersionInfoA}
function GetFileVersionInfoA(lptstrFilename: PAnsiChar; dwHandle, dwLen: DWORD;
  lpData: Pointer): BOOL; stdcall;
{$EXTERNALSYM GetFileVersionInfoW}
function GetFileVersionInfoW(lptstrFilename: PWideChar; dwHandle, dwLen: DWORD;
  lpData: Pointer): BOOL; stdcall;
{$EXTERNALSYM VerLanguageName}
function VerLanguageName(wLang: DWORD; szLang: PChar; nSize: DWORD): DWORD; stdcall;
{$EXTERNALSYM VerLanguageNameA}
function VerLanguageNameA(wLang: DWORD; szLang: PAnsiChar; nSize: DWORD): DWORD; stdcall;
{$EXTERNALSYM VerLanguageNameW}
function VerLanguageNameW(wLang: DWORD; szLang: PWideChar; nSize: DWORD): DWORD; stdcall;
{$EXTERNALSYM VerQueryValue}
function VerQueryValue(pBlock: Pointer; lpSubBlock: PChar;
  var lplpBuffer: Pointer; var puLen: UINT): BOOL; stdcall;
{$EXTERNALSYM VerQueryValueA}
function VerQueryValueA(pBlock: Pointer; lpSubBlock: PAnsiChar;
  var lplpBuffer: Pointer; var puLen: UINT): BOOL; stdcall;
{$EXTERNALSYM VerQueryValueW}
function VerQueryValueW(pBlock: Pointer; lpSubBlock: PWideChar;
  var lplpBuffer: Pointer; var puLen: UINT): BOOL; stdcall;


{ Translated from WINREG.H }

{ This module contains the function prototypes and constant, type and
   structure definitions for the Windows 32-Bit Registry API. }

type
  {$EXTERNALSYM REGSAM}
  REGSAM = ACCESS_MASK;  { Requested Key access mask type. }








  {$EXTERNALSYM HKEY}
  HKEY = type LongWord;

  PHKEY = ^HKEY;

const
{ Reserved Key Handles. }

  {$EXTERNALSYM HKEY_CLASSES_ROOT}
  HKEY_CLASSES_ROOT     = DWORD($80000000);
  {$EXTERNALSYM HKEY_CURRENT_USER}
  HKEY_CURRENT_USER     = DWORD($80000001);
  {$EXTERNALSYM HKEY_LOCAL_MACHINE}
  HKEY_LOCAL_MACHINE    = DWORD($80000002);
  {$EXTERNALSYM HKEY_USERS}
  HKEY_USERS            = DWORD($80000003);
  {$EXTERNALSYM HKEY_PERFORMANCE_DATA}
  HKEY_PERFORMANCE_DATA = DWORD($80000004);
  {$EXTERNALSYM HKEY_CURRENT_CONFIG}
  HKEY_CURRENT_CONFIG   = DWORD($80000005);
  {$EXTERNALSYM HKEY_DYN_DATA}
  HKEY_DYN_DATA         = DWORD($80000006);


  {$EXTERNALSYM PROVIDER_KEEPS_VALUE_LENGTH}
  PROVIDER_KEEPS_VALUE_LENGTH = 1;

type
  PValContext = ^TValContext;
  {$EXTERNALSYM val_context}
  val_context = packed record
    valuelen: Integer;       { the total length of this value }
    value_context: Pointer;  { provider's context }
    val_buff_ptr: Pointer;   { where in the ouput buffer the value is }
  end;
  TValContext = val_context;


type
{ Provider supplied value/context.}
  PPValueA = ^TPValueA;
  PPValueW = ^TPValueW;
  PPValue = PPValueA;
  {$EXTERNALSYM pvalueA}
  pvalueA = packed record
    pv_valuename: PAnsiChar;           { The value name pointer }
    pv_valuelen: BOOL;
    pv_value_context: Pointer;
    pv_type: DWORD;
  end;
  {$EXTERNALSYM pvalueW}
  pvalueW = packed record
    pv_valuename: PWideChar;           { The value name pointer }
    pv_valuelen: BOOL;
    pv_value_context: Pointer;
    pv_type: DWORD;
  end;
  {$EXTERNALSYM pvalue}
  pvalue = pvalueA;
  TPValueA = pvalueA;
  TPValueW = pvalueW;
  TPValue = TPValueA;






  TFNQueryHandler = TFarProc;

  PFNQueryHandler = ^TFNQueryHandler;

  PProviderInfo = ^TProviderInfo;
  {$EXTERNALSYM provider_info}
  provider_info = packed record
    pi_R0_1val: PFNQueryHandler;
    pi_R0_allvals: PFNQueryHandler;
    pi_R3_1val: PFNQueryHandler;
    pi_R3_allvals: PFNQueryHandler;
    pi_flags: DWORD;              { capability flags (none defined yet). }
    pi_key_context: Pointer;
  end;
  TProviderInfo = provider_info;
  {$EXTERNALSYM REG_PROVIDER}
  REG_PROVIDER = provider_info;
  TRegProvider = TProviderInfo;
  PProvider = PProviderInfo;

  PValueEntA = ^TValueEntA;
  PValueEntW = ^TValueEntW;
  PValueEnt = PValueEntA;
  {$EXTERNALSYM value_entA}
  value_entA = packed record
    ve_valuename: PAnsiChar;
    ve_valuelen: DWORD;
    ve_valueptr: DWORD;
    ve_type: DWORD;
  end;
  {$EXTERNALSYM value_entW}
  value_entW = packed record
    ve_valuename: PWideChar;
    ve_valuelen: DWORD;
    ve_valueptr: DWORD;
    ve_type: DWORD;
  end;
  {$EXTERNALSYM value_ent}
  value_ent = value_entA;
  TValueEntA = value_entA;
  TValueEntW = value_entW;
  TValueEnt = TValueEntA;
  {$EXTERNALSYM VALENTA}
  VALENTA = value_entA;
  {$EXTERNALSYM VALENTW}
  VALENTW = value_entW;
  {$EXTERNALSYM VALENT}
  VALENT = VALENTA;
  TValEnt = TValueEnt;
  PValEnt = PValueEnt;


{ Default values for parameters that do not exist in the Win 3.1
  compatible APIs. }

{$EXTERNALSYM RegOverridePredefKey}
function RegOverridePredefKey (hKey, hNewHKey: HKEY): Longint; stdcall;

{$EXTERNALSYM RegOpenUserClassesRoot}
function RegOpenUserClassesRoot(hToken: THandle; dwOptions: DWORD;
  samDesired: REGSAM; out phkResult: HKEY): Longint; stdcall;

{$EXTERNALSYM RegOpenCurrentUser}
function RegOpenCurrentUser(samDesired: REGSAM; out phkResult: HKEY): Longint; stdcall;

{$EXTERNALSYM RegDisablePredefinedCache}
function RegDisablePredefinedCache: Longint; stdcall;

{$EXTERNALSYM RegCloseKey}
function RegCloseKey(hKey: HKEY): Longint; stdcall;

{$EXTERNALSYM RegConnectRegistry}
function RegConnectRegistry(lpMachineName: PChar; hKey: HKEY;
  var phkResult: HKEY): Longint; stdcall;
{$EXTERNALSYM RegConnectRegistryA}
function RegConnectRegistryA(lpMachineName: PAnsiChar; hKey: HKEY;
  var phkResult: HKEY): Longint; stdcall;
{$EXTERNALSYM RegConnectRegistryW}
function RegConnectRegistryW(lpMachineName: PWideChar; hKey: HKEY;
  var phkResult: HKEY): Longint; stdcall;
{$EXTERNALSYM RegCreateKey}
function RegCreateKey(hKey: HKEY; lpSubKey: PChar;
  var phkResult: HKEY): Longint; stdcall;
{$EXTERNALSYM RegCreateKeyA}
function RegCreateKeyA(hKey: HKEY; lpSubKey: PAnsiChar;
  var phkResult: HKEY): Longint; stdcall;
{$EXTERNALSYM RegCreateKeyW}
function RegCreateKeyW(hKey: HKEY; lpSubKey: PWideChar;
  var phkResult: HKEY): Longint; stdcall;
{$EXTERNALSYM RegCreateKeyEx}
function RegCreateKeyEx(hKey: HKEY; lpSubKey: PChar;
  Reserved: DWORD; lpClass: PChar; dwOptions: DWORD; samDesired: REGSAM;
  lpSecurityAttributes: PSecurityAttributes; var phkResult: HKEY;
  lpdwDisposition: PDWORD): Longint; stdcall;
{$EXTERNALSYM RegCreateKeyExA}
function RegCreateKeyExA(hKey: HKEY; lpSubKey: PAnsiChar;
  Reserved: DWORD; lpClass: PAnsiChar; dwOptions: DWORD; samDesired: REGSAM;
  lpSecurityAttributes: PSecurityAttributes; var phkResult: HKEY;
  lpdwDisposition: PDWORD): Longint; stdcall;
{$EXTERNALSYM RegCreateKeyExW}
function RegCreateKeyExW(hKey: HKEY; lpSubKey: PWideChar;
  Reserved: DWORD; lpClass: PWideChar; dwOptions: DWORD; samDesired: REGSAM;
  lpSecurityAttributes: PSecurityAttributes; var phkResult: HKEY;
  lpdwDisposition: PDWORD): Longint; stdcall;
{$EXTERNALSYM RegDeleteKey}
function RegDeleteKey(hKey: HKEY; lpSubKey: PChar): Longint; stdcall;
{$EXTERNALSYM RegDeleteKeyA}
function RegDeleteKeyA(hKey: HKEY; lpSubKey: PAnsiChar): Longint; stdcall;
{$EXTERNALSYM RegDeleteKeyW}
function RegDeleteKeyW(hKey: HKEY; lpSubKey: PWideChar): Longint; stdcall;
{$EXTERNALSYM RegDeleteValue}
function RegDeleteValue(hKey: HKEY; lpValueName: PChar): Longint; stdcall;
{$EXTERNALSYM RegDeleteValueA}
function RegDeleteValueA(hKey: HKEY; lpValueName: PAnsiChar): Longint; stdcall;
{$EXTERNALSYM RegDeleteValueW}
function RegDeleteValueW(hKey: HKEY; lpValueName: PWideChar): Longint; stdcall;
{$EXTERNALSYM RegEnumKey}
function RegEnumKey(hKey: HKEY; dwIndex: DWORD; lpName: PChar; cbName: DWORD): Longint; stdcall;
{$EXTERNALSYM RegEnumKeyA}
function RegEnumKeyA(hKey: HKEY; dwIndex: DWORD; lpName: PAnsiChar; cbName: DWORD): Longint; stdcall;
{$EXTERNALSYM RegEnumKeyW}
function RegEnumKeyW(hKey: HKEY; dwIndex: DWORD; lpName: PWideChar; cbName: DWORD): Longint; stdcall;
{$EXTERNALSYM RegEnumKeyEx}
function RegEnumKeyEx(hKey: HKEY; dwIndex: DWORD; lpName: PChar;
  var lpcbName: DWORD; lpReserved: Pointer; lpClass: PChar;
  lpcbClass: PDWORD; lpftLastWriteTime: PFileTime): Longint; stdcall;
{$EXTERNALSYM RegEnumKeyExA}
function RegEnumKeyExA(hKey: HKEY; dwIndex: DWORD; lpName: PAnsiChar;
  var lpcbName: DWORD; lpReserved: Pointer; lpClass: PAnsiChar;
  lpcbClass: PDWORD; lpftLastWriteTime: PFileTime): Longint; stdcall;
{$EXTERNALSYM RegEnumKeyExW}
function RegEnumKeyExW(hKey: HKEY; dwIndex: DWORD; lpName: PWideChar;
  var lpcbName: DWORD; lpReserved: Pointer; lpClass: PWideChar;
  lpcbClass: PDWORD; lpftLastWriteTime: PFileTime): Longint; stdcall;
{$EXTERNALSYM RegEnumValue}
function RegEnumValue(hKey: HKEY; dwIndex: DWORD; lpValueName: PChar;
  var lpcbValueName: DWORD; lpReserved: Pointer; lpType: PDWORD;
  lpData: PByte; lpcbData: PDWORD): Longint; stdcall;
{$EXTERNALSYM RegEnumValueA}
function RegEnumValueA(hKey: HKEY; dwIndex: DWORD; lpValueName: PAnsiChar;
  var lpcbValueName: DWORD; lpReserved: Pointer; lpType: PDWORD;
  lpData: PByte; lpcbData: PDWORD): Longint; stdcall;
{$EXTERNALSYM RegEnumValueW}
function RegEnumValueW(hKey: HKEY; dwIndex: DWORD; lpValueName: PWideChar;
  var lpcbValueName: DWORD; lpReserved: Pointer; lpType: PDWORD;
  lpData: PByte; lpcbData: PDWORD): Longint; stdcall;
{$EXTERNALSYM RegFlushKey}
function RegFlushKey(hKey: HKEY): Longint; stdcall;
{$EXTERNALSYM RegGetKeySecurity}
function RegGetKeySecurity(hKey: HKEY; SecurityInformation: SECURITY_INFORMATION;
  pSecurityDescriptor: PSecurityDescriptor; var lpcbSecurityDescriptor: DWORD): Longint; stdcall;
{$EXTERNALSYM RegLoadKey}
function RegLoadKey(hKey: HKEY; lpSubKey, lpFile: PChar): Longint; stdcall;
{$EXTERNALSYM RegLoadKeyA}
function RegLoadKeyA(hKey: HKEY; lpSubKey, lpFile: PAnsiChar): Longint; stdcall;
{$EXTERNALSYM RegLoadKeyW}
function RegLoadKeyW(hKey: HKEY; lpSubKey, lpFile: PWideChar): Longint; stdcall;
{$EXTERNALSYM RegNotifyChangeKeyValue}
function RegNotifyChangeKeyValue(hKey: HKEY; bWatchSubtree: BOOL;
  dwNotifyFilter: DWORD; hEvent: THandle; fAsynchronus: BOOL): Longint; stdcall;
{$EXTERNALSYM RegOpenKey}
function RegOpenKey(hKey: HKEY; lpSubKey: PChar; var phkResult: HKEY): Longint; stdcall;
{$EXTERNALSYM RegOpenKeyA}
function RegOpenKeyA(hKey: HKEY; lpSubKey: PAnsiChar; var phkResult: HKEY): Longint; stdcall;
{$EXTERNALSYM RegOpenKeyW}
function RegOpenKeyW(hKey: HKEY; lpSubKey: PWideChar; var phkResult: HKEY): Longint; stdcall;
{$EXTERNALSYM RegOpenKeyEx}
function RegOpenKeyEx(hKey: HKEY; lpSubKey: PChar;
  ulOptions: DWORD; samDesired: REGSAM; var phkResult: HKEY): Longint; stdcall;
{$EXTERNALSYM RegOpenKeyExA}
function RegOpenKeyExA(hKey: HKEY; lpSubKey: PAnsiChar;
  ulOptions: DWORD; samDesired: REGSAM; var phkResult: HKEY): Longint; stdcall;
{$EXTERNALSYM RegOpenKeyExW}
function RegOpenKeyExW(hKey: HKEY; lpSubKey: PWideChar;
  ulOptions: DWORD; samDesired: REGSAM; var phkResult: HKEY): Longint; stdcall;
{$EXTERNALSYM RegQueryInfoKey}
function RegQueryInfoKey(hKey: HKEY; lpClass: PChar;
  lpcbClass: PDWORD; lpReserved: Pointer;
  lpcSubKeys, lpcbMaxSubKeyLen, lpcbMaxClassLen, lpcValues,
  lpcbMaxValueNameLen, lpcbMaxValueLen, lpcbSecurityDescriptor: PDWORD;
  lpftLastWriteTime: PFileTime): Longint; stdcall;
{$EXTERNALSYM RegQueryInfoKeyA}
function RegQueryInfoKeyA(hKey: HKEY; lpClass: PAnsiChar;
  lpcbClass: PDWORD; lpReserved: Pointer;
  lpcSubKeys, lpcbMaxSubKeyLen, lpcbMaxClassLen, lpcValues,
  lpcbMaxValueNameLen, lpcbMaxValueLen, lpcbSecurityDescriptor: PDWORD;
  lpftLastWriteTime: PFileTime): Longint; stdcall;
{$EXTERNALSYM RegQueryInfoKeyW}
function RegQueryInfoKeyW(hKey: HKEY; lpClass: PWideChar;
  lpcbClass: PDWORD; lpReserved: Pointer;
  lpcSubKeys, lpcbMaxSubKeyLen, lpcbMaxClassLen, lpcValues,
  lpcbMaxValueNameLen, lpcbMaxValueLen, lpcbSecurityDescriptor: PDWORD;
  lpftLastWriteTime: PFileTime): Longint; stdcall;
{$EXTERNALSYM RegQueryValue}
function RegQueryValue(hKey: HKEY; lpSubKey: PChar;
  lpValue: PChar; var lpcbValue: Longint): Longint; stdcall;
{$EXTERNALSYM RegQueryValueA}
function RegQueryValueA(hKey: HKEY; lpSubKey: PAnsiChar;
  lpValue: PAnsiChar; var lpcbValue: Longint): Longint; stdcall;
{$EXTERNALSYM RegQueryValueW}
function RegQueryValueW(hKey: HKEY; lpSubKey: PWideChar;
  lpValue: PWideChar; var lpcbValue: Longint): Longint; stdcall;
{$EXTERNALSYM RegQueryMultipleValues}
function RegQueryMultipleValues(hKey: HKEY; var ValList;
  NumVals: DWORD; lpValueBuf: PChar; var ldwTotsize: DWORD): Longint; stdcall;
{$EXTERNALSYM RegQueryMultipleValuesA}
function RegQueryMultipleValuesA(hKey: HKEY; var ValList;
  NumVals: DWORD; lpValueBuf: PAnsiChar; var ldwTotsize: DWORD): Longint; stdcall;
{$EXTERNALSYM RegQueryMultipleValuesW}
function RegQueryMultipleValuesW(hKey: HKEY; var ValList;
  NumVals: DWORD; lpValueBuf: PWideChar; var ldwTotsize: DWORD): Longint; stdcall;
{$EXTERNALSYM RegQueryValueEx}
function RegQueryValueEx(hKey: HKEY; lpValueName: PChar;
  lpReserved: Pointer; lpType: PDWORD; lpData: PByte; lpcbData: PDWORD): Longint; stdcall;
{$EXTERNALSYM RegQueryValueExA}
function RegQueryValueExA(hKey: HKEY; lpValueName: PAnsiChar;
  lpReserved: Pointer; lpType: PDWORD; lpData: PByte; lpcbData: PDWORD): Longint; stdcall;
{$EXTERNALSYM RegQueryValueExW}
function RegQueryValueExW(hKey: HKEY; lpValueName: PWideChar;
  lpReserved: Pointer; lpType: PDWORD; lpData: PByte; lpcbData: PDWORD): Longint; stdcall;
{$EXTERNALSYM RegReplaceKey}
function RegReplaceKey(hKey: HKEY; lpSubKey: PChar;
   lpNewFile: PChar; lpOldFile: PChar): Longint; stdcall;
{$EXTERNALSYM RegReplaceKeyA}
function RegReplaceKeyA(hKey: HKEY; lpSubKey: PAnsiChar;
   lpNewFile: PAnsiChar; lpOldFile: PAnsiChar): Longint; stdcall;
{$EXTERNALSYM RegReplaceKeyW}
function RegReplaceKeyW(hKey: HKEY; lpSubKey: PWideChar;
   lpNewFile: PWideChar; lpOldFile: PWideChar): Longint; stdcall;
{$EXTERNALSYM RegRestoreKey}
function RegRestoreKey(hKey: HKEY; lpFile: PChar; dwFlags: DWORD): Longint; stdcall;
{$EXTERNALSYM RegRestoreKeyA}
function RegRestoreKeyA(hKey: HKEY; lpFile: PAnsiChar; dwFlags: DWORD): Longint; stdcall;
{$EXTERNALSYM RegRestoreKeyW}
function RegRestoreKeyW(hKey: HKEY; lpFile: PWideChar; dwFlags: DWORD): Longint; stdcall;
{$EXTERNALSYM RegSaveKey}
function RegSaveKey(hKey: HKEY; lpFile: PChar;
  lpSecurityAttributes: PSecurityAttributes): Longint; stdcall;
{$EXTERNALSYM RegSaveKeyA}
function RegSaveKeyA(hKey: HKEY; lpFile: PAnsiChar;
  lpSecurityAttributes: PSecurityAttributes): Longint; stdcall;
{$EXTERNALSYM RegSaveKeyW}
function RegSaveKeyW(hKey: HKEY; lpFile: PWideChar;
  lpSecurityAttributes: PSecurityAttributes): Longint; stdcall;
{$EXTERNALSYM RegSetKeySecurity}
function RegSetKeySecurity(hKey: HKEY; SecurityInformation: SECURITY_INFORMATION;
  pSecurityDescriptor: PSECURITY_DESCRIPTOR): Longint; stdcall;
{$EXTERNALSYM RegSetValue}
function RegSetValue(hKey: HKEY; lpSubKey: PChar;
  dwType: DWORD; lpData: PChar; cbData: DWORD): Longint; stdcall;
{$EXTERNALSYM RegSetValueA}
function RegSetValueA(hKey: HKEY; lpSubKey: PAnsiChar;
  dwType: DWORD; lpData: PAnsiChar; cbData: DWORD): Longint; stdcall;
{$EXTERNALSYM RegSetValueW}
function RegSetValueW(hKey: HKEY; lpSubKey: PWideChar;
  dwType: DWORD; lpData: PWideChar; cbData: DWORD): Longint; stdcall;
{$EXTERNALSYM RegSetValueEx}
function RegSetValueEx(hKey: HKEY; lpValueName: PChar;
  Reserved: DWORD; dwType: DWORD; lpData: Pointer; cbData: DWORD): Longint; stdcall;
{$EXTERNALSYM RegSetValueExA}
function RegSetValueExA(hKey: HKEY; lpValueName: PAnsiChar;
  Reserved: DWORD; dwType: DWORD; lpData: Pointer; cbData: DWORD): Longint; stdcall;
{$EXTERNALSYM RegSetValueExW}
function RegSetValueExW(hKey: HKEY; lpValueName: PWideChar;
  Reserved: DWORD; dwType: DWORD; lpData: Pointer; cbData: DWORD): Longint; stdcall;
{$EXTERNALSYM RegUnLoadKey}
function RegUnLoadKey(hKey: HKEY; lpSubKey: PChar): Longint; stdcall;
{$EXTERNALSYM RegUnLoadKeyA}
function RegUnLoadKeyA(hKey: HKEY; lpSubKey: PAnsiChar): Longint; stdcall;
{$EXTERNALSYM RegUnLoadKeyW}
function RegUnLoadKeyW(hKey: HKEY; lpSubKey: PWideChar): Longint; stdcall;

{ Remoteable System Shutdown APIs }

{$EXTERNALSYM InitiateSystemShutdown}
function InitiateSystemShutdown(lpMachineName, lpMessage: PChar;
  dwTimeout: DWORD; bForceAppsClosed, bRebootAfterShutdown: BOOL): BOOL; stdcall;
{$EXTERNALSYM InitiateSystemShutdownA}
function InitiateSystemShutdownA(lpMachineName, lpMessage: PAnsiChar;
  dwTimeout: DWORD; bForceAppsClosed, bRebootAfterShutdown: BOOL): BOOL; stdcall;
{$EXTERNALSYM InitiateSystemShutdownW}
function InitiateSystemShutdownW(lpMachineName, lpMessage: PWideChar;
  dwTimeout: DWORD; bForceAppsClosed, bRebootAfterShutdown: BOOL): BOOL; stdcall;
{$EXTERNALSYM AbortSystemShutdown}
function AbortSystemShutdown(lpMachineName: PChar): BOOL; stdcall;
{$EXTERNALSYM AbortSystemShutdownA}
function AbortSystemShutdownA(lpMachineName: PAnsiChar): BOOL; stdcall;
{$EXTERNALSYM AbortSystemShutdownW}
function AbortSystemShutdownW(lpMachineName: PWideChar): BOOL; stdcall;


{ Translated from WINNETWK.H }

const
{ Network types }

  {$EXTERNALSYM WNNC_NET_MSNET}
  WNNC_NET_MSNET              = $00010000;
  {$EXTERNALSYM WNNC_NET_LANMAN}
  WNNC_NET_LANMAN             = $00020000;
  {$EXTERNALSYM WNNC_NET_NETWARE}
  WNNC_NET_NETWARE            = $00030000;
  {$EXTERNALSYM WNNC_NET_VINES}
  WNNC_NET_VINES              = $00040000;
  {$EXTERNALSYM WNNC_NET_10NET}
  WNNC_NET_10NET              = $00050000;
  {$EXTERNALSYM WNNC_NET_LOCUS}
  WNNC_NET_LOCUS              = $00060000;
  {$EXTERNALSYM WNNC_NET_SUN_PC_NFS}
  WNNC_NET_SUN_PC_NFS         = $00070000;
  {$EXTERNALSYM WNNC_NET_LANSTEP}
  WNNC_NET_LANSTEP            = $00080000;
  {$EXTERNALSYM WNNC_NET_9TILES}
  WNNC_NET_9TILES             = $00090000;
  {$EXTERNALSYM WNNC_NET_LANTASTIC}
  WNNC_NET_LANTASTIC          = $000A0000;
  {$EXTERNALSYM WNNC_NET_AS400}
  WNNC_NET_AS400              = $000B0000;
  {$EXTERNALSYM WNNC_NET_FTP_NFS}
  WNNC_NET_FTP_NFS            = $000C0000;
  {$EXTERNALSYM WNNC_NET_PATHWORKS}
  WNNC_NET_PATHWORKS          = $000D0000;
  {$EXTERNALSYM WNNC_NET_LIFENET}
  WNNC_NET_LIFENET            = $000E0000;
  {$EXTERNALSYM WNNC_NET_POWERLAN}
  WNNC_NET_POWERLAN           = $000F0000;
  {$EXTERNALSYM WNNC_NET_BWNFS}
  WNNC_NET_BWNFS              = $00100000;
  {$EXTERNALSYM WNNC_NET_COGENT}
  WNNC_NET_COGENT             = $00110000;
  {$EXTERNALSYM WNNC_NET_FARALLON}
  WNNC_NET_FARALLON           = $00120000;
  {$EXTERNALSYM WNNC_NET_APPLETALK}
  WNNC_NET_APPLETALK          = $00130000;
  {$EXTERNALSYM WNNC_NET_INTERGRAPH}
  WNNC_NET_INTERGRAPH         = $00140000;
  {$EXTERNALSYM WNNC_NET_SYMFONET}
  WNNC_NET_SYMFONET           = $00150000;
  {$EXTERNALSYM WNNC_NET_CLEARCASE}
  WNNC_NET_CLEARCASE          = $00160000;

{ Network Resources. }

  {$EXTERNALSYM RESOURCE_CONNECTED}
  RESOURCE_CONNECTED = 1;
  {$EXTERNALSYM RESOURCE_GLOBALNET}
  RESOURCE_GLOBALNET = 2;
  {$EXTERNALSYM RESOURCE_REMEMBERED}
  RESOURCE_REMEMBERED = 3;
  {$EXTERNALSYM RESOURCE_RECENT}
  RESOURCE_RECENT = 4;
  {$EXTERNALSYM RESOURCE_CONTEXT}
  RESOURCE_CONTEXT = 5;

  {$EXTERNALSYM RESOURCETYPE_ANY}
  RESOURCETYPE_ANY = 0;
  {$EXTERNALSYM RESOURCETYPE_DISK}
  RESOURCETYPE_DISK = 1;
  {$EXTERNALSYM RESOURCETYPE_PRINT}
  RESOURCETYPE_PRINT = 2;
  {$EXTERNALSYM RESOURCETYPE_RESERVED}
  RESOURCETYPE_RESERVED = 8;
  {$EXTERNALSYM RESOURCETYPE_UNKNOWN}
  RESOURCETYPE_UNKNOWN = DWORD($FFFFFFFF);

  {$EXTERNALSYM RESOURCEUSAGE_CONNECTABLE}
  RESOURCEUSAGE_CONNECTABLE = 1;
  {$EXTERNALSYM RESOURCEUSAGE_CONTAINER}
  RESOURCEUSAGE_CONTAINER = 2;
  {$EXTERNALSYM RESOURCEUSAGE_NOLOCALDEVICE}
  RESOURCEUSAGE_NOLOCALDEVICE = 4;
  {$EXTERNALSYM RESOURCEUSAGE_SIBLING}
  RESOURCEUSAGE_SIBLING = 8;

  {$EXTERNALSYM RESOURCEUSAGE_ATTACHED}
  RESOURCEUSAGE_ATTACHED = $00000010;
  {$EXTERNALSYM RESOURCEUSAGE_ALL}
  RESOURCEUSAGE_ALL = (RESOURCEUSAGE_CONNECTABLE or RESOURCEUSAGE_CONTAINER or RESOURCEUSAGE_ATTACHED);
  {$EXTERNALSYM RESOURCEUSAGE_RESERVED}
  RESOURCEUSAGE_RESERVED = DWORD($80000000);

  {$EXTERNALSYM RESOURCEDISPLAYTYPE_GENERIC}
  RESOURCEDISPLAYTYPE_GENERIC            = $00000000;
  {$EXTERNALSYM RESOURCEDISPLAYTYPE_DOMAIN}
  RESOURCEDISPLAYTYPE_DOMAIN             = $00000001;
  {$EXTERNALSYM RESOURCEDISPLAYTYPE_SERVER}
  RESOURCEDISPLAYTYPE_SERVER             = $00000002;
  {$EXTERNALSYM RESOURCEDISPLAYTYPE_SHARE}
  RESOURCEDISPLAYTYPE_SHARE              = $00000003;
  {$EXTERNALSYM RESOURCEDISPLAYTYPE_FILE}
  RESOURCEDISPLAYTYPE_FILE               = $00000004;
  {$EXTERNALSYM RESOURCEDISPLAYTYPE_GROUP}
  RESOURCEDISPLAYTYPE_GROUP              = $00000005;
  {$EXTERNALSYM RESOURCEDISPLAYTYPE_NETWORK}
  RESOURCEDISPLAYTYPE_NETWORK            = $00000006;
  {$EXTERNALSYM RESOURCEDISPLAYTYPE_ROOT}
  RESOURCEDISPLAYTYPE_ROOT               = $00000007;
  {$EXTERNALSYM RESOURCEDISPLAYTYPE_SHAREADMIN}
  RESOURCEDISPLAYTYPE_SHAREADMIN         = $00000008;
  {$EXTERNALSYM RESOURCEDISPLAYTYPE_DIRECTORY}
  RESOURCEDISPLAYTYPE_DIRECTORY          = $00000009;
  {$EXTERNALSYM RESOURCEDISPLAYTYPE_TREE}
  RESOURCEDISPLAYTYPE_TREE               = $0000000A;
  {$EXTERNALSYM RESOURCEDISPLAYTYPE_NDSCONTAINER}
  RESOURCEDISPLAYTYPE_NDSCONTAINER       = $0000000B;

type
  PNetResourceA = ^TNetResourceA;
  PNetResourceW = ^TNetResourceW;
  PNetResource = PNetResourceA;
  {$EXTERNALSYM _NETRESOURCEA}
  _NETRESOURCEA = packed record
    dwScope: DWORD;
    dwType: DWORD;
    dwDisplayType: DWORD;
    dwUsage: DWORD;
    lpLocalName: PAnsiChar;
    lpRemoteName: PAnsiChar;
    lpComment: PAnsiChar;
    lpProvider: PAnsiChar;
  end;
  {$EXTERNALSYM _NETRESOURCEW}
  _NETRESOURCEW = packed record
    dwScope: DWORD;
    dwType: DWORD;
    dwDisplayType: DWORD;
    dwUsage: DWORD;
    lpLocalName: PWideChar;
    lpRemoteName: PWideChar;
    lpComment: PWideChar;
    lpProvider: PWideChar;
  end;
  {$EXTERNALSYM _NETRESOURCE}
  _NETRESOURCE = _NETRESOURCEA;
  TNetResourceA = _NETRESOURCEA;
  TNetResourceW = _NETRESOURCEW;
  TNetResource = TNetResourceA;
  {$EXTERNALSYM NETRESOURCEA}
  NETRESOURCEA = _NETRESOURCEA;
  {$EXTERNALSYM NETRESOURCEW}
  NETRESOURCEW = _NETRESOURCEW;
  {$EXTERNALSYM NETRESOURCE}
  NETRESOURCE = NETRESOURCEA;

const
{ Network Connections. }

  {$EXTERNALSYM NETPROPERTY_PERSISTENT}
  NETPROPERTY_PERSISTENT = 1;

  {$EXTERNALSYM CONNECT_UPDATE_PROFILE}
  CONNECT_UPDATE_PROFILE          = $00000001;
  {$EXTERNALSYM CONNECT_UPDATE_RECENT}
  CONNECT_UPDATE_RECENT           = $00000002;
  {$EXTERNALSYM CONNECT_TEMPORARY}
  CONNECT_TEMPORARY               = $00000004;
  {$EXTERNALSYM CONNECT_INTERACTIVE}
  CONNECT_INTERACTIVE             = $00000008;
  {$EXTERNALSYM CONNECT_PROMPT}
  CONNECT_PROMPT                  = $00000010;
  {$EXTERNALSYM CONNECT_NEED_DRIVE}
  CONNECT_NEED_DRIVE              = $00000020;
  {$EXTERNALSYM CONNECT_REFCOUNT}
  CONNECT_REFCOUNT                = $00000040;
  {$EXTERNALSYM CONNECT_REDIRECT}
  CONNECT_REDIRECT                = $00000080;
  {$EXTERNALSYM CONNECT_LOCALDRIVE}
  CONNECT_LOCALDRIVE              = $00000100;
  {$EXTERNALSYM CONNECT_CURRENT_MEDIA}
  CONNECT_CURRENT_MEDIA           = $00000200;
  {$EXTERNALSYM CONNECT_DEFERRED}
  CONNECT_DEFERRED                = $00000400;
  {$EXTERNALSYM CONNECT_RESERVED}
  CONNECT_RESERVED                = DWORD($FF000000);

{$EXTERNALSYM WNetAddConnection}
function WNetAddConnection(lpRemoteName, lpPassword, lpLocalName: PChar): DWORD; stdcall;
{$EXTERNALSYM WNetAddConnectionA}
function WNetAddConnectionA(lpRemoteName, lpPassword, lpLocalName: PAnsiChar): DWORD; stdcall;
{$EXTERNALSYM WNetAddConnectionW}
function WNetAddConnectionW(lpRemoteName, lpPassword, lpLocalName: PWideChar): DWORD; stdcall;
{$EXTERNALSYM WNetAddConnection2}
function WNetAddConnection2(var lpNetResource: TNetResource;
  lpPassword, lpUserName: PChar; dwFlags: DWORD): DWORD; stdcall;
{$EXTERNALSYM WNetAddConnection2A}
function WNetAddConnection2A(var lpNetResource: TNetResourceA;
  lpPassword, lpUserName: PAnsiChar; dwFlags: DWORD): DWORD; stdcall;
{$EXTERNALSYM WNetAddConnection2W}
function WNetAddConnection2W(var lpNetResource: TNetResourceW;
  lpPassword, lpUserName: PWideChar; dwFlags: DWORD): DWORD; stdcall;
{$EXTERNALSYM WNetAddConnection3}
function WNetAddConnection3(hwndOwner: HWND; var lpNetResource: TNetResource;
  lpPassword, lpUserName: PChar; dwFlags: DWORD): DWORD; stdcall;
{$EXTERNALSYM WNetAddConnection3A}
function WNetAddConnection3A(hwndOwner: HWND; var lpNetResource: TNetResourceA;
  lpPassword, lpUserName: PAnsiChar; dwFlags: DWORD): DWORD; stdcall;
{$EXTERNALSYM WNetAddConnection3W}
function WNetAddConnection3W(hwndOwner: HWND; var lpNetResource: TNetResourceW;
  lpPassword, lpUserName: PWideChar; dwFlags: DWORD): DWORD; stdcall;
{$EXTERNALSYM WNetCancelConnection}
function WNetCancelConnection(lpName: PChar; fForce: BOOL): DWORD; stdcall;
{$EXTERNALSYM WNetCancelConnectionA}
function WNetCancelConnectionA(lpName: PAnsiChar; fForce: BOOL): DWORD; stdcall;
{$EXTERNALSYM WNetCancelConnectionW}
function WNetCancelConnectionW(lpName: PWideChar; fForce: BOOL): DWORD; stdcall;
{$EXTERNALSYM WNetCancelConnection2}
function WNetCancelConnection2(lpName: PChar; dwFlags: DWORD; fForce: BOOL): DWORD; stdcall;
{$EXTERNALSYM WNetCancelConnection2A}
function WNetCancelConnection2A(lpName: PAnsiChar; dwFlags: DWORD; fForce: BOOL): DWORD; stdcall;
{$EXTERNALSYM WNetCancelConnection2W}
function WNetCancelConnection2W(lpName: PWideChar; dwFlags: DWORD; fForce: BOOL): DWORD; stdcall;
{$EXTERNALSYM WNetGetConnection}
function WNetGetConnection(lpLocalName: PChar;
  lpRemoteName: PChar; var lpnLength: DWORD): DWORD; stdcall;
{$EXTERNALSYM WNetGetConnectionA}
function WNetGetConnectionA(lpLocalName: PAnsiChar;
  lpRemoteName: PAnsiChar; var lpnLength: DWORD): DWORD; stdcall;
{$EXTERNALSYM WNetGetConnectionW}
function WNetGetConnectionW(lpLocalName: PWideChar;
  lpRemoteName: PWideChar; var lpnLength: DWORD): DWORD; stdcall;
{$EXTERNALSYM WNetUseConnection}
function WNetUseConnection(hwndOwner: HWND;
  var lpNetResource: TNetResource; lpUserID: PChar;
  lpPassword: PChar; dwFlags: DWORD; lpAccessName: PChar;
  var lpBufferSize: DWORD; var lpResult: DWORD): DWORD; stdcall;
{$EXTERNALSYM WNetUseConnectionA}
function WNetUseConnectionA(hwndOwner: HWND;
  var lpNetResource: TNetResourceA; lpUserID: PAnsiChar;
  lpPassword: PAnsiChar; dwFlags: DWORD; lpAccessName: PAnsiChar;
  var lpBufferSize: DWORD; var lpResult: DWORD): DWORD; stdcall;
{$EXTERNALSYM WNetUseConnectionW}
function WNetUseConnectionW(hwndOwner: HWND;
  var lpNetResource: TNetResourceW; lpUserID: PWideChar;
  lpPassword: PWideChar; dwFlags: DWORD; lpAccessName: PWideChar;
  var lpBufferSize: DWORD; var lpResult: DWORD): DWORD; stdcall;
{$EXTERNALSYM WNetSetConnection}
function WNetSetConnection(lpName: PChar; dwProperties: DWORD; pvValues: Pointer): DWORD; stdcall;
{$EXTERNALSYM WNetSetConnectionA}
function WNetSetConnectionA(lpName: PAnsiChar; dwProperties: DWORD; pvValues: Pointer): DWORD; stdcall;
{$EXTERNALSYM WNetSetConnectionW}
function WNetSetConnectionW(lpName: PWideChar; dwProperties: DWORD; pvValues: Pointer): DWORD; stdcall;

{ Network Connection Dialogs. }

{$EXTERNALSYM WNetConnectionDialog}
function WNetConnectionDialog(hwnd: HWND; dwType: DWORD): DWORD; stdcall;
{$EXTERNALSYM WNetDisconnectDialog}
function WNetDisconnectDialog(hwnd: HWND; dwType: DWORD): DWORD; stdcall;

type
  PConnectDlgStruct = ^TConnectDlgStruct;
  {$EXTERNALSYM _CONNECTDLGSTRUCTA}
  _CONNECTDLGSTRUCTA = packed record
    cbStructure: DWORD;          { size of this structure in bytes }
    hwndOwner: HWND;             { owner window for the dialog }
    lpConnRes: PNetResource;     { Requested Resource info    }
    dwFlags: DWORD;              { flags (see below) }
    dwDevNum: DWORD;             { number of devices connected to }
  end;
  TConnectDlgStruct = _CONNECTDLGSTRUCTA;
  {$EXTERNALSYM CONNECTDLGSTRUCT}
  CONNECTDLGSTRUCT = _CONNECTDLGSTRUCTA;

const
  {$EXTERNALSYM CONNDLG_RO_PATH}
  CONNDLG_RO_PATH = 1;    { Resource path should be read-only     }
  {$EXTERNALSYM CONNDLG_CONN_POINT}
  CONNDLG_CONN_POINT = 2; { Netware -style movable connection point enabled  }
  {$EXTERNALSYM CONNDLG_USE_MRU}
  CONNDLG_USE_MRU = 4;    { Use MRU combobox   }
  {$EXTERNALSYM CONNDLG_HIDE_BOX}
  CONNDLG_HIDE_BOX = 8;   { Hide persistent connect checkbox   }

  { NOTE:  Set at most ONE of the below flags.  If neither flag is set,
           then the persistence is set to whatever the user chose during
           a previous connection }

  {$EXTERNALSYM CONNDLG_PERSIST}
  CONNDLG_PERSIST = $10;       { Force persistent connection  }
  {$EXTERNALSYM CONNDLG_NOT_PERSIST}
  CONNDLG_NOT_PERSIST = $20;   { Force connection NOT persistent  }

{$EXTERNALSYM WNetConnectionDialog1}
function WNetConnectionDialog1(var lpConnDlgStruct: TConnectDlgStruct): DWORD; stdcall;
{$EXTERNALSYM WNetConnectionDialog1A}
function WNetConnectionDialog1A(var lpConnDlgStruct: TConnectDlgStruct): DWORD; stdcall;
{$EXTERNALSYM WNetConnectionDialog1W}
function WNetConnectionDialog1W(var lpConnDlgStruct: TConnectDlgStruct): DWORD; stdcall;

type
  PDiscDlgStructA = ^TDiscDlgStructA;
  PDiscDlgStructW = ^TDiscDlgStructW;
  PDiscDlgStruct = PDiscDlgStructA;
  {$EXTERNALSYM _DISCDLGSTRUCTA}
  _DISCDLGSTRUCTA = packed record
    cbStructure: DWORD;       { size of this structure in bytes }
    hwndOwner: HWND;          { owner window for the dialog }
    lpLocalName: PAnsiChar;       { local device name }
    lpRemoteName: PAnsiChar;      { network resource name }
    dwFlags: DWORD;
  end;
  {$EXTERNALSYM _DISCDLGSTRUCTW}
  _DISCDLGSTRUCTW = packed record
    cbStructure: DWORD;       { size of this structure in bytes }
    hwndOwner: HWND;          { owner window for the dialog }
    lpLocalName: PWideChar;       { local device name }
    lpRemoteName: PWideChar;      { network resource name }
    dwFlags: DWORD;
  end;
  {$EXTERNALSYM _DISCDLGSTRUCT}
  _DISCDLGSTRUCT = _DISCDLGSTRUCTA;
  TDiscDlgStructA = _DISCDLGSTRUCTA;
  TDiscDlgStructW = _DISCDLGSTRUCTW;
  TDiscDlgStruct = TDiscDlgStructA;
  {$EXTERNALSYM DISCDLGSTRUCTA}
  DISCDLGSTRUCTA = _DISCDLGSTRUCTA;
  {$EXTERNALSYM DISCDLGSTRUCTW}
  DISCDLGSTRUCTW = _DISCDLGSTRUCTW;
  {$EXTERNALSYM DISCDLGSTRUCT}
  DISCDLGSTRUCT = DISCDLGSTRUCTA;

const
  {$EXTERNALSYM DISC_UPDATE_PROFILE}
  DISC_UPDATE_PROFILE = 1;
  {$EXTERNALSYM DISC_NO_FORCE}
  DISC_NO_FORCE = $40;

{$EXTERNALSYM WNetDisconnectDialog1}
function WNetDisconnectDialog1(var lpConnDlgStruct: TDiscDlgStruct): DWORD; stdcall;
{$EXTERNALSYM WNetDisconnectDialog1A}
function WNetDisconnectDialog1A(var lpConnDlgStruct: TDiscDlgStructA): DWORD; stdcall;
{$EXTERNALSYM WNetDisconnectDialog1W}
function WNetDisconnectDialog1W(var lpConnDlgStruct: TDiscDlgStructW): DWORD; stdcall;

{ Network Browsing. }

{$EXTERNALSYM WNetOpenEnum}
function WNetOpenEnum(dwScope, dwType, dwUsage: DWORD;
  lpNetResource: PNetResource; var lphEnum: THandle): DWORD; stdcall;
{$EXTERNALSYM WNetOpenEnumA}
function WNetOpenEnumA(dwScope, dwType, dwUsage: DWORD;
  lpNetResource: PNetResourceA; var lphEnum: THandle): DWORD; stdcall;
{$EXTERNALSYM WNetOpenEnumW}
function WNetOpenEnumW(dwScope, dwType, dwUsage: DWORD;
  lpNetResource: PNetResourceW; var lphEnum: THandle): DWORD; stdcall;
{$EXTERNALSYM WNetEnumResource}
function WNetEnumResource(hEnum: THandle; var lpcCount: DWORD;
  lpBuffer: Pointer; var lpBufferSize: DWORD): DWORD; stdcall;
{$EXTERNALSYM WNetEnumResourceA}
function WNetEnumResourceA(hEnum: THandle; var lpcCount: DWORD;
  lpBuffer: Pointer; var lpBufferSize: DWORD): DWORD; stdcall;
{$EXTERNALSYM WNetEnumResourceW}
function WNetEnumResourceW(hEnum: THandle; var lpcCount: DWORD;
  lpBuffer: Pointer; var lpBufferSize: DWORD): DWORD; stdcall;
{$EXTERNALSYM WNetCloseEnum}
function WNetCloseEnum(hEnum: THandle): DWORD; stdcall;
{$EXTERNALSYM WNetGetResourceParent}
function WNetGetResourceParent(lpNetResource: PNetResource;
  lpBuffer: Pointer; var cbBuffer: DWORD): DWORD; stdcall;
{$EXTERNALSYM WNetGetResourceParentA}
function WNetGetResourceParentA(lpNetResource: PNetResourceA;
  lpBuffer: Pointer; var cbBuffer: DWORD): DWORD; stdcall;
{$EXTERNALSYM WNetGetResourceParentW}
function WNetGetResourceParentW(lpNetResource: PNetResourceW;
  lpBuffer: Pointer; var cbBuffer: DWORD): DWORD; stdcall;

const
{ Universal Naming. }

  {$EXTERNALSYM UNIVERSAL_NAME_INFO_LEVEL}
  UNIVERSAL_NAME_INFO_LEVEL = 1;
  {$EXTERNALSYM REMOTE_NAME_INFO_LEVEL}
  REMOTE_NAME_INFO_LEVEL = 2;

type
  PUniversalNameInfoA = ^TUniversalNameInfoA;
  PUniversalNameInfoW = ^TUniversalNameInfoW;
  PUniversalNameInfo = PUniversalNameInfoA;
  {$EXTERNALSYM _UNIVERSAL_NAME_INFOA}
  _UNIVERSAL_NAME_INFOA = packed record
    lpUniversalName: PAnsiChar;
  end;
  {$EXTERNALSYM _UNIVERSAL_NAME_INFOW}
  _UNIVERSAL_NAME_INFOW = packed record
    lpUniversalName: PWideChar;
  end;
  {$EXTERNALSYM _UNIVERSAL_NAME_INFO}
  _UNIVERSAL_NAME_INFO = _UNIVERSAL_NAME_INFOA;
  TUniversalNameInfoA = _UNIVERSAL_NAME_INFOA;
  TUniversalNameInfoW = _UNIVERSAL_NAME_INFOW;
  TUniversalNameInfo = TUniversalNameInfoA;
  {$EXTERNALSYM UNIVERSAL_NAME_INFOA}
  UNIVERSAL_NAME_INFOA = _UNIVERSAL_NAME_INFOA;
  {$EXTERNALSYM UNIVERSAL_NAME_INFOW}
  UNIVERSAL_NAME_INFOW = _UNIVERSAL_NAME_INFOW;
  {$EXTERNALSYM UNIVERSAL_NAME_INFO}
  UNIVERSAL_NAME_INFO = UNIVERSAL_NAME_INFOA;

  PRemoteNameInfoA = ^TRemoteNameInfoA;
  PRemoteNameInfoW = ^TRemoteNameInfoW;
  PRemoteNameInfo = PRemoteNameInfoA;
  {$EXTERNALSYM _REMOTE_NAME_INFOA}
  _REMOTE_NAME_INFOA = packed record
    lpUniversalName: PAnsiChar;
    lpConnectionName: PAnsiChar;
    lpRemainingPath: PAnsiChar;
  end;
  {$EXTERNALSYM _REMOTE_NAME_INFOW}
  _REMOTE_NAME_INFOW = packed record
    lpUniversalName: PWideChar;
    lpConnectionName: PWideChar;
    lpRemainingPath: PWideChar;
  end;
  {$EXTERNALSYM _REMOTE_NAME_INFO}
  _REMOTE_NAME_INFO = _REMOTE_NAME_INFOA;
  TRemoteNameInfoA = _REMOTE_NAME_INFOA;
  TRemoteNameInfoW = _REMOTE_NAME_INFOW;
  TRemoteNameInfo = TRemoteNameInfoA;
  {$EXTERNALSYM REMOTE_NAME_INFOA}
  REMOTE_NAME_INFOA = _REMOTE_NAME_INFOA;
  {$EXTERNALSYM REMOTE_NAME_INFOW}
  REMOTE_NAME_INFOW = _REMOTE_NAME_INFOW;
  {$EXTERNALSYM REMOTE_NAME_INFO}
  REMOTE_NAME_INFO = REMOTE_NAME_INFOA;

{$EXTERNALSYM WNetGetUniversalName}
function WNetGetUniversalName(lpLocalPath: PChar; dwInfoLevel: DWORD;
  lpBuffer: Pointer; var lpBufferSize: DWORD): DWORD; stdcall;
{$EXTERNALSYM WNetGetUniversalNameA}
function WNetGetUniversalNameA(lpLocalPath: PAnsiChar; dwInfoLevel: DWORD;
  lpBuffer: Pointer; var lpBufferSize: DWORD): DWORD; stdcall;
{$EXTERNALSYM WNetGetUniversalNameW}
function WNetGetUniversalNameW(lpLocalPath: PWideChar; dwInfoLevel: DWORD;
  lpBuffer: Pointer; var lpBufferSize: DWORD): DWORD; stdcall;

{ Authentication and Logon/Logoff }

{$EXTERNALSYM WNetGetUser}
function WNetGetUser(lpName: PChar; lpUserName: PChar; var lpnLength: DWORD): DWORD; stdcall;
{$EXTERNALSYM WNetGetUserA}
function WNetGetUserA(lpName: PAnsiChar; lpUserName: PAnsiChar; var lpnLength: DWORD): DWORD; stdcall;
{$EXTERNALSYM WNetGetUserW}
function WNetGetUserW(lpName: PWideChar; lpUserName: PWideChar; var lpnLength: DWORD): DWORD; stdcall;

const
  {$EXTERNALSYM WNFMT_MULTILINE}
  WNFMT_MULTILINE = 1;
  {$EXTERNALSYM WNFMT_ABBREVIATED}
  WNFMT_ABBREVIATED = 2;
  {$EXTERNALSYM WNFMT_INENUM}
  WNFMT_INENUM = $10;
  {$EXTERNALSYM WNFMT_CONNECTION}
  WNFMT_CONNECTION = $20;

{$EXTERNALSYM WNetGetProviderName}
function WNetGetProviderName(dwNetType: DWORD; lpProviderName: PChar;
  var lpBufferSize: DWORD): DWORD; stdcall;
{$EXTERNALSYM WNetGetProviderNameA}
function WNetGetProviderNameA(dwNetType: DWORD; lpProviderName: PAnsiChar;
  var lpBufferSize: DWORD): DWORD; stdcall;
{$EXTERNALSYM WNetGetProviderNameW}
function WNetGetProviderNameW(dwNetType: DWORD; lpProviderName: PWideChar;
  var lpBufferSize: DWORD): DWORD; stdcall;

type
  PNetInfoStruct = ^TNetInfoStruct;
  {$EXTERNALSYM _NETINFOSTRUCT}
  _NETINFOSTRUCT = record
    cbStructure: DWORD;
    dwProviderVersion: DWORD;
    dwStatus: DWORD;
    dwCharacteristics: DWORD;
    dwHandle: DWORD;
    wNetType: Word;
    dwPrinters: DWORD;
    dwDrives: DWORD;
  end;
  TNetInfoStruct = _NETINFOSTRUCT;
  {$EXTERNALSYM NETINFOSTRUCT}
  NETINFOSTRUCT = _NETINFOSTRUCT;

const
  {$EXTERNALSYM NETINFO_DLL16}
  NETINFO_DLL16 = 1;      { Provider running as 16 bit Winnet Driver  }
  {$EXTERNALSYM NETINFO_DISKRED}
  NETINFO_DISKRED = 4;    { Provider requires disk redirections to connect  }
  {$EXTERNALSYM NETINFO_PRINTERRED}
  NETINFO_PRINTERRED = 8; { Provider requires printer redirections to connect  }

{$EXTERNALSYM WNetGetNetworkInformation}
function WNetGetNetworkInformation(lpProvider: PChar;
  var lpNetInfoStruct: TNetInfoStruct): DWORD; stdcall;
{$EXTERNALSYM WNetGetNetworkI